/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.launcher;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContainerInitializer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tomcat.InstanceManager;
import org.apache.tomcat.SimpleInstanceManager;
import org.eclipse.jetty.annotations.ServletContainerInitializersStarter;
import org.eclipse.jetty.apache.jsp.JettyJasperInitializer;
import org.eclipse.jetty.jsp.JettyJspServlet;
import org.eclipse.jetty.plus.annotation.ContainerInitializer;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SessionManager;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.security.Password;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.webapp.WebAppContext;
import org.openspaces.launcher.JettyUtils;
import org.openspaces.launcher.WebLauncher;
import org.openspaces.launcher.WebLauncherConfig;

public class JettyLauncher
extends WebLauncher {
    private static final Log logger = LogFactory.getLog(JettyLauncher.class);
    private Server server;

    public void launch(WebLauncherConfig config) throws Exception {
        this.server = new Server();
        System.setProperty("org.apache.jasper.compiler.disablejsr199", "true");
        ServerConnector connector = JettyUtils.createConnector(this.server, config.getHostAddress(), config.getPort(), this.toSslContextFactory(config));
        connector.setReuseAddress(false);
        this.server.addConnector((Connector)connector);
        WebAppContext webAppContext = new WebAppContext();
        webAppContext.setContextPath("/");
        webAppContext.setWar(config.getWarFilePath());
        File tempDir = new File(config.getTempDirPath());
        boolean createdDirs = tempDir.mkdirs();
        if (logger.isDebugEnabled()) {
            boolean canRead = tempDir.canRead();
            boolean canWrite = tempDir.canWrite();
            boolean canExecute = tempDir.canExecute();
            logger.debug((Object)("Temp dir:" + tempDir.getName() + ", canRead=" + canRead + ", canWrite=" + canWrite + ", canExecute=" + canExecute + ", exists=" + tempDir.exists() + ", createdDirs=" + createdDirs + ", path=" + config.getTempDirPath()));
        }
        webAppContext.setTempDirectory(tempDir);
        webAppContext.setCopyWebDir(false);
        webAppContext.setParentLoaderPriority(true);
        webAppContext.setAttribute("javax.servlet.context.tempdir", (Object)this.getScratchDir());
        webAppContext.setAttribute("org.eclipse.jetty.server.webapp.ContainerIncludeJarPattern", (Object)".*/[^/]*servlet-api-[^/]*\\.jar$|.*/javax.servlet.jsp.jstl-.*\\.jar$|.*/.*taglibs*\\.jar$");
        webAppContext.setAttribute("org.eclipse.jetty.containerInitializers", this.jspInitializers());
        webAppContext.setAttribute(InstanceManager.class.getName(), (Object)new SimpleInstanceManager());
        webAppContext.addBean((Object)new ServletContainerInitializersStarter(webAppContext), true);
        webAppContext.addServlet(this.jspServletHolder(), "*.jsp");
        String sessionManager = System.getProperty("org.openspaces.launcher.jetty.session.manager");
        if (sessionManager != null) {
            try {
                Class<?> sessionManagerClass = Class.forName(sessionManager);
                SessionManager sessionManagerImpl = (SessionManager)sessionManagerClass.newInstance();
                webAppContext.getSessionHandler().setSessionManager(sessionManagerImpl);
            }
            catch (Throwable t) {
                System.out.println("Session Manager [" + sessionManager + "] was not set cause following exception:" + t.toString());
                t.printStackTrace();
            }
        } else {
            System.out.println("Session Manager was not provided");
        }
        this.server.setHandler((Handler)webAppContext);
        this.server.start();
    }

    public void close() throws IOException {
        if (this.server != null) {
            try {
                this.server.stop();
            }
            catch (Exception e) {
                throw new IOException("Failed to stop jetty server", e);
            }
        }
    }

    private ServletHolder jspServletHolder() {
        ServletHolder holderJsp = new ServletHolder("jsp", JettyJspServlet.class);
        holderJsp.setInitOrder(0);
        holderJsp.setInitParameter("logVerbosityLevel", "DEBUG");
        holderJsp.setInitParameter("fork", "false");
        holderJsp.setInitParameter("xpoweredBy", "false");
        holderJsp.setInitParameter("compilerTargetVM", "1.7");
        holderJsp.setInitParameter("compilerSourceVM", "1.7");
        holderJsp.setInitParameter("keepgenerated", "true");
        return holderJsp;
    }

    private List<ContainerInitializer> jspInitializers() {
        JettyJasperInitializer sci = new JettyJasperInitializer();
        ContainerInitializer initializer = new ContainerInitializer((ServletContainerInitializer)sci, null);
        ArrayList<ContainerInitializer> initializers = new ArrayList<ContainerInitializer>();
        initializers.add(initializer);
        return initializers;
    }

    private File getScratchDir() throws IOException {
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        File scratchDir = new File(tempDir.toString(), "embedded-jetty-jsp");
        if (!scratchDir.exists() && !scratchDir.mkdirs()) {
            throw new IOException("Unable to create scratch directory: " + scratchDir);
        }
        return scratchDir;
    }

    private SslContextFactory toSslContextFactory(WebLauncherConfig config) {
        if (!config.isSslEnabled()) {
            return null;
        }
        SslContextFactory sslContextFactory = new SslContextFactory();
        sslContextFactory.setKeyStorePath(config.getSslKeyStorePath());
        sslContextFactory.setTrustStorePath(config.getSslTrustStorePath());
        sslContextFactory.setKeyStorePassword(Password.obfuscate((String)config.getSslKeyStorePassword()));
        sslContextFactory.setKeyManagerPassword(Password.obfuscate((String)config.getSslKeyManagerPassword()));
        sslContextFactory.setTrustStorePassword(Password.obfuscate((String)config.getSslTrustStorePassword()));
        return sslContextFactory;
    }
}

