/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.launcher;

import com.gigaspaces.internal.version.PlatformVersion;
import com.gigaspaces.lrmi.nio.filters.SelfSignedCertificate;
import com.gigaspaces.start.SystemInfo;
import com.gigaspaces.start.manager.XapManagerConfig;
import java.io.Closeable;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.MovedContextHandler;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.webapp.WebInfConfiguration;
import org.openspaces.core.util.FileUtils;
import org.openspaces.launcher.JettyUtils;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public class JettyManagerRestLauncher
implements Closeable {
    private static final Logger logger = Logger.getLogger("com.gigaspaces.manager");
    private AbstractXmlApplicationContext application;
    private Server server;
    private static final File workLocation = new File(SystemInfo.singleton().locations().restJettyTempFiles());

    public static void main(String[] args) {
        final JettyManagerRestLauncher starter = new JettyManagerRestLauncher();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                starter.close();
            }
        });
    }

    public JettyManagerRestLauncher() {
        try {
            String customJettyPath;
            XapManagerConfig config = SystemInfo.singleton().getManagerClusterInfo().getCurrServer();
            if (config == null) {
                logger.severe("Cannot start server  - this host is not part of the xap managers configuration");
                System.exit(1);
            }
            if ((customJettyPath = System.getProperty("com.gs.manager.rest.jetty.config")) != null) {
                logger.info("Loading jetty configuration from " + customJettyPath);
                this.application = new FileSystemXmlApplicationContext(customJettyPath);
                this.server = (Server)this.application.getBean(Server.class);
            } else {
                this.server = new Server();
            }
            if (!this.server.isStarted()) {
                if (this.server.getConnectors() == null || this.server.getConnectors().length == 0) {
                    this.initConnectors(this.server, config);
                }
                if (this.server.getHandler() == null) {
                    this.initWebApps(this.server);
                }
                this.clearOldTempWarFiles();
                this.server.start();
            }
            if (logger.isLoggable(Level.INFO)) {
                String connectors = "";
                for (Connector connector : this.server.getConnectors()) {
                    if (!(connector instanceof ServerConnector)) continue;
                    String connectorDesc = JettyUtils.toUrlPrefix((ServerConnector)connector);
                    connectors = connectors.isEmpty() ? connectorDesc : connectors + ", " + connectorDesc;
                }
                logger.info("Started at " + connectors);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.toString(), e);
            System.exit(-1);
        }
    }

    private void clearOldTempWarFiles() {
        String clearRestJettyFiles = System.getProperty("com.gs.clear-rest-jetty-files.enabled", Boolean.FALSE.toString());
        if (Boolean.parseBoolean(clearRestJettyFiles)) {
            File tempDirectory = workLocation;
            File[] filteredFiles = tempDirectory.listFiles();
            logger.info(filteredFiles.length + " rest jetty files are deleting from [" + tempDirectory.getPath() + "]");
            for (File file : filteredFiles) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("File name:" + file.getName() + ", exists:" + file.exists());
                }
                try {
                    FileUtils.deleteFileOrDirectory((File)file);
                    logger.info("Deleted temp file :" + file.getName());
                }
                catch (Throwable t) {
                    if (!logger.isLoggable(Level.WARNING)) continue;
                    logger.log(Level.WARNING, "Failed to delete jetty temp file, " + t.toString());
                }
            }
        }
    }

    private void initConnectors(Server server, XapManagerConfig config) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        String host = config.getHost().equals("localhost") ? config.getHost() : SystemInfo.singleton().network().getHostId();
        int port = Integer.parseInt(config.getAdminRest());
        SslContextFactory sslContextFactory = this.createSslContextFactoryIfNeeded();
        JettyUtils.createConnector(server, host, port, sslContextFactory);
    }

    private void sortDesc(File[] files) {
        Arrays.sort(files, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return -1 * o1.getName().compareTo(o2.getName());
            }
        });
    }

    private void initWebApps(Server server) {
        ContextHandlerCollection handler = new ContextHandlerCollection();
        File webApps = new File(SystemInfo.singleton().locations().getLibPlatform() + "/manager/webapps");
        FilenameFilter warFilesFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".war");
            }
        };
        WebAppContext defaultWebApp = null;
        File[] warFiles = webApps.listFiles(warFilesFilter);
        this.sortDesc(warFiles);
        boolean isWorkLocationExist = workLocation.exists();
        if (!isWorkLocationExist) {
            workLocation.mkdirs();
        }
        for (File file : warFiles) {
            WebAppContext webApp = new WebAppContext();
            webApp.setContextPath("/" + file.getName().replace(".war", ""));
            webApp.setWar(file.getAbsolutePath());
            webApp.setThrowUnavailableOnStartupException(true);
            handler.addHandler((Handler)webApp);
            if (defaultWebApp == null) {
                defaultWebApp = webApp;
            }
            String webAppTmpDir = WebInfConfiguration.getCanonicalNameForWebAppTmpDir((WebAppContext)webApp);
            try {
                File tmpDir = File.createTempFile(webAppTmpDir, ".dir", workLocation);
                webApp.setTempDirectory(tmpDir);
            }
            catch (IOException e) {
                if (!logger.isLoggable(Level.SEVERE)) continue;
                logger.log(Level.SEVERE, e.toString(), e);
            }
        }
        if (defaultWebApp != null) {
            MovedContextHandler redirectHandler = new MovedContextHandler();
            redirectHandler.setContextPath("/");
            redirectHandler.setNewContextURL(defaultWebApp.getContextPath());
            redirectHandler.setPermanent(true);
            redirectHandler.setDiscardPathInfo(true);
            redirectHandler.setDiscardQuery(true);
            handler.addHandler((Handler)redirectHandler);
        }
        server.setHandler((Handler)handler);
    }

    private SslContextFactory createSslContextFactoryIfNeeded() throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        boolean sslEnabled = Boolean.getBoolean("com.gs.manager.rest.ssl.enabled");
        if (!sslEnabled) {
            boolean isSecured = Boolean.getBoolean("com.gs.security.enabled");
            if (isSecured) {
                if (System.getProperty("com.gs.manager.rest.ssl.enabled") == null) {
                    throw new SecurityException("Security is enabled, but SSL is not configured. Please configure SSL using the system property 'com.gs.manager.rest.ssl.enabled'. For more information: '" + PlatformVersion.getProductHelpUrl() + "/admin/xap-manager-rest.html#security'");
                }
                logger.warning("Security is enabled, but SSL was explicitly disabled - passwords will be sent over the network without encryption");
            }
            return null;
        }
        SslContextFactory sslContextFactory = new SslContextFactory();
        String keyStorePath = System.getProperty("com.gs.manager.rest.ssl.keystore-path");
        String password = System.getProperty("com.gs.manager.rest.ssl.keystore-password");
        if (keyStorePath != null && new File(keyStorePath).exists()) {
            sslContextFactory.setKeyStorePath(keyStorePath);
            sslContextFactory.setKeyStorePassword(password);
        } else {
            sslContextFactory.setKeyStore(SelfSignedCertificate.keystore());
            sslContextFactory.setKeyStorePassword("foo");
            logger.info("SSL Keystore was not provided - Self-signed certificate was generated");
        }
        return sslContextFactory;
    }

    @Override
    public void close() {
        if (this.server != null) {
            try {
                this.server.stop();
            }
            catch (Exception e) {
                logger.warning("Failed to stop server: " + e);
            }
        }
        if (this.application != null) {
            this.application.destroy();
        }
    }
}

