/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.launcher;

import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class JettyUtils {
    public static ServerConnector createConnector(Server server, String host, int port, SslContextFactory sslContextFactory) {
        ServerConnector connector;
        ServerConnector serverConnector = connector = sslContextFactory == null ? new ServerConnector(server) : new ServerConnector(server, JettyUtils.toConnectionFactories(sslContextFactory, port));
        if (host != null) {
            connector.setHost(host);
        }
        connector.setPort(port);
        server.addConnector((Connector)connector);
        return connector;
    }

    private static ConnectionFactory[] toConnectionFactories(SslContextFactory sslContextFactory, int port) {
        sslContextFactory.setExcludeCipherSuites(new String[]{"SSL_RSA_WITH_DES_CBC_SHA", "SSL_DHE_RSA_WITH_DES_CBC_SHA", "SSL_DHE_DSS_WITH_DES_CBC_SHA", "SSL_RSA_EXPORT_WITH_RC4_40_MD5", "SSL_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA"});
        HttpConfiguration http_config = new HttpConfiguration();
        http_config.setSecureScheme("https");
        http_config.setSecurePort(port);
        http_config.setOutputBufferSize(32768);
        http_config.setSendServerVersion(true);
        http_config.setSendDateHeader(false);
        HttpConfiguration https_config = new HttpConfiguration(http_config);
        https_config.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
        return new ConnectionFactory[]{new SslConnectionFactory(sslContextFactory, HttpVersion.HTTP_1_1.asString()), new HttpConnectionFactory(https_config)};
    }

    public static boolean isSsl(ServerConnector connector) {
        return connector.getConnectionFactory(SslConnectionFactory.class) != null;
    }

    public static String toUrlPrefix(ServerConnector connector) {
        String protocol = JettyUtils.isSsl(connector) ? "https" : "http";
        return protocol + "://" + connector.getHost() + ":" + connector.getLocalPort();
    }
}

