/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.pu.container.jee.jetty;

import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import java.util.Set;
import javax.servlet.SessionCookieConfig;
import javax.servlet.SessionTrackingMode;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.server.SessionIdManager;
import org.eclipse.jetty.server.SessionManager;
import org.eclipse.jetty.server.session.HashSessionManager;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.component.LifeCycle;

public class GSLazySessionManager
implements LifeCycle,
SessionManager {
    private static final Log logger = LogFactory.getLog(GSLazySessionManager.class);
    private volatile SessionManager defaultSessionManager;
    private volatile boolean replaced;
    private SessionHandler handler;
    private List<EventListener> savedEventListeners;

    public GSLazySessionManager() {
        this((SessionManager)new HashSessionManager());
    }

    public GSLazySessionManager(SessionManager defaultSessionManager) {
        this.defaultSessionManager = defaultSessionManager;
        this.replaced = false;
        this.savedEventListeners = new ArrayList<EventListener>();
    }

    public void replaceDefault(SessionManager sessionManager) throws Exception {
        if (sessionManager == null || this.replaced) {
            return;
        }
        this.replaced = true;
        if (this.defaultSessionManager != null) {
            this.defaultSessionManager.stop();
        }
        this.defaultSessionManager = sessionManager;
        this.defaultSessionManager.setSessionHandler(this.handler);
        for (EventListener savedEventListener : this.savedEventListeners) {
            this.defaultSessionManager.addEventListener(savedEventListener);
        }
        if (!this.defaultSessionManager.isStarted() || this.defaultSessionManager.isRunning()) {
            this.defaultSessionManager.start();
        }
    }

    @ManagedAttribute(value="true if cookies use the http only flag")
    public boolean getHttpOnly() {
        return this.defaultSessionManager.getHttpOnly();
    }

    public void addEventListener(EventListener listener) {
        this.defaultSessionManager.addEventListener(listener);
        if (!this.replaced) {
            this.savedEventListeners.add(listener);
        }
    }

    public HttpSession getHttpSession(String nodeId) {
        return this.defaultSessionManager.getHttpSession(nodeId);
    }

    public SessionCookieConfig getSessionCookieConfig() {
        return this.defaultSessionManager.getSessionCookieConfig();
    }

    public String getSessionIdPathParameterNamePrefix() {
        return this.defaultSessionManager.getSessionIdPathParameterNamePrefix();
    }

    public boolean isValid(HttpSession session) {
        return this.defaultSessionManager.isValid(session);
    }

    public boolean isFailed() {
        return this.defaultSessionManager.isFailed();
    }

    public boolean isStopping() {
        return this.defaultSessionManager.isStopping();
    }

    @Deprecated
    public SessionIdManager getMetaManager() {
        return this.defaultSessionManager.getMetaManager();
    }

    public void addLifeCycleListener(LifeCycle.Listener listener) {
        this.defaultSessionManager.addLifeCycleListener(listener);
    }

    public void setCheckingRemoteSessionIdEncoding(boolean remote) {
        this.defaultSessionManager.setCheckingRemoteSessionIdEncoding(remote);
    }

    public void setSessionIdManager(SessionIdManager metaManager) {
        this.defaultSessionManager.setSessionIdManager(metaManager);
    }

    public HttpSession newHttpSession(HttpServletRequest request) {
        return this.defaultSessionManager.newHttpSession(request);
    }

    public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
        return this.defaultSessionManager.getDefaultSessionTrackingModes();
    }

    public String getClusterId(HttpSession session) {
        return this.defaultSessionManager.getClusterId(session);
    }

    public boolean isStarted() {
        return this.defaultSessionManager.isStarted();
    }

    public void removeLifeCycleListener(LifeCycle.Listener listener) {
        this.defaultSessionManager.removeLifeCycleListener(listener);
    }

    public void stop() throws Exception {
        this.defaultSessionManager.stop();
    }

    @ManagedAttribute(value="check remote session id encoding")
    public boolean isCheckingRemoteSessionIdEncoding() {
        return this.defaultSessionManager.isCheckingRemoteSessionIdEncoding();
    }

    public void renewSessionId(String oldClusterId, String oldNodeId, String newClusterId, String newNodeId) {
        this.defaultSessionManager.renewSessionId(oldClusterId, oldNodeId, newClusterId, newNodeId);
    }

    public String getNodeId(HttpSession session) {
        return this.defaultSessionManager.getNodeId(session);
    }

    public boolean isRunning() {
        return this.defaultSessionManager.isRunning();
    }

    @ManagedAttribute(value="name of use for URL session tracking")
    public String getSessionIdPathParameterName() {
        return this.defaultSessionManager.getSessionIdPathParameterName();
    }

    @ManagedAttribute(value="Session ID Manager")
    public SessionIdManager getSessionIdManager() {
        return this.defaultSessionManager.getSessionIdManager();
    }

    public void setSessionTrackingModes(Set<SessionTrackingMode> sessionTrackingModes) {
        this.defaultSessionManager.setSessionTrackingModes(sessionTrackingModes);
    }

    public void start() throws Exception {
        this.defaultSessionManager.start();
    }

    public void complete(HttpSession session) {
        this.defaultSessionManager.complete(session);
    }

    public boolean isStopped() {
        return this.defaultSessionManager.isStopped();
    }

    public boolean isStarting() {
        return this.defaultSessionManager.isStarting();
    }

    public boolean isUsingURLs() {
        return this.defaultSessionManager.isUsingURLs();
    }

    public void setMaxInactiveInterval(int seconds) {
        this.defaultSessionManager.setMaxInactiveInterval(seconds);
    }

    public void clearEventListeners() {
        this.defaultSessionManager.clearEventListeners();
    }

    public void setSessionIdPathParameterName(String param) {
        this.defaultSessionManager.setSessionIdPathParameterName(param);
    }

    public void removeEventListener(EventListener listener) {
        this.defaultSessionManager.removeEventListener(listener);
        if (!this.replaced) {
            this.savedEventListeners.remove(listener);
        }
    }

    public boolean isUsingCookies() {
        return this.defaultSessionManager.isUsingCookies();
    }

    public HttpCookie getSessionCookie(HttpSession session, String contextPath, boolean requestIsSecure) {
        return this.defaultSessionManager.getSessionCookie(session, contextPath, requestIsSecure);
    }

    public void setSessionHandler(SessionHandler sessionHandler) {
        this.handler = sessionHandler;
        this.defaultSessionManager.setSessionHandler(sessionHandler);
    }

    public HttpCookie access(HttpSession session, boolean secure) {
        return this.defaultSessionManager.access(session, secure);
    }

    @ManagedAttribute(value="defailt maximum time a session may be idle for (in s)")
    public int getMaxInactiveInterval() {
        return this.defaultSessionManager.getMaxInactiveInterval();
    }

    public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
        return this.defaultSessionManager.getEffectiveSessionTrackingModes();
    }
}

