/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.pu.container.jee.jetty;

import com.gigaspaces.internal.utils.Singletons;
import com.j_spaces.kernel.ClassLoaderHelper;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.BindException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jetty.jmx.MBeanContainer;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.NetworkConnector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SessionManager;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.log.JavaUtilLog;
import org.eclipse.jetty.util.resource.FileResource;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.WebAppContext;
import org.jini.rio.boot.CommonClassLoader;
import org.jini.rio.boot.ServiceClassLoader;
import org.jini.rio.boot.SharedServiceData;
import org.openspaces.core.cluster.ClusterInfo;
import org.openspaces.core.properties.BeanLevelProperties;
import org.openspaces.pu.container.CannotCreateContainerException;
import org.openspaces.pu.container.ProcessingUnitContainer;
import org.openspaces.pu.container.jee.JeeProcessingUnitContainerProvider;
import org.openspaces.pu.container.jee.jetty.GSLazySessionManager;
import org.openspaces.pu.container.jee.jetty.JettyProcessingUnitContainer;
import org.openspaces.pu.container.jee.jetty.holder.JettyHolder;
import org.openspaces.pu.container.jee.jetty.support.FileLockFreePortGenerator;
import org.openspaces.pu.container.jee.jetty.support.FreePortGenerator;
import org.openspaces.pu.container.jee.jetty.support.JettyWebAppClassLoader;
import org.openspaces.pu.container.jee.jetty.support.NoOpFreePortGenerator;
import org.openspaces.pu.container.support.BeanLevelPropertiesUtils;
import org.openspaces.pu.container.support.ClusterInfoParser;
import org.openspaces.pu.container.support.ResourceApplicationContext;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.ClassPathResource;

public class JettyJeeProcessingUnitContainerProvider
extends JeeProcessingUnitContainerProvider {
    private static final Log logger;
    public static final String DEFAULT_JETTY_PU = "/META-INF/spring/jetty.pu.xml";
    public static final String INTERNAL_JETTY_PU_PREFIX = "/org/openspaces/pu/container/jee/jetty/jetty.";
    public static final String INSTANCE_PLAIN = "plain";
    public static final String INSTANCE_SHARD = "shared";
    public static final String JETTY_LOCATION_PREFIX_SYSPROP = "com.gs.pu.jee.jetty.pu.locationPrefix";
    public static final String JETTY_INSTANCE_PROP = "jetty.instance";
    public static final String JETTY_JMX_PROP = "jetty.jmx";
    private static final ThreadLocal<ApplicationContext> currentApplicationContext;
    private static final ThreadLocal<ClusterInfo> currentClusterInfo;
    private static final ThreadLocal<BeanLevelProperties> currentBeanLevelProperties;
    private static final String SERVLET_CONTEXT_PORTS_KEY = "servletcontext.ports";

    public static ApplicationContext getCurrentApplicationContext() {
        return currentApplicationContext.get();
    }

    private static void setCurrentApplicationContext(ApplicationContext applicationContext) {
        currentApplicationContext.set(applicationContext);
    }

    public static ClusterInfo getCurrentClusterInfo() {
        return currentClusterInfo.get();
    }

    private static void setCurrentClusterInfo(ClusterInfo clusterInfo) {
        currentClusterInfo.set(clusterInfo);
    }

    public static BeanLevelProperties getCurrentBeanLevelProperties() {
        return currentBeanLevelProperties.get();
    }

    private static void setCurrentBeanLevelProperties(BeanLevelProperties beanLevelProperties) {
        currentBeanLevelProperties.set(beanLevelProperties);
    }

    public String getJeeContainerType() {
        return "jetty";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessingUnitContainer createContainer() throws CannotCreateContainerException {
        JettyHolder jettyHolder;
        this.addConfigLocation(this.getJettyPuResource());
        if (this.getClusterInfo() != null) {
            ClusterInfoParser.guessSchema((ClusterInfo)this.getClusterInfo());
        }
        ResourceApplicationContext applicationContext = this.initApplicationContext();
        ClassLoader origClassLoader = Thread.currentThread().getContextClassLoader();
        LinkedHashMap<String, FreePortGenerator.PortHandle> portHandles = new LinkedHashMap<String, FreePortGenerator.PortHandle>();
        try {
            String[] filesToResolve;
            try {
                ClassLoaderHelper.setContextClassLoader((ClassLoader)this.getJeeClassLoader(), (boolean)true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            applicationContext.refresh();
            jettyHolder = this.initJettyHolder(applicationContext, portHandles);
            this.initJettyJmx(jettyHolder);
            for (String fileToResolve : filesToResolve = new String[]{"WEB-INF/web.xml", "WEB-INF/jetty-web.xml", "WEB-INF/jetty6-web.xml", "WEB-INF/web-jetty.xml"}) {
                try {
                    BeanLevelPropertiesUtils.resolvePlaceholders((BeanLevelProperties)this.getBeanLevelProperties(), (File)new File(this.getDeployPath(), fileToResolve));
                }
                catch (IOException iOException) {
                    throw new CannotCreateContainerException("Failed to resolve properties on " + (String)fileToResolve, (Throwable)iOException);
                }
            }
        }
        finally {
            ClassLoaderHelper.setContextClassLoader((ClassLoader)origClassLoader, (boolean)true);
        }
        try {
            JettyJeeProcessingUnitContainerProvider.setCurrentApplicationContext((ApplicationContext)applicationContext);
            JettyJeeProcessingUnitContainerProvider.setCurrentBeanLevelProperties(this.getBeanLevelProperties());
            JettyJeeProcessingUnitContainerProvider.setCurrentClusterInfo(this.getClusterInfo());
            CommonClassLoader.getInstance().setDisableSmartGetUrl(true);
            WebAppContext webAppContext = this.initWebAppContext(applicationContext);
            ContextHandler.Context servletContext = webAppContext.getServletContext();
            HashMap<String, Integer> servletContextPortsMap = null;
            if (jettyHolder.isSingleInstance() && (servletContextPortsMap = (HashMap<String, Integer>)Singletons.get((String)SERVLET_CONTEXT_PORTS_KEY)) == null) {
                servletContextPortsMap = new HashMap<String, Integer>(portHandles.size() + 1);
            }
            Set entries = portHandles.entrySet();
            for (Map.Entry entry : entries) {
                String string = (String)entry.getKey();
                int port = ((FreePortGenerator.PortHandle)entry.getValue()).getPort();
                String attrName = "jetty." + string + ".port.actual";
                servletContext.setAttribute(attrName, (Object)port);
                if (!jettyHolder.isSingleInstance()) continue;
                servletContextPortsMap.put(attrName, port);
            }
            if (!portHandles.isEmpty()) {
                int port = ((FreePortGenerator.PortHandle)portHandles.values().iterator().next()).getPort();
                String string = "jetty.port.actual";
                servletContext.setAttribute(string, (Object)port);
                if (jettyHolder.isSingleInstance()) {
                    servletContextPortsMap.put(string, port);
                }
            }
            if (jettyHolder.isSingleInstance()) {
                Set servletContextPortsEntries = servletContextPortsMap.entrySet();
                for (Map.Entry entry : servletContextPortsEntries) {
                    servletContext.setAttribute((String)entry.getKey(), entry.getValue());
                }
                Singletons.putIfAbsent((String)SERVLET_CONTEXT_PORTS_KEY, servletContextPortsMap);
            }
            Server container = jettyHolder.getServer();
            Handler[] handlerArray = jettyHolder.getServer().getChildHandlersByClass(ContextHandlerCollection.class);
            if (handlerArray == null || handlerArray.length <= 0) {
                throw new IllegalStateException("No container");
            }
            ContextHandlerCollection contextHandlerCollection = (ContextHandlerCollection)handlerArray[0];
            contextHandlerCollection.addHandler((Handler)webAppContext);
            if (container.isStarted() || container.isStarting()) {
                origClassLoader = Thread.currentThread().getContextClassLoader();
                try {
                    ClassLoaderHelper.setContextClassLoader((ClassLoader)SharedServiceData.getJeeClassLoader((String)"jetty", (String[])new String[0]), (boolean)true);
                    webAppContext.start();
                }
                catch (Exception e) {
                    throw new CannotCreateContainerException("Failed to start web app context", (Throwable)e);
                }
                finally {
                    ClassLoaderHelper.setContextClassLoader((ClassLoader)origClassLoader, (boolean)true);
                }
            }
            if (webAppContext.getUnavailableException() != null) {
                throw new CannotCreateContainerException("Failed to start web app context", webAppContext.getUnavailableException());
            }
            if (webAppContext.isFailed()) {
                throw new CannotCreateContainerException("Failed to start web app context (exception should be logged)");
            }
            JettyProcessingUnitContainer processingUnitContainer = new JettyProcessingUnitContainer((ApplicationContext)applicationContext, webAppContext, contextHandlerCollection, jettyHolder, portHandles.values());
            logger.info((Object)("Deployed web application [" + processingUnitContainer.getJeeDetails().getDescription() + "]"));
            JettyProcessingUnitContainer jettyProcessingUnitContainer = processingUnitContainer;
            return jettyProcessingUnitContainer;
        }
        catch (Exception e) {
            try {
                jettyHolder.stop();
            }
            catch (Exception e1) {
                logger.debug((Object)"Failed to stop jetty after an error occured, ignoring", (Throwable)e);
            }
            if (e instanceof CannotCreateContainerException) {
                throw (CannotCreateContainerException)e;
            }
            throw new CannotCreateContainerException("Failed to start web application", (Throwable)e);
        }
        finally {
            JettyJeeProcessingUnitContainerProvider.setCurrentApplicationContext(null);
            JettyJeeProcessingUnitContainerProvider.setCurrentBeanLevelProperties(null);
            JettyJeeProcessingUnitContainerProvider.setCurrentClusterInfo(null);
            CommonClassLoader.getInstance().setDisableSmartGetUrl(false);
        }
    }

    private org.springframework.core.io.Resource getJettyPuResource() {
        ClassPathResource jettyPuResource = new ClassPathResource(DEFAULT_JETTY_PU);
        if (!jettyPuResource.exists()) {
            String instanceProp = this.getBeanLevelProperties().getContextProperties().getProperty(JETTY_INSTANCE_PROP, INSTANCE_PLAIN);
            String defaultLocation = System.getProperty(JETTY_LOCATION_PREFIX_SYSPROP, INTERNAL_JETTY_PU_PREFIX) + instanceProp + ".pu.xml";
            jettyPuResource = new ClassPathResource(defaultLocation);
            if (!jettyPuResource.exists()) {
                throw new CannotCreateContainerException("Failed to read internal pu file [" + defaultLocation + "] as well as user defined [" + DEFAULT_JETTY_PU + "]");
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Using internal built in jetty pu.xml from [" + defaultLocation + "]"));
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)"Using user specific jetty pu.xml from [/META-INF/spring/jetty.pu.xml]");
        }
        return jettyPuResource;
    }

    private JettyHolder initJettyHolder(ResourceApplicationContext applicationContext, Map<String, FreePortGenerator.PortHandle> portHandles) {
        JettyHolder jettyHolder = (JettyHolder)applicationContext.getBean("jettyHolder");
        int retryPortCount = 20;
        String retryPortCountProperty = System.getProperty("com.gs.retryPortCount");
        if (retryPortCountProperty != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Using system property [com.gs.retryPortCount]:" + retryPortCountProperty));
            }
            try {
                retryPortCount = Integer.parseInt(retryPortCountProperty);
            }
            catch (Exception exception) {}
        } else {
            try {
                retryPortCount = (Integer)applicationContext.getBean("retryPortCount");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        FreePortGenerator freePortGenerator = new NoOpFreePortGenerator();
        String freePortGeneratorSetting = this.getBeanLevelProperties().getContextProperties().getProperty("jetty.freePortGenerator", "file");
        if ("file".equalsIgnoreCase(freePortGeneratorSetting)) {
            freePortGenerator = new FileLockFreePortGenerator();
        }
        if (!jettyHolder.getServer().isStarted()) {
            boolean success = false;
            for (int i = 0; i < retryPortCount; ++i) {
                for (Connector connector : jettyHolder.getServer().getConnectors()) {
                    String connectorKey;
                    int port;
                    if (!(connector instanceof ServerConnector) || (port = ((ServerConnector)connector).getPort()) == 0) continue;
                    FreePortGenerator.PortHandle portHandle = freePortGenerator.nextAvailablePort(port, retryPortCount);
                    jettyHolder.updateConfidentialPort(port, portHandle.getPort());
                    ((ServerConnector)connector).setPort(portHandle.getPort());
                    String connectorName = connector.getName();
                    String string = connectorKey = connectorName != null ? connectorName : connector.getClass().getName();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)(">>> connectorKey:" + connectorKey + ", connector port:" + port + ", connector class name:" + connector.getClass().getName()));
                    }
                    if (portHandles.containsKey(connectorKey)) {
                        if (!logger.isWarnEnabled()) continue;
                        String messagePrefix = "Port [" + port + "] of connector [" + connectorKey + "] will not be exposed.";
                        logger.warn((Object)(connectorName != null ? messagePrefix + " Connector with this name already exists. Please provide a unique connector name." : messagePrefix + " Connector with this class already exists. To differentiate, please define a connector `name` property."));
                        continue;
                    }
                    portHandles.put(connectorKey, portHandle);
                }
                try {
                    jettyHolder.openConnectors();
                    success = true;
                    break;
                }
                catch (BindException e) {
                    for (FreePortGenerator.PortHandle portHandle : portHandles.values()) {
                        portHandle.release();
                    }
                    portHandles.clear();
                    try {
                        jettyHolder.closeConnectors();
                    }
                    catch (Exception e1) {
                        logger.debug((Object)e1);
                    }
                    for (Connector connector : jettyHolder.getServer().getConnectors()) {
                        if (!(connector instanceof ServerConnector)) continue;
                        int port = ((ServerConnector)connector).getPort();
                        jettyHolder.updateConfidentialPort(port, port + 1);
                        ((ServerConnector)connector).setPort(port + 1);
                    }
                    continue;
                }
                catch (Exception e) {
                    for (FreePortGenerator.PortHandle portHandle : portHandles.values()) {
                        portHandle.release();
                    }
                    portHandles.clear();
                    try {
                        jettyHolder.closeConnectors();
                    }
                    catch (Exception e1) {
                        logger.debug((Object)e1);
                    }
                    if (e instanceof CannotCreateContainerException) {
                        throw (CannotCreateContainerException)e;
                    }
                    throw new CannotCreateContainerException("Failed to start jetty server", (Throwable)e);
                }
            }
            if (!success) {
                throw new CannotCreateContainerException("Failed to bind jetty to port with retries [" + retryPortCount + "]");
            }
        }
        for (Connector connector : jettyHolder.getServer().getConnectors()) {
            if (connector instanceof NetworkConnector) {
                NetworkConnector networkConnector = (NetworkConnector)connector;
                logger.info((Object)("Using Jetty server connector [" + connector.getClass().getName() + "], Name [" + networkConnector.getName() + "], Host [" + networkConnector.getHost() + "], Port [" + networkConnector.getPort() + "], Confidential Port [" + JettyHolder.getConfidentialPort((Connector)networkConnector) + "]"));
                continue;
            }
            logger.info((Object)("Using Jetty server connector [" + connector.getClass().getName() + "]"));
        }
        try {
            jettyHolder.start();
        }
        catch (Exception e) {
            try {
                jettyHolder.stop();
            }
            catch (Exception e1) {
                logger.debug((Object)e1);
            }
            if (e instanceof CannotCreateContainerException) {
                throw (CannotCreateContainerException)e;
            }
            throw new CannotCreateContainerException("Failed to start jetty server", (Throwable)e);
        }
        return jettyHolder;
    }

    private void initJettyJmx(JettyHolder jettyHolder) {
        String jmxEnabled = this.getBeanLevelProperties().getContextProperties().getProperty(JETTY_JMX_PROP, "false");
        if ("true".equals(jmxEnabled)) {
            MBeanContainer mBeanContainer = new MBeanContainer(ManagementFactory.getPlatformMBeanServer());
            String domain = "gigaspaces.jetty";
            if (!jettyHolder.isSingleInstance()) {
                domain = domain + "." + this.getClusterInfo().getName() + "." + this.getClusterInfo().getRunningNumberOffset1();
            }
            mBeanContainer.setDomain(domain);
            jettyHolder.getServer().addEventListener((Container.Listener)mBeanContainer);
        }
    }

    private WebAppContext initWebAppContext(ResourceApplicationContext applicationContext) throws Exception {
        WebAppContext webAppContext = (WebAppContext)applicationContext.getBean("webAppContext");
        webAppContext.setExtractWAR(true);
        if (!webAppContext.getInitParams().containsKey("org.eclipse.jetty.servlet.Default.aliases")) {
            webAppContext.getInitParams().put("org.eclipse.jetty.servlet.Default.aliases", "true");
        }
        if (!webAppContext.getInitParams().containsKey("org.eclipse.jetty.servlet.Default.useFileMappedBuffer")) {
            webAppContext.getInitParams().put("org.eclipse.jetty.servlet.Default.useFileMappedBuffer", "false");
        }
        if (this.getBeanLevelProperties().getContextProperties().getProperty("com.gs.pu.jee.jetty.modifySystemClasses", "false").equalsIgnoreCase("true")) {
            HashSet<String> systemClasses = new HashSet<String>(Arrays.asList(webAppContext.getSystemClasses()));
            systemClasses.remove("org.apache.commons.logging.");
            systemClasses.remove("org.apache.log4j.");
            webAppContext.setSystemClasses(systemClasses.toArray(new String[systemClasses.size()]));
        }
        webAppContext.setServerClasses(new String[0]);
        webAppContext.setDisplayName("web." + this.getClusterInfo().getName() + "." + this.getClusterInfo().getSuffix());
        webAppContext.setClassLoader(this.initWebAppClassLoader(webAppContext));
        String SESSION_MANAGER_BEAN = "sessionManager";
        if (applicationContext.containsBean("sessionManager")) {
            SessionHandler sessionHandler;
            SessionManager sessionManager = (SessionManager)applicationContext.getBean("sessionManager");
            if (sessionManager != null && (sessionHandler = webAppContext.getSessionHandler()) != null) {
                sessionHandler.setSessionManager((SessionManager)new GSLazySessionManager(sessionManager));
            }
        } else {
            SessionHandler sessionHandler = webAppContext.getSessionHandler();
            if (sessionHandler != null) {
                sessionHandler.setSessionManager((SessionManager)new GSLazySessionManager());
            }
        }
        return webAppContext;
    }

    private ClassLoader initWebAppClassLoader(WebAppContext webAppContext) throws Exception {
        ServiceClassLoader serviceClassLoader = (ServiceClassLoader)Thread.currentThread().getContextClassLoader();
        JettyWebAppClassLoader webAppClassLoader = new JettyWebAppClassLoader(this.getJeeClassLoader(), webAppContext, serviceClassLoader.getLogName());
        for (String jar : super.getWebAppClassLoaderJars()) {
            webAppClassLoader.addJars((Resource)new FileResource(new File(jar).toURL()));
        }
        for (String classpath : super.getWebAppClassLoaderClassPath()) {
            webAppClassLoader.addClassPath(classpath);
        }
        if (this.getManifestURLs() != null) {
            for (URL url : this.getManifestURLs()) {
                webAppClassLoader.addClassPath((Resource)new FileResource(url));
            }
        }
        return webAppClassLoader;
    }

    static {
        System.setProperty("org.eclipse.jetty.util.log.class", JavaUtilLog.class.getName());
        System.setProperty("JETTY_NO_SHUTDOWN_HOOK", "true");
        logger = LogFactory.getLog(JettyJeeProcessingUnitContainerProvider.class);
        currentApplicationContext = new ThreadLocal();
        currentClusterInfo = new ThreadLocal();
        currentBeanLevelProperties = new ThreadLocal();
    }
}

