/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.pu.container.jee.jetty;

import com.gigaspaces.start.SystemInfo;
import java.net.InetSocketAddress;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.NetworkConnector;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.webapp.WebAppContext;
import org.openspaces.pu.container.CannotCloseContainerException;
import org.openspaces.pu.container.jee.JeeProcessingUnitContainer;
import org.openspaces.pu.container.jee.JeeServiceDetails;
import org.openspaces.pu.container.jee.JeeType;
import org.openspaces.pu.container.jee.jetty.holder.JettyHolder;
import org.openspaces.pu.container.jee.jetty.support.FreePortGenerator;
import org.openspaces.pu.service.ServiceDetails;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.web.context.ContextLoader;

public class JettyProcessingUnitContainer
extends JeeProcessingUnitContainer {
    private static final Log logger = LogFactory.getLog(JettyProcessingUnitContainer.class);
    private final ApplicationContext applicationContext;
    private ApplicationContext webApplicationContext;
    private final WebAppContext webAppContext;
    private ContextHandlerCollection contextHandlerCollection;
    private final JettyHolder jettyHolder;
    private final Collection<FreePortGenerator.PortHandle> portHandels;

    public JettyProcessingUnitContainer(ApplicationContext applicationContext, WebAppContext webAppContext, ContextHandlerCollection contextHandlerCollection, JettyHolder jettyHolder, Collection<FreePortGenerator.PortHandle> portHandels) {
        this.applicationContext = applicationContext;
        this.webAppContext = webAppContext;
        this.contextHandlerCollection = contextHandlerCollection;
        this.jettyHolder = jettyHolder;
        this.webApplicationContext = ContextLoader.getCurrentWebApplicationContext();
        if (this.webApplicationContext == null) {
            this.webApplicationContext = applicationContext;
        }
        this.portHandels = portHandels;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public ServiceDetails[] getServicesDetails() {
        return new ServiceDetails[]{this.getJeeDetails()};
    }

    public JeeServiceDetails getJeeDetails() {
        String hostAddress = null;
        int port = -1;
        int sslPort = -1;
        int sslConnectionPort = -1;
        Connector connector = this.jettyHolder.getServer().getConnectors()[0];
        if (connector instanceof NetworkConnector) {
            NetworkConnector networkConnector = (NetworkConnector)connector;
            port = networkConnector.getPort();
            sslPort = JettyHolder.getConfidentialPort(connector);
            sslConnectionPort = JettyHolder.getSslConnectionPort(connector);
            String host = networkConnector.getHost();
            if (host == null) {
                host = SystemInfo.singleton().network().getHostId();
            }
            InetSocketAddress addr = host == null ? new InetSocketAddress(port) : new InetSocketAddress(host, port);
            hostAddress = addr.getAddress().getHostAddress();
        }
        JeeServiceDetails details = new JeeServiceDetails(hostAddress, port, sslPort, this.webAppContext.getContextPath(), this.jettyHolder.isSingleInstance(), "jetty", JeeType.JETTY, sslConnectionPort);
        return details;
    }

    public void close() throws CannotCloseContainerException {
        for (FreePortGenerator.PortHandle portHandle : this.portHandels) {
            portHandle.release();
        }
        this.portHandels.clear();
        if (this.webAppContext.isRunning()) {
            try {
                this.webAppContext.stop();
                this.webAppContext.destroy();
            }
            catch (Exception e) {
                logger.warn((Object)"Failed to stop/destroy web context", (Throwable)e);
            }
            finally {
                this.webAppContext.setClassLoader(null);
            }
            if (this.contextHandlerCollection != null) {
                this.contextHandlerCollection.removeHandler((Handler)this.webAppContext);
            }
        }
        ConfigurableApplicationContext confAppContext = (ConfigurableApplicationContext)this.applicationContext;
        confAppContext.close();
        try {
            this.jettyHolder.stop();
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to stop jetty server", (Throwable)e);
        }
        super.close();
    }
}

