/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.pu.container.jee.jetty;

import com.j_spaces.core.IJSpace;
import java.lang.reflect.Method;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jetty.server.SessionManager;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.session.HashSessionIdManager;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.component.LifeCycle;
import org.openspaces.core.GigaSpace;
import org.openspaces.core.GigaSpaceConfigurer;
import org.openspaces.core.cluster.ClusterInfo;
import org.openspaces.core.properties.BeanLevelProperties;
import org.openspaces.core.space.UrlSpaceConfigurer;
import org.openspaces.jee.sessions.jetty.GigaSessionIdManager;
import org.openspaces.jee.sessions.jetty.GigaSessionManager;
import org.springframework.context.ApplicationContext;
import org.springframework.util.ReflectionUtils;

public class JettyWebApplicationContextListener
implements ServletContextListener {
    private static final Log logger = LogFactory.getLog(JettyWebApplicationContextListener.class);
    public static final String JETTY_SESSIONS_URL = "jetty.sessions.spaceUrl";
    public static final String JETTY_SESSIONS_SCAVENGE_PERIOD = "jetty.sessions.scavengePeriod";
    public static final String JETTY_SESSIONS_SAVE_PERIOD = "jetty.sessions.savePeriod";
    public static final String JETTY_SESSIONS_LEASE = "jetty.sessions.lease";
    public static final String JETTY_SESSIONS_TIMEOUT = "jetty.sessions.timeout";

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        ServletContext servletContext = servletContextEvent.getServletContext();
        ServletContextHandler jettyContext = (ServletContextHandler)((ContextHandler.Context)servletContext).getContextHandler();
        SessionHandler sessionHandler = jettyContext.getSessionHandler();
        BeanLevelProperties beanLevelProperties = (BeanLevelProperties)servletContext.getAttribute("beanLevelProperties");
        ClusterInfo clusterInfo = (ClusterInfo)servletContext.getAttribute("clusterInfo");
        if (beanLevelProperties != null) {
            HashSessionIdManager sessionIdManager;
            String sessionsSpaceUrl = beanLevelProperties.getContextProperties().getProperty(JETTY_SESSIONS_URL);
            if (sessionsSpaceUrl != null) {
                String lease;
                String savePeriod;
                logger.info((Object)("Jetty GigaSpaces Session support using space url [" + sessionsSpaceUrl + "]"));
                GigaSessionManager gigaSessionManager = new GigaSessionManager();
                if (sessionsSpaceUrl.startsWith("bean://")) {
                    GigaSpace space;
                    ApplicationContext applicationContext = (ApplicationContext)servletContext.getAttribute("applicationContext");
                    if (applicationContext == null) {
                        throw new IllegalStateException("Failed to find servlet context bound application context");
                    }
                    Object bean = applicationContext.getBean(sessionsSpaceUrl.substring("bean://".length()));
                    if (bean instanceof GigaSpace) {
                        space = (GigaSpace)bean;
                    } else if (bean instanceof IJSpace) {
                        space = new GigaSpaceConfigurer((IJSpace)bean).create();
                    } else {
                        throw new IllegalArgumentException("Bean [" + bean + "] is not of either GigaSpace type or IJSpace type");
                    }
                    gigaSessionManager.setSpace(space);
                } else {
                    gigaSessionManager.setUrlSpaceConfigurer(new UrlSpaceConfigurer(sessionsSpaceUrl).clusterInfo(clusterInfo));
                }
                String scavangePeriod = beanLevelProperties.getContextProperties().getProperty(JETTY_SESSIONS_SCAVENGE_PERIOD);
                if (scavangePeriod != null) {
                    gigaSessionManager.setScavengePeriod(Integer.parseInt(scavangePeriod));
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Setting scavenge period to [" + scavangePeriod + "] seconds"));
                    }
                }
                if ((savePeriod = beanLevelProperties.getContextProperties().getProperty(JETTY_SESSIONS_SAVE_PERIOD)) != null) {
                    gigaSessionManager.setSavePeriod(Integer.parseInt(savePeriod));
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Setting save period to [" + savePeriod + "] seconds"));
                    }
                }
                if ((lease = beanLevelProperties.getContextProperties().getProperty(JETTY_SESSIONS_LEASE)) != null) {
                    gigaSessionManager.setLease(Long.parseLong(lease));
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Setting lease to [" + lease + "] milliseconds"));
                    }
                }
                SessionManager sessionManager = sessionHandler.getSessionManager();
                gigaSessionManager.getSessionCookieConfig().setName(sessionManager.getSessionCookieConfig().getName());
                gigaSessionManager.getSessionCookieConfig().setDomain(sessionManager.getSessionCookieConfig().getDomain());
                gigaSessionManager.getSessionCookieConfig().setPath(sessionManager.getSessionCookieConfig().getPath());
                gigaSessionManager.setUsingCookies(sessionManager.isUsingCookies());
                gigaSessionManager.getSessionCookieConfig().setMaxAge(sessionManager.getSessionCookieConfig().getMaxAge());
                gigaSessionManager.getSessionCookieConfig().setSecure(sessionManager.getSessionCookieConfig().isSecure());
                gigaSessionManager.setMaxInactiveInterval(sessionManager.getMaxInactiveInterval());
                gigaSessionManager.setHttpOnly(sessionManager.getHttpOnly());
                gigaSessionManager.getSessionCookieConfig().setComment(sessionManager.getSessionCookieConfig().getComment());
                String sessionTimeout = beanLevelProperties.getContextProperties().getProperty(JETTY_SESSIONS_TIMEOUT);
                if (sessionTimeout != null) {
                    gigaSessionManager.setMaxInactiveInterval(Integer.parseInt(sessionTimeout) * 60);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Setting session timeout to [" + sessionTimeout + "] seconds"));
                    }
                }
                GigaSessionIdManager sessionIdManager2 = new GigaSessionIdManager(jettyContext.getServer());
                sessionIdManager2.setWorkerName(clusterInfo.getUniqueName().replace('.', '_'));
                gigaSessionManager.setSessionIdManager(sessionIdManager2);
                if ("GSLazySessionManager".equals(sessionManager.getClass().getSimpleName())) {
                    try {
                        Method method = ReflectionUtils.findMethod(sessionManager.getClass(), (String)"replaceDefault", (Class[])new Class[]{SessionManager.class});
                        if (method == null) {
                            throw new NoSuchMethodException("replaceDefault");
                        }
                        ReflectionUtils.invokeMethod((Method)method, (Object)sessionManager, (Object[])new Object[]{gigaSessionManager});
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Failed to replace default session manager with GSSessionManager", e);
                    }
                }
            }
            if (sessionHandler.getSessionManager().getSessionIdManager() instanceof HashSessionIdManager && (sessionIdManager = (HashSessionIdManager)sessionHandler.getSessionManager().getSessionIdManager()).getWorkerName() == null) {
                String workerName = clusterInfo.getUniqueName().replace('.', '_');
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Automatically setting worker name to [" + workerName + "]"));
                }
                this.stop((LifeCycle)sessionIdManager, "to set worker name");
                sessionIdManager.setWorkerName(workerName);
                this.start((LifeCycle)sessionIdManager, "to set worker name");
            }
        }
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
    }

    private void stop(LifeCycle instance, String cause) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Stopping " + instance.toString() + " " + cause));
        }
        try {
            instance.stop();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to stop " + instance.toString() + " " + cause, e);
        }
    }

    private void start(LifeCycle instance, String cause) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Starting " + instance.toString() + " " + cause));
        }
        try {
            instance.start();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to start " + instance.toString() + " " + cause, e);
        }
    }
}

