/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.pu.container.jee.jetty.holder;

import java.util.Collection;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.NetworkConnector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.util.MultiException;

public abstract class JettyHolder {
    public abstract Server getServer();

    public abstract boolean isSingleInstance();

    public void openConnectors() throws Exception {
        Connector[] connectors;
        Server server = this.getServer();
        for (Connector c : connectors = server.getConnectors()) {
            if (!(c instanceof NetworkConnector)) continue;
            ((NetworkConnector)c).open();
        }
    }

    public void closeConnectors() throws Exception {
        Server server = this.getServer();
        Connector[] connectors = server.getConnectors();
        MultiException ex = new MultiException();
        for (Connector c : connectors) {
            try {
                if (!(c instanceof NetworkConnector)) continue;
                ((NetworkConnector)c).close();
            }
            catch (Exception e) {
                ex.add((Throwable)e);
            }
        }
        ex.ifExceptionThrowMulti();
    }

    public void start() throws Exception {
        Server server = this.getServer();
        server.start();
    }

    public void stop() throws Exception {
        Server server = this.getServer();
        server.stop();
        server.destroy();
    }

    public void updateConfidentialPort(int port, int newPort) {
        Server server = this.getServer();
        for (Connector connector : server.getConnectors()) {
            HttpConfiguration config = JettyHolder.getHttpConfig(connector);
            if (config == null || config.getSecurePort() != port) continue;
            config.setSecurePort(newPort);
        }
    }

    public static int getConfidentialPort(Connector connector) {
        HttpConfiguration config = JettyHolder.getHttpConfig(connector);
        return config != null ? config.getSecurePort() : -1;
    }

    public static HttpConfiguration getHttpConfig(Connector connector) {
        HttpConnectionFactory connectionFactory = (HttpConnectionFactory)connector.getConnectionFactory(HttpConnectionFactory.class);
        return connectionFactory != null ? connectionFactory.getHttpConfiguration() : null;
    }

    public static int getSslPort(Connector connector) {
        HttpConfiguration config = JettyHolder.getHttpConfig(connector);
        return config != null ? config.getSecurePort() : -1;
    }

    public static int getSslConnectionPort(Connector connector) {
        int sslPort = 0;
        Collection connectionFactories = connector.getConnectionFactories();
        for (ConnectionFactory connectionFactory : connectionFactories) {
            if (!(connectionFactory instanceof SslConnectionFactory)) continue;
            sslPort = JettyHolder.getSslPort(connector);
            break;
        }
        return sslPort;
    }
}

