/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.pu.container.jee.jetty.holder;

import com.gigaspaces.internal.utils.SharedInstance;
import com.gigaspaces.internal.utils.Singletons;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jetty.server.Server;
import org.openspaces.pu.container.jee.jetty.holder.JettyHolder;

public class SharedJettyHolder
extends JettyHolder {
    private static final Log logger = LogFactory.getLog(SharedJettyHolder.class);
    private static final String SHARED_JETTY_KEY = "jetty.server";
    private final SharedInstance<Server> server;

    public SharedJettyHolder(Server localServer) {
        SharedInstance newServer = new SharedInstance((Object)localServer);
        this.server = (SharedInstance)Singletons.putIfAbsent((String)SHARED_JETTY_KEY, (Object)newServer);
        if (this.server == newServer) {
            ((Server)this.server.value()).setStopAtShutdown(false);
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Using new jetty server [" + this.server.value() + "]"));
            }
        } else if (logger.isInfoEnabled()) {
            logger.info((Object)("Using existing jetty server [" + this.server.value() + "]"));
        }
    }

    @Override
    public void start() throws Exception {
        if (this.server.increment() == 1) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Starting jetty server [" + this.server + "]"));
            }
            super.start();
        }
    }

    @Override
    public void stop() throws Exception {
        if (this.server.decrement() == 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Stopping jetty server [" + this.server + "]"));
            }
            super.stop();
            Singletons.remove((String)SHARED_JETTY_KEY);
        }
    }

    @Override
    public Server getServer() {
        return (Server)this.server.value();
    }

    @Override
    public boolean isSingleInstance() {
        return true;
    }
}

