/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.pu.container.jee.jetty.holder;

import com.gigaspaces.internal.utils.SharedInstance;
import com.gigaspaces.internal.utils.Singletons;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.thread.ThreadPool;

public class SharedThreadPool
implements ThreadPool,
LifeCycle {
    private static final Log logger = LogFactory.getLog(SharedThreadPool.class);
    private static final String SHARED_JETTY_KEY = "jetty.threadpool";
    private final SharedInstance<ThreadPool> threadPool;

    public SharedThreadPool(ThreadPool threadPool) {
        SharedInstance newThreadPool = new SharedInstance((Object)threadPool);
        this.threadPool = (SharedInstance)Singletons.putIfAbsent((String)SHARED_JETTY_KEY, (Object)newThreadPool);
        if (this.threadPool == newThreadPool) {
            logger.debug((Object)("Using new thread pool [" + threadPool + "]"));
        } else {
            logger.debug((Object)("Using existing thread pool [" + threadPool + "]"));
        }
    }

    public void execute(Runnable command) {
        ((ThreadPool)this.threadPool.value()).execute(command);
    }

    public void join() throws InterruptedException {
        ((ThreadPool)this.threadPool.value()).join();
    }

    public int getThreads() {
        return ((ThreadPool)this.threadPool.value()).getThreads();
    }

    public int getIdleThreads() {
        return ((ThreadPool)this.threadPool.value()).getIdleThreads();
    }

    public boolean isLowOnThreads() {
        return ((ThreadPool)this.threadPool.value()).isLowOnThreads();
    }

    public void start() throws Exception {
        if (this.threadPool.increment() == 1) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Starting thread pool [" + this.threadPool + "]"));
            }
            ((LifeCycle)this.threadPool.value()).start();
        }
    }

    public void stop() throws Exception {
        if (this.threadPool.decrement() == 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Stopping thread pool [" + this.threadPool + "]"));
            }
            ((LifeCycle)this.threadPool.value()).stop();
        }
    }

    public boolean isRunning() {
        return ((LifeCycle)this.threadPool.value()).isRunning();
    }

    public boolean isStarted() {
        return ((LifeCycle)this.threadPool.value()).isStarted();
    }

    public boolean isStarting() {
        return ((LifeCycle)this.threadPool.value()).isStarting();
    }

    public boolean isStopping() {
        return ((LifeCycle)this.threadPool.value()).isStopping();
    }

    public boolean isStopped() {
        return ((LifeCycle)this.threadPool.value()).isStopped();
    }

    public boolean isFailed() {
        return ((LifeCycle)this.threadPool.value()).isFailed();
    }

    public void addLifeCycleListener(LifeCycle.Listener listener) {
        ((LifeCycle)this.threadPool.value()).addLifeCycleListener(listener);
    }

    public void removeLifeCycleListener(LifeCycle.Listener listener) {
        ((LifeCycle)this.threadPool.value()).removeLifeCycleListener(listener);
    }

    public String toString() {
        return "Shared(" + this.threadPool.count() + ") [" + this.threadPool.value() + "]";
    }
}

