/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.pu.container.jee.jetty.support;

import com.gigaspaces.start.SystemInfo;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openspaces.pu.container.jee.jetty.support.FreePortGenerator;

public class FileLockFreePortGenerator
implements FreePortGenerator {
    private static final Log logger = LogFactory.getLog(FileLockFreePortGenerator.class);
    private static final File portDirectory;

    @Override
    public FreePortGenerator.PortHandle nextAvailablePort(int startFromPort, int retryCount) {
        int portNumber = -1;
        FileLock portFileLock = null;
        RandomAccessFile portFile = null;
        for (int i = 0; i < retryCount; ++i) {
            portNumber = startFromPort + i;
            File portF = new File(portDirectory, portNumber + ".port");
            try {
                portFile = new RandomAccessFile(portF, "rw");
            }
            catch (FileNotFoundException e) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Failed to open port marker file [" + portF.getAbsolutePath() + "]"), (Throwable)e);
                continue;
            }
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Trying to lock file [" + portF.getAbsolutePath() + "]"));
                }
                if ((portFileLock = portFile.getChannel().tryLock()) != null) break;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Can't get lock for [" + portF.getAbsolutePath() + "], try another"));
                }
                try {
                    portFile.close();
                }
                catch (Exception e) {}
                continue;
            }
            catch (OverlappingFileLockException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Can't get lock for [" + portF.getAbsolutePath() + "], try another, " + e.getMessage()));
                }
                try {
                    portFile.close();
                }
                catch (Exception exception) {}
                continue;
            }
            catch (IOException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Failed to get lock file for [" + portF.getAbsolutePath() + "]"), (Throwable)e);
                }
                try {
                    portFile.close();
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (portFileLock == null) {
            throw new IllegalStateException("Failed to acquire port file lock, tried for [" + retryCount + "], basePort [" + startFromPort + "]");
        }
        return new FileLockPortHandle(portFile, portFileLock, portNumber);
    }

    static {
        File jettyWork = new File(SystemInfo.singleton().locations().work() + "/jetty");
        portDirectory = new File(jettyWork, "ports");
        portDirectory.mkdirs();
    }

    public static class FileLockPortHandle
    implements FreePortGenerator.PortHandle {
        private final RandomAccessFile portFile;
        private final FileLock portFileLock;
        private final int portNumber;

        public FileLockPortHandle(RandomAccessFile portFile, FileLock portFileLock, int portNumber) {
            this.portFile = portFile;
            this.portFileLock = portFileLock;
            this.portNumber = portNumber;
        }

        @Override
        public int getPort() {
            return this.portNumber;
        }

        @Override
        public void release() {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Releasing port [" + this.portNumber + "]"));
                }
                this.portFileLock.release();
            }
            catch (IOException e) {
                logger.debug((Object)("Failed to release port file lock for port [" + this.portNumber + "]"), (Throwable)e);
            }
            try {
                this.portFile.close();
            }
            catch (IOException e) {
                logger.debug((Object)("Failed to close port file for port [" + this.portNumber + "]"), (Throwable)e);
            }
        }
    }
}

