/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.persistency.hibernate;

import com.gigaspaces.datasource.BulkItem;
import com.gigaspaces.datasource.DataIterator;
import com.gigaspaces.datasource.DataSourceException;
import com.gigaspaces.datasource.ManagedDataSource;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.SessionFactory;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.openspaces.persistency.hibernate.SessionFactoryBuilder;
import org.openspaces.persistency.hibernate.iterator.HibernateProxyRemoverIterator;
import org.openspaces.persistency.patterns.ManagedDataSourceEntriesProvider;
import org.openspaces.persistency.support.ConcurrentMultiDataIterator;

@Deprecated
public abstract class AbstractHibernateExternalDataSource
implements ManagedDataSource,
ManagedDataSourceEntriesProvider {
    protected final Log logger = LogFactory.getLog(this.getClass());
    public static final String HIBERNATE_CFG_PROPERTY = "hibernate-config-file";
    private SessionFactory sessionFactory;
    private Set<String> managedEntries;
    private String[] initialLoadEntries;
    private int fetchSize = 100;
    private int initialLoadThreadPoolSize = 10;
    private int initialLoadChunkSize = 100000;
    private boolean performOrderById = true;
    private boolean createdSessionFactory = true;
    private boolean useScrollableResultSet = true;

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.createdSessionFactory = false;
        this.sessionFactory = sessionFactory;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setManagedEntries(String ... entries) {
        this.managedEntries = new HashSet<String>();
        this.managedEntries.addAll(Arrays.asList(entries));
    }

    public String[] getManagedEntries() {
        return this.managedEntries.toArray(new String[this.managedEntries.size()]);
    }

    protected boolean isManagedEntry(String entityName) {
        return this.managedEntries.contains(entityName);
    }

    protected Map<String, Object> filterItemValue(String entityName, Map<String, Object> itemValues) {
        ClassMetadata classMetadata = this.sessionFactory.getClassMetadata(entityName);
        String[] propertyNames = classMetadata.getPropertyNames();
        List<String> names = Arrays.asList(propertyNames);
        Iterator<String> iterator = itemValues.keySet().iterator();
        while (iterator.hasNext()) {
            if (names.contains(iterator.next())) continue;
            iterator.remove();
        }
        return itemValues;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    protected int getFetchSize() {
        return this.fetchSize;
    }

    public void setPerformOrderById(boolean performOrderById) {
        this.performOrderById = performOrderById;
    }

    protected boolean isPerformOrderById() {
        return this.performOrderById;
    }

    public void setInitialLoadEntries(String ... initialLoadEntries) {
        this.initialLoadEntries = initialLoadEntries;
    }

    public String[] getInitialLoadEntries() {
        return this.initialLoadEntries;
    }

    public void setInitialLoadThreadPoolSize(int initialLoadThreadPoolSize) {
        this.initialLoadThreadPoolSize = initialLoadThreadPoolSize;
    }

    public void setInitialLoadChunkSize(int initalLoadChunkSize) {
        this.initialLoadChunkSize = initalLoadChunkSize;
    }

    protected int getInitialLoadChunkSize() {
        return this.initialLoadChunkSize;
    }

    protected boolean isUseScrollableResultSet() {
        return this.useScrollableResultSet;
    }

    public void setUseScrollableResultSet(boolean useScrollableResultSet) {
        this.useScrollableResultSet = useScrollableResultSet;
    }

    public void init(Properties properties) throws DataSourceException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Using initialLoadChunkSize [" + this.initialLoadChunkSize + "], fetchSize [" + this.fetchSize + "], initialLoadThreadPoolSize [" + this.initialLoadThreadPoolSize + "], performOrderById [" + this.performOrderById + "]"));
        }
        if (this.sessionFactory == null) {
            this.createdSessionFactory = true;
            String hibernateFile = properties.getProperty(HIBERNATE_CFG_PROPERTY);
            if (hibernateFile == null) {
                this.logger.error((Object)"No session factory injected, and [hibernate-config-file] is not provided in the properties file, can't create session factory");
            } else {
                this.logger.debug((Object)("[hibernate-config-file] " + hibernateFile + " is provided in the properties file "));
            }
            try {
                this.sessionFactory = SessionFactoryBuilder.getFactory(hibernateFile);
            }
            catch (Exception e) {
                throw new DataSourceException("Failed to create session factory from properties file [" + hibernateFile + "]", (Throwable)e);
            }
        }
        if (this.managedEntries == null) {
            this.managedEntries = new HashSet<String>();
            Map allClassMetaData = this.sessionFactory.getAllClassMetadata();
            for (String entityname : allClassMetaData.keySet()) {
                this.managedEntries.add(entityname);
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Using Hibernate managedEntries [" + this.managedEntries + "]"));
        }
        if (this.initialLoadEntries == null) {
            HashSet<String> initialLoadEntries = new HashSet<String>();
            Map allClassMetaData = this.sessionFactory.getAllClassMetadata();
            for (Map.Entry entry : allClassMetaData.entrySet()) {
                String superClassEntityName;
                ClassMetadata superClassMetadata;
                Class superClass;
                String entityname = (String)entry.getKey();
                ClassMetadata classMetadata = (ClassMetadata)entry.getValue();
                if (classMetadata.isInherited() && (superClass = (superClassMetadata = (ClassMetadata)allClassMetaData.get(superClassEntityName = ((AbstractEntityPersister)classMetadata).getMappedSuperclass())).getMappedClass()) != null) {
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug((Object)("Entity [" + entityname + "] is inherited and has a super class [" + superClass + "] filtering it out for initial load managedEntries"));
                    continue;
                }
                initialLoadEntries.add(entityname);
            }
            this.initialLoadEntries = initialLoadEntries.toArray(new String[initialLoadEntries.size()]);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Using Hibernate initial load managedEntries [" + Arrays.toString(this.initialLoadEntries) + "]"));
        }
    }

    public void shutdown() throws DataSourceException {
        if (this.createdSessionFactory && this.sessionFactory != null && !this.sessionFactory.isClosed()) {
            try {
                this.sessionFactory.close();
            }
            finally {
                this.sessionFactory = null;
            }
        }
    }

    protected DataIterator createInitialLoadIterator(DataIterator[] iterators) {
        return new HibernateProxyRemoverIterator((DataIterator)new ConcurrentMultiDataIterator(iterators, this.initialLoadThreadPoolSize));
    }

    protected boolean isManaged(BulkItem bulkItem) {
        String typeName = bulkItem.getTypeName();
        if (!this.isManagedEntry(typeName)) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Entry [" + typeName + ":" + bulkItem + "] is not managed, filtering it out"));
            }
            return false;
        }
        return true;
    }

    protected String getPartialUpdateHQL(BulkItem updateBulkItem, Map<String, Object> updatedValues) {
        StringBuilder updateQueryBuilder = new StringBuilder("update ");
        updateQueryBuilder.append(updateBulkItem.getTypeName()).append(" set ");
        int i = 0;
        for (Map.Entry<String, Object> updateEntry : updatedValues.entrySet()) {
            updateQueryBuilder.append(updateEntry.getKey()).append("=:").append(updateEntry.getKey());
            if (i < updatedValues.size() - 1) {
                updateQueryBuilder.append(',');
            }
            ++i;
        }
        updateQueryBuilder.append(" where ").append(updateBulkItem.getIdPropertyName()).append("=:id_").append(updateBulkItem.getIdPropertyName());
        String hql = updateQueryBuilder.toString();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Partial Update HQL [" + hql + ']'));
        }
        return hql;
    }
}

