/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.persistency.hibernate;

import com.gigaspaces.datasource.DataIterator;
import com.gigaspaces.internal.client.spaceproxy.metadata.TypeDescFactory;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.metadata.SpaceTypeDescriptor;
import com.j_spaces.kernel.ClassLoaderHelper;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.SessionFactory;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.openspaces.core.cluster.ClusterInfo;
import org.openspaces.persistency.hibernate.ManagedEntitiesContainer;
import org.openspaces.persistency.hibernate.iterator.HibernateProxyRemoverIterator;
import org.openspaces.persistency.patterns.ManagedEntriesSpaceDataSource;
import org.openspaces.persistency.support.ConcurrentMultiDataIterator;

public abstract class AbstractHibernateSpaceDataSource
extends ManagedEntriesSpaceDataSource {
    protected static final Log logger = LogFactory.getLog(AbstractHibernateSpaceDataSource.class);
    private final int fetchSize;
    private final boolean performOrderById;
    private final Set<String> initialLoadEntries = new HashSet<String>();
    private final int initialLoadThreadPoolSize;
    private final int initialLoadChunkSize;
    private final boolean useScrollableResultSet;
    private final ManagedEntitiesContainer sessionManager;
    private final SessionFactory sessionFactory;
    private final Map<String, SpaceTypeDescriptor> initialLoadEntriesTypeDescs = new HashMap<String, SpaceTypeDescriptor>();
    private Map<String, ClassMetadata> allMappedClassMetaData;

    public AbstractHibernateSpaceDataSource(SessionFactory sessionFactory, Set<String> managedEntries, int fetchSize, boolean performOrderById, String[] initialLoadEntries, int initialLoadThreadPoolSize, int initialLoadChunkSize, boolean useScrollableResultSet, String[] initialLoadQueryScanningBasePackages, boolean augmentInitialLoadEntries, ClusterInfo clusterInfo) {
        this.sessionFactory = sessionFactory;
        this.fetchSize = fetchSize;
        this.performOrderById = performOrderById;
        this.initialLoadEntries.addAll(this.createInitialLoadEntries(initialLoadEntries, sessionFactory));
        this.initialLoadThreadPoolSize = initialLoadThreadPoolSize;
        this.initialLoadChunkSize = initialLoadChunkSize;
        this.useScrollableResultSet = useScrollableResultSet;
        this.sessionManager = new ManagedEntitiesContainer(sessionFactory, managedEntries);
        this.initialLoadQueryScanningBasePackages = initialLoadQueryScanningBasePackages;
        this.augmentInitialLoadEntries = augmentInitialLoadEntries;
        this.clusterInfo = clusterInfo;
    }

    private Set<String> createInitialLoadEntries(String[] initialLoadEntries, SessionFactory sessionFactory) {
        HashSet<String> result = new HashSet<String>();
        if (initialLoadEntries != null) {
            for (String entry : initialLoadEntries) {
                result.add(entry);
            }
        } else {
            this.allMappedClassMetaData = sessionFactory.getAllClassMetadata();
            for (Map.Entry<String, ClassMetadata> entry : this.allMappedClassMetaData.entrySet()) {
                String superClassEntityName;
                ClassMetadata superClassMetadata;
                Class superClass;
                String entityName = entry.getKey();
                ClassMetadata classMetadata = entry.getValue();
                if (classMetadata.isInherited() && (superClass = (superClassMetadata = this.allMappedClassMetaData.get(superClassEntityName = ((AbstractEntityPersister)classMetadata).getMappedSuperclass())).getMappedClass()) != null) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("Entity [" + entityName + "] is inherited and has a super class [" + superClass + "] filtering it out for initial load managedEntries"));
                    continue;
                }
                result.add(entityName);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Using Hibernate initial load managedEntries [" + Arrays.toString(initialLoadEntries) + "]"));
        }
        return result;
    }

    protected Set<String> getInitialLoadEntries() {
        return this.initialLoadEntries;
    }

    protected int getInitialLoadChunkSize() {
        return this.initialLoadChunkSize;
    }

    protected boolean isUseScrollableResultSet() {
        return this.useScrollableResultSet;
    }

    protected SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    protected int getFetchSize() {
        return this.fetchSize;
    }

    protected boolean isPerformOrderById() {
        return this.performOrderById;
    }

    protected DataIterator createInitialLoadIterator(DataIterator[] iterators) {
        return new HibernateProxyRemoverIterator((DataIterator)new ConcurrentMultiDataIterator(iterators, this.initialLoadThreadPoolSize));
    }

    protected boolean isManagedEntry(String entityName) {
        return this.sessionManager.isManagedEntry(entityName);
    }

    public boolean supportsInheritance() {
        return true;
    }

    public Iterable<String> getManagedEntries() {
        return this.sessionManager.getManagedEntries();
    }

    public DataIterator<SpaceTypeDescriptor> initialMetadataLoad() {
        super.initialMetadataLoad();
        TypeDescFactory typeDescFactory = new TypeDescFactory();
        for (String initialLoadEntryTypeName : this.initialLoadEntries) {
            try {
                this.initialLoadEntriesTypeDescs.put(initialLoadEntryTypeName, (SpaceTypeDescriptor)typeDescFactory.createPojoTypeDesc(ClassLoaderHelper.loadClass((String)initialLoadEntryTypeName), null, null));
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Initial load entity " + initialLoadEntryTypeName + " cannot be resolved!", e);
            }
        }
        this.putUnmappedAncestors(typeDescFactory);
        return null;
    }

    private void putUnmappedAncestors(TypeDescFactory typeDescFactory) {
        HashSet<SpaceTypeDescriptor> mapped = new HashSet<SpaceTypeDescriptor>(this.initialLoadEntriesTypeDescs.values());
        for (SpaceTypeDescriptor entry : mapped) {
            String superTypeName = entry.getSuperTypeName();
            while (!Object.class.getName().equals(superTypeName) && !this.initialLoadEntriesTypeDescs.containsKey(superTypeName)) {
                try {
                    ITypeDesc typeDescriptor = typeDescFactory.createPojoTypeDesc(ClassLoaderHelper.loadClass((String)superTypeName), null, null);
                    this.initialLoadEntriesTypeDescs.put(superTypeName, (SpaceTypeDescriptor)typeDescriptor);
                    superTypeName = typeDescriptor.getSuperTypeName();
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException("Initial load entity " + superTypeName + " cannot be resolved!", e);
                }
            }
        }
    }

    protected void obtainInitialLoadQueries() {
        super.obtainInitialLoadQueries();
        if (!this.augmentInitialLoadEntries) {
            return;
        }
        if (this.clusterInfo == null) {
            return;
        }
        Integer num = this.clusterInfo.getNumberOfInstances();
        Integer instanceId = this.clusterInfo.getInstanceId();
        if (num == null || instanceId == null) {
            return;
        }
        String query = "MOD(?," + num + ") = " + (instanceId - 1);
        for (String type : this.initialLoadEntries) {
            if (this.allMappedClassMetaData != null && !this.allMappedClassMetaData.containsKey(type) || this.initialLoadQueries.containsKey(type)) continue;
            this.processInitialLoadEntry(type, query);
        }
    }

    private void processInitialLoadEntry(String type, String query) {
        SpaceTypeDescriptor typeDesc = this.initialLoadEntriesTypeDescs.get(type);
        String typeQuery = this.createInitialLoadQuery(typeDesc, query);
        if (null != typeQuery) {
            this.initialLoadQueries.put(type, typeQuery);
        }
    }
}

