/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.persistency.hibernate;

import com.gigaspaces.metadata.SpaceTypeDescriptor;
import com.gigaspaces.sync.DataSyncOperation;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.metadata.ClassMetadata;
import org.openspaces.persistency.hibernate.ManagedEntitiesContainer;
import org.openspaces.persistency.patterns.ManagedEntriesSpaceSynchronizationEndpoint;

public abstract class AbstractHibernateSpaceSynchronizationEndpoint
extends ManagedEntriesSpaceSynchronizationEndpoint {
    protected static final Log logger = LogFactory.getLog(AbstractHibernateSpaceSynchronizationEndpoint.class);
    private final ManagedEntitiesContainer sessionManager;
    private final SessionFactory sessionFactory;

    public AbstractHibernateSpaceSynchronizationEndpoint(SessionFactory sessionFactory, Set<String> managedEntries) {
        this.sessionFactory = sessionFactory;
        this.sessionManager = new ManagedEntitiesContainer(sessionFactory, managedEntries);
    }

    protected boolean isManaged(DataSyncOperation dataSyncOperation) {
        if (!dataSyncOperation.supportsGetTypeDescriptor()) {
            return false;
        }
        String typeName = dataSyncOperation.getTypeDescriptor().getTypeName();
        if (!this.sessionManager.isManagedEntry(typeName)) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Entry [" + typeName + ":" + dataSyncOperation + "] is not managed, filtering it out"));
            }
            return false;
        }
        return true;
    }

    protected Map<String, Object> filterItemValue(String entityName, Map<String, Object> itemValues) {
        ClassMetadata classMetadata = this.getSessionFactory().getClassMetadata(entityName);
        String[] propertyNames = classMetadata.getPropertyNames();
        List<String> names = Arrays.asList(propertyNames);
        HashMap<String, Object> filteredItems = new HashMap<String, Object>();
        for (Map.Entry<String, Object> next : itemValues.entrySet()) {
            if (!names.contains(next.getKey())) continue;
            filteredItems.put(next.getKey(), next.getValue());
        }
        return filteredItems;
    }

    protected String getPartialUpdateHQL(DataSyncOperation dataSyncOperation, Map<String, Object> updatedValues) {
        StringBuilder updateQueryBuilder = new StringBuilder("update ");
        SpaceTypeDescriptor typeDescriptor = dataSyncOperation.getTypeDescriptor();
        updateQueryBuilder.append(typeDescriptor.getTypeName()).append(" set ");
        int i = 0;
        for (Map.Entry<String, Object> updateEntry : updatedValues.entrySet()) {
            updateQueryBuilder.append(updateEntry.getKey()).append("=:").append(updateEntry.getKey());
            if (i < updatedValues.size() - 1) {
                updateQueryBuilder.append(',');
            }
            ++i;
        }
        updateQueryBuilder.append(" where ").append(typeDescriptor.getIdPropertyName()).append("=:id_").append(typeDescriptor.getIdPropertyName());
        String hql = updateQueryBuilder.toString();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Partial Update HQL [" + hql + ']'));
        }
        return hql;
    }

    protected void rollbackTx(Transaction tr) {
        try {
            tr.rollback();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public Iterable<String> getManagedEntries() {
        return this.sessionManager.getManagedEntries();
    }
}

