/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.persistency.hibernate;

import com.gigaspaces.datasource.DataIterator;
import com.gigaspaces.datasource.DataSourceIdQuery;
import com.gigaspaces.datasource.DataSourceQuery;
import com.gigaspaces.datasource.SpaceDataSourceException;
import java.io.Serializable;
import java.util.Set;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.openspaces.core.cluster.ClusterInfo;
import org.openspaces.persistency.hibernate.DefaultHibernateSpaceDataSource;
import org.openspaces.persistency.hibernate.iterator.DefaultCriteriaByExampleDataIterator;
import org.openspaces.persistency.hibernate.iterator.HibernateIteratorUtils;
import org.openspaces.persistency.hibernate.iterator.HibernateProxyRemoverIterator;

public class CriteriaHibernateSpaceDataSource
extends DefaultHibernateSpaceDataSource {
    public CriteriaHibernateSpaceDataSource(SessionFactory sessionFactory, Set<String> managedEntries, int fetchSize, boolean performOrderById, String[] initialLoadEntries, int initialLoadThreadPoolSize, int initialLoadChunkSize, boolean useScrollableResultSet, String[] initialLoadQueryScanningBasePackages, boolean augmentInitialLoadEntries, ClusterInfo clusterInfo) {
        super(sessionFactory, managedEntries, fetchSize, performOrderById, initialLoadEntries, initialLoadThreadPoolSize, initialLoadChunkSize, useScrollableResultSet, initialLoadQueryScanningBasePackages, augmentInitialLoadEntries, clusterInfo);
    }

    @Override
    public DataIterator<Object> getDataIterator(DataSourceQuery query) {
        if (!query.supportsTemplateAsObject()) {
            return super.getDataIterator(query);
        }
        Object template = query.getTemplateAsObject();
        if (!this.isManagedEntry(query.getTypeDescriptor().getTypeName()) && logger.isTraceEnabled()) {
            logger.trace((Object)("Ignoring template (no mapping in hibernate) [" + template + "]"));
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Iterator over template [" + template + "]"));
        }
        return new HibernateProxyRemoverIterator(new DefaultCriteriaByExampleDataIterator(template, this.getSessionFactory()));
    }

    public Object getById(DataSourceIdQuery idQuery) {
        if (!this.isManagedEntry(idQuery.getTypeDescriptor().getTypeName()) && logger.isTraceEnabled()) {
            logger.trace((Object)("Ignoring template (no mapping in hibernate) [" + idQuery + "]"));
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Read over template [" + idQuery + "]"));
        }
        Object object = null;
        Session session = this.getSessionFactory().openSession();
        session.setFlushMode(FlushMode.MANUAL);
        Transaction tx = null;
        try {
            tx = session.beginTransaction();
            object = session.get(idQuery.getTypeDescriptor().getTypeName(), (Serializable)idQuery.getId());
            tx.rollback();
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
            }
            throw new SpaceDataSourceException("Exception caught while read with template [" + idQuery + "]", (Throwable)e);
        }
        finally {
            session.close();
        }
        return HibernateIteratorUtils.unproxy(object);
    }
}

