/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.persistency.hibernate;

import com.gigaspaces.datasource.BulkDataPersister;
import com.gigaspaces.datasource.BulkItem;
import com.gigaspaces.datasource.DataIterator;
import com.gigaspaces.datasource.DataSourceException;
import com.gigaspaces.datasource.SQLDataProvider;
import com.j_spaces.core.client.SQLQuery;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.openspaces.persistency.hibernate.AbstractHibernateExternalDataSource;
import org.openspaces.persistency.hibernate.iterator.DefaultChunkListDataIterator;
import org.openspaces.persistency.hibernate.iterator.DefaultChunkScrollableDataIterator;
import org.openspaces.persistency.hibernate.iterator.DefaultListQueryDataIterator;
import org.openspaces.persistency.hibernate.iterator.DefaultScrollableDataIterator;
import org.openspaces.persistency.hibernate.iterator.HibernateProxyRemoverIterator;

@Deprecated
public class DefaultHibernateExternalDataSource
extends AbstractHibernateExternalDataSource
implements BulkDataPersister,
SQLDataProvider {
    private boolean useMerge = false;
    private boolean deleteById = true;

    public void setUseMerge(boolean useMerge) {
        this.useMerge = useMerge;
    }

    public void setDeleteById(boolean deleteById) {
        this.deleteById = deleteById;
    }

    public void executeBulk(List<BulkItem> bulkItems) throws DataSourceException {
        Session session = this.getSessionFactory().openSession();
        Transaction tr = session.beginTransaction();
        BulkItem latest = null;
        try {
            for (BulkItem bulkItem : bulkItems) {
                if (!this.isManaged(bulkItem)) continue;
                latest = bulkItem;
                switch (bulkItem.getOperation()) {
                    case 1: {
                        this.executeRemove(session, bulkItem);
                        break;
                    }
                    case 3: {
                        this.executeWrite(session, bulkItem);
                        break;
                    }
                    case 2: {
                        this.executeUpdate(session, bulkItem);
                        break;
                    }
                    case 4: {
                        this.executePartialUpdate(session, bulkItem);
                        break;
                    }
                }
            }
            tr.commit();
        }
        catch (Exception e) {
            this.rollbackTx(tr);
            throw new DataSourceException("Failed to execute bulk operation, latest object [" + latest + "]", (Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    private void executePartialUpdate(Session session, BulkItem bulkItem) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Partial Update Entry [" + bulkItem.toString() + ']'));
        }
        Map<String, Object> itemValues = this.filterItemValue(bulkItem.getTypeName(), bulkItem.getItemValues());
        String hql = this.getPartialUpdateHQL(bulkItem, itemValues);
        Query query = session.createQuery(hql);
        for (Map.Entry<String, Object> updateEntry : itemValues.entrySet()) {
            query.setParameter(updateEntry.getKey(), updateEntry.getValue());
        }
        query.setParameter("id_" + bulkItem.getIdPropertyName(), bulkItem.getIdPropertyValue());
        query.executeUpdate();
    }

    private void executeWrite(Session session, BulkItem bulkItem) {
        Object entry = bulkItem.getItem();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Write Entry [" + entry + ']'));
        }
        if (this.useMerge) {
            session.merge(entry);
        } else {
            try {
                session.saveOrUpdate(entry);
            }
            catch (HibernateException e) {
                session.merge(entry);
            }
        }
    }

    private void executeUpdate(Session session, BulkItem bulkItem) {
        Object entry = bulkItem.getItem();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Update Entry [" + entry + ']'));
        }
        if (this.useMerge) {
            session.merge(entry);
        } else {
            try {
                session.saveOrUpdate(entry);
            }
            catch (HibernateException e) {
                session.merge(entry);
            }
        }
    }

    private void executeRemove(Session session, BulkItem bulkItem) throws DataSourceException {
        block11: {
            Object entry = bulkItem.getItem();
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Deleting Entry [" + entry + ']'));
            }
            if (this.deleteById) {
                Serializable id = (Serializable)(bulkItem.supportsGetSpaceId() ? bulkItem.getSpaceId() : this.getIdentifier(entry));
                if (id == null) {
                    throw new DataSourceException("Object id is null. Make sure object space id and hibernate id are the same property.");
                }
                try {
                    Object toDelete = session.load(entry.getClass(), id);
                    if (toDelete != null) {
                        session.delete(toDelete);
                    }
                    break block11;
                }
                catch (ObjectNotFoundException e) {
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace((Object)("Delete Entry failed [" + entry + ']'), (Throwable)e);
                    }
                    break block11;
                }
            }
            if (this.useMerge) {
                session.delete(session.merge(entry));
            } else {
                try {
                    session.delete(entry);
                }
                catch (HibernateException e) {
                    session.delete(session.merge(entry));
                }
            }
        }
    }

    public DataIterator iterator(SQLQuery sqlQuery) throws DataSourceException {
        if (!this.isManagedEntry(sqlQuery.getTypeName()) && this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Ignoring query (no mapping in hibernate) [" + sqlQuery + ']'));
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Iterator over query [" + sqlQuery + ']'));
        }
        return new HibernateProxyRemoverIterator(new DefaultListQueryDataIterator(sqlQuery, this.getSessionFactory()));
    }

    public DataIterator initialLoad() throws DataSourceException {
        DataIterator[] iterators = new DataIterator[this.getInitialLoadEntries().length];
        int iteratorCounter = 0;
        for (String entityName : this.getInitialLoadEntries()) {
            if (this.getInitialLoadChunkSize() == -1) {
                if (this.isUseScrollableResultSet()) {
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace((Object)("Creating initial load scrollable iterator for entry [" + entityName + "]"));
                    }
                    iterators[iteratorCounter++] = new DefaultScrollableDataIterator(entityName, this.getSessionFactory(), this.getFetchSize(), this.isPerformOrderById());
                    continue;
                }
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("Creating initial load list iterator for entry [" + entityName + "]"));
                }
                iterators[iteratorCounter++] = new DefaultListQueryDataIterator(entityName, this.getSessionFactory());
                continue;
            }
            if (this.isUseScrollableResultSet()) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("Creating initial load chunk scrollable iterator for entry [" + entityName + "]"));
                }
                iterators[iteratorCounter++] = new DefaultChunkScrollableDataIterator(entityName, this.getSessionFactory(), this.getFetchSize(), this.isPerformOrderById(), this.getInitialLoadChunkSize());
                continue;
            }
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Creating initial load chunk list iterator for entry [" + entityName + "]"));
            }
            iterators[iteratorCounter++] = new DefaultChunkListDataIterator(entityName, this.getSessionFactory(), this.getFetchSize(), this.isPerformOrderById(), this.getInitialLoadChunkSize());
        }
        return this.createInitialLoadIterator(iterators);
    }

    private void rollbackTx(Transaction tr) {
        try {
            tr.rollback();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void closeSession(Session session) {
        if (session.isOpen()) {
            session.close();
        }
    }

    protected Serializable getIdentifier(Object o) {
        return this.getSessionFactory().getClassMetadata(o.getClass()).getIdentifier(o);
    }
}

