/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.persistency.hibernate;

import com.gigaspaces.datasource.DataIterator;
import com.gigaspaces.datasource.DataSourceQuery;
import com.gigaspaces.datasource.DataSourceSQLQuery;
import com.j_spaces.core.client.SQLQuery;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.hibernate.SessionFactory;
import org.openspaces.core.cluster.ClusterInfo;
import org.openspaces.persistency.hibernate.AbstractHibernateSpaceDataSource;
import org.openspaces.persistency.hibernate.iterator.DefaultChunkListDataIterator;
import org.openspaces.persistency.hibernate.iterator.DefaultChunkScrollableDataIterator;
import org.openspaces.persistency.hibernate.iterator.DefaultListQueryDataIterator;
import org.openspaces.persistency.hibernate.iterator.DefaultScrollableDataIterator;
import org.openspaces.persistency.hibernate.iterator.HibernateProxyRemoverIterator;

public class DefaultHibernateSpaceDataSource
extends AbstractHibernateSpaceDataSource {
    public DefaultHibernateSpaceDataSource(SessionFactory sessionFactory, Set<String> managedEntries, int fetchSize, boolean performOrderById, String[] initialLoadEntries, int initialLoadThreadPoolSize, int initialLoadChunkSize, boolean useScrollableResultSet, String[] initialLoadQueryScanningBasePackages, boolean augmentInitialLoadEntries, ClusterInfo clusterInfo) {
        super(sessionFactory, managedEntries, fetchSize, performOrderById, initialLoadEntries, initialLoadThreadPoolSize, initialLoadChunkSize, useScrollableResultSet, initialLoadQueryScanningBasePackages, augmentInitialLoadEntries, clusterInfo);
    }

    public DataIterator<Object> initialDataLoad() {
        LinkedList<Object> iterators = new LinkedList<Object>();
        this.obtainInitialLoadQueries();
        HashSet<Object> initialLoadTypes = new HashSet<Object>();
        initialLoadTypes.addAll(this.initialLoadQueries.keySet());
        initialLoadTypes.addAll(this.getInitialLoadEntries());
        for (String string : initialLoadTypes) {
            SQLQuery sqlQuery = null;
            String query = null;
            if (this.initialLoadQueries.containsKey(string)) {
                query = (String)this.initialLoadQueries.get(string);
                sqlQuery = new SQLQuery(string, query);
            }
            if (this.getInitialLoadChunkSize() == -1) {
                if (this.isUseScrollableResultSet()) {
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("Creating initial load scrollable iterator for entry [" + string + (query == null ? "]" : "], query: " + query)));
                    }
                    iterators.add(sqlQuery == null ? new DefaultScrollableDataIterator(string, this.getSessionFactory(), this.getFetchSize(), this.isPerformOrderById()) : new DefaultScrollableDataIterator(sqlQuery, this.getSessionFactory(), this.getFetchSize(), this.isPerformOrderById()));
                    continue;
                }
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Creating initial load list iterator for entry [" + string + (query == null ? "]" : "], query: " + query)));
                }
                iterators.add(sqlQuery == null ? new DefaultListQueryDataIterator(string, this.getSessionFactory()) : new DefaultListQueryDataIterator(sqlQuery, this.getSessionFactory()));
                continue;
            }
            if (this.isUseScrollableResultSet()) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Creating initial load chunk scrollable iterator for entry [" + string + (query == null ? "]" : "], query: " + query)));
                }
                iterators.add(sqlQuery == null ? new DefaultChunkScrollableDataIterator(string, this.getSessionFactory(), this.getFetchSize(), this.isPerformOrderById(), this.getInitialLoadChunkSize()) : new DefaultChunkScrollableDataIterator(sqlQuery, this.getSessionFactory(), this.getFetchSize(), this.isPerformOrderById(), this.getInitialLoadChunkSize()));
                continue;
            }
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Creating initial load chunk list iterator for entry [" + string + (query == null ? "]" : "], query: " + query)));
            }
            iterators.add(sqlQuery == null ? new DefaultChunkListDataIterator(string, this.getSessionFactory(), this.getFetchSize(), this.isPerformOrderById(), this.getInitialLoadChunkSize()) : new DefaultChunkListDataIterator(sqlQuery, this.getSessionFactory(), this.getFetchSize(), this.isPerformOrderById(), this.getInitialLoadChunkSize()));
        }
        DataIterator[] dataIterators = new DataIterator[iterators.size()];
        return this.createInitialLoadIterator(iterators.toArray(dataIterators));
    }

    public DataIterator<Object> getDataIterator(DataSourceQuery query) {
        if (!query.supportsAsSQLQuery()) {
            return null;
        }
        DataSourceSQLQuery sqlQuery = query.getAsSQLQuery();
        if (!this.isManagedEntry(query.getTypeDescriptor().getTypeName()) && logger.isTraceEnabled()) {
            logger.trace((Object)("Ignoring query (no mapping in hibernate) [" + sqlQuery + ']'));
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Iterator over query [" + sqlQuery + ']'));
        }
        return new HibernateProxyRemoverIterator(new DefaultListQueryDataIterator(sqlQuery, this.getSessionFactory()));
    }
}

