/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.persistency.hibernate;

import com.gigaspaces.datasource.DataSourceException;
import com.gigaspaces.document.SpaceDocument;
import com.gigaspaces.metadata.SpaceTypeDescriptor;
import com.gigaspaces.sync.DataSyncOperation;
import com.gigaspaces.sync.OperationsBatchData;
import com.gigaspaces.sync.SpaceSynchronizationEndpointException;
import com.gigaspaces.sync.TransactionData;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.openspaces.persistency.hibernate.AbstractHibernateSpaceSynchronizationEndpoint;

public class DefaultHibernateSpaceSynchronizationEndpoint
extends AbstractHibernateSpaceSynchronizationEndpoint {
    private final boolean useMerge;
    private final boolean deleteById;

    public DefaultHibernateSpaceSynchronizationEndpoint(SessionFactory sessionFactory, Set<String> managedEntries, boolean useMerge, boolean deleteById) {
        super(sessionFactory, managedEntries);
        this.useMerge = useMerge;
        this.deleteById = deleteById;
    }

    public void onTransactionSynchronization(TransactionData transactionData) {
        this.executeDataSyncOperations(transactionData.getTransactionParticipantDataItems());
    }

    public void onOperationsBatchSynchronization(OperationsBatchData batchData) {
        this.executeDataSyncOperations(batchData.getBatchDataItems());
    }

    private void executeDataSyncOperations(DataSyncOperation[] dataSyncOperations) {
        Session session = this.getSessionFactory().openSession();
        Transaction tr = session.beginTransaction();
        DataSyncOperation latest = null;
        try {
            block11: for (DataSyncOperation dataSyncOperation : dataSyncOperations) {
                if (!this.isManaged(dataSyncOperation)) continue;
                latest = dataSyncOperation;
                switch (dataSyncOperation.getDataSyncOperationType()) {
                    case REMOVE: {
                        this.executeRemove(session, dataSyncOperation);
                        continue block11;
                    }
                    case WRITE: {
                        this.executeWrite(session, dataSyncOperation);
                        continue block11;
                    }
                    case UPDATE: {
                        this.executeUpdate(session, dataSyncOperation);
                        continue block11;
                    }
                    case PARTIAL_UPDATE: {
                        this.executePartialUpdate(session, dataSyncOperation);
                        continue block11;
                    }
                }
            }
            tr.commit();
        }
        catch (Exception e) {
            this.rollbackTx(tr);
            throw new SpaceSynchronizationEndpointException("Failed to execute bulk operation, latest object [" + latest + "]", (Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    private void executePartialUpdate(Session session, DataSyncOperation dataSyncOperation) {
        if (!dataSyncOperation.supportsDataAsDocument() || !dataSyncOperation.supportsGetTypeDescriptor()) {
            return;
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Partial Update Entry [" + dataSyncOperation.toString() + ']'));
        }
        SpaceTypeDescriptor typeDescriptor = dataSyncOperation.getTypeDescriptor();
        String typeName = typeDescriptor.getTypeName();
        SpaceDocument spaceDocument = dataSyncOperation.getDataAsDocument();
        Map<String, Object> itemValues = this.filterItemValue(typeName, spaceDocument.getProperties());
        String hql = this.getPartialUpdateHQL(dataSyncOperation, itemValues);
        Query query = session.createQuery(hql);
        for (Map.Entry<String, Object> updateEntry : itemValues.entrySet()) {
            query.setParameter(updateEntry.getKey(), updateEntry.getValue());
        }
        query.setParameter("id_" + typeDescriptor.getIdPropertyName(), spaceDocument.getProperty(typeDescriptor.getIdPropertyName()));
        query.executeUpdate();
    }

    private void executeWrite(Session session, DataSyncOperation dataSyncOperation) {
        if (!dataSyncOperation.supportsDataAsObject()) {
            return;
        }
        Object entry = dataSyncOperation.getDataAsObject();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Write Entry [" + entry + ']'));
        }
        if (this.useMerge) {
            session.merge(entry);
        } else {
            try {
                session.saveOrUpdate(entry);
            }
            catch (HibernateException e) {
                session.merge(entry);
            }
        }
    }

    private void executeUpdate(Session session, DataSyncOperation dataSyncOperation) {
        if (!dataSyncOperation.supportsDataAsObject()) {
            return;
        }
        Object entry = dataSyncOperation.getDataAsObject();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Update Entry [" + entry + ']'));
        }
        if (this.useMerge) {
            session.merge(entry);
        } else {
            try {
                session.saveOrUpdate(entry);
            }
            catch (HibernateException e) {
                session.merge(entry);
            }
        }
    }

    private void executeRemove(Session session, DataSyncOperation dataSyncOperation) throws DataSourceException {
        block12: {
            if (!dataSyncOperation.supportsDataAsObject()) {
                return;
            }
            Object entry = dataSyncOperation.getDataAsObject();
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Deleting Entry [" + entry + ']'));
            }
            if (this.deleteById) {
                Serializable id = (Serializable)(dataSyncOperation.supportsGetSpaceId() ? dataSyncOperation.getSpaceId() : this.getIdentifier(entry));
                if (id == null) {
                    throw new DataSourceException("Object id is null. Make sure object space id and hibernate id are the same property.");
                }
                try {
                    Object toDelete = session.load(entry.getClass(), id);
                    if (toDelete != null) {
                        session.delete(toDelete);
                    }
                    break block12;
                }
                catch (ObjectNotFoundException e) {
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("Delete Entry failed [" + entry + ']'), (Throwable)e);
                    }
                    break block12;
                }
            }
            if (this.useMerge) {
                session.delete(session.merge(entry));
            } else {
                try {
                    session.delete(entry);
                }
                catch (HibernateException e) {
                    session.delete(session.merge(entry));
                }
            }
        }
    }

    private void closeSession(Session session) {
        if (session.isOpen()) {
            session.close();
        }
    }

    protected Serializable getIdentifier(Object o) {
        return this.getSessionFactory().getClassMetadata(o.getClass()).getIdentifier(o);
    }
}

