/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.persistency.hibernate;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.SessionFactory;

public class ManagedEntitiesContainer {
    protected static final Log logger = LogFactory.getLog(ManagedEntitiesContainer.class);
    private final Set<String> managedEntries;

    public ManagedEntitiesContainer(SessionFactory sessionFactory, Set<String> managedEntries) {
        this.managedEntries = ManagedEntitiesContainer.createManagedEntries(managedEntries, sessionFactory);
    }

    private static Set<String> createManagedEntries(Set<String> managedEntries, SessionFactory sessionFactory) {
        if (managedEntries == null) {
            managedEntries = new HashSet<String>();
            Map allClassMetaData = sessionFactory.getAllClassMetadata();
            for (String entityname : allClassMetaData.keySet()) {
                managedEntries.add(entityname);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Using Hibernate managedEntries [" + managedEntries + "]"));
        }
        return managedEntries;
    }

    public boolean isManagedEntry(String entityName) {
        return this.managedEntries.contains(entityName);
    }

    public Iterable<String> getManagedEntries() {
        return this.managedEntries;
    }
}

