/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.persistency.hibernate;

import com.j_spaces.kernel.ClassLoaderHelper;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.hibernate.SessionFactory;
import org.hibernate.boot.model.naming.ImplicitNamingStrategy;
import org.hibernate.boot.model.naming.PhysicalNamingStrategy;
import org.hibernate.cfg.Configuration;

@Deprecated
public class SessionFactoryBuilder {
    private static final String HIBERNATE_IMPLICIT_NAMING_STRATEGY = "hibernate.implicit_naming_strategy";
    private static final String HIBERNATE_PHYSICAL_NAMING_STRATEGY = "hibernate.physical_naming_strategy";
    private static final String HIBERNATE_NAMING_STRATEGY = "hibernate.naming_strategy";
    private static final String ANNOTATION_CONFIGURATION_CLASS = "org.hibernate.cfg.AnnotationConfiguration";
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.persistent");

    public static SessionFactory getFactory(String hibernateFile) throws Exception {
        String implicitNamingStrategyClass;
        String physicalNamingStrategyClass;
        Configuration config = null;
        try {
            config = SessionFactoryBuilder.configure((Configuration)ClassLoaderHelper.loadClass((String)ANNOTATION_CONFIGURATION_CLASS).newInstance(), hibernateFile);
        }
        catch (Throwable t) {
            try {
                config = SessionFactoryBuilder.configure(new Configuration(), hibernateFile);
            }
            catch (Exception e) {
                if (_logger.isLoggable(Level.SEVERE)) {
                    _logger.log(Level.SEVERE, "Failed to configure using hibernate annotations.", t);
                }
                throw e;
            }
        }
        String namingStrategyClass = config.getProperty(HIBERNATE_NAMING_STRATEGY);
        if (namingStrategyClass != null) {
            _logger.log(Level.WARNING, "Definition of naming strategy [hibernate.naming_strategy] found, it's unsupported since hibernate 5.x used, please use instead either [hibernate.implicit_naming_strategy] or [hibernate.physical_naming_strategy]");
        }
        if ((physicalNamingStrategyClass = config.getProperty(HIBERNATE_PHYSICAL_NAMING_STRATEGY)) != null) {
            PhysicalNamingStrategy physicalNamingStrategy = (PhysicalNamingStrategy)ClassLoaderHelper.loadClass((String)physicalNamingStrategyClass).newInstance();
            config.setPhysicalNamingStrategy(physicalNamingStrategy);
        }
        if ((implicitNamingStrategyClass = config.getProperty(HIBERNATE_IMPLICIT_NAMING_STRATEGY)) != null) {
            ImplicitNamingStrategy implicitNamingStrategy = (ImplicitNamingStrategy)ClassLoaderHelper.loadClass((String)implicitNamingStrategyClass).newInstance();
            config.setImplicitNamingStrategy(implicitNamingStrategy);
        }
        return config.buildSessionFactory();
    }

    private static Configuration configure(Configuration config, String hibernateFile) {
        if (hibernateFile == null) {
            return config.configure();
        }
        return config.configure(hibernateFile);
    }
}

