/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.persistency.hibernate;

import com.gigaspaces.datasource.BulkDataPersister;
import com.gigaspaces.datasource.BulkItem;
import com.gigaspaces.datasource.DataIterator;
import com.gigaspaces.datasource.DataSourceException;
import com.gigaspaces.datasource.SQLDataProvider;
import com.j_spaces.core.client.SQLQuery;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.StatelessSession;
import org.hibernate.Transaction;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.metadata.ClassMetadata;
import org.openspaces.persistency.hibernate.AbstractHibernateExternalDataSource;
import org.openspaces.persistency.hibernate.iterator.HibernateProxyRemoverIterator;
import org.openspaces.persistency.hibernate.iterator.StatelessChunkListDataIterator;
import org.openspaces.persistency.hibernate.iterator.StatelessChunkScrollableDataIterator;
import org.openspaces.persistency.hibernate.iterator.StatelessListQueryDataIterator;
import org.openspaces.persistency.hibernate.iterator.StatelessScrollableDataIterator;

public class StatelessHibernateExternalDataSource
extends AbstractHibernateExternalDataSource
implements BulkDataPersister,
SQLDataProvider {
    private Log batchingLogger = LogFactory.getLog((String)"org.hibernate.jdbc.BatchingBatcher");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeBulk(List<BulkItem> bulkItems) throws DataSourceException {
        StatelessSession session = this.getSessionFactory().openStatelessSession();
        Transaction tr = session.beginTransaction();
        DataSourceException batchModeException = null;
        try {
            for (BulkItem bulkItem : bulkItems) {
                if (!this.isManaged(bulkItem)) continue;
                switch (bulkItem.getOperation()) {
                    case 1: {
                        this.executeRemove(session, bulkItem);
                        break;
                    }
                    case 3: {
                        this.executeWrite(session, bulkItem);
                        break;
                    }
                    case 2: {
                        this.executeUpdate(session, bulkItem);
                        break;
                    }
                    case 4: {
                        this.executePartialUpdate(session, bulkItem);
                        break;
                    }
                }
            }
            tr.commit();
        }
        catch (Exception e) {
            this.rollbackTx(tr);
            batchModeException = new DataSourceException("Failed to execute bulk operation in batch mode", (Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
        if (batchModeException == null) {
            return;
        }
        this.batchingLogger.error((Object)"Ignoring Hibernate StaleStateException, trying with exists batching");
        BulkItem latest = null;
        session = this.getSessionFactory().openStatelessSession();
        tr = session.beginTransaction();
        try {
            for (BulkItem bulkItem : bulkItems) {
                if (!this.isManaged(bulkItem)) continue;
                latest = bulkItem;
                switch (bulkItem.getOperation()) {
                    case 1: {
                        this.executeRemoveIfExists(session, bulkItem);
                        break;
                    }
                    case 3: {
                        this.executeWriteIfExists(session, bulkItem);
                        break;
                    }
                    case 2: {
                        this.executeUpdateIfExists(session, bulkItem);
                        break;
                    }
                    case 4: {
                        this.executePartialUpdateIfExists(session, bulkItem);
                    }
                }
            }
            tr.commit();
        }
        catch (Exception exception) {
            this.rollbackTx(tr);
            throw new DataSourceException("Failed to execute bulk operation, latest object [" + latest + "]", (Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    private void executePartialUpdateIfExists(StatelessSession session, BulkItem bulkItem) {
        if (this.exists(bulkItem, session)) {
            this.executePartialUpdate(session, bulkItem);
        }
    }

    private void executeWriteIfExists(StatelessSession session, BulkItem bulkItem) {
        Object entry = bulkItem.getItem();
        if (this.exists(bulkItem, session)) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("[Exists WRITE] Update Entry [" + entry + "]"));
            }
            session.update(entry);
        } else {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("[Exists WRITE] Insert Entry [" + entry + "]"));
            }
            session.insert(entry);
        }
    }

    private void executeUpdateIfExists(StatelessSession session, BulkItem bulkItem) {
        Object entry = bulkItem.getItem();
        if (this.exists(bulkItem, session)) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("[Exists UPDATE] Update Entry [" + entry + "]"));
            }
            session.update(entry);
        } else {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("[Exists UPDATE] Insert Entry [" + entry + "]"));
            }
            session.insert(entry);
        }
    }

    private void executeRemoveIfExists(StatelessSession session, BulkItem bulkItem) {
        Object entry = bulkItem.getItem();
        if (this.exists(bulkItem, session)) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("[Exists REMOVE] Deleting Entry [" + entry + "]"));
            }
            session.delete(entry);
        }
    }

    private void executeUpdate(StatelessSession session, BulkItem bulkItem) {
        Object entry = bulkItem.getItem();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("[Optimistic UPDATE] Update Entry [" + entry + "]"));
        }
        session.update(entry);
    }

    private void executeWrite(StatelessSession session, BulkItem bulkItem) {
        Object entry = bulkItem.getItem();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("[Optimistic WRITE] Write Entry [" + entry + "]"));
        }
        session.insert(entry);
    }

    private void executeRemove(StatelessSession session, BulkItem bulkItem) {
        Object entry = bulkItem.getItem();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("[Optimistic REMOVE] Deleting Entry [" + entry + "]"));
        }
        session.delete(entry);
    }

    private void executePartialUpdate(StatelessSession session, BulkItem bulkItem) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Partial Update Entry [" + bulkItem.toString() + "]"));
        }
        Map<String, Object> itemValues = this.filterItemValue(bulkItem.getTypeName(), bulkItem.getItemValues());
        String hql = this.getPartialUpdateHQL(bulkItem, itemValues);
        Query query = session.createQuery(hql);
        for (Map.Entry<String, Object> updateEntry : itemValues.entrySet()) {
            query.setParameter(updateEntry.getKey(), updateEntry.getValue());
        }
        query.setParameter("id_" + bulkItem.getIdPropertyName(), bulkItem.getIdPropertyValue());
        query.executeUpdate();
    }

    public DataIterator iterator(SQLQuery sqlQuery) throws DataSourceException {
        if (!this.isManagedEntry(sqlQuery.getTypeName()) && this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Ignoring query (no mapping in hibernate) [" + sqlQuery + "]"));
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Iterator over query [" + sqlQuery + "]"));
        }
        return new HibernateProxyRemoverIterator(new StatelessListQueryDataIterator(sqlQuery, this.getSessionFactory()));
    }

    public DataIterator initialLoad() throws DataSourceException {
        DataIterator[] iterators = new DataIterator[this.getInitialLoadEntries().length];
        int iteratorCounter = 0;
        for (String entityName : this.getInitialLoadEntries()) {
            if (this.getInitialLoadChunkSize() == -1) {
                if (this.isUseScrollableResultSet()) {
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace((Object)("Creating initial load scrollable iterator for entry [" + entityName + "]"));
                    }
                    iterators[iteratorCounter++] = new StatelessScrollableDataIterator(entityName, this.getSessionFactory(), this.getFetchSize(), this.isPerformOrderById());
                    continue;
                }
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("Creating initial load list iterator for entry [" + entityName + "]"));
                }
                iterators[iteratorCounter++] = new StatelessListQueryDataIterator(entityName, this.getSessionFactory());
                continue;
            }
            if (this.isUseScrollableResultSet()) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("Creating initial load chunk scrollable iterator for entry [" + entityName + "]"));
                }
                iterators[iteratorCounter++] = new StatelessChunkScrollableDataIterator(entityName, this.getSessionFactory(), this.getFetchSize(), this.isPerformOrderById(), this.getInitialLoadChunkSize());
                continue;
            }
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Creating initial load chunk list iterator for entry [" + entityName + "]"));
            }
            iterators[iteratorCounter++] = new StatelessChunkListDataIterator(entityName, this.getSessionFactory(), this.getFetchSize(), this.isPerformOrderById(), this.getInitialLoadChunkSize());
        }
        return this.createInitialLoadIterator(iterators);
    }

    protected boolean exists(BulkItem bulkItem, StatelessSession session) {
        Criteria criteria = null;
        switch (bulkItem.getOperation()) {
            case 1: 
            case 2: 
            case 3: {
                Object entry = bulkItem.getItem();
                criteria = session.createCriteria(entry.getClass().getName());
                ClassMetadata classMetaData = this.getSessionFactory().getClassMetadata(entry.getClass());
                criteria.add(Restrictions.idEq((Object)classMetaData.getIdentifier(entry)));
                criteria.setProjection(Projections.rowCount());
                return ((Number)criteria.uniqueResult()).intValue() > 0;
            }
            case 4: {
                criteria = session.createCriteria(bulkItem.getTypeName());
                criteria.add(Restrictions.idEq((Object)bulkItem.getIdPropertyValue()));
                criteria.setProjection(Projections.rowCount());
                return ((Number)criteria.uniqueResult()).intValue() > 0;
            }
        }
        return false;
    }

    private void rollbackTx(Transaction tr) {
        try {
            tr.rollback();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void closeSession(StatelessSession session) {
        session.close();
    }
}

