/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.persistency.hibernate;

import com.gigaspaces.datasource.DataIterator;
import com.gigaspaces.datasource.DataSourceQuery;
import com.gigaspaces.datasource.DataSourceSQLQuery;
import java.util.Set;
import org.hibernate.SessionFactory;
import org.openspaces.core.cluster.ClusterInfo;
import org.openspaces.persistency.hibernate.AbstractHibernateSpaceDataSource;
import org.openspaces.persistency.hibernate.iterator.HibernateProxyRemoverIterator;
import org.openspaces.persistency.hibernate.iterator.StatelessChunkListDataIterator;
import org.openspaces.persistency.hibernate.iterator.StatelessChunkScrollableDataIterator;
import org.openspaces.persistency.hibernate.iterator.StatelessListQueryDataIterator;
import org.openspaces.persistency.hibernate.iterator.StatelessScrollableDataIterator;

public class StatelessHibernateSpaceDataSource
extends AbstractHibernateSpaceDataSource {
    public StatelessHibernateSpaceDataSource(SessionFactory sessionFactory, Set<String> managedEntries, int fetchSize, boolean performOrderById, String[] initialLoadEntries, int initialLoadThreadPoolSize, int initialLoadChunkSize, boolean useScrollableResultSet, String[] initialLoadQueryScanningBasePackages, boolean augmentInitialLoadEntries, ClusterInfo clusterInfo) {
        super(sessionFactory, managedEntries, fetchSize, performOrderById, initialLoadEntries, initialLoadThreadPoolSize, initialLoadChunkSize, useScrollableResultSet, initialLoadQueryScanningBasePackages, augmentInitialLoadEntries, clusterInfo);
    }

    public DataIterator initialDataLoad() {
        DataIterator[] iterators = new DataIterator[this.getInitialLoadEntries().size()];
        int iteratorCounter = 0;
        for (String entityName : this.getInitialLoadEntries()) {
            if (this.getInitialLoadChunkSize() == -1) {
                if (this.isUseScrollableResultSet()) {
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("Creating initial load scrollable iterator for entry [" + entityName + "]"));
                    }
                    iterators[iteratorCounter++] = new StatelessScrollableDataIterator(entityName, this.getSessionFactory(), this.getFetchSize(), this.isPerformOrderById());
                    continue;
                }
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Creating initial load list iterator for entry [" + entityName + "]"));
                }
                iterators[iteratorCounter++] = new StatelessListQueryDataIterator(entityName, this.getSessionFactory());
                continue;
            }
            if (this.isUseScrollableResultSet()) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Creating initial load chunk scrollable iterator for entry [" + entityName + "]"));
                }
                iterators[iteratorCounter++] = new StatelessChunkScrollableDataIterator(entityName, this.getSessionFactory(), this.getFetchSize(), this.isPerformOrderById(), this.getInitialLoadChunkSize());
                continue;
            }
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Creating initial load chunk list iterator for entry [" + entityName + "]"));
            }
            iterators[iteratorCounter++] = new StatelessChunkListDataIterator(entityName, this.getSessionFactory(), this.getFetchSize(), this.isPerformOrderById(), this.getInitialLoadChunkSize());
        }
        return this.createInitialLoadIterator(iterators);
    }

    public DataIterator getDataIterator(DataSourceQuery query) {
        if (!query.supportsAsSQLQuery()) {
            return null;
        }
        DataSourceSQLQuery sqlQuery = query.getAsSQLQuery();
        if (!this.isManagedEntry(query.getTypeDescriptor().getTypeName()) && logger.isTraceEnabled()) {
            logger.trace((Object)("Ignoring query (no mapping in hibernate) [" + sqlQuery + ']'));
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Iterator over query [" + sqlQuery + ']'));
        }
        return new HibernateProxyRemoverIterator(new StatelessListQueryDataIterator(sqlQuery, this.getSessionFactory()));
    }
}

