/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.persistency.hibernate;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.SessionFactory;
import org.openspaces.core.cluster.ClusterInfo;
import org.openspaces.persistency.hibernate.StatelessHibernateSpaceDataSource;

public class StatelessHibernateSpaceDataSourceConfigurer {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected SessionFactory sessionFactory;
    protected Set<String> managedEntries;
    protected String[] initialLoadEntries;
    protected int fetchSize = 100;
    protected int initialLoadThreadPoolSize = 10;
    protected int initialLoadChunkSize = 100000;
    protected boolean performOrderById = true;
    protected boolean useScrollableResultSet = true;
    protected boolean augmentInitialLoadEntries = true;
    protected String[] initialLoadQueryScanningBasePackages;
    protected ClusterInfo clusterInfo;

    public StatelessHibernateSpaceDataSourceConfigurer sessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
        return this;
    }

    public StatelessHibernateSpaceDataSourceConfigurer managedEntries(String ... entries) {
        this.managedEntries = new HashSet<String>();
        this.managedEntries.addAll(Arrays.asList(entries));
        return this;
    }

    public StatelessHibernateSpaceDataSourceConfigurer fetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
        return this;
    }

    public StatelessHibernateSpaceDataSourceConfigurer performOrderById(boolean performOrderById) {
        this.performOrderById = performOrderById;
        return this;
    }

    public StatelessHibernateSpaceDataSourceConfigurer initialLoadEntries(String ... initialLoadEntries) {
        this.initialLoadEntries = initialLoadEntries;
        return this;
    }

    public StatelessHibernateSpaceDataSourceConfigurer initialLoadThreadPoolSize(int initialLoadThreadPoolSize) {
        this.initialLoadThreadPoolSize = initialLoadThreadPoolSize;
        return this;
    }

    public StatelessHibernateSpaceDataSourceConfigurer initialLoadChunkSize(int initalLoadChunkSize) {
        this.initialLoadChunkSize = initalLoadChunkSize;
        return this;
    }

    public StatelessHibernateSpaceDataSourceConfigurer useScrollableResultSet(boolean useScrollableResultSet) {
        this.useScrollableResultSet = useScrollableResultSet;
        return this;
    }

    public StatelessHibernateSpaceDataSourceConfigurer initialLoadQueryScanningBasePackages(String[] initialLoadQueryScanningBasePackages) {
        this.initialLoadQueryScanningBasePackages = initialLoadQueryScanningBasePackages;
        return this;
    }

    public StatelessHibernateSpaceDataSourceConfigurer clusterInfo(ClusterInfo clusterInfo) {
        this.clusterInfo = clusterInfo;
        return this;
    }

    public StatelessHibernateSpaceDataSourceConfigurer augmentInitialLoadEntries(boolean augmentInitialLoadEntries) {
        this.augmentInitialLoadEntries = augmentInitialLoadEntries;
        return this;
    }

    public StatelessHibernateSpaceDataSource create() {
        return new StatelessHibernateSpaceDataSource(this.sessionFactory, this.managedEntries, this.fetchSize, this.performOrderById, this.initialLoadEntries, this.initialLoadThreadPoolSize, this.initialLoadChunkSize, this.useScrollableResultSet, this.initialLoadQueryScanningBasePackages, this.augmentInitialLoadEntries, this.clusterInfo);
    }
}

