/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.persistency.hibernate;

import com.gigaspaces.datasource.DataSourceException;
import com.gigaspaces.document.SpaceDocument;
import com.gigaspaces.metadata.SpaceTypeDescriptor;
import com.gigaspaces.sync.DataSyncOperation;
import com.gigaspaces.sync.OperationsBatchData;
import com.gigaspaces.sync.SpaceSynchronizationEndpointException;
import com.gigaspaces.sync.TransactionData;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.hibernate.StatelessSession;
import org.hibernate.Transaction;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.metadata.ClassMetadata;
import org.openspaces.persistency.hibernate.AbstractHibernateSpaceSynchronizationEndpoint;

public class StatelessHibernateSpaceSynchronizationEndpoint
extends AbstractHibernateSpaceSynchronizationEndpoint {
    private static final Log batchingLogger = LogFactory.getLog((String)"org.hibernate.jdbc.BatchingBatcher");

    public StatelessHibernateSpaceSynchronizationEndpoint(SessionFactory sessionFactory, Set<String> managedEntries) {
        super(sessionFactory, managedEntries);
    }

    public void onTransactionSynchronization(TransactionData transactionData) {
        this.executeDataSyncOperations(transactionData.getTransactionParticipantDataItems());
    }

    public void onOperationsBatchSynchronization(OperationsBatchData batchData) {
        this.executeDataSyncOperations(batchData.getBatchDataItems());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeDataSyncOperations(DataSyncOperation[] dataSyncOperations) {
        StatelessSession session = this.getSessionFactory().openStatelessSession();
        Transaction tr = session.beginTransaction();
        DataSourceException batchModeException = null;
        try {
            block22: for (DataSyncOperation dataSyncOperation : dataSyncOperations) {
                if (!this.isManaged(dataSyncOperation)) continue;
                switch (dataSyncOperation.getDataSyncOperationType()) {
                    case REMOVE: {
                        this.executeRemove(session, dataSyncOperation);
                        continue block22;
                    }
                    case WRITE: {
                        this.executeWrite(session, dataSyncOperation);
                        continue block22;
                    }
                    case UPDATE: {
                        this.executeUpdate(session, dataSyncOperation);
                        continue block22;
                    }
                    case PARTIAL_UPDATE: {
                        this.executePartialUpdate(session, dataSyncOperation);
                        continue block22;
                    }
                }
            }
            tr.commit();
        }
        catch (Exception e) {
            this.rollbackTx(tr);
            batchModeException = new DataSourceException("Failed to execute bulk operation in batch mode", (Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
        if (batchModeException == null) {
            return;
        }
        batchingLogger.error((Object)"Ignoring Hibernate StaleStateException, trying with exists batching");
        DataSyncOperation latest = null;
        session = this.getSessionFactory().openStatelessSession();
        tr = session.beginTransaction();
        try {
            block23: for (DataSyncOperation dataSyncOperation : dataSyncOperations) {
                if (!this.isManaged(dataSyncOperation)) continue;
                latest = dataSyncOperation;
                switch (dataSyncOperation.getDataSyncOperationType()) {
                    case REMOVE: {
                        this.executeRemoveIfExists(session, dataSyncOperation);
                        continue block23;
                    }
                    case WRITE: {
                        this.executeWriteIfExists(session, dataSyncOperation);
                        continue block23;
                    }
                    case UPDATE: {
                        this.executeUpdateIfExists(session, dataSyncOperation);
                        continue block23;
                    }
                    case PARTIAL_UPDATE: {
                        this.executePartialUpdateIfExists(session, dataSyncOperation);
                    }
                }
            }
            tr.commit();
        }
        catch (Exception e) {
            this.rollbackTx(tr);
            throw new SpaceSynchronizationEndpointException("Failed to execute bulk operation, latest object [" + latest + "]", (Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    private void executePartialUpdateIfExists(StatelessSession session, DataSyncOperation dataSyncOperation) {
        if (this.exists(dataSyncOperation, session)) {
            this.executePartialUpdate(session, dataSyncOperation);
        }
    }

    private void executeWriteIfExists(StatelessSession session, DataSyncOperation dataSyncOperation) {
        if (!dataSyncOperation.supportsDataAsObject()) {
            return;
        }
        Object entry = dataSyncOperation.getDataAsObject();
        if (this.exists(dataSyncOperation, session)) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("[Exists WRITE] Update Entry [" + entry + "]"));
            }
            session.update(entry);
        } else {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("[Exists WRITE] Insert Entry [" + entry + "]"));
            }
            session.insert(entry);
        }
    }

    private void executeUpdateIfExists(StatelessSession session, DataSyncOperation dataSyncOperation) {
        if (!dataSyncOperation.supportsDataAsObject()) {
            return;
        }
        Object entry = dataSyncOperation.getDataAsObject();
        if (this.exists(dataSyncOperation, session)) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("[Exists UPDATE] Update Entry [" + entry + "]"));
            }
            session.update(entry);
        } else {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("[Exists UPDATE] Insert Entry [" + entry + "]"));
            }
            session.insert(entry);
        }
    }

    private void executeRemoveIfExists(StatelessSession session, DataSyncOperation dataSyncOperation) {
        if (!dataSyncOperation.supportsDataAsObject()) {
            return;
        }
        Object entry = dataSyncOperation.getDataAsObject();
        if (this.exists(dataSyncOperation, session)) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("[Exists REMOVE] Deleting Entry [" + entry + "]"));
            }
            session.delete(entry);
        }
    }

    private void executeUpdate(StatelessSession session, DataSyncOperation dataSyncOperation) {
        if (!dataSyncOperation.supportsDataAsObject()) {
            return;
        }
        Object entry = dataSyncOperation.getDataAsObject();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("[Optimistic UPDATE] Update Entry [" + entry + "]"));
        }
        session.update(entry);
    }

    private void executeWrite(StatelessSession session, DataSyncOperation dataSyncOperation) {
        if (!dataSyncOperation.supportsDataAsObject()) {
            return;
        }
        Object entry = dataSyncOperation.getDataAsObject();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("[Optimistic WRITE] Write Entry [" + entry + "]"));
        }
        session.insert(entry);
    }

    private void executeRemove(StatelessSession session, DataSyncOperation dataSyncOperation) {
        if (!dataSyncOperation.supportsDataAsObject()) {
            return;
        }
        Object entry = dataSyncOperation.getDataAsObject();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("[Optimistic REMOVE] Deleting Entry [" + entry + "]"));
        }
        session.delete(entry);
    }

    private void executePartialUpdate(StatelessSession session, DataSyncOperation dataSyncOperation) {
        if (!dataSyncOperation.supportsDataAsDocument() || !dataSyncOperation.supportsGetTypeDescriptor()) {
            return;
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Partial Update Entry [" + dataSyncOperation.toString() + ']'));
        }
        SpaceTypeDescriptor typeDescriptor = dataSyncOperation.getTypeDescriptor();
        String typeName = typeDescriptor.getTypeName();
        SpaceDocument spaceDocument = dataSyncOperation.getDataAsDocument();
        Map<String, Object> itemValues = this.filterItemValue(typeName, spaceDocument.getProperties());
        String hql = this.getPartialUpdateHQL(dataSyncOperation, itemValues);
        Query query = session.createQuery(hql);
        for (Map.Entry<String, Object> updateEntry : itemValues.entrySet()) {
            query.setParameter(updateEntry.getKey(), updateEntry.getValue());
        }
        query.setParameter("id_" + typeDescriptor.getIdPropertyName(), spaceDocument.getProperty(typeDescriptor.getIdPropertyName()));
        query.executeUpdate();
    }

    private void closeSession(StatelessSession session) {
        session.close();
    }

    private boolean exists(DataSyncOperation dataSyncOperation, StatelessSession session) {
        Criteria criteria = null;
        switch (dataSyncOperation.getDataSyncOperationType()) {
            case REMOVE: 
            case WRITE: 
            case UPDATE: {
                if (!dataSyncOperation.supportsDataAsObject()) {
                    return false;
                }
                Object entry = dataSyncOperation.getDataAsObject();
                criteria = session.createCriteria(entry.getClass().getName());
                ClassMetadata classMetaData = this.getSessionFactory().getClassMetadata(entry.getClass());
                criteria.add(Restrictions.idEq((Object)classMetaData.getIdentifier(entry)));
                criteria.setProjection(Projections.rowCount());
                return ((Number)criteria.uniqueResult()).intValue() > 0;
            }
            case PARTIAL_UPDATE: {
                if (!dataSyncOperation.supportsGetTypeDescriptor()) {
                    return false;
                }
                SpaceTypeDescriptor typeDescriptor = dataSyncOperation.getTypeDescriptor();
                criteria = session.createCriteria(typeDescriptor.getTypeName());
                criteria.add(Restrictions.idEq((Object)typeDescriptor.getIdPropertyName()));
                criteria.setProjection(Projections.rowCount());
                return ((Number)criteria.uniqueResult()).intValue() > 0;
            }
        }
        return false;
    }
}

