/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.persistency.hibernate.iterator;

import com.gigaspaces.datasource.DataIterator;
import com.j_spaces.core.client.SQLQuery;
import java.util.ArrayList;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.criterion.Projections;
import org.openspaces.persistency.support.ConcurrentMultiDataIterator;
import org.openspaces.persistency.support.MultiDataIterator;
import org.openspaces.persistency.support.SerialMultiDataIterator;

public abstract class AbstractChunkDataIterator
implements MultiDataIterator {
    protected final String entityName;
    protected final SQLQuery sqlQuery;
    protected final String hQuery;
    protected final SessionFactory sessionFactory;
    protected final boolean perfromOrderById;
    protected final int fetchSize;
    protected final int chunkSize;
    private DataIterator[] iterators;
    private MultiDataIterator multiDataIterator;

    public AbstractChunkDataIterator(String entityName, SessionFactory sessionFactory, int fetchSize, boolean performOrderById, int chunkSize) {
        this.entityName = entityName;
        this.sqlQuery = null;
        this.hQuery = null;
        this.sessionFactory = sessionFactory;
        this.fetchSize = fetchSize;
        this.perfromOrderById = performOrderById;
        this.chunkSize = chunkSize;
    }

    public AbstractChunkDataIterator(SQLQuery sqlQuery, SessionFactory sessionFactory, int fetchSize, boolean performOrderById, int chunkSize) {
        this.sqlQuery = sqlQuery;
        this.entityName = null;
        this.hQuery = null;
        this.sessionFactory = sessionFactory;
        this.fetchSize = fetchSize;
        this.perfromOrderById = performOrderById;
        this.chunkSize = chunkSize;
    }

    public AbstractChunkDataIterator(String hQuery, SessionFactory sessionFactory, int fetchSize, int chunkSize) {
        this.sqlQuery = null;
        this.entityName = null;
        this.hQuery = hQuery;
        this.sessionFactory = sessionFactory;
        this.fetchSize = fetchSize;
        this.perfromOrderById = false;
        this.chunkSize = chunkSize;
    }

    public DataIterator[] iterators() {
        this.initIterators();
        return this.iterators;
    }

    public boolean hasNext() {
        this.initIterators();
        if (this.multiDataIterator == null) {
            this.multiDataIterator = this.iterators.length == 1 ? new SerialMultiDataIterator(this.iterators) : new ConcurrentMultiDataIterator(this.iterators, 10);
        }
        return this.multiDataIterator.hasNext();
    }

    public Object next() {
        return this.multiDataIterator.next();
    }

    public void remove() {
        this.multiDataIterator.remove();
    }

    public void close() {
        if (this.multiDataIterator != null) {
            try {
                this.multiDataIterator.close();
            }
            finally {
                this.multiDataIterator = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initIterators() {
        if (this.iterators == null) {
            ArrayList<DataIterator> itList = new ArrayList<DataIterator>();
            Session session = this.sessionFactory.openSession();
            Transaction transaction = session.beginTransaction();
            try {
                int count = -1;
                if (this.entityName != null) {
                    Criteria criteria = session.createCriteria(this.entityName);
                    criteria.setProjection(Projections.rowCount());
                    try {
                        Number result = null;
                        if (null != criteria) {
                            result = (Number)criteria.uniqueResult();
                        }
                        count = result == null ? -1 : result.intValue();
                    }
                    catch (HibernateException e) {
                        count = -1;
                    }
                }
                if (count != -1) {
                    for (int from = 0; from < count; from += this.chunkSize) {
                        if (this.entityName != null) {
                            itList.add(this.createIteratorByEntityName(this.entityName, this.sessionFactory, this.fetchSize, this.perfromOrderById, from, this.chunkSize));
                            continue;
                        }
                        if (this.sqlQuery != null) {
                            itList.add(this.createIteratorBySQLQuery(this.sqlQuery, this.sessionFactory, this.fetchSize, this.perfromOrderById, from, this.chunkSize));
                            continue;
                        }
                        if (this.hQuery == null) continue;
                        itList.add(this.createIteratorByHibernateQuery(this.hQuery, this.sessionFactory, this.fetchSize, from, this.chunkSize));
                    }
                } else if (this.entityName != null) {
                    itList.add(this.createIteratorByEntityName(this.entityName, this.sessionFactory, this.fetchSize, this.perfromOrderById, -1, -1));
                } else if (this.sqlQuery != null) {
                    itList.add(this.createIteratorBySQLQuery(this.sqlQuery, this.sessionFactory, this.fetchSize, this.perfromOrderById, -1, -1));
                } else if (this.hQuery != null) {
                    itList.add(this.createIteratorByHibernateQuery(this.hQuery, this.sessionFactory, this.fetchSize, -1, -1));
                }
                this.iterators = itList.toArray(new DataIterator[itList.size()]);
            }
            finally {
                transaction.commit();
                session.close();
            }
        }
    }

    protected abstract DataIterator createIteratorByEntityName(String var1, SessionFactory var2, int var3, boolean var4, int var5, int var6);

    protected abstract DataIterator createIteratorBySQLQuery(SQLQuery var1, SessionFactory var2, int var3, boolean var4, int var5, int var6);

    protected abstract DataIterator createIteratorByHibernateQuery(String var1, SessionFactory var2, int var3, int var4, int var5);
}

