/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.persistency.hibernate.iterator;

import com.gigaspaces.datasource.DataIterator;
import com.j_spaces.core.client.SQLQuery;
import org.hibernate.ScrollableResults;
import org.hibernate.SessionFactory;

public abstract class AbstractScrollableDataIterator
implements DataIterator {
    protected final String entityName;
    protected final SQLQuery sqlQuery;
    protected final String hQuery;
    protected final SessionFactory sessionFactory;
    protected final boolean perfromOrderById;
    protected final int fetchSize;
    protected final int from;
    protected final int size;
    private ScrollableResults cursor;
    private int clearCounter;
    private int globalCounter;

    public AbstractScrollableDataIterator(String entityName, SessionFactory sessionFactory, int fetchSize, boolean performOrderById) {
        this(entityName, sessionFactory, fetchSize, performOrderById, -1, -1);
    }

    public AbstractScrollableDataIterator(String entityName, SessionFactory sessionFactory, int fetchSize, boolean performOrderById, int from, int size) {
        this.entityName = entityName;
        this.sqlQuery = null;
        this.hQuery = null;
        this.sessionFactory = sessionFactory;
        this.fetchSize = fetchSize;
        this.perfromOrderById = performOrderById;
        this.from = from;
        this.size = size;
    }

    public AbstractScrollableDataIterator(String hQuery, SessionFactory sessionFactory, int fetchSize) {
        this(hQuery, sessionFactory, fetchSize, -1, -1);
    }

    public AbstractScrollableDataIterator(String hQuery, SessionFactory sessionFactory, int fetchSize, int from, int size) {
        this.entityName = null;
        this.sqlQuery = null;
        this.hQuery = hQuery;
        this.sessionFactory = sessionFactory;
        this.fetchSize = fetchSize;
        this.perfromOrderById = false;
        this.from = from;
        this.size = size;
    }

    public AbstractScrollableDataIterator(SQLQuery sqlQuery, SessionFactory sessionFactory, int fetchSize, boolean performOrderById) {
        this(sqlQuery, sessionFactory, fetchSize, performOrderById, -1, -1);
    }

    public AbstractScrollableDataIterator(SQLQuery sqlQuery, SessionFactory sessionFactory, int fetchSize, boolean performOrderById, int from, int size) {
        this.sqlQuery = sqlQuery;
        this.entityName = null;
        this.hQuery = null;
        this.sessionFactory = sessionFactory;
        this.fetchSize = fetchSize;
        this.perfromOrderById = performOrderById;
        this.from = from;
        this.size = size;
    }

    public boolean hasNext() {
        boolean hasNext;
        if (this.cursor == null) {
            this.cursor = this.createCursor();
        }
        if ((hasNext = this.cursor.next()) && this.size != -1 && ++this.globalCounter > this.size) {
            return false;
        }
        return hasNext;
    }

    public Object next() {
        if (this.clearCounter++ > this.fetchSize) {
            this.clearCounter = 0;
            this.clear();
        }
        return this.cursor.get(0);
    }

    public void remove() {
        throw new UnsupportedOperationException("remove is not supported");
    }

    public void close() {
        if (this.cursor == null) {
            return;
        }
        try {
            this.cursor.close();
        }
        finally {
            this.cursor = null;
            this.doClose();
        }
    }

    protected abstract void doClose();

    protected abstract void clear();

    protected abstract ScrollableResults createCursor();
}

