/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.persistency.hibernate.iterator;

import com.gigaspaces.datasource.DataIterator;
import java.util.Iterator;
import org.hibernate.CacheMode;
import org.hibernate.Criteria;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Example;

public class DefaultCriteriaByExampleDataIterator
implements DataIterator {
    protected final Object template;
    protected final SessionFactory sessionFactory;
    protected Transaction transaction;
    protected Session session;
    private Iterator iterator;

    public DefaultCriteriaByExampleDataIterator(Object template, SessionFactory sessionFactory) {
        this.template = template;
        this.sessionFactory = sessionFactory;
    }

    public boolean hasNext() {
        if (this.iterator == null) {
            this.iterator = this.createIterator();
        }
        return this.iterator.hasNext();
    }

    public Object next() {
        return this.iterator.next();
    }

    public void remove() {
        throw new UnsupportedOperationException("remove not supported");
    }

    public void close() {
        try {
            if (this.transaction == null) {
                return;
            }
            this.transaction.commit();
        }
        finally {
            this.transaction = null;
            if (this.session != null && this.session.isOpen()) {
                this.session.close();
            }
        }
    }

    protected Iterator createIterator() {
        this.session = this.sessionFactory.openSession();
        this.transaction = this.session.beginTransaction();
        Example example = Example.create((Object)this.template);
        Criteria criteria = this.session.createCriteria(this.template.getClass()).add((Criterion)example);
        criteria.setCacheMode(CacheMode.IGNORE);
        criteria.setCacheable(false);
        criteria.setFlushMode(FlushMode.MANUAL);
        return criteria.list().iterator();
    }
}

