/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.persistency.hibernate.iterator;

import com.gigaspaces.SpaceRuntimeException;
import com.gigaspaces.datasource.DataIterator;
import com.gigaspaces.datasource.DataSourceSQLQuery;
import com.j_spaces.core.client.SQLQuery;
import java.util.Iterator;
import org.hibernate.CacheMode;
import org.hibernate.Criteria;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.openspaces.persistency.hibernate.iterator.HibernateIteratorUtils;

public class DefaultListQueryDataIterator
implements DataIterator {
    protected final SQLQuery<?> sqlQuery;
    protected final DataSourceSQLQuery dataSourceSQLQuery;
    protected final String entityName;
    protected final SessionFactory sessionFactory;
    protected final int from;
    protected final int size;
    protected Transaction transaction;
    protected Session session;
    private Iterator iterator;

    public DefaultListQueryDataIterator(SQLQuery sqlQuery, SessionFactory sessionFactory) {
        this.sqlQuery = sqlQuery;
        this.entityName = null;
        this.dataSourceSQLQuery = null;
        this.sessionFactory = sessionFactory;
        this.from = -1;
        this.size = -1;
    }

    public DefaultListQueryDataIterator(String entityName, SessionFactory sessionFactory) {
        this.entityName = entityName;
        this.sqlQuery = null;
        this.dataSourceSQLQuery = null;
        this.sessionFactory = sessionFactory;
        this.from = -1;
        this.size = -1;
    }

    public DefaultListQueryDataIterator(DataSourceSQLQuery dataSourceSQLQuery, SessionFactory sessionFactory) {
        this.dataSourceSQLQuery = dataSourceSQLQuery;
        this.sqlQuery = null;
        this.entityName = null;
        this.sessionFactory = sessionFactory;
        this.from = -1;
        this.size = -1;
    }

    public DefaultListQueryDataIterator(String entityName, SessionFactory sessionFactory, int from, int size) {
        this.entityName = entityName;
        this.sqlQuery = null;
        this.dataSourceSQLQuery = null;
        this.sessionFactory = sessionFactory;
        this.from = from;
        this.size = size;
    }

    public DefaultListQueryDataIterator(SQLQuery sqlQuery, SessionFactory sessionFactory, int from, int size) {
        this.sqlQuery = sqlQuery;
        this.entityName = null;
        this.dataSourceSQLQuery = null;
        this.sessionFactory = sessionFactory;
        this.from = from;
        this.size = size;
    }

    public boolean hasNext() {
        if (this.iterator == null) {
            this.iterator = this.createIterator();
        }
        return this.iterator.hasNext();
    }

    public Object next() {
        return this.iterator.next();
    }

    public void remove() {
        throw new UnsupportedOperationException("remove not supported");
    }

    public void close() {
        try {
            if (this.transaction == null) {
                return;
            }
            this.transaction.commit();
        }
        finally {
            this.transaction = null;
            if (this.session != null && this.session.isOpen()) {
                this.session.close();
            }
        }
    }

    protected Iterator createIterator() {
        this.session = this.sessionFactory.openSession();
        this.transaction = this.session.beginTransaction();
        if (this.entityName != null) {
            return this.createIteratorFromCriteria();
        }
        if (this.sqlQuery != null) {
            return this.createIteratorFromSqlQuery();
        }
        if (this.dataSourceSQLQuery != null) {
            return this.createIteratorFromDataSourceQuery();
        }
        throw new IllegalStateException("Either SQLQuery or entity must be provided");
    }

    private Iterator createIteratorFromCriteria() {
        try {
            Criteria criteria = this.session.createCriteria(this.entityName);
            criteria.setCacheMode(CacheMode.IGNORE);
            criteria.setCacheable(false);
            criteria.setFlushMode(FlushMode.MANUAL);
            if (this.from >= 0) {
                criteria.setFirstResult(this.from);
                criteria.setMaxResults(this.size);
            }
            return criteria.list().iterator();
        }
        catch (HibernateException e) {
            throw new SpaceRuntimeException("Failed to create iterator for [" + this.entityName + "]", (Throwable)e);
        }
    }

    private Iterator createIteratorFromSqlQuery() {
        try {
            Query query = HibernateIteratorUtils.createQueryFromSQLQuery(this.sqlQuery, this.session);
            if (this.from >= 0) {
                query.setFirstResult(this.from);
                query.setMaxResults(this.size);
            }
            return query.list().iterator();
        }
        catch (HibernateException e) {
            throw new SpaceRuntimeException("Failed to create iterator for [" + this.sqlQuery + "]", (Throwable)e);
        }
    }

    private Iterator createIteratorFromDataSourceQuery() {
        try {
            Query query = HibernateIteratorUtils.createQueryFromDataSourceSQLQuery(this.dataSourceSQLQuery, this.session);
            if (this.from >= 0) {
                query.setFirstResult(this.from);
                query.setMaxResults(this.size);
            }
            return query.list().iterator();
        }
        catch (HibernateException e) {
            throw new SpaceRuntimeException("Failed to create iterator for [" + this.dataSourceSQLQuery + "]", (Throwable)e);
        }
    }

    protected Iterator createIterator(Query query) {
        return query.list().iterator();
    }
}

