/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.persistency.hibernate.iterator;

import com.gigaspaces.datasource.DataIterator;
import com.gigaspaces.datasource.DataSourceSQLQuery;
import com.j_spaces.core.client.SQLQuery;
import java.util.Iterator;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.hibernate.StatelessSession;
import org.openspaces.persistency.hibernate.iterator.HibernateIteratorUtils;

public class StatelessListQueryDataIterator
implements DataIterator {
    protected final String entityName;
    protected final SQLQuery<?> sqlQuery;
    protected final DataSourceSQLQuery dataSourceSQLQuery;
    protected final SessionFactory sessionFactory;
    protected final int from;
    protected final int size;
    protected StatelessSession session;
    private Iterator iterator;

    public StatelessListQueryDataIterator(SQLQuery sqlQuery, SessionFactory sessionFactory) {
        this.sqlQuery = sqlQuery;
        this.entityName = null;
        this.dataSourceSQLQuery = null;
        this.sessionFactory = sessionFactory;
        this.from = -1;
        this.size = -1;
    }

    public StatelessListQueryDataIterator(SQLQuery sqlQuery, SessionFactory sessionFactory, int from, int size) {
        this.sqlQuery = sqlQuery;
        this.entityName = null;
        this.dataSourceSQLQuery = null;
        this.sessionFactory = sessionFactory;
        this.from = from;
        this.size = size;
    }

    public StatelessListQueryDataIterator(String entityName, SessionFactory sessionFactory) {
        this.entityName = entityName;
        this.sqlQuery = null;
        this.dataSourceSQLQuery = null;
        this.sessionFactory = sessionFactory;
        this.from = -1;
        this.size = -1;
    }

    public StatelessListQueryDataIterator(String entityName, SessionFactory sessionFactory, int from, int size) {
        this.entityName = entityName;
        this.sqlQuery = null;
        this.dataSourceSQLQuery = null;
        this.sessionFactory = sessionFactory;
        this.from = from;
        this.size = size;
    }

    public StatelessListQueryDataIterator(DataSourceSQLQuery dataSourceSQLQuery, SessionFactory sessionFactory) {
        this.sqlQuery = null;
        this.entityName = null;
        this.dataSourceSQLQuery = dataSourceSQLQuery;
        this.sessionFactory = sessionFactory;
        this.from = -1;
        this.size = -1;
    }

    public boolean hasNext() {
        if (this.iterator == null) {
            this.iterator = this.createIterator();
        }
        return this.iterator.hasNext();
    }

    public Object next() {
        return this.iterator.next();
    }

    public void remove() {
        throw new UnsupportedOperationException("remove not supported");
    }

    public void close() {
        if (this.session != null) {
            try {
                this.session.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected Iterator createIterator() {
        this.session = this.sessionFactory.openStatelessSession();
        if (this.entityName != null) {
            Criteria criteria = this.session.createCriteria(this.entityName);
            criteria.setCacheable(false);
            if (this.from >= 0) {
                criteria.setFirstResult(this.from);
                criteria.setMaxResults(this.size);
            }
            return criteria.list().iterator();
        }
        if (this.sqlQuery != null) {
            Query query = HibernateIteratorUtils.createQueryFromSQLQuery(this.sqlQuery, this.session);
            if (this.from >= 0) {
                query.setFirstResult(this.from);
                query.setMaxResults(this.size);
            }
            return query.list().iterator();
        }
        if (this.dataSourceSQLQuery != null) {
            Query query = HibernateIteratorUtils.createQueryFromDataSourceSQLQuery(this.dataSourceSQLQuery, this.session);
            if (this.from >= 0) {
                query.setFirstResult(this.from);
                query.setMaxResults(this.size);
            }
            return query.list().iterator();
        }
        throw new IllegalStateException("Either SQLQuery or entity must be provided");
    }
}

