/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.persistency.hibernate.iterator;

import com.j_spaces.core.client.SQLQuery;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.SessionFactory;
import org.hibernate.StatelessSession;
import org.hibernate.Transaction;
import org.hibernate.criterion.Order;
import org.hibernate.metadata.ClassMetadata;
import org.openspaces.persistency.hibernate.iterator.AbstractScrollableDataIterator;
import org.openspaces.persistency.hibernate.iterator.HibernateIteratorUtils;

public class StatelessScrollableDataIterator
extends AbstractScrollableDataIterator {
    protected StatelessSession session;
    protected Transaction transaction;

    public StatelessScrollableDataIterator(String entityName, SessionFactory sessionFactory, int fetchSize, boolean performOrderById) {
        super(entityName, sessionFactory, fetchSize, performOrderById);
    }

    public StatelessScrollableDataIterator(String entityName, SessionFactory sessionFactory, int fetchSize, boolean performOrderById, int from, int size) {
        super(entityName, sessionFactory, fetchSize, performOrderById, from, size);
    }

    public StatelessScrollableDataIterator(SQLQuery sqlQuery, SessionFactory sessionFactory, int fetchSize, boolean performOrderById) {
        super(sqlQuery, sessionFactory, fetchSize, performOrderById);
    }

    public StatelessScrollableDataIterator(SQLQuery sqlQuery, SessionFactory sessionFactory, int fetchSize, boolean performOrderById, int from, int size) {
        super(sqlQuery, sessionFactory, fetchSize, performOrderById, from, size);
    }

    public StatelessScrollableDataIterator(String hQuery, SessionFactory sessionFactory, int fetchSize) {
        super(hQuery, sessionFactory, fetchSize);
    }

    public StatelessScrollableDataIterator(String hQuery, SessionFactory sessionFactory, int fetchSize, int from, int size) {
        super(hQuery, sessionFactory, fetchSize, from, size);
    }

    @Override
    protected void doClose() {
        try {
            if (this.transaction == null) {
                return;
            }
            this.transaction.commit();
        }
        finally {
            this.transaction = null;
            if (this.session != null) {
                try {
                    this.session.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    protected void clear() {
    }

    @Override
    protected ScrollableResults createCursor() {
        this.session = this.sessionFactory.openStatelessSession();
        this.transaction = this.session.beginTransaction();
        if (this.entityName != null) {
            ClassMetadata metadata;
            String idPropName;
            Criteria criteria = this.session.createCriteria(this.entityName);
            criteria.setFetchSize(this.fetchSize);
            if (this.perfromOrderById && (idPropName = (metadata = this.sessionFactory.getClassMetadata(this.entityName)).getIdentifierPropertyName()) != null) {
                criteria.addOrder(Order.asc((String)idPropName));
            }
            if (this.from >= 0) {
                if (this.from > 0) {
                    criteria.setFirstResult(this.from);
                }
                criteria.setMaxResults(this.size);
            }
            return criteria.scroll(ScrollMode.FORWARD_ONLY);
        }
        if (this.sqlQuery != null) {
            Query query = HibernateIteratorUtils.createQueryFromSQLQuery(this.sqlQuery, this.session);
            query.setFetchSize(this.fetchSize);
            if (this.from >= 0) {
                if (this.from > 0) {
                    query.setFirstResult(this.from);
                }
                query.setMaxResults(this.size);
            }
            return query.scroll(ScrollMode.FORWARD_ONLY);
        }
        if (this.hQuery != null) {
            Query query = this.session.createQuery(this.hQuery);
            query.setFetchSize(this.fetchSize);
            if (this.from >= 0) {
                if (this.from > 0) {
                    query.setFirstResult(this.from);
                }
                query.setMaxResults(this.size);
            }
            query.setReadOnly(true);
            return query.scroll(ScrollMode.FORWARD_ONLY);
        }
        throw new IllegalStateException("Either SQLQuery or entity must be provided");
    }
}

