/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.interop;

import com.gigaspaces.internal.dump.InternalDumpProcessor;
import com.gigaspaces.security.directory.CredentialsProvider;
import com.gigaspaces.security.directory.CredentialsProviderHelper;
import com.gigaspaces.security.directory.UserDetails;
import com.gigaspaces.serialization.pbs.commands.processingunit.PUDetailsHolder;
import com.gigaspaces.serialization.pbs.commands.processingunit.ServicesDetails;
import com.gigaspaces.serialization.pbs.commands.processingunit.ServicesMonitors;
import com.gigaspaces.serialization.pbs.openspaces.ProcessingUnitProxy;
import com.j_spaces.core.IJSpace;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openspaces.admin.quiesce.QuiesceStateChangedListener;
import org.openspaces.core.cluster.ClusterInfo;
import org.openspaces.core.cluster.ClusterInfoAware;
import org.openspaces.core.cluster.MemberAliveIndicator;
import org.openspaces.core.cluster.ProcessingUnitUndeployingListener;
import org.openspaces.core.cluster.SpaceMemberAliveIndicator;
import org.openspaces.core.properties.BeanLevelProperties;
import org.openspaces.core.properties.BeanLevelPropertiesAware;
import org.openspaces.core.space.SpaceServiceDetails;
import org.openspaces.events.notify.NotifyEventContainerServiceDetails;
import org.openspaces.events.notify.NotifyEventContainerServiceMonitors;
import org.openspaces.events.polling.PollingEventContainerServiceDetails;
import org.openspaces.events.polling.PollingEventContainerServiceMonitors;
import org.openspaces.interop.DotnetContainerServiceDetails;
import org.openspaces.pu.service.CustomServiceDetails;
import org.openspaces.pu.service.CustomServiceMonitors;
import org.openspaces.pu.service.InvocableService;
import org.openspaces.pu.service.ServiceDetails;
import org.openspaces.pu.service.ServiceDetailsProvider;
import org.openspaces.pu.service.ServiceMonitors;
import org.openspaces.pu.service.ServiceMonitorsProvider;
import org.openspaces.remoting.RemotingServiceDetails;
import org.openspaces.remoting.RemotingServiceMonitors;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class DotnetProcessingUnitBean
implements InitializingBean,
DisposableBean,
ClusterInfoAware,
BeanLevelPropertiesAware,
ServiceDetailsProvider,
ServiceMonitorsProvider {
    protected final Log log = LogFactory.getLog(this.getClass());
    private ProcessingUnitProxy proxy;
    private String assemblyFile;
    private String implementationClassName;
    private String[] dependencies;
    private String deploymentPath;
    private ClusterInfo clusterInfo;
    private Properties customProperties;
    private BeanLevelProperties beanLevelProperties;
    private Collection<ServiceDetailsProvider> serviceDetailsProviders = Collections.singleton(this);
    private Collection<ServiceMonitorsProvider> serviceMonitorsProviders = Collections.singleton(this);
    private static final String REMOTING_SERVICE_DETAILS = "remoting";
    private static final String EVENT_CONTAINER_SERVICE_DETAILS = "event-container";
    private static final String POLLING_CONTAINER_SERVICE_DETAILS = "polling";
    private static final String NOTIFY_CONTAINER_SERVICE_DETAILS = "notify";
    private static final String REMOTING_SERVICE_MONITORS = "RemotingServiceMonitors";
    private static final String POLLING_CONTAINER_MONITORS = "PollingEventContainerServiceMonitors";
    private static final String NOTIFY_CONTAINER_MONITORS = "NotifyEventContainerServiceMonitors";

    public void setAssemblyFile(String assemblyFile) {
        this.assemblyFile = assemblyFile;
    }

    public void setImplementationClassName(String implementationClassName) {
        this.implementationClassName = implementationClassName;
    }

    public void setDependencies(String[] dependencies) {
        this.dependencies = dependencies;
    }

    public void setDeploymentDirectory(String deploymentDirectory) {
        this.deploymentPath = deploymentDirectory;
    }

    public void setCustomProperties(Properties customProperties) {
        this.customProperties = customProperties;
    }

    public void setClusterInfo(ClusterInfo clusterInfo) {
        this.clusterInfo = clusterInfo;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.deploymentPath == null && this.beanLevelProperties != null) {
            this.deploymentPath = this.beanLevelProperties.getContextProperties().getProperty("deployPath");
        }
        if (this.deploymentPath != null) {
            this.log.info((Object)("Deployment path taken from deployPath property (" + this.deploymentPath + ")"));
        }
        if (this.beanLevelProperties != null) {
            if (this.customProperties == null) {
                this.customProperties = new Properties();
            }
            this.customProperties.putAll((Map<?, ?>)this.beanLevelProperties.getMergedBeanProperties("space"));
            CredentialsProvider credentialsProvider = CredentialsProviderHelper.extractMarshalledCredentials((Properties)this.customProperties, (boolean)true);
            if (credentialsProvider != null) {
                UserDetails credentials = credentialsProvider.getUserDetails();
                this.customProperties.put("security.username", credentials.getUsername());
                this.customProperties.put("security.password", credentials.getPassword());
            }
        }
        UUID beanUniqueIdentifier = UUID.randomUUID();
        this.log.debug((Object)("Invoking Init on the .Net processing unit, pu context " + beanUniqueIdentifier));
        this.proxy = this.clusterInfo == null ? new ProcessingUnitProxy(this.assemblyFile, this.implementationClassName, this.dependencies, this.deploymentPath, this.customProperties, beanUniqueIdentifier) : new ProcessingUnitProxy(this.assemblyFile, this.implementationClassName, this.dependencies, this.deploymentPath, this.customProperties, this.clusterInfo.getBackupId(), this.clusterInfo.getInstanceId(), this.clusterInfo.getNumberOfBackups(), this.clusterInfo.getNumberOfInstances(), this.clusterInfo.getSchema(), this.clusterInfo.getName(), beanUniqueIdentifier);
        this.customProperties.remove("security.username");
        this.customProperties.remove("security.password");
    }

    public void destroy() throws Exception {
        this.log.debug((Object)"Invoking Dispose on the .Net processing unit");
        this.proxy.close();
        this.proxy = null;
    }

    public void setBeanLevelProperties(BeanLevelProperties beanLevelProperties) {
        this.beanLevelProperties = beanLevelProperties;
    }

    public ServiceDetails[] getServicesDetails() {
        ArrayList<ServiceDetails> serviceDetails = new ArrayList<ServiceDetails>();
        PUDetailsHolder puDetails = this.proxy.getPUDetailsHolder();
        serviceDetails.add((ServiceDetails)new DotnetContainerServiceDetails(puDetails.getDotnetPUContainerShortName(), "interop", puDetails.getDotnetPUContainerShortName(), puDetails.getDotnetPUContainerQualifiedName()));
        for (IJSpace space : this.proxy.getContextProxies()) {
            serviceDetails.add((ServiceDetails)new SpaceServiceDetails(space));
        }
        this.buildServiceDetails(puDetails, serviceDetails);
        for (ServiceDetails detail : serviceDetails) {
            if (!(detail instanceof DotnetContainerServiceDetails)) continue;
            ((DotnetContainerServiceDetails)detail).setSubType("pure");
        }
        return serviceDetails.toArray(new ServiceDetails[serviceDetails.size()]);
    }

    private void buildServiceDetails(PUDetailsHolder puDetails, ArrayList<ServiceDetails> serviceDetails) {
        ServicesDetails details = puDetails.getServicesDetails();
        if (details != null) {
            String[] ids = details.getIds();
            String[] serviceTypes = details.getServiceTypes();
            String[] subServiceTypes = details.getSubServiceTypes();
            String[] descriptions = details.getDescriptions();
            String[] longDescriptions = details.getLongDescriptions();
            Map[] properties = details.getProperties();
            for (int i = 0; i < descriptions.length; ++i) {
                serviceDetails.add(this.transformDetails(ids[i], serviceTypes[i], subServiceTypes[i], descriptions[i], longDescriptions[i], properties[i]));
            }
        }
    }

    private ServiceDetails transformDetails(String id, String serviceType, String subServiceType, String description, String longDescription, Map<String, String> properties) {
        if (REMOTING_SERVICE_DETAILS.equals(serviceType)) {
            return this.buildRemotingServiceDetails(id, properties);
        }
        if (EVENT_CONTAINER_SERVICE_DETAILS.equals(serviceType)) {
            if (POLLING_CONTAINER_SERVICE_DETAILS.equals(subServiceType)) {
                return this.buildPollingContainerServiceDetails(id, properties);
            }
            if (NOTIFY_CONTAINER_SERVICE_DETAILS.equals(subServiceType)) {
                return this.buildNotifyContainerServiceDetails(id, properties);
            }
        }
        return new CustomServiceDetails(id, serviceType, subServiceType, description, longDescription);
    }

    private ServiceDetails buildNotifyContainerServiceDetails(String id, Map<String, String> props) {
        String space = props.get("space");
        String template = props.get("template");
        boolean performSnapshot = Boolean.parseBoolean(props.get("perform-snapshot"));
        String txManager = props.get("transaction-manager");
        boolean batchProcessing = Boolean.parseBoolean(props.get("pass-array-as-is"));
        String commTypeStr = props.get("comm-type");
        int commType = 0;
        if ("unicast".equals(commTypeStr)) {
            commType = 0;
        } else if ("multiplex".equals(commTypeStr)) {
            commType = 1;
        } else if ("multicast".equals(commTypeStr)) {
            commType = 2;
        }
        boolean fifo = Boolean.parseBoolean(props.get("fifo"));
        Integer batchSize = props.get("batch-size") == null ? null : Integer.valueOf(Integer.parseInt("batch-size"));
        Integer batchTime = props.get("batch-time") == null ? null : Integer.valueOf(Integer.parseInt("batch-time"));
        Integer batchPendingThreshold = props.get("batch-pending-threshold") == null ? null : Integer.valueOf(Integer.parseInt("batch-pending-threshold"));
        boolean autoRenew = Boolean.parseBoolean(props.get("auto-renew"));
        boolean notifyWrite = Boolean.parseBoolean(props.get("notify-write"));
        boolean notifyUpdate = Boolean.parseBoolean(props.get("notify-update"));
        boolean notifyTake = Boolean.parseBoolean(props.get("notify-take"));
        boolean notifyLease = Boolean.parseBoolean(props.get("notify-lease-expire"));
        boolean notifyUnmatched = Boolean.parseBoolean(props.get("notify-unmatched"));
        boolean notifyMatched = Boolean.parseBoolean(props.get("notify-matched"));
        boolean notifyRematched = Boolean.parseBoolean(props.get("notify-rematched"));
        Boolean triggerNotifyTemplate = props.get("trigger-notify-template") == null ? null : Boolean.valueOf(Boolean.parseBoolean(props.get("trigger-notify-template")));
        Boolean replicateNotifyTemplate = props.get("replicate-notify-template") == null ? null : Boolean.valueOf(Boolean.parseBoolean(props.get("replicate-notify-template")));
        boolean performTakeOnNotify = Boolean.parseBoolean(props.get("perform-take-on-notify"));
        boolean guaranteed = Boolean.parseBoolean(props.get("guaranteed"));
        boolean durable = Boolean.parseBoolean(props.get("durable"));
        return new NotifyEventContainerServiceDetails(id, space, (Object)template, performSnapshot, txManager, commType, fifo, batchSize, batchTime, batchPendingThreshold, autoRenew, null, Boolean.valueOf(notifyWrite), Boolean.valueOf(notifyUpdate), Boolean.valueOf(notifyTake), Boolean.valueOf(notifyLease), Boolean.valueOf(notifyUnmatched), Boolean.valueOf(notifyMatched), Boolean.valueOf(notifyRematched), triggerNotifyTemplate, replicateNotifyTemplate, performTakeOnNotify, batchProcessing, guaranteed, durable);
    }

    private PollingEventContainerServiceDetails buildPollingContainerServiceDetails(String id, Map<String, String> props) {
        String space = props.get("space");
        String template = props.get("template");
        boolean performSnapshot = Boolean.parseBoolean(props.get("perform-snapshot"));
        String txManager = props.get("transaction-manager");
        long receiveTimeout = Long.parseLong(props.get("receive-timeout"));
        String receiveOperationHandler = props.get("receive-operating-handler");
        String triggerOperationHandler = props.get("trigger-operating-handler");
        int minConcurrentConsumers = Integer.parseInt(props.get("concurrent-consumers"));
        int maxConcurrentConsumer = Integer.parseInt(props.get("max-concurrent-consumers"));
        boolean batchProcessing = Boolean.parseBoolean(props.get("pass-array-as-is"));
        boolean dynamicTemplate = Boolean.parseBoolean(props.get("dynamic-template"));
        return new PollingEventContainerServiceDetails(id, space, (Object)template, performSnapshot, txManager, receiveTimeout, receiveOperationHandler, triggerOperationHandler, minConcurrentConsumers, maxConcurrentConsumer, batchProcessing, dynamicTemplate, 0);
    }

    private RemotingServiceDetails buildRemotingServiceDetails(String id, Map<String, String> properties) {
        ArrayList<RemotingServiceDetails.RemoteService> remoteServices = new ArrayList<RemotingServiceDetails.RemoteService>();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String serviceId = entry.getKey();
            String className = entry.getValue();
            if (className == null) {
                className = "unknown";
            }
            RemotingServiceDetails.RemoteService remoteService = new RemotingServiceDetails.RemoteService(serviceId, className);
            remoteServices.add(remoteService);
        }
        return new RemotingServiceDetails(id, remoteServices.toArray(new RemotingServiceDetails.RemoteService[remoteServices.size()]));
    }

    public ServiceMonitors[] getServicesMonitors() {
        ServicesMonitors servicesMonitors = this.proxy.getServicesMonitors();
        ServiceMonitors[] result = new ServiceMonitors[servicesMonitors.getIds().length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.transformMonitors(servicesMonitors.getInteropId()[i], servicesMonitors.getIds()[i], servicesMonitors.getServicesMonitors()[i]);
        }
        return result;
    }

    public Collection<MemberAliveIndicator> getMemberAliveIndicators() {
        ArrayList<MemberAliveIndicator> result = new ArrayList<MemberAliveIndicator>();
        IJSpace[] spaceProxies = this.proxy.getContextProxies();
        if (spaceProxies != null) {
            for (IJSpace spaceProxy : spaceProxies) {
                result.add((MemberAliveIndicator)new SpaceMemberAliveIndicator(spaceProxy, null));
            }
        }
        return result;
    }

    private ServiceMonitors transformMonitors(String interopId, String id, Map<String, String> monitors) {
        if (REMOTING_SERVICE_MONITORS.equals(interopId)) {
            String totalProcessedStr = monitors.remove("processed");
            String totalFailedStr = monitors.remove("failed");
            int totalProc = totalProcessedStr == null ? 0 : Integer.parseInt(totalProcessedStr);
            int totalFail = totalFailedStr == null ? 0 : Integer.parseInt(totalFailedStr);
            HashSet<String> servicesIds = new HashSet<String>();
            for (Map.Entry<String, String> entry : monitors.entrySet()) {
                String[] split = entry.getKey().split("#");
                String serviceId = split[0];
                servicesIds.add(serviceId);
            }
            ArrayList<RemotingServiceMonitors.RemoteServiceStats> stats = new ArrayList<RemotingServiceMonitors.RemoteServiceStats>(monitors.size());
            for (String serviceId : servicesIds) {
                String serviceProcStr = monitors.get(serviceId + "#processed");
                String serviceFailStr = monitors.get(serviceId + "#failed");
                int proc = serviceProcStr == null ? 0 : Integer.parseInt(serviceProcStr);
                int fail = serviceFailStr == null ? 0 : Integer.parseInt(serviceFailStr);
                stats.add(new RemotingServiceMonitors.RemoteServiceStats(serviceId, (long)proc, (long)fail));
            }
            return new RemotingServiceMonitors(id, (long)totalProc, (long)totalFail, stats.toArray(new RemotingServiceMonitors.RemoteServiceStats[stats.size()]));
        }
        if (POLLING_CONTAINER_MONITORS.equals(interopId)) {
            long procEvent = Long.parseLong(monitors.get("processedEvents"));
            long failEvent = Long.parseLong(monitors.get("failedEvents"));
            int activeConsumers = Integer.parseInt(monitors.get("consumers"));
            String status = monitors.get("status");
            return new PollingEventContainerServiceMonitors(id, procEvent, failEvent, status, activeConsumers);
        }
        if (NOTIFY_CONTAINER_MONITORS.equals(interopId)) {
            long procEvent = Long.parseLong(monitors.get("processedEvents"));
            long failEvent = Long.parseLong(monitors.get("failedEvents"));
            String status = monitors.get("status");
            return new NotifyEventContainerServiceMonitors(id, procEvent, failEvent, status);
        }
        CustomServiceMonitors plainServiceMonitors = new CustomServiceMonitors(id);
        Map plainMonitors = plainServiceMonitors.getMonitors();
        for (Map.Entry<String, String> entry : monitors.entrySet()) {
            plainMonitors.put(entry.getKey(), entry.getValue());
        }
        return plainServiceMonitors;
    }

    public Collection<ServiceDetailsProvider> getServiceDetailsProviders() {
        return this.serviceDetailsProviders;
    }

    public Collection<ServiceMonitorsProvider> getServiceMonitorsProviders() {
        return this.serviceMonitorsProviders;
    }

    public Collection<QuiesceStateChangedListener> getQuiesceStateChangedListeners() {
        return Collections.EMPTY_LIST;
    }

    public Collection<ProcessingUnitUndeployingListener> getUndeployListeners() {
        return Collections.EMPTY_LIST;
    }

    public Map<String, InvocableService> getInvocableServices() {
        return Collections.EMPTY_MAP;
    }

    public Collection<InternalDumpProcessor> getDumpProcessors() {
        return Collections.EMPTY_LIST;
    }
}

