/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.bean.locators;

import com.google.inject.Binding;
import com.google.inject.ImplementedBy;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.ProvidedBy;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.google.inject.spi.BindingTargetVisitor;
import java.util.List;
import org.sonatype.guice.bean.locators.DelegatingBinding;
import org.sonatype.guice.bean.locators.HiddenBinding;
import org.sonatype.guice.bean.locators.ImplementationVisitor;
import org.sonatype.guice.bean.locators.RankingFunction;
import org.sonatype.guice.bean.locators.spi.BindingPublisher;
import org.sonatype.guice.bean.locators.spi.BindingSubscriber;
import org.sonatype.guice.bean.reflect.ClassSpace;
import org.sonatype.guice.bean.reflect.TypeParameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class InjectorPublisher
implements BindingPublisher {
    private static final TypeLiteral<?> OBJECT_TYPE_LITERAL = TypeLiteral.get(Object.class);
    private final Injector injector;
    private final RankingFunction function;
    private ClassSpace space;

    InjectorPublisher(Injector injector, RankingFunction function) {
        this.injector = injector;
        this.function = function;
        try {
            this.space = (ClassSpace)injector.getInstance(ClassSpace.class);
        }
        catch (Throwable e) {
            this.space = null;
        }
    }

    @Override
    public <T> void subscribe(TypeLiteral<T> type, BindingSubscriber subscriber) {
        Class clazz = type.getRawType();
        boolean matchFound = this.publishBindings(type, subscriber, null);
        if (clazz != type.getType()) {
            matchFound |= this.publishBindings(TypeLiteral.get((Class)clazz), subscriber, type);
        }
        if (clazz != Object.class) {
            matchFound |= this.publishBindings(OBJECT_TYPE_LITERAL, subscriber, type);
        }
        if (!matchFound && null != this.space && this.space.loadedClass(clazz)) {
            try {
                Binding<T> binding = this.getImplicitBinding(type, clazz);
                if (null != binding && InjectorPublisher.isVisible(binding)) {
                    subscriber.add(binding, Integer.MIN_VALUE);
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
    }

    @Override
    public <T> boolean contains(Binding<T> binding) {
        return binding == this.injector.getBindings().get(binding.getKey());
    }

    @Override
    public <T> void unsubscribe(TypeLiteral<T> type, BindingSubscriber importer) {
    }

    public int hashCode() {
        return this.injector.hashCode();
    }

    public boolean equals(Object rhs) {
        if (this == rhs) {
            return true;
        }
        if (rhs instanceof InjectorPublisher) {
            return this.injector.equals(((InjectorPublisher)rhs).injector);
        }
        return false;
    }

    public String toString() {
        return this.injector.toString();
    }

    private static boolean isVisible(Binding<?> binding) {
        return false == binding.getSource() instanceof HiddenBinding;
    }

    private static boolean isAssignableFrom(TypeLiteral<?> superType, Binding<?> binding) {
        Class implementation = (Class)binding.acceptTargetVisitor((BindingTargetVisitor)ImplementationVisitor.THIS);
        if (null != implementation && superType.getRawType() != implementation) {
            return TypeParameters.isAssignableFrom(superType, TypeLiteral.get((Class)implementation));
        }
        return false;
    }

    private boolean publishBindings(TypeLiteral<?> searchType, BindingSubscriber subscriber, TypeLiteral<?> superType) {
        boolean matchFound = false;
        List bindings = this.injector.findBindingsByType(searchType);
        int size = bindings.size();
        for (int i = 0; i < size; ++i) {
            Binding binding = (Binding)bindings.get(i);
            if (!InjectorPublisher.isVisible(binding) || null != superType && !InjectorPublisher.isAssignableFrom(superType, binding)) continue;
            subscriber.add(binding, this.function.rank(binding));
            matchFound = true;
        }
        return matchFound;
    }

    private <T> Binding<T> getImplicitBinding(TypeLiteral<T> type, Class<?> clazz) {
        Key key = Key.get(type);
        if ((clazz.getModifiers() & 0x600) == 0) {
            return this.injector.getBinding(key);
        }
        ImplementedBy implementedBy = clazz.getAnnotation(ImplementedBy.class);
        if (null != implementedBy) {
            return new DelegatingBinding(key, this.injector.getBinding(implementedBy.value()));
        }
        ProvidedBy providedBy = clazz.getAnnotation(ProvidedBy.class);
        if (null != providedBy) {
            return new DelegatingBinding(key, this.injector.getBinding(providedBy.value())){

                public Provider getProvider() {
                    return (Provider)super.getProvider().get();
                }
            };
        }
        return null;
    }
}

