/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.jdbc;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.calcite.avatica.AvaticaConnection;
import org.apache.calcite.avatica.Meta;
import org.apache.calcite.avatica.SqlType;
import org.apache.calcite.avatica.remote.LocalJsonService;
import org.apache.calcite.avatica.remote.LocalService;
import org.apache.calcite.avatica.remote.Service;
import org.apache.calcite.avatica.server.AvaticaJsonHandler;
import org.apache.calcite.avatica.server.HttpServer;
import org.apache.calcite.avatica.server.Main;
import org.apache.calcite.jdbc.CalciteConnectionImpl;
import org.apache.calcite.jdbc.CalciteMetaImpl;
import org.apache.calcite.prepare.CalcitePrepareImpl;
import org.apache.calcite.test.CalciteAssert;
import org.apache.calcite.test.JdbcFrontLinqBackTest;
import org.apache.calcite.test.JdbcTest;
import org.apache.calcite.util.Util;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class CalciteRemoteDriverTest {
    public static final String LJS = Factory2.class.getName();
    private final PrintWriter out = CalcitePrepareImpl.DEBUG ? Util.printWriter((OutputStream)System.out) : new PrintWriter(new StringWriter());
    private static final CalciteAssert.ConnectionFactory REMOTE_CONNECTION_FACTORY = new CalciteAssert.ConnectionFactory(){

        @Override
        public Connection createConnection() throws SQLException {
            return remoteConnection;
        }
    };
    private static final Function<Connection, ResultSet> GET_SCHEMAS = new Function<Connection, ResultSet>(){

        public ResultSet apply(Connection input) {
            try {
                return input.getMetaData().getSchemas();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    };
    private static final Function<Connection, ResultSet> GET_CATALOGS = new Function<Connection, ResultSet>(){

        public ResultSet apply(Connection input) {
            try {
                return input.getMetaData().getCatalogs();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    };
    private static final Function<Connection, ResultSet> GET_COLUMNS = new Function<Connection, ResultSet>(){

        public ResultSet apply(Connection input) {
            try {
                return input.getMetaData().getColumns(null, null, null, null);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    };
    private static final Function<Connection, ResultSet> GET_TYPEINFO = new Function<Connection, ResultSet>(){

        public ResultSet apply(Connection input) {
            try {
                return input.getMetaData().getTypeInfo();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    };
    private static final Function<Connection, ResultSet> GET_TABLE_TYPES = new Function<Connection, ResultSet>(){

        public ResultSet apply(Connection input) {
            try {
                return input.getMetaData().getTableTypes();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    };
    private static Connection localConnection;
    private static Connection remoteConnection;
    private static HttpServer start;
    private static final List<Object> SAMPLE_VALUES;

    @BeforeClass
    public static void beforeClass() throws Exception {
        localConnection = CalciteAssert.hr().connect();
        start = Main.start((String[])new String[]{Factory.class.getName()}, (int)0, (Main.HandlerFactory)new Main.HandlerFactory(){

            public AvaticaJsonHandler createHandler(Service service) {
                return new AvaticaJsonHandler(service);
            }
        });
        int port = start.getPort();
        remoteConnection = DriverManager.getConnection("jdbc:avatica:remote:url=http://localhost:" + port);
    }

    @AfterClass
    public static void afterClass() throws Exception {
        if (localConnection != null) {
            localConnection.close();
            localConnection = null;
        }
        if (start != null) {
            start.stop();
        }
    }

    @Test
    public void testCatalogsLocal() throws Exception {
        Connection connection = DriverManager.getConnection("jdbc:avatica:remote:factory=" + LJS);
        Assert.assertThat((Object)connection.isClosed(), (Matcher)CoreMatchers.is((Object)false));
        ResultSet resultSet = connection.getMetaData().getCatalogs();
        ResultSetMetaData metaData = resultSet.getMetaData();
        Assert.assertThat((Object)metaData.getColumnCount(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)metaData.getColumnName(1), (Matcher)CoreMatchers.is((Object)"TABLE_CAT"));
        Assert.assertThat((Object)resultSet.next(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)resultSet.next(), (Matcher)CoreMatchers.is((Object)false));
        resultSet.close();
        connection.close();
        Assert.assertThat((Object)connection.isClosed(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testSchemasLocal() throws Exception {
        Connection connection = DriverManager.getConnection("jdbc:avatica:remote:factory=" + LJS);
        Assert.assertThat((Object)connection.isClosed(), (Matcher)CoreMatchers.is((Object)false));
        ResultSet resultSet = connection.getMetaData().getSchemas();
        ResultSetMetaData metaData = resultSet.getMetaData();
        Assert.assertThat((Object)metaData.getColumnCount(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)metaData.getColumnName(1), (Matcher)CoreMatchers.is((Object)"TABLE_SCHEM"));
        Assert.assertThat((Object)metaData.getColumnName(2), (Matcher)CoreMatchers.is((Object)"TABLE_CATALOG"));
        Assert.assertThat((Object)resultSet.next(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)resultSet.getString(1), (Matcher)CoreMatchers.equalTo((Object)"POST"));
        Assert.assertThat((Object)resultSet.getString(2), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((Object)resultSet.next(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)resultSet.getString(1), (Matcher)CoreMatchers.equalTo((Object)"foodmart"));
        Assert.assertThat((Object)resultSet.getString(2), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((Object)resultSet.next(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)resultSet.next(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)resultSet.next(), (Matcher)CoreMatchers.is((Object)false));
        resultSet.close();
        connection.close();
        Assert.assertThat((Object)connection.isClosed(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testMetaFunctionsLocal() throws Exception {
        Connection connection = CalciteAssert.hr().connect();
        Assert.assertThat((Object)connection.isClosed(), (Matcher)CoreMatchers.is((Object)false));
        block7: for (Meta.DatabaseProperty p : Meta.DatabaseProperty.values()) {
            switch (p) {
                case GET_NUMERIC_FUNCTIONS: {
                    Assert.assertThat((Object)connection.getMetaData().getNumericFunctions(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)"")));
                    continue block7;
                }
                case GET_SYSTEM_FUNCTIONS: {
                    Assert.assertThat((Object)connection.getMetaData().getSystemFunctions(), (Matcher)CoreMatchers.notNullValue());
                    continue block7;
                }
                case GET_TIME_DATE_FUNCTIONS: {
                    Assert.assertThat((Object)connection.getMetaData().getTimeDateFunctions(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)"")));
                    continue block7;
                }
                case GET_S_Q_L_KEYWORDS: {
                    Assert.assertThat((Object)connection.getMetaData().getSQLKeywords(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)"")));
                    continue block7;
                }
                case GET_STRING_FUNCTIONS: {
                    Assert.assertThat((Object)connection.getMetaData().getStringFunctions(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)"")));
                    continue block7;
                }
            }
        }
        connection.close();
        Assert.assertThat((Object)connection.isClosed(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testRemoteCatalogs() throws Exception {
        CalciteAssert.hr().with(REMOTE_CONNECTION_FACTORY).metaData(GET_CATALOGS).returns("TABLE_CAT=null\n");
    }

    @Test
    public void testRemoteSchemas() throws Exception {
        CalciteAssert.hr().with(REMOTE_CONNECTION_FACTORY).metaData(GET_SCHEMAS).returns("TABLE_SCHEM=POST; TABLE_CATALOG=null\nTABLE_SCHEM=foodmart; TABLE_CATALOG=null\nTABLE_SCHEM=hr; TABLE_CATALOG=null\nTABLE_SCHEM=metadata; TABLE_CATALOG=null\n");
    }

    @Test
    public void testRemoteColumns() throws Exception {
        CalciteAssert.hr().with(REMOTE_CONNECTION_FACTORY).metaData(GET_COLUMNS).returns(CalciteAssert.checkResultContains("COLUMN_NAME=EMPNO"));
    }

    @Test
    public void testRemoteTypeInfo() throws Exception {
        CalciteAssert.hr().with(REMOTE_CONNECTION_FACTORY).metaData(GET_TYPEINFO).returns(CalciteAssert.checkResultCount((Matcher<Integer>)CoreMatchers.is((Object)42)));
    }

    @Test
    public void testRemoteTableTypes() throws Exception {
        CalciteAssert.hr().with(REMOTE_CONNECTION_FACTORY).metaData(GET_TABLE_TYPES).returns("TABLE_TYPE=TABLE\nTABLE_TYPE=VIEW\n");
    }

    @Test
    public void testRemoteExecuteQuery() throws Exception {
        CalciteAssert.hr().with(REMOTE_CONNECTION_FACTORY).query("values (1, 'a'), (cast(null as integer), 'b')").returnsUnordered("EXPR$0=1; EXPR$1=a", "EXPR$0=null; EXPR$1=b");
    }

    @Test
    public void testRemoteExecuteQuery2() throws Exception {
        Statement statement = remoteConnection.createStatement();
        ResultSet resultSet = statement.executeQuery("values (1, 'a'), (cast(null as integer), 'b')");
        int n = 0;
        while (resultSet.next()) {
            ++n;
        }
        Assert.assertThat((Object)n, (Matcher)CoreMatchers.equalTo((Object)2));
    }

    @Test
    public void testParameterConvert() throws Exception {
        StringBuilder sql = new StringBuilder("select 1");
        HashMap map = Maps.newHashMap();
        block8: for (Map.Entry entry : SqlType.getSetConversions()) {
            SqlType sqlType = (SqlType)entry.getValue();
            switch (sqlType) {
                case BIT: 
                case LONGVARCHAR: 
                case LONGVARBINARY: 
                case NCHAR: 
                case NVARCHAR: 
                case LONGNVARCHAR: 
                case BLOB: 
                case CLOB: 
                case NCLOB: 
                case ARRAY: 
                case REF: 
                case STRUCT: 
                case DATALINK: 
                case ROWID: 
                case JAVA_OBJECT: 
                case SQLXML: {
                    continue block8;
                }
            }
            if (map.containsKey(sqlType)) continue;
            sql.append(", cast(? as ").append(sqlType).append(")");
            map.put(sqlType, map.size() + 1);
        }
        sql.append(" from (values 1)");
        PreparedStatement statement = localConnection.prepareStatement(sql.toString());
        for (Map.Entry entry : map.entrySet()) {
            statement.setNull((Integer)entry.getValue(), ((SqlType)entry.getKey()).id);
        }
        for (Map.Entry entry : SqlType.getSetConversions()) {
            SqlType sqlType = (SqlType)entry.getValue();
            if (!map.containsKey(sqlType)) continue;
            int param = (Integer)map.get(sqlType);
            Class clazz = (Class)entry.getKey();
            block11: for (Object sampleValue : CalciteRemoteDriverTest.values(sqlType.boxedClass())) {
                Object o;
                switch (sqlType) {
                    case DATE: 
                    case TIME: 
                    case TIMESTAMP: {
                        continue block11;
                    }
                }
                if (clazz == Calendar.class) continue;
                try {
                    o = this.convert(sampleValue, clazz);
                }
                catch (IllegalArgumentException | ParseException e) {
                    continue;
                }
                this.out.println("check " + o + " (originally " + sampleValue.getClass() + ", now " + o.getClass() + ") converted to " + sqlType);
                if (o instanceof Double && o.equals(Double.POSITIVE_INFINITY) || o instanceof Float && o.equals(Float.valueOf(Float.POSITIVE_INFINITY))) continue;
                statement.setObject(param, o, sqlType.id);
                ResultSet resultSet = statement.executeQuery();
                Assert.assertThat((Object)resultSet.next(), (Matcher)CoreMatchers.is((Object)true));
                this.out.println(resultSet.getString(param + 1));
            }
        }
        statement.close();
    }

    @Test
    public void testTableB5() {
        Class[] rows;
        SqlType[] columns = new SqlType[]{SqlType.TINYINT, SqlType.SMALLINT, SqlType.INTEGER, SqlType.BIGINT, SqlType.REAL, SqlType.FLOAT, SqlType.DOUBLE, SqlType.DECIMAL, SqlType.NUMERIC, SqlType.BIT, SqlType.BOOLEAN, SqlType.CHAR, SqlType.VARCHAR, SqlType.LONGVARCHAR, SqlType.BINARY, SqlType.VARBINARY, SqlType.LONGVARBINARY, SqlType.DATE, SqlType.TIME, SqlType.TIMESTAMP, SqlType.ARRAY, SqlType.BLOB, SqlType.CLOB, SqlType.STRUCT, SqlType.REF, SqlType.DATALINK, SqlType.JAVA_OBJECT, SqlType.ROWID, SqlType.NCHAR, SqlType.NVARCHAR, SqlType.LONGNVARCHAR, SqlType.NCLOB, SqlType.SQLXML};
        for (Class row : rows = new Class[]{String.class, BigDecimal.class, Boolean.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, byte[].class, BigInteger.class, Date.class, Time.class, Timestamp.class, Array.class, Blob.class, Clob.class, Struct.class, Ref.class, URL.class, Class.class, RowId.class, NClob.class, SQLXML.class, Calendar.class, java.util.Date.class}) {
            String s = row == java.util.Date.class ? row.getName() : row.getSimpleName();
            this.out.print(this.pad(s));
            for (SqlType column : columns) {
                this.out.print(SqlType.canSet((Class)row, (SqlType)column) ? "x " : ". ");
            }
            this.out.println();
        }
    }

    private String pad(String x) {
        while (x.length() < 20) {
            x = x + " ";
        }
        return x;
    }

    @Test
    public void testTableB6() {
        SqlType[] columns = new SqlType[]{SqlType.TINYINT, SqlType.SMALLINT, SqlType.INTEGER, SqlType.BIGINT, SqlType.REAL, SqlType.FLOAT, SqlType.DOUBLE, SqlType.DECIMAL, SqlType.NUMERIC, SqlType.BIT, SqlType.BOOLEAN, SqlType.CHAR, SqlType.VARCHAR, SqlType.LONGVARCHAR, SqlType.BINARY, SqlType.VARBINARY, SqlType.LONGVARBINARY, SqlType.DATE, SqlType.TIME, SqlType.TIMESTAMP, SqlType.CLOB, SqlType.BLOB, SqlType.ARRAY, SqlType.REF, SqlType.DATALINK, SqlType.STRUCT, SqlType.JAVA_OBJECT, SqlType.ROWID, SqlType.NCHAR, SqlType.NVARCHAR, SqlType.LONGNVARCHAR, SqlType.NCLOB, SqlType.SQLXML};
        PrintWriter out = CalcitePrepareImpl.DEBUG ? Util.printWriter((OutputStream)System.out) : new PrintWriter(new StringWriter());
        for (SqlType.Method row : SqlType.Method.values()) {
            out.print(this.pad(row.methodName));
            for (SqlType column : columns) {
                out.print(SqlType.canGet((SqlType.Method)row, (SqlType)column) ? "x " : ". ");
            }
            out.println();
        }
    }

    @Test
    public void testRemoteStatementExecute() throws Exception {
        Statement statement = remoteConnection.createStatement();
        boolean status = statement.execute("values (1, 2), (3, 4), (5, 6)");
        ResultSet resultSet = statement.getResultSet();
        int n = 0;
        while (resultSet.next()) {
            ++n;
        }
        Assert.assertThat((Object)n, (Matcher)CoreMatchers.equalTo((Object)3));
    }

    @Test(expected=SQLException.class)
    public void testAvaticaConnectionException() throws Exception {
        remoteConnection.isValid(0);
    }

    @Test(expected=SQLException.class)
    public void testAvaticaStatementException() throws Exception {
        remoteConnection.createStatement().getMoreResults();
    }

    @Test
    public void testRemoteExecute() throws Exception {
        ResultSet resultSet = remoteConnection.createStatement().executeQuery("select * from \"hr\".\"emps\"");
        int count = 0;
        while (resultSet.next()) {
            ++count;
        }
        Assert.assertThat((Object)(count > 0 ? 1 : 0), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testRemoteExecuteMaxRow() throws Exception {
        Statement statement = remoteConnection.createStatement();
        statement.setMaxRows(2);
        ResultSet resultSet = statement.executeQuery("select * from \"hr\".\"emps\"");
        int count = 0;
        while (resultSet.next()) {
            ++count;
        }
        Assert.assertThat((Object)count, (Matcher)CoreMatchers.equalTo((Object)2));
    }

    @Test
    public void testRemotePrepareExecute() throws Exception {
        PreparedStatement preparedStatement = remoteConnection.prepareStatement("select * from \"hr\".\"emps\"");
        ResultSet resultSet = preparedStatement.executeQuery();
        int count = 0;
        while (resultSet.next()) {
            ++count;
        }
        Assert.assertThat((Object)(count > 0 ? 1 : 0), (Matcher)CoreMatchers.is((Object)true));
    }

    public static Connection makeConnection() throws Exception {
        ArrayList<JdbcTest.Employee> employees = new ArrayList<JdbcTest.Employee>();
        for (int i = 1; i <= 101; ++i) {
            employees.add(new JdbcTest.Employee(i, 0, "first", 0.0f, null));
        }
        Connection conn = JdbcFrontLinqBackTest.makeConnection(employees);
        return conn;
    }

    @Test
    public void testLocalStatementFetch() throws Exception {
        Connection conn = CalciteRemoteDriverTest.makeConnection();
        String sql = "select * from \"foo\".\"bar\"";
        Statement statement = conn.createStatement();
        boolean status = statement.execute(sql);
        Assert.assertThat((Object)status, (Matcher)CoreMatchers.is((Object)true));
        ResultSet resultSet = statement.getResultSet();
        int count = 0;
        while (resultSet.next()) {
            ++count;
        }
        Assert.assertThat((Object)count, (Matcher)CoreMatchers.is((Object)101));
    }

    @Test
    public void testLocalPreparedStatementFetch() throws Exception {
        Connection conn = CalciteRemoteDriverTest.makeConnection();
        Assert.assertThat((Object)conn.isClosed(), (Matcher)CoreMatchers.is((Object)false));
        String sql = "select * from \"foo\".\"bar\"";
        PreparedStatement preparedStatement = conn.prepareStatement(sql);
        Assert.assertThat((Object)conn.isClosed(), (Matcher)CoreMatchers.is((Object)false));
        boolean status = preparedStatement.execute();
        Assert.assertThat((Object)status, (Matcher)CoreMatchers.is((Object)true));
        ResultSet resultSet = preparedStatement.getResultSet();
        Assert.assertThat((Object)resultSet, (Matcher)CoreMatchers.notNullValue());
        int count = 0;
        while (resultSet.next()) {
            Assert.assertThat((Object)resultSet.getObject(1), (Matcher)CoreMatchers.notNullValue());
            ++count;
        }
        Assert.assertThat((Object)count, (Matcher)CoreMatchers.is((Object)101));
    }

    @Test
    public void testRemoteStatementFetch() throws Exception {
        Connection connection = DriverManager.getConnection("jdbc:avatica:remote:factory=" + LocalServiceMoreFactory.class.getName());
        String sql = "select * from \"foo\".\"bar\"";
        Statement statement = connection.createStatement();
        boolean status = statement.execute(sql);
        Assert.assertThat((Object)status, (Matcher)CoreMatchers.is((Object)true));
        ResultSet resultSet = statement.getResultSet();
        int count = 0;
        while (resultSet.next()) {
            ++count;
        }
        Assert.assertThat((Object)count, (Matcher)CoreMatchers.is((Object)101));
    }

    @Test
    public void testRemotePreparedStatementFetch() throws Exception {
        Connection connection = DriverManager.getConnection("jdbc:avatica:remote:factory=" + LocalServiceMoreFactory.class.getName());
        Assert.assertThat((Object)connection.isClosed(), (Matcher)CoreMatchers.is((Object)false));
        String sql = "select * from \"foo\".\"bar\"";
        PreparedStatement preparedStatement = connection.prepareStatement(sql);
        Assert.assertThat((Object)preparedStatement.isClosed(), (Matcher)CoreMatchers.is((Object)false));
        boolean status = preparedStatement.execute();
        Assert.assertThat((Object)status, (Matcher)CoreMatchers.is((Object)true));
        ResultSet resultSet = preparedStatement.getResultSet();
        Assert.assertThat((Object)resultSet, (Matcher)CoreMatchers.notNullValue());
        int count = 0;
        while (resultSet.next()) {
            Assert.assertThat((Object)resultSet.getObject(1), (Matcher)CoreMatchers.notNullValue());
            ++count;
        }
        Assert.assertThat((Object)count, (Matcher)CoreMatchers.is((Object)101));
    }

    private static List<Object> values(Class clazz) {
        ArrayList list = Lists.newArrayList();
        for (Object sampleValue : SAMPLE_VALUES) {
            if (sampleValue.getClass() != clazz) continue;
            list.add(sampleValue);
        }
        return list;
    }

    private Object convert(Object o, Class clazz) throws ParseException {
        if (o.getClass() == clazz) {
            return o;
        }
        if (clazz == String.class) {
            return o.toString();
        }
        if (clazz == Boolean.class) {
            return o instanceof Number && ((Number)o).intValue() != 0 || o instanceof String && ((String)o).equalsIgnoreCase("true");
        }
        if (clazz == byte[].class && o instanceof String) {
            return ((String)o).getBytes(StandardCharsets.UTF_8);
        }
        if (clazz == Timestamp.class && o instanceof String) {
            return Timestamp.valueOf((String)o);
        }
        if (clazz == Time.class && o instanceof String) {
            return Time.valueOf((String)o);
        }
        if (clazz == Date.class && o instanceof String) {
            return Date.valueOf((String)o);
        }
        if (clazz == java.util.Date.class && o instanceof String) {
            DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3, Locale.ROOT);
            return dateFormat.parse((String)o);
        }
        if (clazz == Calendar.class && o instanceof String) {
            return Util.calendar();
        }
        if (o instanceof Boolean) {
            o = (Boolean)o != false ? 1 : 0;
        }
        if (o instanceof Number) {
            Number number = (Number)o;
            if (Number.class.isAssignableFrom(clazz)) {
                if (clazz == BigDecimal.class) {
                    if (o instanceof Double || o instanceof Float) {
                        return new BigDecimal(number.doubleValue());
                    }
                    return new BigDecimal(number.longValue());
                }
                if (clazz == BigInteger.class) {
                    return new BigInteger(o.toString());
                }
                if (clazz == Byte.class || clazz == Byte.TYPE) {
                    return number.byteValue();
                }
                if (clazz == Short.class || clazz == Short.TYPE) {
                    return number.shortValue();
                }
                if (clazz == Integer.class || clazz == Integer.TYPE) {
                    return number.intValue();
                }
                if (clazz == Long.class || clazz == Long.TYPE) {
                    return number.longValue();
                }
                if (clazz == Float.class || clazz == Float.TYPE) {
                    return Float.valueOf(number.floatValue());
                }
                if (clazz == Double.class || clazz == Double.TYPE) {
                    return number.doubleValue();
                }
            }
        }
        if (Number.class.isAssignableFrom(clazz)) {
            if (clazz == BigDecimal.class) {
                return new BigDecimal(o.toString());
            }
            if (clazz == BigInteger.class) {
                return new BigInteger(o.toString());
            }
            if (clazz == Byte.class || clazz == Byte.TYPE) {
                return Byte.valueOf(o.toString());
            }
            if (clazz == Short.class || clazz == Short.TYPE) {
                return Short.valueOf(o.toString());
            }
            if (clazz == Integer.class || clazz == Integer.TYPE) {
                return Integer.valueOf(o.toString());
            }
            if (clazz == Long.class || clazz == Long.TYPE) {
                return Long.valueOf(o.toString());
            }
            if (clazz == Float.class || clazz == Float.TYPE) {
                return Float.valueOf(o.toString());
            }
            if (clazz == Double.class || clazz == Double.TYPE) {
                return Double.valueOf(o.toString());
            }
        }
        throw new AssertionError((Object)("cannot convert " + o + "(" + o.getClass() + ") to " + clazz));
    }

    @Test
    public void testInsert() throws Exception {
        Connection connection = DriverManager.getConnection("jdbc:avatica:remote:factory=" + LocalServiceModifiableFactory.class.getName());
        Assert.assertThat((Object)connection.isClosed(), (Matcher)CoreMatchers.is((Object)false));
        Statement statement = connection.createStatement();
        Assert.assertThat((Object)statement.isClosed(), (Matcher)CoreMatchers.is((Object)false));
        String sql = "insert into \"foo\".\"bar\" values (1, 1, 'second', 2, 2)";
        boolean status = statement.execute(sql);
        Assert.assertThat((Object)status, (Matcher)CoreMatchers.is((Object)false));
        ResultSet resultSet = statement.getResultSet();
        Assert.assertThat((Object)resultSet, (Matcher)CoreMatchers.nullValue());
        int updateCount = statement.getUpdateCount();
        Assert.assertThat((Object)updateCount, (Matcher)CoreMatchers.is((Object)1));
        connection.close();
    }

    @Test
    public void testInsertBatch() throws Exception {
        Connection connection = DriverManager.getConnection("jdbc:avatica:remote:factory=" + LocalServiceModifiableFactory.class.getName());
        Assert.assertThat((Object)connection.getMetaData().supportsBatchUpdates(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)connection.isClosed(), (Matcher)CoreMatchers.is((Object)false));
        Statement statement = connection.createStatement();
        Assert.assertThat((Object)statement.isClosed(), (Matcher)CoreMatchers.is((Object)false));
        String sql = "insert into \"foo\".\"bar\" values (1, 1, 'second', 2, 2)";
        statement.addBatch(sql);
        statement.addBatch(sql);
        int[] updateCounts = statement.executeBatch();
        Assert.assertThat((Object)updateCounts.length, (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)updateCounts[0], (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)updateCounts[1], (Matcher)CoreMatchers.is((Object)1));
        ResultSet resultSet = statement.getResultSet();
        Assert.assertThat((Object)resultSet, (Matcher)CoreMatchers.nullValue());
        statement.clearBatch();
        updateCounts = statement.executeBatch();
        Assert.assertThat((Object)updateCounts.length, (Matcher)CoreMatchers.is((Object)0));
        resultSet = statement.getResultSet();
        Assert.assertThat((Object)resultSet, (Matcher)CoreMatchers.nullValue());
        connection.close();
    }

    @Test
    public void testRemotePreparedStatementInsert() throws Exception {
        Connection connection = DriverManager.getConnection("jdbc:avatica:remote:factory=" + LocalServiceModifiableFactory.class.getName());
        Assert.assertThat((Object)connection.isClosed(), (Matcher)CoreMatchers.is((Object)false));
        String sql = "insert into \"foo\".\"bar\" values (1, 1, 'second', 2, 2)";
        PreparedStatement preparedStatement = connection.prepareStatement(sql);
        Assert.assertThat((Object)preparedStatement.isClosed(), (Matcher)CoreMatchers.is((Object)false));
        boolean status = preparedStatement.execute();
        Assert.assertThat((Object)status, (Matcher)CoreMatchers.is((Object)false));
        ResultSet resultSet = preparedStatement.getResultSet();
        Assert.assertThat((Object)resultSet, (Matcher)CoreMatchers.nullValue());
        int updateCount = preparedStatement.getUpdateCount();
        Assert.assertThat((Object)updateCount, (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testRemotePreparedStatementInsert2() throws Exception {
    }

    static {
        SAMPLE_VALUES = ImmutableList.of((Object)false, (Object)true, (Object)0, (Object)1, (Object)-128, (Object)127, (Object)0, (Object)1, (Object)Short.MIN_VALUE, (Object)Short.MAX_VALUE, (Object)-128, (Object)127, (Object[])new Object[]{0, 1, -3, Integer.MIN_VALUE, Integer.MAX_VALUE, Short.MIN_VALUE, Short.MAX_VALUE, -128, 127, 0L, 1L, -2L, Long.MIN_VALUE, Long.MAX_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE, -32768L, 32767L, -128L, 127L, Float.valueOf(0.0f), Float.valueOf(1.5f), Float.valueOf(-10.0f), Float.valueOf(Float.MIN_VALUE), Float.valueOf(Float.MAX_VALUE), 0.0, Math.PI, Double.MIN_VALUE, Double.MAX_VALUE, (double)1.4E-45f, 3.4028234663852886E38, -2.147483648E9, 2.147483647E9, BigDecimal.ZERO, BigDecimal.ONE, BigDecimal.valueOf(2.5), BigDecimal.valueOf(Double.MAX_VALUE), BigDecimal.valueOf(Long.MIN_VALUE), new Timestamp(0L), new Date(0L), new Time(0L), "", "foo", " foo! Baz ", new byte[0], "hello".getBytes(StandardCharsets.UTF_8)});
    }

    public static class LocalServiceModifiableFactory
    implements Service.Factory {
        public Service create(AvaticaConnection connection) {
            try {
                Connection conn = JdbcFrontLinqBackTest.makeConnection();
                CalciteMetaImpl meta = new CalciteMetaImpl(conn.unwrap(CalciteConnectionImpl.class));
                return new LocalService((Meta)meta);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class Factory2
    implements Service.Factory {
        public Service create(AvaticaConnection connection) {
            try {
                Connection localConnection = CalciteAssert.hr().connect();
                Meta meta = CalciteConnectionImpl.TROJAN.getMeta((AvaticaConnection)((CalciteConnectionImpl)localConnection));
                return new LocalJsonService((Service)new LocalService(meta));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class Factory
    implements Meta.Factory {
        public Meta create(List<String> args) {
            try {
                Connection connection = CalciteAssert.hr().connect();
                return new CalciteMetaImpl((CalciteConnectionImpl)connection);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class LocalServiceMoreFactory
    implements Service.Factory {
        public Service create(AvaticaConnection connection) {
            try {
                Connection conn = CalciteRemoteDriverTest.makeConnection();
                CalciteMetaImpl meta = new CalciteMetaImpl(conn.unwrap(CalciteConnectionImpl.class));
                return new LocalService((Meta)meta);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

