/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelFieldCollation;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class RelCollationTest {
    @Test
    public void testCollationContains() {
        RelCollation collation = RelCollations.of((RelFieldCollation[])new RelFieldCollation[]{new RelFieldCollation(2, RelFieldCollation.Direction.ASCENDING), new RelFieldCollation(1, RelFieldCollation.Direction.DESCENDING)});
        Assert.assertThat((Object)RelCollations.contains((RelCollation)collation, Arrays.asList(2)), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)RelCollations.contains((RelCollation)collation, Arrays.asList(1)), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)RelCollations.contains((RelCollation)collation, Arrays.asList(0)), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)RelCollations.contains((RelCollation)collation, Arrays.asList(2, 1)), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)RelCollations.contains((RelCollation)collation, Arrays.asList(2, 0)), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)RelCollations.contains((RelCollation)collation, Arrays.asList(2, 1, 3)), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)RelCollations.contains((RelCollation)collation, Arrays.asList(new Integer[0])), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testCollationCompare() {
        Assert.assertThat((Object)RelCollationTest.collation(1, 2).compareTo((Object)RelCollationTest.collation(1, 2)), (Matcher)CoreMatchers.equalTo((Object)0));
        Assert.assertThat((Object)RelCollationTest.collation(1, 2).compareTo((Object)RelCollationTest.collation(1)), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)RelCollationTest.collation(1).compareTo((Object)RelCollationTest.collation(1, 2)), (Matcher)CoreMatchers.equalTo((Object)-1));
        Assert.assertThat((Object)RelCollationTest.collation(1, 3).compareTo((Object)RelCollationTest.collation(1, 2)), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)RelCollationTest.collation(0, 3).compareTo((Object)RelCollationTest.collation(1, 2)), (Matcher)CoreMatchers.equalTo((Object)-1));
        Assert.assertThat((Object)RelCollationTest.collation(new int[0]).compareTo((Object)RelCollationTest.collation(0)), (Matcher)CoreMatchers.equalTo((Object)-1));
        Assert.assertThat((Object)RelCollationTest.collation(1).compareTo((Object)RelCollationTest.collation(new int[0])), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    private static RelCollation collation(int ... ordinals) {
        ArrayList list = Lists.newArrayList();
        for (int ordinal : ordinals) {
            list.add(new RelFieldCollation(ordinal));
        }
        return RelCollations.of((List)list);
    }
}

