/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Ordering;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.calcite.rel.rules.DateRangeRules;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.test.RexImplicationCheckerTest;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;

public class DateRangeRulesTest {
    @Test
    public void testExtractYearFromDateColumn() {
        Fixture2 f = new Fixture2();
        RexNode e = f.eq((RexNode)f.literal(2014), f.exYear);
        Assert.assertThat((Object)DateRangeRules.extractTimeUnits((RexNode)e), (Matcher)Is.is(DateRangeRulesTest.set(TimeUnitRange.YEAR)));
        Assert.assertThat((Object)DateRangeRules.extractTimeUnits((RexNode)f.dec), (Matcher)Is.is(DateRangeRulesTest.set(new TimeUnitRange[0])));
        Assert.assertThat((Object)DateRangeRules.extractTimeUnits((RexNode)f.literal(1)), (Matcher)Is.is(DateRangeRulesTest.set(new TimeUnitRange[0])));
        this.checkDateRange(f, e, (Matcher<String>)Is.is((Object)"AND(>=($8, 2014-01-01), <($8, 2015-01-01))"));
        this.checkDateRange(f, f.eq(f.exYear, (RexNode)f.literal(2014)), (Matcher<String>)Is.is((Object)"AND(>=($8, 2014-01-01), <($8, 2015-01-01))"));
        this.checkDateRange(f, f.ge(f.exYear, (RexNode)f.literal(2014)), (Matcher<String>)Is.is((Object)">=($8, 2014-01-01)"));
        this.checkDateRange(f, f.gt(f.exYear, (RexNode)f.literal(2014)), (Matcher<String>)Is.is((Object)">=($8, 2015-01-01)"));
        this.checkDateRange(f, f.lt(f.exYear, (RexNode)f.literal(2014)), (Matcher<String>)Is.is((Object)"<($8, 2014-01-01)"));
        this.checkDateRange(f, f.le(f.exYear, (RexNode)f.literal(2014)), (Matcher<String>)Is.is((Object)"<($8, 2015-01-01)"));
        this.checkDateRange(f, f.ne(f.exYear, (RexNode)f.literal(2014)), (Matcher<String>)Is.is((Object)"<>(EXTRACT_DATE(FLAG(YEAR), $8), 2014)"));
    }

    @Test
    public void testExtractYearFromTimestampColumn() {
        Fixture2 f = new Fixture2();
        this.checkDateRange(f, f.eq(f.exYearTs, (RexNode)f.literal(2014)), (Matcher<String>)Is.is((Object)"AND(>=($9, 2014-01-01), <($9, 2015-01-01))"));
        this.checkDateRange(f, f.ge(f.exYearTs, (RexNode)f.literal(2014)), (Matcher<String>)Is.is((Object)">=($9, 2014-01-01)"));
        this.checkDateRange(f, f.gt(f.exYearTs, (RexNode)f.literal(2014)), (Matcher<String>)Is.is((Object)">=($9, 2015-01-01)"));
        this.checkDateRange(f, f.lt(f.exYearTs, (RexNode)f.literal(2014)), (Matcher<String>)Is.is((Object)"<($9, 2014-01-01)"));
        this.checkDateRange(f, f.le(f.exYearTs, (RexNode)f.literal(2014)), (Matcher<String>)Is.is((Object)"<($9, 2015-01-01)"));
        this.checkDateRange(f, f.ne(f.exYearTs, (RexNode)f.literal(2014)), (Matcher<String>)Is.is((Object)"<>(EXTRACT(FLAG(YEAR), $9), 2014)"));
    }

    @Test
    public void testExtractYearAndMonthFromDateColumn() {
        Fixture2 f = new Fixture2();
        this.checkDateRange(f, f.and(f.eq(f.exYear, (RexNode)f.literal(2014)), f.eq(f.exMonth, (RexNode)f.literal(6))), (Matcher<String>)Is.is((Object)"AND(AND(>=($8, 2014-01-01), <($8, 2015-01-01)), AND(>=($8, 2014-06-01), <($8, 2014-07-01)))"), (Matcher<String>)Is.is((Object)"AND(>=($8, 2014-01-01), <($8, 2015-01-01), >=($8, 2014-06-01), <($8, 2014-07-01))"));
    }

    @Test
    public void testExtractYearAndMonthFromDateColumn2() {
        Fixture2 f = new Fixture2();
        String s1 = "AND(AND(>=($8, 2000-01-01), <($8, 2001-01-01)), OR(AND(>=($8, 2000-02-01), <($8, 2000-03-01)), AND(>=($8, 2000-03-01), <($8, 2000-04-01)), AND(>=($8, 2000-05-01), <($8, 2000-06-01))))";
        String s2 = "AND(>=($8, 2000-01-01), <($8, 2001-01-01), OR(AND(>=($8, 2000-02-01), <($8, 2000-03-01)), AND(>=($8, 2000-03-01), <($8, 2000-04-01)), AND(>=($8, 2000-05-01), <($8, 2000-06-01))))";
        RexNode e = f.and(f.eq(f.exYear, (RexNode)f.literal(2000)), f.or(f.eq(f.exMonth, (RexNode)f.literal(2)), f.eq(f.exMonth, (RexNode)f.literal(3)), f.eq(f.exMonth, (RexNode)f.literal(5))));
        this.checkDateRange(f, e, (Matcher<String>)Is.is((Object)"AND(AND(>=($8, 2000-01-01), <($8, 2001-01-01)), OR(AND(>=($8, 2000-02-01), <($8, 2000-03-01)), AND(>=($8, 2000-03-01), <($8, 2000-04-01)), AND(>=($8, 2000-05-01), <($8, 2000-06-01))))"), (Matcher<String>)Is.is((Object)"AND(>=($8, 2000-01-01), <($8, 2001-01-01), OR(AND(>=($8, 2000-02-01), <($8, 2000-03-01)), AND(>=($8, 2000-03-01), <($8, 2000-04-01)), AND(>=($8, 2000-05-01), <($8, 2000-06-01))))"));
    }

    @Test
    public void testExtractYearAndDayFromDateColumn() {
        Fixture2 f = new Fixture2();
        this.checkDateRange(f, f.and(f.eq(f.exYear, (RexNode)f.literal(2010)), f.eq(f.exDay, (RexNode)f.literal(31))), (Matcher<String>)Is.is((Object)"AND(AND(>=($8, 2010-01-01), <($8, 2011-01-01)), OR(AND(>=($8, 2010-01-31), <($8, 2010-02-01)), AND(>=($8, 2010-03-31), <($8, 2010-04-01)), AND(>=($8, 2010-05-31), <($8, 2010-06-01)), AND(>=($8, 2010-07-31), <($8, 2010-08-01)), AND(>=($8, 2010-08-31), <($8, 2010-09-01)), AND(>=($8, 2010-10-31), <($8, 2010-11-01)), AND(>=($8, 2010-12-31), <($8, 2011-01-01))))"));
    }

    @Test
    public void testExtractYearMonthDayFromDateColumn() {
        Fixture2 f = new Fixture2();
        this.checkDateRange(f, f.and(f.gt(f.exYear, (RexNode)f.literal(2010)), f.lt(f.exYear, (RexNode)f.literal(2020)), f.eq(f.exMonth, (RexNode)f.literal(2)), f.eq(f.exDay, (RexNode)f.literal(29))), (Matcher<String>)Is.is((Object)"AND(>=($8, 2011-01-01), AND(>=($8, 2011-01-01), <($8, 2020-01-01)), OR(AND(>=($8, 2011-02-01), <($8, 2011-03-01)), AND(>=($8, 2012-02-01), <($8, 2012-03-01)), AND(>=($8, 2013-02-01), <($8, 2013-03-01)), AND(>=($8, 2014-02-01), <($8, 2014-03-01)), AND(>=($8, 2015-02-01), <($8, 2015-03-01)), AND(>=($8, 2016-02-01), <($8, 2016-03-01)), AND(>=($8, 2017-02-01), <($8, 2017-03-01)), AND(>=($8, 2018-02-01), <($8, 2018-03-01)), AND(>=($8, 2019-02-01), <($8, 2019-03-01))), OR(AND(>=($8, 2012-02-29), <($8, 2012-03-01)), AND(>=($8, 2016-02-29), <($8, 2016-03-01))))"));
    }

    @Test
    public void testExtractYearMonthDayFromTimestampColumn() {
        Fixture2 f = new Fixture2();
        this.checkDateRange(f, f.and(f.gt(f.exYearTs, (RexNode)f.literal(2010)), f.lt(f.exYearTs, (RexNode)f.literal(2020)), f.eq(f.exMonthTs, (RexNode)f.literal(2)), f.eq(f.exDayTs, (RexNode)f.literal(29))), (Matcher<String>)Is.is((Object)"AND(>=($9, 2011-01-01), AND(>=($9, 2011-01-01), <($9, 2020-01-01)), OR(AND(>=($9, 2011-02-01), <($9, 2011-03-01)), AND(>=($9, 2012-02-01), <($9, 2012-03-01)), AND(>=($9, 2013-02-01), <($9, 2013-03-01)), AND(>=($9, 2014-02-01), <($9, 2014-03-01)), AND(>=($9, 2015-02-01), <($9, 2015-03-01)), AND(>=($9, 2016-02-01), <($9, 2016-03-01)), AND(>=($9, 2017-02-01), <($9, 2017-03-01)), AND(>=($9, 2018-02-01), <($9, 2018-03-01)), AND(>=($9, 2019-02-01), <($9, 2019-03-01))), OR(AND(>=($9, 2012-02-29), <($9, 2012-03-01)), AND(>=($9, 2016-02-29), <($9, 2016-03-01))))"));
    }

    private static Set<TimeUnitRange> set(TimeUnitRange ... es) {
        return ImmutableSet.copyOf((Object[])es);
    }

    private void checkDateRange(RexImplicationCheckerTest.Fixture f, RexNode e, Matcher<String> matcher) {
        this.checkDateRange(f, e, matcher, (Matcher<String>)CoreMatchers.any(String.class));
    }

    private void checkDateRange(RexImplicationCheckerTest.Fixture f, RexNode e, Matcher<String> matcher, Matcher<String> simplifyMatcher) {
        HashMap operandRanges = new HashMap();
        List timeUnits = Ordering.natural().sortedCopy((Iterable)DateRangeRules.extractTimeUnits((RexNode)e));
        for (TimeUnitRange timeUnit : timeUnits) {
            e = (RexNode)e.accept((RexVisitor)new DateRangeRules.ExtractShuttle(f.rexBuilder, timeUnit, operandRanges));
        }
        Assert.assertThat((Object)e.toString(), matcher);
        RexNode e2 = f.simplify.simplify(e);
        Assert.assertThat((Object)e2.toString(), simplifyMatcher);
    }

    private static class Fixture2
    extends RexImplicationCheckerTest.Fixture {
        private final RexNode exYear;
        private final RexNode exMonth;
        private final RexNode exDay;
        private final RexNode exYearTs;
        private final RexNode exMonthTs;
        private final RexNode exDayTs;

        Fixture2() {
            this.exYear = this.rexBuilder.makeCall(this.intRelDataType, (SqlOperator)SqlStdOperatorTable.EXTRACT_DATE, (List)ImmutableList.of((Object)this.rexBuilder.makeFlag((Enum)TimeUnitRange.YEAR), (Object)this.dt));
            this.exMonth = this.rexBuilder.makeCall(this.intRelDataType, (SqlOperator)SqlStdOperatorTable.EXTRACT_DATE, (List)ImmutableList.of((Object)this.rexBuilder.makeFlag((Enum)TimeUnitRange.MONTH), (Object)this.dt));
            this.exDay = this.rexBuilder.makeCall(this.intRelDataType, (SqlOperator)SqlStdOperatorTable.EXTRACT_DATE, (List)ImmutableList.of((Object)this.rexBuilder.makeFlag((Enum)TimeUnitRange.DAY), (Object)this.dt));
            this.exYearTs = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EXTRACT, (List)ImmutableList.of((Object)this.rexBuilder.makeFlag((Enum)TimeUnitRange.YEAR), (Object)this.ts));
            this.exMonthTs = this.rexBuilder.makeCall(this.intRelDataType, (SqlOperator)SqlStdOperatorTable.EXTRACT, (List)ImmutableList.of((Object)this.rexBuilder.makeFlag((Enum)TimeUnitRange.MONTH), (Object)this.ts));
            this.exDayTs = this.rexBuilder.makeCall(this.intRelDataType, (SqlOperator)SqlStdOperatorTable.EXTRACT, (List)ImmutableList.of((Object)this.rexBuilder.makeFlag((Enum)TimeUnitRange.DAY), (Object)this.ts));
        }
    }
}

