/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.test;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import javax.annotation.Nonnull;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.avatica.util.Casing;
import org.apache.calcite.avatica.util.Quoting;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.advise.SqlAdvisor;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.test.SqlTestFactory;
import org.apache.calcite.sql.validate.SqlConformance;
import org.apache.calcite.sql.validate.SqlConformanceEnum;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorCatalogReader;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.sql.validate.SqlValidatorWithHints;
import org.apache.calcite.test.CalciteAssert;
import org.apache.calcite.test.MockCatalogReader;
import org.apache.calcite.test.MockSqlOperatorTable;

public class DefaultSqlTestFactory
implements SqlTestFactory {
    public static final ImmutableMap<String, Object> DEFAULT_OPTIONS = ImmutableMap.builder().put((Object)"quoting", (Object)Quoting.DOUBLE_QUOTE).put((Object)"quotedCasing", (Object)Casing.UNCHANGED).put((Object)"unquotedCasing", (Object)Casing.TO_UPPER).put((Object)"caseSensitive", (Object)true).put((Object)"conformance", (Object)SqlConformanceEnum.DEFAULT).put((Object)"operatorTable", (Object)SqlStdOperatorTable.instance()).put((Object)"connectionFactory", (Object)CalciteAssert.EMPTY_CONNECTION_FACTORY.with(new CalciteAssert.AddSchemaSpecPostProcessor(CalciteAssert.SchemaSpec.HR))).build();
    private final LoadingCache<SqlTestFactory, Xyz> cache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<SqlTestFactory, Xyz>(){

        public Xyz load(@Nonnull SqlTestFactory factory) throws Exception {
            SqlOperatorTable operatorTable = factory.createOperatorTable(factory);
            boolean caseSensitive = (Boolean)factory.get("caseSensitive");
            JavaTypeFactoryImpl typeFactory = new JavaTypeFactoryImpl(RelDataTypeSystem.DEFAULT);
            return new Xyz(operatorTable, (JavaTypeFactory)typeFactory, new MockCatalogReader((RelDataTypeFactory)typeFactory, caseSensitive).init());
        }
    });
    public static final DefaultSqlTestFactory INSTANCE = new DefaultSqlTestFactory();

    private DefaultSqlTestFactory() {
    }

    @Override
    public SqlOperatorTable createOperatorTable(SqlTestFactory factory) {
        SqlOperatorTable opTab0 = (SqlOperatorTable)factory.get("operatorTable");
        MockSqlOperatorTable opTab = new MockSqlOperatorTable(opTab0);
        MockSqlOperatorTable.addRamp(opTab);
        return opTab;
    }

    @Override
    public SqlParser createParser(SqlTestFactory factory, String sql) {
        return SqlParser.create((String)sql, (SqlParser.Config)SqlParser.configBuilder().setQuoting((Quoting)factory.get("quoting")).setUnquotedCasing((Casing)factory.get("unquotedCasing")).setQuotedCasing((Casing)factory.get("quotedCasing")).setConformance((SqlConformance)factory.get("conformance")).build());
    }

    @Override
    public SqlValidator getValidator(SqlTestFactory factory) {
        Xyz xyz = (Xyz)this.cache.getUnchecked((Object)factory);
        SqlConformance conformance = (SqlConformance)factory.get("conformance");
        return SqlValidatorUtil.newValidator((SqlOperatorTable)xyz.operatorTable, (SqlValidatorCatalogReader)xyz.catalogReader, (RelDataTypeFactory)xyz.typeFactory, (SqlConformance)conformance);
    }

    @Override
    public SqlAdvisor createAdvisor(SqlValidatorWithHints validator) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object get(String name) {
        return DEFAULT_OPTIONS.get((Object)name);
    }

    private static class Xyz {
        private final SqlOperatorTable operatorTable;
        private final JavaTypeFactory typeFactory;
        private final MockCatalogReader catalogReader;

        Xyz(SqlOperatorTable operatorTable, JavaTypeFactory typeFactory, MockCatalogReader catalogReader) {
            this.operatorTable = operatorTable;
            this.typeFactory = typeFactory;
            this.catalogReader = catalogReader;
        }
    }
}

