/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.calcite.DataContext;
import org.apache.calcite.jdbc.CalciteConnection;
import org.apache.calcite.linq4j.AbstractEnumerable;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.runtime.CalciteContextException;
import org.apache.calcite.schema.ScannableTable;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Statistic;
import org.apache.calcite.schema.Statistics;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.test.CalciteAssert;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class CollectionTypeTest {
    @Test
    public void testAccessNestedMap() throws Exception {
        Connection connection = this.setupConnectionWithNestedTable();
        Statement statement = connection.createStatement();
        String sql = "select \"ID\", \"MAPFIELD\"['c'] AS \"MAPFIELD_C\", \"NESTEDMAPFIELD\", \"ARRAYFIELD\" from \"s\".\"nested\" where \"NESTEDMAPFIELD\"['a']['b'] = 2 AND \"ARRAYFIELD\"[2] = 200";
        ResultSet resultSet = statement.executeQuery("select \"ID\", \"MAPFIELD\"['c'] AS \"MAPFIELD_C\", \"NESTEDMAPFIELD\", \"ARRAYFIELD\" from \"s\".\"nested\" where \"NESTEDMAPFIELD\"['a']['b'] = 2 AND \"ARRAYFIELD\"[2] = 200");
        List<String> resultStrings = CalciteAssert.toList(resultSet);
        Assert.assertThat((Object)resultStrings.size(), (Matcher)CoreMatchers.is((Object)1));
        String expectedRow = "ID=2; MAPFIELD_C=4; NESTEDMAPFIELD={a={b=2, c=4}}; ARRAYFIELD=[100, 200, 300]";
        Assert.assertThat((Object)resultStrings.get(0), (Matcher)CoreMatchers.is((Object)expectedRow));
    }

    @Test
    public void testAccessNonExistKeyFromMap() throws Exception {
        Connection connection = this.setupConnectionWithNestedTable();
        Statement statement = connection.createStatement();
        String sql = "select \"ID\", \"MAPFIELD\", \"NESTEDMAPFIELD\", \"ARRAYFIELD\" from \"s\".\"nested\" where \"MAPFIELD\"['a'] = 2";
        ResultSet resultSet = statement.executeQuery("select \"ID\", \"MAPFIELD\", \"NESTEDMAPFIELD\", \"ARRAYFIELD\" from \"s\".\"nested\" where \"MAPFIELD\"['a'] = 2");
        List<String> resultStrings = CalciteAssert.toList(resultSet);
        Assert.assertThat((Object)resultStrings.size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void testAccessNonExistKeyFromNestedMap() throws Exception {
        Connection connection = this.setupConnectionWithNestedTable();
        Statement statement = connection.createStatement();
        String sql = "select \"ID\", \"MAPFIELD\", \"NESTEDMAPFIELD\", \"ARRAYFIELD\" from \"s\".\"nested\" where \"NESTEDMAPFIELD\"['b']['c'] = 4";
        ResultSet resultSet = statement.executeQuery("select \"ID\", \"MAPFIELD\", \"NESTEDMAPFIELD\", \"ARRAYFIELD\" from \"s\".\"nested\" where \"NESTEDMAPFIELD\"['b']['c'] = 4");
        List<String> resultStrings = CalciteAssert.toList(resultSet);
        Assert.assertThat((Object)resultStrings.size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void testInvalidAccessUseStringForIndexOnArray() throws Exception {
        Connection connection = this.setupConnectionWithNestedTable();
        Statement statement = connection.createStatement();
        try {
            String sql = "select \"ID\", \"MAPFIELD\", \"NESTEDMAPFIELD\", \"ARRAYFIELD\" from \"s\".\"nested\" where \"ARRAYFIELD\"['a'] = 200";
            statement.executeQuery("select \"ID\", \"MAPFIELD\", \"NESTEDMAPFIELD\", \"ARRAYFIELD\" from \"s\".\"nested\" where \"ARRAYFIELD\"['a'] = 200");
            Assert.fail((String)"This query shouldn't be evaluated properly");
        }
        catch (SQLException e) {
            Throwable e2 = e.getCause();
            Assert.assertThat((Object)e2, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(CalciteContextException.class)));
        }
    }

    @Test
    public void testNestedArrayOutOfBoundAccess() throws Exception {
        Connection connection = this.setupConnectionWithNestedTable();
        Statement statement = connection.createStatement();
        String sql = "select \"ID\", \"MAPFIELD\", \"NESTEDMAPFIELD\", \"ARRAYFIELD\" from \"s\".\"nested\" where \"ARRAYFIELD\"[10] = 200";
        ResultSet resultSet = statement.executeQuery("select \"ID\", \"MAPFIELD\", \"NESTEDMAPFIELD\", \"ARRAYFIELD\" from \"s\".\"nested\" where \"ARRAYFIELD\"[10] = 200");
        List<String> resultStrings = CalciteAssert.toList(resultSet);
        Assert.assertThat((Object)resultStrings.size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void testAccessNestedMapWithAnyType() throws Exception {
        Connection connection = this.setupConnectionWithNestedAnyTypeTable();
        Statement statement = connection.createStatement();
        String sql = "select \"ID\", \"MAPFIELD\"['c'] AS \"MAPFIELD_C\", \"NESTEDMAPFIELD\", \"ARRAYFIELD\" from \"s\".\"nested\" where CAST(\"NESTEDMAPFIELD\"['a']['b'] AS INTEGER) = 2 AND CAST(\"ARRAYFIELD\"[2] AS INTEGER) = 200";
        ResultSet resultSet = statement.executeQuery("select \"ID\", \"MAPFIELD\"['c'] AS \"MAPFIELD_C\", \"NESTEDMAPFIELD\", \"ARRAYFIELD\" from \"s\".\"nested\" where CAST(\"NESTEDMAPFIELD\"['a']['b'] AS INTEGER) = 2 AND CAST(\"ARRAYFIELD\"[2] AS INTEGER) = 200");
        List<String> resultStrings = CalciteAssert.toList(resultSet);
        Assert.assertThat((Object)resultStrings.size(), (Matcher)CoreMatchers.is((Object)1));
        String expectedRow = "ID=2; MAPFIELD_C=4; NESTEDMAPFIELD={a={b=2, c=4}}; ARRAYFIELD=[100, 200, 300]";
        Assert.assertThat((Object)resultStrings.get(0), (Matcher)CoreMatchers.is((Object)expectedRow));
    }

    @Test
    public void testAccessNestedMapWithAnyTypeWithoutCast() throws Exception {
        Connection connection = this.setupConnectionWithNestedAnyTypeTable();
        Statement statement = connection.createStatement();
        String sql = "select \"ID\", \"MAPFIELD\"['c'] AS \"MAPFIELD_C\", \"NESTEDMAPFIELD\", \"ARRAYFIELD\" from \"s\".\"nested\" where \"NESTEDMAPFIELD\"['a']['b'] = 2 AND 200.0 = \"ARRAYFIELD\"[2]";
        ResultSet resultSet = statement.executeQuery("select \"ID\", \"MAPFIELD\"['c'] AS \"MAPFIELD_C\", \"NESTEDMAPFIELD\", \"ARRAYFIELD\" from \"s\".\"nested\" where \"NESTEDMAPFIELD\"['a']['b'] = 2 AND 200.0 = \"ARRAYFIELD\"[2]");
        List<String> resultStrings = CalciteAssert.toList(resultSet);
        Assert.assertThat((Object)resultStrings.size(), (Matcher)CoreMatchers.is((Object)1));
        String expectedRow = "ID=2; MAPFIELD_C=4; NESTEDMAPFIELD={a={b=2, c=4}}; ARRAYFIELD=[100, 200, 300]";
        Assert.assertThat((Object)resultStrings.get(0), (Matcher)CoreMatchers.is((Object)expectedRow));
    }

    @Test
    public void testArithmeticToAnyTypeWithoutCast() throws Exception {
        Connection connection = this.setupConnectionWithNestedAnyTypeTable();
        Statement statement = connection.createStatement();
        String sql = "select \"ID\", \"MAPFIELD\"['c'] AS \"MAPFIELD_C\", \"NESTEDMAPFIELD\", \"ARRAYFIELD\" from \"s\".\"nested\" where \"NESTEDMAPFIELD\"['a']['b'] + 1.0 = 3 AND \"NESTEDMAPFIELD\"['a']['b'] * 2.0 = 4 AND \"NESTEDMAPFIELD\"['a']['b'] > 1AND \"NESTEDMAPFIELD\"['a']['b'] >= 2AND 100.1 <> \"ARRAYFIELD\"[2] - 100.0AND 100.0 = \"ARRAYFIELD\"[2] / 2AND 99.9 < \"ARRAYFIELD\"[2] / 2AND 100.0 <= \"ARRAYFIELD\"[2] / 2AND '200' <> \"STRINGARRAYFIELD\"[1]AND '200' = \"STRINGARRAYFIELD\"[2]AND '100' < \"STRINGARRAYFIELD\"[2]";
        ResultSet resultSet = statement.executeQuery("select \"ID\", \"MAPFIELD\"['c'] AS \"MAPFIELD_C\", \"NESTEDMAPFIELD\", \"ARRAYFIELD\" from \"s\".\"nested\" where \"NESTEDMAPFIELD\"['a']['b'] + 1.0 = 3 AND \"NESTEDMAPFIELD\"['a']['b'] * 2.0 = 4 AND \"NESTEDMAPFIELD\"['a']['b'] > 1AND \"NESTEDMAPFIELD\"['a']['b'] >= 2AND 100.1 <> \"ARRAYFIELD\"[2] - 100.0AND 100.0 = \"ARRAYFIELD\"[2] / 2AND 99.9 < \"ARRAYFIELD\"[2] / 2AND 100.0 <= \"ARRAYFIELD\"[2] / 2AND '200' <> \"STRINGARRAYFIELD\"[1]AND '200' = \"STRINGARRAYFIELD\"[2]AND '100' < \"STRINGARRAYFIELD\"[2]");
        List<String> resultStrings = CalciteAssert.toList(resultSet);
        Assert.assertThat((Object)resultStrings.size(), (Matcher)CoreMatchers.is((Object)1));
        String expectedRow = "ID=2; MAPFIELD_C=4; NESTEDMAPFIELD={a={b=2, c=4}}; ARRAYFIELD=[100, 200, 300]";
        Assert.assertThat((Object)resultStrings.get(0), (Matcher)CoreMatchers.is((Object)expectedRow));
    }

    @Test
    public void testAccessNonExistKeyFromMapWithAnyType() throws Exception {
        Connection connection = this.setupConnectionWithNestedTable();
        Statement statement = connection.createStatement();
        String sql = "select \"ID\", \"MAPFIELD\", \"NESTEDMAPFIELD\", \"ARRAYFIELD\" from \"s\".\"nested\" where CAST(\"MAPFIELD\"['a'] AS INTEGER) = 2";
        ResultSet resultSet = statement.executeQuery("select \"ID\", \"MAPFIELD\", \"NESTEDMAPFIELD\", \"ARRAYFIELD\" from \"s\".\"nested\" where CAST(\"MAPFIELD\"['a'] AS INTEGER) = 2");
        List<String> resultStrings = CalciteAssert.toList(resultSet);
        Assert.assertThat((Object)resultStrings.size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void testAccessNonExistKeyFromNestedMapWithAnyType() throws Exception {
        Connection connection = this.setupConnectionWithNestedTable();
        Statement statement = connection.createStatement();
        String sql = "select \"ID\", \"MAPFIELD\", \"NESTEDMAPFIELD\", \"ARRAYFIELD\" from \"s\".\"nested\" where CAST(\"NESTEDMAPFIELD\"['b']['c'] AS INTEGER) = 4";
        ResultSet resultSet = statement.executeQuery("select \"ID\", \"MAPFIELD\", \"NESTEDMAPFIELD\", \"ARRAYFIELD\" from \"s\".\"nested\" where CAST(\"NESTEDMAPFIELD\"['b']['c'] AS INTEGER) = 4");
        List<String> resultStrings = CalciteAssert.toList(resultSet);
        Assert.assertThat((Object)resultStrings.size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void testInvalidAccessUseStringForIndexOnArrayWithAnyType() throws Exception {
        Connection connection = this.setupConnectionWithNestedTable();
        Statement statement = connection.createStatement();
        try {
            String sql = "select \"ID\", \"MAPFIELD\", \"NESTEDMAPFIELD\", \"ARRAYFIELD\" from \"s\".\"nested\" where CAST(\"ARRAYFIELD\"['a'] AS INTEGER) = 200";
            statement.executeQuery("select \"ID\", \"MAPFIELD\", \"NESTEDMAPFIELD\", \"ARRAYFIELD\" from \"s\".\"nested\" where CAST(\"ARRAYFIELD\"['a'] AS INTEGER) = 200");
            Assert.fail((String)"This query shouldn't be evaluated properly");
        }
        catch (SQLException e) {
            Throwable e2 = e.getCause();
            Assert.assertThat((Object)e2, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(CalciteContextException.class)));
        }
    }

    @Test
    public void testNestedArrayOutOfBoundAccessWithAnyType() throws Exception {
        Connection connection = this.setupConnectionWithNestedTable();
        Statement statement = connection.createStatement();
        String sql = "select \"ID\", \"MAPFIELD\", \"NESTEDMAPFIELD\", \"ARRAYFIELD\" from \"s\".\"nested\" where CAST(\"ARRAYFIELD\"[10] AS INTEGER) = 200";
        ResultSet resultSet = statement.executeQuery("select \"ID\", \"MAPFIELD\", \"NESTEDMAPFIELD\", \"ARRAYFIELD\" from \"s\".\"nested\" where CAST(\"ARRAYFIELD\"[10] AS INTEGER) = 200");
        List<String> resultStrings = CalciteAssert.toList(resultSet);
        Assert.assertThat((Object)resultStrings.size(), (Matcher)CoreMatchers.is((Object)0));
    }

    private Connection setupConnectionWithNestedTable() throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:calcite:");
        CalciteConnection calciteConnection = connection.unwrap(CalciteConnection.class);
        SchemaPlus rootSchema = calciteConnection.getRootSchema();
        SchemaPlus schema = rootSchema.add("s", (Schema)new AbstractSchema());
        schema.add("nested", (Table)new NestedCollectionTable());
        return connection;
    }

    private Connection setupConnectionWithNestedAnyTypeTable() throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:calcite:");
        CalciteConnection calciteConnection = connection.unwrap(CalciteConnection.class);
        SchemaPlus rootSchema = calciteConnection.getRootSchema();
        SchemaPlus schema = rootSchema.add("s", (Schema)new AbstractSchema());
        schema.add("nested", (Table)new NestedCollectionWithAnyTypeTable());
        return connection;
    }

    public static Enumerator<Object[]> nestedRecordsEnumerator() {
        final Object[][] records = CollectionTypeTest.setupNestedRecords();
        return new Enumerator<Object[]>(){
            int row = -1;
            int returnCount = 0;
            Object[] current;

            public Object[] current() {
                return this.current;
            }

            public boolean moveNext() {
                if (++this.row < 5) {
                    this.current = records[this.row];
                    ++this.returnCount;
                    return true;
                }
                return false;
            }

            public void reset() {
                this.row = -1;
            }

            public void close() {
                this.current = null;
            }
        };
    }

    private static Object[][] setupNestedRecords() {
        List<Integer> ints = Arrays.asList(100, 200, 300);
        List<String> strings = Arrays.asList("100", "200", "300");
        Object[][] records = new Object[5][];
        for (int i = 0; i < 5; ++i) {
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            map.put("b", i);
            map.put("c", i * i);
            HashMap<String, HashMap<String, Integer>> mm = new HashMap<String, HashMap<String, Integer>>();
            mm.put("a", map);
            records[i] = new Object[]{i, map, mm, ints, strings};
        }
        return records;
    }

    public static class NestedCollectionWithAnyTypeTable
    implements ScannableTable {
        public RelDataType getRowType(RelDataTypeFactory typeFactory) {
            return typeFactory.builder().add("ID", SqlTypeName.INTEGER).add("MAPFIELD", SqlTypeName.ANY).add("NESTEDMAPFIELD", SqlTypeName.ANY).add("ARRAYFIELD", SqlTypeName.ANY).add("STRINGARRAYFIELD", SqlTypeName.ANY).build();
        }

        public Statistic getStatistic() {
            return Statistics.UNKNOWN;
        }

        public Schema.TableType getJdbcTableType() {
            return Schema.TableType.TABLE;
        }

        public Enumerable<Object[]> scan(DataContext root) {
            return new AbstractEnumerable<Object[]>(){

                public Enumerator<Object[]> enumerator() {
                    return CollectionTypeTest.nestedRecordsEnumerator();
                }
            };
        }
    }

    public static class NestedCollectionTable
    implements ScannableTable {
        public RelDataType getRowType(RelDataTypeFactory typeFactory) {
            RelDataType nullableVarcharType = typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.VARCHAR), true);
            RelDataType nullableIntegerType = typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.INTEGER), true);
            RelDataType nullableMapType = typeFactory.createTypeWithNullability(typeFactory.createMapType(nullableVarcharType, nullableIntegerType), true);
            return typeFactory.builder().add("ID", SqlTypeName.INTEGER).add("MAPFIELD", typeFactory.createTypeWithNullability(typeFactory.createMapType(nullableVarcharType, nullableIntegerType), true)).add("NESTEDMAPFIELD", typeFactory.createTypeWithNullability(typeFactory.createMapType(nullableVarcharType, nullableMapType), true)).add("ARRAYFIELD", typeFactory.createTypeWithNullability(typeFactory.createArrayType(nullableIntegerType, -1L), true)).add("STRINGARRAYFIELD", typeFactory.createTypeWithNullability(typeFactory.createArrayType(nullableVarcharType, -1L), true)).build();
        }

        public Statistic getStatistic() {
            return Statistics.UNKNOWN;
        }

        public Schema.TableType getJdbcTableType() {
            return Schema.TableType.TABLE;
        }

        public Enumerable<Object[]> scan(DataContext root) {
            return new AbstractEnumerable<Object[]>(){

                public Enumerator<Object[]> enumerator() {
                    return CollectionTypeTest.nestedRecordsEnumerator();
                }
            };
        }
    }
}

