/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.jdbc.CalcitePrepare;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.linq4j.QueryProvider;
import org.apache.calcite.linq4j.Queryable;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelDistribution;
import org.apache.calcite.rel.RelDistributions;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelReferentialConstraint;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.logical.LogicalTableScan;
import org.apache.calcite.rel.type.DynamicRecordTypeImpl;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeComparability;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeFamily;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeFieldImpl;
import org.apache.calcite.rel.type.RelDataTypeImpl;
import org.apache.calcite.rel.type.RelDataTypePrecedenceList;
import org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.calcite.rel.type.RelRecordType;
import org.apache.calcite.rel.type.StructKind;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.schema.CustomColumnResolvingTable;
import org.apache.calcite.schema.ExtensibleTable;
import org.apache.calcite.schema.Path;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Schemas;
import org.apache.calcite.schema.Statistic;
import org.apache.calcite.schema.StreamableTable;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.TranslatableTable;
import org.apache.calcite.schema.Wrapper;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.calcite.schema.impl.ModifiableViewTable;
import org.apache.calcite.schema.impl.ViewTableMacro;
import org.apache.calcite.sql.SqlAccessType;
import org.apache.calcite.sql.SqlCollation;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.ObjectSqlType;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.SqlModality;
import org.apache.calcite.sql.validate.SqlMonotonicity;
import org.apache.calcite.sql.validate.SqlNameMatcher;
import org.apache.calcite.sql.validate.SqlNameMatchers;
import org.apache.calcite.sql2rel.InitializerContext;
import org.apache.calcite.sql2rel.InitializerExpressionFactory;
import org.apache.calcite.sql2rel.NullInitializerExpressionFactory;
import org.apache.calcite.test.JdbcTest;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.Litmus;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;

public class MockCatalogReader
extends CalciteCatalogReader {
    static final String DEFAULT_CATALOG = "CATALOG";
    static final String DEFAULT_SCHEMA = "SALES";
    static final List<String> PREFIX = ImmutableList.of((Object)"SALES");
    private RelDataType addressType;

    public MockCatalogReader(RelDataTypeFactory typeFactory, boolean caseSensitive) {
        super(CalciteSchema.createRootSchema((boolean)false, (boolean)true, (String)DEFAULT_CATALOG), SqlNameMatchers.withCaseSensitive((boolean)caseSensitive), (List)ImmutableList.of(PREFIX, (Object)ImmutableList.of()), typeFactory);
    }

    public boolean isCaseSensitive() {
        return this.nameMatcher.isCaseSensitive();
    }

    public SqlNameMatcher nameMatcher() {
        return this.nameMatcher;
    }

    public MockCatalogReader init() {
        Fixture f = new Fixture();
        this.addressType = f.addressType;
        MockSchema salesSchema = new MockSchema(DEFAULT_SCHEMA);
        this.registerSchema(salesSchema);
        CountingFactory countingInitializerExpressionFactory = new CountingFactory(this.typeFactory);
        MockTable empTable = MockTable.create(this, salesSchema, "EMP", false, 14.0, null, (InitializerExpressionFactory)countingInitializerExpressionFactory);
        empTable.addColumn("EMPNO", f.intType, true);
        empTable.addColumn("ENAME", f.varchar20Type);
        empTable.addColumn("JOB", f.varchar10Type);
        empTable.addColumn("MGR", f.intTypeNull);
        empTable.addColumn("HIREDATE", f.timestampType);
        empTable.addColumn("SAL", f.intType);
        empTable.addColumn("COMM", f.intType);
        empTable.addColumn("DEPTNO", f.intType);
        empTable.addColumn("SLACKER", f.booleanType);
        this.registerTable(empTable);
        MockTable empNullablesTable = MockTable.create(this, salesSchema, "EMPNULLABLES", false, 14.0);
        empNullablesTable.addColumn("EMPNO", f.intType, true);
        empNullablesTable.addColumn("ENAME", f.varchar20Type);
        empNullablesTable.addColumn("JOB", f.varchar10TypeNull);
        empNullablesTable.addColumn("MGR", f.intTypeNull);
        empNullablesTable.addColumn("HIREDATE", f.timestampTypeNull);
        empNullablesTable.addColumn("SAL", f.intTypeNull);
        empNullablesTable.addColumn("COMM", f.intTypeNull);
        empNullablesTable.addColumn("DEPTNO", f.intTypeNull);
        empNullablesTable.addColumn("SLACKER", f.booleanTypeNull);
        this.registerTable(empNullablesTable);
        NullInitializerExpressionFactory empInitializerExpressionFactory = new NullInitializerExpressionFactory(){

            public RexNode newColumnDefaultValue(RelOptTable table, int iColumn, InitializerContext context) {
                RexBuilder rexBuilder = context.getRexBuilder();
                switch (iColumn) {
                    case 0: {
                        return rexBuilder.makeExactLiteral(new BigDecimal(123), MockCatalogReader.this.typeFactory.createSqlType(SqlTypeName.INTEGER));
                    }
                    case 1: {
                        return rexBuilder.makeLiteral("Bob");
                    }
                    case 5: {
                        return rexBuilder.makeExactLiteral(new BigDecimal(555), MockCatalogReader.this.typeFactory.createSqlType(SqlTypeName.INTEGER));
                    }
                }
                return rexBuilder.constantNull();
            }
        };
        MockTable empDefaultsTable = MockTable.create(this, salesSchema, "EMPDEFAULTS", false, 14.0, null, (InitializerExpressionFactory)empInitializerExpressionFactory);
        empDefaultsTable.addColumn("EMPNO", f.intType, true);
        empDefaultsTable.addColumn("ENAME", f.varchar20Type);
        empDefaultsTable.addColumn("JOB", f.varchar10TypeNull);
        empDefaultsTable.addColumn("MGR", f.intTypeNull);
        empDefaultsTable.addColumn("HIREDATE", f.timestampTypeNull);
        empDefaultsTable.addColumn("SAL", f.intTypeNull);
        empDefaultsTable.addColumn("COMM", f.intTypeNull);
        empDefaultsTable.addColumn("DEPTNO", f.intTypeNull);
        empDefaultsTable.addColumn("SLACKER", f.booleanTypeNull);
        this.registerTable(empDefaultsTable);
        MockTable empBTable = MockTable.create(this, salesSchema, "EMP_B", false, 14.0);
        empBTable.addColumn("EMPNO", f.intType, true);
        empBTable.addColumn("ENAME", f.varchar20Type);
        empBTable.addColumn("JOB", f.varchar10Type);
        empBTable.addColumn("MGR", f.intTypeNull);
        empBTable.addColumn("HIREDATE", f.timestampType);
        empBTable.addColumn("SAL", f.intType);
        empBTable.addColumn("COMM", f.intType);
        empBTable.addColumn("DEPTNO", f.intType);
        empBTable.addColumn("SLACKER", f.booleanType);
        empBTable.addColumn("BIRTHDATE", f.dateType);
        this.registerTable(empBTable);
        MockTable deptTable = MockTable.create(this, salesSchema, "DEPT", false, 4.0);
        deptTable.addColumn("DEPTNO", f.intType, true);
        deptTable.addColumn("NAME", f.varchar10Type);
        this.registerTable(deptTable);
        MockTable deptNestedTable = MockTable.create(this, salesSchema, "DEPT_NESTED", false, 4.0);
        deptNestedTable.addColumn("DEPTNO", f.intType, true);
        deptNestedTable.addColumn("NAME", f.varchar10Type);
        deptNestedTable.addColumn("EMPLOYEES", f.empListType);
        this.registerTable(deptNestedTable);
        MockTable bonusTable = MockTable.create(this, salesSchema, "BONUS", false, 0.0);
        bonusTable.addColumn("ENAME", f.varchar20Type);
        bonusTable.addColumn("JOB", f.varchar10Type);
        bonusTable.addColumn("SAL", f.intType);
        bonusTable.addColumn("COMM", f.intType);
        this.registerTable(bonusTable);
        MockTable salgradeTable = MockTable.create(this, salesSchema, "SALGRADE", false, 5.0);
        salgradeTable.addColumn("GRADE", f.intType, true);
        salgradeTable.addColumn("LOSAL", f.intType);
        salgradeTable.addColumn("HISAL", f.intType);
        this.registerTable(salgradeTable);
        MockTable contactAddressTable = MockTable.create(this, salesSchema, "EMP_ADDRESS", false, 26.0);
        contactAddressTable.addColumn("EMPNO", f.intType, true);
        contactAddressTable.addColumn("HOME_ADDRESS", this.addressType);
        contactAddressTable.addColumn("MAILING_ADDRESS", this.addressType);
        this.registerTable(contactAddressTable);
        MockSchema dynamicSchema = new MockSchema("DYNAMIC");
        this.registerSchema(dynamicSchema);
        MockDynamicTable nationTable = new MockDynamicTable(this, dynamicSchema.getCatalogName(), dynamicSchema.getName(), "NATION", false, 100.0);
        this.registerTable(nationTable);
        MockDynamicTable customerTable = new MockDynamicTable(this, dynamicSchema.getCatalogName(), dynamicSchema.getName(), "CUSTOMER", false, 100.0);
        this.registerTable(customerTable);
        MockSchema customerSchema = new MockSchema("CUSTOMER");
        this.registerSchema(customerSchema);
        MockTable contactTable = MockTable.create(this, customerSchema, "CONTACT", false, 1000.0);
        contactTable.addColumn("CONTACTNO", f.intType);
        contactTable.addColumn("FNAME", f.varchar10Type);
        contactTable.addColumn("LNAME", f.varchar10Type);
        contactTable.addColumn("EMAIL", f.varchar20Type);
        contactTable.addColumn("COORD", f.rectilinearCoordType);
        this.registerTable(contactTable);
        MockTable contactPeekTable = MockTable.create(this, customerSchema, "CONTACT_PEEK", false, 1000.0);
        contactPeekTable.addColumn("CONTACTNO", f.intType);
        contactPeekTable.addColumn("FNAME", f.varchar10Type);
        contactPeekTable.addColumn("LNAME", f.varchar10Type);
        contactPeekTable.addColumn("EMAIL", f.varchar20Type);
        contactPeekTable.addColumn("COORD", f.rectilinearPeekCoordType);
        this.registerTable(contactPeekTable);
        MockTable accountTable = MockTable.create(this, customerSchema, "ACCOUNT", false, 457.0);
        accountTable.addColumn("ACCTNO", f.intType);
        accountTable.addColumn("TYPE", f.varchar20Type);
        accountTable.addColumn("BALANCE", f.intType);
        this.registerTable(accountTable);
        MockTable ordersStream = MockTable.create(this, salesSchema, "ORDERS", true, Double.POSITIVE_INFINITY);
        ordersStream.addColumn("ROWTIME", f.timestampType);
        ordersStream.addMonotonic("ROWTIME");
        ordersStream.addColumn("PRODUCTID", f.intType);
        ordersStream.addColumn("ORDERID", f.intType);
        this.registerTable(ordersStream);
        MockTable shipmentsStream = MockTable.create(this, salesSchema, "SHIPMENTS", true, Double.POSITIVE_INFINITY);
        shipmentsStream.addColumn("ORDERID", f.intType);
        shipmentsStream.addColumn("ROWTIME", f.timestampType);
        shipmentsStream.addMonotonic("ROWTIME");
        this.registerTable(shipmentsStream);
        MockTable productsTable = MockTable.create(this, salesSchema, "PRODUCTS", false, 200.0);
        productsTable.addColumn("PRODUCTID", f.intType);
        productsTable.addColumn("NAME", f.varchar20Type);
        productsTable.addColumn("SUPPLIERID", f.intType);
        this.registerTable(productsTable);
        MockTable suppliersTable = MockTable.create(this, salesSchema, "SUPPLIERS", false, 10.0);
        suppliersTable.addColumn("SUPPLIERID", f.intType);
        suppliersTable.addColumn("NAME", f.varchar20Type);
        suppliersTable.addColumn("CITY", f.intType);
        this.registerTable(suppliersTable);
        NullInitializerExpressionFactory nullInitializerFactory = new NullInitializerExpressionFactory();
        ImmutableIntList m0 = ImmutableIntList.of((int[])new int[]{0, 1, 2, 3, 4, 5, 6, 8});
        MockViewTable emp20View = new MockViewTable(this, salesSchema.getCatalogName(), salesSchema.name, "EMP_20", false, 600.0, empTable, m0, null, nullInitializerFactory){

            @Override
            public RexNode getConstraint(RexBuilder rexBuilder, RelDataType tableRowType) {
                RelDataTypeField deptnoField = (RelDataTypeField)tableRowType.getFieldList().get(7);
                RelDataTypeField salField = (RelDataTypeField)tableRowType.getFieldList().get(5);
                List<RexNode> nodes = Arrays.asList(rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{rexBuilder.makeInputRef(deptnoField.getType(), deptnoField.getIndex()), rexBuilder.makeExactLiteral(BigDecimal.valueOf(20L), deptnoField.getType())}), rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{rexBuilder.makeInputRef(salField.getType(), salField.getIndex()), rexBuilder.makeExactLiteral(BigDecimal.valueOf(1000L), salField.getType())}));
                return RexUtil.composeConjunction((RexBuilder)rexBuilder, nodes, (boolean)false);
            }
        };
        salesSchema.addTable((String)Util.last(emp20View.getQualifiedName()));
        emp20View.addColumn("EMPNO", f.intType);
        emp20View.addColumn("ENAME", f.varchar20Type);
        emp20View.addColumn("JOB", f.varchar10Type);
        emp20View.addColumn("MGR", f.intTypeNull);
        emp20View.addColumn("HIREDATE", f.timestampType);
        emp20View.addColumn("SAL", f.intType);
        emp20View.addColumn("COMM", f.intType);
        emp20View.addColumn("SLACKER", f.booleanType);
        this.registerTable(emp20View);
        MockViewTable empNullables20View = new MockViewTable(this, salesSchema.getCatalogName(), salesSchema.name, "EMPNULLABLES_20", false, 600.0, empNullablesTable, m0, null, nullInitializerFactory){

            @Override
            public RexNode getConstraint(RexBuilder rexBuilder, RelDataType tableRowType) {
                RelDataTypeField deptnoField = (RelDataTypeField)tableRowType.getFieldList().get(7);
                RelDataTypeField salField = (RelDataTypeField)tableRowType.getFieldList().get(5);
                List<RexNode> nodes = Arrays.asList(rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{rexBuilder.makeInputRef(deptnoField.getType(), deptnoField.getIndex()), rexBuilder.makeExactLiteral(BigDecimal.valueOf(20L), deptnoField.getType())}), rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{rexBuilder.makeInputRef(salField.getType(), salField.getIndex()), rexBuilder.makeExactLiteral(BigDecimal.valueOf(1000L), salField.getType())}));
                return RexUtil.composeConjunction((RexBuilder)rexBuilder, nodes, (boolean)false);
            }
        };
        salesSchema.addTable((String)Util.last(empNullables20View.getQualifiedName()));
        empNullables20View.addColumn("EMPNO", f.intType);
        empNullables20View.addColumn("ENAME", f.varchar20Type);
        empNullables20View.addColumn("JOB", f.varchar10TypeNull);
        empNullables20View.addColumn("MGR", f.intTypeNull);
        empNullables20View.addColumn("HIREDATE", f.timestampTypeNull);
        empNullables20View.addColumn("SAL", f.intTypeNull);
        empNullables20View.addColumn("COMM", f.intTypeNull);
        empNullables20View.addColumn("SLACKER", f.booleanTypeNull);
        this.registerTable(empNullables20View);
        MockSchema structTypeSchema = new MockSchema("STRUCT");
        this.registerSchema(structTypeSchema);
        List<CompoundNameColumn> columns = Arrays.asList(new CompoundNameColumn("", "K0", f.varchar20Type), new CompoundNameColumn("", "C1", f.varchar20Type), new CompoundNameColumn("F1", "A0", f.intType), new CompoundNameColumn("F2", "A0", f.booleanType), new CompoundNameColumn("F0", "C0", f.intType), new CompoundNameColumn("F1", "C0", f.intTypeNull), new CompoundNameColumn("F0", "C1", f.intType), new CompoundNameColumn("F1", "C2", f.intType), new CompoundNameColumn("F2", "C3", f.intType));
        CompoundNameColumnResolver structTypeTableResolver = new CompoundNameColumnResolver(columns, "F0");
        MockTable structTypeTable = MockTable.create(this, structTypeSchema, "T", false, 100.0, structTypeTableResolver);
        for (CompoundNameColumn column : columns) {
            structTypeTable.addColumn(column.getName(), column.type);
        }
        this.registerTable(structTypeTable);
        List<CompoundNameColumn> columnsNullable = Arrays.asList(new CompoundNameColumn("", "K0", f.varchar20TypeNull), new CompoundNameColumn("", "C1", f.varchar20TypeNull), new CompoundNameColumn("F1", "A0", f.intTypeNull), new CompoundNameColumn("F2", "A0", f.booleanTypeNull), new CompoundNameColumn("F0", "C0", f.intTypeNull), new CompoundNameColumn("F1", "C0", f.intTypeNull), new CompoundNameColumn("F0", "C1", f.intTypeNull), new CompoundNameColumn("F1", "C2", f.intType), new CompoundNameColumn("F2", "C3", f.intTypeNull));
        MockTable structNullableTypeTable = MockTable.create(this, structTypeSchema, "T_NULLABLES", false, 100.0, structTypeTableResolver);
        for (CompoundNameColumn column : columnsNullable) {
            structNullableTypeTable.addColumn(column.getName(), column.type);
        }
        this.registerTable(structNullableTypeTable);
        ImmutableIntList m1 = ImmutableIntList.of((int[])new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8});
        MockViewTable struct10View = new MockViewTable(this, structTypeSchema.getCatalogName(), structTypeSchema.name, "T_10", false, 20.0, structTypeTable, m1, structTypeTableResolver, nullInitializerFactory){

            @Override
            public RexNode getConstraint(RexBuilder rexBuilder, RelDataType tableRowType) {
                RelDataTypeField c0Field = (RelDataTypeField)tableRowType.getFieldList().get(4);
                return rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{rexBuilder.makeInputRef(c0Field.getType(), c0Field.getIndex()), rexBuilder.makeExactLiteral(BigDecimal.valueOf(10L), c0Field.getType())});
            }
        };
        structTypeSchema.addTable((String)Util.last(struct10View.getQualifiedName()));
        for (CompoundNameColumn column : columns) {
            struct10View.addColumn(column.getName(), column.type);
        }
        this.registerTable(struct10View);
        return this.init2(salesSchema);
    }

    private MockCatalogReader init2(MockSchema salesSchema) {
        ImmutableList empModifiableViewNames = ImmutableList.of((Object)salesSchema.getCatalogName(), (Object)salesSchema.name, (Object)"EMP_MODIFIABLEVIEW");
        MockModifiableViewRelOptTable.MockViewTableMacro empModifiableViewMacro = MockModifiableViewRelOptTable.viewMacro(this.rootSchema, "select EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, SLACKER from EMPDEFAULTS where DEPTNO = 20", empModifiableViewNames.subList(0, 2), (List<String>)ImmutableList.of(empModifiableViewNames.get(2)), true);
        TranslatableTable empModifiableView = empModifiableViewMacro.apply((List)ImmutableList.of());
        MockModifiableViewRelOptTable mockEmpViewTable = MockModifiableViewRelOptTable.create((MockModifiableViewRelOptTable.MockModifiableViewTable)empModifiableView, this, (String)empModifiableViewNames.get(0), (String)empModifiableViewNames.get(1), (String)empModifiableViewNames.get(2), false, 20.0, null);
        this.registerTable(mockEmpViewTable);
        ImmutableList empModifiableViewNames2 = ImmutableList.of((Object)salesSchema.getCatalogName(), (Object)salesSchema.name, (Object)"EMP_MODIFIABLEVIEW2");
        MockModifiableViewRelOptTable.MockViewTableMacro empModifiableViewMacro2 = MockModifiableViewRelOptTable.viewMacro(this.rootSchema, "select ENAME, EMPNO, JOB, DEPTNO, SLACKER, SAL, EXTRA, HIREDATE, MGR, COMM from EMPDEFAULTS extend (EXTRA boolean) where DEPTNO = 20", empModifiableViewNames2.subList(0, 2), (List<String>)ImmutableList.of(empModifiableViewNames.get(2)), true);
        TranslatableTable empModifiableView2 = empModifiableViewMacro2.apply((List)ImmutableList.of());
        MockModifiableViewRelOptTable mockEmpViewTable2 = MockModifiableViewRelOptTable.create((MockModifiableViewRelOptTable.MockModifiableViewTable)empModifiableView2, this, (String)empModifiableViewNames2.get(0), (String)empModifiableViewNames2.get(1), (String)empModifiableViewNames2.get(2), false, 20.0, null);
        this.registerTable(mockEmpViewTable2);
        ImmutableList empModifiableViewNames3 = ImmutableList.of((Object)salesSchema.getCatalogName(), (Object)salesSchema.name, (Object)"EMP_MODIFIABLEVIEW3");
        MockModifiableViewRelOptTable.MockViewTableMacro empModifiableViewMacro3 = MockModifiableViewRelOptTable.viewMacro(this.rootSchema, "select EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, SLACKER from EMPDEFAULTS where DEPTNO = 20", empModifiableViewNames3.subList(0, 2), (List<String>)ImmutableList.of(empModifiableViewNames3.get(2)), true);
        TranslatableTable empModifiableView3 = empModifiableViewMacro3.apply((List)ImmutableList.of());
        MockModifiableViewRelOptTable mockEmpViewTable3 = MockModifiableViewRelOptTable.create((MockModifiableViewRelOptTable.MockModifiableViewTable)empModifiableView3, this, (String)empModifiableViewNames3.get(0), (String)empModifiableViewNames3.get(1), (String)empModifiableViewNames3.get(2), false, 20.0, null);
        this.registerTable(mockEmpViewTable3);
        return this;
    }

    protected void registerTable(MockTable table) {
        table.onRegister(this.typeFactory);
        final WrapperTable wrapperTable = new WrapperTable(table);
        if (table.stream) {
            this.registerTable(table.names, new StreamableWrapperTable(table){

                @Override
                public Table stream() {
                    return wrapperTable;
                }
            });
        } else {
            this.registerTable(table.names, wrapperTable);
        }
    }

    private void registerTable(List<String> names, Table table) {
        assert (names.get(0).equals(DEFAULT_CATALOG));
        String schemaName = names.get(1);
        String tableName = names.get(2);
        CalciteSchema schema = this.rootSchema.getSubSchema(schemaName, true);
        schema.add(tableName, table);
    }

    protected void registerSchema(MockSchema schema) {
        this.rootSchema.add(schema.name, (Schema)new AbstractSchema());
    }

    public RelDataType getNamedType(SqlIdentifier typeName) {
        if (typeName.equalsDeep((SqlNode)this.addressType.getSqlIdentifier(), Litmus.IGNORE)) {
            return this.addressType;
        }
        return null;
    }

    private static List<RelCollation> deduceMonotonicity(Prepare.PreparingTable table) {
        ArrayList collationList = Lists.newArrayList();
        int i = -1;
        for (RelDataTypeField field : table.getRowType().getFieldList()) {
            ++i;
            SqlMonotonicity monotonicity = table.getMonotonicity(field.getName());
            if (monotonicity == SqlMonotonicity.NOT_MONOTONIC) continue;
            RelFieldCollation.Direction direction = monotonicity.isDecreasing() ? RelFieldCollation.Direction.DESCENDING : RelFieldCollation.Direction.ASCENDING;
            collationList.add(RelCollations.of((RelFieldCollation[])new RelFieldCollation[]{new RelFieldCollation(i, direction)}));
        }
        return collationList;
    }

    public static class CountingFactory
    extends NullInitializerExpressionFactory {
        static final ThreadLocal<AtomicInteger> THREAD_CALL_COUNT = new ThreadLocal<AtomicInteger>(){

            @Override
            protected AtomicInteger initialValue() {
                return new AtomicInteger();
            }
        };

        CountingFactory(RelDataTypeFactory typeFactory) {
        }

        public RexNode newColumnDefaultValue(RelOptTable table, int iColumn, InitializerContext context) {
            THREAD_CALL_COUNT.get().incrementAndGet();
            return super.newColumnDefaultValue(table, iColumn, context);
        }

        public RexNode newAttributeInitializer(RelDataType type, SqlFunction constructor, int iAttribute, List<RexNode> constructorArgs, InitializerContext context) {
            THREAD_CALL_COUNT.get().incrementAndGet();
            return super.newAttributeInitializer(type, constructor, iAttribute, constructorArgs, context);
        }
    }

    private class Fixture {
        final RelDataType intType;
        final RelDataType intTypeNull;
        final RelDataType varchar10Type;
        final RelDataType varchar10TypeNull;
        final RelDataType varchar20Type;
        final RelDataType varchar20TypeNull;
        final RelDataType timestampType;
        final RelDataType timestampTypeNull;
        final RelDataType dateType;
        final RelDataType booleanType;
        final RelDataType booleanTypeNull;
        final RelDataType rectilinearCoordType;
        final RelDataType rectilinearPeekCoordType;
        final RelDataType empRecordType;
        final RelDataType empListType;
        final ObjectSqlType addressType;

        private Fixture() {
            this.intType = MockCatalogReader.this.typeFactory.createSqlType(SqlTypeName.INTEGER);
            this.intTypeNull = MockCatalogReader.this.typeFactory.createTypeWithNullability(this.intType, true);
            this.varchar10Type = MockCatalogReader.this.typeFactory.createSqlType(SqlTypeName.VARCHAR, 10);
            this.varchar10TypeNull = MockCatalogReader.this.typeFactory.createTypeWithNullability(this.varchar10Type, true);
            this.varchar20Type = MockCatalogReader.this.typeFactory.createSqlType(SqlTypeName.VARCHAR, 20);
            this.varchar20TypeNull = MockCatalogReader.this.typeFactory.createTypeWithNullability(this.varchar20Type, true);
            this.timestampType = MockCatalogReader.this.typeFactory.createSqlType(SqlTypeName.TIMESTAMP);
            this.timestampTypeNull = MockCatalogReader.this.typeFactory.createTypeWithNullability(this.timestampType, true);
            this.dateType = MockCatalogReader.this.typeFactory.createSqlType(SqlTypeName.DATE);
            this.booleanType = MockCatalogReader.this.typeFactory.createSqlType(SqlTypeName.BOOLEAN);
            this.booleanTypeNull = MockCatalogReader.this.typeFactory.createTypeWithNullability(this.booleanType, true);
            this.rectilinearCoordType = MockCatalogReader.this.typeFactory.builder().add("X", this.intType).add("Y", this.intType).build();
            this.rectilinearPeekCoordType = MockCatalogReader.this.typeFactory.builder().add("X", this.intType).add("Y", this.intType).kind(StructKind.PEEK_FIELDS).build();
            this.empRecordType = MockCatalogReader.this.typeFactory.builder().add("EMPNO", this.intType).add("ENAME", this.varchar10Type).build();
            this.empListType = MockCatalogReader.this.typeFactory.createArrayType(this.empRecordType, -1L);
            this.addressType = new ObjectSqlType(SqlTypeName.STRUCTURED, new SqlIdentifier("ADDRESS", SqlParserPos.ZERO), false, Arrays.asList(new RelDataTypeFieldImpl("STREET", 0, this.varchar20Type), new RelDataTypeFieldImpl("CITY", 1, this.varchar20Type), new RelDataTypeFieldImpl("ZIP", 2, this.intType), new RelDataTypeFieldImpl("STATE", 3, this.varchar20Type)), RelDataTypeComparability.NONE);
        }
    }

    private static class StreamableWrapperTable
    extends WrapperTable
    implements StreamableTable {
        StreamableWrapperTable(MockTable table) {
            super(table);
        }

        public Table stream() {
            return this;
        }
    }

    private static class WrapperTable
    implements Table,
    Wrapper {
        private final MockTable table;

        WrapperTable(MockTable table) {
            this.table = table;
        }

        public <C> C unwrap(Class<C> aClass) {
            return (C)(aClass.isInstance(this) ? aClass.cast(this) : (aClass.isInstance((Object)this.table) ? aClass.cast((Object)this.table) : null));
        }

        public RelDataType getRowType(RelDataTypeFactory typeFactory) {
            return this.table.getRowType();
        }

        public Statistic getStatistic() {
            return new Statistic(){

                public Double getRowCount() {
                    return ((WrapperTable)WrapperTable.this).table.rowCount;
                }

                public boolean isKey(ImmutableBitSet columns) {
                    return WrapperTable.this.table.isKey(columns);
                }

                public List<RelReferentialConstraint> getReferentialConstraints() {
                    return WrapperTable.this.table.getReferentialConstraints();
                }

                public List<RelCollation> getCollations() {
                    return ((WrapperTable)WrapperTable.this).table.collationList;
                }

                public RelDistribution getDistribution() {
                    return WrapperTable.this.table.getDistribution();
                }
            };
        }

        public Schema.TableType getJdbcTableType() {
            return this.table.stream ? Schema.TableType.STREAM : Schema.TableType.TABLE;
        }
    }

    private static final class CompoundNameColumnResolver
    implements ColumnResolver {
        private final Map<String, Integer> nameMap = Maps.newHashMap();
        private final Map<String, Map<String, Integer>> groupMap = Maps.newHashMap();
        private final String defaultColumnGroup;

        CompoundNameColumnResolver(List<CompoundNameColumn> columns, String defaultColumnGroup) {
            this.defaultColumnGroup = defaultColumnGroup;
            for (Ord column : Ord.zip(columns)) {
                this.nameMap.put(((CompoundNameColumn)column.e).getName(), column.i);
                HashMap subMap = this.groupMap.get(((CompoundNameColumn)column.e).first);
                if (subMap == null) {
                    subMap = Maps.newHashMap();
                    this.groupMap.put(((CompoundNameColumn)column.e).first, subMap);
                }
                subMap.put(((CompoundNameColumn)column.e).second, column.i);
            }
        }

        @Override
        public List<Pair<RelDataTypeField, List<String>>> resolveColumn(RelDataType rowType, RelDataTypeFactory typeFactory, List<String> names) {
            Map<String, Integer> subMap;
            Integer index;
            Map<String, Integer> subMap2;
            ArrayList<Pair<RelDataTypeField, List<String>>> ret = new ArrayList<Pair<RelDataTypeField, List<String>>>();
            if (names.size() >= 2 && (subMap2 = this.groupMap.get(names.get(0))) != null && (index = subMap2.get(names.get(1))) != null) {
                ret.add((Pair<RelDataTypeField, List<String>>)new Pair(rowType.getFieldList().get(index), names.subList(2, names.size())));
            }
            String columnName = names.get(0);
            List<String> remainder = names.subList(1, names.size());
            Integer index2 = this.nameMap.get(columnName);
            if (index2 != null) {
                ret.add(new Pair(rowType.getFieldList().get(index2), remainder));
                return ret;
            }
            List<String> priorityGroups = Arrays.asList("", this.defaultColumnGroup);
            for (String string : priorityGroups) {
                Map<String, Integer> subMap3 = this.groupMap.get(string);
                if (subMap3 == null || (index2 = subMap3.get(columnName)) == null) continue;
                ret.add((Pair<RelDataTypeField, List<String>>)new Pair(rowType.getFieldList().get(index2), remainder));
                return ret;
            }
            for (Map.Entry entry : this.groupMap.entrySet()) {
                if (priorityGroups.contains(entry.getKey()) || (index2 = (Integer)((Map)entry.getValue()).get(columnName)) == null) continue;
                ret.add((Pair<RelDataTypeField, List<String>>)new Pair(rowType.getFieldList().get(index2), remainder));
            }
            if (ret.isEmpty() && names.size() == 1 && (subMap = this.groupMap.get(columnName)) != null) {
                ArrayList<Map.Entry<String, Integer>> arrayList = new ArrayList<Map.Entry<String, Integer>>(subMap.entrySet());
                Collections.sort(arrayList, new Comparator<Map.Entry<String, Integer>>(){

                    @Override
                    public int compare(Map.Entry<String, Integer> o1, Map.Entry<String, Integer> o2) {
                        return o1.getValue() - o2.getValue();
                    }
                });
                ret.add((Pair<RelDataTypeField, List<String>>)new Pair((Object)new RelDataTypeFieldImpl(columnName, -1, CompoundNameColumnResolver.createStructType(rowType, typeFactory, arrayList)), remainder));
            }
            return ret;
        }

        private static RelDataType createStructType(final RelDataType rowType, RelDataTypeFactory typeFactory, final List<Map.Entry<String, Integer>> entries) {
            return typeFactory.createStructType(StructKind.PEEK_FIELDS, (List)new AbstractList<RelDataType>(){

                @Override
                public RelDataType get(int index) {
                    int i = (Integer)((Map.Entry)entries.get(index)).getValue();
                    return ((RelDataTypeField)rowType.getFieldList().get(i)).getType();
                }

                @Override
                public int size() {
                    return entries.size();
                }
            }, (List)new AbstractList<String>(){

                @Override
                public String get(int index) {
                    return (String)((Map.Entry)entries.get(index)).getKey();
                }

                @Override
                public int size() {
                    return entries.size();
                }
            });
        }
    }

    private static final class CompoundNameColumn {
        final String first;
        final String second;
        final RelDataType type;

        CompoundNameColumn(String first, String second, RelDataType type) {
            this.first = first;
            this.second = second;
            this.type = type;
        }

        String getName() {
            return (this.first.isEmpty() ? "" : "\"" + this.first + "\".") + "\"" + this.second + "\"";
        }
    }

    private static class DelegateStructType
    implements RelDataType {
        private RelDataType delegate;
        private StructKind structKind;

        DelegateStructType(RelDataType delegate, StructKind structKind) {
            assert (delegate.isStruct());
            this.delegate = delegate;
            this.structKind = structKind;
        }

        public boolean isStruct() {
            return this.delegate.isStruct();
        }

        public boolean isDynamicStruct() {
            return this.delegate.isDynamicStruct();
        }

        public List<RelDataTypeField> getFieldList() {
            return this.delegate.getFieldList();
        }

        public List<String> getFieldNames() {
            return this.delegate.getFieldNames();
        }

        public int getFieldCount() {
            return this.delegate.getFieldCount();
        }

        public StructKind getStructKind() {
            return this.structKind;
        }

        public RelDataTypeField getField(String fieldName, boolean caseSensitive, boolean elideRecord) {
            return this.delegate.getField(fieldName, caseSensitive, elideRecord);
        }

        public boolean isNullable() {
            return this.delegate.isNullable();
        }

        public RelDataType getComponentType() {
            return this.delegate.getComponentType();
        }

        public RelDataType getKeyType() {
            return this.delegate.getKeyType();
        }

        public RelDataType getValueType() {
            return this.delegate.getValueType();
        }

        public Charset getCharset() {
            return this.delegate.getCharset();
        }

        public SqlCollation getCollation() {
            return this.delegate.getCollation();
        }

        public SqlIntervalQualifier getIntervalQualifier() {
            return this.delegate.getIntervalQualifier();
        }

        public int getPrecision() {
            return this.delegate.getPrecision();
        }

        public int getScale() {
            return this.delegate.getScale();
        }

        public SqlTypeName getSqlTypeName() {
            return this.delegate.getSqlTypeName();
        }

        public SqlIdentifier getSqlIdentifier() {
            return this.delegate.getSqlIdentifier();
        }

        public String getFullTypeString() {
            return this.delegate.getFullTypeString();
        }

        public RelDataTypeFamily getFamily() {
            return this.delegate.getFamily();
        }

        public RelDataTypePrecedenceList getPrecedenceList() {
            return this.delegate.getPrecedenceList();
        }

        public RelDataTypeComparability getComparability() {
            return this.delegate.getComparability();
        }
    }

    public static class MockDynamicTable
    extends MockTable {
        MockDynamicTable(MockCatalogReader catalogReader, String catalogName, String schemaName, String name, boolean stream, double rowCount) {
            super(catalogReader, catalogName, schemaName, name, stream, rowCount, null, (InitializerExpressionFactory)new NullInitializerExpressionFactory());
        }

        @Override
        public void onRegister(RelDataTypeFactory typeFactory) {
            this.rowType = new DynamicRecordTypeImpl(typeFactory);
        }

        @Override
        public RelNode toRel(RelOptTable.ToRelContext context) {
            if (this.rowType.isDynamicStruct()) {
                this.rowType = new RelRecordType(this.rowType.getFieldList());
            }
            return super.toRel(context);
        }
    }

    public static abstract class MockViewTable
    extends MockTable {
        private final MockTable fromTable;
        private final Table table;
        private final ImmutableIntList mapping;

        MockViewTable(MockCatalogReader catalogReader, String catalogName, String schemaName, String name, boolean stream, double rowCount, MockTable fromTable, ImmutableIntList mapping, ColumnResolver resolver, NullInitializerExpressionFactory initializerFactory) {
            super(catalogReader, catalogName, schemaName, name, stream, rowCount, resolver, (InitializerExpressionFactory)initializerFactory);
            this.fromTable = fromTable;
            this.table = fromTable.unwrap(Table.class);
            this.mapping = mapping;
        }

        protected abstract RexNode getConstraint(RexBuilder var1, RelDataType var2);

        @Override
        public void onRegister(RelDataTypeFactory typeFactory) {
            super.onRegister(typeFactory);
            RelProtoDataType protoRowType = RelDataTypeImpl.proto((RelDataType)this.rowType);
            this.rowType = (RelDataType)protoRowType.apply((Object)typeFactory);
        }

        @Override
        public RelNode toRel(RelOptTable.ToRelContext context) {
            LogicalTableScan rel = LogicalTableScan.create((RelOptCluster)context.getCluster(), (RelOptTable)this.fromTable);
            RexBuilder rexBuilder = context.getCluster().getRexBuilder();
            rel = LogicalFilter.create((RelNode)rel, (RexNode)this.getConstraint(rexBuilder, rel.getRowType()));
            final List fieldList = rel.getRowType().getFieldList();
            AbstractList<Pair<RexNode, String>> projects = new AbstractList<Pair<RexNode, String>>(){

                @Override
                public Pair<RexNode, String> get(int index) {
                    return RexInputRef.of2((int)MockViewTable.this.mapping.get(index), (List)fieldList);
                }

                @Override
                public int size() {
                    return MockViewTable.this.mapping.size();
                }
            };
            return LogicalProject.create((RelNode)rel, (List)Pair.left((List)projects), (List)Pair.right((List)projects));
        }

        @Override
        public <T> T unwrap(Class<T> clazz) {
            if (clazz.isAssignableFrom(ModifiableView.class)) {
                ModifiableView view = this.resolver == null ? new ModifiableView() : new ModifiableViewWithCustomColumnResolving();
                return clazz.cast((Object)view);
            }
            return super.unwrap(clazz);
        }

        private class ModifiableViewWithCustomColumnResolving
        extends ModifiableView
        implements CustomColumnResolvingTable,
        Wrapper {
            private ModifiableViewWithCustomColumnResolving() {
            }

            public List<Pair<RelDataTypeField, List<String>>> resolveColumn(RelDataType rowType, RelDataTypeFactory typeFactory, List<String> names) {
                return MockViewTable.this.resolver.resolveColumn(rowType, typeFactory, names);
            }

            @Override
            public <C> C unwrap(Class<C> aClass) {
                if (MockViewTable.this.table instanceof Wrapper) {
                    return (C)((Wrapper)MockViewTable.this.table).unwrap(aClass);
                }
                return null;
            }
        }

        private class ModifiableView
        extends JdbcTest.AbstractModifiableView
        implements Wrapper {
            private ModifiableView() {
            }

            public Table getTable() {
                return MockViewTable.this.fromTable.unwrap(Table.class);
            }

            public Path getTablePath() {
                ImmutableList.Builder builder = ImmutableList.builder();
                for (String name : ((MockViewTable)MockViewTable.this).fromTable.names) {
                    builder.add((Object)Pair.of((Object)name, null));
                }
                return Schemas.path((ImmutableList)builder.build());
            }

            public ImmutableIntList getColumnMapping() {
                return MockViewTable.this.mapping;
            }

            public RexNode getConstraint(RexBuilder rexBuilder, RelDataType tableRowType) {
                return MockViewTable.this.getConstraint(rexBuilder, tableRowType);
            }

            public RelDataType getRowType(final RelDataTypeFactory typeFactory) {
                return typeFactory.createStructType((List)new AbstractList<Map.Entry<String, RelDataType>>(){

                    @Override
                    public Map.Entry<String, RelDataType> get(int index) {
                        return (Map.Entry)MockViewTable.this.table.getRowType(typeFactory).getFieldList().get(MockViewTable.this.mapping.get(index));
                    }

                    @Override
                    public int size() {
                        return MockViewTable.this.mapping.size();
                    }
                });
            }

            public <C> C unwrap(Class<C> aClass) {
                if (MockViewTable.this.table instanceof Wrapper) {
                    return (C)((Wrapper)MockViewTable.this.table).unwrap(aClass);
                }
                return null;
            }
        }
    }

    public static class MockModifiableViewRelOptTable
    extends MockTable {
        private final MockModifiableViewTable modifiableViewTable;

        private MockModifiableViewRelOptTable(MockModifiableViewTable modifiableViewTable, MockCatalogReader catalogReader, String catalogName, String schemaName, String name, boolean stream, double rowCount, ColumnResolver resolver, InitializerExpressionFactory initializerExpressionFactory) {
            super(catalogReader, (List)ImmutableList.of((Object)catalogName, (Object)schemaName, (Object)name), stream, rowCount, resolver, initializerExpressionFactory);
            this.modifiableViewTable = modifiableViewTable;
        }

        private MockModifiableViewRelOptTable(MockModifiableViewTable modifiableViewTable, MockCatalogReader catalogReader, boolean stream, double rowCount, List<Map.Entry<String, RelDataType>> columnList, List<Integer> keyList, RelDataType rowType, List<RelCollation> collationList, List<String> names, Set<String> monotonicColumnSet, StructKind kind, ColumnResolver resolver, InitializerExpressionFactory initializerFactory) {
            super(catalogReader, stream, rowCount, columnList, keyList, rowType, collationList, names, monotonicColumnSet, kind, resolver, initializerFactory);
            this.modifiableViewTable = modifiableViewTable;
        }

        public static MockModifiableViewRelOptTable create(MockModifiableViewTable modifiableViewTable, MockCatalogReader catalogReader, String catalogName, String schemaName, String name, boolean stream, double rowCount, ColumnResolver resolver) {
            Table underlying = (Table)modifiableViewTable.unwrap(Table.class);
            NullInitializerExpressionFactory maybeInitializerExpressionFactory = underlying != null && underlying instanceof Wrapper ? (InitializerExpressionFactory)((Wrapper)underlying).unwrap(InitializerExpressionFactory.class) : new NullInitializerExpressionFactory();
            NullInitializerExpressionFactory initializerExpressionFactory = maybeInitializerExpressionFactory == null ? new NullInitializerExpressionFactory() : maybeInitializerExpressionFactory;
            return new MockModifiableViewRelOptTable(modifiableViewTable, catalogReader, catalogName, schemaName, name, stream, rowCount, resolver, (InitializerExpressionFactory)initializerExpressionFactory);
        }

        public static MockViewTableMacro viewMacro(CalciteSchema schema, String viewSql, List<String> schemaPath, List<String> viewPath, Boolean modifiable) {
            return new MockViewTableMacro(schema, viewSql, schemaPath, viewPath, modifiable);
        }

        @Override
        public RelDataType getRowType() {
            return this.modifiableViewTable.getRowType(this.catalogReader.typeFactory);
        }

        @Override
        protected RelOptTable extend(Table extendedTable) {
            return new MockModifiableViewRelOptTable((MockModifiableViewTable)extendedTable, this.catalogReader, this.stream, this.rowCount, this.columnList, this.keyList, this.rowType, this.collationList, this.names, this.monotonicColumnSet, this.kind, this.resolver, this.initializerFactory);
        }

        @Override
        public <T> T unwrap(Class<T> clazz) {
            if (clazz.isInstance((Object)this.modifiableViewTable)) {
                return clazz.cast((Object)this.modifiableViewTable);
            }
            return super.unwrap(clazz);
        }

        private static class MockModifiableViewTable
        extends ModifiableViewTable {
            private final RexNode constraint;

            MockModifiableViewTable(Type elementType, RelProtoDataType rowType, String viewSql, List<String> schemaPath, List<String> viewPath, Table table, Path tablePath, RexNode constraint, ImmutableIntList columnMapping) {
                super(elementType, rowType, viewSql, schemaPath, viewPath, table, tablePath, constraint, columnMapping);
                this.constraint = constraint;
            }

            public ModifiableViewTable extend(Table extendedTable, RelProtoDataType protoRowType, ImmutableIntList newColumnMapping) {
                return new MockModifiableViewTable(this.getElementType(), protoRowType, this.getViewSql(), this.getSchemaPath(), this.getViewPath(), extendedTable, this.getTablePath(), this.constraint, newColumnMapping);
            }
        }

        public static class MockViewTableMacro
        extends ViewTableMacro {
            MockViewTableMacro(CalciteSchema schema, String viewSql, List<String> schemaPath, List<String> viewPath, Boolean modifiable) {
                super(schema, viewSql, schemaPath, viewPath, modifiable);
            }

            protected ModifiableViewTable modifiableViewTable(CalcitePrepare.AnalyzeViewResult parsed, String viewSql, List<String> schemaPath, List<String> viewPath, CalciteSchema schema) {
                JavaTypeFactory typeFactory = (JavaTypeFactory)parsed.typeFactory;
                Type elementType = typeFactory.getJavaClass(parsed.rowType);
                return new MockModifiableViewTable(elementType, RelDataTypeImpl.proto((RelDataType)parsed.rowType), viewSql, schemaPath, viewPath, parsed.table, Schemas.path((CalciteSchema)schema.root(), (Iterable)parsed.tablePath), parsed.constraint, parsed.columnMapping);
            }
        }
    }

    public static class MockTable
    extends Prepare.AbstractPreparingTable {
        protected final MockCatalogReader catalogReader;
        protected final boolean stream;
        protected final double rowCount;
        protected final List<Map.Entry<String, RelDataType>> columnList = new ArrayList<Map.Entry<String, RelDataType>>();
        protected final List<Integer> keyList = new ArrayList<Integer>();
        protected final List<RelReferentialConstraint> referentialConstraints = new ArrayList<RelReferentialConstraint>();
        protected RelDataType rowType;
        protected List<RelCollation> collationList;
        protected final List<String> names;
        protected final Set<String> monotonicColumnSet = Sets.newHashSet();
        protected StructKind kind = StructKind.FULLY_QUALIFIED;
        protected final ColumnResolver resolver;
        protected final InitializerExpressionFactory initializerFactory;

        public MockTable(MockCatalogReader catalogReader, String catalogName, String schemaName, String name, boolean stream, double rowCount, ColumnResolver resolver, InitializerExpressionFactory initializerFactory) {
            this(catalogReader, (List<String>)ImmutableList.of((Object)catalogName, (Object)schemaName, (Object)name), stream, rowCount, resolver, initializerFactory);
        }

        private MockTable(MockCatalogReader catalogReader, List<String> names, boolean stream, double rowCount, ColumnResolver resolver, InitializerExpressionFactory initializerFactory) {
            this.catalogReader = catalogReader;
            this.stream = stream;
            this.rowCount = rowCount;
            this.names = names;
            this.resolver = resolver;
            this.initializerFactory = initializerFactory;
        }

        protected MockTable(MockCatalogReader catalogReader, boolean stream, double rowCount, List<Map.Entry<String, RelDataType>> columnList, List<Integer> keyList, RelDataType rowType, List<RelCollation> collationList, List<String> names, Set<String> monotonicColumnSet, StructKind kind, ColumnResolver resolver, InitializerExpressionFactory initializerFactory) {
            this.catalogReader = catalogReader;
            this.stream = stream;
            this.rowCount = rowCount;
            this.rowType = rowType;
            this.collationList = collationList;
            this.names = names;
            this.kind = kind;
            this.resolver = resolver;
            this.initializerFactory = initializerFactory;
            for (String name : monotonicColumnSet) {
                this.addMonotonic(name);
            }
        }

        protected RelOptTable extend(final Table extendedTable) {
            return new MockTable(this.catalogReader, this.names, this.stream, this.rowCount, this.resolver, this.initializerFactory){

                @Override
                public RelDataType getRowType() {
                    return extendedTable.getRowType(this.catalogReader.typeFactory);
                }
            };
        }

        public static MockTable create(MockCatalogReader catalogReader, MockSchema schema, String name, boolean stream, double rowCount) {
            return MockTable.create(catalogReader, schema, name, stream, rowCount, null);
        }

        public static MockTable create(MockCatalogReader catalogReader, MockSchema schema, String name, boolean stream, double rowCount, ColumnResolver resolver) {
            return MockTable.create(catalogReader, schema, name, stream, rowCount, resolver, (InitializerExpressionFactory)new NullInitializerExpressionFactory());
        }

        public static MockTable create(MockCatalogReader catalogReader, MockSchema schema, String name, boolean stream, double rowCount, ColumnResolver resolver, InitializerExpressionFactory initializerExpressionFactory) {
            MockTable table = new MockTable(catalogReader, schema.getCatalogName(), schema.name, name, stream, rowCount, resolver, initializerExpressionFactory);
            schema.addTable(name);
            return table;
        }

        public <T> T unwrap(Class<T> clazz) {
            if (clazz.isInstance((Object)this)) {
                return clazz.cast((Object)this);
            }
            if (clazz.isAssignableFrom(Table.class)) {
                ModifiableTable table = this.resolver == null ? new ModifiableTable((String)Util.last(this.names)) : new ModifiableTableWithCustomColumnResolving((String)Util.last(this.names));
                return clazz.cast((Object)table);
            }
            return null;
        }

        public double getRowCount() {
            return this.rowCount;
        }

        public RelOptSchema getRelOptSchema() {
            return this.catalogReader;
        }

        public RelNode toRel(RelOptTable.ToRelContext context) {
            return LogicalTableScan.create((RelOptCluster)context.getCluster(), (RelOptTable)this);
        }

        public List<RelCollation> getCollationList() {
            return this.collationList;
        }

        public RelDistribution getDistribution() {
            return RelDistributions.BROADCAST_DISTRIBUTED;
        }

        public boolean isKey(ImmutableBitSet columns) {
            return !this.keyList.isEmpty() && columns.contains(ImmutableBitSet.of(this.keyList));
        }

        public List<RelReferentialConstraint> getReferentialConstraints() {
            return this.referentialConstraints;
        }

        public RelDataType getRowType() {
            return this.rowType;
        }

        public boolean supportsModality(SqlModality modality) {
            return modality == (this.stream ? SqlModality.STREAM : SqlModality.RELATION);
        }

        public void onRegister(RelDataTypeFactory typeFactory) {
            this.rowType = typeFactory.createStructType(this.kind, Pair.right(this.columnList), Pair.left(this.columnList));
            this.collationList = MockCatalogReader.deduceMonotonicity((Prepare.PreparingTable)this);
        }

        public List<String> getQualifiedName() {
            return this.names;
        }

        public SqlMonotonicity getMonotonicity(String columnName) {
            return this.monotonicColumnSet.contains(columnName) ? SqlMonotonicity.INCREASING : SqlMonotonicity.NOT_MONOTONIC;
        }

        public SqlAccessType getAllowedAccess() {
            return SqlAccessType.ALL;
        }

        public Expression getExpression(Class clazz) {
            throw new UnsupportedOperationException();
        }

        public void addColumn(String name, RelDataType type) {
            this.addColumn(name, type, false);
        }

        public void addColumn(String name, RelDataType type, boolean isKey) {
            if (isKey) {
                this.keyList.add(this.columnList.size());
            }
            this.columnList.add((Map.Entry<String, RelDataType>)Pair.of((Object)name, (Object)type));
        }

        public void addMonotonic(String name) {
            this.monotonicColumnSet.add(name);
            assert (Pair.left(this.columnList).contains(name));
        }

        public void setKind(StructKind kind) {
            this.kind = kind;
        }

        public StructKind getKind() {
            return this.kind;
        }

        private class ModifiableTableWithCustomColumnResolving
        extends ModifiableTable
        implements CustomColumnResolvingTable,
        Wrapper {
            protected ModifiableTableWithCustomColumnResolving(String tableName) {
                super(tableName);
            }

            public List<Pair<RelDataTypeField, List<String>>> resolveColumn(RelDataType rowType, RelDataTypeFactory typeFactory, List<String> names) {
                return MockTable.this.resolver.resolveColumn(rowType, typeFactory, names);
            }
        }

        private class ModifiableTable
        extends JdbcTest.AbstractModifiableTable
        implements ExtensibleTable,
        Wrapper {
            protected ModifiableTable(String tableName) {
                super(tableName);
            }

            public RelDataType getRowType(RelDataTypeFactory typeFactory) {
                return typeFactory.createStructType(MockTable.this.getRowType().getFieldList());
            }

            public Collection getModifiableCollection() {
                return null;
            }

            public <E> Queryable<E> asQueryable(QueryProvider queryProvider, SchemaPlus schema, String tableName) {
                return null;
            }

            public Type getElementType() {
                return null;
            }

            public Expression getExpression(SchemaPlus schema, String tableName, Class clazz) {
                return null;
            }

            public <C> C unwrap(Class<C> aClass) {
                if (aClass.isInstance(MockTable.this.initializerFactory)) {
                    return aClass.cast(MockTable.this.initializerFactory);
                }
                if (aClass.isInstance((Object)MockTable.this)) {
                    return aClass.cast((Object)MockTable.this);
                }
                return null;
            }

            public Table extend(final List<RelDataTypeField> fields) {
                return new ModifiableTable((String)Util.last(MockTable.this.names)){

                    @Override
                    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
                        ImmutableList allFields = ImmutableList.copyOf((Iterable)Iterables.concat((Iterable)ModifiableTable.this.getRowType(typeFactory).getFieldList(), (Iterable)fields));
                        return typeFactory.createStructType((List)allFields);
                    }
                };
            }

            public int getExtendedColumnOffset() {
                return MockTable.this.rowType.getFieldCount();
            }
        }
    }

    public static class MockSchema {
        private final List<String> tableNames = Lists.newArrayList();
        private String name;

        public MockSchema(String name) {
            this.name = name;
        }

        public void addTable(String name) {
            this.tableNames.add(name);
        }

        public String getCatalogName() {
            return MockCatalogReader.DEFAULT_CATALOG;
        }

        public String getName() {
            return this.name;
        }
    }

    public static interface ColumnResolver {
        public List<Pair<RelDataTypeField, List<String>>> resolveColumn(RelDataType var1, RelDataTypeFactory var2, List<String> var3);
    }
}

