/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.plan.hep.HepMatchOrder;
import org.apache.calcite.plan.hep.HepPlanner;
import org.apache.calcite.plan.hep.HepProgram;
import org.apache.calcite.plan.hep.HepProgramBuilder;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.logical.LogicalTableModify;
import org.apache.calcite.rel.metadata.CachingRelMetadataProvider;
import org.apache.calcite.rel.metadata.ChainedRelMetadataProvider;
import org.apache.calcite.rel.metadata.DefaultRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.rules.AggregateExpandDistinctAggregatesRule;
import org.apache.calcite.rel.rules.AggregateFilterTransposeRule;
import org.apache.calcite.rel.rules.AggregateJoinTransposeRule;
import org.apache.calcite.rel.rules.AggregateProjectMergeRule;
import org.apache.calcite.rel.rules.AggregateProjectPullUpConstantsRule;
import org.apache.calcite.rel.rules.AggregateReduceFunctionsRule;
import org.apache.calcite.rel.rules.AggregateUnionAggregateRule;
import org.apache.calcite.rel.rules.AggregateUnionTransposeRule;
import org.apache.calcite.rel.rules.AggregateValuesRule;
import org.apache.calcite.rel.rules.CalcMergeRule;
import org.apache.calcite.rel.rules.CoerceInputsRule;
import org.apache.calcite.rel.rules.DateRangeRules;
import org.apache.calcite.rel.rules.FilterAggregateTransposeRule;
import org.apache.calcite.rel.rules.FilterJoinRule;
import org.apache.calcite.rel.rules.FilterMergeRule;
import org.apache.calcite.rel.rules.FilterProjectTransposeRule;
import org.apache.calcite.rel.rules.FilterSetOpTransposeRule;
import org.apache.calcite.rel.rules.FilterToCalcRule;
import org.apache.calcite.rel.rules.IntersectToDistinctRule;
import org.apache.calcite.rel.rules.JoinAddRedundantSemiJoinRule;
import org.apache.calcite.rel.rules.JoinCommuteRule;
import org.apache.calcite.rel.rules.JoinExtractFilterRule;
import org.apache.calcite.rel.rules.JoinProjectTransposeRule;
import org.apache.calcite.rel.rules.JoinPushExpressionsRule;
import org.apache.calcite.rel.rules.JoinPushTransitivePredicatesRule;
import org.apache.calcite.rel.rules.JoinToMultiJoinRule;
import org.apache.calcite.rel.rules.JoinUnionTransposeRule;
import org.apache.calcite.rel.rules.ProjectFilterTransposeRule;
import org.apache.calcite.rel.rules.ProjectJoinTransposeRule;
import org.apache.calcite.rel.rules.ProjectMergeRule;
import org.apache.calcite.rel.rules.ProjectRemoveRule;
import org.apache.calcite.rel.rules.ProjectSetOpTransposeRule;
import org.apache.calcite.rel.rules.ProjectToCalcRule;
import org.apache.calcite.rel.rules.ProjectToWindowRule;
import org.apache.calcite.rel.rules.ProjectWindowTransposeRule;
import org.apache.calcite.rel.rules.PruneEmptyRules;
import org.apache.calcite.rel.rules.ReduceExpressionsRule;
import org.apache.calcite.rel.rules.SemiJoinFilterTransposeRule;
import org.apache.calcite.rel.rules.SemiJoinJoinTransposeRule;
import org.apache.calcite.rel.rules.SemiJoinProjectTransposeRule;
import org.apache.calcite.rel.rules.SemiJoinRemoveRule;
import org.apache.calcite.rel.rules.SemiJoinRule;
import org.apache.calcite.rel.rules.SortJoinTransposeRule;
import org.apache.calcite.rel.rules.SortProjectTransposeRule;
import org.apache.calcite.rel.rules.SortUnionTransposeRule;
import org.apache.calcite.rel.rules.SubQueryRemoveRule;
import org.apache.calcite.rel.rules.TableScanRule;
import org.apache.calcite.rel.rules.UnionMergeRule;
import org.apache.calcite.rel.rules.UnionPullUpConstantsRule;
import org.apache.calcite.rel.rules.UnionToDistinctRule;
import org.apache.calcite.rel.rules.ValuesReduceRule;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.runtime.Hook;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorCatalogReader;
import org.apache.calcite.sql2rel.SqlToRelConverter;
import org.apache.calcite.test.DiffRepository;
import org.apache.calcite.test.MockCatalogReader;
import org.apache.calcite.test.MockRelOptPlanner;
import org.apache.calcite.test.RelOptTestBase;
import org.apache.calcite.test.SqlToRelTestBase;
import org.apache.calcite.tools.RelBuilder;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class RelOptRulesTest
extends RelOptTestBase {
    private static final String NOT_STRONG_EXPR = "case when e.sal < 11 then 11 else -1 * e.sal end";
    private static final String STRONG_EXPR = "case when e.sal < 11 then -1 * e.sal else e.sal end";

    @Override
    protected DiffRepository getDiffRepos() {
        return DiffRepository.lookup(RelOptRulesTest.class);
    }

    @Test
    public void testReduceNestedCaseWhen() {
        HepProgram preProgram = new HepProgramBuilder().build();
        HepProgramBuilder builder = new HepProgramBuilder();
        builder.addRuleClass(ReduceExpressionsRule.class);
        HepPlanner hepPlanner = new HepPlanner(builder.build());
        hepPlanner.addRule((RelOptRule)ReduceExpressionsRule.FILTER_INSTANCE);
        String sql = "select sal\nfrom emp\nwhere case when (sal = 1000) then\n(case when sal = 1000 then null else 1 end is null) else\n(case when sal = 2000 then null else 1 end is null) end is true";
        this.checkPlanning(this.tester, preProgram, (RelOptPlanner)hepPlanner, "select sal\nfrom emp\nwhere case when (sal = 1000) then\n(case when sal = 1000 then null else 1 end is null) else\n(case when sal = 2000 then null else 1 end is null) end is true");
    }

    @Test
    public void testReduceCompositeInSubQuery() {
        HepProgram hepProgram = new HepProgramBuilder().addRuleInstance((RelOptRule)ReduceExpressionsRule.FILTER_INSTANCE).build();
        String sql = "select *\nfrom emp\nwhere (empno, deptno) in (\n  select empno, deptno from (\n    select empno, deptno\n    from emp\n    group by empno, deptno))\nor deptno < 40 + 60";
        this.checkSubQuery("select *\nfrom emp\nwhere (empno, deptno) in (\n  select empno, deptno from (\n    select empno, deptno\n    from emp\n    group by empno, deptno))\nor deptno < 40 + 60").with(hepProgram).check();
    }

    @Test
    public void testReduceOrCaseWhen() {
        HepProgram preProgram = new HepProgramBuilder().build();
        HepProgramBuilder builder = new HepProgramBuilder();
        builder.addRuleClass(ReduceExpressionsRule.class);
        HepPlanner hepPlanner = new HepPlanner(builder.build());
        hepPlanner.addRule((RelOptRule)ReduceExpressionsRule.FILTER_INSTANCE);
        String sql = "select sal\nfrom emp\nwhere case when sal = 1000 then null else 1 end is null\nOR case when sal = 2000 then null else 1 end is null";
        this.checkPlanning(this.tester, preProgram, (RelOptPlanner)hepPlanner, "select sal\nfrom emp\nwhere case when sal = 1000 then null else 1 end is null\nOR case when sal = 2000 then null else 1 end is null");
    }

    @Test
    public void testReduceNullableCase() {
        HepProgramBuilder builder = new HepProgramBuilder();
        builder.addRuleClass(ReduceExpressionsRule.class);
        HepPlanner hepPlanner = new HepPlanner(builder.build());
        hepPlanner.addRule((RelOptRule)ReduceExpressionsRule.PROJECT_INSTANCE);
        String sql = "SELECT CASE WHEN 1=2 THEN cast((values(1)) as integer) ELSE 2 end from (values(1))";
        this.sql("SELECT CASE WHEN 1=2 THEN cast((values(1)) as integer) ELSE 2 end from (values(1))").with(hepPlanner).check();
    }

    @Test
    public void testReduceNullableCase2() {
        HepProgramBuilder builder = new HepProgramBuilder();
        builder.addRuleClass(ReduceExpressionsRule.class);
        HepPlanner hepPlanner = new HepPlanner(builder.build());
        hepPlanner.addRule((RelOptRule)ReduceExpressionsRule.PROJECT_INSTANCE);
        String sql = "SELECT deptno, ename, CASE WHEN 1=2 THEN substring(ename, 1, cast(2 as int)) ELSE NULL end from emp group by deptno, ename, case when 1=2 then substring(ename,1, cast(2 as int))  else null end";
        this.sql("SELECT deptno, ename, CASE WHEN 1=2 THEN substring(ename, 1, cast(2 as int)) ELSE NULL end from emp group by deptno, ename, case when 1=2 then substring(ename,1, cast(2 as int))  else null end").with(hepPlanner).check();
    }

    @Test
    public void testProjectToWindowRuleForMultipleWindows() {
        HepProgram preProgram = new HepProgramBuilder().build();
        HepProgramBuilder builder = new HepProgramBuilder();
        builder.addRuleClass(ProjectToWindowRule.class);
        HepPlanner hepPlanner = new HepPlanner(builder.build());
        hepPlanner.addRule((RelOptRule)ProjectToWindowRule.PROJECT);
        String sql = "select\n count(*) over(partition by empno order by sal) as count1,\n count(*) over(partition by deptno order by sal) as count2,\n sum(deptno) over(partition by empno order by sal) as sum1,\n sum(deptno) over(partition by deptno order by sal) as sum2\nfrom emp";
        this.checkPlanning(this.tester, preProgram, (RelOptPlanner)hepPlanner, "select\n count(*) over(partition by empno order by sal) as count1,\n count(*) over(partition by deptno order by sal) as count2,\n sum(deptno) over(partition by empno order by sal) as sum1,\n sum(deptno) over(partition by deptno order by sal) as sum2\nfrom emp");
    }

    @Test
    public void testUnionToDistinctRule() {
        this.checkPlanning((RelOptRule)UnionToDistinctRule.INSTANCE, "select * from dept union select * from dept");
    }

    @Test
    public void testExtractJoinFilterRule() {
        this.checkPlanning((RelOptRule)JoinExtractFilterRule.INSTANCE, "select 1 from emp inner join dept on emp.deptno=dept.deptno");
    }

    @Test
    public void testAddRedundantSemiJoinRule() {
        this.checkPlanning((RelOptRule)JoinAddRedundantSemiJoinRule.INSTANCE, "select 1 from emp inner join dept on emp.deptno = dept.deptno");
    }

    @Test
    public void testStrengthenJoinType() {
        HepProgram preProgram = HepProgram.builder().addRuleInstance((RelOptRule)ProjectMergeRule.INSTANCE).addRuleInstance((RelOptRule)FilterProjectTransposeRule.INSTANCE).build();
        HepProgram program = HepProgram.builder().addRuleInstance((RelOptRule)FilterJoinRule.FILTER_ON_JOIN).build();
        String sql = "select *\nfrom dept left join emp using (deptno)\nwhere emp.deptno is not null and emp.sal > 100";
        this.sql("select *\nfrom dept left join emp using (deptno)\nwhere emp.deptno is not null and emp.sal > 100").withDecorrelation(true).withTrim(true).withPre(preProgram).with(program).check();
    }

    @Test
    public void testFullOuterJoinSimplificationToLeftOuter() {
        this.checkPlanning((RelOptRule)FilterJoinRule.FILTER_ON_JOIN, "select 1 from sales.dept d full outer join sales.emp e on d.deptno = e.deptno where d.name = 'Charlie'");
    }

    @Test
    public void testFullOuterJoinSimplificationToRightOuter() {
        this.checkPlanning((RelOptRule)FilterJoinRule.FILTER_ON_JOIN, "select 1 from sales.dept d full outer join sales.emp e on d.deptno = e.deptno where e.sal > 100");
    }

    @Test
    public void testFullOuterJoinSimplificationToInner() {
        this.checkPlanning((RelOptRule)FilterJoinRule.FILTER_ON_JOIN, "select 1 from sales.dept d full outer join sales.emp e on d.deptno = e.deptno where d.name = 'Charlie' and e.sal > 100");
    }

    @Test
    public void testLeftOuterJoinSimplificationToInner() {
        this.checkPlanning((RelOptRule)FilterJoinRule.FILTER_ON_JOIN, "select 1 from sales.dept d left outer join sales.emp e on d.deptno = e.deptno where e.sal > 100");
    }

    @Test
    public void testRightOuterJoinSimplificationToInner() {
        this.checkPlanning((RelOptRule)FilterJoinRule.FILTER_ON_JOIN, "select 1 from sales.dept d right outer join sales.emp e on d.deptno = e.deptno where d.name = 'Charlie'");
    }

    @Test
    public void testPushFilterPastAgg() {
        this.checkPlanning((RelOptRule)FilterAggregateTransposeRule.INSTANCE, "select dname, c from (select name dname, count(*) as c from dept group by name) t where dname = 'Charlie'");
    }

    private void basePushFilterPastAggWithGroupingSets(boolean unchanged) throws Exception {
        HepProgram preProgram = HepProgram.builder().addRuleInstance((RelOptRule)ProjectMergeRule.INSTANCE).addRuleInstance((RelOptRule)FilterProjectTransposeRule.INSTANCE).build();
        HepProgram program = HepProgram.builder().addRuleInstance((RelOptRule)FilterAggregateTransposeRule.INSTANCE).build();
        this.checkPlanning(this.tester, preProgram, (RelOptPlanner)new HepPlanner(program), "${sql}", unchanged);
    }

    @Test
    public void testPushFilterPastAggWithGroupingSets1() throws Exception {
        this.basePushFilterPastAggWithGroupingSets(true);
    }

    @Test
    public void testPushFilterPastAggWithGroupingSets2() throws Exception {
        this.basePushFilterPastAggWithGroupingSets(false);
    }

    @Test
    public void testPushFilterPastAggTwo() {
        this.checkPlanning((RelOptRule)FilterAggregateTransposeRule.INSTANCE, "select dept1.c1 from (\n  select dept.name as c1, count(*) as c2\n  from dept where dept.name > 'b' group by dept.name) dept1\nwhere dept1.c1 > 'c' and (dept1.c2 > 30 or dept1.c1 < 'z')");
    }

    @Test
    public void testPushFilterPastAggThree() {
        HepProgram program = HepProgram.builder().addRuleInstance((RelOptRule)FilterAggregateTransposeRule.INSTANCE).build();
        String sql = "select deptno from emp\ngroup by deptno having count(*) > 1";
        this.checkPlanUnchanged((RelOptPlanner)new HepPlanner(program), "select deptno from emp\ngroup by deptno having count(*) > 1");
    }

    @Test
    public void testPushFilterPastAggFour() {
        HepProgram preProgram = HepProgram.builder().addRuleInstance((RelOptRule)AggregateProjectMergeRule.INSTANCE).addRuleInstance((RelOptRule)AggregateFilterTransposeRule.INSTANCE).build();
        HepProgram program = HepProgram.builder().addRuleInstance((RelOptRule)FilterAggregateTransposeRule.INSTANCE).build();
        this.checkPlanning(this.tester, preProgram, (RelOptPlanner)new HepPlanner(program), "select emp.deptno, count(*) from emp where emp.sal > '12' group by emp.deptno\n", false);
    }

    @Test
    public void testPushFilterPastProject() {
        HepProgram preProgram = HepProgram.builder().addRuleInstance((RelOptRule)ProjectMergeRule.INSTANCE).build();
        FilterJoinRule.Predicate predicate = new FilterJoinRule.Predicate(){

            public boolean apply(Join join, JoinRelType joinType, RexNode exp) {
                return joinType != JoinRelType.INNER;
            }
        };
        FilterJoinRule.JoinConditionPushRule join = new FilterJoinRule.JoinConditionPushRule(RelBuilder.proto((Object[])new Object[0]), predicate);
        FilterJoinRule.FilterIntoJoinRule filterOnJoin = new FilterJoinRule.FilterIntoJoinRule(true, RelBuilder.proto((Object[])new Object[0]), predicate);
        HepProgram program = HepProgram.builder().addGroupBegin().addRuleInstance((RelOptRule)FilterProjectTransposeRule.INSTANCE).addRuleInstance((RelOptRule)join).addRuleInstance((RelOptRule)filterOnJoin).addGroupEnd().build();
        String sql = "select a.name\nfrom dept a\nleft join dept b on b.deptno > 10\nright join dept c on b.deptno > 10\n";
        this.checkPlanning(this.tester, preProgram, (RelOptPlanner)new HepPlanner(program), "select a.name\nfrom dept a\nleft join dept b on b.deptno > 10\nright join dept c on b.deptno > 10\n");
    }

    @Test
    public void testJoinProjectTranspose() {
        HepProgram preProgram = HepProgram.builder().addRuleInstance((RelOptRule)ProjectJoinTransposeRule.INSTANCE).addRuleInstance((RelOptRule)ProjectMergeRule.INSTANCE).build();
        HepProgram program = HepProgram.builder().addRuleInstance((RelOptRule)JoinProjectTransposeRule.LEFT_PROJECT_INCLUDE_OUTER).addRuleInstance((RelOptRule)ProjectMergeRule.INSTANCE).addRuleInstance((RelOptRule)JoinProjectTransposeRule.RIGHT_PROJECT_INCLUDE_OUTER).addRuleInstance((RelOptRule)JoinProjectTransposeRule.LEFT_PROJECT_INCLUDE_OUTER).addRuleInstance((RelOptRule)ProjectMergeRule.INSTANCE).build();
        String sql = "select a.name\nfrom dept a\nleft join dept b on b.deptno > 10\nright join dept c on b.deptno > 10\n";
        this.checkPlanning(this.tester, preProgram, (RelOptPlanner)new HepPlanner(program), "select a.name\nfrom dept a\nleft join dept b on b.deptno > 10\nright join dept c on b.deptno > 10\n");
    }

    @Test
    public void testSortUnionTranspose() {
        HepProgram program = HepProgram.builder().addRuleInstance((RelOptRule)ProjectSetOpTransposeRule.INSTANCE).addRuleInstance((RelOptRule)SortUnionTransposeRule.INSTANCE).build();
        String sql = "select a.name from dept a\nunion all\nselect b.name from dept b\norder by name limit 10";
        this.checkPlanning(program, "select a.name from dept a\nunion all\nselect b.name from dept b\norder by name limit 10");
    }

    @Test
    public void testSortUnionTranspose2() {
        HepProgram program = HepProgram.builder().addRuleInstance((RelOptRule)ProjectSetOpTransposeRule.INSTANCE).addRuleInstance((RelOptRule)SortUnionTransposeRule.MATCH_NULL_FETCH).build();
        String sql = "select a.name from dept a\nunion all\nselect b.name from dept b\norder by name";
        this.checkPlanning(program, "select a.name from dept a\nunion all\nselect b.name from dept b\norder by name");
    }

    @Test
    public void testSortUnionTranspose3() {
        HepProgram program = HepProgram.builder().addRuleInstance((RelOptRule)ProjectSetOpTransposeRule.INSTANCE).addRuleInstance((RelOptRule)SortUnionTransposeRule.MATCH_NULL_FETCH).build();
        String sql = "select a.name from dept a\nunion all\nselect b.name from dept b\norder by name limit 0";
        this.checkPlanning(program, "select a.name from dept a\nunion all\nselect b.name from dept b\norder by name limit 0");
    }

    @Test
    public void testSemiJoinRuleExists() {
        HepProgram preProgram = HepProgram.builder().addRuleInstance((RelOptRule)FilterProjectTransposeRule.INSTANCE).addRuleInstance((RelOptRule)FilterJoinRule.FILTER_ON_JOIN).addRuleInstance((RelOptRule)ProjectMergeRule.INSTANCE).build();
        HepProgram program = HepProgram.builder().addRuleInstance((RelOptRule)SemiJoinRule.PROJECT).build();
        String sql = "select * from dept where exists (\n  select * from emp\n  where emp.deptno = dept.deptno\n  and emp.sal > 100)";
        this.sql("select * from dept where exists (\n  select * from emp\n  where emp.deptno = dept.deptno\n  and emp.sal > 100)").withDecorrelation(true).withTrim(true).withPre(preProgram).with(program).check();
    }

    @Test
    public void testSemiJoinRule() {
        HepProgram preProgram = HepProgram.builder().addRuleInstance((RelOptRule)FilterProjectTransposeRule.INSTANCE).addRuleInstance((RelOptRule)FilterJoinRule.FILTER_ON_JOIN).addRuleInstance((RelOptRule)ProjectMergeRule.INSTANCE).build();
        HepProgram program = HepProgram.builder().addRuleInstance((RelOptRule)SemiJoinRule.PROJECT).build();
        String sql = "select dept.* from dept join (\n  select distinct deptno from emp\n  where sal > 100) using (deptno)";
        this.sql("select dept.* from dept join (\n  select distinct deptno from emp\n  where sal > 100) using (deptno)").withDecorrelation(true).withTrim(true).withPre(preProgram).with(program).check();
    }

    @Test
    public void testSemiJoinRuleRight() {
        HepProgram preProgram = HepProgram.builder().addRuleInstance((RelOptRule)FilterProjectTransposeRule.INSTANCE).addRuleInstance((RelOptRule)FilterJoinRule.FILTER_ON_JOIN).addRuleInstance((RelOptRule)ProjectMergeRule.INSTANCE).build();
        HepProgram program = HepProgram.builder().addRuleInstance((RelOptRule)SemiJoinRule.PROJECT).build();
        String sql = "select dept.* from dept right join (\n  select distinct deptno from emp\n  where sal > 100) using (deptno)";
        this.sql("select dept.* from dept right join (\n  select distinct deptno from emp\n  where sal > 100) using (deptno)").withPre(preProgram).with(program).withDecorrelation(true).withTrim(true).checkUnchanged();
    }

    @Test
    public void testSemiJoinRuleFull() {
        HepProgram preProgram = HepProgram.builder().addRuleInstance((RelOptRule)FilterProjectTransposeRule.INSTANCE).addRuleInstance((RelOptRule)FilterJoinRule.FILTER_ON_JOIN).addRuleInstance((RelOptRule)ProjectMergeRule.INSTANCE).build();
        HepProgram program = HepProgram.builder().addRuleInstance((RelOptRule)SemiJoinRule.PROJECT).build();
        String sql = "select dept.* from dept full join (\n  select distinct deptno from emp\n  where sal > 100) using (deptno)";
        this.sql("select dept.* from dept full join (\n  select distinct deptno from emp\n  where sal > 100) using (deptno)").withPre(preProgram).with(program).withDecorrelation(true).withTrim(true).checkUnchanged();
    }

    @Test
    public void testSemiJoinRuleLeft() {
        HepProgram preProgram = HepProgram.builder().addRuleInstance((RelOptRule)FilterProjectTransposeRule.INSTANCE).addRuleInstance((RelOptRule)FilterJoinRule.FILTER_ON_JOIN).addRuleInstance((RelOptRule)ProjectMergeRule.INSTANCE).build();
        HepProgram program = HepProgram.builder().addRuleInstance((RelOptRule)SemiJoinRule.PROJECT).build();
        String sql = "select name from dept left join (\n  select distinct deptno from emp\n  where sal > 100) using (deptno)";
        this.sql("select name from dept left join (\n  select distinct deptno from emp\n  where sal > 100) using (deptno)").withPre(preProgram).with(program).withDecorrelation(true).withTrim(true).check();
    }

    @Test
    public void testPushFilterThroughSemiJoin() {
        HepProgram preProgram = HepProgram.builder().addRuleInstance((RelOptRule)SemiJoinRule.PROJECT).build();
        HepProgram program = HepProgram.builder().addRuleInstance((RelOptRule)FilterProjectTransposeRule.INSTANCE).addRuleInstance((RelOptRule)FilterJoinRule.FILTER_ON_JOIN).addRuleInstance((RelOptRule)FilterJoinRule.JOIN).build();
        String sql = "select * from (\n  select * from dept where dept.deptno in (\n    select emp.deptno from emp))R\nwhere R.deptno <=10";
        this.sql("select * from (\n  select * from dept where dept.deptno in (\n    select emp.deptno from emp))R\nwhere R.deptno <=10").withDecorrelation(true).withTrim(false).withPre(preProgram).with(program).check();
    }

    @Test
    public void testSemiJoinReduceConstants() {
        HepProgram preProgram = HepProgram.builder().addRuleInstance((RelOptRule)SemiJoinRule.PROJECT).build();
        HepProgram program = HepProgram.builder().addRuleInstance((RelOptRule)ReduceExpressionsRule.JOIN_INSTANCE).build();
        String sql = "select e1.sal\nfrom (select * from emp where deptno = 200) as e1\nwhere e1.deptno in (\n  select e2.deptno from emp e2 where e2.sal = 100)";
        this.sql("select e1.sal\nfrom (select * from emp where deptno = 200) as e1\nwhere e1.deptno in (\n  select e2.deptno from emp e2 where e2.sal = 100)").withDecorrelation(false).withTrim(true).withPre(preProgram).with(program).checkUnchanged();
    }

    @Test
    public void testSemiJoinTrim() throws Exception {
        DiffRepository diffRepos = this.getDiffRepos();
        String sql = diffRepos.expand(null, "${sql}");
        SqlToRelTestBase.TesterImpl t = (SqlToRelTestBase.TesterImpl)this.tester;
        RelDataTypeFactory typeFactory = t.getTypeFactory();
        Prepare.CatalogReader catalogReader = t.createCatalogReader(typeFactory);
        SqlValidator validator = t.createValidator((SqlValidatorCatalogReader)catalogReader, typeFactory);
        SqlToRelConverter converter = t.createSqlToRelConverter(validator, catalogReader, typeFactory, SqlToRelConverter.Config.DEFAULT);
        SqlNode sqlQuery = t.parseQuery(sql);
        SqlNode validatedQuery = validator.validate(sqlQuery);
        RelRoot root = converter.convertQuery(validatedQuery, false, true);
        root = root.withRel(converter.decorrelate(sqlQuery, root.rel));
        HepProgram program = HepProgram.builder().addRuleInstance((RelOptRule)FilterProjectTransposeRule.INSTANCE).addRuleInstance((RelOptRule)FilterJoinRule.FILTER_ON_JOIN).addRuleInstance((RelOptRule)ProjectMergeRule.INSTANCE).addRuleInstance((RelOptRule)SemiJoinRule.PROJECT).build();
        HepPlanner planner = new HepPlanner(program);
        planner.setRoot(root.rel);
        root = root.withRel(planner.findBestExp());
        String planBefore = NL + RelOptUtil.toString((RelNode)root.rel);
        diffRepos.assertEquals("planBefore", "${planBefore}", planBefore);
        converter = t.createSqlToRelConverter(validator, catalogReader, typeFactory, SqlToRelConverter.configBuilder().withTrimUnusedFields(true).build());
        root = root.withRel(converter.trimUnusedFields(false, root.rel));
        String planAfter = NL + RelOptUtil.toString((RelNode)root.rel);
        diffRepos.assertEquals("planAfter", "${planAfter}", planAfter);
    }

    @Test
    public void testReduceAverage() {
        this.checkPlanning((RelOptRule)AggregateReduceFunctionsRule.INSTANCE, "select name, max(name), avg(deptno), min(name) from sales.dept group by name");
    }

    @Test
    public void testCastInAggregateReduceFunctions() {
        HepProgram program = HepProgram.builder().addRuleInstance((RelOptRule)AggregateReduceFunctionsRule.INSTANCE).build();
        String sql = "select name, stddev_pop(deptno), avg(deptno), stddev_samp(deptno),var_pop(deptno), var_samp(deptno)\nfrom sales.dept group by name";
        this.sql("select name, stddev_pop(deptno), avg(deptno), stddev_samp(deptno),var_pop(deptno), var_samp(deptno)\nfrom sales.dept group by name").with(program).check();
    }

    @Test
    public void testDistinctCount1() {
        HepProgram program = HepProgram.builder().addRuleInstance((RelOptRule)AggregateExpandDistinctAggregatesRule.INSTANCE).addRuleInstance((RelOptRule)AggregateProjectMergeRule.INSTANCE).build();
        this.checkPlanning(program, "select deptno, count(distinct ename) from sales.emp group by deptno");
    }

    @Test
    public void testDistinctCount2() {
        HepProgram program = HepProgram.builder().addRuleInstance((RelOptRule)AggregateExpandDistinctAggregatesRule.INSTANCE).addRuleInstance((RelOptRule)AggregateProjectMergeRule.INSTANCE).build();
        this.checkPlanning(program, "select deptno, count(distinct ename), sum(sal) from sales.emp group by deptno");
    }

    @Test
    public void testDistinctCount3() {
        String sql = "select count(distinct deptno), sum(sal) from sales.emp group by deptno";
        HepProgram program = HepProgram.builder().addRuleInstance((RelOptRule)AggregateExpandDistinctAggregatesRule.INSTANCE).build();
        this.sql("select count(distinct deptno), sum(sal) from sales.emp group by deptno").with(program).check();
    }

    @Test
    public void testDistinctCountMultipleViaJoin() {
        HepProgram program = HepProgram.builder().addRuleInstance((RelOptRule)AggregateExpandDistinctAggregatesRule.JOIN).addRuleInstance((RelOptRule)AggregateProjectMergeRule.INSTANCE).build();
        this.checkPlanning(program, "select deptno, count(distinct ename), count(distinct job, ename),\n  count(distinct deptno, job), sum(sal)\n from sales.emp group by deptno");
    }

    @Test
    public void testDistinctCountMultiple() {
        HepProgram program = HepProgram.builder().addRuleInstance((RelOptRule)AggregateExpandDistinctAggregatesRule.INSTANCE).addRuleInstance((RelOptRule)AggregateProjectMergeRule.INSTANCE).build();
        this.checkPlanning(program, "select deptno, count(distinct ename), count(distinct job)\n from sales.emp group by deptno");
    }

    @Test
    public void testDistinctCountMultipleNoGroup() {
        HepProgram program = HepProgram.builder().addRuleInstance((RelOptRule)AggregateExpandDistinctAggregatesRule.INSTANCE).addRuleInstance((RelOptRule)AggregateProjectMergeRule.INSTANCE).build();
        this.checkPlanning(program, "select count(distinct ename), count(distinct job)\n from sales.emp");
    }

    @Test
    public void testDistinctCountMixedJoin() {
        HepProgram program = HepProgram.builder().addRuleInstance((RelOptRule)AggregateExpandDistinctAggregatesRule.JOIN).addRuleInstance((RelOptRule)AggregateProjectMergeRule.INSTANCE).build();
        this.checkPlanning(program, "select deptno, count(distinct ename), count(distinct job, ename),\n  count(distinct deptno, job), sum(sal)\n from sales.emp group by deptno");
    }

    @Test
    public void testDistinctCountMixed() {
        HepProgram program = HepProgram.builder().addRuleInstance((RelOptRule)AggregateExpandDistinctAggregatesRule.INSTANCE).addRuleInstance((RelOptRule)ProjectMergeRule.INSTANCE).build();
        this.checkPlanning(program, "select deptno, count(distinct deptno, job) as cddj, sum(sal) as s\n from sales.emp group by deptno");
    }

    @Test
    public void testDistinctCountMixed2() {
        HepProgram program = HepProgram.builder().addRuleInstance((RelOptRule)AggregateExpandDistinctAggregatesRule.INSTANCE).addRuleInstance((RelOptRule)AggregateProjectMergeRule.INSTANCE).addRuleInstance((RelOptRule)ProjectMergeRule.INSTANCE).build();
        this.checkPlanning(program, "select deptno, count(distinct ename) as cde,\n  count(distinct job, ename) as cdje,\n  count(distinct deptno, job) as cddj,\n  sum(sal) as s\n from sales.emp group by deptno");
    }

    @Test
    public void testDistinctCountGroupingSets1() {
        HepProgram program = HepProgram.builder().addRuleInstance((RelOptRule)AggregateExpandDistinctAggregatesRule.INSTANCE).addRuleInstance((RelOptRule)ProjectMergeRule.INSTANCE).build();
        this.checkPlanning(program, "select deptno, job, count(distinct ename) from sales.emp group by rollup(deptno,job)");
    }

    @Test
    public void testDistinctCountGroupingSets2() {
        HepProgram program = HepProgram.builder().addRuleInstance((RelOptRule)AggregateExpandDistinctAggregatesRule.INSTANCE).addRuleInstance((RelOptRule)ProjectMergeRule.INSTANCE).build();
        this.checkPlanning(program, "select deptno, job, count(distinct ename), sum(sal) from sales.emp group by rollup(deptno,job)");
    }

    @Test
    public void testDistinctNonDistinctAggregates() {
        String sql = "select emp.empno, count(*), avg(distinct dept.deptno)\nfrom sales.emp emp inner join sales.dept dept\non emp.deptno = dept.deptno\ngroup by emp.empno";
        HepProgram program = HepProgram.builder().addRuleInstance((RelOptRule)AggregateExpandDistinctAggregatesRule.JOIN).build();
        this.sql("select emp.empno, count(*), avg(distinct dept.deptno)\nfrom sales.emp emp inner join sales.dept dept\non emp.deptno = dept.deptno\ngroup by emp.empno").with(program).check();
    }

    @Test
    public void testCastInAggregateExpandDistinctAggregatesRule() {
        String sql = "select name, sum(distinct cn), sum(distinct sm)\nfrom (\n  select name, count(dept.deptno) as cn,sum(dept.deptno) as sm\n  from sales.dept group by name)\ngroup by name";
        HepProgram program = HepProgram.builder().addRuleInstance((RelOptRule)AggregateExpandDistinctAggregatesRule.INSTANCE).build();
        this.sql("select name, sum(distinct cn), sum(distinct sm)\nfrom (\n  select name, count(dept.deptno) as cn,sum(dept.deptno) as sm\n  from sales.dept group by name)\ngroup by name").with(program).check();
    }

    @Test
    public void testDistinctNonDistinctAggregatesWithGrouping1() {
        String sql = "SELECT deptno,\n  SUM(deptno), SUM(DISTINCT sal), MAX(deptno), MAX(comm)\nFROM emp\nGROUP BY deptno";
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)AggregateExpandDistinctAggregatesRule.JOIN).build();
        this.sql("SELECT deptno,\n  SUM(deptno), SUM(DISTINCT sal), MAX(deptno), MAX(comm)\nFROM emp\nGROUP BY deptno").with(program).check();
    }

    @Test
    public void testDistinctNonDistinctAggregatesWithGrouping2() {
        String sql = "SELECT deptno, COUNT(deptno), SUM(DISTINCT sal)\nFROM emp\nGROUP BY deptno";
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)AggregateExpandDistinctAggregatesRule.JOIN).build();
        this.sql("SELECT deptno, COUNT(deptno), SUM(DISTINCT sal)\nFROM emp\nGROUP BY deptno").with(program).check();
    }

    @Test
    public void testPushProjectPastFilter() {
        this.checkPlanning((RelOptRule)ProjectFilterTransposeRule.INSTANCE, "select empno + deptno from emp where sal = 10 * comm and upper(ename) = 'FOO'");
    }

    @Test
    public void testPushProjectPastFilter2() {
        String sql = "select count(*)\nfrom emp\nwhere case when mgr < 10 then true else false end";
        this.sql("select count(*)\nfrom emp\nwhere case when mgr < 10 then true else false end").withRule((RelOptRule)ProjectFilterTransposeRule.INSTANCE).check();
    }

    @Test
    public void testPushProjectPastJoin() {
        this.checkPlanning((RelOptRule)ProjectJoinTransposeRule.INSTANCE, "select e.sal + b.comm from emp e inner join bonus b on e.ename = b.ename and e.deptno = 10");
    }

    @Test
    public void testPushProjectPastInnerJoin() {
        String sql = "select count(*), case when e.sal < 11 then 11 else -1 * e.sal end\nfrom emp e inner join bonus b on e.ename = b.ename\ngroup by case when e.sal < 11 then 11 else -1 * e.sal end";
        this.sql("select count(*), case when e.sal < 11 then 11 else -1 * e.sal end\nfrom emp e inner join bonus b on e.ename = b.ename\ngroup by case when e.sal < 11 then 11 else -1 * e.sal end").withRule((RelOptRule)ProjectJoinTransposeRule.INSTANCE).check();
    }

    @Test
    public void testPushProjectPastInnerJoinStrong() {
        String sql = "select count(*), case when e.sal < 11 then -1 * e.sal else e.sal end\nfrom emp e inner join bonus b on e.ename = b.ename\ngroup by case when e.sal < 11 then -1 * e.sal else e.sal end";
        this.sql("select count(*), case when e.sal < 11 then -1 * e.sal else e.sal end\nfrom emp e inner join bonus b on e.ename = b.ename\ngroup by case when e.sal < 11 then -1 * e.sal else e.sal end").withRule((RelOptRule)ProjectJoinTransposeRule.INSTANCE).check();
    }

    @Test
    public void testPushProjectPastLeftJoin() {
        String sql = "select count(*), case when e.sal < 11 then 11 else -1 * e.sal end\nfrom emp e left outer join bonus b on e.ename = b.ename\ngroup by case when e.sal < 11 then 11 else -1 * e.sal end";
        this.sql("select count(*), case when e.sal < 11 then 11 else -1 * e.sal end\nfrom emp e left outer join bonus b on e.ename = b.ename\ngroup by case when e.sal < 11 then 11 else -1 * e.sal end").withRule((RelOptRule)ProjectJoinTransposeRule.INSTANCE).check();
    }

    @Test
    public void testPushProjectPastLeftJoinSwap() {
        String sql = "select count(*), case when e.sal < 11 then 11 else -1 * e.sal end\nfrom bonus b left outer join emp e on e.ename = b.ename\ngroup by case when e.sal < 11 then 11 else -1 * e.sal end";
        this.sql("select count(*), case when e.sal < 11 then 11 else -1 * e.sal end\nfrom bonus b left outer join emp e on e.ename = b.ename\ngroup by case when e.sal < 11 then 11 else -1 * e.sal end").withRule((RelOptRule)ProjectJoinTransposeRule.INSTANCE).check();
    }

    @Test
    public void testPushProjectPastLeftJoinSwapStrong() {
        String sql = "select count(*), case when e.sal < 11 then -1 * e.sal else e.sal end\nfrom bonus b left outer join emp e on e.ename = b.ename\ngroup by case when e.sal < 11 then -1 * e.sal else e.sal end";
        this.sql("select count(*), case when e.sal < 11 then -1 * e.sal else e.sal end\nfrom bonus b left outer join emp e on e.ename = b.ename\ngroup by case when e.sal < 11 then -1 * e.sal else e.sal end").withRule((RelOptRule)ProjectJoinTransposeRule.INSTANCE).check();
    }

    @Test
    public void testPushProjectPastRightJoin() {
        String sql = "select count(*), case when e.sal < 11 then 11 else -1 * e.sal end\nfrom emp e right outer join bonus b on e.ename = b.ename\ngroup by case when e.sal < 11 then 11 else -1 * e.sal end";
        this.sql("select count(*), case when e.sal < 11 then 11 else -1 * e.sal end\nfrom emp e right outer join bonus b on e.ename = b.ename\ngroup by case when e.sal < 11 then 11 else -1 * e.sal end").withRule((RelOptRule)ProjectJoinTransposeRule.INSTANCE).check();
    }

    @Test
    public void testPushProjectPastRightJoinStrong() {
        String sql = "select count(*),\n case when e.sal < 11 then -1 * e.sal else e.sal end\nfrom emp e right outer join bonus b on e.ename = b.ename\ngroup by case when e.sal < 11 then -1 * e.sal else e.sal end";
        this.sql("select count(*),\n case when e.sal < 11 then -1 * e.sal else e.sal end\nfrom emp e right outer join bonus b on e.ename = b.ename\ngroup by case when e.sal < 11 then -1 * e.sal else e.sal end").withRule((RelOptRule)ProjectJoinTransposeRule.INSTANCE).check();
    }

    @Test
    public void testPushProjectPastRightJoinSwap() {
        String sql = "select count(*), case when e.sal < 11 then 11 else -1 * e.sal end\nfrom bonus b right outer join emp e on e.ename = b.ename\ngroup by case when e.sal < 11 then 11 else -1 * e.sal end";
        this.sql("select count(*), case when e.sal < 11 then 11 else -1 * e.sal end\nfrom bonus b right outer join emp e on e.ename = b.ename\ngroup by case when e.sal < 11 then 11 else -1 * e.sal end").withRule((RelOptRule)ProjectJoinTransposeRule.INSTANCE).check();
    }

    @Test
    public void testPushProjectPastRightJoinSwapStrong() {
        String sql = "select count(*), case when e.sal < 11 then -1 * e.sal else e.sal end\nfrom bonus b right outer join emp e on e.ename = b.ename\ngroup by case when e.sal < 11 then -1 * e.sal else e.sal end";
        this.sql("select count(*), case when e.sal < 11 then -1 * e.sal else e.sal end\nfrom bonus b right outer join emp e on e.ename = b.ename\ngroup by case when e.sal < 11 then -1 * e.sal else e.sal end").withRule((RelOptRule)ProjectJoinTransposeRule.INSTANCE).check();
    }

    @Test
    public void testPushProjectPastFullJoin() {
        String sql = "select count(*), case when e.sal < 11 then 11 else -1 * e.sal end\nfrom emp e full outer join bonus b on e.ename = b.ename\ngroup by case when e.sal < 11 then 11 else -1 * e.sal end";
        this.sql("select count(*), case when e.sal < 11 then 11 else -1 * e.sal end\nfrom emp e full outer join bonus b on e.ename = b.ename\ngroup by case when e.sal < 11 then 11 else -1 * e.sal end").withRule((RelOptRule)ProjectJoinTransposeRule.INSTANCE).check();
    }

    @Test
    public void testPushProjectPastFullJoinStrong() {
        String sql = "select count(*), case when e.sal < 11 then -1 * e.sal else e.sal end\nfrom emp e full outer join bonus b on e.ename = b.ename\ngroup by case when e.sal < 11 then -1 * e.sal else e.sal end";
        this.sql("select count(*), case when e.sal < 11 then -1 * e.sal else e.sal end\nfrom emp e full outer join bonus b on e.ename = b.ename\ngroup by case when e.sal < 11 then -1 * e.sal else e.sal end").withRule((RelOptRule)ProjectJoinTransposeRule.INSTANCE).check();
    }

    @Test
    public void testPushProjectPastSetOp() {
        this.checkPlanning((RelOptRule)ProjectSetOpTransposeRule.INSTANCE, "select sal from (select * from emp e1 union all select * from emp e2)");
    }

    @Test
    public void testPushJoinThroughUnionOnLeft() {
        this.checkPlanning((RelOptRule)JoinUnionTransposeRule.LEFT_UNION, "select r1.sal from (select * from emp e1 union all select * from emp e2) r1, emp r2");
    }

    @Test
    public void testPushJoinThroughUnionOnRight() {
        this.checkPlanning((RelOptRule)JoinUnionTransposeRule.RIGHT_UNION, "select r1.sal from emp r1, (select * from emp e1 union all select * from emp e2) r2");
    }

    @Ignore(value="cycles")
    @Test
    public void testMergeFilterWithJoinCondition() throws Exception {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)TableScanRule.INSTANCE).addRuleInstance((RelOptRule)JoinExtractFilterRule.INSTANCE).addRuleInstance((RelOptRule)FilterToCalcRule.INSTANCE).addRuleInstance((RelOptRule)CalcMergeRule.INSTANCE).addRuleInstance((RelOptRule)ProjectToCalcRule.INSTANCE).build();
        this.checkPlanning(program, "select d.name as dname,e.ename as ename from emp e inner join dept d on e.deptno=d.deptno where d.name='Propane'");
    }

    @Test
    public void testMergeFilter() throws Exception {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)FilterProjectTransposeRule.INSTANCE).addRuleInstance((RelOptRule)FilterMergeRule.INSTANCE).build();
        this.checkPlanning(program, "select name from (\n  select *\n  from dept\n  where deptno = 10)\nwhere deptno = 10\n");
    }

    @Test
    public void testUnionMergeRule() throws Exception {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)ProjectSetOpTransposeRule.INSTANCE).addRuleInstance((RelOptRule)ProjectRemoveRule.INSTANCE).addRuleInstance((RelOptRule)UnionMergeRule.INSTANCE).build();
        this.checkPlanning(program, "select * from (\nselect * from (\n  select name, deptno from dept\n  union all\n  select name, deptno from\n  (\n    select name, deptno, count(1) from dept group by name, deptno\n    union all\n    select name, deptno, count(1) from dept group by name, deptno\n  ) subq\n) a\nunion all\nselect name, deptno from dept\n) aa\n");
    }

    @Test
    public void testMinusMergeRule() throws Exception {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)ProjectSetOpTransposeRule.INSTANCE).addRuleInstance((RelOptRule)ProjectRemoveRule.INSTANCE).addRuleInstance((RelOptRule)UnionMergeRule.MINUS_INSTANCE).build();
        this.checkPlanning(program, "select * from (\nselect * from (\n  select name, deptno from\n  (\n    select name, deptno, count(1) from dept group by name, deptno\n    except all\n    select name, deptno, 1 from dept\n  ) subq\n  except all\n  select name, deptno from\n  (\n    select name, deptno, 1 from dept\n    except all\n    select name, deptno, count(1) from dept group by name, deptno\n  ) subq2\n) a\nexcept all\nselect name, deptno from dept\n) aa\n");
    }

    @Test
    public void testMergeJoinFilter() throws Exception {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)FilterProjectTransposeRule.INSTANCE).addRuleInstance((RelOptRule)FilterMergeRule.INSTANCE).addRuleInstance((RelOptRule)FilterJoinRule.FILTER_ON_JOIN).build();
        this.checkPlanning(program, "select * from (\n  select d.deptno, e.ename\n  from emp as e\n  join dept as d\n  on e.deptno = d.deptno\n  and d.deptno = 10)\nwhere deptno = 10\n");
    }

    @Test
    public void testMergeUnionAll() throws Exception {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)UnionMergeRule.INSTANCE).build();
        String sql = "select * from emp where deptno = 10\nunion all\nselect * from emp where deptno = 20\nunion all\nselect * from emp where deptno = 30\n";
        this.sql("select * from emp where deptno = 10\nunion all\nselect * from emp where deptno = 20\nunion all\nselect * from emp where deptno = 30\n").with(program).check();
    }

    @Test
    public void testMergeUnionDistinct() throws Exception {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)UnionMergeRule.INSTANCE).build();
        String sql = "select * from emp where deptno = 10\nunion distinct\nselect * from emp where deptno = 20\nunion\nselect * from emp where deptno = 30\n";
        this.sql("select * from emp where deptno = 10\nunion distinct\nselect * from emp where deptno = 20\nunion\nselect * from emp where deptno = 30\n").with(program).check();
    }

    @Test
    public void testMergeUnionMixed() throws Exception {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)UnionMergeRule.INSTANCE).build();
        String sql = "select * from emp where deptno = 10\nunion\nselect * from emp where deptno = 20\nunion all\nselect * from emp where deptno = 30\n";
        this.sql("select * from emp where deptno = 10\nunion\nselect * from emp where deptno = 20\nunion all\nselect * from emp where deptno = 30\n").with(program).checkUnchanged();
    }

    @Test
    public void testMergeUnionMixed2() throws Exception {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)UnionMergeRule.INSTANCE).build();
        String sql = "select * from emp where deptno = 10\nunion all\nselect * from emp where deptno = 20\nunion\nselect * from emp where deptno = 30\n";
        this.sql("select * from emp where deptno = 10\nunion all\nselect * from emp where deptno = 20\nunion\nselect * from emp where deptno = 30\n").with(program).check();
    }

    @Test
    public void testMergeSetOpMixed() throws Exception {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)UnionMergeRule.INSTANCE).addRuleInstance((RelOptRule)UnionMergeRule.INTERSECT_INSTANCE).build();
        String sql = "select * from emp where deptno = 10\nunion\nselect * from emp where deptno = 20\nintersect\nselect * from emp where deptno = 30\n";
        this.sql("select * from emp where deptno = 10\nunion\nselect * from emp where deptno = 20\nintersect\nselect * from emp where deptno = 30\n").with(program).checkUnchanged();
    }

    @Test
    public void testMergeIntersect() throws Exception {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)UnionMergeRule.INTERSECT_INSTANCE).build();
        String sql = "select * from emp where deptno = 10\nintersect\nselect * from emp where deptno = 20\nintersect\nselect * from emp where deptno = 30\n";
        this.sql("select * from emp where deptno = 10\nintersect\nselect * from emp where deptno = 20\nintersect\nselect * from emp where deptno = 30\n").with(program).check();
    }

    @Test
    public void testIntersectToDistinct() throws Exception {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)UnionMergeRule.INTERSECT_INSTANCE).addRuleInstance((RelOptRule)IntersectToDistinctRule.INSTANCE).build();
        String sql = "select * from emp where deptno = 10\nintersect\nselect * from emp where deptno = 20\nintersect\nselect * from emp where deptno = 30\n";
        this.sql("select * from emp where deptno = 10\nintersect\nselect * from emp where deptno = 20\nintersect\nselect * from emp where deptno = 30\n").with(program).check();
    }

    @Test
    public void testIntersectToDistinctAll() throws Exception {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)UnionMergeRule.INTERSECT_INSTANCE).addRuleInstance((RelOptRule)IntersectToDistinctRule.INSTANCE).build();
        String sql = "select * from emp where deptno = 10\nintersect\nselect * from emp where deptno = 20\nintersect all\nselect * from emp where deptno = 30\n";
        this.sql("select * from emp where deptno = 10\nintersect\nselect * from emp where deptno = 20\nintersect all\nselect * from emp where deptno = 30\n").with(program).check();
    }

    @Test
    public void testMergeMinus() throws Exception {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)UnionMergeRule.MINUS_INSTANCE).build();
        String sql = "select * from emp where deptno = 10\nexcept\nselect * from emp where deptno = 20\nexcept\nselect * from emp where deptno = 30\n";
        this.sql("select * from emp where deptno = 10\nexcept\nselect * from emp where deptno = 20\nexcept\nselect * from emp where deptno = 30\n").with(program).check();
    }

    @Test
    public void testMergeMinusRightDeep() throws Exception {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)UnionMergeRule.MINUS_INSTANCE).build();
        String sql = "select * from emp where deptno = 10\nexcept\nselect * from (\n  select * from emp where deptno = 20\n  except\n  select * from emp where deptno = 30)";
        this.sql("select * from emp where deptno = 10\nexcept\nselect * from (\n  select * from emp where deptno = 20\n  except\n  select * from emp where deptno = 30)").with(program).checkUnchanged();
    }

    @Ignore(value="cycles")
    @Test
    public void testHeterogeneousConversion() throws Exception {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)TableScanRule.INSTANCE).addRuleInstance((RelOptRule)ProjectToCalcRule.INSTANCE).addMatchLimit(1).addMatchLimit(Integer.MAX_VALUE).build();
        this.checkPlanning(program, "select upper(ename) from emp union all select lower(ename) from emp");
    }

    @Test
    public void testPushSemiJoinPastJoinRuleLeft() throws Exception {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)FilterJoinRule.FILTER_ON_JOIN).addRuleInstance((RelOptRule)JoinAddRedundantSemiJoinRule.INSTANCE).addRuleInstance((RelOptRule)SemiJoinJoinTransposeRule.INSTANCE).build();
        this.checkPlanning(program, "select e1.ename from emp e1, dept d, emp e2 where e1.deptno = d.deptno and e1.empno = e2.empno");
    }

    @Test
    public void testPushSemiJoinPastJoinRuleRight() throws Exception {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)FilterJoinRule.FILTER_ON_JOIN).addRuleInstance((RelOptRule)JoinAddRedundantSemiJoinRule.INSTANCE).addRuleInstance((RelOptRule)SemiJoinJoinTransposeRule.INSTANCE).build();
        this.checkPlanning(program, "select e1.ename from emp e1, dept d, emp e2 where e1.deptno = d.deptno and d.deptno = e2.deptno");
    }

    @Test
    public void testPushSemiJoinPastFilter() throws Exception {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)FilterJoinRule.FILTER_ON_JOIN).addRuleInstance((RelOptRule)JoinAddRedundantSemiJoinRule.INSTANCE).addRuleInstance((RelOptRule)SemiJoinFilterTransposeRule.INSTANCE).build();
        this.checkPlanning(program, "select e.ename from emp e, dept d where e.deptno = d.deptno and e.ename = 'foo'");
    }

    @Test
    public void testConvertMultiJoinRule() throws Exception {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)FilterJoinRule.FILTER_ON_JOIN).addMatchOrder(HepMatchOrder.BOTTOM_UP).addRuleInstance((RelOptRule)JoinToMultiJoinRule.INSTANCE).build();
        this.checkPlanning(program, "select e1.ename from emp e1, dept d, emp e2 where e1.deptno = d.deptno and d.deptno = e2.deptno");
    }

    @Test
    public void testReduceConstants() throws Exception {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)ReduceExpressionsRule.PROJECT_INSTANCE).addRuleInstance((RelOptRule)ReduceExpressionsRule.FILTER_INSTANCE).addRuleInstance((RelOptRule)ReduceExpressionsRule.JOIN_INSTANCE).build();
        String sql = "select 1+2, d.deptno+(3+4), (5+6)+d.deptno, cast(null as integer), coalesce(2,null), row(7+8) from dept d inner join emp e on d.deptno = e.deptno + (5-5) where d.deptno=(7+8) and d.deptno=(8+7) and d.deptno=coalesce(2,null)";
        this.sql("select 1+2, d.deptno+(3+4), (5+6)+d.deptno, cast(null as integer), coalesce(2,null), row(7+8) from dept d inner join emp e on d.deptno = e.deptno + (5-5) where d.deptno=(7+8) and d.deptno=(8+7) and d.deptno=coalesce(2,null)").with(program).withProperty(Hook.REL_BUILDER_SIMPLIFY, false).check();
    }

    @Test
    public void testReduceConstantsDup() throws Exception {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)ReduceExpressionsRule.PROJECT_INSTANCE).addRuleInstance((RelOptRule)ReduceExpressionsRule.FILTER_INSTANCE).addRuleInstance((RelOptRule)ReduceExpressionsRule.JOIN_INSTANCE).build();
        String sql = "select d.deptno from dept d where d.deptno=7 and d.deptno=8";
        this.checkPlanning((RelOptPlanner)new HepPlanner(program), "select d.deptno from dept d where d.deptno=7 and d.deptno=8");
    }

    @Test
    public void testReduceConstantsDup2() throws Exception {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)ReduceExpressionsRule.PROJECT_INSTANCE).addRuleInstance((RelOptRule)ReduceExpressionsRule.FILTER_INSTANCE).addRuleInstance((RelOptRule)ReduceExpressionsRule.JOIN_INSTANCE).build();
        String sql = "select *\nfrom emp\nwhere deptno=7 and deptno=8\nand empno = 10 and mgr is null and empno = 10";
        this.checkPlanning(program, "select *\nfrom emp\nwhere deptno=7 and deptno=8\nand empno = 10 and mgr is null and empno = 10");
    }

    @Test
    public void testPullNull() throws Exception {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)ReduceExpressionsRule.PROJECT_INSTANCE).addRuleInstance((RelOptRule)ReduceExpressionsRule.FILTER_INSTANCE).addRuleInstance((RelOptRule)ReduceExpressionsRule.JOIN_INSTANCE).build();
        String sql = "select *\nfrom emp\nwhere deptno=7\nand empno = 10 and mgr is null and empno = 10";
        this.checkPlanning(program, "select *\nfrom emp\nwhere deptno=7\nand empno = 10 and mgr is null and empno = 10");
    }

    @Test
    public void testReduceConstants2() throws Exception {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)ReduceExpressionsRule.PROJECT_INSTANCE).addRuleInstance((RelOptRule)ReduceExpressionsRule.FILTER_INSTANCE).addRuleInstance((RelOptRule)ReduceExpressionsRule.JOIN_INSTANCE).build();
        this.checkPlanning(program, "select p1 is not distinct from p0 from (values (2, cast(null as integer))) as t(p0, p1)");
    }

    @Test
    public void testReduceConstantsProjectNullable() throws Exception {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)ReduceExpressionsRule.PROJECT_INSTANCE).addRuleInstance((RelOptRule)ReduceExpressionsRule.FILTER_INSTANCE).addRuleInstance((RelOptRule)ReduceExpressionsRule.JOIN_INSTANCE).build();
        this.checkPlanning(program, "select mgr from emp where mgr=10");
    }

    @Test
    public void testReduceConstantsNullEqualsOne() throws Exception {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)ReduceExpressionsRule.PROJECT_INSTANCE).addRuleInstance((RelOptRule)ReduceExpressionsRule.FILTER_INSTANCE).addRuleInstance((RelOptRule)ReduceExpressionsRule.JOIN_INSTANCE).build();
        this.checkPlanning(program, "select count(1) from emp where cast(null as integer) = 1");
    }

    @Test
    public void testReduceConstantsCaseEquals() throws Exception {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)ReduceExpressionsRule.PROJECT_INSTANCE).addRuleInstance((RelOptRule)ReduceExpressionsRule.FILTER_INSTANCE).addRuleInstance((RelOptRule)ReduceExpressionsRule.JOIN_INSTANCE).build();
        this.checkPlanning(program, "select count(1) from emp\nwhere case deptno\n  when 20 then 2\n  when 10 then 1\n  else 3 end = 1");
    }

    @Test
    public void testReduceConstantsCaseEquals2() throws Exception {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)ReduceExpressionsRule.PROJECT_INSTANCE).addRuleInstance((RelOptRule)ReduceExpressionsRule.FILTER_INSTANCE).addRuleInstance((RelOptRule)ReduceExpressionsRule.JOIN_INSTANCE).build();
        this.checkPlanning(program, "select count(1) from emp\nwhere case deptno\n  when 20 then 2\n  when 10 then 1\n  else cast(null as integer) end = 1");
    }

    @Test
    public void testReduceConstantsCaseEquals3() throws Exception {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)ReduceExpressionsRule.PROJECT_INSTANCE).addRuleInstance((RelOptRule)ReduceExpressionsRule.FILTER_INSTANCE).addRuleInstance((RelOptRule)ReduceExpressionsRule.JOIN_INSTANCE).build();
        this.checkPlanning(program, "select count(1) from emp\nwhere case deptno\n  when 30 then 1\n  when 20 then 2\n  when 10 then 1\n  when 30 then 111\n  else 0 end = 1");
    }

    @Test
    public void testReduceConstantsEliminatesFilter() throws Exception {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)ReduceExpressionsRule.FILTER_INSTANCE).build();
        this.checkPlanning(program, "select * from (values (1,2)) where 1 + 2 > 3 + CAST(NULL AS INTEGER)");
    }

    @Test
    public void testReduceConstantsRequiresExecutor() throws Exception {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)ReduceExpressionsRule.FILTER_INSTANCE).build();
        this.tester.convertSqlToRel((String)"values 1").rel.getCluster().getPlanner().setExecutor(null);
        String sql = "select * from (values (1,2)) where 1 + 2 > 3 + CAST(NULL AS INTEGER)";
        this.checkPlanUnchanged((RelOptPlanner)new HepPlanner(program), "select * from (values (1,2)) where 1 + 2 > 3 + CAST(NULL AS INTEGER)");
    }

    @Test
    public void testAlreadyFalseEliminatesFilter() throws Exception {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)ReduceExpressionsRule.FILTER_INSTANCE).build();
        this.checkPlanning(program, "select * from (values (1,2)) where false");
    }

    @Test
    public void testReduceConstantsCalc() throws Exception {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)FilterProjectTransposeRule.INSTANCE).addRuleInstance((RelOptRule)FilterSetOpTransposeRule.INSTANCE).addRuleInstance((RelOptRule)FilterToCalcRule.INSTANCE).addRuleInstance((RelOptRule)ProjectToCalcRule.INSTANCE).addRuleInstance((RelOptRule)CalcMergeRule.INSTANCE).addRuleInstance((RelOptRule)ReduceExpressionsRule.CALC_INSTANCE).addRuleInstance(PruneEmptyRules.UNION_INSTANCE).addRuleInstance((RelOptRule)ProjectToCalcRule.INSTANCE).addRuleInstance((RelOptRule)CalcMergeRule.INSTANCE).addRuleInstance((RelOptRule)ReduceExpressionsRule.CALC_INSTANCE).build();
        this.checkPlanning(program, "select * from (\n  select upper(substring(x FROM 1 FOR 2) || substring(x FROM 3)) as u,\n      substring(x FROM 1 FOR 1) as s\n  from (\n    select 'table' as x from (values (true))\n    union\n    select 'view' from (values (true))\n    union\n    select 'foreign table' from (values (true))\n  )\n) where u = 'TABLE'");
    }

    @Test
    public void testRemoveSemiJoin() throws Exception {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)FilterJoinRule.FILTER_ON_JOIN).addRuleInstance((RelOptRule)JoinAddRedundantSemiJoinRule.INSTANCE).addRuleInstance((RelOptRule)SemiJoinRemoveRule.INSTANCE).build();
        this.checkPlanning(program, "select e.ename from emp e, dept d where e.deptno = d.deptno");
    }

    @Test
    public void testRemoveSemiJoinWithFilter() throws Exception {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)FilterJoinRule.FILTER_ON_JOIN).addRuleInstance((RelOptRule)JoinAddRedundantSemiJoinRule.INSTANCE).addRuleInstance((RelOptRule)SemiJoinFilterTransposeRule.INSTANCE).addRuleInstance((RelOptRule)SemiJoinRemoveRule.INSTANCE).build();
        this.checkPlanning(program, "select e.ename from emp e, dept d where e.deptno = d.deptno and e.ename = 'foo'");
    }

    @Test
    public void testRemoveSemiJoinRight() throws Exception {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)FilterJoinRule.FILTER_ON_JOIN).addRuleInstance((RelOptRule)JoinAddRedundantSemiJoinRule.INSTANCE).addRuleInstance((RelOptRule)SemiJoinJoinTransposeRule.INSTANCE).addRuleInstance((RelOptRule)SemiJoinRemoveRule.INSTANCE).build();
        this.checkPlanning(program, "select e1.ename from emp e1, dept d, emp e2 where e1.deptno = d.deptno and d.deptno = e2.deptno");
    }

    @Test
    public void testRemoveSemiJoinRightWithFilter() throws Exception {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)FilterJoinRule.FILTER_ON_JOIN).addRuleInstance((RelOptRule)JoinAddRedundantSemiJoinRule.INSTANCE).addRuleInstance((RelOptRule)SemiJoinJoinTransposeRule.INSTANCE).addRuleInstance((RelOptRule)SemiJoinFilterTransposeRule.INSTANCE).addRuleInstance((RelOptRule)SemiJoinRemoveRule.INSTANCE).build();
        this.checkPlanning(program, "select e1.ename from emp e1, dept d, emp e2 where e1.deptno = d.deptno and d.deptno = e2.deptno and d.name = 'foo'");
    }

    private void checkPlanning(String query) throws Exception {
        SqlToRelTestBase.Tester tester1 = this.tester.withCatalogReaderFactory(new Function<RelDataTypeFactory, Prepare.CatalogReader>(){

            public Prepare.CatalogReader apply(RelDataTypeFactory typeFactory) {
                return new MockCatalogReader(typeFactory, true){

                    @Override
                    public MockCatalogReader init() {
                        MockCatalogReader.MockSchema schema = new MockCatalogReader.MockSchema("SALES");
                        this.registerSchema(schema);
                        RelDataType intType = this.typeFactory.createSqlType(SqlTypeName.INTEGER);
                        for (int i = 0; i < 10; ++i) {
                            String t = String.valueOf((char)(65 + i));
                            MockCatalogReader.MockTable table = MockCatalogReader.MockTable.create(this, schema, t, false, 100.0);
                            table.addColumn(t, intType);
                            this.registerTable(table);
                        }
                        return this;
                    }
                }.init();
            }
        });
        HepProgram program = new HepProgramBuilder().addMatchOrder(HepMatchOrder.BOTTOM_UP).addRuleInstance((RelOptRule)ProjectRemoveRule.INSTANCE).addRuleInstance((RelOptRule)JoinToMultiJoinRule.INSTANCE).build();
        this.checkPlanning(tester1, null, (RelOptPlanner)new HepPlanner(program), query);
    }

    @Test
    public void testConvertMultiJoinRuleOuterJoins() throws Exception {
        this.checkPlanning("select * from     (select * from         (select * from             (select * from A right outer join B on a = b)             left outer join             (select * from C full outer join D on c = d)            on a = c and b = d)         right outer join         (select * from             (select * from E full outer join F on e = f)             right outer join             (select * from G left outer join H on g = h)             on e = g and f = h)         on a = e and b = f and c = g and d = h)     inner join     (select * from I inner join J on i = j)     on a = i and h = j");
    }

    @Test
    public void testConvertMultiJoinRuleOuterJoins2() throws Exception {
        this.checkPlanning("select * from A right join B on a = b join C on b = c");
    }

    @Test
    public void testConvertMultiJoinRuleOuterJoins3() throws Exception {
        this.checkPlanning("select * from A join B on a = b left join C on b = c");
    }

    @Test
    public void testConvertMultiJoinRuleOuterJoins4() throws Exception {
        this.checkPlanning("select * from A join B on a = b right join C on b = c");
    }

    @Test
    public void testPushSemiJoinPastProject() throws Exception {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)FilterJoinRule.FILTER_ON_JOIN).addRuleInstance((RelOptRule)JoinAddRedundantSemiJoinRule.INSTANCE).addRuleInstance((RelOptRule)SemiJoinProjectTransposeRule.INSTANCE).build();
        this.checkPlanning(program, "select e.* from (select ename, trim(job), sal * 2, deptno from emp) e, dept d where e.deptno = d.deptno");
    }

    @Test
    public void testReduceValuesUnderFilter() throws Exception {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)FilterProjectTransposeRule.INSTANCE).addRuleInstance((RelOptRule)ValuesReduceRule.FILTER_INSTANCE).build();
        this.checkPlanning(program, "select a, b from (values (10, 'x'), (20, 'y')) as t(a, b) where a < 15");
    }

    @Test
    public void testReduceValuesUnderProject() throws Exception {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)ProjectMergeRule.INSTANCE).addRuleInstance((RelOptRule)ValuesReduceRule.PROJECT_INSTANCE).build();
        this.checkPlanning(program, "select a + b from (values (10, 1), (20, 3)) as t(a, b)");
    }

    @Test
    public void testReduceValuesUnderProjectFilter() throws Exception {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)FilterProjectTransposeRule.INSTANCE).addRuleInstance((RelOptRule)ProjectMergeRule.INSTANCE).addRuleInstance((RelOptRule)ValuesReduceRule.PROJECT_FILTER_INSTANCE).build();
        this.checkPlanning(program, "select a + b as x, b, a from (values (10, 1), (30, 7), (20, 3)) as t(a, b) where a - b < 21");
    }

    @Ignore
    @Test
    public void testReduceCase() throws Exception {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)ReduceExpressionsRule.PROJECT_INSTANCE).build();
        String sql = "select\n  case when false then cast(2.1 as float)\n   else cast(1 as integer) end as newcol\nfrom emp";
        this.sql("select\n  case when false then cast(2.1 as float)\n   else cast(1 as integer) end as newcol\nfrom emp").with(program).withProperty(Hook.REL_BUILDER_SIMPLIFY, false).check();
    }

    @Test
    public void testReduceConstantsIsNull() throws Exception {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)ReduceExpressionsRule.FILTER_INSTANCE).build();
        this.checkPlanning(program, "select empno from emp where empno=10 and empno is null");
    }

    @Test
    public void testReduceConstantsIsNotNull() throws Exception {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)ReduceExpressionsRule.FILTER_INSTANCE).build();
        String sql = "select empno from emp\nwhere empno=10 and empno is not null";
        this.checkPlanning(program, "select empno from emp\nwhere empno=10 and empno is not null");
    }

    @Test
    public void testReduceConstantsNegated() throws Exception {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)ReduceExpressionsRule.FILTER_INSTANCE).build();
        String sql = "select empno from emp\nwhere empno=10 and not(empno=10)";
        this.checkPlanning(program, "select empno from emp\nwhere empno=10 and not(empno=10)");
    }

    @Test
    public void testReduceConstantsNegatedInverted() throws Exception {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)ReduceExpressionsRule.FILTER_INSTANCE).build();
        String sql = "select empno from emp where empno>10 and empno<=10";
        this.checkPlanning(program, "select empno from emp where empno>10 and empno<=10");
    }

    @Ignore
    @Test
    public void testReduceValuesNull() throws Exception {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)ValuesReduceRule.PROJECT_INSTANCE).build();
        this.checkPlanning(program, "insert into sales.depts(deptno,name) values (NULL, 'null')");
    }

    @Test
    public void testReduceValuesToEmpty() throws Exception {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)FilterProjectTransposeRule.INSTANCE).addRuleInstance((RelOptRule)ProjectMergeRule.INSTANCE).addRuleInstance((RelOptRule)ValuesReduceRule.PROJECT_FILTER_INSTANCE).build();
        this.checkPlanning(program, "select a + b as x, b, a from (values (10, 1), (30, 7)) as t(a, b) where a - b < 0");
    }

    @Test
    public void testEmptyFilterProjectUnion() throws Exception {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)FilterSetOpTransposeRule.INSTANCE).addRuleInstance((RelOptRule)FilterProjectTransposeRule.INSTANCE).addRuleInstance((RelOptRule)ProjectMergeRule.INSTANCE).addRuleInstance((RelOptRule)ValuesReduceRule.PROJECT_FILTER_INSTANCE).addRuleInstance(PruneEmptyRules.PROJECT_INSTANCE).addRuleInstance(PruneEmptyRules.UNION_INSTANCE).build();
        this.checkPlanning(program, "select * from (\nselect * from (values (10, 1), (30, 3)) as t (x, y)\nunion all\nselect * from (values (20, 2))\n)\nwhere x + y > 30");
    }

    @Test
    public void testEmptyProject() throws Exception {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)ValuesReduceRule.PROJECT_FILTER_INSTANCE).addRuleInstance((RelOptRule)ValuesReduceRule.FILTER_INSTANCE).addRuleInstance((RelOptRule)ValuesReduceRule.PROJECT_INSTANCE).build();
        String sql = "select z + x from (\n  select x + y as z, x from (\n    select * from (values (10, 1), (30, 3)) as t (x, y)\n    where x + y > 50))";
        this.sql("select z + x from (\n  select x + y as z, x from (\n    select * from (values (10, 1), (30, 3)) as t (x, y)\n    where x + y > 50))").with(program).check();
    }

    @Test
    public void testEmptyProject2() throws Exception {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)ValuesReduceRule.FILTER_INSTANCE).addRuleInstance(PruneEmptyRules.PROJECT_INSTANCE).build();
        String sql = "select z + x from (\n  select x + y as z, x from (\n    select * from (values (10, 1), (30, 3)) as t (x, y)\n    where x + y > 50))";
        this.sql("select z + x from (\n  select x + y as z, x from (\n    select * from (values (10, 1), (30, 3)) as t (x, y)\n    where x + y > 50))").with(program).check();
    }

    @Test
    public void testEmptyIntersect() throws Exception {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)ValuesReduceRule.PROJECT_FILTER_INSTANCE).addRuleInstance(PruneEmptyRules.PROJECT_INSTANCE).addRuleInstance(PruneEmptyRules.INTERSECT_INSTANCE).build();
        String sql = "select * from (values (30, 3))intersect\nselect *\nfrom (values (10, 1), (30, 3)) as t (x, y) where x > 50\nintersect\nselect * from (values (30, 3))";
        this.sql("select * from (values (30, 3))intersect\nselect *\nfrom (values (10, 1), (30, 3)) as t (x, y) where x > 50\nintersect\nselect * from (values (30, 3))").with(program).check();
    }

    @Test
    public void testEmptyMinus() throws Exception {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)ValuesReduceRule.PROJECT_FILTER_INSTANCE).addRuleInstance(PruneEmptyRules.PROJECT_INSTANCE).addRuleInstance(PruneEmptyRules.MINUS_INSTANCE).build();
        String sql = "select * from (values (30, 3)) as t (x, y)\nwhere x > 30\nexcept\nselect * from (values (20, 2))\nexcept\nselect * from (values (40, 4))";
        this.sql("select * from (values (30, 3)) as t (x, y)\nwhere x > 30\nexcept\nselect * from (values (20, 2))\nexcept\nselect * from (values (40, 4))").with(program).check();
    }

    @Test
    public void testEmptyMinus2() throws Exception {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)ValuesReduceRule.PROJECT_FILTER_INSTANCE).addRuleInstance(PruneEmptyRules.PROJECT_INSTANCE).addRuleInstance(PruneEmptyRules.MINUS_INSTANCE).build();
        String sql = "select * from (values (30, 3)) as t (x, y)\nexcept\nselect * from (values (20, 2)) as t (x, y) where x > 30\nexcept\nselect * from (values (40, 4))\nexcept\nselect * from (values (50, 5)) as t (x, y) where x > 50";
        this.sql("select * from (values (30, 3)) as t (x, y)\nexcept\nselect * from (values (20, 2)) as t (x, y) where x > 30\nexcept\nselect * from (values (40, 4))\nexcept\nselect * from (values (50, 5)) as t (x, y) where x > 50").with(program).check();
    }

    @Test
    public void testEmptyJoin() {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)ReduceExpressionsRule.FILTER_INSTANCE).addRuleInstance(PruneEmptyRules.PROJECT_INSTANCE).addRuleInstance(PruneEmptyRules.JOIN_LEFT_INSTANCE).addRuleInstance(PruneEmptyRules.JOIN_RIGHT_INSTANCE).build();
        this.checkPlanning(program, "select * from (\nselect * from emp where false)\njoin dept using (deptno)");
    }

    @Test
    public void testEmptyJoinLeft() {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)ReduceExpressionsRule.FILTER_INSTANCE).addRuleInstance(PruneEmptyRules.PROJECT_INSTANCE).addRuleInstance(PruneEmptyRules.JOIN_LEFT_INSTANCE).addRuleInstance(PruneEmptyRules.JOIN_RIGHT_INSTANCE).build();
        this.checkPlanning(program, "select * from (\nselect * from emp where false)\nleft join dept using (deptno)");
    }

    @Test
    public void testEmptyJoinRight() {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)ReduceExpressionsRule.FILTER_INSTANCE).addRuleInstance(PruneEmptyRules.PROJECT_INSTANCE).addRuleInstance(PruneEmptyRules.JOIN_LEFT_INSTANCE).addRuleInstance(PruneEmptyRules.JOIN_RIGHT_INSTANCE).build();
        this.checkPlanning(program, "select * from (\nselect * from emp where false)\nright join dept using (deptno)");
    }

    @Test
    public void testEmptySort() {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)ReduceExpressionsRule.FILTER_INSTANCE).addRuleInstance(PruneEmptyRules.SORT_INSTANCE).build();
        this.checkPlanning(program, "select * from emp where false order by deptno");
    }

    @Test
    public void testEmptySortLimitZero() {
        HepProgram program = new HepProgramBuilder().addRuleInstance(PruneEmptyRules.SORT_FETCH_ZERO_INSTANCE).build();
        this.checkPlanning(program, "select * from emp order by deptno limit 0");
    }

    @Test
    public void testEmptyAggregate() {
        HepProgram preProgram = HepProgram.builder().addRuleInstance((RelOptRule)ReduceExpressionsRule.FILTER_INSTANCE).addRuleInstance(PruneEmptyRules.PROJECT_INSTANCE).build();
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)ReduceExpressionsRule.FILTER_INSTANCE).addRuleInstance(PruneEmptyRules.PROJECT_INSTANCE).addRuleInstance(PruneEmptyRules.AGGREGATE_INSTANCE).addRuleInstance(PruneEmptyRules.PROJECT_INSTANCE).build();
        String sql = "select sum(empno) from emp where false group by deptno";
        this.checkPlanning(this.tester, preProgram, (RelOptPlanner)new HepPlanner(program), "select sum(empno) from emp where false group by deptno");
    }

    @Test
    public void testEmptyAggregateEmptyKey() {
        HepProgram preProgram = HepProgram.builder().addRuleInstance((RelOptRule)ReduceExpressionsRule.FILTER_INSTANCE).addRuleInstance(PruneEmptyRules.PROJECT_INSTANCE).build();
        HepProgram program = new HepProgramBuilder().addRuleInstance(PruneEmptyRules.AGGREGATE_INSTANCE).build();
        String sql = "select sum(empno) from emp where false";
        boolean unchanged = true;
        this.checkPlanning(this.tester, preProgram, (RelOptPlanner)new HepPlanner(program), "select sum(empno) from emp where false", true);
    }

    @Test
    public void testEmptyAggregateEmptyKeyWithAggregateValuesRule() {
        HepProgram preProgram = HepProgram.builder().addRuleInstance((RelOptRule)ReduceExpressionsRule.FILTER_INSTANCE).addRuleInstance(PruneEmptyRules.PROJECT_INSTANCE).build();
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)AggregateValuesRule.INSTANCE).build();
        String sql = "select count(*), sum(empno) from emp where false";
        this.sql("select count(*), sum(empno) from emp where false").withPre(preProgram).with(program).check();
    }

    @Test
    public void testReduceCasts() throws Exception {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)ReduceExpressionsRule.PROJECT_INSTANCE).addRuleInstance((RelOptRule)ReduceExpressionsRule.FILTER_INSTANCE).addRuleInstance((RelOptRule)ReduceExpressionsRule.JOIN_INSTANCE).build();
        this.checkPlanning(program, "select cast(d.name as varchar(128)), cast(e.empno as integer) from dept as d inner join emp as e on cast(d.deptno as integer) = cast(e.deptno as integer) where cast(e.job as varchar(1)) = 'Manager'");
    }

    @Test
    public void testReduceCastTimeUnchanged() throws Exception {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)ReduceExpressionsRule.PROJECT_INSTANCE).addRuleInstance((RelOptRule)ReduceExpressionsRule.FILTER_INSTANCE).addRuleInstance((RelOptRule)ReduceExpressionsRule.JOIN_INSTANCE).build();
        this.sql("select cast(time '12:34:56' as timestamp) from emp as e").with(program).checkUnchanged();
    }

    @Test
    public void testReduceCastAndConsts() throws Exception {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)ReduceExpressionsRule.FILTER_INSTANCE).build();
        this.checkPlanning(program, "select * from emp where cast((empno + (10/2)) as int) = 13");
    }

    @Ignore
    @Test
    public void testReduceCastsNullable() throws Exception {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)new CoerceInputsRule(LogicalTableModify.class, false)).addRuleInstance((RelOptRule)ProjectToCalcRule.INSTANCE).addRuleInstance((RelOptRule)CalcMergeRule.INSTANCE).addRuleInstance((RelOptRule)ReduceExpressionsRule.CALC_INSTANCE).build();
        this.checkPlanning(program, "insert into sales.depts(name) select cast(gender as varchar(128)) from sales.emps");
    }

    private void basePushAggThroughUnion() throws Exception {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)ProjectSetOpTransposeRule.INSTANCE).addRuleInstance((RelOptRule)ProjectMergeRule.INSTANCE).addRuleInstance((RelOptRule)AggregateUnionTransposeRule.INSTANCE).build();
        this.checkPlanning(program, "${sql}");
    }

    @Test
    public void testPushSumConstantThroughUnion() throws Exception {
        this.basePushAggThroughUnion();
    }

    @Test
    public void testPushSumNullConstantThroughUnion() throws Exception {
        this.basePushAggThroughUnion();
    }

    @Test
    public void testPushSumNullableThroughUnion() throws Exception {
        this.basePushAggThroughUnion();
    }

    @Test
    public void testPushSumNullableNOGBYThroughUnion() throws Exception {
        this.basePushAggThroughUnion();
    }

    @Test
    public void testPushCountStarThroughUnion() throws Exception {
        this.basePushAggThroughUnion();
    }

    @Test
    public void testPushCountNullableThroughUnion() throws Exception {
        this.basePushAggThroughUnion();
    }

    @Test
    public void testPushMaxNullableThroughUnion() throws Exception {
        this.basePushAggThroughUnion();
    }

    @Test
    public void testPushMinThroughUnion() throws Exception {
        this.basePushAggThroughUnion();
    }

    @Test
    public void testPushAvgThroughUnion() throws Exception {
        this.basePushAggThroughUnion();
    }

    @Test
    public void testPushSumCountStarThroughUnion() throws Exception {
        this.basePushAggThroughUnion();
    }

    @Test
    public void testPushSumConstantGroupingSetsThroughUnion() throws Exception {
        this.basePushAggThroughUnion();
    }

    @Test
    public void testPushSumNullConstantGroupingSetsThroughUnion() throws Exception {
        this.basePushAggThroughUnion();
    }

    @Test
    public void testPushSumNullableGroupingSetsThroughUnion() throws Exception {
        this.basePushAggThroughUnion();
    }

    @Test
    public void testPushCountStarGroupingSetsThroughUnion() throws Exception {
        this.basePushAggThroughUnion();
    }

    @Test
    public void testPushCountNullableGroupingSetsThroughUnion() throws Exception {
        this.basePushAggThroughUnion();
    }

    @Test
    public void testPushMaxNullableGroupingSetsThroughUnion() throws Exception {
        this.basePushAggThroughUnion();
    }

    @Test
    public void testPushMinGroupingSetsThroughUnion() throws Exception {
        this.basePushAggThroughUnion();
    }

    @Test
    public void testPushAvgGroupingSetsThroughUnion() throws Exception {
        this.basePushAggThroughUnion();
    }

    @Test
    public void testPushSumCountStarGroupingSetsThroughUnion() throws Exception {
        this.basePushAggThroughUnion();
    }

    @Test
    public void testPushCountFilterThroughUnion() throws Exception {
        this.basePushAggThroughUnion();
    }

    @Test
    public void testPullFilterThroughAggregate() throws Exception {
        HepProgram preProgram = HepProgram.builder().addRuleInstance((RelOptRule)ProjectMergeRule.INSTANCE).addRuleInstance((RelOptRule)ProjectFilterTransposeRule.INSTANCE).build();
        HepProgram program = HepProgram.builder().addRuleInstance((RelOptRule)AggregateFilterTransposeRule.INSTANCE).build();
        String sql = "select ename, sal, deptno from (  select ename, sal, deptno  from emp  where sal > 5000)group by ename, sal, deptno";
        this.checkPlanning(this.tester, preProgram, (RelOptPlanner)new HepPlanner(program), "select ename, sal, deptno from (  select ename, sal, deptno  from emp  where sal > 5000)group by ename, sal, deptno");
    }

    @Test
    public void testPullFilterThroughAggregateGroupingSets() throws Exception {
        HepProgram preProgram = HepProgram.builder().addRuleInstance((RelOptRule)ProjectMergeRule.INSTANCE).addRuleInstance((RelOptRule)ProjectFilterTransposeRule.INSTANCE).build();
        HepProgram program = HepProgram.builder().addRuleInstance((RelOptRule)AggregateFilterTransposeRule.INSTANCE).build();
        String sql = "select ename, sal, deptno from (  select ename, sal, deptno  from emp  where sal > 5000)group by rollup(ename, sal, deptno)";
        this.checkPlanning(this.tester, preProgram, (RelOptPlanner)new HepPlanner(program), "select ename, sal, deptno from (  select ename, sal, deptno  from emp  where sal > 5000)group by rollup(ename, sal, deptno)");
    }

    private void basePullConstantTroughAggregate() throws Exception {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)ProjectMergeRule.INSTANCE).addRuleInstance((RelOptRule)AggregateProjectPullUpConstantsRule.INSTANCE).addRuleInstance((RelOptRule)ProjectMergeRule.INSTANCE).build();
        this.checkPlanning(program, "${sql}");
    }

    @Test
    public void testPullConstantThroughConstLast() throws Exception {
        this.basePullConstantTroughAggregate();
    }

    @Test
    public void testPullConstantThroughAggregateSimpleNonNullable() throws Exception {
        this.basePullConstantTroughAggregate();
    }

    @Test
    public void testPullConstantThroughAggregatePermuted() throws Exception {
        this.basePullConstantTroughAggregate();
    }

    @Test
    public void testPullConstantThroughAggregatePermutedConstFirst() throws Exception {
        this.basePullConstantTroughAggregate();
    }

    @Test
    public void testPullConstantThroughAggregatePermutedConstGroupBy() throws Exception {
        this.basePullConstantTroughAggregate();
    }

    @Test
    public void testPullConstantThroughAggregateConstGroupBy() throws Exception {
        this.basePullConstantTroughAggregate();
    }

    @Test
    public void testPullConstantThroughAggregateAllConst() throws Exception {
        this.basePullConstantTroughAggregate();
    }

    @Test
    public void testPullConstantThroughAggregateAllLiterals() throws Exception {
        this.basePullConstantTroughAggregate();
    }

    @Test
    public void testPullConstantThroughUnion() throws Exception {
        HepProgram program = HepProgram.builder().addRuleInstance((RelOptRule)UnionPullUpConstantsRule.INSTANCE).addRuleInstance((RelOptRule)ProjectMergeRule.INSTANCE).build();
        String sql = "select 2, deptno, job from emp as e1\nunion all\nselect 2, deptno, job from emp as e2";
        this.sql("select 2, deptno, job from emp as e1\nunion all\nselect 2, deptno, job from emp as e2").withTrim(true).with(program).check();
    }

    @Test
    public void testPullConstantThroughUnion2() throws Exception {
        HepProgram program = HepProgram.builder().addRuleInstance((RelOptRule)UnionPullUpConstantsRule.INSTANCE).addRuleInstance((RelOptRule)ProjectMergeRule.INSTANCE).build();
        String sql = "select 2, deptno, job from emp as e1\nunion all\nselect 1, deptno, job from emp as e2";
        this.checkPlanUnchanged((RelOptPlanner)new HepPlanner(program), "select 2, deptno, job from emp as e1\nunion all\nselect 1, deptno, job from emp as e2");
    }

    @Test
    public void testPullConstantThroughUnion3() throws Exception {
        HepProgram program = HepProgram.builder().addRuleInstance((RelOptRule)UnionPullUpConstantsRule.INSTANCE).addRuleInstance((RelOptRule)ProjectMergeRule.INSTANCE).build();
        String sql = "select 2, 3 from emp as e1\nunion all\nselect 2, 3 from emp as e2";
        this.sql("select 2, 3 from emp as e1\nunion all\nselect 2, 3 from emp as e2").withTrim(true).with(program).check();
    }

    @Test
    public void testAggregateProjectMerge() throws Exception {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)AggregateProjectMergeRule.INSTANCE).build();
        this.checkPlanning(program, "select x, sum(z), y from (\n  select deptno as x, empno as y, sal as z, sal * 2 as zz\n  from emp)\ngroup by x, y");
    }

    @Test
    public void testAggregateGroupingSetsProjectMerge() throws Exception {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)AggregateProjectMergeRule.INSTANCE).build();
        this.checkPlanning(program, "select x, sum(z), y from (\n  select deptno as x, empno as y, sal as z, sal * 2 as zz\n  from emp)\ngroup by rollup(x, y)");
    }

    @Test
    public void testPullAggregateThroughUnion() throws Exception {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)AggregateUnionAggregateRule.INSTANCE).build();
        this.checkPlanning(program, "select deptno, job from (select deptno, job from emp as e1 group by deptno,job  union all select deptno, job from emp as e2 group by deptno,job) group by deptno,job");
    }

    private void transitiveInference(RelOptRule ... extraRules) throws Exception {
        DiffRepository diffRepos = this.getDiffRepos();
        String sql = diffRepos.expand(null, "${sql}");
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)FilterJoinRule.DUMB_FILTER_ON_JOIN).addRuleInstance((RelOptRule)FilterJoinRule.JOIN).addRuleInstance((RelOptRule)FilterProjectTransposeRule.INSTANCE).addRuleInstance((RelOptRule)FilterSetOpTransposeRule.INSTANCE).build();
        HepPlanner planner = new HepPlanner(program);
        RelRoot root = this.tester.convertSqlToRel(sql);
        RelNode relInitial = root.rel;
        Assert.assertTrue((relInitial != null ? 1 : 0) != 0);
        ArrayList list = Lists.newArrayList();
        list.add(DefaultRelMetadataProvider.INSTANCE);
        planner.registerMetadataProviders((List)list);
        RelMetadataProvider plannerChain = ChainedRelMetadataProvider.of((List)list);
        relInitial.getCluster().setMetadataProvider((RelMetadataProvider)new CachingRelMetadataProvider(plannerChain, (RelOptPlanner)planner));
        planner.setRoot(relInitial);
        RelNode relBefore = planner.findBestExp();
        String planBefore = NL + RelOptUtil.toString((RelNode)relBefore);
        diffRepos.assertEquals("planBefore", "${planBefore}", planBefore);
        HepProgram program2 = new HepProgramBuilder().addMatchOrder(HepMatchOrder.BOTTOM_UP).addRuleInstance((RelOptRule)FilterJoinRule.DUMB_FILTER_ON_JOIN).addRuleInstance((RelOptRule)FilterJoinRule.JOIN).addRuleInstance((RelOptRule)FilterProjectTransposeRule.INSTANCE).addRuleInstance((RelOptRule)FilterSetOpTransposeRule.INSTANCE).addRuleInstance((RelOptRule)JoinPushTransitivePredicatesRule.INSTANCE).addRuleCollection(Arrays.asList(extraRules)).build();
        HepPlanner planner2 = new HepPlanner(program2);
        planner.registerMetadataProviders((List)list);
        planner2.setRoot(relBefore);
        RelNode relAfter = planner2.findBestExp();
        String planAfter = NL + RelOptUtil.toString((RelNode)relAfter);
        diffRepos.assertEquals("planAfter", "${planAfter}", planAfter);
    }

    @Test
    public void testTransitiveInferenceJoin() throws Exception {
        this.transitiveInference(new RelOptRule[0]);
    }

    @Test
    public void testTransitiveInferenceProject() throws Exception {
        this.transitiveInference(new RelOptRule[0]);
    }

    @Test
    public void testTransitiveInferenceAggregate() throws Exception {
        this.transitiveInference(new RelOptRule[0]);
    }

    @Test
    public void testTransitiveInferenceUnion() throws Exception {
        this.transitiveInference(new RelOptRule[0]);
    }

    @Test
    public void testTransitiveInferenceJoin3way() throws Exception {
        this.transitiveInference(new RelOptRule[0]);
    }

    @Test
    public void testTransitiveInferenceJoin3wayAgg() throws Exception {
        this.transitiveInference(new RelOptRule[0]);
    }

    @Test
    public void testTransitiveInferenceLeftOuterJoin() throws Exception {
        this.transitiveInference(new RelOptRule[0]);
    }

    @Test
    public void testTransitiveInferenceRightOuterJoin() throws Exception {
        this.transitiveInference(new RelOptRule[0]);
    }

    @Test
    public void testTransitiveInferenceFullOuterJoin() throws Exception {
        this.transitiveInference(new RelOptRule[0]);
    }

    @Test
    public void testTransitiveInferencePreventProjectPullUp() throws Exception {
        this.transitiveInference(new RelOptRule[0]);
    }

    @Test
    public void testTransitiveInferencePullUpThruAlias() throws Exception {
        this.transitiveInference(new RelOptRule[0]);
    }

    @Test
    public void testTransitiveInferenceConjunctInPullUp() throws Exception {
        this.transitiveInference(new RelOptRule[0]);
    }

    @Test
    public void testTransitiveInferenceNoPullUpExprs() throws Exception {
        this.transitiveInference(new RelOptRule[0]);
    }

    @Test
    public void testTransitiveInferenceUnion3way() throws Exception {
        this.transitiveInference(new RelOptRule[0]);
    }

    @Ignore(value="not working")
    @Test
    public void testTransitiveInferenceUnion3wayOr() throws Exception {
        this.transitiveInference(new RelOptRule[0]);
    }

    @Test
    public void testTransitiveInferenceUnionAlwaysTrue() throws Exception {
        this.transitiveInference(new RelOptRule[0]);
    }

    @Test
    public void testTransitiveInferenceConstantEquiPredicate() throws Exception {
        this.transitiveInference(new RelOptRule[0]);
    }

    @Test
    public void testTransitiveInferenceComplexPredicate() throws Exception {
        this.transitiveInference(new RelOptRule[0]);
    }

    @Test
    public void testPullConstantIntoProject() throws Exception {
        this.transitiveInference(new RelOptRule[]{ReduceExpressionsRule.PROJECT_INSTANCE});
    }

    @Test
    public void testPullConstantIntoFilter() throws Exception {
        this.transitiveInference(new RelOptRule[]{ReduceExpressionsRule.FILTER_INSTANCE});
    }

    @Test
    public void testPullConstantIntoJoin() throws Exception {
        this.transitiveInference(new RelOptRule[]{ReduceExpressionsRule.JOIN_INSTANCE});
    }

    @Test
    public void testPullConstantIntoJoin2() throws Exception {
        this.transitiveInference(new RelOptRule[]{ReduceExpressionsRule.JOIN_INSTANCE, ReduceExpressionsRule.PROJECT_INSTANCE, FilterProjectTransposeRule.INSTANCE});
    }

    @Test
    public void testProjectWindowTransposeRule() {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)ProjectToWindowRule.PROJECT).addRuleInstance((RelOptRule)ProjectWindowTransposeRule.INSTANCE).build();
        String sql = "select count(empno) over(), deptno from emp";
        this.checkPlanning(program, "select count(empno) over(), deptno from emp");
    }

    @Test
    public void testProjectWindowTransposeRuleWithConstants() {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)ProjectToWindowRule.PROJECT).addRuleInstance((RelOptRule)ProjectMergeRule.INSTANCE).addRuleInstance((RelOptRule)ProjectWindowTransposeRule.INSTANCE).build();
        String sql = "select col1, col2\nfrom (\n  select empno,\n    sum(100) over (partition by  deptno order by sal) as col1,\n  sum(1000) over(partition by deptno order by sal) as col2\n  from emp)";
        this.checkPlanning(program, "select col1, col2\nfrom (\n  select empno,\n    sum(100) over (partition by  deptno order by sal) as col1,\n  sum(1000) over(partition by deptno order by sal) as col2\n  from emp)");
    }

    @Test
    public void testAggregateProjectPullUpConstants() {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)AggregateProjectPullUpConstantsRule.INSTANCE2).build();
        String sql = "select job, empno, sal, sum(sal) as s\nfrom emp where empno = 10\ngroup by job, empno, sal";
        this.checkPlanning(program, "select job, empno, sal, sum(sal) as s\nfrom emp where empno = 10\ngroup by job, empno, sal");
    }

    @Test
    public void testPushFilterWithRank() throws Exception {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)FilterProjectTransposeRule.INSTANCE).build();
        String sql = "select e1.ename, r\nfrom (\n  select ename,   rank() over(partition by  deptno order by sal) as r   from emp) e1\nwhere r < 2";
        this.checkPlanUnchanged((RelOptPlanner)new HepPlanner(program), "select e1.ename, r\nfrom (\n  select ename,   rank() over(partition by  deptno order by sal) as r   from emp) e1\nwhere r < 2");
    }

    @Test
    public void testPushFilterWithRankExpr() throws Exception {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)FilterProjectTransposeRule.INSTANCE).build();
        String sql = "select e1.ename, r\nfrom (\n  select ename,\n  rank() over(partition by  deptno order by sal) + 1 as r   from emp) e1\nwhere r < 2";
        this.checkPlanUnchanged((RelOptPlanner)new HepPlanner(program), "select e1.ename, r\nfrom (\n  select ename,\n  rank() over(partition by  deptno order by sal) + 1 as r   from emp) e1\nwhere r < 2");
    }

    @Test
    public void testExpressionInWindowFunction() {
        HepProgramBuilder builder = new HepProgramBuilder();
        builder.addRuleClass(ProjectToWindowRule.class);
        HepPlanner hepPlanner = new HepPlanner(builder.build());
        hepPlanner.addRule((RelOptRule)ProjectToWindowRule.PROJECT);
        String sql = "select\n sum(deptno) over(partition by deptno order by sal) as sum1,\nsum(deptno + sal) over(partition by deptno order by sal) as sum2\nfrom emp";
        this.sql("select\n sum(deptno) over(partition by deptno order by sal) as sum1,\nsum(deptno + sal) over(partition by deptno order by sal) as sum2\nfrom emp").with(hepPlanner).check();
    }

    @Test
    public void testWindowInParenthesis() {
        HepProgramBuilder builder = new HepProgramBuilder();
        builder.addRuleClass(ProjectToWindowRule.class);
        HepPlanner hepPlanner = new HepPlanner(builder.build());
        hepPlanner.addRule((RelOptRule)ProjectToWindowRule.PROJECT);
        String sql = "select count(*) over (w), count(*) over w\nfrom emp\nwindow w as (partition by empno order by empno)";
        this.sql("select count(*) over (w), count(*) over w\nfrom emp\nwindow w as (partition by empno order by empno)").with(hepPlanner).check();
    }

    @Test
    public void testNestedAggregates() {
        HepProgram program = HepProgram.builder().addRuleInstance((RelOptRule)ProjectToWindowRule.PROJECT).build();
        String sql = "SELECT\n  avg(sum(sal) + 2 * min(empno) + 3 * avg(empno))\n  over (partition by deptno)\nfrom emp\ngroup by deptno";
        this.checkPlanning(program, "SELECT\n  avg(sum(sal) + 2 * min(empno) + 3 * avg(empno))\n  over (partition by deptno)\nfrom emp\ngroup by deptno");
    }

    @Test
    public void testPushAggregateThroughJoin1() throws Exception {
        HepProgram preProgram = new HepProgramBuilder().addRuleInstance((RelOptRule)AggregateProjectMergeRule.INSTANCE).build();
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)AggregateJoinTransposeRule.EXTENDED).build();
        String sql = "select e.job,d.name\nfrom (select * from sales.emp where empno = 10) as e\njoin sales.dept as d on e.job = d.name\ngroup by e.job,d.name";
        this.checkPlanning(this.tester, preProgram, (RelOptPlanner)new HepPlanner(program), "select e.job,d.name\nfrom (select * from sales.emp where empno = 10) as e\njoin sales.dept as d on e.job = d.name\ngroup by e.job,d.name");
    }

    @Test
    public void testPushAggregateThroughJoin2() throws Exception {
        HepProgram preProgram = new HepProgramBuilder().addRuleInstance((RelOptRule)AggregateProjectMergeRule.INSTANCE).build();
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)AggregateJoinTransposeRule.EXTENDED).build();
        String sql = "select e.job,d.name\nfrom (select * from sales.emp where empno = 10) as e\njoin sales.dept as d on e.job = d.name\nand e.deptno + e.empno = d.deptno + 5\ngroup by e.job,d.name";
        this.checkPlanning(this.tester, preProgram, (RelOptPlanner)new HepPlanner(program), "select e.job,d.name\nfrom (select * from sales.emp where empno = 10) as e\njoin sales.dept as d on e.job = d.name\nand e.deptno + e.empno = d.deptno + 5\ngroup by e.job,d.name");
    }

    @Test
    public void testPushAggregateThroughJoin3() throws Exception {
        HepProgram preProgram = new HepProgramBuilder().addRuleInstance((RelOptRule)AggregateProjectMergeRule.INSTANCE).build();
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)AggregateJoinTransposeRule.EXTENDED).build();
        String sql = "select e.empno,d.deptno\nfrom (select * from sales.emp where empno = 10) as e\njoin sales.dept as d on e.empno < d.deptno\ngroup by e.empno,d.deptno";
        this.checkPlanning(this.tester, preProgram, (RelOptPlanner)new HepPlanner(program), "select e.empno,d.deptno\nfrom (select * from sales.emp where empno = 10) as e\njoin sales.dept as d on e.empno < d.deptno\ngroup by e.empno,d.deptno", true);
    }

    @Test
    public void testPushAggregateThroughJoin4() throws Exception {
        HepProgram preProgram = new HepProgramBuilder().addRuleInstance((RelOptRule)AggregateProjectMergeRule.INSTANCE).build();
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)AggregateJoinTransposeRule.EXTENDED).build();
        String sql = "select e.deptno\nfrom sales.emp as e join sales.dept as d on e.deptno = d.deptno\ngroup by e.deptno";
        this.sql("select e.deptno\nfrom sales.emp as e join sales.dept as d on e.deptno = d.deptno\ngroup by e.deptno").withPre(preProgram).with(program).check();
    }

    @Test
    public void testPushAggregateThroughJoin5() throws Exception {
        HepProgram preProgram = new HepProgramBuilder().addRuleInstance((RelOptRule)AggregateProjectMergeRule.INSTANCE).build();
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)AggregateJoinTransposeRule.EXTENDED).build();
        String sql = "select e.deptno, d.deptno\nfrom sales.emp as e join sales.dept as d on e.deptno = d.deptno\ngroup by e.deptno, d.deptno";
        this.sql("select e.deptno, d.deptno\nfrom sales.emp as e join sales.dept as d on e.deptno = d.deptno\ngroup by e.deptno, d.deptno").withPre(preProgram).with(program).check();
    }

    @Test
    public void testPushAggregateSumThroughJoin() throws Exception {
        HepProgram preProgram = new HepProgramBuilder().addRuleInstance((RelOptRule)AggregateProjectMergeRule.INSTANCE).build();
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)AggregateJoinTransposeRule.EXTENDED).build();
        String sql = "select e.job,sum(sal)\nfrom (select * from sales.emp where empno = 10) as e\njoin sales.dept as d on e.job = d.name\ngroup by e.job,d.name";
        this.checkPlanning(this.tester, preProgram, (RelOptPlanner)new HepPlanner(program), "select e.job,sum(sal)\nfrom (select * from sales.emp where empno = 10) as e\njoin sales.dept as d on e.job = d.name\ngroup by e.job,d.name");
    }

    @Test
    public void testPushAggregateFunctionsThroughJoin() throws Exception {
        HepProgram preProgram = new HepProgramBuilder().addRuleInstance((RelOptRule)AggregateProjectMergeRule.INSTANCE).build();
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)AggregateJoinTransposeRule.EXTENDED).build();
        String sql = "select e.job,\n  min(sal) as min_sal, min(e.deptno) as min_deptno,\n  sum(sal) + 1 as sum_sal_plus, max(sal) as max_sal,\n  sum(sal) as sum_sal_2, count(sal) as count_sal,\n  count(mgr) as count_mgr\nfrom sales.emp as e\njoin sales.dept as d on e.job = d.name\ngroup by e.job,d.name";
        this.checkPlanning(this.tester, preProgram, (RelOptPlanner)new HepPlanner(program), "select e.job,\n  min(sal) as min_sal, min(e.deptno) as min_deptno,\n  sum(sal) + 1 as sum_sal_plus, max(sal) as max_sal,\n  sum(sal) as sum_sal_2, count(sal) as count_sal,\n  count(mgr) as count_mgr\nfrom sales.emp as e\njoin sales.dept as d on e.job = d.name\ngroup by e.job,d.name");
    }

    @Test
    public void testPushAggregateThroughJoinDistinct() throws Exception {
        HepProgram preProgram = new HepProgramBuilder().addRuleInstance((RelOptRule)AggregateProjectMergeRule.INSTANCE).build();
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)AggregateJoinTransposeRule.EXTENDED).build();
        String sql = "select d.name,\n  sum(sal) as sum_sal, count(*) as c\nfrom sales.emp as e\njoin (select distinct name from sales.dept) as d\n  on e.job = d.name\ngroup by d.name";
        this.checkPlanning(this.tester, preProgram, (RelOptPlanner)new HepPlanner(program), "select d.name,\n  sum(sal) as sum_sal, count(*) as c\nfrom sales.emp as e\njoin (select distinct name from sales.dept) as d\n  on e.job = d.name\ngroup by d.name");
    }

    @Test
    public void testPushAggregateSumNoGroup() throws Exception {
        HepProgram preProgram = new HepProgramBuilder().addRuleInstance((RelOptRule)AggregateProjectMergeRule.INSTANCE).build();
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)AggregateJoinTransposeRule.EXTENDED).build();
        String sql = "select count(*) from sales.emp join sales.dept on job = name";
        this.checkPlanning(this.tester, preProgram, (RelOptPlanner)new HepPlanner(program), "select count(*) from sales.emp join sales.dept on job = name");
    }

    @Test
    public void testSwapOuterJoin() throws Exception {
        HepProgram program = new HepProgramBuilder().addMatchLimit(1).addRuleInstance((RelOptRule)JoinCommuteRule.SWAP_OUTER).build();
        this.checkPlanning(program, "select 1 from sales.dept d left outer join sales.emp e on d.deptno = e.deptno");
    }

    @Test
    public void testPushJoinCondDownToProject() {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)FilterJoinRule.FILTER_ON_JOIN).addRuleInstance((RelOptRule)JoinPushExpressionsRule.INSTANCE).build();
        this.checkPlanning(program, "select d.deptno, e.deptno from sales.dept d, sales.emp e where d.deptno + 10 = e.deptno * 2");
    }

    @Test
    public void testSortJoinTranspose1() {
        HepProgram preProgram = new HepProgramBuilder().addRuleInstance((RelOptRule)SortProjectTransposeRule.INSTANCE).build();
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)SortJoinTransposeRule.INSTANCE).build();
        String sql = "select * from sales.emp e left join (\nselect * from sales.dept d) using (deptno)\norder by sal limit 10";
        this.checkPlanning(this.tester, preProgram, (RelOptPlanner)new HepPlanner(program), "select * from sales.emp e left join (\nselect * from sales.dept d) using (deptno)\norder by sal limit 10");
    }

    @Test
    public void testSortJoinTranspose2() {
        HepProgram preProgram = new HepProgramBuilder().addRuleInstance((RelOptRule)SortProjectTransposeRule.INSTANCE).build();
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)SortJoinTransposeRule.INSTANCE).build();
        String sql = "select * from sales.emp e right join (\nselect * from sales.dept d) using (deptno)\norder by name";
        this.checkPlanning(this.tester, preProgram, (RelOptPlanner)new HepPlanner(program), "select * from sales.emp e right join (\nselect * from sales.dept d) using (deptno)\norder by name");
    }

    @Test
    public void testSortJoinTranspose3() {
        HepProgram preProgram = new HepProgramBuilder().addRuleInstance((RelOptRule)SortProjectTransposeRule.INSTANCE).build();
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)SortJoinTransposeRule.INSTANCE).build();
        String sql = "select * from sales.emp left join (\nselect * from sales.dept) using (deptno)\norder by sal, name limit 10";
        this.checkPlanning(this.tester, preProgram, (RelOptPlanner)new HepPlanner(program), "select * from sales.emp left join (\nselect * from sales.dept) using (deptno)\norder by sal, name limit 10", true);
    }

    @Test
    public void testSortJoinTranspose4() {
        SqlToRelTestBase.TesterImpl tester = new SqlToRelTestBase.TesterImpl(this.getDiffRepos(), true, true, false, false, null, null){

            @Override
            public RelOptPlanner createPlanner() {
                return new MockRelOptPlanner(){

                    public List<RelTraitDef> getRelTraitDefs() {
                        return ImmutableList.of((Object)RelCollationTraitDef.INSTANCE);
                    }

                    public RelTraitSet emptyTraitSet() {
                        return RelTraitSet.createEmpty().plus((RelTrait)RelCollationTraitDef.INSTANCE.getDefault());
                    }
                };
            }
        };
        HepProgram preProgram = new HepProgramBuilder().addRuleInstance((RelOptRule)SortProjectTransposeRule.INSTANCE).build();
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)SortJoinTransposeRule.INSTANCE).build();
        String sql = "select * from sales.emp e right join (\nselect * from sales.dept d) using (deptno)\norder by name";
        this.checkPlanning(tester, preProgram, (RelOptPlanner)new HepPlanner(program), "select * from sales.emp e right join (\nselect * from sales.dept d) using (deptno)\norder by name");
    }

    @Test
    public void testSortJoinTranspose5() {
        HepProgram preProgram = new HepProgramBuilder().addRuleInstance((RelOptRule)SortProjectTransposeRule.INSTANCE).addRuleInstance((RelOptRule)SortJoinTransposeRule.INSTANCE).addRuleInstance((RelOptRule)SortProjectTransposeRule.INSTANCE).build();
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)SortJoinTransposeRule.INSTANCE).build();
        String sql = "select * from sales.emp e right join (\nselect * from sales.dept d) using (deptno)\nlimit 10";
        this.checkPlanning(this.tester, preProgram, (RelOptPlanner)new HepPlanner(program), "select * from sales.emp e right join (\nselect * from sales.dept d) using (deptno)\nlimit 10", true);
    }

    @Test
    public void testSortJoinTranspose6() {
        HepProgram preProgram = new HepProgramBuilder().addRuleInstance((RelOptRule)SortProjectTransposeRule.INSTANCE).build();
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)SortJoinTransposeRule.INSTANCE).build();
        String sql = "select d.deptno, empno from sales.dept d\nright join sales.emp e using (deptno) limit 10 offset 2";
        this.sql("select d.deptno, empno from sales.dept d\nright join sales.emp e using (deptno) limit 10 offset 2").withPre(preProgram).with(program).check();
    }

    @Test
    public void testSortJoinTranspose7() {
        HepProgram preProgram = new HepProgramBuilder().addRuleInstance((RelOptRule)SortProjectTransposeRule.INSTANCE).build();
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)SortJoinTransposeRule.INSTANCE).build();
        String sql = "select d.deptno, empno from sales.dept d\nleft join sales.emp e using (deptno) order by d.deptno offset 1";
        this.sql("select d.deptno, empno from sales.dept d\nleft join sales.emp e using (deptno) order by d.deptno offset 1").withPre(preProgram).with(program).checkUnchanged();
    }

    @Test
    public void testSortProjectTranspose1() {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)SortProjectTransposeRule.INSTANCE).build();
        String sql = "select d.deptno from sales.dept d\norder by cast(d.deptno as integer) offset 1";
        this.sql("select d.deptno from sales.dept d\norder by cast(d.deptno as integer) offset 1").with(program).check();
    }

    @Test
    public void testSortProjectTranspose2() {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)SortProjectTransposeRule.INSTANCE).build();
        String sql = "select d.deptno from sales.dept d\norder by cast(d.deptno as double) offset 1";
        this.sql("select d.deptno from sales.dept d\norder by cast(d.deptno as double) offset 1").with(program).check();
    }

    @Test
    public void testSortProjectTranspose3() {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)SortProjectTransposeRule.INSTANCE).build();
        String sql = "select d.deptno from sales.dept d\norder by cast(d.deptno as varchar(10)) offset 1";
        this.sql("select d.deptno from sales.dept d\norder by cast(d.deptno as varchar(10)) offset 1").with(program).checkUnchanged();
    }

    @Test
    public void testAggregateConstantKeyRule() {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)AggregateProjectPullUpConstantsRule.INSTANCE2).build();
        String sql = "select count(*) as c\nfrom sales.emp\nwhere deptno = 10\ngroup by deptno, sal";
        this.checkPlanning((RelOptPlanner)new HepPlanner(program), "select count(*) as c\nfrom sales.emp\nwhere deptno = 10\ngroup by deptno, sal");
    }

    @Test
    public void testAggregateConstantKeyRule2() {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)AggregateProjectPullUpConstantsRule.INSTANCE2).build();
        String sql = "select count(*) as c\nfrom sales.emp\nwhere deptno = 10\ngroup by deptno";
        this.checkPlanUnchanged((RelOptPlanner)new HepPlanner(program), "select count(*) as c\nfrom sales.emp\nwhere deptno = 10\ngroup by deptno");
    }

    @Test
    public void testAggregateConstantKeyRule3() {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)AggregateProjectPullUpConstantsRule.INSTANCE2).build();
        String sql = "select job\nfrom sales.emp\nwhere sal is null and job = 'Clerk'\ngroup by sal, job\nhaving count(*) > 3";
        this.checkPlanning((RelOptPlanner)new HepPlanner(program), "select job\nfrom sales.emp\nwhere sal is null and job = 'Clerk'\ngroup by sal, job\nhaving count(*) > 3");
    }

    @Test
    public void testReduceExpressionsNot() {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)ReduceExpressionsRule.FILTER_INSTANCE).build();
        this.checkPlanUnchanged((RelOptPlanner)new HepPlanner(program), "select * from (values (false),(true)) as q (col1) where not(col1)");
    }

    private RelOptTestBase.Sql checkSubQuery(String sql) {
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)SubQueryRemoveRule.PROJECT).addRuleInstance((RelOptRule)SubQueryRemoveRule.FILTER).addRuleInstance((RelOptRule)SubQueryRemoveRule.JOIN).build();
        return this.sql(sql).with(new HepPlanner(program)).expand(false);
    }

    @Test
    public void testExpandProjectScalar() throws Exception {
        String sql = "select empno,\n  (select deptno from sales.emp where empno < 20) as d\nfrom sales.emp";
        this.checkSubQuery("select empno,\n  (select deptno from sales.emp where empno < 20) as d\nfrom sales.emp").check();
    }

    @Test
    public void testWhereNotInCorrelated() {
        String sql = "select sal from emp\nwhere empno NOT IN (\n  select deptno from dept\n  where emp.job = dept.name)";
        this.checkSubQuery("select sal from emp\nwhere empno NOT IN (\n  select deptno from dept\n  where emp.job = dept.name)").withLateDecorrelation(true).check();
    }

    @Test
    public void testWhereNotInCorrelated2() {
        String sql = "select * from emp e1\n  where e1.empno NOT IN\n   (select empno from (select ename, empno, sal as r from emp) e2\n    where r > 2 and e1.ename= e2.ename)";
        this.checkSubQuery("select * from emp e1\n  where e1.empno NOT IN\n   (select empno from (select ename, empno, sal as r from emp) e2\n    where r > 2 and e1.ename= e2.ename)").withLateDecorrelation(true).check();
    }

    @Test
    public void testWhereOrSubQuery() {
        String sql = "select * from emp\nwhere sal = 4\nor empno NOT IN (select deptno from dept)";
        this.checkSubQuery("select * from emp\nwhere sal = 4\nor empno NOT IN (select deptno from dept)").withLateDecorrelation(true).check();
    }

    @Test
    public void testExpandProjectIn() throws Exception {
        String sql = "select empno,\n  deptno in (select deptno from sales.emp where empno < 20) as d\nfrom sales.emp";
        this.checkSubQuery("select empno,\n  deptno in (select deptno from sales.emp where empno < 20) as d\nfrom sales.emp").withProperty(Hook.REL_BUILDER_SIMPLIFY, false).check();
    }

    @Test
    public void testExpandProjectInNullable() throws Exception {
        String sql = "with e2 as (\n  select empno, case when true then deptno else null end as deptno\n  from sales.emp)\nselect empno,\n  deptno in (select deptno from e2 where empno < 20) as d\nfrom e2";
        this.checkSubQuery("with e2 as (\n  select empno, case when true then deptno else null end as deptno\n  from sales.emp)\nselect empno,\n  deptno in (select deptno from e2 where empno < 20) as d\nfrom e2").withProperty(Hook.REL_BUILDER_SIMPLIFY, false).check();
    }

    @Test
    public void testExpandProjectInComposite() throws Exception {
        String sql = "select empno, (empno, deptno) in (\n    select empno, deptno from sales.emp where empno < 20) as d\nfrom sales.emp";
        this.checkSubQuery("select empno, (empno, deptno) in (\n    select empno, deptno from sales.emp where empno < 20) as d\nfrom sales.emp").withProperty(Hook.REL_BUILDER_SIMPLIFY, false).check();
    }

    @Test
    public void testExpandProjectExists() throws Exception {
        String sql = "select empno,\n  exists (select deptno from sales.emp where empno < 20) as d\nfrom sales.emp";
        this.checkSubQuery("select empno,\n  exists (select deptno from sales.emp where empno < 20) as d\nfrom sales.emp").withProperty(Hook.REL_BUILDER_SIMPLIFY, false).check();
    }

    @Test
    public void testExpandFilterScalar() throws Exception {
        String sql = "select empno\nfrom sales.emp\nwhere (select deptno from sales.emp where empno < 20)\n < (select deptno from sales.emp where empno > 100)\nor emp.sal < 100";
        this.checkSubQuery("select empno\nfrom sales.emp\nwhere (select deptno from sales.emp where empno < 20)\n < (select deptno from sales.emp where empno > 100)\nor emp.sal < 100").check();
    }

    @Test
    public void testExpandFilterIn() throws Exception {
        String sql = "select empno\nfrom sales.emp\nwhere deptno in (select deptno from sales.emp where empno < 20)\nor emp.sal < 100";
        this.checkSubQuery("select empno\nfrom sales.emp\nwhere deptno in (select deptno from sales.emp where empno < 20)\nor emp.sal < 100").check();
    }

    @Test
    public void testExpandFilterInComposite() throws Exception {
        String sql = "select empno\nfrom sales.emp\nwhere (empno, deptno) in (\n  select empno, deptno from sales.emp where empno < 20)\nor emp.sal < 100";
        this.checkSubQuery("select empno\nfrom sales.emp\nwhere (empno, deptno) in (\n  select empno, deptno from sales.emp where empno < 20)\nor emp.sal < 100").check();
    }

    @Test
    public void testExpandFilterIn3Value() throws Exception {
        String sql = "select empno\nfrom sales.emp\nwhere empno\n < case deptno in (select case when true then deptno else null end\n                   from sales.emp where empno < 20)\n   when true then 10\n   when false then 20\n   else 30\n   end";
        this.checkSubQuery("select empno\nfrom sales.emp\nwhere empno\n < case deptno in (select case when true then deptno else null end\n                   from sales.emp where empno < 20)\n   when true then 10\n   when false then 20\n   else 30\n   end").withProperty(Hook.REL_BUILDER_SIMPLIFY, false).check();
    }

    @Test
    public void testExpandFilterExists() throws Exception {
        String sql = "select empno\nfrom sales.emp\nwhere exists (select deptno from sales.emp where empno < 20)\nor emp.sal < 100";
        this.checkSubQuery("select empno\nfrom sales.emp\nwhere exists (select deptno from sales.emp where empno < 20)\nor emp.sal < 100").check();
    }

    @Test
    public void testExpandFilterExistsSimple() throws Exception {
        String sql = "select empno\nfrom sales.emp\nwhere exists (select deptno from sales.emp where empno < 20)";
        this.checkSubQuery("select empno\nfrom sales.emp\nwhere exists (select deptno from sales.emp where empno < 20)").check();
    }

    @Test
    public void testExpandFilterExistsSimpleAnd() throws Exception {
        String sql = "select empno\nfrom sales.emp\nwhere exists (select deptno from sales.emp where empno < 20)\nand emp.sal < 100";
        this.checkSubQuery("select empno\nfrom sales.emp\nwhere exists (select deptno from sales.emp where empno < 20)\nand emp.sal < 100").check();
    }

    @Test
    public void testExpandJoinScalar() throws Exception {
        String sql = "select empno\nfrom sales.emp left join sales.dept\non (select deptno from sales.emp where empno < 20)\n < (select deptno from sales.emp where empno > 100)";
        this.checkSubQuery("select empno\nfrom sales.emp left join sales.dept\non (select deptno from sales.emp where empno < 20)\n < (select deptno from sales.emp where empno > 100)").check();
    }

    @Ignore(value="[CALCITE-1045]")
    @Test
    public void testExpandJoinIn() throws Exception {
        String sql = "select empno\nfrom sales.emp left join sales.dept\non emp.deptno in (select deptno from sales.emp where empno < 20)";
        this.checkSubQuery("select empno\nfrom sales.emp left join sales.dept\non emp.deptno in (select deptno from sales.emp where empno < 20)").check();
    }

    @Ignore(value="[CALCITE-1045]")
    @Test
    public void testExpandJoinInComposite() throws Exception {
        String sql = "select empno\nfrom sales.emp left join sales.dept\non (emp.empno, dept.deptno) in (\n  select empno, deptno from sales.emp where empno < 20)";
        this.checkSubQuery("select empno\nfrom sales.emp left join sales.dept\non (emp.empno, dept.deptno) in (\n  select empno, deptno from sales.emp where empno < 20)").check();
    }

    @Test
    public void testExpandJoinExists() throws Exception {
        String sql = "select empno\nfrom sales.emp left join sales.dept\non exists (select deptno from sales.emp where empno < 20)";
        this.checkSubQuery("select empno\nfrom sales.emp left join sales.dept\non exists (select deptno from sales.emp where empno < 20)").check();
    }

    @Test
    public void testDecorrelateExists() throws Exception {
        String sql = "select * from sales.emp\nwhere EXISTS (\n  select * from emp e where emp.deptno = e.deptno)";
        this.checkSubQuery("select * from sales.emp\nwhere EXISTS (\n  select * from emp e where emp.deptno = e.deptno)").withLateDecorrelation(true).check();
    }

    @Test
    public void testDecorrelateTwoExists() throws Exception {
        String sql = "select * from sales.emp\nwhere EXISTS (\n  select * from emp e where emp.deptno = e.deptno)\nAND NOT EXISTS (\n  select * from emp ee where ee.job = emp.job AND ee.sal=34)";
        this.checkSubQuery("select * from sales.emp\nwhere EXISTS (\n  select * from emp e where emp.deptno = e.deptno)\nAND NOT EXISTS (\n  select * from emp ee where ee.job = emp.job AND ee.sal=34)").withLateDecorrelation(true).check();
    }

    @Test
    public void testDecorrelateTwoIn() throws Exception {
        String sql = "select sal\nfrom sales.emp\nwhere empno IN (\n  select deptno from dept where emp.job = dept.name)\nAND empno IN (\n  select empno from emp e where emp.ename = e.ename)";
        this.checkSubQuery("select sal\nfrom sales.emp\nwhere empno IN (\n  select deptno from dept where emp.job = dept.name)\nAND empno IN (\n  select empno from emp e where emp.ename = e.ename)").withLateDecorrelation(true).check();
    }

    @Ignore(value="[CALCITE-1045]")
    @Test
    public void testDecorrelateTwoScalar() throws Exception {
        String sql = "select deptno,\n  (select min(1) from emp where empno > d.deptno) as i0,\n  (select min(0) from emp\n    where deptno = d.deptno and ename = 'SMITH') as i1\nfrom dept as d";
        this.checkSubQuery("select deptno,\n  (select min(1) from emp where empno > d.deptno) as i0,\n  (select min(0) from emp\n    where deptno = d.deptno and ename = 'SMITH') as i1\nfrom dept as d").withLateDecorrelation(true).check();
    }

    @Test
    public void testWhereInJoinCorrelated() {
        String sql = "select empno from emp as e\njoin dept as d using (deptno)\nwhere e.sal in (\n  select e2.sal from emp as e2 where e2.deptno > e.deptno)";
        this.checkSubQuery("select empno from emp as e\njoin dept as d using (deptno)\nwhere e.sal in (\n  select e2.sal from emp as e2 where e2.deptno > e.deptno)").check();
    }

    @Test
    public void testWhereInCorrelated() {
        String sql = "select sal from emp where empno IN (\n  select deptno from dept where emp.job = dept.name)";
        this.checkSubQuery("select sal from emp where empno IN (\n  select deptno from dept where emp.job = dept.name)").withLateDecorrelation(true).check();
    }

    @Test
    public void testWhereExpressionInCorrelated() {
        String sql = "select ename from (\n  select ename, deptno, sal + 1 as salPlus from emp) as e\nwhere deptno in (\n  select deptno from emp where sal + 1 = e.salPlus)";
        this.checkSubQuery("select ename from (\n  select ename, deptno, sal + 1 as salPlus from emp) as e\nwhere deptno in (\n  select deptno from emp where sal + 1 = e.salPlus)").withLateDecorrelation(true).check();
    }

    @Test
    public void testWhereExpressionInCorrelated2() {
        String sql = "select name from (\n  select name, deptno, deptno - 10 as deptnoMinus from dept) as d\nwhere deptno in (\n  select deptno from emp where sal + 1 = d.deptnoMinus)";
        this.checkSubQuery("select name from (\n  select name, deptno, deptno - 10 as deptnoMinus from dept) as d\nwhere deptno in (\n  select deptno from emp where sal + 1 = d.deptnoMinus)").withLateDecorrelation(true).check();
    }

    @Test
    public void testExpandWhereComparisonCorrelated() throws Exception {
        String sql = "select empno\nfrom sales.emp as e\nwhere sal = (\n  select max(sal) from sales.emp e2 where e2.empno = e.empno)";
        this.checkSubQuery("select empno\nfrom sales.emp as e\nwhere sal = (\n  select max(sal) from sales.emp e2 where e2.empno = e.empno)").check();
    }

    @Test
    public void testCustomColumnResolvingInNonCorrelatedSubQuery() {
        String sql = "select *\nfrom struct.t t1\nwhere c0 in (\n  select f1.c0 from struct.t t2)";
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)SubQueryRemoveRule.PROJECT).addRuleInstance((RelOptRule)SubQueryRemoveRule.FILTER).addRuleInstance((RelOptRule)SubQueryRemoveRule.JOIN).build();
        this.sql("select *\nfrom struct.t t1\nwhere c0 in (\n  select f1.c0 from struct.t t2)").withTrim(true).expand(false).with(program).check();
    }

    @Test
    public void testCustomColumnResolvingInCorrelatedSubQuery() {
        String sql = "select *\nfrom struct.t t1\nwhere c0 = (\n  select max(f1.c0) from struct.t t2 where t1.k0 = t2.k0)";
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)SubQueryRemoveRule.PROJECT).addRuleInstance((RelOptRule)SubQueryRemoveRule.FILTER).addRuleInstance((RelOptRule)SubQueryRemoveRule.JOIN).build();
        this.sql("select *\nfrom struct.t t1\nwhere c0 = (\n  select max(f1.c0) from struct.t t2 where t1.k0 = t2.k0)").withTrim(true).expand(false).with(program).check();
    }

    @Test
    public void testCustomColumnResolvingInCorrelatedSubQuery2() {
        String sql = "select *\nfrom struct.t t1\nwhere c0 in (\n  select f1.c0 from struct.t t2 where t1.c2 = t2.c2)";
        HepProgram program = new HepProgramBuilder().addRuleInstance((RelOptRule)SubQueryRemoveRule.PROJECT).addRuleInstance((RelOptRule)SubQueryRemoveRule.FILTER).addRuleInstance((RelOptRule)SubQueryRemoveRule.JOIN).build();
        this.sql("select *\nfrom struct.t t1\nwhere c0 in (\n  select f1.c0 from struct.t t2 where t1.c2 = t2.c2)").withTrim(true).expand(false).with(program).check();
    }

    @Test
    public void testExtractYearToRange() throws Exception {
        String sql = "select *\nfrom sales.emp_b as e\nwhere extract(year from birthdate) = 2014";
        HepProgram program = new HepProgramBuilder().addRuleInstance(DateRangeRules.FILTER_INSTANCE).build();
        this.sql("select *\nfrom sales.emp_b as e\nwhere extract(year from birthdate) = 2014").with(program).check();
    }

    @Test
    public void testExtractYearMonthToRange() throws Exception {
        String sql = "select *\nfrom sales.emp_b as e\nwhere extract(year from birthdate) = 2014and extract(month from birthdate) = 4";
        HepProgram program = new HepProgramBuilder().addRuleInstance(DateRangeRules.FILTER_INSTANCE).build();
        this.sql("select *\nfrom sales.emp_b as e\nwhere extract(year from birthdate) = 2014and extract(month from birthdate) = 4").with(program).check();
    }
}

