/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.hep.HepPlanner;
import org.apache.calcite.plan.hep.HepProgram;
import org.apache.calcite.plan.hep.HepProgramBuilder;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.metadata.ChainedRelMetadataProvider;
import org.apache.calcite.rel.metadata.DefaultRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.runtime.FlatLists;
import org.apache.calcite.runtime.Hook;
import org.apache.calcite.sql2rel.RelDecorrelator;
import org.apache.calcite.test.DiffRepository;
import org.apache.calcite.test.SqlToRelTestBase;
import org.apache.calcite.util.Closer;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

abstract class RelOptTestBase
extends SqlToRelTestBase {
    RelOptTestBase() {
    }

    @Override
    protected SqlToRelTestBase.Tester createTester() {
        return super.createTester().withDecorrelation(false);
    }

    protected void checkPlanning(RelOptRule rule, String sql) {
        HepProgramBuilder programBuilder = HepProgram.builder();
        programBuilder.addRuleInstance(rule);
        this.checkPlanning(programBuilder.build(), sql);
    }

    protected void checkPlanning(HepProgram program, String sql) {
        this.checkPlanning((RelOptPlanner)new HepPlanner(program), sql);
    }

    protected void checkPlanning(RelOptPlanner planner, String sql) {
        this.checkPlanning(this.tester, null, planner, sql);
    }

    protected void checkPlanUnchanged(RelOptPlanner planner, String sql) {
        this.checkPlanning(this.tester, null, planner, sql, true);
    }

    protected void checkPlanning(SqlToRelTestBase.Tester tester, HepProgram preProgram, RelOptPlanner planner, String sql) {
        this.checkPlanning(tester, preProgram, planner, sql, false);
    }

    protected void checkPlanning(SqlToRelTestBase.Tester tester, HepProgram preProgram, RelOptPlanner planner, String sql, boolean unchanged) {
        RelNode relBefore;
        DiffRepository diffRepos = this.getDiffRepos();
        String sql2 = diffRepos.expand("sql", sql);
        RelRoot root = tester.convertSqlToRel(sql2);
        RelNode relInitial = root.rel;
        Assert.assertTrue((relInitial != null ? 1 : 0) != 0);
        ArrayList list = Lists.newArrayList();
        list.add(DefaultRelMetadataProvider.INSTANCE);
        planner.registerMetadataProviders((List)list);
        RelMetadataProvider plannerChain = ChainedRelMetadataProvider.of((List)list);
        relInitial.getCluster().setMetadataProvider(plannerChain);
        if (preProgram == null) {
            relBefore = relInitial;
        } else {
            HepPlanner prePlanner = new HepPlanner(preProgram);
            prePlanner.setRoot(relInitial);
            relBefore = prePlanner.findBestExp();
        }
        Assert.assertThat((Object)relBefore, (Matcher)CoreMatchers.notNullValue());
        String planBefore = NL + RelOptUtil.toString((RelNode)relBefore);
        diffRepos.assertEquals("planBefore", "${planBefore}", planBefore);
        SqlToRelTestBase.assertValid(relBefore);
        planner.setRoot(relBefore);
        RelNode r = planner.findBestExp();
        if (tester.isLateDecorrelate()) {
            String planMid = NL + RelOptUtil.toString((RelNode)r);
            diffRepos.assertEquals("planMid", "${planMid}", planMid);
            SqlToRelTestBase.assertValid(r);
            r = RelDecorrelator.decorrelateQuery((RelNode)r);
        }
        String planAfter = NL + RelOptUtil.toString((RelNode)r);
        if (unchanged) {
            Assert.assertThat((Object)planAfter, (Matcher)CoreMatchers.is((Object)planBefore));
        } else {
            diffRepos.assertEquals("planAfter", "${planAfter}", planAfter);
            if (planBefore.equals(planAfter)) {
                throw new AssertionError((Object)"Expected plan before and after is the same.\nYou must use unchanged=true or call checkPlanUnchanged");
            }
        }
        SqlToRelTestBase.assertValid(r);
    }

    Sql sql(String sql) {
        return new Sql(sql, null, null, (ImmutableMap<Hook, Function>)ImmutableMap.of(), (ImmutableList<Function<SqlToRelTestBase.Tester, SqlToRelTestBase.Tester>>)ImmutableList.of());
    }

    class Sql {
        private final String sql;
        private HepProgram preProgram;
        private final HepPlanner hepPlanner;
        private final ImmutableMap<Hook, Function> hooks;
        private ImmutableList<Function<SqlToRelTestBase.Tester, SqlToRelTestBase.Tester>> transforms;

        Sql(String sql, HepProgram preProgram, HepPlanner hepPlanner, ImmutableMap<Hook, Function> hooks, ImmutableList<Function<SqlToRelTestBase.Tester, SqlToRelTestBase.Tester>> transforms) {
            this.sql = sql;
            this.preProgram = preProgram;
            this.hepPlanner = hepPlanner;
            this.hooks = hooks;
            this.transforms = transforms;
        }

        public Sql withPre(HepProgram preProgram) {
            return new Sql(this.sql, preProgram, this.hepPlanner, this.hooks, this.transforms);
        }

        public Sql with(HepPlanner hepPlanner) {
            return new Sql(this.sql, this.preProgram, hepPlanner, this.hooks, this.transforms);
        }

        public Sql with(HepProgram program) {
            return new Sql(this.sql, this.preProgram, new HepPlanner(program), this.hooks, this.transforms);
        }

        public Sql withRule(RelOptRule rule) {
            return this.with(HepProgram.builder().addRuleInstance(rule).build());
        }

        private Sql withTransform(Function<SqlToRelTestBase.Tester, SqlToRelTestBase.Tester> transform) {
            return new Sql(this.sql, this.preProgram, this.hepPlanner, this.hooks, (ImmutableList<Function<SqlToRelTestBase.Tester, SqlToRelTestBase.Tester>>)FlatLists.append(this.transforms, transform));
        }

        public <T> Sql withHook(Hook hook, Function<T, Void> handler) {
            return new Sql(this.sql, this.preProgram, this.hepPlanner, (ImmutableMap<Hook, Function>)FlatLists.append(this.hooks, (Object)hook, handler), this.transforms);
        }

        public <V> Sql withProperty(Hook hook, V value) {
            return this.withHook(hook, Hook.property(value));
        }

        public Sql expand(final boolean b) {
            return this.withTransform(new Function<SqlToRelTestBase.Tester, SqlToRelTestBase.Tester>(){

                public SqlToRelTestBase.Tester apply(SqlToRelTestBase.Tester tester) {
                    return tester.withExpand(b);
                }
            });
        }

        public Sql withLateDecorrelation(final boolean b) {
            return this.withTransform(new Function<SqlToRelTestBase.Tester, SqlToRelTestBase.Tester>(){

                public SqlToRelTestBase.Tester apply(SqlToRelTestBase.Tester tester) {
                    return tester.withLateDecorrelation(b);
                }
            });
        }

        public Sql withDecorrelation(final boolean b) {
            return this.withTransform(new Function<SqlToRelTestBase.Tester, SqlToRelTestBase.Tester>(){

                public SqlToRelTestBase.Tester apply(SqlToRelTestBase.Tester tester) {
                    return tester.withDecorrelation(b);
                }
            });
        }

        public Sql withTrim(final boolean b) {
            return this.withTransform(new Function<SqlToRelTestBase.Tester, SqlToRelTestBase.Tester>(){

                public SqlToRelTestBase.Tester apply(SqlToRelTestBase.Tester tester) {
                    return tester.withTrim(b);
                }
            });
        }

        public void check() {
            this.check(false);
        }

        public void checkUnchanged() {
            this.check(true);
        }

        private void check(boolean unchanged) {
            try (Closer closer = new Closer();){
                for (Map.Entry entry : this.hooks.entrySet()) {
                    closer.add((AutoCloseable)((Hook)entry.getKey()).addThread((Function)entry.getValue()));
                }
                SqlToRelTestBase.Tester t = RelOptTestBase.this.tester;
                for (Function transform : this.transforms) {
                    t = (SqlToRelTestBase.Tester)transform.apply((Object)t);
                }
                RelOptTestBase.this.checkPlanning(t, this.preProgram, (RelOptPlanner)this.hepPlanner, this.sql, unchanged);
            }
        }
    }
}

