/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test;

import com.google.common.base.Function;
import java.io.IOException;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttle;
import org.apache.calcite.rel.RelShuttleImpl;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.externalize.RelJsonReader;
import org.apache.calcite.rel.externalize.RelJsonWriter;
import org.apache.calcite.runtime.Hook;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.test.SqlToRelConverterTest;
import org.apache.calcite.tools.Frameworks;
import org.junit.After;
import org.junit.Before;

public class SqlToRelConverterExtendedTest
extends SqlToRelConverterTest {
    Hook.Closeable closeable;

    @Before
    public void before() {
        this.closeable = Hook.CONVERTED.addThread((Function)new Function<RelNode, Void>(){

            public Void apply(RelNode a0) {
                SqlToRelConverterExtendedTest.foo(a0);
                return null;
            }
        });
    }

    @After
    public void after() {
        if (this.closeable != null) {
            this.closeable.close();
            this.closeable = null;
        }
    }

    public static void foo(RelNode rel) {
        RelJsonWriter writer = new RelJsonWriter();
        rel.explain((RelWriter)writer);
        final String json = writer.asString();
        final RelOptSchema[] schemas = new RelOptSchema[]{null};
        rel.accept((RelShuttle)new RelShuttleImpl(){

            public RelNode visit(TableScan scan) {
                schemas[0] = scan.getTable().getRelOptSchema();
                return super.visit(scan);
            }
        });
        Frameworks.withPlanner((Frameworks.PlannerAction)new Frameworks.PlannerAction<Object>(){

            public Object apply(RelOptCluster cluster, RelOptSchema relOptSchema, SchemaPlus rootSchema) {
                RelJsonReader reader = new RelJsonReader(cluster, schemas[0], (Schema)rootSchema);
                try {
                    RelNode relNode = reader.read(json);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return null;
            }
        });
    }
}

