/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.apache.calcite.avatica.util.Casing;
import org.apache.calcite.avatica.util.Quoting;
import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.config.Lex;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.sql.SqlCollation;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.fun.OracleSqlOperatorTable;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.test.SqlTester;
import org.apache.calcite.sql.type.ArraySqlType;
import org.apache.calcite.sql.type.SqlTypeFactoryImpl;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql.util.ChainedSqlOperatorTable;
import org.apache.calcite.sql.validate.SqlAbstractConformance;
import org.apache.calcite.sql.validate.SqlConformance;
import org.apache.calcite.sql.validate.SqlConformanceEnum;
import org.apache.calcite.sql.validate.SqlDelegatingConformance;
import org.apache.calcite.sql.validate.SqlMonotonicity;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.test.MockCatalogReader;
import org.apache.calcite.test.SqlValidatorTestCase;
import org.apache.calcite.util.ImmutableBitSet;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlValidatorTest
extends SqlValidatorTestCase {
    protected static final boolean TODO = false;
    private static final String ANY = "(?s).*";
    protected static final Logger LOGGER = LoggerFactory.getLogger(SqlValidatorTest.class);
    private static final String ERR_IN_VALUES_INCOMPATIBLE = "Values in expression list must have compatible types";
    private static final String ERR_IN_OPERANDS_INCOMPATIBLE = "Values passed to IN operator must have compatible types";
    private static final String ERR_AGG_IN_GROUP_BY = "Aggregate expression is illegal in GROUP BY clause";
    private static final String ERR_AGG_IN_ORDER_BY = "Aggregate expression is illegal in ORDER BY clause of non-aggregating SELECT";
    private static final String ERR_NESTED_AGG = "Aggregate expressions cannot be nested";
    private static final String EMP_RECORD_TYPE = "RecordType(INTEGER NOT NULL EMPNO, VARCHAR(20) NOT NULL ENAME, VARCHAR(10) NOT NULL JOB, INTEGER MGR, TIMESTAMP(0) NOT NULL HIREDATE, INTEGER NOT NULL SAL, INTEGER NOT NULL COMM, INTEGER NOT NULL DEPTNO, BOOLEAN NOT NULL SLACKER) NOT NULL";
    private static final String STR_AGG_REQUIRES_MONO = "Streaming aggregation requires at least one monotonic expression in GROUP BY clause";
    private static final String STR_ORDER_REQUIRES_MONO = "Streaming ORDER BY must start with monotonic expression";
    private static final String STR_SET_OP_INCONSISTENT = "Set operator cannot combine streaming and non-streaming inputs";
    private static final String ROW_RANGE_NOT_ALLOWED_WITH_RANK = "ROW/RANGE not allowed with RANK, DENSE_RANK or ROW_NUMBER functions";

    @BeforeClass
    public static void setUSLocale() {
        Locale.setDefault(Locale.US);
    }

    private static String cannotConvertToStream(String name) {
        return "Cannot convert table '" + name + "' to stream";
    }

    private static String cannotConvertToRelation(String table) {
        return "Cannot convert stream '" + table + "' to relation";
    }

    private static String cannotStreamResultsForNonStreamingInputs(String inputs) {
        return "Cannot stream results of a query with no streaming inputs: '" + inputs + "'. At least one input should be convertible to a stream";
    }

    @Test
    public void testMultipleSameAsPass() {
        this.check("select 1 as again,2 as \"again\", 3 as AGAiN from (values (true))");
    }

    @Test
    public void testMultipleDifferentAs() {
        this.check("select 1 as c1,2 as c2 from (values(true))");
    }

    @Test
    public void testTypeOfAs() {
        this.checkColumnType("select 1 as c1 from (values (true))", "INTEGER NOT NULL");
        this.checkColumnType("select 'hej' as c1 from (values (true))", "CHAR(3) NOT NULL");
        this.checkColumnType("select x'deadbeef' as c1 from (values (true))", "BINARY(4) NOT NULL");
        this.checkColumnType("select cast(null as boolean) as c1 from (values (true))", "BOOLEAN");
    }

    @Test
    public void testTypesLiterals() {
        this.checkExpType("'abc'", "CHAR(3) NOT NULL");
        this.checkExpType("n'abc'", "CHAR(3) NOT NULL");
        this.checkExpType("_UTF16'abc'", "CHAR(3) NOT NULL");
        this.checkExpType("'ab '\n' cd'", "CHAR(6) NOT NULL");
        this.checkExpType("'ab'\n'cd'\n'ef'\n'gh'\n'ij'\n'kl'", "CHAR(12) NOT NULL");
        this.checkExpType("n'ab '\n' cd'", "CHAR(6) NOT NULL");
        this.checkExpType("_UTF16'ab '\n' cd'", "CHAR(6) NOT NULL");
        this.checkExpFails("^x'abc'^", "Binary literal string must contain an even number of hexits");
        this.checkExpType("x'abcd'", "BINARY(2) NOT NULL");
        this.checkExpType("x'abcd'\n'ff001122aabb'", "BINARY(8) NOT NULL");
        this.checkExpType("x'aaaa'\n'bbbb'\n'0000'\n'1111'", "BINARY(8) NOT NULL");
        this.checkExpType("1234567890", "INTEGER NOT NULL");
        this.checkExpType("123456.7890", "DECIMAL(10, 4) NOT NULL");
        this.checkExpType("123456.7890e3", "DOUBLE NOT NULL");
        this.checkExpType("true", "BOOLEAN NOT NULL");
        this.checkExpType("false", "BOOLEAN NOT NULL");
        this.checkExpType("unknown", "BOOLEAN");
    }

    @Test
    public void testBooleans() {
        this.check("select TRUE OR unknowN from (values(true))");
        this.check("select false AND unknown from (values(true))");
        this.check("select not UNKNOWn from (values(true))");
        this.check("select not true from (values(true))");
        this.check("select not false from (values(true))");
    }

    @Test
    public void testAndOrIllegalTypesFails() {
        this.checkWholeExpFails("'abc' AND FaLsE", "(?s).*'<CHAR.3.> AND <BOOLEAN>'.*");
        this.checkWholeExpFails("TRUE OR 1", ANY);
        this.checkWholeExpFails("unknown OR 1.0", ANY);
        this.checkWholeExpFails("true OR 1.0e4", ANY);
    }

    @Test
    public void testNotIllegalTypeFails() {
        this.assertExceptionIsThrown("select ^NOT 3.141^ from (values(true))", "(?s).*Cannot apply 'NOT' to arguments of type 'NOT<DECIMAL.4, 3.>'.*");
        this.assertExceptionIsThrown("select ^NOT 'abc'^ from (values(true))", ANY);
        this.assertExceptionIsThrown("select ^NOT 1^ from (values(true))", ANY);
    }

    @Test
    public void testIs() {
        this.check("select TRUE IS FALSE FROM (values(true))");
        this.check("select false IS NULL FROM (values(true))");
        this.check("select UNKNOWN IS NULL FROM (values(true))");
        this.check("select FALSE IS UNKNOWN FROM (values(true))");
        this.check("select TRUE IS NOT FALSE FROM (values(true))");
        this.check("select TRUE IS NOT NULL FROM (values(true))");
        this.check("select false IS NOT NULL FROM (values(true))");
        this.check("select UNKNOWN IS NOT NULL FROM (values(true))");
        this.check("select FALSE IS NOT UNKNOWN FROM (values(true))");
        this.check("select 1 IS NULL FROM (values(true))");
        this.check("select 1.2 IS NULL FROM (values(true))");
        this.checkExpFails("^'abc' IS NOT UNKNOWN^", "(?s).*Cannot apply.*");
    }

    @Test
    public void testIsFails() {
        this.assertExceptionIsThrown("select ^1 IS TRUE^ FROM (values(true))", "(?s).*'<INTEGER> IS TRUE'.*");
        this.assertExceptionIsThrown("select ^1.1 IS NOT FALSE^ FROM (values(true))", ANY);
        this.assertExceptionIsThrown("select ^1.1e1 IS NOT FALSE^ FROM (values(true))", "(?s).*Cannot apply 'IS NOT FALSE' to arguments of type '<DOUBLE> IS NOT FALSE'.*");
        this.assertExceptionIsThrown("select ^'abc' IS NOT TRUE^ FROM (values(true))", ANY);
    }

    @Test
    public void testScalars() {
        this.check("select 1  + 1 from (values(true))");
        this.check("select 1  + 2.3 from (values(true))");
        this.check("select 1.2+3 from (values(true))");
        this.check("select 1.2+3.4 from (values(true))");
        this.check("select 1  - 1 from (values(true))");
        this.check("select 1  - 2.3 from (values(true))");
        this.check("select 1.2-3 from (values(true))");
        this.check("select 1.2-3.4 from (values(true))");
        this.check("select 1  * 2 from (values(true))");
        this.check("select 1.2* 3 from (values(true))");
        this.check("select 1  * 2.3 from (values(true))");
        this.check("select 1.2* 3.4 from (values(true))");
        this.check("select 1  / 2 from (values(true))");
        this.check("select 1  / 2.3 from (values(true))");
        this.check("select 1.2/ 3 from (values(true))");
        this.check("select 1.2/3.4 from (values(true))");
    }

    @Test
    public void testScalarsFails() {
        this.assertExceptionIsThrown("select ^1+TRUE^ from (values(true))", "(?s).*Cannot apply '\\+' to arguments of type '<INTEGER> \\+ <BOOLEAN>'\\. Supported form\\(s\\):.*");
    }

    @Test
    public void testNumbers() {
        this.check("select 1+-2.*-3.e-1/-4>+5 AND true from (values(true))");
    }

    @Test
    public void testPrefix() {
        this.checkExpType("+interval '1' second", "INTERVAL SECOND NOT NULL");
        this.checkExpType("-interval '1' month", "INTERVAL MONTH NOT NULL");
        this.checkFails("SELECT ^-'abc'^ from (values(true))", "(?s).*Cannot apply '-' to arguments of type '-<CHAR.3.>'.*");
        this.checkFails("SELECT ^+'abc'^ from (values(true))", "(?s).*Cannot apply '\\+' to arguments of type '\\+<CHAR.3.>'.*");
    }

    @Test
    public void testEqualNotEqual() {
        this.checkExp("''=''");
        this.checkExp("'abc'=n''");
        this.checkExp("''=_latin1''");
        this.checkExp("n''=''");
        this.checkExp("n'abc'=n''");
        this.checkExp("n''=_latin1''");
        this.checkExp("_latin1''=''");
        this.checkExp("_latin1''=n''");
        this.checkExp("_latin1''=_latin1''");
        this.checkExp("''<>''");
        this.checkExp("'abc'<>n''");
        this.checkExp("''<>_latin1''");
        this.checkExp("n''<>''");
        this.checkExp("n'abc'<>n''");
        this.checkExp("n''<>_latin1''");
        this.checkExp("_latin1''<>''");
        this.checkExp("_latin1'abc'<>n''");
        this.checkExp("_latin1''<>_latin1''");
        this.checkExp("true=false");
        this.checkExp("unknown<>true");
        this.checkExp("1=1");
        this.checkExp("1=.1");
        this.checkExp("1=1e-1");
        this.checkExp("0.1=1");
        this.checkExp("0.1=0.1");
        this.checkExp("0.1=1e1");
        this.checkExp("1.1e1=1");
        this.checkExp("1.1e1=1.1");
        this.checkExp("1.1e-1=1e1");
        this.checkExp("''<>''");
        this.checkExp("1<>1");
        this.checkExp("1<>.1");
        this.checkExp("1<>1e-1");
        this.checkExp("0.1<>1");
        this.checkExp("0.1<>0.1");
        this.checkExp("0.1<>1e1");
        this.checkExp("1.1e1<>1");
        this.checkExp("1.1e1<>1.1");
        this.checkExp("1.1e-1<>1e1");
    }

    @Test
    public void testEqualNotEqualFails() {
        this.checkExp("''<>1");
        this.checkExp("'1'>=1");
        this.checkExp("1<>n'abc'");
        this.checkExp("''=.1");
        this.checkExpFails("^true<>1e-1^", "(?s).*Cannot apply '<>' to arguments of type '<BOOLEAN> <> <DOUBLE>'.*");
        this.checkExp("false=''");
        this.checkExpFails("^x'a4'=0.01^", "(?s).*Cannot apply '=' to arguments of type '<BINARY.1.> = <DECIMAL.3, 2.>'.*");
        this.checkExpFails("^x'a4'=1^", "(?s).*Cannot apply '=' to arguments of type '<BINARY.1.> = <INTEGER>'.*");
        this.checkExpFails("^x'13'<>0.01^", "(?s).*Cannot apply '<>' to arguments of type '<BINARY.1.> <> <DECIMAL.3, 2.>'.*");
        this.checkExpFails("^x'abcd'<>1^", "(?s).*Cannot apply '<>' to arguments of type '<BINARY.2.> <> <INTEGER>'.*");
    }

    @Test
    public void testBinaryString() {
        this.check("select x'face'=X'' from (values(true))");
        this.check("select x'ff'=X'' from (values(true))");
    }

    @Test
    public void testBinaryStringFails() {
        this.assertExceptionIsThrown("select ^x'ffee'='abc'^ from (values(true))", "(?s).*Cannot apply '=' to arguments of type '<BINARY.2.> = <CHAR.3.>'.*");
        this.assertExceptionIsThrown("select ^x'ff'=88^ from (values(true))", "(?s).*Cannot apply '=' to arguments of type '<BINARY.1.> = <INTEGER>'.*");
        this.assertExceptionIsThrown("select ^x''<>1.1e-1^ from (values(true))", "(?s).*Cannot apply '<>' to arguments of type '<BINARY.0.> <> <DOUBLE>'.*");
        this.assertExceptionIsThrown("select ^x''<>1.1^ from (values(true))", "(?s).*Cannot apply '<>' to arguments of type '<BINARY.0.> <> <DECIMAL.2, 1.>'.*");
    }

    @Test
    public void testStringLiteral() {
        this.check("select n''=_iso-8859-1'abc' from (values(true))");
        this.check("select N'f'<>'''' from (values(true))");
    }

    @Test
    public void testStringLiteralBroken() {
        this.check("select 'foo'\n'bar' from (values(true))");
        this.check("select 'foo'\r'bar' from (values(true))");
        this.check("select 'foo'\n\r'bar' from (values(true))");
        this.check("select 'foo'\r\n'bar' from (values(true))");
        this.check("select 'foo'\n'bar' from (values(true))");
        this.checkFails("select 'foo' /* comment */ ^'bar'^ from (values(true))", "String literal continued on same line");
        this.check("select 'foo' -- comment\r from (values(true))");
        this.checkFails("select 'foo' ^'bar'^ from (values(true))", "String literal continued on same line");
    }

    @Test
    public void testArithmeticOperators() {
        this.checkExp("power(2,3)");
        this.checkExp("aBs(-2.3e-2)");
        this.checkExp("MOD(5             ,\t\f\r\n2)");
        this.checkExp("ln(5.43  )");
        this.checkExp("log10(- -.2  )");
        this.checkExp("mod(5.1, 3)");
        this.checkExp("mod(2,5.1)");
        this.checkExp("exp(3.67)");
    }

    @Test
    public void testArithmeticOperatorsFails() {
        this.checkExpFails("^power(2,'abc')^", "(?s).*Cannot apply 'POWER' to arguments of type 'POWER.<INTEGER>, <CHAR.3.>.*");
        this.checkExpFails("^power(true,1)^", "(?s).*Cannot apply 'POWER' to arguments of type 'POWER.<BOOLEAN>, <INTEGER>.*");
        this.checkExpFails("^mod(x'1100',1)^", "(?s).*Cannot apply 'MOD' to arguments of type 'MOD.<BINARY.2.>, <INTEGER>.*");
        this.checkExpFails("^mod(1, x'1100')^", "(?s).*Cannot apply 'MOD' to arguments of type 'MOD.<INTEGER>, <BINARY.2.>.*");
        this.checkExpFails("^abs(x'')^", "(?s).*Cannot apply 'ABS' to arguments of type 'ABS.<BINARY.0.>.*");
        this.checkExpFails("^ln(x'face12')^", "(?s).*Cannot apply 'LN' to arguments of type 'LN.<BINARY.3.>.*");
        this.checkExpFails("^log10(x'fa')^", "(?s).*Cannot apply 'LOG10' to arguments of type 'LOG10.<BINARY.1.>.*");
        this.checkExpFails("^exp('abc')^", "(?s).*Cannot apply 'EXP' to arguments of type 'EXP.<CHAR.3.>.*");
    }

    @Test
    public void testCaseExpression() {
        this.checkExp("case 1 when 1 then 'one' end");
        this.checkExp("case 1 when 1 then 'one' else null end");
        this.checkExp("case 1 when 1 then 'one' else 'more' end");
        this.checkExp("case 1 when 1 then 'one' when 2 then null else 'more' end");
        this.checkExp("case when TRUE then 'true' else 'false' end");
        this.check("values case when TRUE then 'true' else 'false' end");
        this.checkExp("CASE 1 WHEN 1 THEN cast(null as integer) WHEN 2 THEN null END");
        this.checkExp("CASE 1 WHEN 1 THEN cast(null as integer) WHEN 2 THEN cast(null as integer) END");
        this.checkExp("CASE 1 WHEN 1 THEN null WHEN 2 THEN cast(null as integer) END");
        this.checkExp("CASE 1 WHEN 1 THEN cast(null as integer) WHEN 2 THEN cast(cast(null as tinyint) as integer) END");
    }

    @Test
    public void testCaseExpressionTypes() {
        this.checkExpType("case 1 when 1 then 'one' else 'not one' end", "CHAR(7) NOT NULL");
        this.checkExpType("case when 2<1 then 'impossible' end", "CHAR(10)");
        this.checkExpType("case 'one' when 'two' then 2.00 when 'one' then 1.3 else 3.2 end", "DECIMAL(3, 2) NOT NULL");
        this.checkExpType("case 'one' when 'two' then 2 when 'one' then 1.00 else 3 end", "DECIMAL(12, 2) NOT NULL");
        this.checkExpType("case 1 when 1 then 'one' when 2 then null else 'more' end", "CHAR(4)");
        this.checkExpType("case when TRUE then 'true' else 'false' end", "CHAR(5) NOT NULL");
        this.checkExpType("CASE 1 WHEN 1 THEN cast(null as integer) END", "INTEGER");
        this.checkExpType("CASE 1 WHEN 1 THEN NULL WHEN 2 THEN cast(cast(null as tinyint) as integer) END", "INTEGER");
        this.checkExpType("CASE 1 WHEN 1 THEN cast(null as integer) WHEN 2 THEN cast(null as integer) END", "INTEGER");
        this.checkExpType("CASE 1 WHEN 1 THEN cast(null as integer) WHEN 2 THEN cast(cast(null as tinyint) as integer) END", "INTEGER");
        this.checkExpType("CASE 1 WHEN 1 THEN INTERVAL '12 3:4:5.6' DAY TO SECOND(6) WHEN 2 THEN INTERVAL '12 3:4:5.6' DAY TO SECOND(9) END", "INTERVAL DAY TO SECOND(9)");
    }

    @Test
    public void testCaseExpressionFails() {
        this.checkWholeExpFails("case 'string' when x'01' then 'zero one' else 'something' end", "(?s).*Cannot apply '=' to arguments of type '<CHAR.6.> = <BINARY.1.>'.*");
        this.checkWholeExpFails("case 1 when 1 then null else null end", "(?s).*ELSE clause or at least one THEN clause must be non-NULL.*");
        this.checkWholeExpFails("case 1 when 1 then null end", "(?s).*ELSE clause or at least one THEN clause must be non-NULL.*");
        this.checkWholeExpFails("case when true and true then 1 when false then 2 when false then true else case when true then 3 end end", "Illegal mixing of types in CASE or COALESCE statement");
    }

    @Test
    public void testNullIf() {
        this.checkExp("nullif(1,2)");
        this.checkExpType("nullif(1,2)", "INTEGER");
        this.checkExpType("nullif('a','b')", "CHAR(1)");
        this.checkExpType("nullif(345.21, 2)", "DECIMAL(5, 2)");
        this.checkExpType("nullif(345.21, 2e0)", "DECIMAL(5, 2)");
        this.checkWholeExpFails("nullif(1,2,3)", "Invalid number of arguments to function 'NULLIF'. Was expecting 2 arguments");
    }

    @Test
    public void testCoalesce() {
        this.checkExp("coalesce('a','b')");
        this.checkExpType("coalesce('a','b','c')", "CHAR(1) NOT NULL");
    }

    @Test
    public void testCoalesceFails() {
        this.checkWholeExpFails("coalesce('a',1)", "Illegal mixing of types in CASE or COALESCE statement");
        this.checkWholeExpFails("coalesce('a','b',1)", "Illegal mixing of types in CASE or COALESCE statement");
    }

    @Test
    public void testStringCompare() {
        this.checkExp("'a' = 'b'");
        this.checkExp("'a' <> 'b'");
        this.checkExp("'a' > 'b'");
        this.checkExp("'a' < 'b'");
        this.checkExp("'a' >= 'b'");
        this.checkExp("'a' <= 'b'");
        this.checkExp("cast('' as varchar(1))>cast('' as char(1))");
        this.checkExp("cast('' as varchar(1))<cast('' as char(1))");
        this.checkExp("cast('' as varchar(1))>=cast('' as char(1))");
        this.checkExp("cast('' as varchar(1))<=cast('' as char(1))");
        this.checkExp("cast('' as varchar(1))=cast('' as char(1))");
        this.checkExp("cast('' as varchar(1))<>cast('' as char(1))");
    }

    @Test
    public void testStringCompareType() {
        this.checkExpType("'a' = 'b'", "BOOLEAN NOT NULL");
        this.checkExpType("'a' <> 'b'", "BOOLEAN NOT NULL");
        this.checkExpType("'a' > 'b'", "BOOLEAN NOT NULL");
        this.checkExpType("'a' < 'b'", "BOOLEAN NOT NULL");
        this.checkExpType("'a' >= 'b'", "BOOLEAN NOT NULL");
        this.checkExpType("'a' <= 'b'", "BOOLEAN NOT NULL");
        this.checkExpType("CAST(NULL AS VARCHAR(33)) > 'foo'", "BOOLEAN");
    }

    @Test
    public void testConcat() {
        this.checkExp("'a'||'b'");
        this.checkExp("x'12'||x'34'");
        this.checkExpType("'a'||'b'", "CHAR(2) NOT NULL");
        this.checkExpType("cast('a' as char(1))||cast('b' as char(2))", "CHAR(3) NOT NULL");
        this.checkExpType("cast(null as char(1))||cast('b' as char(2))", "CHAR(3)");
        this.checkExpType("'a'||'b'||'c'", "CHAR(3) NOT NULL");
        this.checkExpType("'a'||'b'||'cde'||'f'", "CHAR(6) NOT NULL");
        this.checkExpType("'a'||'b'||cast('cde' as VARCHAR(3))|| 'f'", "VARCHAR(6) NOT NULL");
        this.checkExp("_UTF16'a'||_UTF16'b'||_UTF16'c'");
    }

    @Test
    public void testConcatWithCharset() {
        this.checkCharset("_UTF16'a'||_UTF16'b'||_UTF16'c'", Charset.forName("UTF-16LE"));
    }

    @Test
    public void testConcatFails() {
        this.checkWholeExpFails("'a'||x'ff'", "(?s).*Cannot apply '\\|\\|' to arguments of type '<CHAR.1.> \\|\\| <BINARY.1.>'.*Supported form.s.: '<STRING> \\|\\| <STRING>.*'");
    }

    @Test
    public void testBetween() {
        this.checkExp("1 between 2 and 3");
        this.checkExp("'a' between 'b' and 'c'");
        this.checkExp("'' between 2 and 3");
        this.checkWholeExpFails("date '2012-02-03' between 2 and 3", "(?s).*Cannot apply 'BETWEEN ASYMMETRIC' to arguments of type.*");
    }

    @Test
    public void testCharsetMismatch() {
        this.checkWholeExpFails("''=_UTF16''", "Cannot apply .* to the two different charsets ISO-8859-1 and UTF-16LE");
        this.checkWholeExpFails("''<>_UTF16''", "(?s).*Cannot apply .* to the two different charsets.*");
        this.checkWholeExpFails("''>_UTF16''", "(?s).*Cannot apply .* to the two different charsets.*");
        this.checkWholeExpFails("''<_UTF16''", "(?s).*Cannot apply .* to the two different charsets.*");
        this.checkWholeExpFails("''<=_UTF16''", "(?s).*Cannot apply .* to the two different charsets.*");
        this.checkWholeExpFails("''>=_UTF16''", "(?s).*Cannot apply .* to the two different charsets.*");
        this.checkWholeExpFails("''||_UTF16''", ANY);
        this.checkWholeExpFails("'a'||'b'||_UTF16'c'", ANY);
    }

    public void _testSimpleCollate() {
        this.checkExp("'s' collate latin1$en$1");
        this.checkExpType("'s' collate latin1$en$1", "CHAR(1)");
        this.checkCollation("'s'", "ISO-8859-1$en_US$primary", SqlCollation.Coercibility.COERCIBLE);
        this.checkCollation("'s' collate latin1$sv$3", "ISO-8859-1$sv$3", SqlCollation.Coercibility.EXPLICIT);
    }

    public void _testCharsetAndCollateMismatch() {
        this.checkExpFails("_UTF16's' collate latin1$en$1", "?");
    }

    public void _testDyadicCollateCompare() {
        this.checkExp("'s' collate latin1$en$1 < 't'");
        this.checkExp("'t' > 's' collate latin1$en$1");
        this.checkExp("'s' collate latin1$en$1 <> 't' collate latin1$en$1");
    }

    public void _testDyadicCompareCollateFails() {
        this.checkExpFails("'s' collate latin1$en$1 <= 't' collate latin1$en$2", "(?s).*Two explicit different collations.*are illegal.*");
        this.checkExpFails("'s' collate latin1$sv$1 >= 't' collate latin1$en$1", "(?s).*Two explicit different collations.*are illegal.*");
    }

    public void _testDyadicCollateOperator() {
        this.checkCollation("'a' || 'b'", "ISO-8859-1$en_US$primary", SqlCollation.Coercibility.COERCIBLE);
        this.checkCollation("'a' collate latin1$sv$3 || 'b'", "ISO-8859-1$sv$3", SqlCollation.Coercibility.EXPLICIT);
        this.checkCollation("'a' collate latin1$sv$3 || 'b' collate latin1$sv$3", "ISO-8859-1$sv$3", SqlCollation.Coercibility.EXPLICIT);
    }

    @Test
    public void testCharLength() {
        this.checkExp("char_length('string')");
        this.checkExp("char_length(_UTF16'string')");
        this.checkExp("character_length('string')");
        this.checkExpType("char_length('string')", "INTEGER NOT NULL");
        this.checkExpType("character_length('string')", "INTEGER NOT NULL");
    }

    @Test
    public void testUpperLower() {
        this.checkExp("upper(_UTF16'sadf')");
        this.checkExp("lower(n'sadf')");
        this.checkExpType("lower('sadf')", "CHAR(4) NOT NULL");
        this.checkWholeExpFails("upper(123)", "(?s).*Cannot apply 'UPPER' to arguments of type 'UPPER.<INTEGER>.'.*");
    }

    @Test
    public void testPosition() {
        this.checkExp("position('mouse' in 'house')");
        this.checkExp("position(x'11' in x'100110')");
        this.checkExp("position(x'11' in x'100110' FROM 10)");
        this.checkExp("position(x'abcd' in x'')");
        this.checkExpType("position('mouse' in 'house')", "INTEGER NOT NULL");
        this.checkWholeExpFails("position(x'1234' in '110')", "Parameters must be of the same type");
        this.checkWholeExpFails("position(x'1234' in '110' from 3)", "Parameters must be of the same type");
    }

    @Test
    public void testTrim() {
        this.checkExp("trim('mustache' FROM 'beard')");
        this.checkExp("trim(both 'mustache' FROM 'beard')");
        this.checkExp("trim(leading 'mustache' FROM 'beard')");
        this.checkExp("trim(trailing 'mustache' FROM 'beard')");
        this.checkExpType("trim('mustache' FROM 'beard')", "VARCHAR(5) NOT NULL");
        this.checkExpType("trim('beard  ')", "VARCHAR(7) NOT NULL");
        this.checkExpType("trim('mustache' FROM cast(null as varchar(4)))", "VARCHAR(4)");
    }

    @Test
    public void testTrimFails() {
        this.checkWholeExpFails("trim(123 FROM 'beard')", "(?s).*Cannot apply 'TRIM' to arguments of type.*");
        this.checkWholeExpFails("trim('a' FROM 123)", "(?s).*Cannot apply 'TRIM' to arguments of type.*");
        this.checkWholeExpFails("trim('a' FROM _UTF16'b')", "(?s).*not comparable to each other.*");
    }

    public void _testConvertAndTranslate() {
        this.checkExp("convert('abc' using conversion)");
        this.checkExp("translate('abc' using translation)");
    }

    @Test
    public void testTranslate3() {
        this.checkWholeExpFails("translate('aabbcc', 'ab', '+-')", "No match found for function signature TRANSLATE3\\(<CHARACTER>, <CHARACTER>, <CHARACTER>\\)");
        this.tester = this.tester.withOperatorTable(ChainedSqlOperatorTable.of((SqlOperatorTable[])new SqlOperatorTable[]{OracleSqlOperatorTable.instance(), SqlStdOperatorTable.instance()}));
        this.checkExpType("translate('aabbcc', 'ab', '+-')", "VARCHAR(6) NOT NULL");
        this.checkWholeExpFails("translate('abc', 'ab')", "Invalid number of arguments to function 'TRANSLATE3'. Was expecting 3 arguments");
        this.checkWholeExpFails("translate('abc', 'ab', 123)", "(?s)Cannot apply 'TRANSLATE3' to arguments of type 'TRANSLATE3\\(<CHAR\\(3\\)>, <CHAR\\(2\\)>, <INTEGER>\\)'\\. .*");
        this.checkWholeExpFails("translate('abc', 'ab', '+-', 'four')", "Invalid number of arguments to function 'TRANSLATE3'. Was expecting 3 arguments");
    }

    @Test
    public void testOverlay() {
        this.checkExp("overlay('ABCdef' placing 'abc' from 1)");
        this.checkExp("overlay('ABCdef' placing 'abc' from 1 for 3)");
        this.checkWholeExpFails("overlay('ABCdef' placing 'abc' from '1' for 3)", "(?s).*OVERLAY\\(<STRING> PLACING <STRING> FROM <INTEGER>\\).*");
        this.checkExpType("overlay('ABCdef' placing 'abc' from 1 for 3)", "VARCHAR(9) NOT NULL");
        this.checkExpType("overlay('ABCdef' placing 'abc' from 6 for 3)", "VARCHAR(9) NOT NULL");
        this.checkExpType("overlay('ABCdef' placing cast(null as char(5)) from 1)", "VARCHAR(11)");
    }

    @Test
    public void testSubstring() {
        this.checkExp("substring('a' FROM 1)");
        this.checkExp("substring('a' FROM 1 FOR 3)");
        this.checkExp("substring('a' FROM 'reg' FOR '\\')");
        this.checkExp("substring(x'ff' FROM 1  FOR 2)");
        this.checkExpType("substring('10' FROM 1  FOR 2)", "VARCHAR(2) NOT NULL");
        this.checkExpType("substring('1000' FROM 2)", "VARCHAR(4) NOT NULL");
        this.checkExpType("substring('1000' FROM '1'  FOR 'w')", "VARCHAR(4) NOT NULL");
        this.checkExpType("substring(cast(' 100 ' as CHAR(99)) FROM '1'  FOR 'w')", "VARCHAR(99) NOT NULL");
        this.checkExpType("substring(x'10456b' FROM 1  FOR 2)", "VARBINARY(3) NOT NULL");
        this.checkCharset("substring('10' FROM 1  FOR 2)", Charset.forName("latin1"));
        this.checkCharset("substring(_UTF16'10' FROM 1  FOR 2)", Charset.forName("UTF-16LE"));
    }

    @Test
    public void testSubstringFails() {
        this.checkWholeExpFails("substring('a' from 1 for 'b')", "(?s).*Cannot apply 'SUBSTRING' to arguments of type.*");
        this.checkWholeExpFails("substring(_UTF16'10' FROM '0' FOR '\\')", "(?s).* not comparable to each other.*");
        this.checkWholeExpFails("substring('10' FROM _UTF16'0' FOR '\\')", "(?s).* not comparable to each other.*");
        this.checkWholeExpFails("substring('10' FROM '0' FOR _UTF16'\\')", "(?s).* not comparable to each other.*");
    }

    @Test
    public void testLikeAndSimilar() {
        this.checkExp("'a' like 'b'");
        this.checkExp("'a' like 'b'");
        this.checkExp("'a' similar to 'b'");
        this.checkExp("'a' similar to 'b' escape 'c'");
    }

    public void _testLikeAndSimilarFails() {
        this.checkExpFails("'a' like _UTF16'b'  escape 'c'", "(?s).*Operands _ISO-8859-1.a. COLLATE ISO-8859-1.en_US.primary, _SHIFT_JIS.b..*");
        this.checkExpFails("'a' similar to _UTF16'b'  escape 'c'", "(?s).*Operands _ISO-8859-1.a. COLLATE ISO-8859-1.en_US.primary, _SHIFT_JIS.b..*");
        this.checkExpFails("'a' similar to 'b' collate UTF16$jp  escape 'c'", "(?s).*Operands _ISO-8859-1.a. COLLATE ISO-8859-1.en_US.primary, _ISO-8859-1.b. COLLATE SHIFT_JIS.jp.primary.*");
    }

    @Test
    public void testNull() {
        this.checkFails("values 1.0 + ^NULL^", "(?s).*Illegal use of .NULL.*");
        this.checkExpFails("1.0 + ^NULL^", "(?s).*Illegal use of .NULL.*");
        this.checkExp("1 in (1, null, 2)");
        this.checkExp("1 in (null, 1, null, 2)");
        this.checkExp("1 in (cast(null as integer), null)");
        this.checkWholeExpFails("1 in (null, null)", ERR_IN_OPERANDS_INCOMPATIBLE);
    }

    @Test
    public void testNullCast() {
        this.checkExpType("cast(null as tinyint)", "TINYINT");
        this.checkExpType("cast(null as smallint)", "SMALLINT");
        this.checkExpType("cast(null as integer)", "INTEGER");
        this.checkExpType("cast(null as bigint)", "BIGINT");
        this.checkExpType("cast(null as float)", "FLOAT");
        this.checkExpType("cast(null as real)", "REAL");
        this.checkExpType("cast(null as double)", "DOUBLE");
        this.checkExpType("cast(null as boolean)", "BOOLEAN");
        this.checkExpType("cast(null as varchar(1))", "VARCHAR(1)");
        this.checkExpType("cast(null as char(1))", "CHAR(1)");
        this.checkExpType("cast(null as binary(1))", "BINARY(1)");
        this.checkExpType("cast(null as date)", "DATE");
        this.checkExpType("cast(null as time)", "TIME(0)");
        this.checkExpType("cast(null as timestamp)", "TIMESTAMP(0)");
        this.checkExpType("cast(null as decimal)", "DECIMAL(19, 0)");
        this.checkExpType("cast(null as varbinary(1))", "VARBINARY(1)");
        this.checkExp("cast(null as integer), cast(null as char(1))");
    }

    @Test
    public void testCastTypeToType() {
        this.checkExpType("cast(123 as char)", "CHAR(1) NOT NULL");
        this.checkExpType("cast(123 as varchar)", "VARCHAR NOT NULL");
        this.checkExpType("cast(x'1234' as binary)", "BINARY(1) NOT NULL");
        this.checkExpType("cast(x'1234' as varbinary)", "VARBINARY NOT NULL");
        this.checkExpType("cast(123 as varchar(3))", "VARCHAR(3) NOT NULL");
        this.checkExpType("cast(123 as char(3))", "CHAR(3) NOT NULL");
        this.checkExpType("cast('123' as integer)", "INTEGER NOT NULL");
        this.checkExpType("cast('123' as double)", "DOUBLE NOT NULL");
        this.checkExpType("cast('1.0' as real)", "REAL NOT NULL");
        this.checkExpType("cast(1.0 as tinyint)", "TINYINT NOT NULL");
        this.checkExpType("cast(1 as tinyint)", "TINYINT NOT NULL");
        this.checkExpType("cast(1.0 as smallint)", "SMALLINT NOT NULL");
        this.checkExpType("cast(1 as integer)", "INTEGER NOT NULL");
        this.checkExpType("cast(1.0 as integer)", "INTEGER NOT NULL");
        this.checkExpType("cast(1.0 as bigint)", "BIGINT NOT NULL");
        this.checkExpType("cast(1 as bigint)", "BIGINT NOT NULL");
        this.checkExpType("cast(1.0 as float)", "FLOAT NOT NULL");
        this.checkExpType("cast(1 as float)", "FLOAT NOT NULL");
        this.checkExpType("cast(1.0 as real)", "REAL NOT NULL");
        this.checkExpType("cast(1 as real)", "REAL NOT NULL");
        this.checkExpType("cast(1.0 as double)", "DOUBLE NOT NULL");
        this.checkExpType("cast(1 as double)", "DOUBLE NOT NULL");
        this.checkExpType("cast(123 as decimal(6,4))", "DECIMAL(6, 4) NOT NULL");
        this.checkExpType("cast(123 as decimal(6))", "DECIMAL(6, 0) NOT NULL");
        this.checkExpType("cast(123 as decimal)", "DECIMAL(19, 0) NOT NULL");
        this.checkExpType("cast(1.234 as decimal(2,5))", "DECIMAL(2, 5) NOT NULL");
        this.checkExpType("cast('4.5' as decimal(3,1))", "DECIMAL(3, 1) NOT NULL");
        this.checkExpType("cast(null as boolean)", "BOOLEAN");
        this.checkExpType("cast('abc' as varchar(1))", "VARCHAR(1) NOT NULL");
        this.checkExpType("cast('abc' as char(1))", "CHAR(1) NOT NULL");
        this.checkExpType("cast(x'ff' as binary(1))", "BINARY(1) NOT NULL");
        this.checkExpType("cast(multiset[1] as double multiset)", "DOUBLE NOT NULL MULTISET NOT NULL");
        this.checkExpType("cast(multiset['abc'] as integer multiset)", "INTEGER NOT NULL MULTISET NOT NULL");
    }

    @Test
    public void testCastFails() {
        this.checkExpFails("cast('foo' as ^bar^)", "(?s).*Unknown datatype name 'BAR'");
        this.checkWholeExpFails("cast(multiset[1] as integer)", "(?s).*Cast function cannot convert value of type INTEGER MULTISET to type INTEGER");
        this.checkWholeExpFails("cast(x'ff' as decimal(5,2))", "(?s).*Cast function cannot convert value of type BINARY\\(1\\) to type DECIMAL\\(5, 2\\)");
        this.checkWholeExpFails("cast(1 as boolean)", "(?s).*Cast function cannot convert value of type INTEGER to type BOOLEAN.*");
        this.checkWholeExpFails("cast(1.0e1 as boolean)", "(?s).*Cast function cannot convert value of type DOUBLE to type BOOLEAN.*");
        this.checkWholeExpFails("cast(true as numeric)", "(?s).*Cast function cannot convert value of type BOOLEAN to type DECIMAL.*");
        this.checkWholeExpFails("cast(DATE '1243-12-01' as TIME)", "(?s).*Cast function cannot convert value of type DATE to type TIME.*");
        this.checkWholeExpFails("cast(TIME '12:34:01' as DATE)", "(?s).*Cast function cannot convert value of type TIME\\(0\\) to type DATE.*");
        this.checkExp("cast(true as char(3))");
    }

    @Test
    public void testCastBinaryLiteral() {
        this.checkExpFails("cast(^x'0dd'^ as binary(5))", "Binary literal string must contain an even number of hexits");
    }

    @Test
    public void testDateTime() {
        this.checkExp("LOCALTIME(3)");
        this.checkExp("LOCALTIME");
        this.checkWholeExpFails("LOCALTIME(1+2)", "Argument to function 'LOCALTIME' must be a literal");
        this.checkWholeExpFails("LOCALTIME(NULL)", "Argument to function 'LOCALTIME' must not be NULL");
        this.checkWholeExpFails("LOCALTIME(CAST(NULL AS INTEGER))", "Argument to function 'LOCALTIME' must not be NULL");
        this.checkWholeExpFails("LOCALTIME()", "No match found for function signature LOCALTIME..");
        this.checkExpType("LOCALTIME", "TIME(0) NOT NULL");
        this.checkWholeExpFails("LOCALTIME(-1)", "Argument to function 'LOCALTIME' must be a positive integer literal");
        this.checkExpFails("^LOCALTIME(100000000000000)^", "(?s).*Numeric literal '100000000000000' out of range.*");
        this.checkWholeExpFails("LOCALTIME(4)", "Argument to function 'LOCALTIME' must be a valid precision between '0' and '3'");
        this.checkWholeExpFails("LOCALTIME('foo')", "(?s).*Cannot apply.*");
        this.checkExp("LOCALTIMESTAMP(3)");
        this.checkExp("LOCALTIMESTAMP");
        this.checkWholeExpFails("LOCALTIMESTAMP(1+2)", "Argument to function 'LOCALTIMESTAMP' must be a literal");
        this.checkWholeExpFails("LOCALTIMESTAMP()", "No match found for function signature LOCALTIMESTAMP..");
        this.checkExpType("LOCALTIMESTAMP", "TIMESTAMP(0) NOT NULL");
        this.checkWholeExpFails("LOCALTIMESTAMP(-1)", "Argument to function 'LOCALTIMESTAMP' must be a positive integer literal");
        this.checkExpFails("^LOCALTIMESTAMP(100000000000000)^", "(?s).*Numeric literal '100000000000000' out of range.*");
        this.checkWholeExpFails("LOCALTIMESTAMP(4)", "Argument to function 'LOCALTIMESTAMP' must be a valid precision between '0' and '3'");
        this.checkWholeExpFails("LOCALTIMESTAMP('foo')", "(?s).*Cannot apply.*");
        this.checkWholeExpFails("CURRENT_DATE(3)", "No match found for function signature CURRENT_DATE..NUMERIC..");
        this.checkExp("CURRENT_DATE");
        this.checkWholeExpFails("CURRENT_DATE(1+2)", "No match found for function signature CURRENT_DATE..NUMERIC..");
        this.checkWholeExpFails("CURRENT_DATE()", "No match found for function signature CURRENT_DATE..");
        this.checkExpType("CURRENT_DATE", "DATE NOT NULL");
        this.checkWholeExpFails("CURRENT_DATE(-1)", "No match found for function signature CURRENT_DATE..NUMERIC..");
        this.checkWholeExpFails("CURRENT_DATE('foo')", ANY);
        this.checkExp("current_time(3)");
        this.checkExp("current_time");
        this.checkWholeExpFails("current_time(1+2)", "Argument to function 'CURRENT_TIME' must be a literal");
        this.checkWholeExpFails("current_time()", "No match found for function signature CURRENT_TIME..");
        this.checkExpType("current_time", "TIME(0) NOT NULL");
        this.checkWholeExpFails("current_time(-1)", "Argument to function 'CURRENT_TIME' must be a positive integer literal");
        this.checkExpFails("^CURRENT_TIME(100000000000000)^", "(?s).*Numeric literal '100000000000000' out of range.*");
        this.checkWholeExpFails("CURRENT_TIME(4)", "Argument to function 'CURRENT_TIME' must be a valid precision between '0' and '3'");
        this.checkWholeExpFails("current_time('foo')", "(?s).*Cannot apply.*");
        this.checkExp("CURRENT_TIMESTAMP(3)");
        this.checkExp("CURRENT_TIMESTAMP");
        this.check("SELECT CURRENT_TIMESTAMP AS X FROM (VALUES (1))");
        this.checkWholeExpFails("CURRENT_TIMESTAMP(1+2)", "Argument to function 'CURRENT_TIMESTAMP' must be a literal");
        this.checkWholeExpFails("CURRENT_TIMESTAMP()", "No match found for function signature CURRENT_TIMESTAMP..");
        this.checkExpType("CURRENT_TIMESTAMP", "TIMESTAMP(0) NOT NULL");
        this.checkExpType("CURRENT_TIMESTAMP(2)", "TIMESTAMP(2) NOT NULL");
        this.checkWholeExpFails("CURRENT_TIMESTAMP(-1)", "Argument to function 'CURRENT_TIMESTAMP' must be a positive integer literal");
        this.checkExpFails("^CURRENT_TIMESTAMP(100000000000000)^", "(?s).*Numeric literal '100000000000000' out of range.*");
        this.checkWholeExpFails("CURRENT_TIMESTAMP(4)", "Argument to function 'CURRENT_TIMESTAMP' must be a valid precision between '0' and '3'");
        this.checkWholeExpFails("CURRENT_TIMESTAMP('foo')", "(?s).*Cannot apply.*");
        this.checkExp("DATE '2004-12-01'");
        this.checkExp("TIME '12:01:01'");
        this.checkExp("TIME '11:59:59.99'");
        this.checkExp("TIME '12:01:01.001'");
        this.checkExp("TIMESTAMP '2004-12-01 12:01:01'");
        this.checkExp("TIMESTAMP '2004-12-01 12:01:01.001'");
    }

    @Test
    public void testDateTimeCast() {
        this.checkWholeExpFails("CAST(1 as DATE)", "Cast function cannot convert value of type INTEGER to type DATE");
        this.checkExp("CAST(DATE '2001-12-21' AS VARCHAR(10))");
        this.checkExp("CAST( '2001-12-21' AS DATE)");
        this.checkExp("CAST( TIMESTAMP '2001-12-21 10:12:21' AS VARCHAR(20))");
        this.checkExp("CAST( TIME '10:12:21' AS VARCHAR(20))");
        this.checkExp("CAST( '10:12:21' AS TIME)");
        this.checkExp("CAST( '2004-12-21 10:12:21' AS TIMESTAMP)");
    }

    @Test
    public void testInvalidFunction() {
        this.checkWholeExpFails("foo()", "No match found for function signature FOO..");
        this.checkWholeExpFails("mod(123)", "Invalid number of arguments to function 'MOD'. Was expecting 2 arguments");
    }

    @Test
    public void testJdbcFunctionCall() {
        this.checkExp("{fn log10(1)}");
        this.checkExp("{fn locate('','')}");
        this.checkExp("{fn insert('',1,2,'')}");
        this.checkWholeExpFails("{fn lower('Foo' || 'Bar')}", "Function '\\{fn LOWER\\}' is not defined");
        this.checkExp("{fn lcase('Foo' || 'Bar')}");
        this.checkExp("{fn power(2, 3)}");
        this.checkWholeExpFails("{fn insert('','',1,2)}", "(?s).*.*");
        this.checkWholeExpFails("{fn insert('','',1)}", "(?s).*4.*");
        this.checkExp("{fn locate('','',1)}");
        this.checkWholeExpFails("{fn log10('1')}", "(?s).*Cannot apply.*fn LOG10..<CHAR.1.>.*");
        String expected = "Cannot apply '\\{fn LOG10\\}' to arguments of type '\\{fn LOG10\\}\\(<INTEGER>, <INTEGER>\\)'\\. Supported form\\(s\\): '\\{fn LOG10\\}\\(<NUMERIC>\\)'";
        this.checkWholeExpFails("{fn log10(1,1)}", "Cannot apply '\\{fn LOG10\\}' to arguments of type '\\{fn LOG10\\}\\(<INTEGER>, <INTEGER>\\)'\\. Supported form\\(s\\): '\\{fn LOG10\\}\\(<NUMERIC>\\)'");
        this.checkWholeExpFails("{fn fn(1)}", "(?s).*Function '.fn FN.' is not defined.*");
        this.checkWholeExpFails("{fn hahaha(1)}", "(?s).*Function '.fn HAHAHA.' is not defined.*");
    }

    @Test
    public void testQuotedFunction() {
        this.checkExpFails("^\"TRIM\"('b' FROM 'a')^", "(?s).*Encountered \"FROM\" at .*");
        this.checkExpType("\"TRIM\"('b')", "VARCHAR(1) NOT NULL");
        this.checkExpType("TRIM('b')", "VARCHAR(1) NOT NULL");
    }

    @Test
    public void testRowtype() {
        this.check("values (1),(2),(1)");
        this.checkResultType("values (1),(2),(1)", "RecordType(INTEGER NOT NULL EXPR$0) NOT NULL");
        this.check("values (1,'1'),(2,'2')");
        this.checkResultType("values (1,'1'),(2,'2')", "RecordType(INTEGER NOT NULL EXPR$0, CHAR(1) NOT NULL EXPR$1) NOT NULL");
        this.checkResultType("values true", "RecordType(BOOLEAN NOT NULL EXPR$0) NOT NULL");
        this.checkFails("^values ('1'),(2)^", "Values passed to VALUES operator must have compatible types");
    }

    @Test
    public void testRow() {
        this.checkColumnType("select t.r.\"EXPR$1\".\"EXPR$2\"\nfrom (select ((1,2),(3,4,5)) r from dept) t", "INTEGER NOT NULL");
    }

    @Test
    public void testMultiset() {
        this.checkExpType("multiset[1]", "INTEGER NOT NULL MULTISET NOT NULL");
        this.checkExpType("multiset[1, CAST(null AS DOUBLE)]", "DOUBLE MULTISET NOT NULL");
        this.checkExpType("multiset[1.3,2.3]", "DECIMAL(2, 1) NOT NULL MULTISET NOT NULL");
        this.checkExpType("multiset[1,2.3, cast(4 as bigint)]", "DECIMAL(19, 0) NOT NULL MULTISET NOT NULL");
        this.checkExpType("multiset['1','22', '333','22']", "CHAR(3) NOT NULL MULTISET NOT NULL");
        this.checkExpFails("^multiset[1, '2']^", "Parameters must be of the same type");
        this.checkExpType("multiset[ROW(1,2)]", "RecordType(INTEGER NOT NULL EXPR$0, INTEGER NOT NULL EXPR$1) NOT NULL MULTISET NOT NULL");
        this.checkExpType("multiset[ROW(1,2),ROW(2,5)]", "RecordType(INTEGER NOT NULL EXPR$0, INTEGER NOT NULL EXPR$1) NOT NULL MULTISET NOT NULL");
        this.checkExpType("multiset[ROW(1,2),ROW(3.4,5.4)]", "RecordType(DECIMAL(11, 1) NOT NULL EXPR$0, DECIMAL(11, 1) NOT NULL EXPR$1) NOT NULL MULTISET NOT NULL");
        this.checkExpType("multiset(select*from emp)", "RecordType(INTEGER NOT NULL EMPNO, VARCHAR(20) NOT NULL ENAME, VARCHAR(10) NOT NULL JOB, INTEGER MGR, TIMESTAMP(0) NOT NULL HIREDATE, INTEGER NOT NULL SAL, INTEGER NOT NULL COMM, INTEGER NOT NULL DEPTNO, BOOLEAN NOT NULL SLACKER) NOT NULL MULTISET NOT NULL");
    }

    @Test
    public void testMultisetSetOperators() {
        this.checkExp("multiset[1] multiset union multiset[1,2.3]");
        this.checkExpType("multiset[324.2] multiset union multiset[23.2,2.32]", "DECIMAL(5, 2) NOT NULL MULTISET NOT NULL");
        this.checkExpType("multiset[1] multiset union multiset[1,2.3]", "DECIMAL(11, 1) NOT NULL MULTISET NOT NULL");
        this.checkExp("multiset[1] multiset union all multiset[1,2.3]");
        this.checkExp("multiset[1] multiset except multiset[1,2.3]");
        this.checkExp("multiset[1] multiset except all multiset[1,2.3]");
        this.checkExp("multiset[1] multiset intersect multiset[1,2.3]");
        this.checkExp("multiset[1] multiset intersect all multiset[1,2.3]");
        this.checkExpFails("^multiset[1, '2']^ multiset union multiset[1]", "Parameters must be of the same type");
        this.checkExp("multiset[ROW(1,2)] multiset intersect multiset[row(3,4)]");
    }

    @Test
    public void testSubMultisetOf() {
        this.checkExpType("multiset[1] submultiset of multiset[1,2.3]", "BOOLEAN NOT NULL");
        this.checkExpType("multiset[1] submultiset of multiset[1]", "BOOLEAN NOT NULL");
        this.checkExpFails("^multiset[1, '2']^ submultiset of multiset[1]", "Parameters must be of the same type");
        this.checkExp("multiset[ROW(1,2)] submultiset of multiset[row(3,4)]");
    }

    @Test
    public void testElement() {
        this.checkExpType("element(multiset[1])", "INTEGER NOT NULL");
        this.checkExpType("1.0+element(multiset[1])", "DECIMAL(12, 1) NOT NULL");
        this.checkExpType("element(multiset['1'])", "CHAR(1) NOT NULL");
        this.checkExpType("element(multiset[1e-2])", "DOUBLE NOT NULL");
        this.checkExpType("element(multiset[multiset[cast(null as tinyint)]])", "TINYINT MULTISET NOT NULL");
    }

    @Test
    public void testMemberOf() {
        this.checkExpType("1 member of multiset[1]", "BOOLEAN NOT NULL");
        this.checkWholeExpFails("1 member of multiset['1']", "Cannot compare values of types 'INTEGER', 'CHAR\\(1\\)'");
    }

    @Test
    public void testIsASet() {
        this.checkExp("multiset[1] is a set");
        this.checkExp("multiset['1'] is a set");
        this.checkWholeExpFails("'a' is a set", ".*Cannot apply 'IS A SET' to.*");
    }

    @Test
    public void testCardinality() {
        this.checkExpType("cardinality(multiset[1])", "INTEGER NOT NULL");
        this.checkExpType("cardinality(multiset['1'])", "INTEGER NOT NULL");
        this.checkWholeExpFails("cardinality('a')", "Cannot apply 'CARDINALITY' to arguments of type 'CARDINALITY\\(<CHAR\\(1\\)>\\)'\\. Supported form\\(s\\): 'CARDINALITY\\(<MULTISET>\\)'\n'CARDINALITY\\(<ARRAY>\\)'\n'CARDINALITY\\(<MAP>\\)'");
    }

    @Test
    public void testIntervalTimeUnitEnumeration() {
        Assert.assertEquals((long)0L, (long)TimeUnit.YEAR.ordinal());
        Assert.assertEquals((long)1L, (long)TimeUnit.MONTH.ordinal());
        Assert.assertEquals((long)2L, (long)TimeUnit.DAY.ordinal());
        Assert.assertEquals((long)3L, (long)TimeUnit.HOUR.ordinal());
        Assert.assertEquals((long)4L, (long)TimeUnit.MINUTE.ordinal());
        Assert.assertEquals((long)5L, (long)TimeUnit.SECOND.ordinal());
        boolean b = TimeUnit.YEAR.ordinal() < TimeUnit.MONTH.ordinal() && TimeUnit.MONTH.ordinal() < TimeUnit.DAY.ordinal() && TimeUnit.DAY.ordinal() < TimeUnit.HOUR.ordinal() && TimeUnit.HOUR.ordinal() < TimeUnit.MINUTE.ordinal() && TimeUnit.MINUTE.ordinal() < TimeUnit.SECOND.ordinal();
        Assert.assertTrue((boolean)b);
    }

    @Test
    public void testIntervalMonthsConversion() {
        this.checkIntervalConv("INTERVAL '1' YEAR", "12");
        this.checkIntervalConv("INTERVAL '5' MONTH", "5");
        this.checkIntervalConv("INTERVAL '3-2' YEAR TO MONTH", "38");
        this.checkIntervalConv("INTERVAL '-5-4' YEAR TO MONTH", "-64");
    }

    @Test
    public void testIntervalMillisConversion() {
        this.checkIntervalConv("INTERVAL '1' DAY", "86400000");
        this.checkIntervalConv("INTERVAL '1' HOUR", "3600000");
        this.checkIntervalConv("INTERVAL '1' MINUTE", "60000");
        this.checkIntervalConv("INTERVAL '1' SECOND", "1000");
        this.checkIntervalConv("INTERVAL '1:05' HOUR TO MINUTE", "3900000");
        this.checkIntervalConv("INTERVAL '1:05' MINUTE TO SECOND", "65000");
        this.checkIntervalConv("INTERVAL '1 1' DAY TO HOUR", "90000000");
        this.checkIntervalConv("INTERVAL '1 1:05' DAY TO MINUTE", "90300000");
        this.checkIntervalConv("INTERVAL '1 1:05:03' DAY TO SECOND", "90303000");
        this.checkIntervalConv("INTERVAL '1 1:05:03.12345' DAY TO SECOND", "90303123");
        this.checkIntervalConv("INTERVAL '1.12345' SECOND", "1123");
        this.checkIntervalConv("INTERVAL '1:05.12345' MINUTE TO SECOND", "65123");
        this.checkIntervalConv("INTERVAL '1:05:03' HOUR TO SECOND", "3903000");
        this.checkIntervalConv("INTERVAL '1:05:03.12345' HOUR TO SECOND", "3903123");
    }

    public void subTestIntervalYearPositive() {
        this.checkExpType("INTERVAL '1' YEAR", "INTERVAL YEAR NOT NULL");
        this.checkExpType("INTERVAL '99' YEAR", "INTERVAL YEAR NOT NULL");
        this.checkExpType("INTERVAL '1' YEAR(2)", "INTERVAL YEAR(2) NOT NULL");
        this.checkExpType("INTERVAL '99' YEAR(2)", "INTERVAL YEAR(2) NOT NULL");
        this.checkExpType("INTERVAL '2147483647' YEAR(10)", "INTERVAL YEAR(10) NOT NULL");
        this.checkExpType("INTERVAL '0' YEAR(1)", "INTERVAL YEAR(1) NOT NULL");
        this.checkExpType("INTERVAL '1234' YEAR(4)", "INTERVAL YEAR(4) NOT NULL");
        this.checkExpType("INTERVAL '+1' YEAR", "INTERVAL YEAR NOT NULL");
        this.checkExpType("INTERVAL '-1' YEAR", "INTERVAL YEAR NOT NULL");
        this.checkExpType("INTERVAL +'1' YEAR", "INTERVAL YEAR NOT NULL");
        this.checkExpType("INTERVAL +'+1' YEAR", "INTERVAL YEAR NOT NULL");
        this.checkExpType("INTERVAL +'-1' YEAR", "INTERVAL YEAR NOT NULL");
        this.checkExpType("INTERVAL -'1' YEAR", "INTERVAL YEAR NOT NULL");
        this.checkExpType("INTERVAL -'+1' YEAR", "INTERVAL YEAR NOT NULL");
        this.checkExpType("INTERVAL -'-1' YEAR", "INTERVAL YEAR NOT NULL");
    }

    public void subTestIntervalYearToMonthPositive() {
        this.checkExpType("INTERVAL '1-2' YEAR TO MONTH", "INTERVAL YEAR TO MONTH NOT NULL");
        this.checkExpType("INTERVAL '99-11' YEAR TO MONTH", "INTERVAL YEAR TO MONTH NOT NULL");
        this.checkExpType("INTERVAL '99-0' YEAR TO MONTH", "INTERVAL YEAR TO MONTH NOT NULL");
        this.checkExpType("INTERVAL '1-2' YEAR(2) TO MONTH", "INTERVAL YEAR(2) TO MONTH NOT NULL");
        this.checkExpType("INTERVAL '99-11' YEAR(2) TO MONTH", "INTERVAL YEAR(2) TO MONTH NOT NULL");
        this.checkExpType("INTERVAL '99-0' YEAR(2) TO MONTH", "INTERVAL YEAR(2) TO MONTH NOT NULL");
        this.checkExpType("INTERVAL '2147483647-11' YEAR(10) TO MONTH", "INTERVAL YEAR(10) TO MONTH NOT NULL");
        this.checkExpType("INTERVAL '0-0' YEAR(1) TO MONTH", "INTERVAL YEAR(1) TO MONTH NOT NULL");
        this.checkExpType("INTERVAL '2006-2' YEAR(4) TO MONTH", "INTERVAL YEAR(4) TO MONTH NOT NULL");
        this.checkExpType("INTERVAL '-1-2' YEAR TO MONTH", "INTERVAL YEAR TO MONTH NOT NULL");
        this.checkExpType("INTERVAL '+1-2' YEAR TO MONTH", "INTERVAL YEAR TO MONTH NOT NULL");
        this.checkExpType("INTERVAL +'1-2' YEAR TO MONTH", "INTERVAL YEAR TO MONTH NOT NULL");
        this.checkExpType("INTERVAL +'-1-2' YEAR TO MONTH", "INTERVAL YEAR TO MONTH NOT NULL");
        this.checkExpType("INTERVAL +'+1-2' YEAR TO MONTH", "INTERVAL YEAR TO MONTH NOT NULL");
        this.checkExpType("INTERVAL -'1-2' YEAR TO MONTH", "INTERVAL YEAR TO MONTH NOT NULL");
        this.checkExpType("INTERVAL -'-1-2' YEAR TO MONTH", "INTERVAL YEAR TO MONTH NOT NULL");
        this.checkExpType("INTERVAL -'+1-2' YEAR TO MONTH", "INTERVAL YEAR TO MONTH NOT NULL");
    }

    public void subTestIntervalMonthPositive() {
        this.checkExpType("INTERVAL '1' MONTH", "INTERVAL MONTH NOT NULL");
        this.checkExpType("INTERVAL '99' MONTH", "INTERVAL MONTH NOT NULL");
        this.checkExpType("INTERVAL '1' MONTH(2)", "INTERVAL MONTH(2) NOT NULL");
        this.checkExpType("INTERVAL '99' MONTH(2)", "INTERVAL MONTH(2) NOT NULL");
        this.checkExpType("INTERVAL '2147483647' MONTH(10)", "INTERVAL MONTH(10) NOT NULL");
        this.checkExpType("INTERVAL '0' MONTH(1)", "INTERVAL MONTH(1) NOT NULL");
        this.checkExpType("INTERVAL '1234' MONTH(4)", "INTERVAL MONTH(4) NOT NULL");
        this.checkExpType("INTERVAL '+1' MONTH", "INTERVAL MONTH NOT NULL");
        this.checkExpType("INTERVAL '-1' MONTH", "INTERVAL MONTH NOT NULL");
        this.checkExpType("INTERVAL +'1' MONTH", "INTERVAL MONTH NOT NULL");
        this.checkExpType("INTERVAL +'+1' MONTH", "INTERVAL MONTH NOT NULL");
        this.checkExpType("INTERVAL +'-1' MONTH", "INTERVAL MONTH NOT NULL");
        this.checkExpType("INTERVAL -'1' MONTH", "INTERVAL MONTH NOT NULL");
        this.checkExpType("INTERVAL -'+1' MONTH", "INTERVAL MONTH NOT NULL");
        this.checkExpType("INTERVAL -'-1' MONTH", "INTERVAL MONTH NOT NULL");
    }

    public void subTestIntervalDayPositive() {
        this.checkExpType("INTERVAL '1' DAY", "INTERVAL DAY NOT NULL");
        this.checkExpType("INTERVAL '99' DAY", "INTERVAL DAY NOT NULL");
        this.checkExpType("INTERVAL '1' DAY(2)", "INTERVAL DAY(2) NOT NULL");
        this.checkExpType("INTERVAL '99' DAY(2)", "INTERVAL DAY(2) NOT NULL");
        this.checkExpType("INTERVAL '2147483647' DAY(10)", "INTERVAL DAY(10) NOT NULL");
        this.checkExpType("INTERVAL '0' DAY(1)", "INTERVAL DAY(1) NOT NULL");
        this.checkExpType("INTERVAL '1234' DAY(4)", "INTERVAL DAY(4) NOT NULL");
        this.checkExpType("INTERVAL '+1' DAY", "INTERVAL DAY NOT NULL");
        this.checkExpType("INTERVAL '-1' DAY", "INTERVAL DAY NOT NULL");
        this.checkExpType("INTERVAL +'1' DAY", "INTERVAL DAY NOT NULL");
        this.checkExpType("INTERVAL +'+1' DAY", "INTERVAL DAY NOT NULL");
        this.checkExpType("INTERVAL +'-1' DAY", "INTERVAL DAY NOT NULL");
        this.checkExpType("INTERVAL -'1' DAY", "INTERVAL DAY NOT NULL");
        this.checkExpType("INTERVAL -'+1' DAY", "INTERVAL DAY NOT NULL");
        this.checkExpType("INTERVAL -'-1' DAY", "INTERVAL DAY NOT NULL");
    }

    public void subTestIntervalDayToHourPositive() {
        this.checkExpType("INTERVAL '1 2' DAY TO HOUR", "INTERVAL DAY TO HOUR NOT NULL");
        this.checkExpType("INTERVAL '99 23' DAY TO HOUR", "INTERVAL DAY TO HOUR NOT NULL");
        this.checkExpType("INTERVAL '99 0' DAY TO HOUR", "INTERVAL DAY TO HOUR NOT NULL");
        this.checkExpType("INTERVAL '1 2' DAY(2) TO HOUR", "INTERVAL DAY(2) TO HOUR NOT NULL");
        this.checkExpType("INTERVAL '99 23' DAY(2) TO HOUR", "INTERVAL DAY(2) TO HOUR NOT NULL");
        this.checkExpType("INTERVAL '99 0' DAY(2) TO HOUR", "INTERVAL DAY(2) TO HOUR NOT NULL");
        this.checkExpType("INTERVAL '2147483647 23' DAY(10) TO HOUR", "INTERVAL DAY(10) TO HOUR NOT NULL");
        this.checkExpType("INTERVAL '0 0' DAY(1) TO HOUR", "INTERVAL DAY(1) TO HOUR NOT NULL");
        this.checkExpType("INTERVAL '2345 2' DAY(4) TO HOUR", "INTERVAL DAY(4) TO HOUR NOT NULL");
        this.checkExpType("INTERVAL '-1 2' DAY TO HOUR", "INTERVAL DAY TO HOUR NOT NULL");
        this.checkExpType("INTERVAL '+1 2' DAY TO HOUR", "INTERVAL DAY TO HOUR NOT NULL");
        this.checkExpType("INTERVAL +'1 2' DAY TO HOUR", "INTERVAL DAY TO HOUR NOT NULL");
        this.checkExpType("INTERVAL +'-1 2' DAY TO HOUR", "INTERVAL DAY TO HOUR NOT NULL");
        this.checkExpType("INTERVAL +'+1 2' DAY TO HOUR", "INTERVAL DAY TO HOUR NOT NULL");
        this.checkExpType("INTERVAL -'1 2' DAY TO HOUR", "INTERVAL DAY TO HOUR NOT NULL");
        this.checkExpType("INTERVAL -'-1 2' DAY TO HOUR", "INTERVAL DAY TO HOUR NOT NULL");
        this.checkExpType("INTERVAL -'+1 2' DAY TO HOUR", "INTERVAL DAY TO HOUR NOT NULL");
    }

    public void subTestIntervalDayToMinutePositive() {
        this.checkExpType("INTERVAL '1 2:3' DAY TO MINUTE", "INTERVAL DAY TO MINUTE NOT NULL");
        this.checkExpType("INTERVAL '99 23:59' DAY TO MINUTE", "INTERVAL DAY TO MINUTE NOT NULL");
        this.checkExpType("INTERVAL '99 0:0' DAY TO MINUTE", "INTERVAL DAY TO MINUTE NOT NULL");
        this.checkExpType("INTERVAL '1 2:3' DAY(2) TO MINUTE", "INTERVAL DAY(2) TO MINUTE NOT NULL");
        this.checkExpType("INTERVAL '99 23:59' DAY(2) TO MINUTE", "INTERVAL DAY(2) TO MINUTE NOT NULL");
        this.checkExpType("INTERVAL '99 0:0' DAY(2) TO MINUTE", "INTERVAL DAY(2) TO MINUTE NOT NULL");
        this.checkExpType("INTERVAL '2147483647 23:59' DAY(10) TO MINUTE", "INTERVAL DAY(10) TO MINUTE NOT NULL");
        this.checkExpType("INTERVAL '0 0:0' DAY(1) TO MINUTE", "INTERVAL DAY(1) TO MINUTE NOT NULL");
        this.checkExpType("INTERVAL '2345 6:7' DAY(4) TO MINUTE", "INTERVAL DAY(4) TO MINUTE NOT NULL");
        this.checkExpType("INTERVAL '-1 2:3' DAY TO MINUTE", "INTERVAL DAY TO MINUTE NOT NULL");
        this.checkExpType("INTERVAL '+1 2:3' DAY TO MINUTE", "INTERVAL DAY TO MINUTE NOT NULL");
        this.checkExpType("INTERVAL +'1 2:3' DAY TO MINUTE", "INTERVAL DAY TO MINUTE NOT NULL");
        this.checkExpType("INTERVAL +'-1 2:3' DAY TO MINUTE", "INTERVAL DAY TO MINUTE NOT NULL");
        this.checkExpType("INTERVAL +'+1 2:3' DAY TO MINUTE", "INTERVAL DAY TO MINUTE NOT NULL");
        this.checkExpType("INTERVAL -'1 2:3' DAY TO MINUTE", "INTERVAL DAY TO MINUTE NOT NULL");
        this.checkExpType("INTERVAL -'-1 2:3' DAY TO MINUTE", "INTERVAL DAY TO MINUTE NOT NULL");
        this.checkExpType("INTERVAL -'+1 2:3' DAY TO MINUTE", "INTERVAL DAY TO MINUTE NOT NULL");
    }

    public void subTestIntervalDayToSecondPositive() {
        this.checkExpType("INTERVAL '1 2:3:4' DAY TO SECOND", "INTERVAL DAY TO SECOND NOT NULL");
        this.checkExpType("INTERVAL '99 23:59:59' DAY TO SECOND", "INTERVAL DAY TO SECOND NOT NULL");
        this.checkExpType("INTERVAL '99 0:0:0' DAY TO SECOND", "INTERVAL DAY TO SECOND NOT NULL");
        this.checkExpType("INTERVAL '99 23:59:59.999999' DAY TO SECOND", "INTERVAL DAY TO SECOND NOT NULL");
        this.checkExpType("INTERVAL '99 0:0:0.0' DAY TO SECOND", "INTERVAL DAY TO SECOND NOT NULL");
        this.checkExpType("INTERVAL '1 2:3:4' DAY(2) TO SECOND", "INTERVAL DAY(2) TO SECOND NOT NULL");
        this.checkExpType("INTERVAL '99 23:59:59' DAY(2) TO SECOND", "INTERVAL DAY(2) TO SECOND NOT NULL");
        this.checkExpType("INTERVAL '99 0:0:0' DAY(2) TO SECOND", "INTERVAL DAY(2) TO SECOND NOT NULL");
        this.checkExpType("INTERVAL '99 23:59:59.999999' DAY TO SECOND(6)", "INTERVAL DAY TO SECOND(6) NOT NULL");
        this.checkExpType("INTERVAL '99 0:0:0.0' DAY TO SECOND(6)", "INTERVAL DAY TO SECOND(6) NOT NULL");
        this.checkExpType("INTERVAL '2147483647 23:59:59' DAY(10) TO SECOND", "INTERVAL DAY(10) TO SECOND NOT NULL");
        this.checkExpType("INTERVAL '2147483647 23:59:59.999999999' DAY(10) TO SECOND(9)", "INTERVAL DAY(10) TO SECOND(9) NOT NULL");
        this.checkExpType("INTERVAL '0 0:0:0' DAY(1) TO SECOND", "INTERVAL DAY(1) TO SECOND NOT NULL");
        this.checkExpType("INTERVAL '0 0:0:0.0' DAY(1) TO SECOND(1)", "INTERVAL DAY(1) TO SECOND(1) NOT NULL");
        this.checkExpType("INTERVAL '2345 6:7:8' DAY(4) TO SECOND", "INTERVAL DAY(4) TO SECOND NOT NULL");
        this.checkExpType("INTERVAL '2345 6:7:8.9012' DAY(4) TO SECOND(4)", "INTERVAL DAY(4) TO SECOND(4) NOT NULL");
        this.checkExpType("INTERVAL '-1 2:3:4' DAY TO SECOND", "INTERVAL DAY TO SECOND NOT NULL");
        this.checkExpType("INTERVAL '+1 2:3:4' DAY TO SECOND", "INTERVAL DAY TO SECOND NOT NULL");
        this.checkExpType("INTERVAL +'1 2:3:4' DAY TO SECOND", "INTERVAL DAY TO SECOND NOT NULL");
        this.checkExpType("INTERVAL +'-1 2:3:4' DAY TO SECOND", "INTERVAL DAY TO SECOND NOT NULL");
        this.checkExpType("INTERVAL +'+1 2:3:4' DAY TO SECOND", "INTERVAL DAY TO SECOND NOT NULL");
        this.checkExpType("INTERVAL -'1 2:3:4' DAY TO SECOND", "INTERVAL DAY TO SECOND NOT NULL");
        this.checkExpType("INTERVAL -'-1 2:3:4' DAY TO SECOND", "INTERVAL DAY TO SECOND NOT NULL");
        this.checkExpType("INTERVAL -'+1 2:3:4' DAY TO SECOND", "INTERVAL DAY TO SECOND NOT NULL");
    }

    public void subTestIntervalHourPositive() {
        this.checkExpType("INTERVAL '1' HOUR", "INTERVAL HOUR NOT NULL");
        this.checkExpType("INTERVAL '99' HOUR", "INTERVAL HOUR NOT NULL");
        this.checkExpType("INTERVAL '1' HOUR(2)", "INTERVAL HOUR(2) NOT NULL");
        this.checkExpType("INTERVAL '99' HOUR(2)", "INTERVAL HOUR(2) NOT NULL");
        this.checkExpType("INTERVAL '2147483647' HOUR(10)", "INTERVAL HOUR(10) NOT NULL");
        this.checkExpType("INTERVAL '0' HOUR(1)", "INTERVAL HOUR(1) NOT NULL");
        this.checkExpType("INTERVAL '1234' HOUR(4)", "INTERVAL HOUR(4) NOT NULL");
        this.checkExpType("INTERVAL '+1' HOUR", "INTERVAL HOUR NOT NULL");
        this.checkExpType("INTERVAL '-1' HOUR", "INTERVAL HOUR NOT NULL");
        this.checkExpType("INTERVAL +'1' HOUR", "INTERVAL HOUR NOT NULL");
        this.checkExpType("INTERVAL +'+1' HOUR", "INTERVAL HOUR NOT NULL");
        this.checkExpType("INTERVAL +'-1' HOUR", "INTERVAL HOUR NOT NULL");
        this.checkExpType("INTERVAL -'1' HOUR", "INTERVAL HOUR NOT NULL");
        this.checkExpType("INTERVAL -'+1' HOUR", "INTERVAL HOUR NOT NULL");
        this.checkExpType("INTERVAL -'-1' HOUR", "INTERVAL HOUR NOT NULL");
    }

    public void subTestIntervalHourToMinutePositive() {
        this.checkExpType("INTERVAL '2:3' HOUR TO MINUTE", "INTERVAL HOUR TO MINUTE NOT NULL");
        this.checkExpType("INTERVAL '23:59' HOUR TO MINUTE", "INTERVAL HOUR TO MINUTE NOT NULL");
        this.checkExpType("INTERVAL '99:0' HOUR TO MINUTE", "INTERVAL HOUR TO MINUTE NOT NULL");
        this.checkExpType("INTERVAL '2:3' HOUR(2) TO MINUTE", "INTERVAL HOUR(2) TO MINUTE NOT NULL");
        this.checkExpType("INTERVAL '23:59' HOUR(2) TO MINUTE", "INTERVAL HOUR(2) TO MINUTE NOT NULL");
        this.checkExpType("INTERVAL '99:0' HOUR(2) TO MINUTE", "INTERVAL HOUR(2) TO MINUTE NOT NULL");
        this.checkExpType("INTERVAL '2147483647:59' HOUR(10) TO MINUTE", "INTERVAL HOUR(10) TO MINUTE NOT NULL");
        this.checkExpType("INTERVAL '0:0' HOUR(1) TO MINUTE", "INTERVAL HOUR(1) TO MINUTE NOT NULL");
        this.checkExpType("INTERVAL '2345:7' HOUR(4) TO MINUTE", "INTERVAL HOUR(4) TO MINUTE NOT NULL");
        this.checkExpType("INTERVAL '-1:3' HOUR TO MINUTE", "INTERVAL HOUR TO MINUTE NOT NULL");
        this.checkExpType("INTERVAL '+1:3' HOUR TO MINUTE", "INTERVAL HOUR TO MINUTE NOT NULL");
        this.checkExpType("INTERVAL +'2:3' HOUR TO MINUTE", "INTERVAL HOUR TO MINUTE NOT NULL");
        this.checkExpType("INTERVAL +'-2:3' HOUR TO MINUTE", "INTERVAL HOUR TO MINUTE NOT NULL");
        this.checkExpType("INTERVAL +'+2:3' HOUR TO MINUTE", "INTERVAL HOUR TO MINUTE NOT NULL");
        this.checkExpType("INTERVAL -'2:3' HOUR TO MINUTE", "INTERVAL HOUR TO MINUTE NOT NULL");
        this.checkExpType("INTERVAL -'-2:3' HOUR TO MINUTE", "INTERVAL HOUR TO MINUTE NOT NULL");
        this.checkExpType("INTERVAL -'+2:3' HOUR TO MINUTE", "INTERVAL HOUR TO MINUTE NOT NULL");
    }

    public void subTestIntervalHourToSecondPositive() {
        this.checkExpType("INTERVAL '2:3:4' HOUR TO SECOND", "INTERVAL HOUR TO SECOND NOT NULL");
        this.checkExpType("INTERVAL '23:59:59' HOUR TO SECOND", "INTERVAL HOUR TO SECOND NOT NULL");
        this.checkExpType("INTERVAL '99:0:0' HOUR TO SECOND", "INTERVAL HOUR TO SECOND NOT NULL");
        this.checkExpType("INTERVAL '23:59:59.999999' HOUR TO SECOND", "INTERVAL HOUR TO SECOND NOT NULL");
        this.checkExpType("INTERVAL '99:0:0.0' HOUR TO SECOND", "INTERVAL HOUR TO SECOND NOT NULL");
        this.checkExpType("INTERVAL '2:3:4' HOUR(2) TO SECOND", "INTERVAL HOUR(2) TO SECOND NOT NULL");
        this.checkExpType("INTERVAL '99:59:59' HOUR(2) TO SECOND", "INTERVAL HOUR(2) TO SECOND NOT NULL");
        this.checkExpType("INTERVAL '99:0:0' HOUR(2) TO SECOND", "INTERVAL HOUR(2) TO SECOND NOT NULL");
        this.checkExpType("INTERVAL '99:59:59.999999' HOUR TO SECOND(6)", "INTERVAL HOUR TO SECOND(6) NOT NULL");
        this.checkExpType("INTERVAL '99:0:0.0' HOUR TO SECOND(6)", "INTERVAL HOUR TO SECOND(6) NOT NULL");
        this.checkExpType("INTERVAL '2147483647:59:59' HOUR(10) TO SECOND", "INTERVAL HOUR(10) TO SECOND NOT NULL");
        this.checkExpType("INTERVAL '2147483647:59:59.999999999' HOUR(10) TO SECOND(9)", "INTERVAL HOUR(10) TO SECOND(9) NOT NULL");
        this.checkExpType("INTERVAL '0:0:0' HOUR(1) TO SECOND", "INTERVAL HOUR(1) TO SECOND NOT NULL");
        this.checkExpType("INTERVAL '0:0:0.0' HOUR(1) TO SECOND(1)", "INTERVAL HOUR(1) TO SECOND(1) NOT NULL");
        this.checkExpType("INTERVAL '2345:7:8' HOUR(4) TO SECOND", "INTERVAL HOUR(4) TO SECOND NOT NULL");
        this.checkExpType("INTERVAL '2345:7:8.9012' HOUR(4) TO SECOND(4)", "INTERVAL HOUR(4) TO SECOND(4) NOT NULL");
        this.checkExpType("INTERVAL '-2:3:4' HOUR TO SECOND", "INTERVAL HOUR TO SECOND NOT NULL");
        this.checkExpType("INTERVAL '+2:3:4' HOUR TO SECOND", "INTERVAL HOUR TO SECOND NOT NULL");
        this.checkExpType("INTERVAL +'2:3:4' HOUR TO SECOND", "INTERVAL HOUR TO SECOND NOT NULL");
        this.checkExpType("INTERVAL +'-2:3:4' HOUR TO SECOND", "INTERVAL HOUR TO SECOND NOT NULL");
        this.checkExpType("INTERVAL +'+2:3:4' HOUR TO SECOND", "INTERVAL HOUR TO SECOND NOT NULL");
        this.checkExpType("INTERVAL -'2:3:4' HOUR TO SECOND", "INTERVAL HOUR TO SECOND NOT NULL");
        this.checkExpType("INTERVAL -'-2:3:4' HOUR TO SECOND", "INTERVAL HOUR TO SECOND NOT NULL");
        this.checkExpType("INTERVAL -'+2:3:4' HOUR TO SECOND", "INTERVAL HOUR TO SECOND NOT NULL");
    }

    public void subTestIntervalMinutePositive() {
        this.checkExpType("INTERVAL '1' MINUTE", "INTERVAL MINUTE NOT NULL");
        this.checkExpType("INTERVAL '99' MINUTE", "INTERVAL MINUTE NOT NULL");
        this.checkExpType("INTERVAL '1' MINUTE(2)", "INTERVAL MINUTE(2) NOT NULL");
        this.checkExpType("INTERVAL '99' MINUTE(2)", "INTERVAL MINUTE(2) NOT NULL");
        this.checkExpType("INTERVAL '2147483647' MINUTE(10)", "INTERVAL MINUTE(10) NOT NULL");
        this.checkExpType("INTERVAL '0' MINUTE(1)", "INTERVAL MINUTE(1) NOT NULL");
        this.checkExpType("INTERVAL '1234' MINUTE(4)", "INTERVAL MINUTE(4) NOT NULL");
        this.checkExpType("INTERVAL '+1' MINUTE", "INTERVAL MINUTE NOT NULL");
        this.checkExpType("INTERVAL '-1' MINUTE", "INTERVAL MINUTE NOT NULL");
        this.checkExpType("INTERVAL +'1' MINUTE", "INTERVAL MINUTE NOT NULL");
        this.checkExpType("INTERVAL +'+1' MINUTE", "INTERVAL MINUTE NOT NULL");
        this.checkExpType("INTERVAL +'-1' MINUTE", "INTERVAL MINUTE NOT NULL");
        this.checkExpType("INTERVAL -'1' MINUTE", "INTERVAL MINUTE NOT NULL");
        this.checkExpType("INTERVAL -'+1' MINUTE", "INTERVAL MINUTE NOT NULL");
        this.checkExpType("INTERVAL -'-1' MINUTE", "INTERVAL MINUTE NOT NULL");
    }

    public void subTestIntervalMinuteToSecondPositive() {
        this.checkExpType("INTERVAL '2:4' MINUTE TO SECOND", "INTERVAL MINUTE TO SECOND NOT NULL");
        this.checkExpType("INTERVAL '59:59' MINUTE TO SECOND", "INTERVAL MINUTE TO SECOND NOT NULL");
        this.checkExpType("INTERVAL '99:0' MINUTE TO SECOND", "INTERVAL MINUTE TO SECOND NOT NULL");
        this.checkExpType("INTERVAL '59:59.999999' MINUTE TO SECOND", "INTERVAL MINUTE TO SECOND NOT NULL");
        this.checkExpType("INTERVAL '99:0.0' MINUTE TO SECOND", "INTERVAL MINUTE TO SECOND NOT NULL");
        this.checkExpType("INTERVAL '2:4' MINUTE(2) TO SECOND", "INTERVAL MINUTE(2) TO SECOND NOT NULL");
        this.checkExpType("INTERVAL '99:59' MINUTE(2) TO SECOND", "INTERVAL MINUTE(2) TO SECOND NOT NULL");
        this.checkExpType("INTERVAL '99:0' MINUTE(2) TO SECOND", "INTERVAL MINUTE(2) TO SECOND NOT NULL");
        this.checkExpType("INTERVAL '99:59.999999' MINUTE TO SECOND(6)", "INTERVAL MINUTE TO SECOND(6) NOT NULL");
        this.checkExpType("INTERVAL '99:0.0' MINUTE TO SECOND(6)", "INTERVAL MINUTE TO SECOND(6) NOT NULL");
        this.checkExpType("INTERVAL '2147483647:59' MINUTE(10) TO SECOND", "INTERVAL MINUTE(10) TO SECOND NOT NULL");
        this.checkExpType("INTERVAL '2147483647:59.999999999' MINUTE(10) TO SECOND(9)", "INTERVAL MINUTE(10) TO SECOND(9) NOT NULL");
        this.checkExpType("INTERVAL '0:0' MINUTE(1) TO SECOND", "INTERVAL MINUTE(1) TO SECOND NOT NULL");
        this.checkExpType("INTERVAL '0:0.0' MINUTE(1) TO SECOND(1)", "INTERVAL MINUTE(1) TO SECOND(1) NOT NULL");
        this.checkExpType("INTERVAL '2345:8' MINUTE(4) TO SECOND", "INTERVAL MINUTE(4) TO SECOND NOT NULL");
        this.checkExpType("INTERVAL '2345:7.8901' MINUTE(4) TO SECOND(4)", "INTERVAL MINUTE(4) TO SECOND(4) NOT NULL");
        this.checkExpType("INTERVAL '-3:4' MINUTE TO SECOND", "INTERVAL MINUTE TO SECOND NOT NULL");
        this.checkExpType("INTERVAL '+3:4' MINUTE TO SECOND", "INTERVAL MINUTE TO SECOND NOT NULL");
        this.checkExpType("INTERVAL +'3:4' MINUTE TO SECOND", "INTERVAL MINUTE TO SECOND NOT NULL");
        this.checkExpType("INTERVAL +'-3:4' MINUTE TO SECOND", "INTERVAL MINUTE TO SECOND NOT NULL");
        this.checkExpType("INTERVAL +'+3:4' MINUTE TO SECOND", "INTERVAL MINUTE TO SECOND NOT NULL");
        this.checkExpType("INTERVAL -'3:4' MINUTE TO SECOND", "INTERVAL MINUTE TO SECOND NOT NULL");
        this.checkExpType("INTERVAL -'-3:4' MINUTE TO SECOND", "INTERVAL MINUTE TO SECOND NOT NULL");
        this.checkExpType("INTERVAL -'+3:4' MINUTE TO SECOND", "INTERVAL MINUTE TO SECOND NOT NULL");
    }

    public void subTestIntervalSecondPositive() {
        this.checkExpType("INTERVAL '1' SECOND", "INTERVAL SECOND NOT NULL");
        this.checkExpType("INTERVAL '99' SECOND", "INTERVAL SECOND NOT NULL");
        this.checkExpType("INTERVAL '1' SECOND(2)", "INTERVAL SECOND(2) NOT NULL");
        this.checkExpType("INTERVAL '99' SECOND(2)", "INTERVAL SECOND(2) NOT NULL");
        this.checkExpType("INTERVAL '1' SECOND(2, 6)", "INTERVAL SECOND(2, 6) NOT NULL");
        this.checkExpType("INTERVAL '99' SECOND(2, 6)", "INTERVAL SECOND(2, 6) NOT NULL");
        this.checkExpType("INTERVAL '2147483647' SECOND(10)", "INTERVAL SECOND(10) NOT NULL");
        this.checkExpType("INTERVAL '2147483647.999999999' SECOND(10, 9)", "INTERVAL SECOND(10, 9) NOT NULL");
        this.checkExpType("INTERVAL '0' SECOND(1)", "INTERVAL SECOND(1) NOT NULL");
        this.checkExpType("INTERVAL '0.0' SECOND(1, 1)", "INTERVAL SECOND(1, 1) NOT NULL");
        this.checkExpType("INTERVAL '1234' SECOND(4)", "INTERVAL SECOND(4) NOT NULL");
        this.checkExpType("INTERVAL '1234.56789' SECOND(4, 5)", "INTERVAL SECOND(4, 5) NOT NULL");
        this.checkExpType("INTERVAL '+1' SECOND", "INTERVAL SECOND NOT NULL");
        this.checkExpType("INTERVAL '-1' SECOND", "INTERVAL SECOND NOT NULL");
        this.checkExpType("INTERVAL +'1' SECOND", "INTERVAL SECOND NOT NULL");
        this.checkExpType("INTERVAL +'+1' SECOND", "INTERVAL SECOND NOT NULL");
        this.checkExpType("INTERVAL +'-1' SECOND", "INTERVAL SECOND NOT NULL");
        this.checkExpType("INTERVAL -'1' SECOND", "INTERVAL SECOND NOT NULL");
        this.checkExpType("INTERVAL -'+1' SECOND", "INTERVAL SECOND NOT NULL");
        this.checkExpType("INTERVAL -'-1' SECOND", "INTERVAL SECOND NOT NULL");
    }

    public void subTestIntervalYearNegative() {
        this.checkWholeExpFails("INTERVAL '-' YEAR", "Illegal interval literal format '-' for INTERVAL YEAR.*");
        this.checkWholeExpFails("INTERVAL '1-2' YEAR", "Illegal interval literal format '1-2' for INTERVAL YEAR.*");
        this.checkWholeExpFails("INTERVAL '1.2' YEAR", "Illegal interval literal format '1.2' for INTERVAL YEAR.*");
        this.checkWholeExpFails("INTERVAL '1 2' YEAR", "Illegal interval literal format '1 2' for INTERVAL YEAR.*");
        this.checkWholeExpFails("INTERVAL '1-2' YEAR(2)", "Illegal interval literal format '1-2' for INTERVAL YEAR\\(2\\)");
        this.checkWholeExpFails("INTERVAL 'bogus text' YEAR", "Illegal interval literal format 'bogus text' for INTERVAL YEAR.*");
        this.checkWholeExpFails("INTERVAL '--1' YEAR", "Illegal interval literal format '--1' for INTERVAL YEAR.*");
        this.checkWholeExpFails("INTERVAL '100' YEAR", "Interval field value 100 exceeds precision of YEAR\\(2\\) field.*");
        this.checkWholeExpFails("INTERVAL '100' YEAR(2)", "Interval field value 100 exceeds precision of YEAR\\(2\\) field.*");
        this.checkWholeExpFails("INTERVAL '1000' YEAR(3)", "Interval field value 1,000 exceeds precision of YEAR\\(3\\) field.*");
        this.checkWholeExpFails("INTERVAL '-1000' YEAR(3)", "Interval field value -1,000 exceeds precision of YEAR\\(3\\) field.*");
        this.checkWholeExpFails("INTERVAL '2147483648' YEAR(10)", "Interval field value 2,147,483,648 exceeds precision of YEAR\\(10\\) field.*");
        this.checkWholeExpFails("INTERVAL '-2147483648' YEAR(10)", "Interval field value -2,147,483,648 exceeds precision of YEAR\\(10\\) field");
        this.checkExpFails("INTERVAL '1' YEAR(11^)^", "Interval leading field precision '11' out of range for INTERVAL YEAR\\(11\\)");
        this.checkExpFails("INTERVAL '0' YEAR(0^)^", "Interval leading field precision '0' out of range for INTERVAL YEAR\\(0\\)");
    }

    public void subTestIntervalYearToMonthNegative() {
        this.checkWholeExpFails("INTERVAL '-' YEAR TO MONTH", "Illegal interval literal format '-' for INTERVAL YEAR TO MONTH");
        this.checkWholeExpFails("INTERVAL '1' YEAR TO MONTH", "Illegal interval literal format '1' for INTERVAL YEAR TO MONTH");
        this.checkWholeExpFails("INTERVAL '1:2' YEAR TO MONTH", "Illegal interval literal format '1:2' for INTERVAL YEAR TO MONTH");
        this.checkWholeExpFails("INTERVAL '1.2' YEAR TO MONTH", "Illegal interval literal format '1.2' for INTERVAL YEAR TO MONTH");
        this.checkWholeExpFails("INTERVAL '1 2' YEAR TO MONTH", "Illegal interval literal format '1 2' for INTERVAL YEAR TO MONTH");
        this.checkWholeExpFails("INTERVAL '1:2' YEAR(2) TO MONTH", "Illegal interval literal format '1:2' for INTERVAL YEAR\\(2\\) TO MONTH");
        this.checkWholeExpFails("INTERVAL 'bogus text' YEAR TO MONTH", "Illegal interval literal format 'bogus text' for INTERVAL YEAR TO MONTH");
        this.checkWholeExpFails("INTERVAL '--1-2' YEAR TO MONTH", "Illegal interval literal format '--1-2' for INTERVAL YEAR TO MONTH");
        this.checkWholeExpFails("INTERVAL '1--2' YEAR TO MONTH", "Illegal interval literal format '1--2' for INTERVAL YEAR TO MONTH");
        this.checkWholeExpFails("INTERVAL '100-0' YEAR TO MONTH", "Interval field value 100 exceeds precision of YEAR\\(2\\) field.*");
        this.checkWholeExpFails("INTERVAL '100-0' YEAR(2) TO MONTH", "Interval field value 100 exceeds precision of YEAR\\(2\\) field.*");
        this.checkWholeExpFails("INTERVAL '1000-0' YEAR(3) TO MONTH", "Interval field value 1,000 exceeds precision of YEAR\\(3\\) field.*");
        this.checkWholeExpFails("INTERVAL '-1000-0' YEAR(3) TO MONTH", "Interval field value -1,000 exceeds precision of YEAR\\(3\\) field.*");
        this.checkWholeExpFails("INTERVAL '2147483648-0' YEAR(10) TO MONTH", "Interval field value 2,147,483,648 exceeds precision of YEAR\\(10\\) field.*");
        this.checkWholeExpFails("INTERVAL '-2147483648-0' YEAR(10) TO MONTH", "Interval field value -2,147,483,648 exceeds precision of YEAR\\(10\\) field.*");
        this.checkWholeExpFails("INTERVAL '1-12' YEAR TO MONTH", "Illegal interval literal format '1-12' for INTERVAL YEAR TO MONTH.*");
        this.checkExpFails("INTERVAL '1-1' YEAR(11) TO ^MONTH^", "Interval leading field precision '11' out of range for INTERVAL YEAR\\(11\\) TO MONTH");
        this.checkExpFails("INTERVAL '0-0' YEAR(0) TO ^MONTH^", "Interval leading field precision '0' out of range for INTERVAL YEAR\\(0\\) TO MONTH");
    }

    public void subTestIntervalMonthNegative() {
        this.checkWholeExpFails("INTERVAL '-' MONTH", "Illegal interval literal format '-' for INTERVAL MONTH.*");
        this.checkWholeExpFails("INTERVAL '1-2' MONTH", "Illegal interval literal format '1-2' for INTERVAL MONTH.*");
        this.checkWholeExpFails("INTERVAL '1.2' MONTH", "Illegal interval literal format '1.2' for INTERVAL MONTH.*");
        this.checkWholeExpFails("INTERVAL '1 2' MONTH", "Illegal interval literal format '1 2' for INTERVAL MONTH.*");
        this.checkWholeExpFails("INTERVAL '1-2' MONTH(2)", "Illegal interval literal format '1-2' for INTERVAL MONTH\\(2\\)");
        this.checkWholeExpFails("INTERVAL 'bogus text' MONTH", "Illegal interval literal format 'bogus text' for INTERVAL MONTH.*");
        this.checkWholeExpFails("INTERVAL '--1' MONTH", "Illegal interval literal format '--1' for INTERVAL MONTH.*");
        this.checkWholeExpFails("INTERVAL '100' MONTH", "Interval field value 100 exceeds precision of MONTH\\(2\\) field.*");
        this.checkWholeExpFails("INTERVAL '100' MONTH(2)", "Interval field value 100 exceeds precision of MONTH\\(2\\) field.*");
        this.checkWholeExpFails("INTERVAL '1000' MONTH(3)", "Interval field value 1,000 exceeds precision of MONTH\\(3\\) field.*");
        this.checkWholeExpFails("INTERVAL '-1000' MONTH(3)", "Interval field value -1,000 exceeds precision of MONTH\\(3\\) field.*");
        this.checkWholeExpFails("INTERVAL '2147483648' MONTH(10)", "Interval field value 2,147,483,648 exceeds precision of MONTH\\(10\\) field.*");
        this.checkWholeExpFails("INTERVAL '-2147483648' MONTH(10)", "Interval field value -2,147,483,648 exceeds precision of MONTH\\(10\\) field.*");
        this.checkExpFails("INTERVAL '1' MONTH(11^)^", "Interval leading field precision '11' out of range for INTERVAL MONTH\\(11\\)");
        this.checkExpFails("INTERVAL '0' MONTH(0^)^", "Interval leading field precision '0' out of range for INTERVAL MONTH\\(0\\)");
    }

    public void subTestIntervalDayNegative() {
        this.checkWholeExpFails("INTERVAL '-' DAY", "Illegal interval literal format '-' for INTERVAL DAY.*");
        this.checkWholeExpFails("INTERVAL '1-2' DAY", "Illegal interval literal format '1-2' for INTERVAL DAY.*");
        this.checkWholeExpFails("INTERVAL '1.2' DAY", "Illegal interval literal format '1.2' for INTERVAL DAY.*");
        this.checkWholeExpFails("INTERVAL '1 2' DAY", "Illegal interval literal format '1 2' for INTERVAL DAY.*");
        this.checkWholeExpFails("INTERVAL '1:2' DAY", "Illegal interval literal format '1:2' for INTERVAL DAY.*");
        this.checkWholeExpFails("INTERVAL '1-2' DAY(2)", "Illegal interval literal format '1-2' for INTERVAL DAY\\(2\\)");
        this.checkWholeExpFails("INTERVAL 'bogus text' DAY", "Illegal interval literal format 'bogus text' for INTERVAL DAY.*");
        this.checkWholeExpFails("INTERVAL '--1' DAY", "Illegal interval literal format '--1' for INTERVAL DAY.*");
        this.checkWholeExpFails("INTERVAL '100' DAY", "Interval field value 100 exceeds precision of DAY\\(2\\) field.*");
        this.checkWholeExpFails("INTERVAL '100' DAY(2)", "Interval field value 100 exceeds precision of DAY\\(2\\) field.*");
        this.checkWholeExpFails("INTERVAL '1000' DAY(3)", "Interval field value 1,000 exceeds precision of DAY\\(3\\) field.*");
        this.checkWholeExpFails("INTERVAL '-1000' DAY(3)", "Interval field value -1,000 exceeds precision of DAY\\(3\\) field.*");
        this.checkWholeExpFails("INTERVAL '2147483648' DAY(10)", "Interval field value 2,147,483,648 exceeds precision of DAY\\(10\\) field.*");
        this.checkWholeExpFails("INTERVAL '-2147483648' DAY(10)", "Interval field value -2,147,483,648 exceeds precision of DAY\\(10\\) field.*");
        this.checkExpFails("INTERVAL '1' DAY(11^)^", "Interval leading field precision '11' out of range for INTERVAL DAY\\(11\\)");
        this.checkExpFails("INTERVAL '0' DAY(0^)^", "Interval leading field precision '0' out of range for INTERVAL DAY\\(0\\)");
    }

    public void subTestIntervalDayToHourNegative() {
        this.checkWholeExpFails("INTERVAL '-' DAY TO HOUR", "Illegal interval literal format '-' for INTERVAL DAY TO HOUR");
        this.checkWholeExpFails("INTERVAL '1' DAY TO HOUR", "Illegal interval literal format '1' for INTERVAL DAY TO HOUR");
        this.checkWholeExpFails("INTERVAL '1:2' DAY TO HOUR", "Illegal interval literal format '1:2' for INTERVAL DAY TO HOUR");
        this.checkWholeExpFails("INTERVAL '1.2' DAY TO HOUR", "Illegal interval literal format '1.2' for INTERVAL DAY TO HOUR");
        this.checkWholeExpFails("INTERVAL '1 x' DAY TO HOUR", "Illegal interval literal format '1 x' for INTERVAL DAY TO HOUR");
        this.checkWholeExpFails("INTERVAL ' ' DAY TO HOUR", "Illegal interval literal format ' ' for INTERVAL DAY TO HOUR");
        this.checkWholeExpFails("INTERVAL '1:2' DAY(2) TO HOUR", "Illegal interval literal format '1:2' for INTERVAL DAY\\(2\\) TO HOUR");
        this.checkWholeExpFails("INTERVAL 'bogus text' DAY TO HOUR", "Illegal interval literal format 'bogus text' for INTERVAL DAY TO HOUR");
        this.checkWholeExpFails("INTERVAL '--1 1' DAY TO HOUR", "Illegal interval literal format '--1 1' for INTERVAL DAY TO HOUR");
        this.checkWholeExpFails("INTERVAL '1 -1' DAY TO HOUR", "Illegal interval literal format '1 -1' for INTERVAL DAY TO HOUR");
        this.checkWholeExpFails("INTERVAL '100 0' DAY TO HOUR", "Interval field value 100 exceeds precision of DAY\\(2\\) field.*");
        this.checkWholeExpFails("INTERVAL '100 0' DAY(2) TO HOUR", "Interval field value 100 exceeds precision of DAY\\(2\\) field.*");
        this.checkWholeExpFails("INTERVAL '1000 0' DAY(3) TO HOUR", "Interval field value 1,000 exceeds precision of DAY\\(3\\) field.*");
        this.checkWholeExpFails("INTERVAL '-1000 0' DAY(3) TO HOUR", "Interval field value -1,000 exceeds precision of DAY\\(3\\) field.*");
        this.checkWholeExpFails("INTERVAL '2147483648 0' DAY(10) TO HOUR", "Interval field value 2,147,483,648 exceeds precision of DAY\\(10\\) field.*");
        this.checkWholeExpFails("INTERVAL '-2147483648 0' DAY(10) TO HOUR", "Interval field value -2,147,483,648 exceeds precision of DAY\\(10\\) field.*");
        this.checkWholeExpFails("INTERVAL '1 24' DAY TO HOUR", "Illegal interval literal format '1 24' for INTERVAL DAY TO HOUR.*");
        this.checkExpFails("INTERVAL '1 1' DAY(11) TO ^HOUR^", "Interval leading field precision '11' out of range for INTERVAL DAY\\(11\\) TO HOUR");
        this.checkExpFails("INTERVAL '0 0' DAY(0) TO ^HOUR^", "Interval leading field precision '0' out of range for INTERVAL DAY\\(0\\) TO HOUR");
    }

    public void subTestIntervalDayToMinuteNegative() {
        this.checkWholeExpFails("INTERVAL ' :' DAY TO MINUTE", "Illegal interval literal format ' :' for INTERVAL DAY TO MINUTE");
        this.checkWholeExpFails("INTERVAL '1' DAY TO MINUTE", "Illegal interval literal format '1' for INTERVAL DAY TO MINUTE");
        this.checkWholeExpFails("INTERVAL '1 2' DAY TO MINUTE", "Illegal interval literal format '1 2' for INTERVAL DAY TO MINUTE");
        this.checkWholeExpFails("INTERVAL '1:2' DAY TO MINUTE", "Illegal interval literal format '1:2' for INTERVAL DAY TO MINUTE");
        this.checkWholeExpFails("INTERVAL '1.2' DAY TO MINUTE", "Illegal interval literal format '1.2' for INTERVAL DAY TO MINUTE");
        this.checkWholeExpFails("INTERVAL 'x 1:1' DAY TO MINUTE", "Illegal interval literal format 'x 1:1' for INTERVAL DAY TO MINUTE");
        this.checkWholeExpFails("INTERVAL '1 x:1' DAY TO MINUTE", "Illegal interval literal format '1 x:1' for INTERVAL DAY TO MINUTE");
        this.checkWholeExpFails("INTERVAL '1 1:x' DAY TO MINUTE", "Illegal interval literal format '1 1:x' for INTERVAL DAY TO MINUTE");
        this.checkWholeExpFails("INTERVAL '1 1:2:3' DAY TO MINUTE", "Illegal interval literal format '1 1:2:3' for INTERVAL DAY TO MINUTE");
        this.checkWholeExpFails("INTERVAL '1 1:1:1.2' DAY TO MINUTE", "Illegal interval literal format '1 1:1:1.2' for INTERVAL DAY TO MINUTE");
        this.checkWholeExpFails("INTERVAL '1 1:2:3' DAY(2) TO MINUTE", "Illegal interval literal format '1 1:2:3' for INTERVAL DAY\\(2\\) TO MINUTE");
        this.checkWholeExpFails("INTERVAL '1 1' DAY(2) TO MINUTE", "Illegal interval literal format '1 1' for INTERVAL DAY\\(2\\) TO MINUTE");
        this.checkWholeExpFails("INTERVAL 'bogus text' DAY TO MINUTE", "Illegal interval literal format 'bogus text' for INTERVAL DAY TO MINUTE");
        this.checkWholeExpFails("INTERVAL '--1 1:1' DAY TO MINUTE", "Illegal interval literal format '--1 1:1' for INTERVAL DAY TO MINUTE");
        this.checkWholeExpFails("INTERVAL '1 -1:1' DAY TO MINUTE", "Illegal interval literal format '1 -1:1' for INTERVAL DAY TO MINUTE");
        this.checkWholeExpFails("INTERVAL '1 1:-1' DAY TO MINUTE", "Illegal interval literal format '1 1:-1' for INTERVAL DAY TO MINUTE");
        this.checkWholeExpFails("INTERVAL '100 0:0' DAY TO MINUTE", "Interval field value 100 exceeds precision of DAY\\(2\\) field.*");
        this.checkWholeExpFails("INTERVAL '100 0:0' DAY(2) TO MINUTE", "Interval field value 100 exceeds precision of DAY\\(2\\) field.*");
        this.checkWholeExpFails("INTERVAL '1000 0:0' DAY(3) TO MINUTE", "Interval field value 1,000 exceeds precision of DAY\\(3\\) field.*");
        this.checkWholeExpFails("INTERVAL '-1000 0:0' DAY(3) TO MINUTE", "Interval field value -1,000 exceeds precision of DAY\\(3\\) field.*");
        this.checkWholeExpFails("INTERVAL '2147483648 0:0' DAY(10) TO MINUTE", "Interval field value 2,147,483,648 exceeds precision of DAY\\(10\\) field.*");
        this.checkWholeExpFails("INTERVAL '-2147483648 0:0' DAY(10) TO MINUTE", "Interval field value -2,147,483,648 exceeds precision of DAY\\(10\\) field.*");
        this.checkWholeExpFails("INTERVAL '1 24:1' DAY TO MINUTE", "Illegal interval literal format '1 24:1' for INTERVAL DAY TO MINUTE.*");
        this.checkWholeExpFails("INTERVAL '1 1:60' DAY TO MINUTE", "Illegal interval literal format '1 1:60' for INTERVAL DAY TO MINUTE.*");
        this.checkExpFails("INTERVAL '1 1:1' DAY(11) TO ^MINUTE^", "Interval leading field precision '11' out of range for INTERVAL DAY\\(11\\) TO MINUTE");
        this.checkExpFails("INTERVAL '0 0' DAY(0) TO ^MINUTE^", "Interval leading field precision '0' out of range for INTERVAL DAY\\(0\\) TO MINUTE");
    }

    public void subTestIntervalDayToSecondNegative() {
        this.checkWholeExpFails("INTERVAL ' ::' DAY TO SECOND", "Illegal interval literal format ' ::' for INTERVAL DAY TO SECOND");
        this.checkWholeExpFails("INTERVAL ' ::.' DAY TO SECOND", "Illegal interval literal format ' ::\\.' for INTERVAL DAY TO SECOND");
        this.checkWholeExpFails("INTERVAL '1' DAY TO SECOND", "Illegal interval literal format '1' for INTERVAL DAY TO SECOND");
        this.checkWholeExpFails("INTERVAL '1 2' DAY TO SECOND", "Illegal interval literal format '1 2' for INTERVAL DAY TO SECOND");
        this.checkWholeExpFails("INTERVAL '1:2' DAY TO SECOND", "Illegal interval literal format '1:2' for INTERVAL DAY TO SECOND");
        this.checkWholeExpFails("INTERVAL '1.2' DAY TO SECOND", "Illegal interval literal format '1\\.2' for INTERVAL DAY TO SECOND");
        this.checkWholeExpFails("INTERVAL '1 1:2' DAY TO SECOND", "Illegal interval literal format '1 1:2' for INTERVAL DAY TO SECOND");
        this.checkWholeExpFails("INTERVAL '1 1:2:x' DAY TO SECOND", "Illegal interval literal format '1 1:2:x' for INTERVAL DAY TO SECOND");
        this.checkWholeExpFails("INTERVAL '1:2:3' DAY TO SECOND", "Illegal interval literal format '1:2:3' for INTERVAL DAY TO SECOND");
        this.checkWholeExpFails("INTERVAL '1:1:1.2' DAY TO SECOND", "Illegal interval literal format '1:1:1\\.2' for INTERVAL DAY TO SECOND");
        this.checkWholeExpFails("INTERVAL '1 1:2' DAY(2) TO SECOND", "Illegal interval literal format '1 1:2' for INTERVAL DAY\\(2\\) TO SECOND");
        this.checkWholeExpFails("INTERVAL '1 1' DAY(2) TO SECOND", "Illegal interval literal format '1 1' for INTERVAL DAY\\(2\\) TO SECOND");
        this.checkWholeExpFails("INTERVAL 'bogus text' DAY TO SECOND", "Illegal interval literal format 'bogus text' for INTERVAL DAY TO SECOND");
        this.checkWholeExpFails("INTERVAL '2345 6:7:8901' DAY TO SECOND(4)", "Illegal interval literal format '2345 6:7:8901' for INTERVAL DAY TO SECOND\\(4\\)");
        this.checkWholeExpFails("INTERVAL '--1 1:1:1' DAY TO SECOND", "Illegal interval literal format '--1 1:1:1' for INTERVAL DAY TO SECOND");
        this.checkWholeExpFails("INTERVAL '1 -1:1:1' DAY TO SECOND", "Illegal interval literal format '1 -1:1:1' for INTERVAL DAY TO SECOND");
        this.checkWholeExpFails("INTERVAL '1 1:-1:1' DAY TO SECOND", "Illegal interval literal format '1 1:-1:1' for INTERVAL DAY TO SECOND");
        this.checkWholeExpFails("INTERVAL '1 1:1:-1' DAY TO SECOND", "Illegal interval literal format '1 1:1:-1' for INTERVAL DAY TO SECOND");
        this.checkWholeExpFails("INTERVAL '1 1:1:1.-1' DAY TO SECOND", "Illegal interval literal format '1 1:1:1.-1' for INTERVAL DAY TO SECOND");
        this.checkWholeExpFails("INTERVAL '100 0' DAY TO SECOND", "Illegal interval literal format '100 0' for INTERVAL DAY TO SECOND.*");
        this.checkWholeExpFails("INTERVAL '100 0' DAY(2) TO SECOND", "Illegal interval literal format '100 0' for INTERVAL DAY\\(2\\) TO SECOND.*");
        this.checkWholeExpFails("INTERVAL '1000 0' DAY(3) TO SECOND", "Illegal interval literal format '1000 0' for INTERVAL DAY\\(3\\) TO SECOND.*");
        this.checkWholeExpFails("INTERVAL '-1000 0' DAY(3) TO SECOND", "Illegal interval literal format '-1000 0' for INTERVAL DAY\\(3\\) TO SECOND.*");
        this.checkWholeExpFails("INTERVAL '2147483648 1:1:0' DAY(10) TO SECOND", "Interval field value 2,147,483,648 exceeds precision of DAY\\(10\\) field.*");
        this.checkWholeExpFails("INTERVAL '-2147483648 1:1:0' DAY(10) TO SECOND", "Interval field value -2,147,483,648 exceeds precision of DAY\\(10\\) field.*");
        this.checkWholeExpFails("INTERVAL '2147483648 0' DAY(10) TO SECOND", "Illegal interval literal format '2147483648 0' for INTERVAL DAY\\(10\\) TO SECOND.*");
        this.checkWholeExpFails("INTERVAL '-2147483648 0' DAY(10) TO SECOND", "Illegal interval literal format '-2147483648 0' for INTERVAL DAY\\(10\\) TO SECOND.*");
        this.checkWholeExpFails("INTERVAL '1 24:1:1' DAY TO SECOND", "Illegal interval literal format '1 24:1:1' for INTERVAL DAY TO SECOND.*");
        this.checkWholeExpFails("INTERVAL '1 1:60:1' DAY TO SECOND", "Illegal interval literal format '1 1:60:1' for INTERVAL DAY TO SECOND.*");
        this.checkWholeExpFails("INTERVAL '1 1:1:60' DAY TO SECOND", "Illegal interval literal format '1 1:1:60' for INTERVAL DAY TO SECOND.*");
        this.checkWholeExpFails("INTERVAL '1 1:1:1.0000001' DAY TO SECOND", "Illegal interval literal format '1 1:1:1\\.0000001' for INTERVAL DAY TO SECOND.*");
        this.checkWholeExpFails("INTERVAL '1 1:1:1.0001' DAY TO SECOND(3)", "Illegal interval literal format '1 1:1:1\\.0001' for INTERVAL DAY TO SECOND\\(3\\).*");
        this.checkExpFails("INTERVAL '1 1' DAY(11) TO ^SECOND^", "Interval leading field precision '11' out of range for INTERVAL DAY\\(11\\) TO SECOND");
        this.checkExpFails("INTERVAL '1 1' DAY TO SECOND(10^)^", "Interval fractional second precision '10' out of range for INTERVAL DAY TO SECOND\\(10\\)");
        this.checkExpFails("INTERVAL '0 0:0:0' DAY(0) TO ^SECOND^", "Interval leading field precision '0' out of range for INTERVAL DAY\\(0\\) TO SECOND");
        this.checkExpFails("INTERVAL '0 0:0:0' DAY TO SECOND(0^)^", "Interval fractional second precision '0' out of range for INTERVAL DAY TO SECOND\\(0\\)");
    }

    public void subTestIntervalHourNegative() {
        this.checkWholeExpFails("INTERVAL '-' HOUR", "Illegal interval literal format '-' for INTERVAL HOUR.*");
        this.checkWholeExpFails("INTERVAL '1-2' HOUR", "Illegal interval literal format '1-2' for INTERVAL HOUR.*");
        this.checkWholeExpFails("INTERVAL '1.2' HOUR", "Illegal interval literal format '1.2' for INTERVAL HOUR.*");
        this.checkWholeExpFails("INTERVAL '1 2' HOUR", "Illegal interval literal format '1 2' for INTERVAL HOUR.*");
        this.checkWholeExpFails("INTERVAL '1:2' HOUR", "Illegal interval literal format '1:2' for INTERVAL HOUR.*");
        this.checkWholeExpFails("INTERVAL '1-2' HOUR(2)", "Illegal interval literal format '1-2' for INTERVAL HOUR\\(2\\)");
        this.checkWholeExpFails("INTERVAL 'bogus text' HOUR", "Illegal interval literal format 'bogus text' for INTERVAL HOUR.*");
        this.checkWholeExpFails("INTERVAL '--1' HOUR", "Illegal interval literal format '--1' for INTERVAL HOUR.*");
        this.checkWholeExpFails("INTERVAL '100' HOUR", "Interval field value 100 exceeds precision of HOUR\\(2\\) field.*");
        this.checkWholeExpFails("INTERVAL '100' HOUR(2)", "Interval field value 100 exceeds precision of HOUR\\(2\\) field.*");
        this.checkWholeExpFails("INTERVAL '1000' HOUR(3)", "Interval field value 1,000 exceeds precision of HOUR\\(3\\) field.*");
        this.checkWholeExpFails("INTERVAL '-1000' HOUR(3)", "Interval field value -1,000 exceeds precision of HOUR\\(3\\) field.*");
        this.checkWholeExpFails("INTERVAL '2147483648' HOUR(10)", "Interval field value 2,147,483,648 exceeds precision of HOUR\\(10\\) field.*");
        this.checkWholeExpFails("INTERVAL '-2147483648' HOUR(10)", "Interval field value -2,147,483,648 exceeds precision of HOUR\\(10\\) field.*");
        this.checkExpFails("INTERVAL '1' HOUR(11^)^", "Interval leading field precision '11' out of range for INTERVAL HOUR\\(11\\)");
        this.checkExpFails("INTERVAL '0' HOUR(0^)^", "Interval leading field precision '0' out of range for INTERVAL HOUR\\(0\\)");
    }

    public void subTestIntervalHourToMinuteNegative() {
        this.checkWholeExpFails("INTERVAL ':' HOUR TO MINUTE", "Illegal interval literal format ':' for INTERVAL HOUR TO MINUTE");
        this.checkWholeExpFails("INTERVAL '1' HOUR TO MINUTE", "Illegal interval literal format '1' for INTERVAL HOUR TO MINUTE");
        this.checkWholeExpFails("INTERVAL '1:x' HOUR TO MINUTE", "Illegal interval literal format '1:x' for INTERVAL HOUR TO MINUTE");
        this.checkWholeExpFails("INTERVAL '1.2' HOUR TO MINUTE", "Illegal interval literal format '1.2' for INTERVAL HOUR TO MINUTE");
        this.checkWholeExpFails("INTERVAL '1 2' HOUR TO MINUTE", "Illegal interval literal format '1 2' for INTERVAL HOUR TO MINUTE");
        this.checkWholeExpFails("INTERVAL '1:2:3' HOUR TO MINUTE", "Illegal interval literal format '1:2:3' for INTERVAL HOUR TO MINUTE");
        this.checkWholeExpFails("INTERVAL '1 2' HOUR(2) TO MINUTE", "Illegal interval literal format '1 2' for INTERVAL HOUR\\(2\\) TO MINUTE");
        this.checkWholeExpFails("INTERVAL 'bogus text' HOUR TO MINUTE", "Illegal interval literal format 'bogus text' for INTERVAL HOUR TO MINUTE");
        this.checkWholeExpFails("INTERVAL '--1:1' HOUR TO MINUTE", "Illegal interval literal format '--1:1' for INTERVAL HOUR TO MINUTE");
        this.checkWholeExpFails("INTERVAL '1:-1' HOUR TO MINUTE", "Illegal interval literal format '1:-1' for INTERVAL HOUR TO MINUTE");
        this.checkWholeExpFails("INTERVAL '100:0' HOUR TO MINUTE", "Interval field value 100 exceeds precision of HOUR\\(2\\) field.*");
        this.checkWholeExpFails("INTERVAL '100:0' HOUR(2) TO MINUTE", "Interval field value 100 exceeds precision of HOUR\\(2\\) field.*");
        this.checkWholeExpFails("INTERVAL '1000:0' HOUR(3) TO MINUTE", "Interval field value 1,000 exceeds precision of HOUR\\(3\\) field.*");
        this.checkWholeExpFails("INTERVAL '-1000:0' HOUR(3) TO MINUTE", "Interval field value -1,000 exceeds precision of HOUR\\(3\\) field.*");
        this.checkWholeExpFails("INTERVAL '2147483648:0' HOUR(10) TO MINUTE", "Interval field value 2,147,483,648 exceeds precision of HOUR\\(10\\) field.*");
        this.checkWholeExpFails("INTERVAL '-2147483648:0' HOUR(10) TO MINUTE", "Interval field value -2,147,483,648 exceeds precision of HOUR\\(10\\) field.*");
        this.checkWholeExpFails("INTERVAL '1:60' HOUR TO MINUTE", "Illegal interval literal format '1:60' for INTERVAL HOUR TO MINUTE.*");
        this.checkExpFails("INTERVAL '1:1' HOUR(11) TO ^MINUTE^", "Interval leading field precision '11' out of range for INTERVAL HOUR\\(11\\) TO MINUTE");
        this.checkExpFails("INTERVAL '0:0' HOUR(0) TO ^MINUTE^", "Interval leading field precision '0' out of range for INTERVAL HOUR\\(0\\) TO MINUTE");
    }

    public void subTestIntervalHourToSecondNegative() {
        this.checkWholeExpFails("INTERVAL '::' HOUR TO SECOND", "Illegal interval literal format '::' for INTERVAL HOUR TO SECOND");
        this.checkWholeExpFails("INTERVAL '::.' HOUR TO SECOND", "Illegal interval literal format '::\\.' for INTERVAL HOUR TO SECOND");
        this.checkWholeExpFails("INTERVAL '1' HOUR TO SECOND", "Illegal interval literal format '1' for INTERVAL HOUR TO SECOND");
        this.checkWholeExpFails("INTERVAL '1 2' HOUR TO SECOND", "Illegal interval literal format '1 2' for INTERVAL HOUR TO SECOND");
        this.checkWholeExpFails("INTERVAL '1:2' HOUR TO SECOND", "Illegal interval literal format '1:2' for INTERVAL HOUR TO SECOND");
        this.checkWholeExpFails("INTERVAL '1.2' HOUR TO SECOND", "Illegal interval literal format '1\\.2' for INTERVAL HOUR TO SECOND");
        this.checkWholeExpFails("INTERVAL '1 1:2' HOUR TO SECOND", "Illegal interval literal format '1 1:2' for INTERVAL HOUR TO SECOND");
        this.checkWholeExpFails("INTERVAL '1:2:x' HOUR TO SECOND", "Illegal interval literal format '1:2:x' for INTERVAL HOUR TO SECOND");
        this.checkWholeExpFails("INTERVAL '1:x:3' HOUR TO SECOND", "Illegal interval literal format '1:x:3' for INTERVAL HOUR TO SECOND");
        this.checkWholeExpFails("INTERVAL '1:1:1.x' HOUR TO SECOND", "Illegal interval literal format '1:1:1\\.x' for INTERVAL HOUR TO SECOND");
        this.checkWholeExpFails("INTERVAL '1 1:2' HOUR(2) TO SECOND", "Illegal interval literal format '1 1:2' for INTERVAL HOUR\\(2\\) TO SECOND");
        this.checkWholeExpFails("INTERVAL '1 1' HOUR(2) TO SECOND", "Illegal interval literal format '1 1' for INTERVAL HOUR\\(2\\) TO SECOND");
        this.checkWholeExpFails("INTERVAL 'bogus text' HOUR TO SECOND", "Illegal interval literal format 'bogus text' for INTERVAL HOUR TO SECOND");
        this.checkWholeExpFails("INTERVAL '6:7:8901' HOUR TO SECOND(4)", "Illegal interval literal format '6:7:8901' for INTERVAL HOUR TO SECOND\\(4\\)");
        this.checkWholeExpFails("INTERVAL '--1:1:1' HOUR TO SECOND", "Illegal interval literal format '--1:1:1' for INTERVAL HOUR TO SECOND");
        this.checkWholeExpFails("INTERVAL '1:-1:1' HOUR TO SECOND", "Illegal interval literal format '1:-1:1' for INTERVAL HOUR TO SECOND");
        this.checkWholeExpFails("INTERVAL '1:1:-1' HOUR TO SECOND", "Illegal interval literal format '1:1:-1' for INTERVAL HOUR TO SECOND");
        this.checkWholeExpFails("INTERVAL '1:1:1.-1' HOUR TO SECOND", "Illegal interval literal format '1:1:1\\.-1' for INTERVAL HOUR TO SECOND");
        this.checkWholeExpFails("INTERVAL '100:0:0' HOUR TO SECOND", "Interval field value 100 exceeds precision of HOUR\\(2\\) field.*");
        this.checkWholeExpFails("INTERVAL '100:0:0' HOUR(2) TO SECOND", "Interval field value 100 exceeds precision of HOUR\\(2\\) field.*");
        this.checkWholeExpFails("INTERVAL '1000:0:0' HOUR(3) TO SECOND", "Interval field value 1,000 exceeds precision of HOUR\\(3\\) field.*");
        this.checkWholeExpFails("INTERVAL '-1000:0:0' HOUR(3) TO SECOND", "Interval field value -1,000 exceeds precision of HOUR\\(3\\) field.*");
        this.checkWholeExpFails("INTERVAL '2147483648:0:0' HOUR(10) TO SECOND", "Interval field value 2,147,483,648 exceeds precision of HOUR\\(10\\) field.*");
        this.checkWholeExpFails("INTERVAL '-2147483648:0:0' HOUR(10) TO SECOND", "Interval field value -2,147,483,648 exceeds precision of HOUR\\(10\\) field.*");
        this.checkWholeExpFails("INTERVAL '1:60:1' HOUR TO SECOND", "Illegal interval literal format '1:60:1' for INTERVAL HOUR TO SECOND.*");
        this.checkWholeExpFails("INTERVAL '1:1:60' HOUR TO SECOND", "Illegal interval literal format '1:1:60' for INTERVAL HOUR TO SECOND.*");
        this.checkWholeExpFails("INTERVAL '1:1:1.0000001' HOUR TO SECOND", "Illegal interval literal format '1:1:1\\.0000001' for INTERVAL HOUR TO SECOND.*");
        this.checkWholeExpFails("INTERVAL '1:1:1.0001' HOUR TO SECOND(3)", "Illegal interval literal format '1:1:1\\.0001' for INTERVAL HOUR TO SECOND\\(3\\).*");
        this.checkExpFails("INTERVAL '1:1:1' HOUR(11) TO ^SECOND^", "Interval leading field precision '11' out of range for INTERVAL HOUR\\(11\\) TO SECOND");
        this.checkExpFails("INTERVAL '1:1:1' HOUR TO SECOND(10^)^", "Interval fractional second precision '10' out of range for INTERVAL HOUR TO SECOND\\(10\\)");
        this.checkExpFails("INTERVAL '0:0:0' HOUR(0) TO ^SECOND^", "Interval leading field precision '0' out of range for INTERVAL HOUR\\(0\\) TO SECOND");
        this.checkExpFails("INTERVAL '0:0:0' HOUR TO SECOND(0^)^", "Interval fractional second precision '0' out of range for INTERVAL HOUR TO SECOND\\(0\\)");
    }

    public void subTestIntervalMinuteNegative() {
        this.checkWholeExpFails("INTERVAL '-' MINUTE", "Illegal interval literal format '-' for INTERVAL MINUTE.*");
        this.checkWholeExpFails("INTERVAL '1-2' MINUTE", "Illegal interval literal format '1-2' for INTERVAL MINUTE.*");
        this.checkWholeExpFails("INTERVAL '1.2' MINUTE", "Illegal interval literal format '1.2' for INTERVAL MINUTE.*");
        this.checkWholeExpFails("INTERVAL '1 2' MINUTE", "Illegal interval literal format '1 2' for INTERVAL MINUTE.*");
        this.checkWholeExpFails("INTERVAL '1:2' MINUTE", "Illegal interval literal format '1:2' for INTERVAL MINUTE.*");
        this.checkWholeExpFails("INTERVAL '1-2' MINUTE(2)", "Illegal interval literal format '1-2' for INTERVAL MINUTE\\(2\\)");
        this.checkWholeExpFails("INTERVAL 'bogus text' MINUTE", "Illegal interval literal format 'bogus text' for INTERVAL MINUTE.*");
        this.checkWholeExpFails("INTERVAL '--1' MINUTE", "Illegal interval literal format '--1' for INTERVAL MINUTE.*");
        this.checkWholeExpFails("INTERVAL '100' MINUTE", "Interval field value 100 exceeds precision of MINUTE\\(2\\) field.*");
        this.checkWholeExpFails("INTERVAL '100' MINUTE(2)", "Interval field value 100 exceeds precision of MINUTE\\(2\\) field.*");
        this.checkWholeExpFails("INTERVAL '1000' MINUTE(3)", "Interval field value 1,000 exceeds precision of MINUTE\\(3\\) field.*");
        this.checkWholeExpFails("INTERVAL '-1000' MINUTE(3)", "Interval field value -1,000 exceeds precision of MINUTE\\(3\\) field.*");
        this.checkWholeExpFails("INTERVAL '2147483648' MINUTE(10)", "Interval field value 2,147,483,648 exceeds precision of MINUTE\\(10\\) field.*");
        this.checkWholeExpFails("INTERVAL '-2147483648' MINUTE(10)", "Interval field value -2,147,483,648 exceeds precision of MINUTE\\(10\\) field.*");
        this.checkExpFails("INTERVAL '1' MINUTE(11^)^", "Interval leading field precision '11' out of range for INTERVAL MINUTE\\(11\\)");
        this.checkExpFails("INTERVAL '0' MINUTE(0^)^", "Interval leading field precision '0' out of range for INTERVAL MINUTE\\(0\\)");
    }

    public void subTestIntervalMinuteToSecondNegative() {
        this.checkWholeExpFails("INTERVAL ':' MINUTE TO SECOND", "Illegal interval literal format ':' for INTERVAL MINUTE TO SECOND");
        this.checkWholeExpFails("INTERVAL ':.' MINUTE TO SECOND", "Illegal interval literal format ':\\.' for INTERVAL MINUTE TO SECOND");
        this.checkWholeExpFails("INTERVAL '1' MINUTE TO SECOND", "Illegal interval literal format '1' for INTERVAL MINUTE TO SECOND");
        this.checkWholeExpFails("INTERVAL '1 2' MINUTE TO SECOND", "Illegal interval literal format '1 2' for INTERVAL MINUTE TO SECOND");
        this.checkWholeExpFails("INTERVAL '1.2' MINUTE TO SECOND", "Illegal interval literal format '1\\.2' for INTERVAL MINUTE TO SECOND");
        this.checkWholeExpFails("INTERVAL '1 1:2' MINUTE TO SECOND", "Illegal interval literal format '1 1:2' for INTERVAL MINUTE TO SECOND");
        this.checkWholeExpFails("INTERVAL '1:x' MINUTE TO SECOND", "Illegal interval literal format '1:x' for INTERVAL MINUTE TO SECOND");
        this.checkWholeExpFails("INTERVAL 'x:3' MINUTE TO SECOND", "Illegal interval literal format 'x:3' for INTERVAL MINUTE TO SECOND");
        this.checkWholeExpFails("INTERVAL '1:1.x' MINUTE TO SECOND", "Illegal interval literal format '1:1\\.x' for INTERVAL MINUTE TO SECOND");
        this.checkWholeExpFails("INTERVAL '1 1:2' MINUTE(2) TO SECOND", "Illegal interval literal format '1 1:2' for INTERVAL MINUTE\\(2\\) TO SECOND");
        this.checkWholeExpFails("INTERVAL '1 1' MINUTE(2) TO SECOND", "Illegal interval literal format '1 1' for INTERVAL MINUTE\\(2\\) TO SECOND");
        this.checkWholeExpFails("INTERVAL 'bogus text' MINUTE TO SECOND", "Illegal interval literal format 'bogus text' for INTERVAL MINUTE TO SECOND");
        this.checkWholeExpFails("INTERVAL '7:8901' MINUTE TO SECOND(4)", "Illegal interval literal format '7:8901' for INTERVAL MINUTE TO SECOND\\(4\\)");
        this.checkWholeExpFails("INTERVAL '--1:1' MINUTE TO SECOND", "Illegal interval literal format '--1:1' for INTERVAL MINUTE TO SECOND");
        this.checkWholeExpFails("INTERVAL '1:-1' MINUTE TO SECOND", "Illegal interval literal format '1:-1' for INTERVAL MINUTE TO SECOND");
        this.checkWholeExpFails("INTERVAL '1:1.-1' MINUTE TO SECOND", "Illegal interval literal format '1:1.-1' for INTERVAL MINUTE TO SECOND");
        this.checkWholeExpFails("INTERVAL '100:0' MINUTE TO SECOND", "Interval field value 100 exceeds precision of MINUTE\\(2\\) field.*");
        this.checkWholeExpFails("INTERVAL '100:0' MINUTE(2) TO SECOND", "Interval field value 100 exceeds precision of MINUTE\\(2\\) field.*");
        this.checkWholeExpFails("INTERVAL '1000:0' MINUTE(3) TO SECOND", "Interval field value 1,000 exceeds precision of MINUTE\\(3\\) field.*");
        this.checkWholeExpFails("INTERVAL '-1000:0' MINUTE(3) TO SECOND", "Interval field value -1,000 exceeds precision of MINUTE\\(3\\) field.*");
        this.checkWholeExpFails("INTERVAL '2147483648:0' MINUTE(10) TO SECOND", "Interval field value 2,147,483,648 exceeds precision of MINUTE\\(10\\) field.*");
        this.checkWholeExpFails("INTERVAL '-2147483648:0' MINUTE(10) TO SECOND", "Interval field value -2,147,483,648 exceeds precision of MINUTE\\(10\\) field.*");
        this.checkWholeExpFails("INTERVAL '1:60' MINUTE TO SECOND", "Illegal interval literal format '1:60' for INTERVAL MINUTE TO SECOND.*");
        this.checkWholeExpFails("INTERVAL '1:1.0000001' MINUTE TO SECOND", "Illegal interval literal format '1:1\\.0000001' for INTERVAL MINUTE TO SECOND.*");
        this.checkWholeExpFails("INTERVAL '1:1:1.0001' MINUTE TO SECOND(3)", "Illegal interval literal format '1:1:1\\.0001' for INTERVAL MINUTE TO SECOND\\(3\\).*");
        this.checkExpFails("INTERVAL '1:1' MINUTE(11) TO ^SECOND^", "Interval leading field precision '11' out of range for INTERVAL MINUTE\\(11\\) TO SECOND");
        this.checkExpFails("INTERVAL '1:1' MINUTE TO SECOND(10^)^", "Interval fractional second precision '10' out of range for INTERVAL MINUTE TO SECOND\\(10\\)");
        this.checkExpFails("INTERVAL '0:0' MINUTE(0) TO ^SECOND^", "Interval leading field precision '0' out of range for INTERVAL MINUTE\\(0\\) TO SECOND");
        this.checkExpFails("INTERVAL '0:0' MINUTE TO SECOND(0^)^", "Interval fractional second precision '0' out of range for INTERVAL MINUTE TO SECOND\\(0\\)");
    }

    public void subTestIntervalSecondNegative() {
        this.checkWholeExpFails("INTERVAL ':' SECOND", "Illegal interval literal format ':' for INTERVAL SECOND.*");
        this.checkWholeExpFails("INTERVAL '.' SECOND", "Illegal interval literal format '\\.' for INTERVAL SECOND.*");
        this.checkWholeExpFails("INTERVAL '1-2' SECOND", "Illegal interval literal format '1-2' for INTERVAL SECOND.*");
        this.checkWholeExpFails("INTERVAL '1.x' SECOND", "Illegal interval literal format '1\\.x' for INTERVAL SECOND.*");
        this.checkWholeExpFails("INTERVAL 'x.1' SECOND", "Illegal interval literal format 'x\\.1' for INTERVAL SECOND.*");
        this.checkWholeExpFails("INTERVAL '1 2' SECOND", "Illegal interval literal format '1 2' for INTERVAL SECOND.*");
        this.checkWholeExpFails("INTERVAL '1:2' SECOND", "Illegal interval literal format '1:2' for INTERVAL SECOND.*");
        this.checkWholeExpFails("INTERVAL '1-2' SECOND(2)", "Illegal interval literal format '1-2' for INTERVAL SECOND\\(2\\)");
        this.checkWholeExpFails("INTERVAL 'bogus text' SECOND", "Illegal interval literal format 'bogus text' for INTERVAL SECOND.*");
        this.checkWholeExpFails("INTERVAL '--1' SECOND", "Illegal interval literal format '--1' for INTERVAL SECOND.*");
        this.checkWholeExpFails("INTERVAL '1.-1' SECOND", "Illegal interval literal format '1.-1' for INTERVAL SECOND.*");
        this.checkWholeExpFails("INTERVAL '100' SECOND", "Interval field value 100 exceeds precision of SECOND\\(2\\) field.*");
        this.checkWholeExpFails("INTERVAL '100' SECOND(2)", "Interval field value 100 exceeds precision of SECOND\\(2\\) field.*");
        this.checkWholeExpFails("INTERVAL '1000' SECOND(3)", "Interval field value 1,000 exceeds precision of SECOND\\(3\\) field.*");
        this.checkWholeExpFails("INTERVAL '-1000' SECOND(3)", "Interval field value -1,000 exceeds precision of SECOND\\(3\\) field.*");
        this.checkWholeExpFails("INTERVAL '2147483648' SECOND(10)", "Interval field value 2,147,483,648 exceeds precision of SECOND\\(10\\) field.*");
        this.checkWholeExpFails("INTERVAL '-2147483648' SECOND(10)", "Interval field value -2,147,483,648 exceeds precision of SECOND\\(10\\) field.*");
        this.checkWholeExpFails("INTERVAL '1.0000001' SECOND", "Illegal interval literal format '1\\.0000001' for INTERVAL SECOND.*");
        this.checkWholeExpFails("INTERVAL '1.0000001' SECOND(2)", "Illegal interval literal format '1\\.0000001' for INTERVAL SECOND\\(2\\).*");
        this.checkWholeExpFails("INTERVAL '1.0001' SECOND(2, 3)", "Illegal interval literal format '1\\.0001' for INTERVAL SECOND\\(2, 3\\).*");
        this.checkWholeExpFails("INTERVAL '1.0000000001' SECOND(2, 9)", "Illegal interval literal format '1\\.0000000001' for INTERVAL SECOND\\(2, 9\\).*");
        this.checkExpFails("INTERVAL '1' SECOND(11^)^", "Interval leading field precision '11' out of range for INTERVAL SECOND\\(11\\)");
        this.checkExpFails("INTERVAL '1.1' SECOND(1, 10^)^", "Interval fractional second precision '10' out of range for INTERVAL SECOND\\(1, 10\\)");
        this.checkExpFails("INTERVAL '0' SECOND(0^)^", "Interval leading field precision '0' out of range for INTERVAL SECOND\\(0\\)");
        this.checkExpFails("INTERVAL '0' SECOND(1, 0^)^", "Interval fractional second precision '0' out of range for INTERVAL SECOND\\(1, 0\\)");
    }

    @Test
    public void testIntervalLiterals() {
        RelDataTypeSystem typeSystem = this.getTester().getValidator().getTypeFactory().getTypeSystem();
        RelDataTypeSystem defTypeSystem = RelDataTypeSystem.DEFAULT;
        for (SqlTypeName typeName : SqlTypeName.INTERVAL_TYPES) {
            Assert.assertThat((Object)typeName.getMinPrecision(), (Matcher)CoreMatchers.is((Object)1));
            Assert.assertThat((Object)typeSystem.getMaxPrecision(typeName), (Matcher)CoreMatchers.is((Object)10));
            Assert.assertThat((Object)typeSystem.getDefaultPrecision(typeName), (Matcher)CoreMatchers.is((Object)2));
            Assert.assertThat((Object)typeName.getMinScale(), (Matcher)CoreMatchers.is((Object)1));
            Assert.assertThat((Object)typeSystem.getMaxScale(typeName), (Matcher)CoreMatchers.is((Object)9));
            Assert.assertThat((Object)typeName.getDefaultScale(), (Matcher)CoreMatchers.is((Object)6));
        }
        this.subTestIntervalYearPositive();
        this.subTestIntervalYearToMonthPositive();
        this.subTestIntervalMonthPositive();
        this.subTestIntervalDayPositive();
        this.subTestIntervalDayToHourPositive();
        this.subTestIntervalDayToMinutePositive();
        this.subTestIntervalDayToSecondPositive();
        this.subTestIntervalHourPositive();
        this.subTestIntervalHourToMinutePositive();
        this.subTestIntervalHourToSecondPositive();
        this.subTestIntervalMinutePositive();
        this.subTestIntervalMinuteToSecondPositive();
        this.subTestIntervalSecondPositive();
        this.subTestIntervalYearNegative();
        this.subTestIntervalYearToMonthNegative();
        this.subTestIntervalMonthNegative();
        this.subTestIntervalDayNegative();
        this.subTestIntervalDayToHourNegative();
        this.subTestIntervalDayToMinuteNegative();
        this.subTestIntervalDayToSecondNegative();
        this.subTestIntervalHourNegative();
        this.subTestIntervalHourToMinuteNegative();
        this.subTestIntervalHourToSecondNegative();
        this.subTestIntervalMinuteNegative();
        this.subTestIntervalMinuteToSecondNegative();
        this.subTestIntervalSecondNegative();
        this.checkWholeExpFails("INTERVAL '1.0' HOUR", "Illegal interval literal format '1.0' for INTERVAL HOUR");
        this.checkExpType("INTERVAL '1.0' SECOND", "INTERVAL SECOND NOT NULL");
        this.checkExpType("INTERVAL '0999' MONTH(3)", "INTERVAL MONTH(3) NOT NULL");
    }

    @Test
    public void testIntervalOperators() {
        this.checkExpType("interval '1' hour + TIME '8:8:8'", "TIME(0) NOT NULL");
        this.checkExpType("TIME '8:8:8' - interval '1' hour", "TIME(0) NOT NULL");
        this.checkExpType("TIME '8:8:8' + interval '1' hour", "TIME(0) NOT NULL");
        this.checkExpType("interval '1' day + interval '1' DAY(4)", "INTERVAL DAY(4) NOT NULL");
        this.checkExpType("interval '1' day(5) + interval '1' DAY", "INTERVAL DAY(5) NOT NULL");
        this.checkExpType("interval '1' day + interval '1' HOUR(10)", "INTERVAL DAY TO HOUR NOT NULL");
        this.checkExpType("interval '1' day + interval '1' MINUTE", "INTERVAL DAY TO MINUTE NOT NULL");
        this.checkExpType("interval '1' day + interval '1' second", "INTERVAL DAY TO SECOND NOT NULL");
        this.checkExpType("interval '1:2' hour to minute + interval '1' second", "INTERVAL HOUR TO SECOND NOT NULL");
        this.checkExpType("interval '1:3' hour to minute + interval '1 1:2:3.4' day to second", "INTERVAL DAY TO SECOND NOT NULL");
        this.checkExpType("interval '1:2' hour to minute + interval '1 1' day to hour", "INTERVAL DAY TO MINUTE NOT NULL");
        this.checkExpType("interval '1:2' hour to minute + interval '1 1' day to hour", "INTERVAL DAY TO MINUTE NOT NULL");
        this.checkExpType("interval '1 2' day to hour + interval '1:1' minute to second", "INTERVAL DAY TO SECOND NOT NULL");
        this.checkExpType("interval '1' year + interval '1' month", "INTERVAL YEAR TO MONTH NOT NULL");
        this.checkExpType("interval '1' day - interval '1' hour", "INTERVAL DAY TO HOUR NOT NULL");
        this.checkExpType("interval '1' year - interval '1' month", "INTERVAL YEAR TO MONTH NOT NULL");
        this.checkExpType("interval '1' month - interval '1' year", "INTERVAL YEAR TO MONTH NOT NULL");
        this.checkWholeExpFails("interval '1' year + interval '1' day", "(?s).*Cannot apply '\\+' to arguments of type '<INTERVAL YEAR> \\+ <INTERVAL DAY>'.*");
        this.checkWholeExpFails("interval '1' month + interval '1' second", "(?s).*Cannot apply '\\+' to arguments of type '<INTERVAL MONTH> \\+ <INTERVAL SECOND>'.*");
        this.checkWholeExpFails("interval '1' year - interval '1' day", "(?s).*Cannot apply '-' to arguments of type '<INTERVAL YEAR> - <INTERVAL DAY>'.*");
        this.checkWholeExpFails("interval '1' month - interval '1' second", "(?s).*Cannot apply '-' to arguments of type '<INTERVAL MONTH> - <INTERVAL SECOND>'.*");
        this.checkExpType("interval '1' year * 2", "INTERVAL YEAR NOT NULL");
        this.checkExpType("1.234*interval '1 1:2:3' day to second ", "INTERVAL DAY TO SECOND NOT NULL");
        this.checkExpType("interval '1' month / 0.1", "INTERVAL MONTH NOT NULL");
        this.checkExpType("interval '1-2' year TO month / 0.1e-9", "INTERVAL YEAR TO MONTH NOT NULL");
        this.checkWholeExpFails("1.234/interval '1 1:2:3' day to second", "(?s).*Cannot apply '/' to arguments of type '<DECIMAL.4, 3.> / <INTERVAL DAY TO SECOND>'.*");
    }

    @Test
    public void testTimestampAddAndDiff() {
        ImmutableList tsi = ImmutableList.builder().add((Object)"FRAC_SECOND").add((Object)"MICROSECOND").add((Object)"MINUTE").add((Object)"HOUR").add((Object)"DAY").add((Object)"WEEK").add((Object)"MONTH").add((Object)"QUARTER").add((Object)"YEAR").add((Object)"SQL_TSI_FRAC_SECOND").add((Object)"SQL_TSI_MICROSECOND").add((Object)"SQL_TSI_MINUTE").add((Object)"SQL_TSI_HOUR").add((Object)"SQL_TSI_DAY").add((Object)"SQL_TSI_WEEK").add((Object)"SQL_TSI_MONTH").add((Object)"SQL_TSI_QUARTER").add((Object)"SQL_TSI_YEAR").build();
        ImmutableList functions = ImmutableList.builder().add((Object)"timestampadd(%s, 12, current_timestamp)").add((Object)"timestampdiff(%s, current_timestamp, current_timestamp)").build();
        for (String interval : tsi) {
            for (String function : functions) {
                this.checkExp(String.format(Locale.ROOT, function, interval));
            }
        }
        this.checkExpType("timestampadd(SQL_TSI_WEEK, 2, current_timestamp)", "TIMESTAMP(0) NOT NULL");
        this.checkExpType("timestampadd(SQL_TSI_WEEK, 2, cast(null as timestamp))", "TIMESTAMP(0)");
        this.checkExpType("timestampdiff(SQL_TSI_WEEK, current_timestamp, current_timestamp)", "INTEGER NOT NULL");
        this.checkExpType("timestampdiff(SQL_TSI_WEEK, cast(null as timestamp), current_timestamp)", "INTEGER");
        this.checkWholeExpFails("timestampadd(incorrect, 1, current_timestamp)", "(?s).*Was expecting one of.*");
        this.checkWholeExpFails("timestampdiff(incorrect, current_timestamp, current_timestamp)", "(?s).*Was expecting one of.*");
    }

    @Test
    public void testNumericOperators() {
        this.checkExpType("- cast(1 as TINYINT)", "TINYINT NOT NULL");
        this.checkExpType("+ cast(1 as INT)", "INTEGER NOT NULL");
        this.checkExpType("- cast(1 as FLOAT)", "FLOAT NOT NULL");
        this.checkExpType("+ cast(1 as DOUBLE)", "DOUBLE NOT NULL");
        this.checkExpType("-1.643", "DECIMAL(4, 3) NOT NULL");
        this.checkExpType("+1.643", "DECIMAL(4, 3) NOT NULL");
        this.checkExpType("cast(1 as TINYINT) + cast(5 as INTEGER)", "INTEGER NOT NULL");
        this.checkExpType("cast(null as SMALLINT) + cast(5 as BIGINT)", "BIGINT");
        this.checkExpType("cast(1 as REAL) + cast(5 as INTEGER)", "REAL NOT NULL");
        this.checkExpType("cast(null as REAL) + cast(5 as DOUBLE)", "DOUBLE");
        this.checkExpType("cast(null as REAL) + cast(5 as REAL)", "REAL");
        this.checkExpType("cast(1 as DECIMAL(5, 2)) + cast(1 as REAL)", "DOUBLE NOT NULL");
        this.checkExpType("cast(1 as DECIMAL(5, 2)) + cast(1 as DOUBLE)", "DOUBLE NOT NULL");
        this.checkExpType("cast(null as DECIMAL(5, 2)) + cast(1 as DOUBLE)", "DOUBLE");
        this.checkExpType("1.543 + 2.34", "DECIMAL(5, 3) NOT NULL");
        this.checkExpType("cast(1 as DECIMAL(5, 2)) + cast(1 as BIGINT)", "DECIMAL(19, 2) NOT NULL");
        this.checkExpType("cast(1 as NUMERIC(5, 2)) + cast(1 as INTEGER)", "DECIMAL(13, 2) NOT NULL");
        this.checkExpType("cast(1 as DECIMAL(5, 2)) + cast(null as SMALLINT)", "DECIMAL(8, 2)");
        this.checkExpType("cast(1 as DECIMAL(5, 2)) + cast(1 as TINYINT)", "DECIMAL(6, 2) NOT NULL");
        this.checkExpType("cast(1 as DECIMAL(5, 2)) + cast(1 as DECIMAL(5, 2))", "DECIMAL(6, 2) NOT NULL");
        this.checkExpType("cast(1 as DECIMAL(5, 2)) + cast(1 as DECIMAL(6, 2))", "DECIMAL(7, 2) NOT NULL");
        this.checkExpType("cast(1 as DECIMAL(4, 2)) + cast(1 as DECIMAL(6, 4))", "DECIMAL(7, 4) NOT NULL");
        this.checkExpType("cast(null as DECIMAL(4, 2)) + cast(1 as DECIMAL(6, 4))", "DECIMAL(7, 4)");
        this.checkExpType("cast(1 as DECIMAL(19, 2)) + cast(1 as DECIMAL(19, 2))", "DECIMAL(19, 2) NOT NULL");
        this.checkExpType("cast(1 as TINYINT) - cast(5 as BIGINT)", "BIGINT NOT NULL");
        this.checkExpType("cast(null as INTEGER) - cast(5 as SMALLINT)", "INTEGER");
        this.checkExpType("cast(1 as INTEGER) - cast(5 as REAL)", "REAL NOT NULL");
        this.checkExpType("cast(null as REAL) - cast(5 as DOUBLE)", "DOUBLE");
        this.checkExpType("cast(null as REAL) - cast(5 as REAL)", "REAL");
        this.checkExpType("cast(1 as DECIMAL(5, 2)) - cast(1 as DOUBLE)", "DOUBLE NOT NULL");
        this.checkExpType("cast(null as DOUBLE) - cast(1 as DECIMAL)", "DOUBLE");
        this.checkExpType("1.543 - 24", "DECIMAL(14, 3) NOT NULL");
        this.checkExpType("cast(1 as DECIMAL(5)) - cast(1 as BIGINT)", "DECIMAL(19, 0) NOT NULL");
        this.checkExpType("cast(1 as DECIMAL(5, 2)) - cast(1 as INTEGER)", "DECIMAL(13, 2) NOT NULL");
        this.checkExpType("cast(1 as DECIMAL(5, 2)) - cast(null as SMALLINT)", "DECIMAL(8, 2)");
        this.checkExpType("cast(1 as DECIMAL(5, 2)) - cast(1 as TINYINT)", "DECIMAL(6, 2) NOT NULL");
        this.checkExpType("cast(1 as DECIMAL(5, 2)) - cast(1 as DECIMAL(7))", "DECIMAL(10, 2) NOT NULL");
        this.checkExpType("cast(1 as DECIMAL(5, 2)) - cast(1 as DECIMAL(6, 2))", "DECIMAL(7, 2) NOT NULL");
        this.checkExpType("cast(1 as DECIMAL(4, 2)) - cast(1 as DECIMAL(6, 4))", "DECIMAL(7, 4) NOT NULL");
        this.checkExpType("cast(null as DECIMAL) - cast(1 as DECIMAL(6, 4))", "DECIMAL(19, 4)");
        this.checkExpType("cast(1 as DECIMAL(19, 2)) - cast(1 as DECIMAL(19, 2))", "DECIMAL(19, 2) NOT NULL");
        this.checkExpType("cast(1 as TINYINT) * cast(5 as INTEGER)", "INTEGER NOT NULL");
        this.checkExpType("cast(null as SMALLINT) * cast(5 as BIGINT)", "BIGINT");
        this.checkExpType("cast(1 as REAL) * cast(5 as INTEGER)", "REAL NOT NULL");
        this.checkExpType("cast(null as REAL) * cast(5 as DOUBLE)", "DOUBLE");
        this.checkExpType("cast(1 as DECIMAL(7, 3)) * 1.654", "DECIMAL(11, 6) NOT NULL");
        this.checkExpType("cast(null as DECIMAL(7, 3)) * cast (1.654 as DOUBLE)", "DOUBLE");
        this.checkExpType("cast(null as DECIMAL(5, 2)) * cast(1 as BIGINT)", "DECIMAL(19, 2)");
        this.checkExpType("cast(1 as DECIMAL(5, 2)) * cast(1 as INTEGER)", "DECIMAL(15, 2) NOT NULL");
        this.checkExpType("cast(1 as DECIMAL(5, 2)) * cast(1 as SMALLINT)", "DECIMAL(10, 2) NOT NULL");
        this.checkExpType("cast(1 as DECIMAL(5, 2)) * cast(1 as TINYINT)", "DECIMAL(8, 2) NOT NULL");
        this.checkExpType("cast(1 as DECIMAL(5, 2)) * cast(1 as DECIMAL(5, 2))", "DECIMAL(10, 4) NOT NULL");
        this.checkExpType("cast(1 as DECIMAL(5, 2)) * cast(1 as DECIMAL(6, 2))", "DECIMAL(11, 4) NOT NULL");
        this.checkExpType("cast(1 as DECIMAL(4, 2)) * cast(1 as DECIMAL(6, 4))", "DECIMAL(10, 6) NOT NULL");
        this.checkExpType("cast(null as DECIMAL(4, 2)) * cast(1 as DECIMAL(6, 4))", "DECIMAL(10, 6)");
        this.checkExpType("cast(1 as DECIMAL(4, 10)) * cast(null as DECIMAL(6, 10))", "DECIMAL(10, 19)");
        this.checkExpType("cast(1 as DECIMAL(19, 2)) * cast(1 as DECIMAL(19, 2))", "DECIMAL(19, 4) NOT NULL");
        this.checkExpType("cast(1 as TINYINT) / cast(5 as INTEGER)", "INTEGER NOT NULL");
        this.checkExpType("cast(null as SMALLINT) / cast(5 as BIGINT)", "BIGINT");
        this.checkExpType("cast(1 as REAL) / cast(5 as INTEGER)", "REAL NOT NULL");
        this.checkExpType("cast(null as REAL) / cast(5 as DOUBLE)", "DOUBLE");
        this.checkExpType("cast(1 as DECIMAL(7, 3)) / 1.654", "DECIMAL(15, 8) NOT NULL");
        this.checkExpType("cast(null as DECIMAL(7, 3)) / cast (1.654 as DOUBLE)", "DOUBLE");
        this.checkExpType("cast(null as DECIMAL(5, 2)) / cast(1 as BIGINT)", "DECIMAL(19, 16)");
        this.checkExpType("cast(1 as DECIMAL(5, 2)) / cast(1 as INTEGER)", "DECIMAL(16, 13) NOT NULL");
        this.checkExpType("cast(1 as DECIMAL(5, 2)) / cast(1 as SMALLINT)", "DECIMAL(11, 8) NOT NULL");
        this.checkExpType("cast(1 as DECIMAL(5, 2)) / cast(1 as TINYINT)", "DECIMAL(9, 6) NOT NULL");
        this.checkExpType("cast(1 as DECIMAL(5, 2)) / cast(1 as DECIMAL(5, 2))", "DECIMAL(13, 8) NOT NULL");
        this.checkExpType("cast(1 as DECIMAL(5, 2)) / cast(1 as DECIMAL(6, 2))", "DECIMAL(14, 9) NOT NULL");
        this.checkExpType("cast(1 as DECIMAL(4, 2)) / cast(1 as DECIMAL(6, 4))", "DECIMAL(15, 9) NOT NULL");
        this.checkExpType("cast(null as DECIMAL(4, 2)) / cast(1 as DECIMAL(6, 4))", "DECIMAL(15, 9)");
        this.checkExpType("cast(1 as DECIMAL(4, 10)) / cast(null as DECIMAL(6, 19))", "DECIMAL(19, 6)");
        this.checkExpType("cast(1 as DECIMAL(19, 2)) / cast(1 as DECIMAL(19, 2))", "DECIMAL(19, 0) NOT NULL");
    }

    @Test
    public void testFloorCeil() {
        this.checkExpType("floor(cast(null as tinyint))", "TINYINT");
        this.checkExpType("floor(1.2)", "DECIMAL(2, 0) NOT NULL");
        this.checkExpType("floor(1)", "INTEGER NOT NULL");
        this.checkExpType("floor(1.2e-2)", "DOUBLE NOT NULL");
        this.checkExpType("floor(interval '2' day)", "INTERVAL DAY NOT NULL");
        this.checkExpType("ceil(cast(null as bigint))", "BIGINT");
        this.checkExpType("ceil(1.2)", "DECIMAL(2, 0) NOT NULL");
        this.checkExpType("ceil(1)", "INTEGER NOT NULL");
        this.checkExpType("ceil(1.2e-2)", "DOUBLE NOT NULL");
        this.checkExpType("ceil(interval '2' second)", "INTERVAL SECOND NOT NULL");
    }

    public void checkWinFuncExpWithWinClause(String sql, String expectedMsgPattern) {
        this.winExp(sql).fails(expectedMsgPattern);
    }

    public void _testWinPartClause() {
        this.win("window w as (w2 order by deptno), w2 as (^rang^e 100 preceding)").fails("Referenced window cannot have framing declarations");
    }

    @Test
    public void testWindowFunctionsWithoutOver() {
        this.winSql("select sum(empno) \nfrom emp \ngroup by deptno \norder by ^row_number()^").fails("OVER clause is necessary for window functions");
        this.winSql("select ^rank()^ \nfrom emp").fails("OVER clause is necessary for window functions");
        this.winSql("select cume_dist() over w , ^rank()^\nfrom emp \nwindow w as (partition by deptno order by deptno)").fails("OVER clause is necessary for window functions");
    }

    @Test
    public void testOverInPartitionBy() {
        this.winSql("select sum(deptno) over ^(partition by sum(deptno) \nover(order by deptno))^ from emp").fails("PARTITION BY expression should not contain OVER clause");
        this.winSql("select sum(deptno) over w \nfrom emp \nwindow w as ^(partition by sum(deptno) over(order by deptno))^").fails("PARTITION BY expression should not contain OVER clause");
    }

    @Test
    public void testOverInOrderBy() {
        this.winSql("select sum(deptno) over ^(order by sum(deptno) \nover(order by deptno))^ from emp").fails("ORDER BY expression should not contain OVER clause");
        this.winSql("select sum(deptno) over w \nfrom emp \nwindow w as ^(order by sum(deptno) over(order by deptno))^").fails("ORDER BY expression should not contain OVER clause");
    }

    @Test
    public void testWindowFunctions() {
        this.winSql("select *\n from emp\n where ^sum(sal) over (partition by deptno\n    order by empno\n    rows 3 preceding)^ > 10").fails("Windowed aggregate expression is illegal in WHERE clause");
        this.winSql("select *\n from emp\n group by ename, ^sum(sal) over (partition by deptno\n    order by empno\n    rows 3 preceding)^ + 10\norder by deptno").fails("Windowed aggregate expression is illegal in GROUP BY clause");
        this.winSql("select *\n from emp\n join dept on emp.deptno = dept.deptno\n and ^sum(sal) over (partition by emp.deptno\n    order by empno\n    rows 3 preceding)^ = dept.deptno + 40\norder by deptno").fails("Windowed aggregate expression is illegal in ON clause");
        this.winSql("select sal from emp order by sum(sal) over (partition by deptno order by deptno)").ok();
        this.winExp("sum(sal)").ok();
    }

    @Test
    public void testWindowFunctions2() {
        List<String> defined = Arrays.asList("CUME_DIST", "DENSE_RANK", "PERCENT_RANK", "RANK", "ROW_NUMBER");
        this.winSql("select rank() over w from emp\nwindow w as ^(partition by sal)^, w2 as (w order by deptno)").fails("RANK or DENSE_RANK functions require ORDER BY clause in window specification");
        this.winSql("select rank() over w2 from emp\nwindow w as (partition by sal), w2 as (w order by deptno)").ok();
        this.winExp("row_number() over (order by deptno)").ok();
        this.winExp("row_number() over (partition by deptno)").ok();
        this.winExp("row_number() over ()").ok();
        this.winExp("row_number() over (order by deptno ^rows^ 2 preceding)").fails(ROW_RANGE_NOT_ALLOWED_WITH_RANK);
        this.winExp("row_number() over (order by deptno ^range^ 2 preceding)").fails(ROW_RANGE_NOT_ALLOWED_WITH_RANK);
        if (defined.contains("DENSE_RANK")) {
            this.winExp("^dense_rank()^").fails("OVER clause is necessary for window functions");
        } else {
            this.checkWinFuncExpWithWinClause("^dense_rank()^", "Function 'DENSE_RANK\\(\\)' is not defined");
        }
        this.winExp("rank() over (order by empno)").ok();
        this.winExp("percent_rank() over (order by empno)").ok();
        this.winExp("cume_dist() over (order by empno)").ok();
        this.winSql("select rank() over ^(partition by deptno)^ from emp").fails("RANK or DENSE_RANK functions require ORDER BY clause in window specification");
        this.winSql("select dense_rank() over ^(partition by deptno)^ from emp ").fails("RANK or DENSE_RANK functions require ORDER BY clause in window specification");
        this.winSql("select rank() over w from emp window w as ^(partition by deptno)^").fails("RANK or DENSE_RANK functions require ORDER BY clause in window specification");
        this.winSql("select dense_rank() over w from emp window w as ^(partition by deptno)^").fails("RANK or DENSE_RANK functions require ORDER BY clause in window specification");
        this.winSql("select rank() over w from emp window w as (order by empno ^rows^ 2 preceding )").fails(ROW_RANGE_NOT_ALLOWED_WITH_RANK);
        this.winSql("select dense_rank() over w from emp window w as (order by empno ^rows^ 2 preceding)").fails(ROW_RANGE_NOT_ALLOWED_WITH_RANK);
        if (defined.contains("PERCENT_RANK")) {
            this.winSql("select percent_rank() over w from emp\nwindow w as (order by empno)").ok();
            this.winSql("select percent_rank() over w from emp\nwindow w as (order by empno ^rows^ 2 preceding)").fails(ROW_RANGE_NOT_ALLOWED_WITH_RANK);
            this.winSql("select percent_rank() over w from emp\nwindow w as ^(partition by empno)^").fails("RANK or DENSE_RANK functions require ORDER BY clause in window specification");
        } else {
            this.checkWinFuncExpWithWinClause("^percent_rank()^", "Function 'PERCENT_RANK\\(\\)' is not defined");
        }
        if (defined.contains("CUME_DIST")) {
            this.winSql("select cume_dist() over w from emp window w as ^(rows 2 preceding)^").fails("RANK or DENSE_RANK functions require ORDER BY clause in window specification");
            this.winSql("select cume_dist() over w from emp window w as (order by empno ^rows^ 2 preceding)").fails(ROW_RANGE_NOT_ALLOWED_WITH_RANK);
            this.winSql("select cume_dist() over w from emp window w as (order by empno)").ok();
            this.winSql("select cume_dist() over (order by empno) from emp ").ok();
        } else {
            this.checkWinFuncExpWithWinClause("^cume_dist()^", "Function 'CUME_DIST\\(\\)' is not defined");
        }
        this.winSql("select rank() over (order by empno ^range^ 2 preceding ) from emp ").fails(ROW_RANGE_NOT_ALLOWED_WITH_RANK);
        this.winSql("select dense_rank() over (order by empno ^rows^ 2 preceding ) from emp ").fails(ROW_RANGE_NOT_ALLOWED_WITH_RANK);
        if (defined.contains("PERCENT_RANK")) {
            this.winSql("select percent_rank() over (order by empno) from emp").ok();
        }
        this.checkWinFuncExpWithWinClause("sum(^invalidColumn^)", "Column 'INVALIDCOLUMN' not found in any table");
        this.checkWinFuncExpWithWinClause("^invalidFun(sal)^", "No match found for function signature INVALIDFUN\\(<NUMERIC>\\)");
        this.winSql("select sum(sal) over (w partition by ^deptno^)\n from emp window w as (order by empno rows 2 preceding )").fails("PARTITION BY not allowed with existing window reference");
        this.winSql("select sum(sal) over (w order by ^empno^)\n from emp window w as (order by empno rows 2 preceding )").fails("ORDER BY not allowed in both base and referenced windows");
        this.winSql("select sum(sal) over (w)\n from emp window w as (order by empno ^rows^ 2 preceding )").fails("Referenced window cannot have framing declarations");
        this.winSql("select sum(sal) over () from emp").ok();
        this.winSql("select sum(sal) over w from emp window w as ()").ok();
        this.winSql("select count(*) over () from emp").ok();
        this.winSql("select count(*) over w from emp window w as ()").ok();
        this.winSql("select rank() over ^()^ from emp").fails("RANK or DENSE_RANK functions require ORDER BY clause in window specification");
        this.winSql("select rank() over w from emp window w as ^()^").fails("RANK or DENSE_RANK functions require ORDER BY clause in window specification");
    }

    @Test
    public void testInvalidWindowFunctionWithGroupBy() {
        this.sql("select max(^empno^) over () from emp\ngroup by deptno").fails("Expression 'EMPNO' is not being grouped");
        this.sql("select max(deptno) over (partition by ^empno^) from emp\ngroup by deptno").fails("Expression 'EMPNO' is not being grouped");
        this.sql("select rank() over (order by ^empno^) from emp\ngroup by deptno").fails("Expression 'EMPNO' is not being grouped");
    }

    @Test
    public void testInlineWinDef() {
        this.check("select sum(sal) over (partition by deptno order by empno)\nfrom emp order by empno");
        this.winExp2("sum(sal) OVER (partition by deptno order by empno rows 2 preceding )").ok();
        this.winExp2("sum(sal) OVER (order by 1 rows 2 preceding )").ok();
        this.winExp2("sum(sal) OVER (order by 'b' rows 2 preceding )").ok();
        this.winExp2("sum(sal) over (partition by deptno order by 1+1 rows 26 preceding)").ok();
        this.winExp2("sum(sal) over (order by deptno rows unbounded preceding)").ok();
        this.winExp2("sum(sal) over (order by deptno rows current row)").ok();
        this.winExp2("sum(sal) over ^(order by deptno rows between unbounded preceding and unbounded following)^").ok();
        this.winExp2("sum(sal) over ^(order by deptno rows between CURRENT ROW and unbounded following)^").ok();
        this.winExp2("sum(sal) over (order by deptno rows between unbounded preceding and CURRENT ROW)").ok();
        this.winExp2("sum(sal) over (order by deptno rows between CURRENT ROW and CURRENT ROW)").ok();
        this.winExp2("sum(sal) over (order by deptno range between CURRENT ROW and CURRENT ROW)").ok();
        this.winExp2("sum(sal) over (order by deptno rows between 2 preceding and CURRENT ROW)").ok();
        this.winExp("sum(sal) OVER (w rows 2 preceding )").ok();
        this.winExp2("sum(sal) over (order by deptno range 2.0 preceding)").ok();
        this.winExp2("sum(sal) over (order by deptno rows between ^UNBOUNDED FOLLOWING^ and unbounded preceding)").fails("UNBOUNDED FOLLOWING cannot be specified for the lower frame boundary");
        this.winExp2("sum(sal) over (order by deptno rows between 2 preceding and ^UNBOUNDED PRECEDING^)").fails("UNBOUNDED PRECEDING cannot be specified for the upper frame boundary");
        this.winExp2("sum(sal) over (order by deptno rows between CURRENT ROW and ^2 preceding^)").fails("Upper frame boundary cannot be PRECEDING when lower boundary is CURRENT ROW");
        this.winExp2("sum(sal) over (order by deptno rows between 2 following and ^CURRENT ROW^)").fails("Upper frame boundary cannot be CURRENT ROW when lower boundary is FOLLOWING");
        this.winExp2("sum(sal) over (order by deptno rows between 2 following and ^2 preceding^)").fails("Upper frame boundary cannot be PRECEDING when lower boundary is FOLLOWING");
        this.winExp2("sum(sal) over (order by deptno RANGE BETWEEN ^INTERVAL '1' SECOND^ PRECEDING AND INTERVAL '1' SECOND FOLLOWING)").fails("Data Type mismatch between ORDER BY and RANGE clause");
        this.winExp2("sum(sal) over (order by empno RANGE BETWEEN ^INTERVAL '1' SECOND^ PRECEDING AND INTERVAL '1' SECOND FOLLOWING)").fails("Data Type mismatch between ORDER BY and RANGE clause");
        this.winExp2("sum(sal) over (order by deptno, empno ^range^ 2 preceding)").fails("RANGE clause cannot be used with compound ORDER BY clause");
        this.winExp2("sum(sal) over ^(partition by deptno range 5 preceding)^").fails("Window specification must contain an ORDER BY clause");
        this.winExp2("sum(sal) over ^w1^").fails("Window 'W1' not found");
        this.winExp2("sum(sal) OVER (^w1^ partition by deptno order by empno rows 2 preceding )").fails("Window 'W1' not found");
    }

    @Test
    public void testPartitionByExpr() {
        this.winExp2("sum(sal) over (partition by empno + deptno order by empno range 5 preceding)").ok();
        this.winExp2("sum(sal) over (partition by ^empno + ename^ order by empno range 5 preceding)").fails("(?s)Cannot apply '\\+' to arguments of type '<INTEGER> \\+ <VARCHAR\\(20\\)>'.*");
    }

    @Test
    public void testWindowClause() {
        this.winExp("sum(sal) as sumsal").ok();
        this.win("window w as (partition by sal order by deptno rows 2 preceding)").ok();
        this.win("window w as (order by sal), w1 as (w)").ok();
        this.win("window w as ^(range 100 preceding)^").fails("Window specification must contain an ORDER BY clause");
        this.win("window w as (order by sal range 100 preceding)").ok();
        this.win("window w as (order by hiredate range ^100^ preceding)").fails("Data Type mismatch between ORDER BY and RANGE clause");
        this.win("window w as (order by ename range ^100^ preceding)").fails("Data type of ORDER BY prohibits use of RANGE clause");
        this.win("window w as (rows 2 preceding)").ok();
        this.win("window w as (rows ^-2.5^ preceding)").fails("ROWS value must be a non-negative integral constant");
        this.win("window w as (rows ^-2^ preceding)").fails("ROWS value must be a non-negative integral constant");
        this.win("window w as (rows ^2.5^ preceding)").fails("ROWS value must be a non-negative integral constant");
        this.win("window w as (partition by ^xyz^)").fails("Column 'XYZ' not found in any table");
        this.win("window w as ^( /* boo! */  )^").ok();
        this.win("window w as (order by empno), ^w^ as (order by empno)").fails("Duplicate window names not allowed");
        this.win("window win1 as (order by empno), ^win1^ as (order by empno)").fails("Duplicate window names not allowed");
        this.sql("select min(sal) over (order by deptno) from emp group by deptno,sal").ok();
        this.checkFails("select min(sal) over (order by ^deptno^) from emp group by sal", "Expression 'DEPTNO' is not being grouped");
        this.sql("select min(sal) over\n(partition by comm order by deptno) from emp group by deptno,sal,comm").ok();
        this.checkFails("select min(sal) over\n(partition by ^comm^ order by deptno) from emp group by deptno,sal", "Expression 'COMM' is not being grouped");
        this.win("window w as ^(order by rank() over (order by sal))^").fails("ORDER BY expression should not contain OVER clause");
        this.win("window w as (rows between ^unbounded following^ and 5 following)").fails("UNBOUNDED FOLLOWING cannot be specified for the lower frame boundary");
        this.win("window w as (order by deptno rows between 2 preceding and ^UNBOUNDED PRECEDING^)").fails("UNBOUNDED PRECEDING cannot be specified for the upper frame boundary");
        this.win("window w as (order by deptno rows between 2 following and ^2 preceding^)").fails("Upper frame boundary cannot be PRECEDING when lower boundary is FOLLOWING");
        this.win("window w as (order by deptno rows between CURRENT ROW and ^2 preceding^)").fails("Upper frame boundary cannot be PRECEDING when lower boundary is CURRENT ROW");
        this.win("window w as (order by deptno rows between 2 following and ^CURRENT ROW^)").fails("Upper frame boundary cannot be CURRENT ROW when lower boundary is FOLLOWING");
        this.win("window w as (w2 range 2 preceding ), w2 as (order by sal)").ok();
        this.win("window w as ^(partition by sal)^, w2 as (w order by deptno)").ok();
        this.win("window w as (w2 partition by ^sal^), w2 as (order by deptno)").fails("PARTITION BY not allowed with existing window reference");
        this.win("window w as (partition by sal order by deptno), w2 as (w order by ^deptno^)").fails("ORDER BY not allowed in both base and referenced windows");
        this.win("window w as (w2 order by deptno), w2 as (^range^ 100 preceding)").fails("Referenced window cannot have framing declarations");
        this.win("window w as (order by sal)").ok();
        this.win("window w as (order by ^non_exist_col^)").fails("Column 'NON_EXIST_COL' not found in any table");
        this.win("window w as (partition by ^non_exist_col^ order by sal)").fails("Column 'NON_EXIST_COL' not found in any table");
    }

    @Test
    public void testWindowClause2() {
        this.win("window\nw  as (partition by deptno order by empno rows 2 preceding),\nw2 as ^(partition by deptno order by empno rows 2 preceding)^\n").fails("Duplicate window specification not allowed in the same window clause");
    }

    @Test
    public void testWindowClauseWithSubQuery() {
        this.check("select * from\n( select sum(empno) over w, sum(deptno) over w from emp\nwindow w as (order by hiredate range interval '1' minute preceding))");
        this.check("select * from\n( select sum(empno) over w, sum(deptno) over w, hiredate from emp)\nwindow w as (order by hiredate range interval '1' minute preceding)");
        this.checkFails("select * from\n( select sum(empno) over w, sum(deptno) over w from emp)\nwindow w as (order by ^hiredate^ range interval '1' minute preceding)", "Column 'HIREDATE' not found in any table");
    }

    @Test
    public void testPartitionByColumnInJoinAlias() {
        this.sql("select sum(1) over(partition by t1.ename) \nfrom emp t1, emp t2").ok();
        this.sql("select sum(1) over(partition by emp.ename) \nfrom emp, dept").ok();
        this.sql("select sum(1) over(partition by ^deptno^) \nfrom emp, dept").fails("Column 'DEPTNO' is ambiguous");
    }

    @Test
    public void testOrderByColumn() {
        this.sql("select emp.deptno from emp, dept order by emp.deptno").ok();
        this.sql("select emp.deptno from emp, dept order by deptno").ok();
        this.sql("select emp.deptno as deptno from emp, dept order by deptno").ok();
        this.sql("select emp.empno as deptno from emp, dept order by deptno").ok();
        this.sql("select emp.deptno as n, dept.deptno as n from emp, dept order by ^n^").fails("Column 'N' is ambiguous");
        this.sql("select emp.empno as deptno, dept.deptno from emp, dept\norder by ^deptno^").fails("Column 'DEPTNO' is ambiguous");
        this.sql("select emp.empno as deptno, dept.deptno from emp, dept\norder by emp.deptno").ok();
        this.sql("select emp.empno as deptno, dept.deptno from emp, dept order by 1, 2").ok();
        this.sql("select empno as \"deptno\", deptno from emp order by deptno").ok();
        this.sql("select empno as \"deptno\", deptno from emp order by \"deptno\"").ok();
    }

    @Test
    public void testWindowNegative() {
        String negSize = null;
        this.checkNegWindow("rows between 2 preceding and 4 preceding", negSize);
        this.checkNegWindow("rows between 2 preceding and 3 preceding", negSize);
        this.checkNegWindow("rows between 2 preceding and 2 preceding", null);
        this.checkNegWindow("rows between unbounded preceding and current row", null);
        String unboundedFollowing = null;
        this.checkNegWindow("rows between unbounded preceding and unbounded following", unboundedFollowing);
        this.checkNegWindow("rows between current row and unbounded following", unboundedFollowing);
        this.checkNegWindow("rows between current row and 2 following", null);
        this.checkNegWindow("range between 2 preceding and 2 following", null);
        this.checkNegWindow("range between 2 preceding and -2 preceding", null);
        this.checkNegWindow("range between 4 following and 3 following", negSize);
        this.checkNegWindow("range between 4 following and 5 following", null);
        this.checkNegWindow("rows between 1 following and 0 following", negSize);
        this.checkNegWindow("rows between 0 following and 0 following", null);
    }

    private void checkNegWindow(String s, String msg) {
        String sql = "select sum(deptno) over ^(order by empno " + s + ")^ from emp";
        this.checkFails(sql, msg);
    }

    @Test
    public void testWindowPartial() {
        this.check("select sum(deptno) over (\norder by deptno, empno rows 2 preceding disallow partial)\nfrom emp");
        this.checkFails("select sum(deptno) over (\n  partition by deptno\n  order by empno\n  range between 2 preceding and 3 following\n  ^disallow partial^)\nfrom emp", "Cannot use DISALLOW PARTIAL with window based on RANGE");
    }

    @Test
    public void testOneWinFunc() {
        this.win("window w as (partition by sal order by deptno rows 2 preceding)").ok();
    }

    @Test
    public void testNameResolutionInValuesClause() {
        String emps = "(select 1 as empno, 'x' as name, 10 as deptno, 'M' as gender, 'San Francisco' as city, 30 as empid, 25 as age from (values (1)))";
        String depts = "(select 10 as deptno, 'Sales' as name from (values (1)))";
        this.checkFails("select * from (select 1 as empno, 'x' as name, 10 as deptno, 'M' as gender, 'San Francisco' as city, 30 as empid, 25 as age from (values (1))) join (select 10 as deptno, 'Sales' as name from (values (1)))\n on ^emps^.deptno = deptno", "Table 'EMPS' not found");
        this.check("select * from (select 1 as empno, 'x' as name, 10 as deptno, 'M' as gender, 'San Francisco' as city, 30 as empid, 25 as age from (values (1))) as e\n join (select 10 as deptno, 'Sales' as name from (values (1))) as d\n on e.deptno = d.deptno");
        this.checkFails("select * from (select 1 as empno, 'x' as name, 10 as deptno, 'M' as gender, 'San Francisco' as city, 30 as empid, 25 as age from (values (1))) as emps,\n (select 10 as deptno, 'Sales' as name from (values (1)))\nwhere ^deptno^ > 5", "Column 'DEPTNO' is ambiguous");
        this.checkFails("select * from (select 1 as empno, 'x' as name, 10 as deptno, 'M' as gender, 'San Francisco' as city, 30 as empid, 25 as age from (values (1))) as e\n join (select 10 as deptno, 'Sales' as name from (values (1))) as d\n on e.deptno = ^deptno^", "Column 'DEPTNO' is ambiguous");
        this.check("select * from (select 1 as empno, 'x' as name, 10 as deptno, 'M' as gender, 'San Francisco' as city, 30 as empid, 25 as age from (values (1))) as e\n join (select 10 as deptno, 'Sales' as name from (values (1))) as d\n on e.deptno = age");
        this.check("select * from (select 10 as deptno, 'Sales' as name from (values (1)))\n join (select mod(age, 30) as agemod from (select 1 as empno, 'x' as name, 10 as deptno, 'M' as gender, 'San Francisco' as city, 30 as empid, 25 as age from (values (1))))\non deptno = agemod");
        this.checkFails("select name from (select 10 as deptno, 'Sales' as name from (values (1)))\njoin (select mod(age, 30) as agemod, deptno from (select 1 as empno, 'x' as name, 10 as deptno, 'M' as gender, 'San Francisco' as city, 30 as empid, 25 as age from (values (1))))\non ^deptno^ = agemod", "Column 'DEPTNO' is ambiguous");
        this.checkFails("select * from (select 1 as empno, 'x' as name, 10 as deptno, 'M' as gender, 'San Francisco' as city, 30 as empid, 25 as age from (values (1))) as e,\n (select 1, ^e^.deptno from (values(true))) as d", "Table 'E' not found");
    }

    @Test
    public void testNestedFrom() {
        this.checkColumnType("values (true)", "BOOLEAN NOT NULL");
        this.checkColumnType("select * from (values(true))", "BOOLEAN NOT NULL");
        this.checkColumnType("select * from (select * from (values(true)))", "BOOLEAN NOT NULL");
        this.checkColumnType("select * from (select * from (select * from (values(true))))", "BOOLEAN NOT NULL");
        this.checkColumnType("select * from (  select * from (    select * from (values(true))    union    select * from (values (false)))  except  select * from (values(true)))", "BOOLEAN NOT NULL");
    }

    @Test
    public void testAmbiguousColumn() {
        this.checkFails("select * from emp join dept\n on emp.deptno = ^deptno^", "Column 'DEPTNO' is ambiguous");
        this.check("select * from emp as e\n join dept as d\n on e.deptno = d.deptno");
        this.checkFails("select * from emp as emps, dept\nwhere ^deptno^ > 5", "Column 'DEPTNO' is ambiguous");
        this.checkFails("select * from emp as emps, dept as d\nwhere ^dept^.deptno > 5", "Table 'DEPT' not found");
        this.checkFails("select * from emp as e\n join dept as d\n on e.deptno = ^deptno^", "Column 'DEPTNO' is ambiguous");
        this.check("select * from emp as e\n join dept as d\n on e.deptno = comm");
        this.check("select * from dept\n join (select mod(comm, 30) as commmod from emp)\non deptno = commmod");
        this.checkFails("select name from dept\njoin (select mod(comm, 30) as commmod, deptno from emp)\non ^deptno^ = commmod", "Column 'DEPTNO' is ambiguous");
        this.checkFails("select * from emp as e,\n (select 1, ^e^.deptno from (values(true))) as d", "Table 'E' not found");
    }

    @Test
    public void testExpandStar() {
        this.checkFails("select ^r^.* from dept", "Unknown identifier 'R'");
        this.check("select e.* from emp as e");
        this.check("select emp.* from emp");
        this.sql("select ^empno^ .  * from emp").fails("Not a record type. The '\\*' operator requires a record");
        this.sql("select ^emp.empno^ .  * from emp").fails("Not a record type. The '\\*' operator requires a record");
    }

    @Test
    public void testStarIdentifier() {
        this.sql("SELECT * FROM (VALUES (0, 0)) AS T(A, \"*\")").type("RecordType(INTEGER NOT NULL A, INTEGER NOT NULL *) NOT NULL");
    }

    @Test
    public void testStarAliasFails() {
        this.sql("select emp.^*^ AS x from emp").fails("Unknown field '\\*'");
    }

    @Test
    public void testNonLocalStar() {
        this.sql("select * from emp e where exists (\n  select e.* from dept where dept.deptno = e.deptno)").type(EMP_RECORD_TYPE);
    }

    @Test
    public void testStarInFromFails() {
        this.sql("select emp.empno AS x from ^sales.*^").fails("Object '\\*' not found within 'SALES'");
        this.sql("select * from ^emp.*^").fails("Object '\\*' not found within 'SALES.EMP'");
        this.sql("select emp.empno AS x from ^emp.*^").fails("Object '\\*' not found within 'SALES.EMP'");
        this.sql("select emp.empno from emp where emp.^*^ is not null").fails("Unknown field '\\*'");
    }

    @Test
    public void testStarDotIdFails() {
        this.sql("select emp.^*^.foo from emp").fails("(?s).*Encountered \".\" at .*");
        this.sql("select ^*^.foo from emp").fails("(?s).*Encountered \".\" at .*");
    }

    @Test
    public void testAsColumnList() {
        this.check("select d.a, b from dept as d(a, b)");
        this.checkFails("select d.^deptno^ from dept as d(a, b)", "(?s).*Column 'DEPTNO' not found in table 'D'.*");
        this.checkFails("select 1 from dept as d(^a, b, c^)", "(?s).*List of column aliases must have same degree as table; table has 2 columns \\('DEPTNO', 'NAME'\\), whereas alias list has 3 columns.*");
        this.checkResultType("select * from dept as d(a, b)", "RecordType(INTEGER NOT NULL A, VARCHAR(10) NOT NULL B) NOT NULL");
        this.checkResultType("select * from (values ('a', 1), ('bc', 2)) t (a, b)", "RecordType(CHAR(2) NOT NULL A, INTEGER NOT NULL B) NOT NULL");
    }

    public void _testAmbiguousColumnInIn() {
        this.check("select * from emp as e\nwhere e.deptno in (\n  select 1 from (values(true)) where e.empno > 10)");
        this.check("select * from emp as e\nwhere e.deptno in (\n  select e.deptno from (values(true)))");
    }

    @Test
    public void testInList() {
        this.check("select * from emp where empno in (10,20)");
        this.check("select * from emp\nwhere empno in (10 + deptno, cast(null as integer))");
        this.checkFails("select * from emp where empno in ^(10, '20')^", ERR_IN_VALUES_INCOMPATIBLE);
        this.checkExpType("1 in (2, 3, 4)", "BOOLEAN NOT NULL");
        this.checkExpType("cast(null as integer) in (2, 3, 4)", "BOOLEAN");
        this.checkExpType("1 in (2, cast(null as integer) , 4)", "BOOLEAN");
        this.checkExpType("1 in (2.5, 3.14)", "BOOLEAN NOT NULL");
        this.checkExpType("true in (false, unknown)", "BOOLEAN");
        this.checkExpType("true in (false, false or unknown)", "BOOLEAN");
        this.checkExpType("true in (false, true)", "BOOLEAN NOT NULL");
        this.checkExpType("(1,2) in ((1,2), (3,4))", "BOOLEAN NOT NULL");
        this.checkExpType("'medium' in (cast(null as varchar(10)), 'bc')", "BOOLEAN");
        this.checkColumnType("select empno in (1, 2) from emp", "BOOLEAN NOT NULL");
        this.checkColumnType("select nullif(empno,empno) in (1, 2) from emp", "BOOLEAN");
        this.checkColumnType("select empno in (1, nullif(empno,empno), 2) from emp", "BOOLEAN");
        this.checkExpFails("1 in ^(2, 'c')^", ERR_IN_VALUES_INCOMPATIBLE);
        this.checkExpFails("1 in ^((2), (3,4))^", ERR_IN_VALUES_INCOMPATIBLE);
        this.checkExp("false and ^1 in ('b', 'c')^");
        this.checkExpFails("false and ^1 in (date '2012-01-02', date '2012-01-04')^", ERR_IN_OPERANDS_INCOMPATIBLE);
        this.checkExpFails("1 > 5 or ^(1, 2) in (3, 4)^", ERR_IN_OPERANDS_INCOMPATIBLE);
    }

    @Test
    public void testInSubQuery() {
        this.check("select * from emp where deptno in (select deptno from dept)");
        this.check("select * from emp where (empno,deptno) in (select deptno,deptno from dept)");
        this.checkFails("select * from emp where ^deptno in (select deptno,deptno from dept^)", ERR_IN_OPERANDS_INCOMPATIBLE);
    }

    @Test
    public void testDoubleNoAlias() {
        this.check("select * from emp join dept on true");
        this.check("select * from emp, dept");
        this.check("select * from emp cross join dept");
    }

    @Test
    public void testDuplicateColumnAliasIsOK() {
        this.check("select 1 as a, 2 as b, 3 as a from emp");
    }

    @Test
    public void testDuplicateTableAliasFails() {
        this.checkFails("select 1 from emp, ^emp^", "Duplicate relation name 'EMP' in FROM clause");
        this.checkFails("select 1 from emp join ^emp^ on emp.empno = emp.mgrno", "Duplicate relation name 'EMP' in FROM clause");
        this.checkFails("select 1 from emp join ^dept as emp^ on emp.empno = emp.deptno", "Duplicate relation name 'EMP' in FROM clause");
        this.check("select 1 from emp as e join emp on emp.empno = e.deptno");
        this.check("select 1 from emp as e join dept as emp on e.empno = emp.deptno");
        this.checkFails("select 1 from emp, dept, emp as e, ^dept as emp^, emp", "Duplicate relation name 'EMP' in FROM clause");
        this.checkFails("select 1 from emp, (^select 1 as x from (values (true))) as emp^", "Duplicate relation name 'EMP' in FROM clause");
        this.checkFails("select 1 from emp, (^values (true,false)) as emp (b, c)^, dept as emp", "Duplicate relation name 'EMP' in FROM clause");
        this.checkFails("select 1 from emp, ^table(foo()) as emp^", "Duplicate relation name 'EMP' in FROM clause");
        this.checkFails("select 1 from emp, ^(table foo.bar.emp) as emp^", "Duplicate relation name 'EMP' in FROM clause");
        this.check("select 1 from emp, dept where exists (\n  select 1 from emp where emp.empno = emp.deptno)");
    }

    @Test
    public void testSchemaTableStar() {
        this.sql("select ^sales.e^.* from sales.emp as e").fails("Unknown identifier 'SALES\\.E'");
        this.sql("select sales.dept.* from sales.dept").type("RecordType(INTEGER NOT NULL DEPTNO, VARCHAR(10) NOT NULL NAME) NOT NULL");
        this.sql("select sales.emp.* from emp").ok();
        this.sql("select sales.emp.* from emp as emp").ok();
        this.sql("select ^sales.emp^.* from emp as e").fails("Unknown identifier 'SALES.EMP'");
    }

    @Test
    public void testSchemaTableColumn() {
        this.sql("select emp.empno from sales.emp").ok();
        this.sql("select sales.emp.empno from sales.emp").ok();
        this.sql("select sales.emp.empno from sales.emp\nwhere sales.emp.deptno > 0").ok();
        this.sql("select 1 from sales.emp where sales.emp.^bad^ < 0").fails("Column 'BAD' not found in table 'SALES.EMP'");
        this.sql("select ^sales.bad^.empno from sales.emp\nwhere sales.emp.deptno > 0").fails("Table 'SALES\\.BAD' not found");
        this.sql("select sales.emp.deptno from sales.emp").ok();
        this.sql("select 1 from sales.emp where sales.emp.deptno = 10").ok();
        this.sql("select 1 from sales.emp order by sales.emp.deptno").ok();
        this.sql("select sales.emp.deptno from sales.emp as emp").ok();
        this.sql("select ^sales.emp^.deptno from sales.emp as e").fails("Table 'SALES\\.EMP' not found");
        this.sql("select sales.emp.deptno from sales.emp, ^sales.emp^").fails("Duplicate relation name 'EMP' in FROM clause");
        this.sql("select ^sales.emp^.deptno from sales.dept as d1, sales.dept").fails("Table 'SALES.EMP' not found");
        this.sql("select ^sales.bad^.deptno from sales.dept as d1, sales.dept").fails("Table 'SALES.BAD' not found");
    }

    @Test
    public void testSchemaTableColumnInGroupBy() {
        this.sql("select 1 from sales.emp group by sales.emp.deptno").ok();
        this.sql("select deptno from sales.emp group by sales.emp.deptno").ok();
        this.sql("select deptno + 1 from sales.emp group by sales.emp.deptno").ok();
    }

    @Test
    public void testInvalidGroupBy() {
        this.sql("select ^empno^, deptno from emp group by deptno").fails("Expression 'EMPNO' is not being grouped");
    }

    @Test
    public void testInvalidGroupBy2() {
        this.sql("select count(*) from emp group by ^deptno + 'a'^").fails("(?s)Cannot apply '\\+' to arguments of type.*");
    }

    @Test
    public void testInvalidGroupBy3() {
        this.sql("select deptno / 2 + 1, count(*) as c\nfrom emp\ngroup by rollup(deptno / 2, sal), rollup(empno, ^deptno + 'a'^)").fails("(?s)Cannot apply '\\+' to arguments of type.*");
    }

    @Test
    public void testCubeExpression() {
        String sql = "select deptno + 1\nfrom emp\ngroup by cube(deptno + 1)";
        this.sql("select deptno + 1\nfrom emp\ngroup by cube(deptno + 1)").ok();
        String sql2 = "select deptno + 2 - 2\nfrom emp\ngroup by cube(deptno + 2, empno)";
        this.sql("select deptno + 2 - 2\nfrom emp\ngroup by cube(deptno + 2, empno)").ok();
        String sql3 = "select ^deptno^\nfrom emp\ngroup by cube(deptno + 1)";
        this.sql("select ^deptno^\nfrom emp\ngroup by cube(deptno + 1)").fails("Expression 'DEPTNO' is not being grouped");
        String sql4 = "select ^deptno^ + 10\nfrom emp\ngroup by rollup(empno, deptno + 10 - 10)";
        this.sql("select ^deptno^ + 10\nfrom emp\ngroup by rollup(empno, deptno + 10 - 10)").fails("Expression 'DEPTNO' is not being grouped");
        String sql5 = "select deptno + 10\nfrom emp\ngroup by rollup(deptno + 10 - 10, deptno)";
        this.sql("select deptno + 10\nfrom emp\ngroup by rollup(deptno + 10 - 10, deptno)").ok();
    }

    @Test
    public void testRollupBitSets() {
        Assert.assertThat((Object)this.rollup(ImmutableBitSet.of((int[])new int[]{1}), ImmutableBitSet.of((int[])new int[]{3})).toString(), (Matcher)CoreMatchers.equalTo((Object)"[{1, 3}, {1}, {}]"));
        Assert.assertThat((Object)this.rollup(ImmutableBitSet.of((int[])new int[]{1}), ImmutableBitSet.of((int[])new int[]{3, 4})).toString(), (Matcher)CoreMatchers.equalTo((Object)"[{1, 3, 4}, {1}, {}]"));
        Assert.assertThat((Object)this.rollup(ImmutableBitSet.of((int[])new int[]{1, 3}), ImmutableBitSet.of((int[])new int[]{4})).toString(), (Matcher)CoreMatchers.equalTo((Object)"[{1, 3, 4}, {1, 3}, {}]"));
        Assert.assertThat((Object)this.rollup(ImmutableBitSet.of((int[])new int[]{1, 4}), ImmutableBitSet.of((int[])new int[]{3})).toString(), (Matcher)CoreMatchers.equalTo((Object)"[{1, 3, 4}, {1, 4}, {}]"));
        Assert.assertThat((Object)this.rollup(ImmutableBitSet.of((int[])new int[]{1, 4}), ImmutableBitSet.of((int[])new int[]{3, 4})).toString(), (Matcher)CoreMatchers.equalTo((Object)"[{1, 3, 4}, {1, 4}, {}]"));
        Assert.assertThat((Object)this.rollup(ImmutableBitSet.of((int[])new int[]{1, 4}), ImmutableBitSet.of(), ImmutableBitSet.of((int[])new int[]{3, 4}), ImmutableBitSet.of()).toString(), (Matcher)CoreMatchers.equalTo((Object)"[{1, 3, 4}, {1, 4}, {}]"));
        Assert.assertThat((Object)this.rollup(ImmutableBitSet.of((int[])new int[]{1})).toString(), (Matcher)CoreMatchers.equalTo((Object)"[{1}, {}]"));
        Assert.assertThat((Object)this.rollup(ImmutableBitSet.of()).toString(), (Matcher)CoreMatchers.equalTo((Object)"[{}]"));
        Assert.assertThat((Object)this.rollup(new ImmutableBitSet[0]).toString(), (Matcher)CoreMatchers.equalTo((Object)"[{}]"));
    }

    private ImmutableList<ImmutableBitSet> rollup(ImmutableBitSet ... sets) {
        return SqlValidatorUtil.rollup((List)ImmutableList.copyOf((Object[])sets));
    }

    @Test
    public void testCubeBitSets() {
        Assert.assertThat((Object)this.cube(ImmutableBitSet.of((int[])new int[]{1}), ImmutableBitSet.of((int[])new int[]{3})).toString(), (Matcher)CoreMatchers.equalTo((Object)"[{1, 3}, {1}, {3}, {}]"));
        Assert.assertThat((Object)this.cube(ImmutableBitSet.of((int[])new int[]{1}), ImmutableBitSet.of((int[])new int[]{3, 4})).toString(), (Matcher)CoreMatchers.equalTo((Object)"[{1, 3, 4}, {1}, {3, 4}, {}]"));
        Assert.assertThat((Object)this.cube(ImmutableBitSet.of((int[])new int[]{1, 3}), ImmutableBitSet.of((int[])new int[]{4})).toString(), (Matcher)CoreMatchers.equalTo((Object)"[{1, 3, 4}, {1, 3}, {4}, {}]"));
        Assert.assertThat((Object)this.cube(ImmutableBitSet.of((int[])new int[]{1, 4}), ImmutableBitSet.of((int[])new int[]{3})).toString(), (Matcher)CoreMatchers.equalTo((Object)"[{1, 3, 4}, {1, 4}, {3}, {}]"));
        Assert.assertThat((Object)this.cube(ImmutableBitSet.of((int[])new int[]{1, 4}), ImmutableBitSet.of((int[])new int[]{3, 4})).toString(), (Matcher)CoreMatchers.equalTo((Object)"[{1, 3, 4}, {1, 4}, {3, 4}, {}]"));
        Assert.assertThat((Object)this.cube(ImmutableBitSet.of((int[])new int[]{1, 4}), ImmutableBitSet.of(), ImmutableBitSet.of((int[])new int[]{1, 4}), ImmutableBitSet.of((int[])new int[]{3, 4}), ImmutableBitSet.of()).toString(), (Matcher)CoreMatchers.equalTo((Object)"[{1, 3, 4}, {1, 4}, {3, 4}, {}]"));
        Assert.assertThat((Object)this.cube(ImmutableBitSet.of((int[])new int[]{1})).toString(), (Matcher)CoreMatchers.equalTo((Object)"[{1}, {}]"));
        Assert.assertThat((Object)this.cube(ImmutableBitSet.of()).toString(), (Matcher)CoreMatchers.equalTo((Object)"[{}]"));
        Assert.assertThat((Object)this.cube(new ImmutableBitSet[0]).toString(), (Matcher)CoreMatchers.equalTo((Object)"[{}]"));
    }

    private ImmutableList<ImmutableBitSet> cube(ImmutableBitSet ... sets) {
        return SqlValidatorUtil.cube((List)ImmutableList.copyOf((Object[])sets));
    }

    @Test
    public void testGrouping() {
        this.sql("select deptno, grouping(deptno) from emp group by deptno").ok();
        this.sql("select deptno, grouping(deptno, deptno) from emp group by deptno").ok();
        this.sql("select deptno / 2, grouping(deptno / 2),\n ^grouping(deptno / 2, empno)^\nfrom emp group by deptno / 2, empno").ok();
        this.sql("select deptno, grouping(^empno^) from emp group by deptno").fails("Argument to GROUPING operator must be a grouped expression");
        this.sql("select deptno, grouping(deptno, ^empno^) from emp group by deptno").fails("Argument to GROUPING operator must be a grouped expression");
        this.sql("select deptno, grouping(^empno^, deptno) from emp group by deptno").fails("Argument to GROUPING operator must be a grouped expression");
        this.sql("select deptno, grouping(^deptno + 1^) from emp group by deptno").fails("Argument to GROUPING operator must be a grouped expression");
        this.sql("select deptno, grouping(emp.^xxx^) from emp").fails("Column 'XXX' not found in table 'EMP'");
        this.sql("select deptno, ^grouping(deptno)^ from emp").fails("GROUPING operator may only occur in an aggregate query");
        this.sql("select deptno, sum(^grouping(deptno)^) over () from emp").fails("GROUPING operator may only occur in an aggregate query");
        this.sql("select deptno from emp group by deptno having grouping(deptno) < 5").ok();
        this.sql("select deptno from emp group by deptno order by grouping(deptno)").ok();
        this.sql("select deptno as xx from emp group by deptno order by grouping(xx)").ok();
        this.sql("select deptno as empno from emp\ngroup by deptno order by grouping(empno)").ok();
        this.sql("select 1 as deptno from emp\ngroup by deptno order by grouping(^deptno^)").fails("Argument to GROUPING operator must be a grouped expression");
        this.sql("select deptno from emp group by deptno order by grouping(emp.deptno)").ok();
        this.sql("select ^deptno^ from emp group by empno order by grouping(deptno)").fails("Expression 'DEPTNO' is not being grouped");
        this.sql("select deptno from emp order by ^grouping(deptno)^").fails("GROUPING operator may only occur in an aggregate query");
        this.sql("select deptno from emp where ^grouping(deptno)^ = 1").fails("GROUPING operator may only occur in an aggregate query");
        this.sql("select deptno from emp where ^grouping(deptno)^ = 1 group by deptno").fails("GROUPING operator may only occur in SELECT, HAVING or ORDER BY clause");
        this.sql("select deptno from emp group by deptno, ^grouping(deptno)^").fails("GROUPING operator may only occur in SELECT, HAVING or ORDER BY clause");
        this.sql("select deptno from emp\ngroup by grouping sets(deptno, ^grouping(deptno)^)").fails("GROUPING operator may only occur in SELECT, HAVING or ORDER BY clause");
        this.sql("select deptno from emp\ngroup by cube(empno, ^grouping(deptno)^)").fails("GROUPING operator may only occur in SELECT, HAVING or ORDER BY clause");
        this.sql("select deptno from emp\ngroup by rollup(empno, ^grouping(deptno)^)").fails("GROUPING operator may only occur in SELECT, HAVING or ORDER BY clause");
    }

    @Test
    public void testGroupingId() {
        this.sql("select deptno, grouping_id(deptno) from emp group by deptno").ok();
        this.sql("select deptno, grouping_id(deptno, deptno) from emp group by deptno").ok();
        this.sql("select deptno / 2, grouping_id(deptno / 2),\n ^grouping_id(deptno / 2, empno)^\nfrom emp group by deptno / 2, empno").ok();
        this.sql("select deptno / 2, ^grouping_id()^\nfrom emp group by deptno / 2, empno").fails("Invalid number of arguments to function 'GROUPING_ID'. Was expecting 1 arguments");
        this.sql("select deptno, grouping_id(^empno^) from emp group by deptno").fails("Argument to GROUPING_ID operator must be a grouped expression");
        this.sql("select deptno, grouping_id(^deptno + 1^) from emp group by deptno").fails("Argument to GROUPING_ID operator must be a grouped expression");
        this.sql("select deptno, grouping_id(emp.^xxx^) from emp").fails("Column 'XXX' not found in table 'EMP'");
        this.sql("select deptno, ^grouping_id(deptno)^ from emp").fails("GROUPING_ID operator may only occur in an aggregate query");
        this.sql("select deptno, sum(^grouping_id(deptno)^) over () from emp").fails("GROUPING_ID operator may only occur in an aggregate query");
        this.sql("select deptno from emp group by deptno having grouping_id(deptno) < 5").ok();
        this.sql("select deptno from emp group by deptno order by grouping_id(deptno)").ok();
        this.sql("select deptno as xx from emp group by deptno order by grouping_id(xx)").ok();
        this.sql("select deptno as empno from emp\ngroup by deptno order by grouping_id(empno)").ok();
        this.sql("select 1 as deptno from emp\ngroup by deptno order by grouping_id(^deptno^)").fails("Argument to GROUPING_ID operator must be a grouped expression");
        this.sql("select deptno from emp group by deptno\norder by grouping_id(emp.deptno)").ok();
        this.sql("select ^deptno^ from emp group by empno order by grouping_id(deptno)").fails("Expression 'DEPTNO' is not being grouped");
        this.sql("select deptno from emp order by ^grouping_id(deptno)^").fails("GROUPING_ID operator may only occur in an aggregate query");
        this.sql("select deptno from emp where ^grouping_id(deptno)^ = 1").fails("GROUPING_ID operator may only occur in an aggregate query");
        this.sql("select deptno from emp where ^grouping_id(deptno)^ = 1\ngroup by deptno").fails("GROUPING_ID operator may only occur in SELECT, HAVING or ORDER BY clause");
        this.sql("select deptno from emp group by deptno, ^grouping_id(deptno)^").fails("GROUPING_ID operator may only occur in SELECT, HAVING or ORDER BY clause");
        this.sql("select deptno from emp\ngroup by grouping sets(deptno, ^grouping_id(deptno)^)").fails("GROUPING_ID operator may only occur in SELECT, HAVING or ORDER BY clause");
        this.sql("select deptno from emp\ngroup by cube(empno, ^grouping_id(deptno)^)").fails("GROUPING_ID operator may only occur in SELECT, HAVING or ORDER BY clause");
        this.sql("select deptno from emp\ngroup by rollup(empno, ^grouping_id(deptno)^)").fails("GROUPING_ID operator may only occur in SELECT, HAVING or ORDER BY clause");
    }

    @Test
    public void testGroupId() {
        this.sql("select deptno, group_id() from emp group by deptno").ok();
        this.sql("select deptno, ^group_id^ as x from emp group by deptno").fails("Column 'GROUP_ID' not found in any table");
        this.sql("select deptno, ^group_id(deptno)^ from emp group by deptno").fails("Invalid number of arguments to function 'GROUP_ID'\\. Was expecting 0 arguments");
        this.sql("select deptno from emp order by ^group_id(deptno)^").fails("GROUP_ID operator may only occur in an aggregate query");
        this.sql("select deptno from emp where ^group_id()^ = 1").fails("GROUP_ID operator may only occur in an aggregate query");
        this.sql("select deptno from emp where ^group_id()^ = 1 group by deptno").fails("GROUP_ID operator may only occur in SELECT, HAVING or ORDER BY clause");
        this.sql("select deptno from emp group by deptno, ^group_id()^").fails("GROUP_ID operator may only occur in SELECT, HAVING or ORDER BY clause");
        this.sql("select deptno from emp\ngroup by grouping sets(deptno, ^group_id()^)").fails("GROUP_ID operator may only occur in SELECT, HAVING or ORDER BY clause");
        this.sql("select deptno from emp\ngroup by cube(empno, ^group_id()^)").fails("GROUP_ID operator may only occur in SELECT, HAVING or ORDER BY clause");
        this.sql("select deptno from emp\ngroup by rollup(empno, ^group_id()^)").fails("GROUP_ID operator may only occur in SELECT, HAVING or ORDER BY clause");
    }

    @Test
    public void testCubeGrouping() {
        this.sql("select deptno, grouping(deptno) from emp group by cube(deptno)").ok();
        this.sql("select deptno, grouping(^deptno + 1^) from emp\ngroup by cube(deptno, empno)").fails("Argument to GROUPING operator must be a grouped expression");
    }

    @Test
    public void testSumInvalidArgs() {
        this.checkFails("select ^sum(ename)^, deptno from emp group by deptno", "(?s)Cannot apply 'SUM' to arguments of type 'SUM\\(<VARCHAR\\(20\\)>\\)'\\. .*");
    }

    @Test
    public void testSumTooManyArgs() {
        this.checkFails("select ^sum(empno, deptno)^, deptno from emp group by deptno", "Invalid number of arguments to function 'SUM'. Was expecting 1 arguments");
    }

    @Test
    public void testSumTooFewArgs() {
        this.checkFails("select ^sum()^, deptno from emp group by deptno", "Invalid number of arguments to function 'SUM'. Was expecting 1 arguments");
    }

    @Test
    public void testSingleNoAlias() {
        this.check("select * from emp");
    }

    @Test
    public void testObscuredAliasFails() {
        this.checkFails("select * from emp as e where exists (\n  select 1 from dept where dept.deptno = ^emp^.deptno)", "Table 'EMP' not found");
    }

    @Test
    public void testFromReferenceFails() {
        this.checkFails("select * from emp as e1 where exists (\n  select * from emp as e2,\n    (select * from dept where dept.deptno = ^e2^.deptno))", "Table 'E2' not found");
    }

    @Test
    public void testWhereReference() {
        this.check("select * from emp as e1 where exists (\n  select * from emp as e2,\n    (select * from dept where dept.deptno = e1.deptno))");
    }

    @Test
    public void testUnionNameResolution() {
        this.checkFails("select * from emp as e1 where exists (\n  select * from emp as e2,\n  (select deptno from dept as d\n   union\n   select deptno from emp as e3 where deptno = ^e2^.deptno))", "Table 'E2' not found");
        this.checkFails("select * from emp\nunion\nselect * from dept where ^empno^ < 10", "Column 'EMPNO' not found in any table");
    }

    @Test
    public void testUnionCountMismatchFails() {
        this.checkFails("select 1,2 from emp\nunion\nselect ^3^ from dept", "Column count mismatch in UNION");
    }

    @Test
    public void testUnionCountMismatcWithValuesFails() {
        this.checkFails("select * from ( values (1))\nunion\nselect ^*^ from ( values (1,2))", "Column count mismatch in UNION");
        this.checkFails("select * from ( values (1))\nunion\nselect ^*^ from emp", "Column count mismatch in UNION");
        this.checkFails("select * from emp\nunion\nselect ^*^ from ( values (1))", "Column count mismatch in UNION");
    }

    @Test
    public void testUnionTypeMismatchFails() {
        this.checkFails("select 1, ^2^ from emp union select deptno, name from dept", "Type mismatch in column 2 of UNION");
        this.checkFails("select ^slacker^ from emp union select name from dept", "Type mismatch in column 1 of UNION");
    }

    @Test
    public void testUnionTypeMismatchWithStarFails() {
        this.checkFails("select ^*^ from dept union select 1, 2 from emp", "Type mismatch in column 2 of UNION");
        this.checkFails("select ^dept.*^ from dept union select 1, 2 from emp", "Type mismatch in column 2 of UNION");
    }

    @Test
    public void testUnionTypeMismatchWithValuesFails() {
        this.checkFails("values (1, ^2^, 3), (3, 4, 5), (6, 7, 8) union\nselect deptno, name, deptno from dept", "Type mismatch in column 2 of UNION");
        this.checkFails("select 1 from (values (^'x'^)) union\nselect 'a' from (values ('y'))", "Type mismatch in column 1 of UNION");
        this.checkFails("select 1 from (values (^'x'^)) union\n(values ('a'))", "Type mismatch in column 1 of UNION");
    }

    @Test
    public void testValuesTypeMismatchFails() {
        this.checkFails("^values (1), ('a')^", "Values passed to VALUES operator must have compatible types");
    }

    @Test
    public void testNaturalCrossJoinFails() {
        this.checkFails("select * from emp natural cross ^join^ dept", "Cannot specify condition \\(NATURAL keyword, or ON or USING clause\\) following CROSS JOIN");
    }

    @Test
    public void testCrossJoinUsingFails() {
        this.checkFails("select * from emp cross join dept ^using^ (deptno)", "Cannot specify condition \\(NATURAL keyword, or ON or USING clause\\) following CROSS JOIN");
    }

    @Test
    public void testJoinUsing() {
        this.check("select * from emp join dept using (deptno)");
        this.checkFails("select * from emp join dept using (deptno, ^comm^)", "Column 'COMM' not found in any table");
        this.checkFails("select * from emp join dept using (^empno^)", "Column 'EMPNO' not found in any table");
        this.checkFails("select * from dept join emp using (^empno^)", "Column 'EMPNO' not found in any table");
        this.checkFails("select * from dept join emp using (^abc^)", "Column 'ABC' not found in any table");
        this.checkFails("select * from dept join emp using (^\"deptno\"^)", "Column 'deptno' not found in any table");
        this.check("select * from emp join dept using (deptno, deptno)");
        this.checkFails("select * from dept where exists (\nselect 1 from emp join bonus using (^dname^))", "Column 'DNAME' not found in any table");
        this.checkFails("select * from dept where exists (\nselect 1 from emp join bonus using (^deptno^))", "Column 'DEPTNO' not found in any table");
    }

    @Test
    public void testCrossJoinOnFails() {
        this.checkFails("select * from emp cross join dept\n ^on^ emp.deptno = dept.deptno", "Cannot specify condition \\(NATURAL keyword, or ON or USING clause\\) following CROSS JOIN");
    }

    @Test
    public void testInnerJoinWithoutUsingOrOnFails() {
        this.checkFails("select * from emp inner ^join^ dept\nwhere emp.deptno = dept.deptno", "INNER, LEFT, RIGHT or FULL join requires a condition \\(NATURAL keyword or ON or USING clause\\)");
    }

    @Test
    public void testNaturalJoinWithOnFails() {
        this.checkFails("select * from emp natural join dept on ^emp.deptno = dept.deptno^", "Cannot specify NATURAL keyword with ON or USING clause");
    }

    @Test
    public void testNaturalJoinWithUsing() {
        this.checkFails("select * from emp natural join dept ^using (deptno)^", "Cannot specify NATURAL keyword with ON or USING clause");
    }

    @Test
    public void testNaturalJoinIncompatibleDatatype() {
        this.checkFails("select *\nfrom (select ename as name, hiredate as deptno from emp)\nnatural ^join^\n(select deptno, name as sal from dept)", "Column 'DEPTNO' matched using NATURAL keyword or USING clause has incompatible types: cannot compare 'TIMESTAMP\\(0\\)' to 'INTEGER'");
        this.check("select * from emp natural ^join^\n(select deptno, name as sal from dept)");
        this.check("select * from emp natural join\n (select deptno, name as sal, 'foo' as sal from dept)");
    }

    @Test
    public void testJoinUsingIncompatibleDatatype() {
        this.checkFails("select *\nfrom (select ename as name, hiredate as deptno from emp)\njoin (select deptno, name as sal from dept) using (^deptno^, sal)", "Column 'DEPTNO' matched using NATURAL keyword or USING clause has incompatible types: cannot compare 'TIMESTAMP\\(0\\)' to 'INTEGER'");
        this.check("select * from emp\njoin (select deptno, name as sal from dept) using (deptno, sal)");
    }

    @Test
    public void testJoinUsingInvalidColsFails() {
        this.checkFails("select * from emp left join dept using (^gender^)", "Column 'GENDER' not found in any table");
    }

    @Test
    public void testJoinUsingDupColsFails() {
        this.checkFails("select * from emp left join (select deptno, name as deptno from dept) using (^deptno^)", "Column name 'DEPTNO' in USING clause is not unique on one side of join");
    }

    @Test
    public void testJoinRowType() {
        this.checkResultType("select * from emp left join dept on emp.deptno = dept.deptno", "RecordType(INTEGER NOT NULL EMPNO, VARCHAR(20) NOT NULL ENAME, VARCHAR(10) NOT NULL JOB, INTEGER MGR, TIMESTAMP(0) NOT NULL HIREDATE, INTEGER NOT NULL SAL, INTEGER NOT NULL COMM, INTEGER NOT NULL DEPTNO, BOOLEAN NOT NULL SLACKER, INTEGER DEPTNO0, VARCHAR(10) NAME) NOT NULL");
        this.checkResultType("select * from emp right join dept on emp.deptno = dept.deptno", "RecordType(INTEGER EMPNO, VARCHAR(20) ENAME, VARCHAR(10) JOB, INTEGER MGR, TIMESTAMP(0) HIREDATE, INTEGER SAL, INTEGER COMM, INTEGER DEPTNO, BOOLEAN SLACKER, INTEGER NOT NULL DEPTNO0, VARCHAR(10) NOT NULL NAME) NOT NULL");
        this.checkResultType("select * from emp full join dept on emp.deptno = dept.deptno", "RecordType(INTEGER EMPNO, VARCHAR(20) ENAME, VARCHAR(10) JOB, INTEGER MGR, TIMESTAMP(0) HIREDATE, INTEGER SAL, INTEGER COMM, INTEGER DEPTNO, BOOLEAN SLACKER, INTEGER DEPTNO0, VARCHAR(10) NAME) NOT NULL");
    }

    public void _testJoinUsing() {
        this.check("select * from (emp join bonus using (job))\njoin dept using (deptno)");
        this.checkFails("select * from (emp join bonus using (job)) as x\njoin dept using (deptno)", "as wrong here");
        this.checkFails("select * from (emp join bonus using (job))\njoin dept using (^dname^)", "dname not found in lhs");
        this.checkFails("select * from (emp join bonus using (job))\njoin (select 1 as job from (true)) using (job)", "ambig");
    }

    @Ignore(value="bug: should fail if sub-query does not have alias")
    @Test
    public void testJoinSubQuery() {
        this.checkFails("select * from (select 1 as uno from emp)\njoin (values (1), (2)) on true", "require alias");
    }

    @Test
    public void testJoinOnIn() {
        String sql = "select * from emp join dept\non dept.deptno in (select deptno from emp)";
        this.sql("select * from emp join dept\non dept.deptno in (select deptno from emp)").ok();
    }

    @Test
    public void testJoinOnInCorrelated() {
        String sql = "select * from emp as e join dept\non dept.deptno in (select deptno from emp where deptno < e.deptno)";
        this.sql("select * from emp as e join dept\non dept.deptno in (select deptno from emp where deptno < e.deptno)").ok();
    }

    @Test
    public void testJoinOnInCorrelatedFails() {
        String sql = "select * from emp as e join dept as d\non d.deptno in (select deptno from emp where deptno < d.^empno^)";
        this.sql("select * from emp as e join dept as d\non d.deptno in (select deptno from emp where deptno < d.^empno^)").fails("Column 'EMPNO' not found in table 'D'");
    }

    @Test
    public void testJoinOnExistsCorrelated() {
        String sql = "select * from emp as e join dept\non exists (select 1, 2 from emp where deptno < e.deptno)";
        this.sql("select * from emp as e join dept\non exists (select 1, 2 from emp where deptno < e.deptno)").ok();
    }

    @Test
    public void testJoinOnScalarCorrelated() {
        String sql = "select * from emp as e join dept d\non d.deptno = (select 1 from emp where deptno < e.deptno)";
        this.sql("select * from emp as e join dept d\non d.deptno = (select 1 from emp where deptno < e.deptno)").ok();
    }

    @Test
    public void testJoinOnScalarFails() {
        String sql = "select * from emp as e join dept d\non d.deptno = (^select 1, 2 from emp where deptno < e.deptno^)";
        this.sql("select * from emp as e join dept d\non d.deptno = (^select 1, 2 from emp where deptno < e.deptno^)").fails("(?s)Cannot apply '\\$SCALAR_QUERY' to arguments of type '\\$SCALAR_QUERY\\(<RECORDTYPE\\(INTEGER EXPR\\$0, INTEGER EXPR\\$1\\)>\\)'\\. Supported form\\(s\\).*");
    }

    @Test
    public void testJoinUsingThreeWay() {
        this.check("select *\nfrom emp as e\njoin dept as d using (deptno)\njoin emp as e2 using (empno)");
        this.checkFails("select *\nfrom emp as e\njoin dept as d using (deptno)\njoin dept as d2 using (^deptno^)", "Column name 'DEPTNO' in USING clause is not unique on one side of join");
    }

    @Test
    public void testWhere() {
        this.checkFails("select * from emp where ^sal^", "WHERE clause must be a condition");
    }

    @Test
    public void testOn() {
        this.checkFails("select * from emp e1 left outer join emp e2 on ^e1.sal^", "ON clause must be a condition");
    }

    @Test
    public void testHaving() {
        this.checkFails("select * from emp having ^sum(sal)^", "HAVING clause must be a condition");
        this.checkFails("select ^*^ from emp having sum(sal) > 10", "Expression 'EMP\\.EMPNO' is not being grouped");
        this.check("select sum(sal + sal) from emp having sum(sal) > 10");
        this.checkFails("SELECT deptno FROM emp GROUP BY deptno HAVING ^sal^ > 10", "Expression 'SAL' is not being grouped");
    }

    @Test
    public void testHavingBetween() {
        this.check("select deptno from emp group by deptno\nhaving deptno between 10 and 12");
        this.check("select deptno from emp group by deptno having deptno + 5 > 10");
    }

    @Test
    public void testWith() {
        this.checkResultType("with emp2 as (select * from emp)\nselect * from emp2", EMP_RECORD_TYPE);
        this.checkFails("with emp2 ^(x, y)^ as (select * from emp)\nselect * from emp2", "Number of columns must match number of query columns");
        this.checkFails("with emp2 (x, y, ^y^, x) as (select sal, deptno, ename, empno from emp)\nselect * from emp2", "Duplicate name 'Y' in column list");
        this.checkFails("with emp2 as (^select empno as e, sal, deptno as e from emp^)\nselect * from emp2", "Column has duplicate column name 'E' and no column list specified");
        this.checkFails("with emp3 as (select * from ^emp2^),\n emp2 as (select * from emp)\nselect * from emp3", "Object 'EMP2' not found");
        this.checkFails("with emp3 as (select * from ^emp2^),\n emp2 as (select * from emp)\nselect * from emp2", "Object 'EMP2' not found");
        this.checkResultType("with emp2 as (select * from emp),\n emp3 as (select * from emp2)\nselect * from emp2", EMP_RECORD_TYPE);
        this.checkFails("with emp2 as (select * from emp),\n emp3 as (select * from ^emp3^)\nvalues (1)", "Object 'EMP3' not found");
        this.checkFails("with emp2 as (select * from ^emp2^)\nselect * from emp2 where false", "Object 'EMP2' not found");
        this.checkResultType("with emp2 as (select * from emp),\n dept2 as (select * from dept),\n empDept as (select emp2.empno, dept2.deptno from dept2 join emp2 using (deptno))\nselect 1 as uno from empDept", "RecordType(INTEGER NOT NULL UNO) NOT NULL");
    }

    @Test
    public void testWithUnion() {
        this.checkResultType("with emp2 as (select * from emp)\nselect * from emp2 union all select * from emp", EMP_RECORD_TYPE);
    }

    @Test
    public void testWithColumnAlias() {
        this.checkResultType("with w(x, y) as (select * from dept)\nselect * from w", "RecordType(INTEGER NOT NULL X, VARCHAR(10) NOT NULL Y) NOT NULL");
        this.checkResultType("with w(x, y) as (select * from dept)\nselect * from w, w as w2", "RecordType(INTEGER NOT NULL X, VARCHAR(10) NOT NULL Y, INTEGER NOT NULL X0, VARCHAR(10) NOT NULL Y0) NOT NULL");
        this.checkFails("with w(x, y) as (select * from dept)\nselect ^deptno^ from w", "Column 'DEPTNO' not found in any table");
        this.checkFails("with w(x, ^x^) as (select * from dept)\nselect * from w", "Duplicate name 'X' in column list");
    }

    @Test
    public void testWithSubQuery() {
        this.checkResultType("with emp2 as (select * from emp)\n(\n  with dept2 as (select * from dept)\n  (\n    with empDept as (select emp2.empno, dept2.deptno from dept2 join emp2 using (deptno))\n    select 1 as uno from empDept))", "RecordType(INTEGER NOT NULL UNO) NOT NULL");
        this.checkResultType("select * from emp\nwhere exists (\n  with dept2 as (select * from dept where dept.deptno >= emp.deptno)\n  select 1 from dept2 where deptno <= emp.deptno)", EMP_RECORD_TYPE);
        this.checkFails("select * from emp\njoin (\n  with dept2 as (select * from dept where dept.deptno >= ^emp^.deptno)\n  select * from dept2) as d on true", "Table 'EMP' not found");
        this.checkFails("select * from emp\njoin (\n  with dept2 as (select * from dept where dept.deptno >= ^emp^.deptno)\n  select * from dept2) as d using (deptno)", "Table 'EMP' not found");
        this.checkResultType("select e.empno, d.* from emp as e\njoin (\n  with dept2 as (select * from dept where dept.deptno > 10)\n  select deptno, 1 as uno from dept2) as d using (deptno)", "RecordType(INTEGER NOT NULL EMPNO, INTEGER NOT NULL DEPTNO, INTEGER NOT NULL UNO) NOT NULL");
        this.checkFails("select ^e^.empno, d.* from emp\njoin (\n  with dept2 as (select * from dept where dept.deptno > 10)\n  select deptno, 1 as uno from dept2) as d using (deptno)", "Table 'E' not found");
    }

    @Test
    public void testWithOrderAgg() {
        this.check("select count(*) from emp order by count(*)");
        this.check("with q as (select * from emp)\nselect count(*) from q group by deptno order by count(*)");
        this.check("with q as (select * from emp)\nselect count(*) from q order by count(*)");
        this.checkFails("select count(*) from emp\nunion all\nselect count(*) from emp\norder by ^count(*)^", ERR_AGG_IN_ORDER_BY);
    }

    @Test
    public void testLarge() {
        SqlValidatorTest.checkLarge(700, new Function<String, Void>(){

            public Void apply(String input) {
                SqlValidatorTest.this.check(input);
                return null;
            }
        });
    }

    static void checkLarge(int x, Function<String, Void> f) {
        if (System.getProperty("os.name").startsWith("Windows")) {
            x /= 3;
        }
        String large = SqlValidatorTest.list(" + ", "deptno * ", x);
        f.apply((Object)("select " + large + "from emp"));
        f.apply((Object)("select distinct " + large + "from emp"));
        f.apply((Object)("select " + large + " from emp group by deptno"));
        f.apply((Object)("select * from emp where " + large + " > 5"));
        f.apply((Object)("select * from emp order by " + large + " desc"));
        f.apply((Object)("select " + large + " from emp order by 1"));
        f.apply((Object)("select distinct " + large + " from emp order by " + large));
        f.apply((Object)("select * from emp where deptno in (" + SqlValidatorTest.list(", ", "", x) + ")"));
        f.apply((Object)("select * from emp where " + SqlValidatorTest.list(" or ", "deptno = ", x)));
        f.apply((Object)("select " + SqlValidatorTest.list(", ", "x", x) + " from (select " + SqlValidatorTest.list(", ", "'a' as x", x) + " from emp union all select " + SqlValidatorTest.list(", ", "'bb' as x", x) + " from dept)"));
    }

    private static String list(String sep, String before, int count) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            if (i > 0) {
                buf.append(sep);
            }
            buf.append(before).append(i);
        }
        return buf.toString();
    }

    @Test
    public void testAbstractConformance() throws InvocationTargetException, IllegalAccessException {
        SqlAbstractConformance c0 = new SqlAbstractConformance(){};
        SqlConformanceEnum c1 = SqlConformanceEnum.DEFAULT;
        for (Method method : SqlConformance.class.getMethods()) {
            Object o0 = method.invoke((Object)c0, new Object[0]);
            Object o1 = method.invoke((Object)c1, new Object[0]);
            Assert.assertThat((String)method.toString(), (Object)Objects.equals(o0, o1), (Matcher)CoreMatchers.is((Object)true));
        }
    }

    @Test
    public void testUserDefinedConformance() {
        SqlDelegatingConformance c = new SqlDelegatingConformance((SqlConformance)SqlConformanceEnum.DEFAULT){

            public boolean isBangEqualAllowed() {
                return true;
            }
        };
        SqlTester customTester = this.tester.withConformance((SqlConformance)c);
        SqlTester defaultTester = this.tester.withConformance((SqlConformance)SqlConformanceEnum.DEFAULT);
        SqlTester oracleTester = this.tester.withConformance((SqlConformance)SqlConformanceEnum.ORACLE_10);
        this.sql("^select 2+2^").tester(customTester).ok().tester(defaultTester).ok().tester(oracleTester).fails("SELECT must have a FROM clause");
        this.sql("select * from (values 1) where 1 != 2").tester(customTester).ok().tester(defaultTester).fails("Bang equal '!=' is not allowed under the current SQL conformance level").tester(oracleTester).ok();
    }

    @Test
    public void testOrder() {
        SqlConformance conformance = this.tester.getConformance();
        this.check("select empno as x from emp order by empno");
        this.checkFails("select empno, sal from emp order by ^asc^", "Column 'ASC' not found in any table");
        this.checkFails("select empno as x from emp order by empno", conformance.isSortByAliasObscures() ? "unknown column empno" : null);
        this.checkFails("select empno as x from emp order by ^x^", conformance.isSortByAlias() ? null : "Column 'X' not found in any table");
        this.checkFails("select empno as x from emp order by ^10^", conformance.isSortByOrdinal() ? "Ordinal out of range" : null);
        this.check("select empno + 1 as empno from emp order by empno");
        this.checkFails("select empno as x from emp, dept order by ^deptno^", "Column 'DEPTNO' is ambiguous");
        this.check("select empno + 1 from emp order by deptno asc, empno + 1 desc");
        this.checkFails("select empno as deptno from emp, dept order by deptno", conformance.isSortByAlias() ? null : "col ambig");
        this.check("select deptno from dept\nunion\nselect empno from emp\norder by deptno");
        this.checkFails("select deptno from dept\nunion\nselect empno from emp\norder by ^empno^", "Column 'EMPNO' not found in any table");
        this.checkFails("select deptno from dept\nunion\nselect empno from emp\norder by ^10^", conformance.isSortByOrdinal() ? "Ordinal out of range" : null);
        this.check("select * from emp\norder by (select name from dept where deptno = emp.deptno)");
        this.checkFails("select * from emp\norder by (select name from dept where deptno = emp.^foo^)", "Column 'FOO' not found in table 'EMP'");
        this.check("select * from emp order by empno");
        this.checkFails("select * from emp order by ^nonExistent^, deptno", "Column 'NONEXISTENT' not found in any table");
        this.checkFails("select 'foo' as empno from emp order by ^empno + 5^", "(?s)Cannot apply '\\+' to arguments of type '<CHAR\\(3\\)> \\+ <INTEGER>'\\..*");
    }

    @Test
    public void testOrderJoin() {
        this.sql("select * from emp as e, dept as d order by e.empno").ok();
    }

    @Test
    public void testWithOrder() {
        this.sql("with e as (select * from emp)\nselect * from e as e1 order by e1.empno").ok();
        this.sql("with e as (select * from emp)\nselect * from e as e1, e as e2 order by e1.empno").ok();
    }

    @Test
    public void testWithOrderInParentheses() {
        this.sql("with e as (select * from emp)\n(select e.empno from e order by e.empno)").ok();
        this.sql("with e as (select * from emp)\n(select e.empno from e order by 1)").ok();
        this.sql("with e as (select * from emp)\n(select ee.empno from e as ee order by ee.deptno)").ok();
        this.sql("with e as (select * from emp)\n(select e.empno from e)").ok();
    }

    @Test
    public void testOrderUnion() {
        this.check("select empno, sal from emp union all select deptno, deptno from dept order by empno");
        this.checkFails("select empno, sal from emp union all select deptno, deptno from dept order by ^asc^", "Column 'ASC' not found in any table");
        this.checkFails("select empno, sal from emp union all select deptno, deptno from dept order by ^ename^ desc", "Column 'ENAME' not found in any table");
        this.checkFails("select deptno, deptno from dept union all select empno, sal from emp order by deptno asc, ^empno^", "Column 'EMPNO' not found in any table");
        this.check("select empno, sal from emp union all select deptno, deptno from dept order by 2");
        if (this.tester.getConformance().isSortByOrdinal()) {
            this.checkFails("select empno, sal from emp union all select deptno, deptno from dept order by ^3^", "Ordinal out of range");
        }
        this.check("select empno, sal from emp union all select deptno, deptno from dept order by empno * sal + 2");
        this.check("select empno, sal from emp union all select deptno, deptno from dept order by 'foobar'");
    }

    @Test
    public void testOrderGroup() {
        this.checkFails("select 1 from emp group by deptno order by ^empno^", "Expression 'EMPNO' is not being grouped");
        this.check("select empno from emp group by empno, deptno order by deptno * sum(sal + 2)");
        this.checkFails("select sum(sal) from emp having count(*) > 3 order by ^empno^", "Expression 'EMPNO' is not being grouped");
        this.check("select sum(sal) from emp having count(*) > 3 order by sum(deptno)");
        this.checkFails("select distinct deptno from emp group by deptno order by ^empno^", "Expression 'EMPNO' is not in the select clause");
        this.checkFails("select distinct deptno from emp group by deptno order by deptno, ^empno^", "Expression 'EMPNO' is not in the select clause");
        this.check("select distinct deptno from emp group by deptno order by deptno");
        this.check("select distinct deptno from dept union all select empno from emp group by deptno, empno order by deptno");
        this.check("select empno as x from emp group by empno, deptno order by x * sum(sal + 2)");
        this.sql("select empno as x from emp group by empno, deptno order by empno * sum(sal + 2)").failsIf(this.tester.getConformance().isSortByAliasObscures(), "xxxx");
    }

    @Test
    public void testAliasInGroupBy() {
        SqlTester lenient = this.tester.withConformance((SqlConformance)SqlConformanceEnum.LENIENT);
        SqlTester strict = this.tester.withConformance((SqlConformance)SqlConformanceEnum.STRICT_2003);
        this.sql("select empno as e from emp group by ^e^").tester(strict).fails("Column 'E' not found in any table").tester(lenient).sansCarets().ok();
        this.sql("select empno as e from emp group by ^e^").tester(strict).fails("Column 'E' not found in any table").tester(lenient).sansCarets().ok();
        this.sql("select emp.empno as e from emp group by ^e^").tester(strict).fails("Column 'E' not found in any table").tester(lenient).sansCarets().ok();
        this.sql("select e.empno from emp as e group by e.empno").tester(strict).ok().tester(lenient).ok();
        this.sql("select e.empno as eno from emp as e group by ^eno^").tester(strict).fails("Column 'ENO' not found in any table").tester(lenient).sansCarets().ok();
        this.sql("select deptno as dno from emp group by cube(^dno^)").tester(strict).fails("Column 'DNO' not found in any table").tester(lenient).sansCarets().ok();
        this.sql("select deptno as dno, ename name, sum(sal) from emp\ngroup by grouping sets ((^dno^), (name, deptno))").tester(strict).fails("Column 'DNO' not found in any table").tester(lenient).sansCarets().ok();
        this.sql("select ename as deptno from emp as e join dept as d on e.deptno = d.deptno group by ^deptno^").tester(lenient).sansCarets().ok();
        this.sql("select t.e, count(*) from (select empno as e from emp) t group by e").tester(strict).ok().tester(lenient).ok();
        this.sql("select t.e, count(*) as c from  (select empno as e from emp) t group by e,^c^").tester(strict).fails("Column 'C' not found in any table");
        this.sql("select t.e, ^count(*)^ as c from  (select empno as e from emp) t group by e,c").tester(lenient).fails(ERR_AGG_IN_GROUP_BY);
        this.sql("select t.e, e + ^count(*)^ as c from  (select empno as e from emp) t group by e,c").tester(lenient).fails(ERR_AGG_IN_GROUP_BY);
        this.sql("select t.e, e + ^count(*)^ as c from  (select empno as e from emp) t group by e,2").tester(lenient).fails(ERR_AGG_IN_GROUP_BY).tester(strict).sansCarets().ok();
        this.sql("select deptno,(select empno + 1 from emp) eno\nfrom dept group by deptno,^eno^").tester(strict).fails("Column 'ENO' not found in any table").tester(lenient).sansCarets().ok();
        this.sql("select empno as e, deptno as e\nfrom emp group by ^e^").tester(lenient).fails("Column 'E' is ambiguous");
        this.sql("select empno, ^count(*)^ c from emp group by empno, c").tester(lenient).fails(ERR_AGG_IN_GROUP_BY);
        this.sql("select deptno + empno as d, deptno + empno + mgr from emp group by d,mgr").tester(lenient).sansCarets().ok();
        this.sql("select count(*) from (\n  select ename AS deptno FROM emp GROUP BY deptno) t").tester(lenient).sansCarets().ok();
        this.sql("select count(*) from (select ename AS deptno FROM emp, dept GROUP BY deptno) t").tester(lenient).sansCarets().ok();
        this.sql("select empno + deptno AS \"z\" FROM emp GROUP BY \"Z\"").tester(lenient.withCaseSensitive(false)).sansCarets().ok();
        this.sql("select empno + deptno as c, ^c^ + mgr as d from emp group by c, d").tester(lenient).fails("Column 'C' not found in any table");
        this.sql("select empno as e from emp group by ^e^").tester(strict).fails("Column 'E' not found in any table");
    }

    @Test
    public void testOrdinalInGroupBy() {
        SqlTester lenient = this.tester.withConformance((SqlConformance)SqlConformanceEnum.LENIENT);
        SqlTester strict = this.tester.withConformance((SqlConformance)SqlConformanceEnum.STRICT_2003);
        this.sql("select ^empno^,deptno from emp group by 1, deptno").tester(strict).fails("Expression 'EMPNO' is not being grouped").tester(lenient).sansCarets().ok();
        this.sql("select ^emp.empno^ as e from emp group by 1").tester(strict).fails("Expression 'EMP.EMPNO' is not being grouped").tester(lenient).sansCarets().ok();
        this.sql("select 2 + ^emp.empno^ + 3 as e from emp group by 1").tester(strict).fails("Expression 'EMP.EMPNO' is not being grouped").tester(lenient).sansCarets().ok();
        this.sql("select ^e.empno^ from emp as e group by 1").tester(strict).fails("Expression 'E.EMPNO' is not being grouped").tester(lenient).sansCarets().ok();
        this.sql("select e.empno from emp as e group by 1, empno").tester(strict).ok().tester(lenient).sansCarets().ok();
        this.sql("select ^e.empno^ as eno from emp as e group by 1").tester(strict).fails("Expression 'E.EMPNO' is not being grouped").tester(lenient).sansCarets().ok();
        this.sql("select ^deptno^ as dno from emp group by cube(1)").tester(strict).fails("Expression 'DEPTNO' is not being grouped").tester(lenient).sansCarets().ok();
        this.sql("select 1 as dno from emp group by cube(1)").tester(strict).ok().tester(lenient).sansCarets().ok();
        this.sql("select deptno as dno, ename name, sum(sal) from emp\ngroup by grouping sets ((1), (^name^, deptno))").tester(strict).fails("Column 'NAME' not found in any table").tester(lenient).sansCarets().ok();
        this.sql("select ^e.deptno^ from emp as e\njoin dept as d on e.deptno = d.deptno group by 1").tester(strict).fails("Expression 'E.DEPTNO' is not being grouped").tester(lenient).sansCarets().ok();
        this.sql("select ^deptno^,(select empno from emp) eno from dept group by 1,2").tester(strict).fails("Expression 'DEPTNO' is not being grouped").tester(lenient).sansCarets().ok();
        this.sql("select count(*) from (select 1 from emp group by substring(ename from 2 for 3))").tester(strict).ok().tester(lenient).sansCarets().ok();
        this.sql("select deptno from emp group by deptno, ^100^").tester(lenient).fails("Ordinal out of range").tester(strict).sansCarets().ok();
        this.sql("select deptno from emp group by ^100^, deptno").tester(lenient).fails("Ordinal out of range").tester(strict).sansCarets().ok();
    }

    @Test
    public void testAliasInHaving() {
        SqlTester lenient = this.tester.withConformance((SqlConformance)SqlConformanceEnum.LENIENT);
        SqlTester strict = this.tester.withConformance((SqlConformance)SqlConformanceEnum.STRICT_2003);
        this.sql("select count(empno) as e from emp having ^e^ > 10").tester(strict).fails("Column 'E' not found in any table").tester(lenient).sansCarets().ok();
        this.sql("select emp.empno as e from emp group by ^e^ having e > 10").tester(strict).fails("Column 'E' not found in any table").tester(lenient).sansCarets().ok();
        this.sql("select emp.empno as e from emp group by empno having ^e^ > 10").tester(strict).fails("Column 'E' not found in any table").tester(lenient).sansCarets().ok();
        this.sql("select e.empno from emp as e group by 1 having ^e.empno^ > 10").tester(strict).fails("Expression 'E.EMPNO' is not being grouped").tester(lenient).sansCarets().ok();
        this.sql("select count(empno) as deptno from emp having ^deptno^ > 10").tester(strict).fails("Expression 'DEPTNO' is not being grouped").tester(lenient).sansCarets().ok();
        this.sql("select empno as e from emp having max(^e^) > 10").tester(strict).fails("Column 'E' not found in any table").tester(lenient).fails("Column 'E' not found in any table");
        this.sql("select count(empno) as e from emp having ^e^ > 10").tester(strict).fails("Column 'E' not found in any table").tester(lenient).sansCarets().ok();
    }

    @Test
    public void testOrderDistinct() {
        this.checkFails("select distinct cast(empno as bigint) from emp order by ^empno^", "Expression 'EMPNO' is not in the select clause");
        this.checkFails("select distinct cast(empno as bigint) from emp order by ^emp.empno^", "Expression 'EMP\\.EMPNO' is not in the select clause");
        this.checkFails("select distinct cast(empno as bigint) as empno from emp order by ^emp.empno^", "Expression 'EMP\\.EMPNO' is not in the select clause");
        this.checkFails("select distinct cast(empno as bigint) as empno from emp as e order by ^e.empno^", "Expression 'E\\.EMPNO' is not in the select clause");
        this.sql("select distinct cast(empno as bigint) as empno from emp order by ^empno^").failsIf(!this.tester.getConformance().isSortByAlias(), "Expression 'EMPNO' is not in the select clause");
        this.sql("select distinct cast(empno as bigint) as eno from emp order by ^eno^").failsIf(!this.tester.getConformance().isSortByAlias(), "Column 'ENO' not found in any table");
        this.sql("select distinct cast(empno as bigint) as empno from emp e order by ^empno^").failsIf(!this.tester.getConformance().isSortByAlias(), "Expression 'EMPNO' is not in the select clause");
        if (this.tester.getConformance().isSortByOrdinal()) {
            this.check("select distinct cast(empno as bigint) from emp order by 1");
            this.check("select distinct cast(empno as bigint) as empno from emp order by 1");
            this.check("select distinct cast(empno as bigint) as empno from emp as e order by 1");
        }
        this.check("select distinct cast(empno as varchar(10)) from emp order by cast(empno as varchar(10))");
        this.checkFails("select distinct cast(empno as varchar(10)) as eno from emp  order by upper(^eno^)", this.tester.getConformance().isSortByAlias() ? null : "Column 'ENO' not found in any table");
    }

    @Test
    public void testOrderGroupDistinct() {
        this.check("select distinct count(empno) AS countEMPNO from emp\ngroup by empno\norder by 1");
        this.check("select distinct count(empno) from emp\ngroup by empno\norder by 1");
        this.check("select distinct count(empno) AS countEMPNO from emp\ngroup by empno\norder by count(empno)");
        this.check("select distinct count(empno) from emp\ngroup by empno\norder by count(empno)");
        this.check("select distinct count(empno) from emp\ngroup by empno\norder by count(empno) desc");
        this.checkFails("SELECT DISTINCT deptno from emp\nORDER BY deptno, ^sum(empno)^", ERR_AGG_IN_ORDER_BY);
        this.checkFails("SELECT DISTINCT deptno from emp\nGROUP BY deptno ORDER BY deptno, ^sum(empno)^", "Expression 'SUM\\(`EMPNO`\\)' is not in the select clause");
        this.checkFails("SELECT DISTINCT deptno, min(empno) from emp\nGROUP BY deptno ORDER BY deptno, ^sum(empno)^", "Expression 'SUM\\(`EMPNO`\\)' is not in the select clause");
        this.check("SELECT DISTINCT deptno, sum(empno) from emp\nGROUP BY deptno ORDER BY deptno, sum(empno)");
    }

    @Test
    public void testGroup() {
        this.checkFails("select empno from emp where ^sum(sal)^ > 50", "Aggregate expression is illegal in WHERE clause");
        this.checkFails("select ^empno^ from emp group by deptno", "Expression 'EMPNO' is not being grouped");
        this.checkFails("select ^*^ from emp group by deptno", "Expression 'EMP\\.EMPNO' is not being grouped");
        this.check("select * from (select empno,deptno from emp) group by deptno,empno");
        this.check("select deptno\nfrom emp\ngroup by deptno\nhaving exists (select sum(emp.sal) > 10 from (values(true)))");
        this.check("select deptno from emp group by deptno having exists (select 1 from (values(true)) where emp.deptno = 10)");
        this.check("select cast(1 as integer) + 2 from emp group by deptno");
        this.check("select localtime, deptno + 3 from emp group by deptno");
    }

    @Test
    public void testGroupBySystemFunction() {
        this.sql("select CURRENT_USER from emp group by CURRENT_USER").ok();
        this.sql("select CURRENT_USER from emp group by rollup(CURRENT_USER)").ok();
        this.sql("select CURRENT_USER from emp group by rollup(CURRENT_USER, ^x^)").fails("Column 'X' not found in any table");
        this.sql("select CURRENT_USER from emp group by deptno").ok();
    }

    @Test
    public void testGroupingSets() {
        this.sql("select count(1), ^empno^ from emp group by grouping sets (deptno)").fails("Expression 'EMPNO' is not being grouped");
        this.sql("select deptno, ename, sum(sal) from emp\ngroup by grouping sets ((deptno), (ename, deptno))\norder by 2").ok();
        this.sql("select sum(sal) from emp\ngroup by deptno,\n  grouping sets (deptno,\n    grouping sets (deptno, ename),\n      (ename)),\n  ()").ok();
    }

    @Test
    public void testRollup() {
        this.sql("select deptno, count(*) as c, sum(sal) as s\nfrom emp\ngroup by rollup(deptno)").ok().type("RecordType(INTEGER DEPTNO, BIGINT NOT NULL C, INTEGER NOT NULL S) NOT NULL");
        this.sql("select deptno, empno\nfrom emp\ngroup by empno, rollup(deptno)").ok().type("RecordType(INTEGER DEPTNO, INTEGER NOT NULL EMPNO) NOT NULL");
        this.sql("select deptno, empno\nfrom emp\ngroup by rollup(empno), deptno").ok().type("RecordType(INTEGER NOT NULL DEPTNO, INTEGER EMPNO) NOT NULL");
    }

    @Test
    public void testGroupByCorrelatedColumn() {
        String sql = "select count(*)\nfrom emp\nwhere exists (select count(*) from dept group by emp.empno)";
        this.sql("select count(*)\nfrom emp\nwhere exists (select count(*) from dept group by emp.empno)").ok();
    }

    @Test
    public void testGroupExpressionEquivalence() {
        this.check("select empno + 1 from emp group by empno + 1");
        this.checkFails("select 1 + ^empno^ from emp group by empno + 1", "Expression 'EMPNO' is not being grouped");
        this.check("select cast(empno as VARCHAR(10)) from emp\ngroup by cast(empno as VARCHAR(10))");
        this.checkFails("select cast(^empno^ as VARCHAR(11)) from emp group by cast(empno as VARCHAR(10))", "Expression 'EMPNO' is not being grouped");
    }

    @Test
    public void testGroupExpressionEquivalenceId() {
        this.check("select case empno when 10 then deptno else null end from emp group by case empno when 10 then deptno else null end");
        this.check("select case empno when 10 then deptno else null end from emp group by case empno when 10 then emp.deptno else null end");
        this.check("select case empno when 10 then deptno else null end from emp group by case emp.empno when 10 then emp.deptno else null end");
        this.check("select case emp.empno when 10 then deptno else null end from emp group by case empno when 10 then emp.deptno else null end");
        this.checkFails("select case ^emp.empno^ when 10 then emp.deptno else null end from emp join dept on emp.deptno = dept.deptno group by case emp.empno when 10 then dept.deptno else null end", "Expression 'EMP\\.EMPNO' is not being grouped");
    }

    public void _testGroupExpressionEquivalenceCorrelated() {
        this.check("select * from dept where exists (select dname from emp group by empno)");
        this.check("select * from dept where exists (select dname + empno + 1 from emp group by empno, dept.deptno)");
    }

    public void _testGroupExpressionEquivalenceParams() {
        this.check("select cast(? as integer) from emp group by cast(? as integer)");
    }

    @Test
    public void testGroupExpressionEquivalenceLiteral() {
        this.check("select case empno when 10 then date '1969-04-29' else null end\nfrom emp\ngroup by case empno when 10 then date '1969-04-29' else null end");
        this.checkFails("select case ^empno^ when 10 then 1 else null end from emp group by case empno when 10 then 1.0 else null end", "Expression 'EMPNO' is not being grouped");
        this.checkFails("select case ^empno^ when 10 then 3.1415 else null end from emp group by case empno when 10 then 3.14150 else null end", "Expression 'EMPNO' is not being grouped");
        this.check("select case empno when 10 then 03 else null end from emp group by case empno when 10 then 3 else null end");
        this.checkFails("select case ^empno^ when 10 then 1 else null end from emp group by case empno when 10 then 2 else null end", "Expression 'EMPNO' is not being grouped");
        this.check("select case empno when 10 then timestamp '1969-04-29 12:34:56.0'\n       else null end from emp\ngroup by case empno when 10 then timestamp '1969-04-29 12:34:56' else null end");
    }

    @Test
    public void testGroupExpressionEquivalenceStringLiteral() {
        this.check("select case empno when 10 then 'foo bar' else null end from emp group by case empno when 10 then 'foo bar' else null end");
        this.checkFails("select case ^empno^ when 10 then _iso-8859-1'foo bar' else null end from emp group by case empno when 10 then _UTF16'foo bar' else null end", "Expression 'EMPNO' is not being grouped");
    }

    @Test
    public void testGroupAgg() {
        this.check("select deptno as d, count(*) as c from emp group by deptno");
    }

    @Test
    public void testNestedAggFails() {
        this.checkFails("select ^sum(max(empno))^ from emp", ERR_NESTED_AGG);
        this.checkFails("select ^sum(2*max(empno))^ from emp", ERR_NESTED_AGG);
        this.checkFails("select ^sum(max(empno))^ from emp group by deptno", ERR_NESTED_AGG);
        this.checkFails("select count(*) from emp group by deptno having ^sum(max(empno))^=3", ERR_NESTED_AGG);
        this.checkFails("select sum(^max(min(empno))^) from emp", ERR_NESTED_AGG);
    }

    @Test
    public void testNestedAggOver() {
        this.sql("select sum(max(empno))\n OVER (order by ^deptno^ ROWS 2 PRECEDING)\n from emp").fails("Expression 'DEPTNO' is not being grouped");
        this.sql("select sum(max(empno)) OVER w\n from emp\n window w as (order by ^deptno^ ROWS 2 PRECEDING)").fails("Expression 'DEPTNO' is not being grouped");
        this.sql("select sum(max(empno)) OVER w2, sum(deptno) OVER w1\n from emp group by deptno\n window w1 as (partition by ^empno^ ROWS 2 PRECEDING),\n w2 as (order by deptno ROWS 2 PRECEDING)").fails("Expression 'EMP.EMPNO' is not being grouped");
        this.sql("select avg(count(empno)) over w\nfrom emp group by deptno\nwindow w as (partition by deptno order by ^empno^)").fails("Expression 'EMPNO' is not being grouped");
        this.checkFails("select ^avg(sum(min(sal)))^ OVER (partition by deptno)\nfrom emp group by deptno", ERR_NESTED_AGG);
        this.sql("select avg(^sal^) OVER (), avg(count(empno)) OVER (partition by 1)\n from emp").fails("Expression 'SAL' is not being grouped");
        this.sql("select avg(^sal^) OVER (), avg(count(empno)) OVER (partition by deptno)\n from emp group by deptno").fails("Expression 'SAL' is not being grouped");
        this.sql("select avg(deptno) OVER (partition by ^empno^),\n avg(count(empno)) OVER (partition by deptno)\n from emp group by deptno").fails("Expression 'EMPNO' is not being grouped");
        this.sql("select avg(deptno) OVER (order by ^empno^),\n avg(count(empno)) OVER (partition by deptno)\n from emp group by deptno").fails("Expression 'EMPNO' is not being grouped");
        this.sql("select avg(sum(sal)) OVER (partition by ^empno^)\n from emp").fails("Expression 'EMPNO' is not being grouped");
        this.sql("select avg(sum(sal)) OVER (partition by ^empno^)\nfrom emp group by deptno").fails("Expression 'EMPNO' is not being grouped");
        this.sql("select avg(sum(sal)) OVER (partition by ^empno^)\n from emp").fails("Expression 'EMPNO' is not being grouped");
        this.sql("select avg(sum(sal)) OVER (partition by ^empno^)\nfrom emp group by deptno").fails("Expression 'EMPNO' is not being grouped");
        this.sql("select avg(sum(sal)) OVER (partition by deptno order by ^empno^)\nfrom emp group by deptno").fails("Expression 'EMPNO' is not being grouped");
        this.sql("select avg(^sal^) OVER (),\n avg(count(empno)) OVER (partition by min(deptno))\n from emp").fails("Expression 'SAL' is not being grouped");
        this.check("select avg(deptno) OVER (),\n avg(count(empno)) OVER (partition by deptno) from emp group by deptno");
        this.check("select avg(count(*)) OVER ()\n from emp group by deptno");
        this.check("select count(*) OVER ()\n from emp group by deptno");
        this.check("select count(deptno) OVER ()\n from emp group by deptno");
        this.check("select count(deptno, deptno + 1) OVER ()\n from emp group by deptno");
        this.sql("select count(deptno, deptno + 1, ^empno^) OVER ()\n from emp group by deptno").fails("Expression 'EMPNO' is not being grouped");
        this.sql("select count(emp.^*^)\nfrom emp group by deptno").fails("Unknown field '\\*'");
        this.sql("select count(emp.^*^) OVER ()\nfrom emp group by deptno").fails("Unknown field '\\*'");
        this.check("select avg(count(*)) OVER (partition by 1)\n from emp group by deptno");
        this.check("select avg(sum(sal)) OVER (partition by 1)\n from emp");
        this.check("select avg(sal), avg(count(empno)) OVER (partition by 1)\n from emp");
        this.check("select avg(sum(sal)) OVER (partition by 10 - deptno\n   order by deptno / 2 desc)\nfrom emp group by deptno");
        this.check("select avg(sal),\n avg(count(empno)) OVER (partition by min(deptno))\n from emp");
        this.check("select avg(min(sal)) OVER (),\n avg(count(empno)) OVER (partition by min(deptno))\n from emp");
        this.sql("select avg(2+^sal^) OVER (partition by deptno)\nfrom emp group by deptno").fails("Expression 'SAL' is not being grouped");
        this.sql("select avg(sum(sal)) OVER (partition by deptno + ^empno^)\nfrom emp group by deptno").fails("Expression 'EMPNO' is not being grouped");
        this.check("select avg(sum(sal)) OVER (partition by empno + deptno)\nfrom emp group by empno + deptno");
        this.check("select avg(sum(sal)) OVER (partition by empno + deptno + 1)\nfrom emp group by empno + deptno");
        this.sql("select avg(sum(sal)) OVER (partition by ^deptno^ + 1)\nfrom emp group by empno + deptno").fails("Expression 'DEPTNO' is not being grouped");
        this.check("select avg(empno + deptno) OVER (partition by empno + deptno + 1),\n count(empno + deptno) OVER (partition by empno + deptno + 1)\n from emp group by empno + deptno");
        this.sql("select sum(max(empno))\n OVER (order by ^deptno^ ROWS 2 PRECEDING) AS sumEmpNo\n from emp").fails("Expression 'DEPTNO' is not being grouped");
        this.sql("select sum(max(empno)) OVER w AS sumEmpNo\n from emp\n window w AS (order by ^deptno^ ROWS 2 PRECEDING)").fails("Expression 'DEPTNO' is not being grouped");
        this.sql("select avg(^sal^) OVER () AS avgSal, avg(count(empno)) OVER (partition by 1) AS avgEmpNo\n from emp").fails("Expression 'SAL' is not being grouped");
        this.sql("select count(deptno, deptno + 1, ^empno^) OVER () AS cntDeptEmp\n from emp group by deptno").fails("Expression 'EMPNO' is not being grouped");
        this.sql("select avg(sum(sal)) OVER (partition by ^deptno^ + 1) AS avgSal\nfrom emp group by empno + deptno").fails("Expression 'DEPTNO' is not being grouped");
        this.checkFails("select ^sum(max(empno) OVER (order by deptno ROWS 2 PRECEDING))^ from emp", ERR_NESTED_AGG);
    }

    @Test
    public void testAggregateInGroupByFails() {
        this.checkFails("select count(*) from emp group by ^sum(empno)^", ERR_AGG_IN_GROUP_BY);
    }

    @Test
    public void testAggregateInNonGroupBy() {
        this.checkFails("select count(1), ^empno^ from emp", "Expression 'EMPNO' is not being grouped");
        this.checkColumnType("select count(*) from emp", "BIGINT NOT NULL");
        this.checkColumnType("select count(deptno) from emp", "BIGINT NOT NULL");
        this.checkColumnType("select sum(deptno) from emp", "INTEGER");
        this.checkColumnType("select sum(deptno) from emp group by ()", "INTEGER");
        this.checkColumnType("select sum(deptno) from emp group by empno", "INTEGER NOT NULL");
    }

    @Test
    public void testAggregateInOrderByFails() {
        this.checkFails("select empno from emp order by ^sum(empno)^", ERR_AGG_IN_ORDER_BY);
        this.check("select sum(empno) from emp group by deptno order by sum(empno)");
        this.check("select sum(empno) from emp order by sum(empno)");
    }

    @Test
    public void testAggregateFilter() {
        this.sql("select sum(empno) filter (where deptno < 10) as s from emp").type("RecordType(INTEGER S) NOT NULL");
    }

    @Test
    public void testAggregateFilterNotBoolean() {
        this.sql("select sum(empno) filter (where ^deptno + 10^) from emp").fails("FILTER clause must be a condition");
    }

    @Test
    public void testAggregateFilterInHaving() {
        this.sql("select sum(empno) as s from emp\ngroup by deptno\nhaving sum(empno) filter (where deptno < 20) > 10").ok();
    }

    @Test
    public void testAggregateFilterContainsAggregate() {
        this.sql("select sum(empno) filter (where ^count(*) < 10^) from emp").fails("FILTER must not contain aggregate expression");
    }

    @Test
    public void testCorrelatingVariables() {
        this.check("select * from emp where exists (\nselect * from dept where deptno = sal)");
        this.check("select * from emp where exists (\nselect * from dept where deptno = emp.sal)");
    }

    @Test
    public void testIntervalCompare() {
        this.checkExpType("interval '1' hour = interval '1' day", "BOOLEAN NOT NULL");
        this.checkExpType("interval '1' hour <> interval '1' hour", "BOOLEAN NOT NULL");
        this.checkExpType("interval '1' hour < interval '1' second", "BOOLEAN NOT NULL");
        this.checkExpType("interval '1' hour <= interval '1' minute", "BOOLEAN NOT NULL");
        this.checkExpType("interval '1' minute > interval '1' second", "BOOLEAN NOT NULL");
        this.checkExpType("interval '1' second >= interval '1' day", "BOOLEAN NOT NULL");
        this.checkExpType("interval '1' year >= interval '1' year", "BOOLEAN NOT NULL");
        this.checkExpType("interval '1' month = interval '1' year", "BOOLEAN NOT NULL");
        this.checkExpType("interval '1' month <> interval '1' month", "BOOLEAN NOT NULL");
        this.checkExpType("interval '1' year >= interval '1' month", "BOOLEAN NOT NULL");
        this.checkWholeExpFails("interval '1' second >= interval '1' year", "(?s).*Cannot apply '>=' to arguments of type '<INTERVAL SECOND> >= <INTERVAL YEAR>'.*");
        this.checkWholeExpFails("interval '1' month = interval '1' day", "(?s).*Cannot apply '=' to arguments of type '<INTERVAL MONTH> = <INTERVAL DAY>'.*");
    }

    @Test
    public void testDateCompare() {
        this.checkExpType("date '2015-03-17' < '2015-03-18'", "BOOLEAN NOT NULL");
        this.checkExpType("date '2015-03-17' > '2015-03-18'", "BOOLEAN NOT NULL");
        this.checkExpType("date '2015-03-17' = '2015-03-18'", "BOOLEAN NOT NULL");
        this.checkExpType("'2015-03-17' < date '2015-03-18'", "BOOLEAN NOT NULL");
        this.checkExpType("date '2015-03-17' between '2015-03-16' and '2015-03-19'", "BOOLEAN NOT NULL");
        this.checkExpType("date '2015-03-17' between '2015-03-16' and '2015-03'||'-19'", "BOOLEAN NOT NULL");
        this.checkExpType("'2015-03-17' between date '2015-03-16' and date '2015-03-19'", "BOOLEAN NOT NULL");
        this.checkExpType("date '2015-03-17' between date '2015-03-16' and '2015-03-19'", "BOOLEAN NOT NULL");
        this.checkExpType("date '2015-03-17' between '2015-03-16' and date '2015-03-19'", "BOOLEAN NOT NULL");
        this.checkExpType("time '12:34:56' < '12:34:57'", "BOOLEAN NOT NULL");
        this.checkExpType("timestamp '2015-03-17 12:34:56' < '2015-03-17 12:34:57'", "BOOLEAN NOT NULL");
        this.checkExpType("interval '2' hour < '2:30'", "BOOLEAN NOT NULL");
        this.checkExpType("123 > '72'", "BOOLEAN NOT NULL");
        this.checkExpType("12.3 > '7.2'", "BOOLEAN NOT NULL");
        this.checkExpType("true = 'true'", "BOOLEAN NOT NULL");
        this.checkExpFails("^true and 'true'^", "Cannot apply 'AND' to arguments of type '<BOOLEAN> AND <CHAR\\(4\\)>'\\..*");
    }

    @Test
    public void testOverlaps() {
        String[] ops;
        this.checkExpType("(date '1-2-3', date '1-2-3')\n overlaps (date '1-2-3', date '1-2-3')", "BOOLEAN NOT NULL");
        this.checkExpType("period (date '1-2-3', date '1-2-3')\n overlaps period (date '1-2-3', date '1-2-3')", "BOOLEAN NOT NULL");
        this.checkExp("(date '1-2-3', date '1-2-3') overlaps (date '1-2-3', interval '1' year)");
        this.checkExp("(time '1:2:3', interval '1' second) overlaps (time '23:59:59', time '1:2:3')");
        this.checkExp("(timestamp '1-2-3 4:5:6', timestamp '1-2-3 4:5:6' ) overlaps (timestamp '1-2-3 4:5:6', interval '1 2:3:4.5' day to second)");
        this.checkWholeExpFails("(timestamp '1-2-3 4:5:6', timestamp '1-2-3 4:5:6' ) overlaps (time '4:5:6', interval '1 2:3:4.5' day to second)", "(?s).*Cannot apply 'OVERLAPS' to arguments of type .*");
        this.checkWholeExpFails("(time '4:5:6', timestamp '1-2-3 4:5:6' ) overlaps (time '4:5:6', interval '1 2:3:4.5' day to second)", "(?s).*Cannot apply 'OVERLAPS' to arguments of type .*");
        this.checkWholeExpFails("(time '4:5:6', time '4:5:6' ) overlaps (time '4:5:6', date '1-2-3')", "(?s).*Cannot apply 'OVERLAPS' to arguments of type .*");
        this.checkWholeExpFails("1 overlaps 2", "(?s).*Cannot apply 'OVERLAPS' to arguments of type '<INTEGER> OVERLAPS <INTEGER>'\\. Supported form.*");
        this.checkExpType("true\nor (date '1-2-3', date '1-2-3')\n   overlaps (date '1-2-3', date '1-2-3')\nor false", "BOOLEAN NOT NULL");
        this.checkExpFails("true\nor ^(date '1-2-3', date '1-2-3', date '1-2-3')\n   overlaps (date '1-2-3', date '1-2-3')^\nor false", "(?s).*Cannot apply 'OVERLAPS' to arguments of type .*");
        this.checkExpFails("true\nor ^(date '1-2-3', date '1-2-3')\n  overlaps (date '1-2-3', date '1-2-3', date '1-2-3')^\nor false", "(?s).*Cannot apply 'OVERLAPS' to arguments of type .*");
        this.checkExpFails("^period (date '1-2-3', date '1-2-3')\n   overlaps (date '1-2-3', date '1-2-3', date '1-2-3')^", "(?s).*Cannot apply 'OVERLAPS' to arguments of type .*");
        this.checkExpFails("true\nor ^(1, 2) overlaps (2, 3)^\nor false", "(?s).*Cannot apply 'OVERLAPS' to arguments of type .*");
        for (String op : ops = new String[]{"overlaps", "contains", "equals", "precedes", "succeeds", "immediately precedes", "immediately succeeds"}) {
            this.checkExpType("period (date '1-2-3', date '1-2-3')\n " + op + " period (date '1-2-3', date '1-2-3')", "BOOLEAN NOT NULL");
            this.checkExpType("(date '1-2-3', date '1-2-3')\n " + op + " (date '1-2-3', date '1-2-3')", "BOOLEAN NOT NULL");
        }
    }

    @Test
    public void testContains() {
        String cannotApply = "(?s).*Cannot apply 'CONTAINS' to arguments of type .*";
        this.checkExpType("(date '1-2-3', date '1-2-3')\n contains (date '1-2-3', date '1-2-3')", "BOOLEAN NOT NULL");
        this.checkExpType("period (date '1-2-3', date '1-2-3')\n contains period (date '1-2-3', date '1-2-3')", "BOOLEAN NOT NULL");
        this.checkExp("(date '1-2-3', date '1-2-3')\n  contains (date '1-2-3', interval '1' year)");
        this.checkExp("(time '1:2:3', interval '1' second)\n contains (time '23:59:59', time '1:2:3')");
        this.checkExp("(timestamp '1-2-3 4:5:6', timestamp '1-2-3 4:5:6')\n contains (timestamp '1-2-3 4:5:6', interval '1 2:3:4.5' day to second)");
        this.checkExp("(date '1-2-3', date '1-2-3')\n  contains date '1-2-3'");
        this.checkExp("period (date '1-2-3', date '1-2-3')\n  contains date '1-2-3'");
        this.checkWholeExpFails("date '1-2-3'\n  contains (date '1-2-3', date '1-2-3')", "(?s).*Cannot apply 'CONTAINS' to arguments of type .*");
        this.checkWholeExpFails("date '1-2-3'\n  contains period (date '1-2-3', date '1-2-3')", "(?s).*Cannot apply 'CONTAINS' to arguments of type .*");
        this.checkWholeExpFails("date '1-2-3' contains date '1-2-3'", "(?s).*Cannot apply 'CONTAINS' to arguments of type .*");
        this.checkWholeExpFails("(timestamp '1-2-3 4:5:6', timestamp '1-2-3 4:5:6' )\n contains (time '4:5:6', interval '1 2:3:4.5' day to second)", "(?s).*Cannot apply 'CONTAINS' to arguments of type .*");
        this.checkWholeExpFails("(time '4:5:6', timestamp '1-2-3 4:5:6' )\n contains (time '4:5:6', interval '1 2:3:4.5' day to second)", "(?s).*Cannot apply 'CONTAINS' to arguments of type .*");
        this.checkWholeExpFails("(time '4:5:6', time '4:5:6' )\n  contains (time '4:5:6', date '1-2-3')", "(?s).*Cannot apply 'CONTAINS' to arguments of type .*");
        this.checkWholeExpFails("1 contains 2", "(?s).*Cannot apply 'CONTAINS' to arguments of type .*");
        this.checkExpFails("true\nor ^(date '1-2-3', date '1-2-3', date '1-2-3')\n  contains (date '1-2-3', date '1-2-3')^\nor false", "(?s).*Cannot apply 'CONTAINS' to arguments of type .*");
        this.checkExpType("true\nor (date '1-2-3', date '1-2-3')\n  contains (date '1-2-3', date '1-2-3')\nor false", "BOOLEAN NOT NULL");
        this.checkExpType("true\nor (date '1-2-3', date '1-2-3')\n  contains date '1-2-3'\nor false", "BOOLEAN NOT NULL");
        this.checkExpType("true\nor (date '1-2-3',\n     case 1 when 2 then date '1-2-3' else null end)\n  contains date '1-2-3'\nor false", "BOOLEAN");
        this.checkExpType("true\nor (date '1-2-3', date '1-2-3')\n  contains case 1 when 1 then date '1-2-3' else null end\nor false", "BOOLEAN");
        this.checkExpFails("true\nor ^period (date '1-2-3', date '1-2-3')\n  contains period (date '1-2-3', time '4:5:6')^\nor false", "(?s).*Cannot apply 'CONTAINS' to arguments of type .*");
        this.checkExpFails("true\nor ^(1, 2) contains (2, 3)^\nor false", "(?s).*Cannot apply 'CONTAINS' to arguments of type .*");
    }

    @Test
    public void testExtract() {
        this.checkExpType("extract(year from interval '1-2' year to month)", "BIGINT NOT NULL");
        this.checkExp("extract(minute from interval '1.1' second)");
        this.checkExp("extract(year from DATE '2008-2-2')");
        this.checkWholeExpFails("extract(minute from interval '11' month)", "(?s).*Cannot apply.*");
        this.checkWholeExpFails("extract(year from interval '11' second)", "(?s).*Cannot apply.*");
    }

    @Test
    public void testCastToInterval() {
        this.checkExpType("cast(interval '1' hour as varchar(20))", "VARCHAR(20) NOT NULL");
        this.checkExpType("cast(interval '1' hour as bigint)", "BIGINT NOT NULL");
        this.checkExpType("cast(1000 as interval hour)", "INTERVAL HOUR NOT NULL");
        this.checkExpType("cast(interval '1' month as interval year)", "INTERVAL YEAR NOT NULL");
        this.checkExpType("cast(interval '1-1' year to month as interval month)", "INTERVAL MONTH NOT NULL");
        this.checkExpType("cast(interval '1:1' hour to minute as interval day)", "INTERVAL DAY NOT NULL");
        this.checkExpType("cast(interval '1:1' hour to minute as interval minute to second)", "INTERVAL MINUTE TO SECOND NOT NULL");
        this.checkWholeExpFails("cast(interval '1:1' hour to minute as interval month)", "Cast function cannot convert value of type INTERVAL HOUR TO MINUTE to type INTERVAL MONTH");
        this.checkWholeExpFails("cast(interval '1-1' year to month as interval second)", "Cast function cannot convert value of type INTERVAL YEAR TO MONTH to type INTERVAL SECOND");
    }

    @Test
    public void testMinusDateOperator() {
        this.checkExpType("(CURRENT_DATE - CURRENT_DATE) HOUR", "INTERVAL HOUR NOT NULL");
        this.checkExpType("(CURRENT_DATE - CURRENT_DATE) YEAR TO MONTH", "INTERVAL YEAR TO MONTH NOT NULL");
        this.checkWholeExpFails("(CURRENT_DATE - LOCALTIME) YEAR TO MONTH", "(?s).*Parameters must be of the same type.*");
    }

    @Test
    public void testBind() {
        this.sql("select * from emp where deptno = ?").ok();
        this.sql("select * from emp where deptno = ? and sal < 100000").ok();
        this.sql("select case when deptno = ? then 1 else 2 end from emp").ok();
        this.sql("select deptno from emp group by substring(name from ^?^ for ?)").fails("Illegal use of dynamic parameter");
        this.sql("select count(*) from emp group by position(^?^ in ename)").fails("Illegal use of dynamic parameter");
        this.sql("select ^deptno^ from emp\ngroup by case when deptno = ? then 1 else 2 end").fails("Expression 'DEPTNO' is not being grouped");
        this.sql("select deptno from emp\ngroup by deptno, case when deptno = ? then 1 else 2 end").ok();
        this.sql("select 1 from emp having sum(sal) < ?").ok();
    }

    @Test
    public void testBindBetween() {
        this.sql("select * from emp where ename between ? and ?").ok();
        this.sql("select * from emp where deptno between ? and ?").ok();
        this.sql("select * from emp where ? between deptno and ?").ok();
        this.sql("select * from emp where ? between ? and deptno").ok();
        this.sql("select * from emp where ^?^ between ? and ?").fails("Illegal use of dynamic parameter");
    }

    @Test
    public void testUnnest() {
        this.checkColumnType("select*from unnest(multiset[1])", "INTEGER NOT NULL");
        this.checkColumnType("select*from unnest(multiset[1, 2])", "INTEGER NOT NULL");
        this.checkColumnType("select*from unnest(multiset[321.3, 2.33])", "DECIMAL(5, 2) NOT NULL");
        this.checkColumnType("select*from unnest(multiset[321.3, 4.23e0])", "DOUBLE NOT NULL");
        this.checkColumnType("select*from unnest(multiset[43.2e1, cast(null as decimal(4,2))])", "DOUBLE");
        this.checkColumnType("select*from unnest(multiset[1, 2.3, 1])", "DECIMAL(11, 1) NOT NULL");
        this.checkColumnType("select*from unnest(multiset['1','22','333'])", "CHAR(3) NOT NULL");
        this.checkColumnType("select*from unnest(multiset['1','22','333','22'])", "CHAR(3) NOT NULL");
        this.checkFails("select*from ^unnest(1)^", "(?s).*Cannot apply 'UNNEST' to arguments of type 'UNNEST.<INTEGER>.'.*");
        this.check("select*from unnest(multiset(select*from dept))");
        this.check("select c from unnest(multiset(select deptno from dept)) as t(c)");
        this.checkFails("select c from unnest(multiset(select * from dept)) as t(^c^)", "List of column aliases must have same degree as table; table has 2 columns \\('DEPTNO', 'NAME'\\), whereas alias list has 1 columns");
        this.checkFails("select ^c1^ from unnest(multiset(select name from dept)) as t(c)", "Column 'C1' not found in any table");
    }

    @Test
    public void testUnnestArray() {
        this.checkColumnType("select*from unnest(array[1])", "INTEGER NOT NULL");
        this.checkColumnType("select*from unnest(array[1, 2])", "INTEGER NOT NULL");
        this.checkColumnType("select*from unnest(array[321.3, 2.33])", "DECIMAL(5, 2) NOT NULL");
        this.checkColumnType("select*from unnest(array[321.3, 4.23e0])", "DOUBLE NOT NULL");
        this.checkColumnType("select*from unnest(array[43.2e1, cast(null as decimal(4,2))])", "DOUBLE");
        this.checkColumnType("select*from unnest(array[1, 2.3, 1])", "DECIMAL(11, 1) NOT NULL");
        this.checkColumnType("select*from unnest(array['1','22','333'])", "CHAR(3) NOT NULL");
        this.checkColumnType("select*from unnest(array['1','22','333','22'])", "CHAR(3) NOT NULL");
        this.checkColumnType("select*from unnest(array['1','22',null,'22'])", "CHAR(2)");
        this.checkFails("select*from ^unnest(1)^", "(?s).*Cannot apply 'UNNEST' to arguments of type 'UNNEST.<INTEGER>.'.*");
        this.check("select*from unnest(array(select*from dept))");
        this.check("select*from unnest(array[1,null])");
        this.check("select c from unnest(array(select deptno from dept)) as t(c)");
        this.checkFails("select c from unnest(array(select * from dept)) as t(^c^)", "List of column aliases must have same degree as table; table has 2 columns \\('DEPTNO', 'NAME'\\), whereas alias list has 1 columns");
        this.checkFails("select ^c1^ from unnest(array(select name from dept)) as t(c)", "Column 'C1' not found in any table");
    }

    @Test
    public void testArrayConstructor() {
        this.sql("select array[1,2] as a from (values (1))").columnType("INTEGER NOT NULL ARRAY NOT NULL");
        this.sql("select array[1,cast(null as integer), 2] as a\nfrom (values (1))").columnType("INTEGER ARRAY NOT NULL");
        this.sql("select array[1,null,2] as a from (values (1))").columnType("INTEGER ARRAY NOT NULL");
        this.sql("select array['1',null,'234',''] as a from (values (1))").columnType("CHAR(3) ARRAY NOT NULL");
    }

    @Test
    public void testMultisetConstructor() {
        this.sql("select multiset[1,null,2] as a from (values (1))").columnType("INTEGER MULTISET NOT NULL");
    }

    @Test
    public void testUnnestArrayColumn() {
        String sql = "select d.deptno, e.*\nfrom dept_nested as d,\n UNNEST(d.employees) as e";
        String type = "RecordType(INTEGER NOT NULL DEPTNO, INTEGER NOT NULL EMPNO, VARCHAR(10) NOT NULL ENAME) NOT NULL";
        this.sql("select d.deptno, e.*\nfrom dept_nested as d,\n UNNEST(d.employees) as e").type("RecordType(INTEGER NOT NULL DEPTNO, INTEGER NOT NULL EMPNO, VARCHAR(10) NOT NULL ENAME) NOT NULL");
        String sql2 = "select d.deptno, e.*\nfrom dept_nested as d CROSS JOIN\n UNNEST(d.employees) as e";
        this.sql("select d.deptno, e.*\nfrom dept_nested as d CROSS JOIN\n UNNEST(d.employees) as e").type("RecordType(INTEGER NOT NULL DEPTNO, INTEGER NOT NULL EMPNO, VARCHAR(10) NOT NULL ENAME) NOT NULL");
        String sql3 = "select d.deptno, e.*\nfrom UNNEST(^d^.employees) as e, dept_nested as d";
        this.sql("select d.deptno, e.*\nfrom UNNEST(^d^.employees) as e, dept_nested as d").fails("Table 'D' not found");
    }

    @Test
    public void testUnnestWithOrdinality() {
        this.checkResultType("select*from unnest(array[1, 2]) with ordinality", "RecordType(INTEGER NOT NULL EXPR$0, INTEGER NOT NULL ORDINALITY) NOT NULL");
        this.checkResultType("select*from unnest(array[43.2e1, cast(null as decimal(4,2))]) with ordinality", "RecordType(DOUBLE EXPR$0, INTEGER NOT NULL ORDINALITY) NOT NULL");
        this.checkFails("select*from ^unnest(1) with ordinality^", "(?s).*Cannot apply 'UNNEST' to arguments of type 'UNNEST.<INTEGER>.'.*");
        this.check("select deptno\nfrom unnest(array(select*from dept)) with ordinality\nwhere ordinality < 5");
        this.checkFails("select c from unnest(\n  array(select deptno from dept)) with ordinality as t(^c^)", "List of column aliases must have same degree as table; table has 2 columns \\('DEPTNO', 'ORDINALITY'\\), whereas alias list has 1 columns");
        this.check("select c from unnest(\n  array(select deptno from dept)) with ordinality as t(c, d)");
        this.checkFails("select c from unnest(\n  array(select deptno from dept)) with ordinality as t(^c, d, e^)", "List of column aliases must have same degree as table; table has 2 columns \\('DEPTNO', 'ORDINALITY'\\), whereas alias list has 3 columns");
        this.checkFails("select c\nfrom unnest(array(select * from dept)) with ordinality as t(^c, d, e, f^)", "List of column aliases must have same degree as table; table has 3 columns \\('DEPTNO', 'NAME', 'ORDINALITY'\\), whereas alias list has 4 columns");
        this.checkFails("select ^name^ from unnest(array(select name from dept)) with ordinality as t(c, o)", "Column 'NAME' not found in any table");
        this.checkFails("select ^ordinality^ from unnest(array(select name from dept)) with ordinality as t(c, o)", "Column 'ORDINALITY' not found in any table");
    }

    @Test
    public void unnestMapMustNameColumnsKeyAndValueWhenNotAliased() {
        this.checkResultType("select * from unnest(map[1, 12, 2, 22])", "RecordType(INTEGER NOT NULL KEY, INTEGER NOT NULL VALUE) NOT NULL");
    }

    @Test
    public void testCorrelationJoin() {
        this.check("select *,         multiset(select * from emp where deptno=dept.deptno)                as empset      from dept");
        this.check("select*from unnest(select multiset[8] from dept)");
        this.check("select*from unnest(select multiset[deptno] from dept)");
    }

    @Test
    public void testStructuredTypes() {
        this.checkColumnType("values new address()", "ObjectSqlType(ADDRESS) NOT NULL");
        this.checkColumnType("select home_address from emp_address", "ObjectSqlType(ADDRESS) NOT NULL");
        this.checkColumnType("select ea.home_address.zip from emp_address ea", "INTEGER NOT NULL");
        this.checkColumnType("select ea.mailing_address.city from emp_address ea", "VARCHAR(20) NOT NULL");
    }

    @Test
    public void testLateral() {
        this.checkFails("select * from emp, (select * from dept where ^emp^.deptno=dept.deptno)", "Table 'EMP' not found");
        this.check("select * from emp,\n  LATERAL (select * from dept where emp.deptno=dept.deptno)");
        this.check("select * from emp,\n  LATERAL (select * from dept where emp.deptno=dept.deptno) as ldt");
        this.check("select * from emp,\n  LATERAL (select * from dept where emp.deptno=dept.deptno) ldt");
    }

    @Test
    public void testCollect() {
        this.check("select collect(deptno) from emp");
        this.check("select collect(multiset[3]) from emp");
        this.sql("select collect(multiset[3]), ^deptno^ from emp").fails("Expression 'DEPTNO' is not being grouped");
    }

    @Test
    public void testFusion() {
        this.checkFails("select ^fusion(deptno)^ from emp", "(?s).*Cannot apply 'FUSION' to arguments of type 'FUSION.<INTEGER>.'.*");
        this.check("select fusion(multiset[3]) from emp");
    }

    @Test
    public void testCountFunction() {
        this.check("select count(*) from emp");
        this.check("select count(ename) from emp");
        this.check("select count(sal) from emp");
        this.check("select count(1) from emp");
        this.checkFails("select ^count()^ from emp", "Invalid number of arguments to function 'COUNT'. Was expecting 1 arguments");
    }

    @Test
    public void testCountCompositeFunction() {
        this.check("select count(ename, deptno) from emp");
        this.checkFails("select count(ename, deptno, ^gender^) from emp", "Column 'GENDER' not found in any table");
        this.check("select count(ename, 1, deptno) from emp");
        this.check("select count(distinct ename, 1, deptno) from emp");
        this.checkFails("select count(deptno, *) from emp", "(?s).*Encountered \", \\*\" at .*");
        this.checkFails("select count(*, deptno) from emp", "(?s).*Encountered \",\" at .*");
    }

    @Test
    public void testLastFunction() {
        this.check("select LAST_VALUE(sal) over (order by empno) from emp");
        this.check("select LAST_VALUE(ename) over (order by empno) from emp");
        this.check("select FIRST_VALUE(sal) over (order by empno) from emp");
        this.check("select FIRST_VALUE(ename) over (order by empno) from emp");
    }

    @Test
    public void testMinMaxFunctions() {
        this.check("SELECT MIN(true) from emp");
        this.check("SELECT MAX(false) from emp");
        this.check("SELECT MIN(sal+deptno) FROM emp");
        this.check("SELECT MAX(ename) FROM emp");
        this.check("SELECT MIN(5.5) FROM emp");
        this.check("SELECT MAX(5) FROM emp");
    }

    @Test
    public void testFunctionalDistinct() {
        this.check("select count(distinct sal) from emp");
        this.checkFails("select COALESCE(^distinct^ sal) from emp", "DISTINCT/ALL not allowed with COALESCE function");
    }

    @Test
    public void testColumnNotFound() {
        this.sql("select ^b0^ from sales.emp").fails("Column 'B0' not found in any table");
    }

    @Test
    public void testColumnNotFound2() {
        this.sql("select ^b0^ from sales.emp, sales.dept").fails("Column 'B0' not found in any table");
    }

    @Test
    public void testColumnNotFound3() {
        this.sql("select e.^b0^ from sales.emp as e").fails("Column 'B0' not found in table 'E'");
    }

    @Test
    public void testSelectDistinct() {
        this.check("SELECT DISTINCT deptno FROM emp");
        this.check("SELECT DISTINCT deptno, sal FROM emp");
        this.check("SELECT DISTINCT deptno FROM emp GROUP BY deptno");
        this.checkFails("SELECT DISTINCT ^deptno^ FROM emp GROUP BY sal", "Expression 'DEPTNO' is not being grouped");
        this.check("SELECT DISTINCT avg(sal) from emp");
        this.checkFails("SELECT DISTINCT ^deptno^, avg(sal) from emp", "Expression 'DEPTNO' is not being grouped");
        this.check("SELECT DISTINCT deptno, sal from emp GROUP BY sal, deptno");
        this.check("SELECT deptno FROM emp GROUP BY deptno HAVING deptno > 55");
        this.check("SELECT DISTINCT deptno, 33 FROM emp\nGROUP BY deptno HAVING deptno > 55");
        this.sql("SELECT DISTINCT deptno, 33 FROM emp HAVING ^deptno^ > 55").fails("Expression 'DEPTNO' is not being grouped");
        this.sql("SELECT DISTINCT ^deptno^, 33 FROM emp HAVING deptno > 55").tester(this.tester.withConformance((SqlConformance)SqlConformanceEnum.LENIENT)).fails("Expression 'DEPTNO' is not being grouped");
        this.sql("SELECT DISTINCT 33 FROM emp HAVING ^deptno^ > 55").fails("Expression 'DEPTNO' is not being grouped").tester(this.tester.withConformance((SqlConformance)SqlConformanceEnum.LENIENT)).fails("Expression 'DEPTNO' is not being grouped");
        this.check("SELECT DISTINCT * from emp");
        this.checkFails("SELECT DISTINCT ^*^ from emp GROUP BY deptno", "Expression 'EMP\\.EMPNO' is not being grouped");
        this.checkFails("SELECT deptno FROM emp GROUP BY deptno ORDER BY deptno, ^empno^", "Expression 'EMPNO' is not being grouped");
        this.checkFails("SELECT DISTINCT deptno from emp ORDER BY deptno, ^empno^", "Expression 'EMPNO' is not in the select clause");
        this.check("SELECT DISTINCT deptno from emp ORDER BY deptno + 2");
        this.checkFails("SELECT DISTINCT deptno FROM emp GROUP BY deptno, empno ORDER BY deptno, ^empno^", "Expression 'EMPNO' is not in the select clause");
        this.check("select distinct * from (\n  select distinct deptno from emp) order by 1");
        this.check("SELECT DISTINCT 5, 10+5, 'string' from emp");
    }

    @Test
    public void testSelectWithoutFrom() {
        this.sql("^select 2+2^").tester(this.tester.withConformance((SqlConformance)SqlConformanceEnum.DEFAULT)).ok();
        this.sql("^select 2+2^").tester(this.tester.withConformance((SqlConformance)SqlConformanceEnum.ORACLE_10)).fails("SELECT must have a FROM clause");
        this.sql("^select 2+2^").tester(this.tester.withConformance((SqlConformance)SqlConformanceEnum.STRICT_2003)).fails("SELECT must have a FROM clause");
    }

    @Test
    public void testTableExtend() {
        this.checkResultType("select * from dept extend (x int not null)", "RecordType(INTEGER NOT NULL DEPTNO, VARCHAR(10) NOT NULL NAME, INTEGER NOT NULL X) NOT NULL");
        this.checkResultType("select deptno + x as z\nfrom dept extend (x int not null) as x\nwhere x > 10", "RecordType(INTEGER NOT NULL Z) NOT NULL");
    }

    @Test
    public void testExplicitTable() {
        String empRecordType = EMP_RECORD_TYPE;
        this.checkResultType("select * from (table emp)", EMP_RECORD_TYPE);
        this.checkResultType("table emp", EMP_RECORD_TYPE);
        this.checkFails("table ^nonexistent^", "Object 'NONEXISTENT' not found");
        this.checkFails("table ^sales.nonexistent^", "Object 'NONEXISTENT' not found within 'SALES'");
        this.checkFails("table ^nonexistent.foo^", "Object 'NONEXISTENT' not found");
    }

    @Test
    public void testCollectionTable() {
        this.checkResultType("select * from table(ramp(3))", "RecordType(INTEGER NOT NULL I) NOT NULL");
        this.checkFails("select * from table(^ramp('3')^)", "Cannot apply 'RAMP' to arguments of type 'RAMP\\(<CHAR\\(1\\)>\\)'\\. Supported form\\(s\\): 'RAMP\\(<NUMERIC>\\)'");
        this.checkFails("select * from table(^nonExistentRamp('3')^)", "No match found for function signature NONEXISTENTRAMP\\(<CHARACTER>\\)");
    }

    @Test
    public void testCollectionTableWithLateral() {
        String expectedType = "RecordType(INTEGER NOT NULL DEPTNO, VARCHAR(10) NOT NULL NAME, INTEGER NOT NULL I) NOT NULL";
        this.sql("select * from dept, lateral table(ramp(dept.deptno))").type("RecordType(INTEGER NOT NULL DEPTNO, VARCHAR(10) NOT NULL NAME, INTEGER NOT NULL I) NOT NULL");
        this.sql("select * from dept cross join lateral table(ramp(dept.deptno))").type("RecordType(INTEGER NOT NULL DEPTNO, VARCHAR(10) NOT NULL NAME, INTEGER NOT NULL I) NOT NULL");
        this.sql("select * from dept join lateral table(ramp(dept.deptno)) on true").type("RecordType(INTEGER NOT NULL DEPTNO, VARCHAR(10) NOT NULL NAME, INTEGER NOT NULL I) NOT NULL");
        String expectedType2 = "RecordType(INTEGER NOT NULL DEPTNO, VARCHAR(10) NOT NULL NAME, INTEGER I) NOT NULL";
        this.sql("select * from dept left join lateral table(ramp(dept.deptno)) on true").type("RecordType(INTEGER NOT NULL DEPTNO, VARCHAR(10) NOT NULL NAME, INTEGER I) NOT NULL");
        this.sql("select * from dept, lateral table(^ramp(dept.name)^)").fails("(?s)Cannot apply 'RAMP' to arguments of type 'RAMP\\(<VARCHAR\\(10\\)>\\)'.*");
        this.sql("select * from lateral table(ramp(^dept^.deptno)), dept").fails("Table 'DEPT' not found");
        String expectedType3 = "RecordType(INTEGER NOT NULL I, INTEGER NOT NULL DEPTNO, VARCHAR(10) NOT NULL NAME) NOT NULL";
        this.sql("select * from lateral table(ramp(1234)), dept").type("RecordType(INTEGER NOT NULL I, INTEGER NOT NULL DEPTNO, VARCHAR(10) NOT NULL NAME) NOT NULL");
    }

    @Test
    public void testCollectionTableWithLateral2() {
        this.sql("select * from emp, lateral table(ramp(emp.deptno)), dept").ok();
        this.sql("select * from emp, lateral table(ramp(^z^.i)) as z, dept").fails("Table 'Z' not found");
        this.sql("select * from emp, lateral table(ramp(^dept^.deptno)), dept").fails("Table 'DEPT' not found");
    }

    @Test
    public void testCollectionTableWithCursorParam() {
        this.checkResultType("select * from table(dedup(cursor(select * from emp),'ename'))", "RecordType(VARCHAR(1024) NOT NULL NAME) NOT NULL");
        this.checkFails("select * from table(dedup(cursor(select * from ^bloop^),'ename'))", "Object 'BLOOP' not found");
    }

    @Test
    public void testScalarSubQuery() {
        this.check("SELECT  ename,(select name from dept where deptno=1) FROM emp");
        this.checkFails("SELECT ename,(^select losal, hisal from salgrade where grade=1^) FROM emp", "Cannot apply '\\$SCALAR_QUERY' to arguments of type '\\$SCALAR_QUERY\\(<RECORDTYPE\\(INTEGER LOSAL, INTEGER HISAL\\)>\\)'\\. Supported form\\(s\\): '\\$SCALAR_QUERY\\(<RECORDTYPE\\(SINGLE FIELD\\)>\\)'");
        this.checkResultType("SELECT  ename,(select name from dept where deptno=1) FROM emp", "RecordType(VARCHAR(20) NOT NULL ENAME, VARCHAR(10) EXPR$1) NOT NULL");
        this.checkResultType("SELECT  ename,(select name from dept where deptno=1) as X FROM emp", "RecordType(VARCHAR(20) NOT NULL ENAME, VARCHAR(10) X) NOT NULL");
        this.checkResultType("SELECT  ename, 1 + (select deptno from dept where deptno=1) as X FROM emp", "RecordType(VARCHAR(20) NOT NULL ENAME, INTEGER X) NOT NULL");
        this.check("select * from emp where (select true from dept)");
    }

    @Ignore(value="not supported")
    @Test
    public void testSubQueryInOnClause() {
        this.check("select * from emp as emps left outer join dept as depts\non emps.deptno = depts.deptno and emps.deptno = (\nselect min(deptno) from dept as depts2)");
    }

    @Test
    public void testRecordType() {
        this.checkFails("SELECT ^coord^.x, coord.y FROM customer.contact", "Table 'COORD' not found");
        this.checkResultType("SELECT contact.coord.x, contact.coord.y FROM customer.contact", "RecordType(INTEGER NOT NULL X, INTEGER NOT NULL Y) NOT NULL");
        this.checkResultType("SELECT customer.contact.coord.x, customer.contact.email, contact.coord.y FROM customer.contact", "RecordType(INTEGER NOT NULL X, VARCHAR(20) NOT NULL EMAIL, INTEGER NOT NULL Y) NOT NULL");
    }

    @Test
    public void testRecordTypeElided() {
        this.sql("SELECT contact.^x^, contact.coord.y FROM customer.contact").fails("Column 'X' not found in table 'CONTACT'");
        this.sql("SELECT contact.coord.x, contact.coord.y FROM customer.contact").type("RecordType(INTEGER NOT NULL X, INTEGER NOT NULL Y) NOT NULL");
        this.sql("SELECT c.x, c.coord.y FROM customer.contact_peek as c").type("RecordType(INTEGER NOT NULL X, INTEGER NOT NULL Y) NOT NULL");
        this.sql("SELECT c.coord.x, c.coord.y FROM customer.contact_peek as c").type("RecordType(INTEGER NOT NULL X, INTEGER NOT NULL Y) NOT NULL");
        this.sql("SELECT x, c.coord.y FROM customer.contact_peek as c").type("RecordType(INTEGER NOT NULL X, INTEGER NOT NULL Y) NOT NULL");
        String sql = "SELECT customer.contact_peek.x,\n customer.contact_peek.email, contact_peek.coord.y\nFROM customer.contact_peek";
        this.sql("SELECT customer.contact_peek.x,\n customer.contact_peek.email, contact_peek.coord.y\nFROM customer.contact_peek").type("RecordType(INTEGER NOT NULL X, VARCHAR(20) NOT NULL EMAIL, INTEGER NOT NULL Y) NOT NULL");
    }

    @Test
    public void testSample() {
        this.check("SELECT * FROM emp TABLESAMPLE SUBSTITUTE('foo')");
        this.check("SELECT * FROM emp TABLESAMPLE BERNOULLI(50)");
        this.check("SELECT * FROM emp TABLESAMPLE SYSTEM(50)");
        this.check("SELECT * FROM (SELECT deptno FROM emp UNION ALL SELECT deptno FROM dept) AS x TABLESAMPLE SUBSTITUTE('foo') WHERE x.deptno < 100");
        this.checkFails("SELECT x.^empno^ FROM (SELECT deptno FROM emp TABLESAMPLE SUBSTITUTE('bar') UNION ALL SELECT deptno FROM dept) AS x TABLESAMPLE SUBSTITUTE('foo') ORDER BY 1", "Column 'EMPNO' not found in table 'X'");
        this.check("select * from (\n    select * from emp\n    join dept on emp.deptno = dept.deptno\n) tablesample substitute('SMALL')");
        this.check("SELECT * FROM (SELECT deptno FROM emp UNION ALL SELECT deptno FROM dept) AS x TABLESAMPLE BERNOULLI(50) WHERE x.deptno < 100");
        this.checkFails("SELECT x.^empno^ FROM (SELECT deptno FROM emp TABLESAMPLE BERNOULLI(50) UNION ALL SELECT deptno FROM dept) AS x TABLESAMPLE BERNOULLI(10) ORDER BY 1", "Column 'EMPNO' not found in table 'X'");
        this.check("select * from (\n    select * from emp\n    join dept on emp.deptno = dept.deptno\n) tablesample bernoulli(10)");
        this.check("SELECT * FROM (SELECT deptno FROM emp UNION ALL SELECT deptno FROM dept) AS x TABLESAMPLE SYSTEM(50) WHERE x.deptno < 100");
        this.checkFails("SELECT x.^empno^ FROM (SELECT deptno FROM emp TABLESAMPLE SYSTEM(50) UNION ALL SELECT deptno FROM dept) AS x TABLESAMPLE SYSTEM(10) ORDER BY 1", "Column 'EMPNO' not found in table 'X'");
        this.check("select * from (\n    select * from emp\n    join dept on emp.deptno = dept.deptno\n) tablesample system(10)");
    }

    @Test
    public void testRewriteWithoutIdentifierExpansion() {
        SqlValidator validator = this.tester.getValidator();
        validator.setIdentifierExpansion(false);
        this.tester.checkRewrite(validator, "select * from dept", "SELECT *\nFROM `DEPT`");
    }

    @Test
    public void testRewriteWithLimitWithoutOrderBy() {
        SqlValidator validator = this.tester.getValidator();
        validator.setIdentifierExpansion(false);
        String sql = "select name from dept limit 2";
        String expected = "SELECT `NAME`\nFROM `DEPT`\nFETCH NEXT 2 ROWS ONLY";
        this.tester.checkRewrite(validator, "select name from dept limit 2", "SELECT `NAME`\nFROM `DEPT`\nFETCH NEXT 2 ROWS ONLY");
    }

    @Test
    public void testRewriteWithOffsetWithoutOrderBy() {
        SqlValidator validator = this.tester.getValidator();
        validator.setIdentifierExpansion(false);
        String sql = "select name from dept offset 2";
        String expected = "SELECT `NAME`\nFROM `DEPT`\nOFFSET 2 ROWS";
        this.tester.checkRewrite(validator, "select name from dept offset 2", "SELECT `NAME`\nFROM `DEPT`\nOFFSET 2 ROWS");
    }

    @Test
    public void testRewriteWithUnionFetchWithoutOrderBy() {
        SqlValidator validator = this.tester.getValidator();
        validator.setIdentifierExpansion(false);
        String sql = "select name from dept union all select name from dept limit 2";
        String expected = "SELECT *\nFROM (SELECT `NAME`\nFROM `DEPT`\nUNION ALL\nSELECT `NAME`\nFROM `DEPT`)\nFETCH NEXT 2 ROWS ONLY";
        this.tester.checkRewrite(validator, "select name from dept union all select name from dept limit 2", "SELECT *\nFROM (SELECT `NAME`\nFROM `DEPT`\nUNION ALL\nSELECT `NAME`\nFROM `DEPT`)\nFETCH NEXT 2 ROWS ONLY");
    }

    @Test
    public void testRewriteWithIdentifierExpansion() {
        SqlValidator validator = this.tester.getValidator();
        validator.setIdentifierExpansion(true);
        this.tester.checkRewrite(validator, "select * from dept", "SELECT `DEPT`.`DEPTNO`, `DEPT`.`NAME`\nFROM `CATALOG`.`SALES`.`DEPT` AS `DEPT`");
    }

    @Test
    public void testRewriteWithColumnReferenceExpansion() {
        SqlValidator validator = this.tester.getValidator();
        validator.setIdentifierExpansion(true);
        validator.setColumnReferenceExpansion(true);
        this.tester.checkRewrite(validator, "select name from dept where name = 'Moonracer' group by name having sum(deptno) > 3 order by name", "SELECT `DEPT`.`NAME`\nFROM `CATALOG`.`SALES`.`DEPT` AS `DEPT`\nWHERE `DEPT`.`NAME` = 'Moonracer'\nGROUP BY `DEPT`.`NAME`\nHAVING SUM(`DEPT`.`DEPTNO`) > 3\nORDER BY `NAME`");
    }

    @Test
    public void testRewriteWithColumnReferenceExpansionAndFromAlias() {
        SqlValidator validator = this.tester.getValidator();
        validator.setIdentifierExpansion(true);
        validator.setColumnReferenceExpansion(true);
        this.tester.checkRewrite(validator, "select ename, sal from (select * from emp) as e where ename = 'Moonracer' group by ename, deptno, sal having sum(deptno) > 3 order by ename, deptno, e.sal", "SELECT `E`.`ENAME`, `E`.`SAL`\nFROM (SELECT `EMP`.`EMPNO`, `EMP`.`ENAME`, `EMP`.`JOB`, `EMP`.`MGR`, `EMP`.`HIREDATE`, `EMP`.`SAL`, `EMP`.`COMM`, `EMP`.`DEPTNO`, `EMP`.`SLACKER`\nFROM `CATALOG`.`SALES`.`EMP` AS `EMP`) AS `E`\nWHERE `E`.`ENAME` = 'Moonracer'\nGROUP BY `E`.`ENAME`, `E`.`DEPTNO`, `E`.`SAL`\nHAVING SUM(`E`.`DEPTNO`) > 3\nORDER BY `ENAME`, `E`.`DEPTNO`, `E`.`SAL`");
    }

    @Test
    public void testCoalesceWithoutRewrite() {
        SqlValidator validator = this.tester.getValidator();
        validator.setCallRewrite(false);
        if (validator.shouldExpandIdentifiers()) {
            this.tester.checkRewrite(validator, "select coalesce(deptno, empno) from emp", "SELECT COALESCE(`EMP`.`DEPTNO`, `EMP`.`EMPNO`)\nFROM `CATALOG`.`SALES`.`EMP` AS `EMP`");
        } else {
            this.tester.checkRewrite(validator, "select coalesce(deptno, empno) from emp", "SELECT COALESCE(`DEPTNO`, `EMPNO`)\nFROM `EMP`");
        }
    }

    @Test
    public void testCoalesceWithRewrite() {
        SqlValidator validator = this.tester.getValidator();
        validator.setCallRewrite(true);
        if (validator.shouldExpandIdentifiers()) {
            this.tester.checkRewrite(validator, "select coalesce(deptno, empno) from emp", "SELECT CASE WHEN `EMP`.`DEPTNO` IS NOT NULL THEN `EMP`.`DEPTNO` ELSE `EMP`.`EMPNO` END\nFROM `CATALOG`.`SALES`.`EMP` AS `EMP`");
        } else {
            this.tester.checkRewrite(validator, "select coalesce(deptno, empno) from emp", "SELECT CASE WHEN `DEPTNO` IS NOT NULL THEN `DEPTNO` ELSE `EMPNO` END\nFROM `EMP`");
        }
    }

    public void _testValuesWithAggFuncs() {
        this.checkFails("values(^count(1)^)", "Call to xxx is invalid\\. Direct calls to aggregate functions not allowed in ROW definitions\\.");
    }

    @Test
    public void testFieldOrigin() {
        this.tester.checkFieldOrigin("select * from emp join dept on true", "{CATALOG.SALES.EMP.EMPNO, CATALOG.SALES.EMP.ENAME, CATALOG.SALES.EMP.JOB, CATALOG.SALES.EMP.MGR, CATALOG.SALES.EMP.HIREDATE, CATALOG.SALES.EMP.SAL, CATALOG.SALES.EMP.COMM, CATALOG.SALES.EMP.DEPTNO, CATALOG.SALES.EMP.SLACKER, CATALOG.SALES.DEPT.DEPTNO, CATALOG.SALES.DEPT.NAME}");
        this.tester.checkFieldOrigin("select distinct emp.empno, hiredate, 1 as uno,\n emp.empno * 2 as twiceEmpno\nfrom emp join dept on true", "{CATALOG.SALES.EMP.EMPNO, CATALOG.SALES.EMP.HIREDATE, null, null}");
    }

    @Test
    public void testBrackets() {
        SqlTester tester1 = this.tester.withQuoting(Quoting.BRACKET);
        tester1.checkResultType("select [e].EMPNO from [EMP] as [e]", "RecordType(INTEGER NOT NULL EMPNO) NOT NULL");
        tester1.checkQueryFails("select ^e^.EMPNO from [EMP] as [e]", "Table 'E' not found; did you mean 'e'\\?");
        tester1.checkQueryFails("select ^x^ from (\n  select [e].EMPNO as [x] from [EMP] as [e])", "Column 'X' not found in any table; did you mean 'x'\\?");
        tester1.checkQueryFails("select ^x^ from (\n  select [e].EMPNO as [x ] from [EMP] as [e])", "Column 'X' not found in any table");
        tester1.checkQueryFails("select EMP.^\"x\"^ from EMP", "(?s).*Encountered \"\\. \\\\\"\" at line .*");
        tester1.checkResultType("select [x[y]] z ] from (\n  select [e].EMPNO as [x[y]] z ] from [EMP] as [e])", "RecordType(INTEGER NOT NULL x[y] z ) NOT NULL");
    }

    @Test
    public void testLexJava() {
        SqlTester tester1 = this.tester.withLex(Lex.JAVA);
        tester1.checkResultType("select e.EMPNO from EMP as e", "RecordType(INTEGER NOT NULL EMPNO) NOT NULL");
        tester1.checkQueryFails("select ^e^.EMPNO from EMP as E", "Table 'e' not found; did you mean 'E'\\?");
        tester1.checkQueryFails("select ^E^.EMPNO from EMP as e", "Table 'E' not found; did you mean 'e'\\?");
        tester1.checkQueryFails("select ^x^ from (\n  select e.EMPNO as X from EMP as e)", "Column 'x' not found in any table; did you mean 'X'\\?");
        tester1.checkQueryFails("select ^x^ from (\n  select e.EMPNO as Xx from EMP as e)", "Column 'x' not found in any table");
        tester1.checkQueryFails("select EMP.^\"x\"^ from EMP", "(?s).*Encountered \"\\. \\\\\"\" at line .*");
        tester1.checkResultType("select `x[y] z ` from (\n  select e.EMPNO as `x[y] z ` from EMP as e)", "RecordType(INTEGER NOT NULL x[y] z ) NOT NULL");
    }

    @Test
    public void testLexJavaKeyword() {
        SqlTester tester1 = this.tester.withLex(Lex.JAVA);
        tester1.checkResultType("select path, x from (select 1 as path, 2 as x from (values (true)))", "RecordType(INTEGER NOT NULL path, INTEGER NOT NULL x) NOT NULL");
        tester1.checkResultType("select path, x from (select 1 as `path`, 2 as x from (values (true)))", "RecordType(INTEGER NOT NULL path, INTEGER NOT NULL x) NOT NULL");
        tester1.checkResultType("select `path`, x from (select 1 as path, 2 as x from (values (true)))", "RecordType(INTEGER NOT NULL path, INTEGER NOT NULL x) NOT NULL");
        tester1.checkFails("select ^PATH^ from (select 1 as path from (values (true)))", "Column 'PATH' not found in any table; did you mean 'path'\\?", false);
        tester1.checkFails("select t.^PATH^ from (select 1 as path from (values (true))) as t", "Column 'PATH' not found in table 't'; did you mean 'path'\\?", false);
        tester1.checkQueryFails("select t.x, t.^PATH^ from (values (true, 1)) as t(path, x)", "Column 'PATH' not found in table 't'; did you mean 'path'\\?");
        tester1.checkQuery("values (current_timestamp, floor(2.5), ceil (3.5))");
        tester1.checkQuery("values (CURRENT_TIMESTAMP, FLOOR(2.5), CEIL (3.5))");
        tester1.checkResultType("values (CURRENT_TIMESTAMP, CEIL (3.5))", "RecordType(TIMESTAMP(0) NOT NULL CURRENT_TIMESTAMP, DECIMAL(2, 0) NOT NULL EXPR$1) NOT NULL");
    }

    @Test
    public void testLexAndQuoting() {
        SqlTester tester1 = this.tester.withLex(Lex.JAVA).withQuoting(Quoting.DOUBLE_QUOTE);
        tester1.checkResultType("select \"x[y] z \" from (\n  select e.EMPNO as \"x[y] z \" from EMP as e)", "RecordType(INTEGER NOT NULL x[y] z ) NOT NULL");
    }

    @Test
    public void testCaseInsensitive() {
        SqlTester tester1 = this.tester.withCaseSensitive(false).withQuoting(Quoting.BRACKET);
        SqlTester tester2 = this.tester.withQuoting(Quoting.BRACKET);
        tester1.checkQuery("select EMPNO from EMP");
        tester1.checkQuery("select empno from emp");
        tester1.checkQuery("select [empno] from [emp]");
        tester1.checkQuery("select [E].[empno] from [emp] as e");
        tester1.checkQuery("select t.[x] from (\n  select [E].[empno] as x from [emp] as e) as [t]");
        tester1.checkQuery("select * from emp as [e] where exists (\nselect 1 from dept where dept.deptno = [E].deptno)");
        tester2.checkQueryFails("select * from emp as [e] where exists (\nselect 1 from dept where dept.deptno = ^[E]^.deptno)", "(?s).*Table 'E' not found; did you mean 'e'\\?");
        this.checkFails("select count(1), ^empno^ from emp", "Expression 'EMPNO' is not being grouped");
    }

    @Test
    public void testCaseInsensitiveTableAlias() {
        SqlTester tester1 = this.tester.withCaseSensitive(false).withQuoting(Quoting.BRACKET);
        SqlTester tester2 = this.tester.withQuoting(Quoting.BRACKET);
        tester1.checkQueryFails("select count(*) from dept as [D], ^dept as [d]^", "Duplicate relation name 'd' in FROM clause");
        tester2.checkQuery("select count(*) from dept as [D], dept as [d]");
        tester2.checkQueryFails("select count(*) from dept as [D], ^dept as [D]^", "Duplicate relation name 'D' in FROM clause");
    }

    @Test
    public void testCaseInsensitiveTableAliasInGroupBy() {
        SqlTester tester1 = this.tester.withCaseSensitive(false).withUnquotedCasing(Casing.UNCHANGED);
        tester1.checkQuery("select deptno, count(*) from EMP AS emp\ngroup by eMp.deptno");
        tester1.checkQuery("select deptno, count(*) from EMP AS EMP\ngroup by eMp.deptno");
        tester1.checkQuery("select deptno, count(*) from EMP\ngroup by eMp.deptno");
        tester1.checkQuery("select * from EMP where exists (\n  select 1 from dept\n  group by eMp.deptno)");
        tester1.checkQuery("select deptno, count(*) from EMP group by DEPTNO");
    }

    @Test
    public void testTableNotFoundDidYouMean() {
        this.tester.checkQueryFails("select * from ^unknownTable^", "Object 'UNKNOWNTABLE' not found");
        this.tester.checkQueryFails("select * from ^\"Emp\"^", "Object 'Emp' not found within 'SALES'; did you mean 'EMP'\\?");
        this.tester.checkQueryFails("select * from ^sales.unknownTable^", "Object 'UNKNOWNTABLE' not found within 'SALES'");
        this.tester.checkQueryFails("select * from ^sales.\"Emp\"^", "Object 'Emp' not found within 'SALES'; did you mean 'EMP'\\?");
        this.tester.checkQueryFails("select * from ^unknownSchema.unknownTable^", "Object 'UNKNOWNSCHEMA' not found");
        this.tester.checkQueryFails("select * from ^\"sales\".emp^", "Object 'sales' not found; did you mean 'SALES'\\?");
        this.tester.checkQueryFails("select * from ^\"saLes\".\"eMp\"^", "Object 'saLes' not found; did you mean 'SALES'\\?");
        this.tester.checkQueryFails("select * from ^emp.foo^", "Object 'FOO' not found within 'SALES\\.EMP'");
        this.tester.checkQueryFails("select * from ^sales.emp.foo^", "Object 'FOO' not found within 'SALES\\.EMP'");
        this.tester.checkQueryFails("select ^aliAs^.\"name\"\nfrom sales.emp as \"Alias\"", "Table 'ALIAS' not found; did you mean 'Alias'\\?");
        this.tester.checkQueryFails("select ^sales.\"emp\"^.\"name\" from sales.emp", "Table 'SALES\\.emp' not found; did you mean 'EMP'\\?");
    }

    @Test
    public void testColumnNotFoundDidYouMean() {
        this.tester.checkQueryFails("select ^\"unknownColumn\"^ from emp", "Column 'unknownColumn' not found in any table");
        this.tester.checkQueryFails("select ^\"empNo\"^ from emp", "Column 'empNo' not found in any table; did you mean 'EMPNO'\\?");
        this.tester.checkQueryFails("select ^\"empNo\"^ from sales.emp", "Column 'empNo' not found in any table; did you mean 'EMPNO'\\?");
        this.tester.checkQueryFails("select ^\"empNo\"^ from catalog.sales.emp", "Column 'empNo' not found in any table; did you mean 'EMPNO'\\?");
        this.tester.checkQueryFails("select e.^\"empNo\"^ from catalog.sales.emp as e", "Column 'empNo' not found in table 'E'; did you mean 'EMPNO'\\?");
        this.tester.checkQueryFails("select catalog.sales.emp.^\"empNo\"^\nfrom catalog.sales.emp", "Column 'empNo' not found in table 'CATALOG\\.SALES\\.EMP'; did you mean 'EMPNO'\\?");
        this.tester.checkQueryFails("select ^\"name\"^ from emp, dept", "Column 'name' not found in any table; did you mean 'NAME'\\?");
        this.tester.checkQueryFails("select ^\"name\"^ from emp,\n  (select * from dept) as d", "Column 'name' not found in any table; did you mean 'NAME'\\?");
        this.tester.checkQueryFails("select ^\"name\"^ from emp, (select * from dept)", "Column 'name' not found in any table; did you mean 'NAME'\\?");
        this.tester.checkQueryFails("select ^\"deptno\"^ from emp,\n  (select deptno as \"deptNo\" from dept)", "Column 'deptno' not found in any table; did you mean 'DEPTNO', 'deptNo'\\?");
        this.tester.checkQueryFails("select ^\"deptno\"^ from emp,\n  (select * from dept) as t(\"deptNo\", name)", "Column 'deptno' not found in any table; did you mean 'DEPTNO', 'deptNo'\\?");
    }

    @Test
    public void testUnquotedBuiltInFunctionNames() {
        SqlTester mysql = this.tester.withUnquotedCasing(Casing.UNCHANGED).withQuoting(Quoting.BACK_TICK).withCaseSensitive(false);
        SqlTester oracle = this.tester.withUnquotedCasing(Casing.TO_UPPER).withCaseSensitive(true);
        oracle.checkQuery("select count(*), sum(deptno), floor(2.5) from dept");
        oracle.checkQuery("select COUNT(*), FLOOR(2.5) from dept");
        oracle.checkQuery("select cOuNt(*), FlOOr(2.5) from dept");
        oracle.checkQuery("select cOuNt (*), FlOOr (2.5) from dept");
        oracle.checkQuery("select current_time from dept");
        oracle.checkQuery("select Current_Time from dept");
        oracle.checkQuery("select CURRENT_TIME from dept");
        mysql.checkQuery("select sum(deptno), floor(2.5) from dept");
        mysql.checkQuery("select count(*), sum(deptno), floor(2.5) from dept");
        mysql.checkQuery("select COUNT(*), FLOOR(2.5) from dept");
        mysql.checkQuery("select cOuNt(*), FlOOr(2.5) from dept");
        mysql.checkQuery("select cOuNt (*), FlOOr (2.5) from dept");
        mysql.checkQuery("select current_time from dept");
        mysql.checkQuery("select Current_Time from dept");
        mysql.checkQuery("select CURRENT_TIME from dept");
        oracle.checkQuery("select \"count\"(*) from dept");
        mysql.checkQuery("select `count`(*) from dept");
    }

    @Test
    public void testStandardOperatorNamesAreUpperCase() {
        block3: for (SqlOperator op : SqlStdOperatorTable.instance().getOperatorList()) {
            String name = op.getName();
            switch (op.getSyntax()) {
                case SPECIAL: 
                case INTERNAL: {
                    continue block3;
                }
            }
            Assert.assertThat((Object)name.toUpperCase(Locale.ROOT), (Matcher)CoreMatchers.equalTo((Object)name));
        }
    }

    private static int prec(SqlOperator op) {
        return Math.max(op.getLeftPrec(), op.getRightPrec());
    }

    @Test
    public void testOperatorsSortedByPrecedence() {
        StringBuilder b = new StringBuilder();
        Comparator<SqlOperator> comparator = new Comparator<SqlOperator>(){

            @Override
            public int compare(SqlOperator o1, SqlOperator o2) {
                int c = Integer.compare(SqlValidatorTest.prec(o1), SqlValidatorTest.prec(o2));
                if (c != 0) {
                    return -c;
                }
                c = o1.getName().compareTo(o2.getName());
                if (c != 0) {
                    return c;
                }
                return o1.getSyntax().compareTo((Enum)o2.getSyntax());
            }
        };
        List operators = SqlStdOperatorTable.instance().getOperatorList();
        int p = -1;
        block6: for (SqlOperator op : Ordering.from((Comparator)comparator).sortedCopy((Iterable)operators)) {
            String type;
            switch (op.getSyntax()) {
                case INTERNAL: 
                case FUNCTION: 
                case FUNCTION_ID: 
                case FUNCTION_STAR: {
                    continue block6;
                }
                case PREFIX: {
                    type = "pre";
                    break;
                }
                case POSTFIX: {
                    type = "post";
                    break;
                }
                case BINARY: {
                    if (op.getLeftPrec() < op.getRightPrec()) {
                        type = "left";
                        break;
                    }
                    type = "right";
                    break;
                }
                default: {
                    if (!(op instanceof SqlSpecialOperator)) continue block6;
                    type = "-";
                }
            }
            if (SqlValidatorTest.prec(op) != p) {
                b.append('\n');
                p = SqlValidatorTest.prec(op);
            }
            b.append(op.getName()).append(' ').append(type).append('\n');
        }
        String expected = "\nARRAY -\nARRAY -\nCOLUMN_LIST -\nCURSOR -\nLATERAL -\nMAP -\nMAP -\nMULTISET -\nMULTISET -\nROW -\nTABLE -\nUNNEST -\n\nCURRENT_VALUE -\nDEFAULT -\nITEM -\nNEXT_VALUE -\nPATTERN_EXCLUDE -\nPATTERN_PERMUTE -\n\nPATTERN_QUANTIFIER -\n\n left\n$LiteralChain -\n+ pre\n- pre\n. left\nFINAL pre\nRUNNING pre\n\n| left\n\n* left\n/ left\n/INT left\n|| left\n\n+ left\n- left\n- -\nDATETIME_PLUS -\nEXISTS pre\n\nBETWEEN ASYMMETRIC -\nBETWEEN SYMMETRIC -\nIN left\nLIKE -\nNOT BETWEEN ASYMMETRIC -\nNOT BETWEEN SYMMETRIC -\nNOT IN left\nNOT LIKE -\nNOT SIMILAR TO -\nSIMILAR TO -\n\n$IS_DIFFERENT_FROM left\n< left\n<= left\n<> left\n= left\n> left\n>= left\nCONTAINS left\nEQUALS left\nIMMEDIATELY PRECEDES left\nIMMEDIATELY SUCCEEDS left\nIS DISTINCT FROM left\nIS NOT DISTINCT FROM left\nMEMBER OF left\nOVERLAPS left\nPRECEDES left\nSUBMULTISET OF left\nSUCCEEDS left\n\nIS A SET post\nIS FALSE post\nIS NOT FALSE post\nIS NOT NULL post\nIS NOT TRUE post\nIS NOT UNKNOWN post\nIS NULL post\nIS TRUE post\nIS UNKNOWN post\n\nNOT pre\n\nAND left\n\nOR left\n\n=> -\nAS -\nDESC post\nOVER left\nTABLESAMPLE -\n\nINTERSECT left\nINTERSECT ALL left\nMULTISET INTERSECT left\nMULTISET INTERSECT ALL left\nNULLS FIRST post\nNULLS LAST post\n\nEXCEPT left\nEXCEPT ALL left\nMULTISET EXCEPT left\nMULTISET EXCEPT ALL left\nMULTISET UNION left\nMULTISET UNION ALL left\nUNION left\nUNION ALL left\n\n$throw -\nEXTRACT_DATE -\nFILTER left\nReinterpret -\nTABLE pre\nVALUES -\n\nCALL pre\nESCAPE -\nNEW pre\n";
        Assert.assertThat((Object)b.toString(), (Matcher)CoreMatchers.is((Object)"\nARRAY -\nARRAY -\nCOLUMN_LIST -\nCURSOR -\nLATERAL -\nMAP -\nMAP -\nMULTISET -\nMULTISET -\nROW -\nTABLE -\nUNNEST -\n\nCURRENT_VALUE -\nDEFAULT -\nITEM -\nNEXT_VALUE -\nPATTERN_EXCLUDE -\nPATTERN_PERMUTE -\n\nPATTERN_QUANTIFIER -\n\n left\n$LiteralChain -\n+ pre\n- pre\n. left\nFINAL pre\nRUNNING pre\n\n| left\n\n* left\n/ left\n/INT left\n|| left\n\n+ left\n- left\n- -\nDATETIME_PLUS -\nEXISTS pre\n\nBETWEEN ASYMMETRIC -\nBETWEEN SYMMETRIC -\nIN left\nLIKE -\nNOT BETWEEN ASYMMETRIC -\nNOT BETWEEN SYMMETRIC -\nNOT IN left\nNOT LIKE -\nNOT SIMILAR TO -\nSIMILAR TO -\n\n$IS_DIFFERENT_FROM left\n< left\n<= left\n<> left\n= left\n> left\n>= left\nCONTAINS left\nEQUALS left\nIMMEDIATELY PRECEDES left\nIMMEDIATELY SUCCEEDS left\nIS DISTINCT FROM left\nIS NOT DISTINCT FROM left\nMEMBER OF left\nOVERLAPS left\nPRECEDES left\nSUBMULTISET OF left\nSUCCEEDS left\n\nIS A SET post\nIS FALSE post\nIS NOT FALSE post\nIS NOT NULL post\nIS NOT TRUE post\nIS NOT UNKNOWN post\nIS NULL post\nIS TRUE post\nIS UNKNOWN post\n\nNOT pre\n\nAND left\n\nOR left\n\n=> -\nAS -\nDESC post\nOVER left\nTABLESAMPLE -\n\nINTERSECT left\nINTERSECT ALL left\nMULTISET INTERSECT left\nMULTISET INTERSECT ALL left\nNULLS FIRST post\nNULLS LAST post\n\nEXCEPT left\nEXCEPT ALL left\nMULTISET EXCEPT left\nMULTISET EXCEPT ALL left\nMULTISET UNION left\nMULTISET UNION ALL left\nUNION left\nUNION ALL left\n\n$throw -\nEXTRACT_DATE -\nFILTER left\nReinterpret -\nTABLE pre\nVALUES -\n\nCALL pre\nESCAPE -\nNEW pre\n"));
    }

    @Test
    public void testCaseInsensitiveInsert() {
        SqlTester tester1 = this.tester.withCaseSensitive(false).withQuoting(Quoting.BRACKET);
        tester1.checkQueryFails("insert into EMP ([EMPNO], deptno, ^[empno]^)\n values (1, 1, 1)", "Target column 'EMPNO' is assigned more than once");
    }

    @Test
    public void testCaseInsensitiveSubQuery() {
        SqlTester insensitive = this.tester.withCaseSensitive(false).withQuoting(Quoting.BRACKET);
        SqlTester sensitive = this.tester.withCaseSensitive(true).withQuoting(Quoting.BRACKET);
        String sql = "select [e] from (\nselect empno as [e], deptno as d, 1 as [e] from EMP)";
        sensitive.checkQuery(sql);
        insensitive.checkQuery(sql);
        String sql1 = "select e from (\nselect empno as [e], deptno as d, 1 as [E] from EMP)";
        insensitive.checkQuery(sql1);
        sensitive.checkQuery(sql1);
    }

    @Test
    public void testCaseInsensitiveTables() {
        SqlTester tester1 = this.tester.withLex(Lex.SQL_SERVER);
        tester1.checkQuery("select eMp.* from (select * from emp) as EmP");
        tester1.checkQueryFails("select ^eMp^.* from (select * from emp as EmP)", "Unknown identifier 'eMp'");
        tester1.checkQuery("select eMp.* from (select * from emP) as EmP");
        tester1.checkQuery("select eMp.empNo from (select * from emP) as EmP");
        tester1.checkQuery("select empNo from (select Empno from emP) as EmP");
        tester1.checkQuery("select empNo from (select Empno from emP)");
    }

    @Test
    public void testInsert() {
        this.tester.checkQuery("insert into empnullables (empno, ename)\nvalues (1, 'Ambrosia')");
        this.tester.checkQuery("insert into empnullables (empno, ename)\nselect 1, 'Ardy' from (values 'a')");
        String sql = "insert into emp\nvalues (1, 'nom', 'job', 0, timestamp '1970-01-01 00:00:00', 1, 1,\n  1, false)";
        this.tester.checkQuery("insert into emp\nvalues (1, 'nom', 'job', 0, timestamp '1970-01-01 00:00:00', 1, 1,\n  1, false)");
        String sql2 = "insert into emp (empno, ename, job, mgr, hiredate,\n  sal, comm, deptno, slacker)\nselect 1, 'nom', 'job', 0, timestamp '1970-01-01 00:00:00',\n  1, 1, 1, false\nfrom (values 'a')";
        this.tester.checkQuery("insert into emp (empno, ename, job, mgr, hiredate,\n  sal, comm, deptno, slacker)\nselect 1, 'nom', 'job', 0, timestamp '1970-01-01 00:00:00',\n  1, 1, 1, false\nfrom (values 'a')");
        this.tester.checkQuery("insert into empnullables (ename, empno, deptno)\nvalues ('Pat', 1, null)");
        String sql3 = "insert into empnullables (\n  empno, ename, job, hiredate)\nvalues (1, 'Jim', 'Baker', timestamp '1970-01-01 00:00:00')";
        this.tester.checkQuery("insert into empnullables (\n  empno, ename, job, hiredate)\nvalues (1, 'Jim', 'Baker', timestamp '1970-01-01 00:00:00')");
        this.tester.checkQuery("insert into empnullables (empno, ename)\nselect 1, 'b' from (values 'a')");
        this.tester.checkQuery("insert into empnullables (empno, ename)\nvalues (1, 'Karl')");
    }

    @Test
    public void testInsertSubset() {
        SqlTester pragmaticTester = this.tester.withConformance((SqlConformance)SqlConformanceEnum.PRAGMATIC_2003);
        String sql1 = "insert into empnullables\nvalues (1, 'nom', 'job', 0, timestamp '1970-01-01 00:00:00')";
        pragmaticTester.checkQuery("insert into empnullables\nvalues (1, 'nom', 'job', 0, timestamp '1970-01-01 00:00:00')");
        String sql2 = "insert into empnullables\nvalues (1, 'nom', null, 0, null)";
        pragmaticTester.checkQuery("insert into empnullables\nvalues (1, 'nom', null, 0, null)");
    }

    @Test
    public void testInsertShouldNotCheckForDefaultValue() {
        int c = MockCatalogReader.CountingFactory.THREAD_CALL_COUNT.get().get();
        SqlTester pragmaticTester = this.tester.withConformance((SqlConformance)SqlConformanceEnum.PRAGMATIC_2003);
        String sql1 = "insert into emp values(1, 'nom', 'job', 0, timestamp '1970-01-01 00:00:00', 1, 1, 1, false)";
        pragmaticTester.checkQuery("insert into emp values(1, 'nom', 'job', 0, timestamp '1970-01-01 00:00:00', 1, 1, 1, false)");
        Assert.assertThat((String)"Should not check for default value if column is in INSERT", (Object)MockCatalogReader.CountingFactory.THREAD_CALL_COUNT.get().get(), (Matcher)CoreMatchers.is((Object)c));
        String sql2 = "insert into emp (empno, ename, job, mgr, hiredate,\n  sal, comm, deptno, slacker)\nvalues(1, 'nom', 'job', 0,\n  timestamp '1970-01-01 00:00:00', 1, 1, 1, false)";
        pragmaticTester.checkQuery("insert into emp (empno, ename, job, mgr, hiredate,\n  sal, comm, deptno, slacker)\nvalues(1, 'nom', 'job', 0,\n  timestamp '1970-01-01 00:00:00', 1, 1, 1, false)");
        Assert.assertThat((String)"Should not check for default value if column is in INSERT", (Object)MockCatalogReader.CountingFactory.THREAD_CALL_COUNT.get().get(), (Matcher)CoreMatchers.is((Object)c));
        String sql3 = "insert into ^emp^ (empno, ename, job, mgr, hiredate,\n  sal, comm, deptno)\nvalues(1, 'nom', 'job', 0,\n  timestamp '1970-01-01 00:00:00', 1, 1, 1)";
        pragmaticTester.checkQueryFails("insert into ^emp^ (empno, ename, job, mgr, hiredate,\n  sal, comm, deptno)\nvalues(1, 'nom', 'job', 0,\n  timestamp '1970-01-01 00:00:00', 1, 1, 1)", "Column 'SLACKER' has no default value and does not allow NULLs");
        Assert.assertThat((String)"Missing non-NULL column generates a call to factory", (Object)MockCatalogReader.CountingFactory.THREAD_CALL_COUNT.get().get(), (Matcher)CoreMatchers.is((Object)(c + 1)));
    }

    @Test
    public void testInsertView() {
        this.tester.checkQuery("insert into empnullables_20 (ename, empno, comm)\nvalues ('Karl', 1, 1)");
    }

    @Test
    public void testInsertSubsetView() {
        SqlTester pragmaticTester = this.tester.withConformance((SqlConformance)SqlConformanceEnum.PRAGMATIC_2003);
        pragmaticTester.checkQuery("insert into empnullables_20\nvalues (1, 'Karl')");
    }

    @Test
    public void testInsertModifiableView() {
        this.tester.checkQuery("insert into EMP_MODIFIABLEVIEW (empno, ename, job)\nvalues (1, 'Arthur', 'clown')");
        this.tester.checkQuery("insert into EMP_MODIFIABLEVIEW2 (empno, ename, job, extra)\nvalues (1, 'Arthur', 'clown', true)");
    }

    @Test
    public void testInsertSubsetModifiableView() {
        SqlTester pragmaticTester = this.tester.withConformance((SqlConformance)SqlConformanceEnum.PRAGMATIC_2003);
        pragmaticTester.checkQuery("insert into EMP_MODIFIABLEVIEW2\nvalues ('Arthur', 1)");
        this.tester.checkQuery("insert into EMP_MODIFIABLEVIEW2\nvalues ('Arthur', 1, 'Knight', 20, false, 99999, true, timestamp '1370-01-01 00:00:00', 1, 100)");
    }

    @Test
    public void testInsertBind() {
        String sql0 = "insert into empnullables (empno, ename, deptno)\nvalues (?, ?, ?)";
        this.sql("insert into empnullables (empno, ename, deptno)\nvalues (?, ?, ?)").ok().bindType("RecordType(INTEGER ?0, VARCHAR(20) ?1, INTEGER ?2)");
        String sql1 = "insert into empnullables (empno, ename, deptno)\nvalues (?, 'Pat', 1), (2, ?, ?), (3, 'Tod', ?), (4, 'Arthur', null)";
        this.sql("insert into empnullables (empno, ename, deptno)\nvalues (?, 'Pat', 1), (2, ?, ?), (3, 'Tod', ?), (4, 'Arthur', null)").ok().bindType("RecordType(INTEGER ?0, VARCHAR(20) ?1, INTEGER ?2, INTEGER ?3)");
        this.sql("insert into empnullables (ename, empno) values (?, ? + 1)").ok().bindType("RecordType(VARCHAR(20) ?0, INTEGER ?1)");
        this.sql("insert into empnullables (ename, empno) select ?, ? from (values (1))").ok().bindType("RecordType(VARCHAR(20) ?0, INTEGER ?1)");
        String sql3 = "insert into empnullables (ename, empno)\nwith v as (values ('a'))\nselect ?, ? from (values (1))";
        this.sql("insert into empnullables (ename, empno)\nwith v as (values ('a'))\nselect ?, ? from (values (1))").ok().bindType("RecordType(VARCHAR(20) ?0, INTEGER ?1)");
        String sql2 = "insert into empnullables (ename, empno)\nselect ?, ? from (values (1))\nunion all\nselect ?, ? from (values (time '1:2:3'))";
        String expected2 = "RecordType(VARCHAR(20) ?0, INTEGER ?1, VARCHAR(20) ?2, INTEGER ?3)";
        this.sql("insert into empnullables (ename, empno)\nselect ?, ? from (values (1))\nunion all\nselect ?, ? from (values (time '1:2:3'))").ok().bindType("RecordType(VARCHAR(20) ?0, INTEGER ?1, VARCHAR(20) ?2, INTEGER ?3)");
    }

    @Test
    public void testInsertBindSubset() {
        SqlTester pragmaticTester = this.tester.withConformance((SqlConformance)SqlConformanceEnum.PRAGMATIC_2003);
        String sql0 = "insert into empnullables \nvalues (?, ?, ?)";
        this.sql("insert into empnullables \nvalues (?, ?, ?)").tester(pragmaticTester).ok().bindType("RecordType(INTEGER ?0, VARCHAR(20) ?1, VARCHAR(10) ?2)");
        String sql1 = "insert into empnullables\nvalues (?, 'Pat', 'Tailor'), (2, ?, ?),\n (3, 'Tod', ?), (4, 'Arthur', null)";
        this.sql("insert into empnullables\nvalues (?, 'Pat', 'Tailor'), (2, ?, ?),\n (3, 'Tod', ?), (4, 'Arthur', null)").tester(pragmaticTester).ok().bindType("RecordType(INTEGER ?0, VARCHAR(20) ?1, VARCHAR(10) ?2, VARCHAR(10) ?3)");
        this.sql("insert into empnullables values (? + 1, ?)").tester(pragmaticTester).ok().bindType("RecordType(INTEGER ?0, VARCHAR(20) ?1)");
        this.sql("insert into empnullables select ?, ? from (values (1))").tester(pragmaticTester).ok().bindType("RecordType(INTEGER ?0, VARCHAR(20) ?1)");
        String sql3 = "insert into empnullables \nwith v as (values ('a'))\nselect ?, ? from (values (1))";
        this.sql("insert into empnullables \nwith v as (values ('a'))\nselect ?, ? from (values (1))").tester(pragmaticTester).ok().bindType("RecordType(INTEGER ?0, VARCHAR(20) ?1)");
        String sql2 = "insert into empnullables \nselect ?, ? from (values (1))\nunion all\nselect ?, ? from (values (time '1:2:3'))";
        String expected2 = "RecordType(INTEGER ?0, VARCHAR(20) ?1, INTEGER ?2, VARCHAR(20) ?3)";
        this.sql("insert into empnullables \nselect ?, ? from (values (1))\nunion all\nselect ?, ? from (values (time '1:2:3'))").tester(pragmaticTester).ok().bindType("RecordType(INTEGER ?0, VARCHAR(20) ?1, INTEGER ?2, VARCHAR(20) ?3)");
    }

    @Test
    public void testInsertBindView() {
        String sql = "insert into EMP_MODIFIABLEVIEW (mgr, empno, ename) values (?, ?, ?)";
        this.sql("insert into EMP_MODIFIABLEVIEW (mgr, empno, ename) values (?, ?, ?)").ok().bindType("RecordType(INTEGER ?0, INTEGER ?1, VARCHAR(20) ?2)");
    }

    @Test
    public void testInsertModifiableViewPassConstraint() {
        this.sql("insert into EMP_MODIFIABLEVIEW2 (deptno, empno, ename, extra) values (20, 100, 'Lex', true)").ok();
        this.sql("insert into EMP_MODIFIABLEVIEW2 (empno, ename, extra) values (100, 'Lex', true)").ok();
        this.sql("insert into EMP_MODIFIABLEVIEW2 values ('Edward', 20)").tester(this.tester.withConformance((SqlConformance)SqlConformanceEnum.PRAGMATIC_2003)).ok();
    }

    @Test
    public void testInsertModifiableViewFailConstraint() {
        this.tester.checkQueryFails("insert into EMP_MODIFIABLEVIEW2 (deptno, empno, ename) values (^21^, 100, 'Lex')", "Modifiable view constraint is not satisfied for column 'DEPTNO' of base table 'EMP_MODIFIABLEVIEW2'");
        this.tester.checkQueryFails("insert into EMP_MODIFIABLEVIEW2 (deptno, empno, ename) values (^19+1^, 100, 'Lex')", "Modifiable view constraint is not satisfied for column 'DEPTNO' of base table 'EMP_MODIFIABLEVIEW2'");
        this.tester.checkQueryFails("insert into EMP_MODIFIABLEVIEW2\nvalues ('Arthur', 1, 'Knight', ^27^, false, 99999, true,timestamp '1370-01-01 00:00:00', 1, 100)", "Modifiable view constraint is not satisfied for column 'DEPTNO' of base table 'EMP_MODIFIABLEVIEW2'");
    }

    @Test
    public void testUpdateModifiableViewPassConstraint() {
        this.sql("update EMP_MODIFIABLEVIEW2 set deptno = 20, empno = 99 where ename = 'Lex'").ok();
        this.sql("update EMP_MODIFIABLEVIEW2 set empno = 99 where ename = 'Lex'").ok();
    }

    @Test
    public void testUpdateModifiableViewFailConstraint() {
        this.tester.checkQueryFails("update EMP_MODIFIABLEVIEW2 set deptno = ^21^, empno = 99 where ename = 'Lex'", "Modifiable view constraint is not satisfied for column 'DEPTNO' of base table 'EMP_MODIFIABLEVIEW2'");
        this.tester.checkQueryFails("update EMP_MODIFIABLEVIEW2 set deptno = ^19 + 1^, empno = 99 where ename = 'Lex'", "Modifiable view constraint is not satisfied for column 'DEPTNO' of base table 'EMP_MODIFIABLEVIEW2'");
    }

    @Test
    public void testInsertFailNullability() {
        this.tester.checkQueryFails("insert into ^empnullables^ (ename) values ('Kevin')", "Column 'EMPNO' has no default value and does not allow NULLs");
        this.tester.checkQueryFails("insert into ^empnullables^ (empno) values (10)", "Column 'ENAME' has no default value and does not allow NULLs");
        this.tester.checkQueryFails("insert into empnullables (empno, ename, deptno) ^values (5, null, 5)^", "Column 'ENAME' has no default value and does not allow NULLs");
    }

    @Test
    public void testInsertSubsetFailNullability() {
        SqlTester pragmaticTester = this.tester.withConformance((SqlConformance)SqlConformanceEnum.PRAGMATIC_2003);
        pragmaticTester.checkQueryFails("insert into ^empnullables^ values (1)", "Column 'ENAME' has no default value and does not allow NULLs");
        pragmaticTester.checkQueryFails("insert into empnullables ^values (null, 'Liam')^", "Column 'EMPNO' has no default value and does not allow NULLs");
        pragmaticTester.checkQueryFails("insert into empnullables ^values (45, null, 5)^", "Column 'ENAME' has no default value and does not allow NULLs");
    }

    @Test
    public void testInsertViewFailNullability() {
        this.tester.checkQueryFails("insert into ^empnullables_20^ (ename) values ('Jake')", "Column 'EMPNO' has no default value and does not allow NULLs");
        this.tester.checkQueryFails("insert into ^empnullables_20^ (empno) values (9)", "Column 'ENAME' has no default value and does not allow NULLs");
        this.tester.checkQueryFails("insert into empnullables_20 (empno, ename, mgr) ^values (5, null, 5)^", "Column 'ENAME' has no default value and does not allow NULLs");
    }

    @Test
    public void testInsertSubsetViewFailNullability() {
        SqlTester pragmaticTester = this.tester.withConformance((SqlConformance)SqlConformanceEnum.PRAGMATIC_2003);
        pragmaticTester.checkQueryFails("insert into ^empnullables_20^ values (1)", "Column 'ENAME' has no default value and does not allow NULLs");
        pragmaticTester.checkQueryFails("insert into empnullables_20 ^values (null, 'Liam')^", "Column 'EMPNO' has no default value and does not allow NULLs");
        pragmaticTester.checkQueryFails("insert into empnullables_20 ^values (45, null)^", "Column 'ENAME' has no default value and does not allow NULLs");
    }

    @Test
    public void testInsertBindFailNullability() {
        this.tester.checkQueryFails("insert into ^emp^ (ename) values (?)", "Column 'EMPNO' has no default value and does not allow NULLs");
        this.tester.checkQueryFails("insert into ^emp^ (empno) values (?)", "Column 'ENAME' has no default value and does not allow NULLs");
        this.tester.checkQueryFails("insert into emp (empno, ename, deptno) ^values (?, null, 5)^", "Column 'ENAME' has no default value and does not allow NULLs");
    }

    @Test
    public void testInsertBindSubsetFailNullability() {
        SqlTester pragmaticTester = this.tester.withConformance((SqlConformance)SqlConformanceEnum.PRAGMATIC_2003);
        pragmaticTester.checkQueryFails("insert into ^empnullables^ values (?)", "Column 'ENAME' has no default value and does not allow NULLs");
        pragmaticTester.checkQueryFails("insert into empnullables ^values (null, ?)^", "Column 'EMPNO' has no default value and does not allow NULLs");
        pragmaticTester.checkQueryFails("insert into empnullables ^values (?, null)^", "Column 'ENAME' has no default value and does not allow NULLs");
    }

    @Test
    public void testInsertSubsetDisallowed() {
        this.tester.checkQueryFails("insert into ^emp^ values (1)", "Number of INSERT target columns \\(9\\) does not equal number of source items \\(1\\)");
        this.tester.checkQueryFails("insert into ^emp^ values (null)", "Number of INSERT target columns \\(9\\) does not equal number of source items \\(1\\)");
        this.tester.checkQueryFails("insert into ^emp^ values (1, 'Kevin')", "Number of INSERT target columns \\(9\\) does not equal number of source items \\(2\\)");
    }

    @Test
    public void testInsertSubsetViewDisallowed() {
        this.tester.checkQueryFails("insert into ^emp_20^ values (1)", "Number of INSERT target columns \\(8\\) does not equal number of source items \\(1\\)");
        this.tester.checkQueryFails("insert into ^emp_20^ values (null)", "Number of INSERT target columns \\(8\\) does not equal number of source items \\(1\\)");
        this.tester.checkQueryFails("insert into ^emp_20^ values (?, ?)", "Number of INSERT target columns \\(8\\) does not equal number of source items \\(2\\)");
    }

    @Test
    public void testInsertBindSubsetDisallowed() {
        this.tester.checkQueryFails("insert into ^emp^ values (?)", "Number of INSERT target columns \\(9\\) does not equal number of source items \\(1\\)");
        this.tester.checkQueryFails("insert into ^emp^ values (?, ?)", "Number of INSERT target columns \\(9\\) does not equal number of source items \\(2\\)");
    }

    @Test
    public void testSelectExtendedColumnDuplicate() {
        this.sql("select deptno, extra from emp (extra int, \"extra\" boolean)").ok();
        this.sql("select deptno, extra from emp (extra int, \"extra\" int)").ok();
        this.tester.checkQueryFails("select deptno, extra from emp (extra int, ^extra^ int)", "Duplicate name 'EXTRA' in column list");
        this.tester.checkQueryFails("select deptno, extra from emp (extra int, ^extra^ boolean)", "Duplicate name 'EXTRA' in column list");
        this.tester.checkQueryFails("select deptno, extra from EMP_MODIFIABLEVIEW (extra int, ^extra^ int)", "Duplicate name 'EXTRA' in column list");
        this.tester.checkQueryFails("select deptno, extra from EMP_MODIFIABLEVIEW (extra int, ^extra^ boolean)", "Duplicate name 'EXTRA' in column list");
    }

    @Test
    public void testSelectViewFailExcludedColumn() {
        this.tester.checkQueryFails("select ^deptno^, empno from EMP_MODIFIABLEVIEW", "Column 'DEPTNO' not found in any table");
    }

    @Test
    public void testSelectViewExtendedColumnCollision() {
        this.sql("select ENAME, EMPNO, JOB, SLACKER, SAL, HIREDATE, MGR\n from EMP_MODIFIABLEVIEW3 extend (SAL int)\n where SAL = 20").ok();
        this.sql("select ENAME, EMPNO, JOB, SLACKER, SAL, \"Sal\", HIREDATE, MGR\n from EMP_MODIFIABLEVIEW3 extend (\"Sal\" VARCHAR)\n where SAL = 20").ok();
    }

    @Test
    public void testSelectViewExtendedColumnExtendedCollision() {
        this.sql("select ENAME, EMPNO, JOB, SLACKER, SAL, HIREDATE, MGR, EXTRA\n from EMP_MODIFIABLEVIEW2 extend (EXTRA boolean)\n where SAL = 20").ok();
        this.sql("select ENAME, EMPNO, JOB, SLACKER, SAL, HIREDATE, MGR, EXTRA, \"EXtra\"\n from EMP_MODIFIABLEVIEW2 extend (\"EXtra\" VARCHAR)\n where SAL = 20").ok();
    }

    @Test
    public void testSelectViewExtendedColumnUnderlyingCollision() {
        this.sql("select ENAME, EMPNO, JOB, SLACKER, SAL, HIREDATE, MGR, COMM\n from EMP_MODIFIABLEVIEW3 extend (COMM int)\n where SAL = 20").ok();
        this.sql("select ENAME, EMPNO, JOB, SLACKER, SAL, HIREDATE, MGR, \"comM\"\n from EMP_MODIFIABLEVIEW3 extend (\"comM\" BOOLEAN)\n where SAL = 20").ok();
    }

    @Test
    public void testSelectExtendedColumnCollision() {
        this.sql("select ENAME, EMPNO, JOB, SLACKER, SAL, HIREDATE, MGR, COMM\n from EMPDEFAULTS extend (COMM int)\n where SAL = 20").ok();
        this.sql("select ENAME, EMPNO, JOB, SLACKER, SAL, HIREDATE, MGR, COMM, \"ComM\"\n from EMPDEFAULTS extend (\"ComM\" int)\n where SAL = 20").ok();
    }

    @Test
    public void testSelectExtendedColumnFailCollision() {
        this.tester.checkQueryFails("select ENAME, EMPNO, JOB, SLACKER, SAL, HIREDATE, MGR, COMM\n from EMPDEFAULTS extend (^COMM^ boolean)\n where SAL = 20", "Cannot assign to target field 'COMM' of type INTEGER from source field 'COMM' of type BOOLEAN");
        this.tester.checkQueryFails("select ENAME, EMPNO, JOB, SLACKER, SAL, HIREDATE, MGR, COMM\n from EMPDEFAULTS extend (^EMPNO^ integer)\n where SAL = 20", "Cannot assign to target field 'EMPNO' of type INTEGER NOT NULL from source field 'EMPNO' of type INTEGER");
        this.tester.checkQueryFails("select ENAME, EMPNO, JOB, SLACKER, SAL, HIREDATE, MGR, COMM\n from EMPDEFAULTS extend (^\"EMPNO\"^ integer)\n where SAL = 20", "Cannot assign to target field 'EMPNO' of type INTEGER NOT NULL from source field 'EMPNO' of type INTEGER");
    }

    @Test
    public void testSelectViewExtendedColumnFailCollision() {
        this.tester.checkQueryFails("select ENAME, EMPNO, JOB, SLACKER, SAL, HIREDATE, MGR, EXTRA\n from EMP_MODIFIABLEVIEW2 extend (^SLACKER^ integer)\n where SAL = 20", "Cannot assign to target field 'SLACKER' of type BOOLEAN from source field 'SLACKER' of type INTEGER");
        this.tester.checkQueryFails("select ENAME, EMPNO, JOB, SLACKER, SAL, HIREDATE, MGR, COMM\n from EMP_MODIFIABLEVIEW2 extend (^EMPNO^ integer)\n where SAL = 20", "Cannot assign to target field 'EMPNO' of type INTEGER NOT NULL from source field 'EMPNO' of type INTEGER");
    }

    @Test
    public void testSelectViewExtendedColumnFailExtendedCollision() {
        this.tester.checkQueryFails("select ENAME, EMPNO, JOB, SLACKER, SAL, HIREDATE, MGR, EXTRA\n from EMP_MODIFIABLEVIEW2 extend (^EXTRA^ integer)\n where SAL = 20", "Cannot assign to target field 'EXTRA' of type BOOLEAN from source field 'EXTRA' of type INTEGER");
        this.tester.checkQueryFails("select ENAME, EMPNO, JOB, SLACKER, SAL, HIREDATE, MGR, EXTRA\n from EMP_MODIFIABLEVIEW2 extend (^\"EXTRA\"^ integer)\n where SAL = 20", "Cannot assign to target field 'EXTRA' of type BOOLEAN from source field 'EXTRA' of type INTEGER");
    }

    @Test
    public void testSelectViewExtendedColumnFailUnderlyingCollision() {
        this.tester.checkQueryFails("select ENAME, EMPNO, JOB, SLACKER, SAL, HIREDATE, MGR, COMM\n from EMP_MODIFIABLEVIEW3 extend (^COMM^ boolean)\n where SAL = 20", "Cannot assign to target field 'COMM' of type INTEGER from source field 'COMM' of type BOOLEAN");
        this.tester.checkQueryFails("select ENAME, EMPNO, JOB, SLACKER, SAL, HIREDATE, MGR, COMM\n from EMP_MODIFIABLEVIEW3 extend (^\"COMM\"^ boolean)\n where SAL = 20", "Cannot assign to target field 'COMM' of type INTEGER from source field 'COMM' of type BOOLEAN");
    }

    @Test
    public void testSelectFailCaseSensitivity() {
        this.tester.checkQueryFails("select ^\"empno\"^, ename, deptno from EMP", "Column 'empno' not found in any table; did you mean 'EMPNO'\\?");
        this.tester.checkQueryFails("select ^\"extra\"^, ename, deptno from EMP (extra boolean)", "Column 'extra' not found in any table; did you mean 'EXTRA'\\?");
        this.tester.checkQueryFails("select ^extra^, ename, deptno from EMP (\"extra\" boolean)", "Column 'EXTRA' not found in any table; did you mean 'extra'\\?");
    }

    @Test
    public void testInsertFailCaseSensitivity() {
        this.tester.checkQueryFails("insert into EMP_MODIFIABLEVIEW (^\"empno\"^, ename, deptno) values (45, 'Jake', 5)", "Unknown target column 'empno'");
        this.tester.checkQueryFails("insert into EMP_MODIFIABLEVIEW (\"extra\" int) (^extra^, ename, deptno) values (45, 'Jake', 5)", "Unknown target column 'EXTRA'");
        this.tester.checkQueryFails("insert into EMP_MODIFIABLEVIEW (extra int) (^\"extra\"^, ename, deptno) values (45, 'Jake', 5)", "Unknown target column 'extra'");
    }

    @Test
    public void testInsertFailExcludedColumn() {
        this.tester.checkQueryFails("insert into EMP_MODIFIABLEVIEW (empno, ename, ^deptno^) values (45, 'Jake', 5)", "Unknown target column 'DEPTNO'");
    }

    @Test
    public void testInsertBindViewFailExcludedColumn() {
        String sql = "insert into EMP_MODIFIABLEVIEW (empno, ename, ^deptno^) values (?, ?, ?)";
        this.tester.checkQueryFails("insert into EMP_MODIFIABLEVIEW (empno, ename, ^deptno^) values (?, ?, ?)", "Unknown target column 'DEPTNO'");
    }

    @Test
    public void testInsertWithCustomInitializerExpressionFactory() {
        this.tester.checkQuery("insert into empdefaults (deptno) values (1)");
        this.tester.checkQuery("insert into empdefaults (ename, empno) values ('Quan', 50)");
        this.tester.checkQueryFails("insert into empdefaults (ename, deptno) ^values (null, 1)^", "Column 'ENAME' has no default value and does not allow NULLs");
        this.tester.checkQueryFails("insert into ^empdefaults^ values (null, 'Tod')", "Number of INSERT target columns \\(9\\) does not equal number of source items \\(2\\)");
    }

    @Test
    public void testInsertSubsetWithCustomInitializerExpressionFactory() {
        SqlTester pragmaticTester = this.tester.withConformance((SqlConformance)SqlConformanceEnum.PRAGMATIC_2003);
        pragmaticTester.checkQuery("insert into empdefaults values (101)");
        pragmaticTester.checkQuery("insert into empdefaults values (101, 'Coral')");
        pragmaticTester.checkQueryFails("insert into empdefaults ^values (null, 'Tod')^", "Column 'EMPNO' has no default value and does not allow NULLs");
        pragmaticTester.checkQueryFails("insert into empdefaults ^values (78, null)^", "Column 'ENAME' has no default value and does not allow NULLs");
    }

    @Test
    public void testInsertBindWithCustomInitializerExpressionFactory() {
        this.sql("insert into empdefaults (deptno) values (?)").ok().bindType("RecordType(INTEGER ?0)");
        this.sql("insert into empdefaults (ename, empno) values (?, ?)").ok().bindType("RecordType(VARCHAR(20) ?0, INTEGER ?1)");
        this.tester.checkQueryFails("insert into empdefaults (ename, deptno) ^values (null, ?)^", "Column 'ENAME' has no default value and does not allow NULLs");
        this.tester.checkQueryFails("insert into ^empdefaults^ values (null, ?)", "Number of INSERT target columns \\(9\\) does not equal number of source items \\(2\\)");
    }

    @Test
    public void testInsertBindSubsetWithCustomInitializerExpressionFactory() {
        SqlTester pragmaticTester = this.tester.withConformance((SqlConformance)SqlConformanceEnum.PRAGMATIC_2003);
        this.sql("insert into empdefaults values (101, ?)").tester(pragmaticTester).ok().bindType("RecordType(VARCHAR(20) ?0)");
        pragmaticTester.checkQueryFails("insert into empdefaults ^values (null, ?)^", "Column 'EMPNO' has no default value and does not allow NULLs");
    }

    @Test
    public void testInsertBindWithCustomColumnResolving() {
        SqlTester pragmaticTester = this.tester.withConformance((SqlConformance)SqlConformanceEnum.PRAGMATIC_2003);
        String sql = "insert into struct.t\nvalues (?, ?, ?, ?, ?, ?, ?, ?, ?)";
        String expected = "RecordType(VARCHAR(20) ?0, VARCHAR(20) ?1, INTEGER ?2, BOOLEAN ?3, INTEGER ?4, INTEGER ?5, INTEGER ?6, INTEGER ?7, INTEGER ?8)";
        this.sql("insert into struct.t\nvalues (?, ?, ?, ?, ?, ?, ?, ?, ?)").ok().bindType("RecordType(VARCHAR(20) ?0, VARCHAR(20) ?1, INTEGER ?2, BOOLEAN ?3, INTEGER ?4, INTEGER ?5, INTEGER ?6, INTEGER ?7, INTEGER ?8)");
        String sql2 = "insert into struct.t_nullables (c0, c2, c1) values (?, ?, ?)";
        String expected2 = "RecordType(INTEGER ?0, INTEGER ?1, VARCHAR(20) ?2)";
        this.sql("insert into struct.t_nullables (c0, c2, c1) values (?, ?, ?)").tester(pragmaticTester).ok().bindType("RecordType(INTEGER ?0, INTEGER ?1, VARCHAR(20) ?2)");
        String sql3 = "insert into struct.t_nullables (f1.c0, f1.c2, f0.c1) values (?, ?, ?)";
        String expected3 = "RecordType(INTEGER ?0, INTEGER ?1, INTEGER ?2)";
        this.sql("insert into struct.t_nullables (f1.c0, f1.c2, f0.c1) values (?, ?, ?)").tester(pragmaticTester).ok().bindType("RecordType(INTEGER ?0, INTEGER ?1, INTEGER ?2)");
        this.sql("insert into struct.t_nullables (c0, ^c4^, c1) values (?, ?, ?)").tester(pragmaticTester).fails("Unknown target column 'C4'");
        this.sql("insert into struct.t_nullables (^a0^, c2, c1) values (?, ?, ?)").tester(pragmaticTester).fails("Unknown target column 'A0'");
        String sql4 = "insert into struct.t_nullables (\n  f1.c0, ^f0.a0^, f0.c1) values (?, ?, ?)";
        this.sql("insert into struct.t_nullables (\n  f1.c0, ^f0.a0^, f0.c1) values (?, ?, ?)").tester(pragmaticTester).fails("Unknown target column 'F0.A0'");
        String sql5 = "insert into struct.t_nullables (\n  f1.c0, f1.c2, ^f1.c0^) values (?, ?, ?)";
        this.sql("insert into struct.t_nullables (\n  f1.c0, f1.c2, ^f1.c0^) values (?, ?, ?)").tester(pragmaticTester).fails("Target column '\"F1\".\"C0\"' is assigned more than once");
    }

    @Test
    public void testUpdateBind() {
        String sql = "update emp\nset ename = ?\nwhere deptno = ?";
        this.sql("update emp\nset ename = ?\nwhere deptno = ?").ok().bindType("RecordType(VARCHAR(20) ?0, INTEGER ?1)");
    }

    @Test
    public void testDeleteBind() {
        String sql = "delete from emp\nwhere deptno = ?\nor ename = ?";
        this.sql("delete from emp\nwhere deptno = ?\nor ename = ?").ok().bindType("RecordType(INTEGER ?0, VARCHAR(20) ?1)");
    }

    @Test
    public void testStream() {
        this.sql("select stream * from orders").ok();
        this.sql("select stream * from ^emp^").fails(SqlValidatorTest.cannotConvertToStream("EMP"));
        this.sql("select * from ^orders^").fails(SqlValidatorTest.cannotConvertToRelation("ORDERS"));
    }

    @Test
    public void testStreamWhere() {
        this.sql("select stream * from orders where productId < 10").ok();
        this.sql("select stream * from ^emp^ where deptno = 10").fails(SqlValidatorTest.cannotConvertToStream("EMP"));
        this.sql("select stream * from ^emp^ as e where deptno = 10").fails(SqlValidatorTest.cannotConvertToStream("E"));
        this.sql("select stream * from (^select * from emp as e1^) as e\nwhere deptno = 10").fails("Cannot convert table 'E' to stream");
        this.sql("select * from ^orders^ where productId > 10").fails(SqlValidatorTest.cannotConvertToRelation("ORDERS"));
    }

    @Test
    public void testStreamGroupBy() {
        this.sql("select stream rowtime, productId, count(*) as c\nfrom orders\ngroup by productId, rowtime").ok();
        this.sql("select stream floor(rowtime to hour) as rowtime, productId,\n count(*) as c\nfrom orders\ngroup by floor(rowtime to hour), productId").ok();
        this.sql("select stream productId, count(*) as c\nfrom orders\n^group by productId^").fails(STR_AGG_REQUIRES_MONO);
        this.sql("select stream ^count(*)^ as c\nfrom orders").fails(STR_AGG_REQUIRES_MONO);
        this.sql("select stream count(*) as c\nfrom orders ^group by ()^").fails(STR_AGG_REQUIRES_MONO);
    }

    @Test
    public void testStreamHaving() {
        this.sql("select stream rowtime, productId, count(*) as c\nfrom orders\ngroup by productId, rowtime\nhaving count(*) > 5").ok();
        this.sql("select stream floor(rowtime to hour) as rowtime, productId,\n count(*) as c\nfrom orders\ngroup by floor(rowtime to hour), productId\nhaving false").ok();
        this.sql("select stream productId, count(*) as c\nfrom orders\n^group by productId^\nhaving count(*) > 5").fails(STR_AGG_REQUIRES_MONO);
        this.sql("select stream 1\nfrom orders\nhaving ^count(*) > 3^").fails(STR_AGG_REQUIRES_MONO);
    }

    @Test
    public void testMonotonic() {
        this.sql("select stream floor(rowtime to hour) from orders").monotonic(SqlMonotonicity.INCREASING);
        this.sql("select stream ceil(rowtime to minute) from orders").monotonic(SqlMonotonicity.INCREASING);
        this.sql("select stream extract(minute from rowtime) from orders").monotonic(SqlMonotonicity.NOT_MONOTONIC);
        this.sql("select stream (rowtime - timestamp '1970-01-01 00:00:00') hour from orders").monotonic(SqlMonotonicity.INCREASING);
        this.sql("select stream\ncast((rowtime - timestamp '1970-01-01 00:00:00') hour as integer)\nfrom orders").monotonic(SqlMonotonicity.INCREASING);
        this.sql("select stream\ncast((rowtime - timestamp '1970-01-01 00:00:00') hour as integer) / 15\nfrom orders").monotonic(SqlMonotonicity.INCREASING);
        this.sql("select stream\nmod(cast((rowtime - timestamp '1970-01-01 00:00:00') hour as integer), 15)\nfrom orders").monotonic(SqlMonotonicity.NOT_MONOTONIC);
        this.sql("select stream 1 - 2 from orders").monotonic(SqlMonotonicity.CONSTANT);
        this.sql("select stream 1 + 2 from orders").monotonic(SqlMonotonicity.CONSTANT);
        this.sql("select stream extract(year from rowtime) from orders").monotonic(SqlMonotonicity.INCREASING);
        this.sql("select stream extract(month from rowtime) from orders").monotonic(SqlMonotonicity.NOT_MONOTONIC);
        this.sql("select stream extract(year from rowtime) - 3 from orders").monotonic(SqlMonotonicity.INCREASING);
        this.sql("select stream extract(year from rowtime) * 5 from orders").monotonic(SqlMonotonicity.INCREASING);
        this.sql("select stream extract(year from rowtime) * -5 from orders").monotonic(SqlMonotonicity.DECREASING);
        this.sql("select stream extract(year from rowtime) / -5 from orders").monotonic(SqlMonotonicity.DECREASING);
        this.sql("select stream extract(year from rowtime) / 5 from orders").monotonic(SqlMonotonicity.INCREASING);
        this.sql("select stream extract(year from rowtime) / 0 from orders").monotonic(SqlMonotonicity.CONSTANT);
        this.sql("select stream 5 / extract(year from rowtime) from orders").monotonic(SqlMonotonicity.NOT_MONOTONIC);
        this.sql("select stream extract(year from rowtime) * -5 from orders").monotonic(SqlMonotonicity.DECREASING);
        this.sql("select stream extract(year from rowtime) * 5 from orders").monotonic(SqlMonotonicity.INCREASING);
        this.sql("select stream extract(year from rowtime) * 0 from orders").monotonic(SqlMonotonicity.CONSTANT);
        this.sql("select stream -5 * extract(year from rowtime) from orders").monotonic(SqlMonotonicity.DECREASING);
        this.sql("select stream 5 * extract(year from rowtime) from orders").monotonic(SqlMonotonicity.INCREASING);
        this.sql("select stream 0 * extract(year from rowtime) from orders").monotonic(SqlMonotonicity.CONSTANT);
        this.sql("select stream\nextract(year from rowtime) - extract(year from rowtime)\nfrom orders").monotonic(SqlMonotonicity.NOT_MONOTONIC);
        this.sql("select stream\nextract(year from rowtime) + extract(year from rowtime)\nfrom orders").monotonic(SqlMonotonicity.INCREASING);
    }

    @Test
    public void testStreamUnionAll() {
        this.sql("select orderId\nfrom ^orders^\nunion all\nselect orderId\nfrom shipments").fails(SqlValidatorTest.cannotConvertToRelation("ORDERS"));
        this.sql("select stream orderId\nfrom orders\nunion all\n^select orderId\nfrom shipments^").fails(STR_SET_OP_INCONSISTENT);
        this.sql("select empno\nfrom emp\nunion all\n^select stream orderId\nfrom orders^").fails(STR_SET_OP_INCONSISTENT);
        this.sql("select stream orderId\nfrom orders\nunion all\nselect stream orderId\nfrom shipments").ok();
        this.sql("select stream rowtime, orderId\nfrom orders\nunion all\nselect stream rowtime, orderId\nfrom shipments\norder by rowtime").ok();
    }

    @Test
    public void testStreamValues() {
        this.sql("select stream * from (^values 1^) as e").fails(SqlValidatorTest.cannotConvertToStream("E"));
        this.sql("select stream orderId from orders\nunion all\n^values 1^").fails(STR_SET_OP_INCONSISTENT);
        this.sql("values 1, 2\nunion all\n^select stream orderId from orders^\n").fails(STR_SET_OP_INCONSISTENT);
    }

    @Test
    public void testStreamOrderBy() {
        this.sql("select stream *\nfrom orders\norder by rowtime").ok();
        this.sql("select stream *\nfrom orders\norder by floor(rowtime to hour)").ok();
        this.sql("select stream floor(rowtime to minute), productId\nfrom orders\norder by floor(rowtime to hour)").ok();
        this.sql("select stream floor(rowtime to minute), productId\nfrom orders\norder by floor(rowtime to minute), productId desc").ok();
        this.sql("select stream *\nfrom orders\norder by ^productId^, rowtime").fails(STR_ORDER_REQUIRES_MONO);
        this.sql("select stream *\nfrom orders\norder by ^rowtime desc^").fails(STR_ORDER_REQUIRES_MONO);
        this.sql("select stream *\nfrom orders\norder by floor(rowtime to hour), rowtime desc").ok();
    }

    @Test
    public void testStreamJoin() {
        this.sql("select stream \norders.rowtime as rowtime, orders.orderId as orderId, products.supplierId as supplierId \nfrom orders join products on orders.productId = products.productId").ok();
        this.sql("^select stream *\nfrom products join suppliers on products.supplierId = suppliers.supplierId^").fails(SqlValidatorTest.cannotStreamResultsForNonStreamingInputs("PRODUCTS, SUPPLIERS"));
    }

    @Test
    public void testDummy() {
    }

    @Test
    public void testCustomColumnResolving() {
        this.checkCustomColumnResolving("T");
    }

    @Test
    public void testCustomColumnResolvingWithView() {
        this.checkCustomColumnResolving("T_10");
    }

    private void checkCustomColumnResolving(String table) {
        this.sql("select * from struct." + table).ok();
        this.sql("select k0 from struct." + table).type("RecordType(VARCHAR(20) NOT NULL K0) NOT NULL");
        this.sql("select c2 from struct." + table).type("RecordType(INTEGER NOT NULL C2) NOT NULL");
        this.sql("select f1.c2 from struct." + table).type("RecordType(INTEGER NOT NULL C2) NOT NULL");
        this.sql("select c1 from struct." + table).type("RecordType(VARCHAR(20) NOT NULL C1) NOT NULL");
        this.sql("select c0 from struct." + table).type("RecordType(INTEGER NOT NULL C0) NOT NULL");
        this.sql("select f1.c0 from struct." + table).type("RecordType(INTEGER C0) NOT NULL");
        this.sql("select ^a0^ from struct." + table).fails("Column 'A0' is ambiguous");
        this.sql("select f2.a0 from struct." + table).type("RecordType(BOOLEAN NOT NULL A0) NOT NULL");
        this.sql("select t0.k0 from struct." + table + " t0").type("RecordType(VARCHAR(20) NOT NULL K0) NOT NULL");
        this.sql("select t0.c2 from struct." + table + " t0").type("RecordType(INTEGER NOT NULL C2) NOT NULL");
        this.sql("select f0.c2 from struct." + table + " f0").type("RecordType(INTEGER NOT NULL C2) NOT NULL");
        this.sql("select f0.c1 from struct." + table + " f0").type("RecordType(VARCHAR(20) NOT NULL C1) NOT NULL");
        this.sql("select f0.f0.c1 from struct." + table + " f0").type("RecordType(INTEGER NOT NULL C1) NOT NULL");
        this.sql("select " + table + ".c1 from struct." + table).type("RecordType(VARCHAR(20) NOT NULL C1) NOT NULL");
        this.sql("select ^" + table + "^.c1 from struct." + table + " f0").fails("Table '" + table + "' not found");
        this.sql("select struct." + table + ".c1 from struct." + table).type("RecordType(VARCHAR(20) NOT NULL C1) NOT NULL");
        this.sql("select ^struct." + table + "^.c1 from struct." + table + " f0").fails("Table 'STRUCT." + table + "' not found");
        this.sql("select f0.f0.c1 from struct." + table + " f0").type("RecordType(INTEGER NOT NULL C1) NOT NULL");
        this.sql("select " + table + ".f0.c1 from struct." + table).type("RecordType(INTEGER NOT NULL C1) NOT NULL");
        this.sql("select ^" + table + ".f0^.c1 from struct." + table + " f0").fails("Table '" + table + ".F0' not found");
        this.sql("select struct." + table + ".f0.c1 from struct." + table).type("RecordType(INTEGER NOT NULL C1) NOT NULL");
        this.sql("select ^struct." + table + ".f0^.c1 from struct." + table + " f0").fails("Table 'STRUCT." + table + ".F0' not found");
        this.sql("select f1.* from struct." + table).type("RecordType(INTEGER NOT NULL A0, INTEGER C0, INTEGER NOT NULL C2) NOT NULL");
        this.sql("select " + table + ".f1.* from struct." + table).type("RecordType(INTEGER NOT NULL A0, INTEGER C0, INTEGER NOT NULL C2) NOT NULL");
        this.sql("select ^b0^ from struct." + table).fails("Column 'B0' not found in any table");
        this.sql("select ^f1^ from struct." + table).fails("Column 'F1' not found in any table");
        this.sql("select " + table + ".^f0.notFound^.a.b.c.d from struct." + table).fails("Column 'F0\\.NOTFOUND' not found in table '" + table + "'");
        this.sql("select " + table + ".^f0.notFound^ from struct." + table).fails("Column 'F0\\.NOTFOUND' not found in table '" + table + "'");
        this.sql("select " + table + ".^f0.c1.notFound^ from struct." + table).fails("Column 'F0\\.C1\\.NOTFOUND' not found in table '" + table + "'");
    }

    @Test
    public void testAmbiguousDynamicStar() throws Exception {
        String sql = "select ^n_nation^\nfrom (select * from \"DYNAMIC\".NATION),\n (select * from \"DYNAMIC\".CUSTOMER)";
        this.sql("select ^n_nation^\nfrom (select * from \"DYNAMIC\".NATION),\n (select * from \"DYNAMIC\".CUSTOMER)").fails("Column 'N_NATION' is ambiguous");
    }

    @Test
    public void testAmbiguousDynamicStar2() throws Exception {
        String sql = "select ^n_nation^\nfrom (select * from \"DYNAMIC\".NATION, \"DYNAMIC\".CUSTOMER)";
        this.sql("select ^n_nation^\nfrom (select * from \"DYNAMIC\".NATION, \"DYNAMIC\".CUSTOMER)").fails("Column 'N_NATION' is ambiguous");
    }

    @Test
    public void testAmbiguousDynamicStar3() throws Exception {
        String sql = "select ^nc.n_nation^\nfrom (select * from \"DYNAMIC\".NATION, \"DYNAMIC\".CUSTOMER) as nc";
        this.sql("select ^nc.n_nation^\nfrom (select * from \"DYNAMIC\".NATION, \"DYNAMIC\".CUSTOMER) as nc").fails("Column 'N_NATION' is ambiguous");
    }

    @Test
    public void testAmbiguousDynamicStar4() throws Exception {
        String sql = "select n.n_nation\nfrom (select * from \"DYNAMIC\".NATION) as n,\n (select * from \"DYNAMIC\".CUSTOMER)";
        this.sql("select n.n_nation\nfrom (select * from \"DYNAMIC\".NATION) as n,\n (select * from \"DYNAMIC\".CUSTOMER)").type("RecordType(ANY N_NATION) NOT NULL");
    }

    @Test
    public void testDynamicStar2() throws Exception {
        String sql = "select newid from (\n  select *, NATION.N_NATION + 100 as newid\n  from \"DYNAMIC\".NATION, \"DYNAMIC\".CUSTOMER)";
        this.sql("select newid from (\n  select *, NATION.N_NATION + 100 as newid\n  from \"DYNAMIC\".NATION, \"DYNAMIC\".CUSTOMER)").type("RecordType(ANY NEWID) NOT NULL");
    }

    @Test
    public void testStreamTumble() {
        this.sql("select stream tumble_end(rowtime, interval '2' hour) as rowtime\nfrom orders\ngroup by tumble(rowtime, interval '2' hour), productId").ok();
        this.sql("select stream ^tumble(rowtime, interval '2' hour)^ as rowtime\nfrom orders\ngroup by tumble(rowtime, interval '2' hour), productId").fails("Group function 'TUMBLE' can only appear in GROUP BY clause");
        this.sql("select stream\n  tumble_end(rowtime, interval '2' hour, time '00:12:00') as rowtime\nfrom orders\ngroup by tumble(rowtime, interval '2' hour, time '00:12:00')").ok();
        this.sql("select stream\n  ^tumble_end(rowtime, interval '2' hour, time '00:13:00')^ as rowtime\nfrom orders\ngroup by floor(rowtime to hour)").fails("Call to auxiliary group function 'TUMBLE_END' must have matching call to group function 'TUMBLE' in GROUP BY clause");
        this.sql("select stream\n  ^tumble_start(rowtime, interval '2' hour, time '00:13:00')^ as rowtime\nfrom orders\ngroup by tumble(rowtime, interval '2' hour, time '00:12:00')").fails("Call to auxiliary group function 'TUMBLE_START' must have matching call to group function 'TUMBLE' in GROUP BY clause");
        this.sql("select stream\n  ^tumble_end(rowtime, interval '2' hour, time '00:00:00')^ as rowtime\nfrom orders\ngroup by tumble(rowtime, interval '2' hour)").fails("Call to auxiliary group function 'TUMBLE_END' must have matching call to group function 'TUMBLE' in GROUP BY clause");
        this.sql("select stream productId\nfrom orders\ngroup by tumble(rowtime, interval '2' hour), productId").ok();
        this.sql("select stream productId\nfrom orders\n^group by productId,\n  tumble(timestamp '1990-03-04 12:34:56', interval '2' hour)^").fails(STR_AGG_REQUIRES_MONO);
    }

    @Test
    public void testStreamHop() {
        this.sql("select stream\n  hop_start(rowtime, interval '1' hour, interval '3' hour) as rowtime,\n  count(*) as c\nfrom orders\ngroup by hop(rowtime, interval '1' hour, interval '3' hour)").ok();
        this.sql("select stream\n  ^hop_start(rowtime, interval '1' hour, interval '2' hour)^,\n  count(*) as c\nfrom orders\ngroup by hop(rowtime, interval '1' hour, interval '3' hour)").fails("Call to auxiliary group function 'HOP_START' must have matching call to group function 'HOP' in GROUP BY clause");
        this.sql("select stream\n  hop_start(rowtime, interval '1' hour, interval '3' hour,\n    time '12:34:56') as rowtime,\n  count(*) as c\nfrom orders\ngroup by hop(rowtime, interval '1' hour, interval '3' hour,\n    time '12:34:56')").ok();
    }

    @Test
    public void testStreamSession() {
        this.sql("select stream session_start(rowtime, interval '1' hour) as rowtime,\n  session_end(rowtime, interval '1' hour),\n  count(*) as c\nfrom orders\ngroup by session(rowtime, interval '1' hour)").ok();
    }

    @Test
    public void testInsertExtendedColumn() {
        this.sql("insert into empdefaults(extra BOOLEAN, note VARCHAR) (deptno, empno, ename, extra, note) values (1, 10, '2', true, 'ok')").ok();
        this.sql("insert into emp(\"rank\" INT, extra BOOLEAN) values (1, 'nom', 'job', 0, timestamp '1970-01-01 00:00:00', 1, 1,  1, false, 100, false)").ok();
    }

    @Test
    public void testInsertBindExtendedColumn() {
        this.sql("insert into empdefaults(extra BOOLEAN, note VARCHAR) (deptno, empno, ename, extra, note) values (1, 10, '2', ?, 'ok')").ok();
        this.sql("insert into emp(\"rank\" INT, extra BOOLEAN) values (1, 'nom', 'job', 0, timestamp '1970-01-01 00:00:00', 1, 1,  1, false, ?, ?)").ok();
    }

    @Test
    public void testInsertExtendedColumnModifiableView() {
        this.sql("insert into EMP_MODIFIABLEVIEW2(extra2 BOOLEAN, note VARCHAR) (deptno, empno, ename, extra2, note) values (20, 10, '2', true, 'ok')").ok();
        this.sql("insert into EMP_MODIFIABLEVIEW2(\"rank\" INT, extra2 BOOLEAN) values ('nom', 1, 'job', 20, true, 0, false, timestamp '1970-01-01 00:00:00', 1, 1,  1, false)").ok();
    }

    @Test
    public void testInsertBindExtendedColumnModifiableView() {
        this.sql("insert into EMP_MODIFIABLEVIEW2(extra2 BOOLEAN, note VARCHAR) (deptno, empno, ename, extra2, note) values (20, 10, '2', true, ?)").ok();
        this.sql("insert into EMP_MODIFIABLEVIEW2(\"rank\" INT, extra2 BOOLEAN) values ('nom', 1, 'job', 20, true, 0, false, timestamp '1970-01-01 00:00:00', 1, 1,  ?, false)").ok();
    }

    @Test
    public void testInsertExtendedColumnModifiableViewFailConstraint() {
        this.tester.checkQueryFails("insert into EMP_MODIFIABLEVIEW2(extra2 BOOLEAN, note VARCHAR) (deptno, empno, ename, extra2, note) values (^1^, 10, '2', true, 'ok')", "Modifiable view constraint is not satisfied for column 'DEPTNO' of base table 'EMP_MODIFIABLEVIEW2'");
        this.tester.checkQueryFails("insert into EMP_MODIFIABLEVIEW2(extra2 BOOLEAN, note VARCHAR) (deptno, empno, ename, extra2, note) values (^?^, 10, '2', true, 'ok')", "Modifiable view constraint is not satisfied for column 'DEPTNO' of base table 'EMP_MODIFIABLEVIEW2'");
        this.tester.checkQueryFails("insert into EMP_MODIFIABLEVIEW2(\"rank\" INT, extra2 BOOLEAN) values ('nom', 1, 'job', ^0^, true, 0, false, timestamp '1970-01-01 00:00:00', 1, 1,  1, false)", "Modifiable view constraint is not satisfied for column 'DEPTNO' of base table 'EMP_MODIFIABLEVIEW2'");
    }

    @Test
    public void testInsertExtendedColumnModifiableViewFailColumnCount() {
        String sql0 = "insert into ^EMP_MODIFIABLEVIEW2(\"rank\" INT, extra2 BOOLEAN)^ values ('nom', 1, 'job', 0, true, 0, false, timestamp '1970-01-01 00:00:00', 1, 1,  1)";
        this.tester.checkQueryFails("insert into ^EMP_MODIFIABLEVIEW2(\"rank\" INT, extra2 BOOLEAN)^ values ('nom', 1, 'job', 0, true, 0, false, timestamp '1970-01-01 00:00:00', 1, 1,  1)", "Number of INSERT target columns \\(12\\) does not equal number of source items \\(11\\)");
        String sql1 = "insert into ^EMP_MODIFIABLEVIEW2(\"rank\" INT, extra2 BOOLEAN)^ (deptno, empno, ename, extra2, \"rank\") values (?, 10, '2', true)";
        this.tester.checkQueryFails("insert into ^EMP_MODIFIABLEVIEW2(\"rank\" INT, extra2 BOOLEAN)^ (deptno, empno, ename, extra2, \"rank\") values (?, 10, '2', true)", "Number of INSERT target columns \\(5\\) does not equal number of source items \\(4\\)");
    }

    @Test
    public void testInsertExtendedColumnFailDuplicate() {
        this.tester.checkQueryFails("insert into EMP_MODIFIABLEVIEW2(extcol INT, ^extcol^ BOOLEAN) values ('nom', 1, 'job', 0, true, 0, false, timestamp '1970-01-01 00:00:00', 1, 1,  1)", "Duplicate name 'EXTCOL' in column list");
        this.tester.checkQueryFails("insert into EMP_MODIFIABLEVIEW2(extcol INT, ^extcol^ BOOLEAN) (extcol) values (1)", "Duplicate name 'EXTCOL' in column list");
        this.tester.checkQueryFails("insert into EMP_MODIFIABLEVIEW2(extcol INT, ^extcol^ BOOLEAN) (extcol) values (false)", "Duplicate name 'EXTCOL' in column list");
        this.tester.checkQueryFails("insert into EMP(extcol INT, ^extcol^ BOOLEAN) (extcol) values (1)", "Duplicate name 'EXTCOL' in column list");
        this.tester.checkQueryFails("insert into EMP(extcol INT, ^extcol^ BOOLEAN) (extcol) values (false)", "Duplicate name 'EXTCOL' in column list");
    }

    @Test
    public void testUpdateExtendedColumn() {
        this.sql("update empdefaults(extra BOOLEAN, note VARCHAR) set deptno = 1, extra = true, empno = 20, ename = 'Bob', note = 'legion' where deptno = 10").ok();
        this.sql("update empdefaults(extra BOOLEAN) set extra = true, deptno = 1, ename = 'Bob' where deptno = 10").ok();
        this.sql("update empdefaults(\"empNo\" VARCHAR) set \"empNo\" = '5', deptno = 1, ename = 'Bob' where deptno = 10").ok();
    }

    @Test
    public void testInsertFailDataType() {
        this.tester.withConformance((SqlConformance)SqlConformanceEnum.PRAGMATIC_2003).checkQueryFails("insert into empnullables ^values ('5', 'bob')^", "Cannot assign to target field 'EMPNO' of type INTEGER from source field 'EXPR\\$0' of type CHAR\\(1\\)");
        this.tester.withConformance((SqlConformance)SqlConformanceEnum.PRAGMATIC_2003).checkQueryFails("insert into empnullables (^empno^, ename) values ('5', 'bob')", "Cannot assign to target field 'EMPNO' of type INTEGER from source field 'EXPR\\$0' of type CHAR\\(1\\)");
        this.tester.withConformance((SqlConformance)SqlConformanceEnum.PRAGMATIC_2003).checkQueryFails("insert into empnullables(extra BOOLEAN) (empno, ename, ^extra^) values (5, 'bob', 'true')", "Cannot assign to target field 'EXTRA' of type BOOLEAN from source field 'EXPR\\$2' of type CHAR\\(4\\)");
    }

    @Ignore(value="CALCITE-1727")
    @Test
    public void testUpdateFailDataType() {
        this.tester.checkQueryFails("update emp set ^empNo^ = '5', deptno = 1, ename = 'Bob' where deptno = 10", "Cannot assign to target field 'EMPNO' of type INTEGER from source field 'EXPR$0' of type CHAR(1)");
        this.tester.checkQueryFails("update emp(extra boolean) set ^extra^ = '5', deptno = 1, ename = 'Bob' where deptno = 10", "Cannot assign to target field 'EXTRA' of type BOOLEAN from source field 'EXPR$0' of type CHAR(1)");
    }

    @Ignore(value="CALCITE-1727")
    @Test
    public void testUpdateFailCaseSensitivity() {
        this.tester.checkQueryFails("update empdefaults set empNo = '5', deptno = 1, ename = 'Bob' where deptno = 10", "Column 'empno' not found in any table; did you mean 'EMPNO'\\?");
    }

    @Test
    public void testUpdateExtendedColumnFailCaseSensitivity() {
        this.tester.checkQueryFails("update empdefaults(\"extra\" BOOLEAN) set ^extra^ = true, deptno = 1, ename = 'Bob' where deptno = 10", "Unknown target column 'EXTRA'");
        this.tester.checkQueryFails("update empdefaults(extra BOOLEAN) set ^\"extra\"^ = true, deptno = 1, ename = 'Bob' where deptno = 10", "Unknown target column 'extra'");
    }

    @Test
    public void testUpdateBindExtendedColumn() {
        this.sql("update empdefaults(extra BOOLEAN, note VARCHAR) set deptno = 1, extra = true, empno = 20, ename = 'Bob', note = ? where deptno = 10").ok();
        this.sql("update empdefaults(extra BOOLEAN) set extra = ?, deptno = 1, ename = 'Bob' where deptno = 10").ok();
    }

    @Test
    public void testUpdateExtendedColumnModifiableView() {
        this.sql("update EMP_MODIFIABLEVIEW2(extra2 BOOLEAN, note VARCHAR) set deptno = 20, extra2 = true, empno = 20, ename = 'Bob', note = 'legion' where ename = 'Jane'").ok();
        this.sql("update EMP_MODIFIABLEVIEW2(extra2 BOOLEAN) set extra2 = true, ename = 'Bob' where ename = 'Jane'").ok();
    }

    @Test
    public void testUpdateBindExtendedColumnModifiableView() {
        this.sql("update EMP_MODIFIABLEVIEW2(extra2 BOOLEAN, note VARCHAR) set deptno = 20, extra2 = true, empno = 20, ename = 'Bob', note = ? where ename = 'Jane'").ok();
        this.sql("update EMP_MODIFIABLEVIEW2(extra2 BOOLEAN) set extra2 = ?, ename = 'Bob' where ename = 'Jane'").ok();
    }

    @Test
    public void testUpdateExtendedColumnModifiableViewFailConstraint() {
        this.tester.checkQueryFails("update EMP_MODIFIABLEVIEW2(extra2 BOOLEAN, note VARCHAR) set deptno = ^1^, extra2 = true, empno = 20, ename = 'Bob', note = 'legion' where ename = 'Jane'", "Modifiable view constraint is not satisfied for column 'DEPTNO' of base table 'EMP_MODIFIABLEVIEW2'");
        this.tester.checkQueryFails("update EMP_MODIFIABLEVIEW2(extra2 BOOLEAN) set extra2 = true, deptno = ^1^, ename = 'Bob' where ename = 'Jane'", "Modifiable view constraint is not satisfied for column 'DEPTNO' of base table 'EMP_MODIFIABLEVIEW2'");
    }

    @Test
    public void testUpdateExtendedColumnCollision() {
        this.sql("update empdefaults(empno INTEGER NOT NULL, deptno INTEGER) set deptno = 1, empno = 20, ename = 'Bob' where deptno = 10").ok();
    }

    @Test
    public void testUpdateExtendedColumnModifiableViewCollision() {
        this.sql("update EMP_MODIFIABLEVIEW3(empno INTEGER NOT NULL, deptno INTEGER) set deptno = 20, empno = 20, ename = 'Bob' where empno = 10").ok();
        this.sql("update EMP_MODIFIABLEVIEW3(empno INTEGER NOT NULL, \"deptno\" BOOLEAN) set \"deptno\" = true, empno = 20, ename = 'Bob' where empno = 10").ok();
    }

    @Test
    public void testUpdateExtendedColumnFailCollision() {
        this.tester.checkQueryFails("update empdefaults(^empno^ BOOLEAN, deptno INTEGER) set deptno = 1, empno = false, ename = 'Bob' where deptno = 10", "Cannot assign to target field 'EMPNO' of type INTEGER NOT NULL from source field 'EMPNO' of type BOOLEAN");
    }

    @Ignore(value="CALCITE-1727")
    @Test
    public void testUpdateExtendedColumnFailCollision2() {
        this.tester.checkQueryFails("update empdefaults(^\"deptno\"^ BOOLEAN) set \"deptno\" = 1, empno = 1, ename = 'Bob' where deptno = 10", "Cannot assign to target field 'deptno' of type BOOLEAN NOT NULL from source field 'deptno' of type INTEGER");
    }

    @Test
    public void testUpdateExtendedColumnModifiableViewFailCollision() {
        this.tester.checkQueryFails("update EMP_MODIFIABLEVIEW3(^empno^ BOOLEAN, deptno INTEGER) set deptno = 1, empno = false, ename = 'Bob' where deptno = 10", "Cannot assign to target field 'EMPNO' of type INTEGER NOT NULL from source field 'EMPNO' of type BOOLEAN");
    }

    @Test
    public void testUpdateExtendedColumnModifiableViewFailExtendedCollision() {
        this.tester.checkQueryFails("update EMP_MODIFIABLEVIEW2(^extra^ INTEGER, deptno INTEGER) set deptno = 20, empno = 20, ename = 'Bob', extra = 5 where empno = 10", "Cannot assign to target field 'EXTRA' of type BOOLEAN from source field 'EXTRA' of type INTEGER");
    }

    @Test
    public void testUpdateExtendedColumnModifiableViewFailUnderlyingCollision() {
        this.tester.checkQueryFails("update EMP_MODIFIABLEVIEW3(^comm^ BOOLEAN, deptno INTEGER) set deptno = 1, empno = 20, ename = 'Bob', comm = true where deptno = 10", "Cannot assign to target field 'COMM' of type INTEGER from source field 'COMM' of type BOOLEAN");
    }

    @Test
    public void testUpdateExtendedColumnFailDuplicate() {
        this.tester.checkQueryFails("update emp(comm BOOLEAN, ^comm^ INTEGER) set deptno = 1, empno = 20, ename = 'Bob', comm = 1 where deptno = 10", "Duplicate name 'COMM' in column list");
        this.tester.checkQueryFails("update EMP_MODIFIABLEVIEW3(comm BOOLEAN, ^comm^ INTEGER) set deptno = 1, empno = 20, ename = 'Bob', comm = true where deptno = 10", "Duplicate name 'COMM' in column list");
    }

    @Test
    public void testInsertExtendedColumnCollision() {
        this.sql("insert into EMPDEFAULTS(^comm^ INTEGER) (empno, ename, job, comm)\nvalues (1, 'Arthur', 'clown', 5)").ok();
    }

    @Test
    public void testInsertExtendedColumnModifiableViewCollision() {
        this.sql("insert into EMP_MODIFIABLEVIEW3(^sal^ INTEGER) (empno, ename, job, sal)\nvalues (1, 'Arthur', 'clown', 5)").ok();
    }

    @Test
    public void testInsertExtendedColumnModifiableViewExtendedCollision() {
        this.sql("insert into EMP_MODIFIABLEVIEW2(^extra^ BOOLEAN) (empno, ename, job, extra)\nvalues (1, 'Arthur', 'clown', true)").ok();
    }

    @Test
    public void testInsertExtendedColumnModifiableViewUnderlyingCollision() {
        this.sql("insert into EMP_MODIFIABLEVIEW3(^comm^ INTEGER) (empno, ename, job, comm)\nvalues (1, 'Arthur', 'clown', 5)").ok();
    }

    @Test
    public void testInsertExtendedColumnFailCollision() {
        this.tester.checkQueryFails("insert into EMPDEFAULTS(^comm^ BOOLEAN) (empno, ename, job, comm)\nvalues (1, 'Arthur', 'clown', true)", "Cannot assign to target field 'COMM' of type INTEGER from source field 'COMM' of type BOOLEAN");
        this.tester.checkQueryFails("insert into EMPDEFAULTS(\"comm\" BOOLEAN) (empno, ename, job, ^comm^)\nvalues (1, 'Arthur', 'clown', true)", "Cannot assign to target field 'COMM' of type INTEGER from source field 'EXPR\\$3' of type BOOLEAN");
        this.tester.checkQueryFails("insert into EMPDEFAULTS(\"comm\" BOOLEAN) (empno, ename, job, ^\"comm\"^)\nvalues (1, 'Arthur', 'clown', 1)", "Cannot assign to target field 'comm' of type BOOLEAN from source field 'EXPR\\$3' of type INTEGER");
    }

    @Test
    public void testInsertExtendedColumnModifiableViewFailCollision() {
        this.tester.checkQueryFails("insert into EMP_MODIFIABLEVIEW2(^slacker^ INTEGER) (empno, ename, job, slacker) values (1, 'Arthur', 'clown', true)", "Cannot assign to target field 'SLACKER' of type BOOLEAN from source field 'SLACKER' of type INTEGER");
        this.tester.checkQueryFails("insert into EMP_MODIFIABLEVIEW2(\"slacker\" INTEGER) (empno, ename, job, ^slacker^) values (1, 'Arthur', 'clown', 1)", "Cannot assign to target field 'SLACKER' of type BOOLEAN from source field 'EXPR\\$3' of type INTEGER");
        this.tester.checkQueryFails("insert into EMP_MODIFIABLEVIEW2(\"slacker\" INTEGER) (empno, ename, job, ^\"slacker\"^) values (1, 'Arthur', 'clown', true)", "Cannot assign to target field 'slacker' of type INTEGER from source field 'EXPR\\$3' of type BOOLEAN");
    }

    @Test
    public void testInsertExtendedColumnModifiableViewFailExtendedCollision() {
        this.tester.checkQueryFails("insert into EMP_MODIFIABLEVIEW2(^extra^ INTEGER) (empno, ename, job, extra) values (1, 'Arthur', 'clown', true)", "Cannot assign to target field 'EXTRA' of type BOOLEAN from source field 'EXTRA' of type INTEGER");
        this.tester.checkQueryFails("insert into EMP_MODIFIABLEVIEW2(\"extra\" INTEGER) (empno, ename, job, ^extra^) values (1, 'Arthur', 'clown', 1)", "Cannot assign to target field 'EXTRA' of type BOOLEAN from source field 'EXPR\\$3' of type INTEGER");
        this.tester.checkQueryFails("insert into EMP_MODIFIABLEVIEW2(\"extra\" INTEGER) (empno, ename, job, ^\"extra\"^) values (1, 'Arthur', 'clown', true)", "Cannot assign to target field 'extra' of type INTEGER from source field 'EXPR\\$3' of type BOOLEAN");
    }

    @Test
    public void testInsertExtendedColumnModifiableViewFailUnderlyingCollision() {
        this.tester.checkQueryFails("insert into EMP_MODIFIABLEVIEW3(^comm^ BOOLEAN) (empno, ename, job, comm) values (1, 'Arthur', 'clown', true)", "Cannot assign to target field 'COMM' of type INTEGER from source field 'COMM' of type BOOLEAN");
        this.tester.checkQueryFails("insert into EMP_MODIFIABLEVIEW3(\"comm\" BOOLEAN) (empno, ename, job, ^comm^) values (1, 'Arthur', 'clown', 5)", "Unknown target column 'COMM'");
        this.tester.checkQueryFails("insert into EMP_MODIFIABLEVIEW3(\"comm\" BOOLEAN) (empno, ename, job, ^\"comm\"^) values (1, 'Arthur', 'clown', 1)", "Cannot assign to target field 'comm' of type BOOLEAN from source field 'EXPR\\$3' of type INTEGER");
    }

    @Test
    public void testDelete() {
        this.sql("delete from empdefaults where deptno = 10").ok();
    }

    @Test
    public void testDeleteExtendedColumn() {
        this.sql("delete from empdefaults(extra BOOLEAN) where deptno = 10").ok();
        this.sql("delete from empdefaults(extra BOOLEAN) where extra = false").ok();
    }

    @Test
    public void testDeleteBindExtendedColumn() {
        this.sql("delete from empdefaults(extra BOOLEAN) where deptno = ?").ok();
        this.sql("delete from empdefaults(extra BOOLEAN) where extra = ?").ok();
    }

    @Test
    public void testDeleteModifiableView() {
        this.sql("delete from EMP_MODIFIABLEVIEW2 where deptno = 10").ok();
        this.sql("delete from EMP_MODIFIABLEVIEW2 where deptno = 20").ok();
        this.sql("delete from EMP_MODIFIABLEVIEW2 where empno = 30").ok();
    }

    @Test
    public void testDeleteExtendedColumnModifiableView() {
        this.sql("delete from EMP_MODIFIABLEVIEW2(extra BOOLEAN) where sal > 10").ok();
        this.sql("delete from EMP_MODIFIABLEVIEW2(note BOOLEAN) where note = 'fired'").ok();
    }

    @Test
    public void testDeleteExtendedColumnCollision() {
        this.sql("delete from emp(empno INTEGER NOT NULL) where sal > 10").ok();
    }

    @Test
    public void testDeleteExtendedColumnModifiableViewCollision() {
        this.sql("delete from EMP_MODIFIABLEVIEW2(empno INTEGER NOT NULL) where sal > 10").ok();
        this.sql("delete from EMP_MODIFIABLEVIEW2(\"empno\" INTEGER) where sal > 10").ok();
        this.sql("delete from EMP_MODIFIABLEVIEW2(extra BOOLEAN) where sal > 10").ok();
        this.sql("delete from EMP_MODIFIABLEVIEW2(\"extra\" VARCHAR) where sal > 10").ok();
        this.sql("delete from EMP_MODIFIABLEVIEW3(comm INTEGER) where sal > 10").ok();
        this.sql("delete from EMP_MODIFIABLEVIEW3(\"comm\" BIGINT) where sal > 10").ok();
    }

    @Test
    public void testDeleteExtendedColumnFailCollision() {
        this.tester.checkQueryFails("delete from EMP_MODIFIABLEVIEW2(^empno^ BOOLEAN) where sal > 10", "Cannot assign to target field 'EMPNO' of type INTEGER NOT NULL from source field 'EMPNO' of type BOOLEAN");
        this.tester.checkQueryFails("delete from EMP_MODIFIABLEVIEW2(^empno^ INTEGER) where sal > 10", "Cannot assign to target field 'EMPNO' of type INTEGER NOT NULL from source field 'EMPNO' of type INTEGER");
        this.tester.checkQueryFails("delete from EMP_MODIFIABLEVIEW2(^\"EMPNO\"^ INTEGER) where sal > 10", "Cannot assign to target field 'EMPNO' of type INTEGER NOT NULL from source field 'EMPNO' of type INTEGER");
        this.tester.checkQueryFails("delete from EMP_MODIFIABLEVIEW2(^empno^ INTEGER) where sal > 10", "Cannot assign to target field 'EMPNO' of type INTEGER NOT NULL from source field 'EMPNO' of type INTEGER");
    }

    @Test
    public void testDeleteExtendedColumnModifiableViewFailCollision() {
        this.tester.checkQueryFails("delete from EMP_MODIFIABLEVIEW(^deptno^ BOOLEAN) where sal > 10", "Cannot assign to target field 'DEPTNO' of type INTEGER from source field 'DEPTNO' of type BOOLEAN");
        this.tester.checkQueryFails("delete from EMP_MODIFIABLEVIEW(^\"DEPTNO\"^ BOOLEAN) where sal > 10", "Cannot assign to target field 'DEPTNO' of type INTEGER from source field 'DEPTNO' of type BOOLEAN");
    }

    @Test
    public void testDeleteExtendedColumnModifiableViewFailExtendedCollision() {
        this.tester.checkQueryFails("delete from EMP_MODIFIABLEVIEW(^slacker^ INTEGER) where sal > 10", "Cannot assign to target field 'SLACKER' of type BOOLEAN from source field 'SLACKER' of type INTEGER");
        this.tester.checkQueryFails("delete from EMP_MODIFIABLEVIEW(^\"SLACKER\"^ INTEGER) where sal > 10", "Cannot assign to target field 'SLACKER' of type BOOLEAN from source field 'SLACKER' of type INTEGER");
    }

    @Test
    public void testDeleteExtendedColumnFailDuplicate() {
        this.tester.checkQueryFails("delete from emp (extra VARCHAR, ^extra^ VARCHAR)", "Duplicate name 'EXTRA' in column list");
        this.tester.checkQueryFails("delete from EMP_MODIFIABLEVIEW (extra VARCHAR, ^extra^ VARCHAR) where extra = 'test'", "Duplicate name 'EXTRA' in column list");
        this.tester.checkQueryFails("delete from EMP_MODIFIABLEVIEW (extra VARCHAR, ^\"EXTRA\"^ VARCHAR) where extra = 'test'", "Duplicate name 'EXTRA' in column list");
    }

    @Test
    public void testArrayAssignment() {
        SqlTypeFactoryImpl typeFactory = new SqlTypeFactoryImpl(RelDataTypeSystem.DEFAULT);
        RelDataType bigint = typeFactory.createSqlType(SqlTypeName.BIGINT);
        RelDataType bigintNullable = typeFactory.createTypeWithNullability(bigint, true);
        RelDataType bigintNotNull = typeFactory.createTypeWithNullability(bigint, false);
        RelDataType date = typeFactory.createSqlType(SqlTypeName.DATE);
        RelDataType dateNotNull = typeFactory.createTypeWithNullability(date, false);
        Assert.assertThat((Object)SqlTypeUtil.canAssignFrom((RelDataType)bigintNullable, (RelDataType)bigintNotNull), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)SqlTypeUtil.canAssignFrom((RelDataType)bigintNullable, (RelDataType)dateNotNull), (Matcher)CoreMatchers.is((Object)false));
        RelDataType bigintNullableArray = typeFactory.createArrayType(bigintNullable, -1L);
        RelDataType bigintArrayNullable = typeFactory.createTypeWithNullability(bigintNullableArray, true);
        ArraySqlType bigintNotNullArray = new ArraySqlType(bigintNotNull, false);
        Assert.assertThat((Object)SqlTypeUtil.canAssignFrom((RelDataType)bigintArrayNullable, (RelDataType)bigintNotNullArray), (Matcher)CoreMatchers.is((Object)true));
        ArraySqlType dateNotNullArray = new ArraySqlType(dateNotNull, false);
        Assert.assertThat((Object)SqlTypeUtil.canAssignFrom((RelDataType)bigintArrayNullable, (RelDataType)dateNotNullArray), (Matcher)CoreMatchers.is((Object)false));
    }
}

