/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.tools;

import java.math.BigDecimal;
import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.adapter.enumerable.EnumerableTableScan;
import org.apache.calcite.plan.RelOptAbstractTable;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rel.type.RelDataTypeSystemImpl;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.schema.Path;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Schemas;
import org.apache.calcite.schema.impl.AbstractTable;
import org.apache.calcite.server.CalciteServerStatement;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlExplainFormat;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.test.CalciteAssert;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Frameworks;
import org.apache.calcite.tools.Planner;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class FrameworksTest {
    @Test
    public void testOptimize() {
        RelNode x = (RelNode)Frameworks.withPlanner((Frameworks.PlannerAction)new Frameworks.PlannerAction<RelNode>(){

            public RelNode apply(RelOptCluster cluster, RelOptSchema relOptSchema, SchemaPlus rootSchema) {
                LogicalFilter filter;
                RelDataTypeFactory typeFactory = cluster.getTypeFactory();
                AbstractTable table = new AbstractTable(){

                    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
                        RelDataType stringType = typeFactory.createJavaType(String.class);
                        RelDataType integerType = typeFactory.createJavaType(Integer.class);
                        return typeFactory.builder().add("s", stringType).add("i", integerType).build();
                    }
                };
                RelOptAbstractTable relOptTable = new RelOptAbstractTable(relOptSchema, "myTable", table.getRowType(typeFactory)){};
                EnumerableTableScan tableRel = EnumerableTableScan.create((RelOptCluster)cluster, (RelOptTable)relOptTable);
                RexBuilder rexBuilder = cluster.getRexBuilder();
                RexNode condition = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{rexBuilder.makeFieldAccess(rexBuilder.makeRangeReference((RelNode)tableRel), "i", true), rexBuilder.makeExactLiteral(BigDecimal.ONE)});
                LogicalFilter rootRel = filter = LogicalFilter.create((RelNode)tableRel, (RexNode)condition);
                RelOptPlanner planner = cluster.getPlanner();
                RelTraitSet desiredTraits = cluster.traitSet().replace((RelTrait)EnumerableConvention.INSTANCE);
                RelNode rootRel2 = planner.changeTraits((RelNode)rootRel, desiredTraits);
                planner.setRoot(rootRel2);
                return planner.findBestExp();
            }
        });
        String s = RelOptUtil.dumpPlan((String)"", (RelNode)x, (SqlExplainFormat)SqlExplainFormat.TEXT, (SqlExplainLevel)SqlExplainLevel.DIGEST_ATTRIBUTES);
        Assert.assertThat((Object)Util.toLinux((String)s), (Matcher)CoreMatchers.equalTo((Object)"EnumerableFilter(condition=[>($1, 1)])\n  EnumerableTableScan(table=[[myTable]])\n"));
    }

    @Test
    public void testCreateRootSchemaWithNoMetadataSchema() {
        SchemaPlus rootSchema = Frameworks.createRootSchema((boolean)false);
        Assert.assertThat((Object)rootSchema.getSubSchemaNames().size(), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void testTypeSystem() {
        this.checkTypeSystem(19, Frameworks.newConfigBuilder().build());
        this.checkTypeSystem(25, Frameworks.newConfigBuilder().typeSystem(HiveLikeTypeSystem.INSTANCE).build());
        this.checkTypeSystem(31, Frameworks.newConfigBuilder().typeSystem((RelDataTypeSystem)new HiveLikeTypeSystem2()).build());
    }

    private void checkTypeSystem(final int expected, FrameworkConfig config) {
        Frameworks.withPrepare((Frameworks.PrepareAction)new Frameworks.PrepareAction<Void>(config){

            public Void apply(RelOptCluster cluster, RelOptSchema relOptSchema, SchemaPlus rootSchema, CalciteServerStatement statement) {
                RelDataType type = cluster.getTypeFactory().createSqlType(SqlTypeName.DECIMAL, 30, 2);
                RexLiteral literal = cluster.getRexBuilder().makeExactLiteral(BigDecimal.ONE, type);
                RexNode call = cluster.getRexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.PLUS, new RexNode[]{literal, literal});
                Assert.assertEquals((long)expected, (long)call.getType().getPrecision());
                return null;
            }
        });
    }

    @Test
    public void testFrameworksValidatorWithIdentifierExpansion() throws Exception {
        SchemaPlus rootSchema = Frameworks.createRootSchema((boolean)true);
        FrameworkConfig config = Frameworks.newConfigBuilder().defaultSchema(CalciteAssert.addSchema(rootSchema, CalciteAssert.SchemaSpec.HR)).build();
        Planner planner = Frameworks.getPlanner((FrameworkConfig)config);
        SqlNode parse = planner.parse("select * from \"emps\" ");
        SqlNode val = planner.validate(parse);
        String valStr = val.toSqlString(SqlDialect.DUMMY, false).getSql();
        String expandedStr = "SELECT `emps`.`empid`, `emps`.`deptno`, `emps`.`name`, `emps`.`salary`, `emps`.`commission`\nFROM `hr`.`emps` AS `emps`";
        Assert.assertThat((Object)Util.toLinux((String)valStr), (Matcher)CoreMatchers.equalTo((Object)expandedStr));
    }

    @Test
    public void testSchemaPath() {
        SchemaPlus rootSchema = Frameworks.createRootSchema((boolean)true);
        FrameworkConfig config = Frameworks.newConfigBuilder().defaultSchema(CalciteAssert.addSchema(rootSchema, CalciteAssert.SchemaSpec.HR)).build();
        Path path = Schemas.path((SchemaPlus)config.getDefaultSchema());
        Assert.assertThat((Object)path.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((Pair)path.get((int)0)).left, (Matcher)CoreMatchers.is((Object)""));
        Assert.assertThat((Object)((Pair)path.get((int)1)).left, (Matcher)CoreMatchers.is((Object)"hr"));
        Assert.assertThat((Object)path.names().size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat(path.names().get(0), (Matcher)CoreMatchers.is((Object)"hr"));
        Assert.assertThat((Object)path.schemas().size(), (Matcher)CoreMatchers.is((Object)2));
        Path parent = path.parent();
        Assert.assertThat((Object)parent.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)parent.names().size(), (Matcher)CoreMatchers.is((Object)0));
        Path grandparent = parent.parent();
        Assert.assertThat((Object)grandparent.size(), (Matcher)CoreMatchers.is((Object)0));
        try {
            Path o = grandparent.parent();
            Assert.fail((String)("expected exception, got " + o));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public static class HiveLikeTypeSystem2
    extends RelDataTypeSystemImpl {
        public int getMaxNumericPrecision() {
            assert (super.getMaxNumericPrecision() == 19);
            return 38;
        }
    }

    public static class HiveLikeTypeSystem
    extends RelDataTypeSystemImpl {
        public static final RelDataTypeSystem INSTANCE = new HiveLikeTypeSystem();

        private HiveLikeTypeSystem() {
        }

        public int getMaxNumericPrecision() {
            assert (super.getMaxNumericPrecision() == 19);
            return 25;
        }
    }
}

