/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Random;
import org.apache.calcite.linq4j.function.Function0;
import org.apache.calcite.linq4j.function.Function1;
import org.apache.calcite.util.Benchmark;
import org.apache.calcite.util.ChunkList;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class ChunkListTest {
    @Test
    public void testChunkList() {
        ChunkList list = new ChunkList();
        ChunkList list0 = new ChunkList((Collection)list);
        ChunkList list1 = new ChunkList((Collection)list);
        list1.add((Object)123);
        Assert.assertEquals((long)0L, (long)list.size());
        Assert.assertEquals((long)0L, (long)list0.size());
        Assert.assertEquals((long)1L, (long)list1.size());
        Assert.assertTrue((boolean)list.isEmpty());
        Assert.assertEquals((Object)"[]", (Object)list.toString());
        try {
            list.remove(0);
            Assert.fail((String)"expected exception");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            list.get(-1);
            Assert.fail((String)"expected exception");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            list.get(0);
            Assert.fail((String)"expected exception");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        list.add((Object)7);
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)7L, (long)((Integer)list.get(0)).intValue());
        Assert.assertFalse((boolean)list.isEmpty());
        Assert.assertEquals((Object)"[7]", (Object)list.toString());
        list.add((Object)9);
        list.add(null);
        list.add((Object)11);
        Assert.assertEquals((long)4L, (long)list.size());
        Assert.assertEquals((long)7L, (long)((Integer)list.get(0)).intValue());
        Assert.assertEquals((long)9L, (long)((Integer)list.get(1)).intValue());
        Assert.assertNull((Object)list.get(2));
        Assert.assertEquals((long)11L, (long)((Integer)list.get(3)).intValue());
        Assert.assertFalse((boolean)list.isEmpty());
        Assert.assertEquals((Object)"[7, 9, null, 11]", (Object)list.toString());
        Assert.assertTrue((boolean)list.contains((Object)9));
        Assert.assertFalse((boolean)list.contains((Object)8));
        list.addAll(Collections.nCopies(70, 1));
        Assert.assertEquals((long)74L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((Integer)list.get(40)).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)list.get(70)).intValue());
        int n = 0;
        for (Integer integer : list) {
            Util.discard((Object)integer);
            ++n;
        }
        Assert.assertEquals((long)n, (long)list.size());
        int i = list.indexOf(null);
        Assert.assertEquals((long)2L, (long)i);
        list.set(2, (Object)123);
        i = list.indexOf(null);
        Assert.assertEquals((long)-1L, (long)i);
        Collections.sort(list0);
        Assert.assertThat((Object)list0.isEmpty(), (Matcher)CoreMatchers.is((Object)true));
        Collections.sort(list1);
        Assert.assertThat((Object)list1.size(), (Matcher)CoreMatchers.is((Object)1));
        Collections.sort(list);
        Assert.assertEquals((long)74L, (long)list.size());
        list.remove((Object)7);
        Collections.sort(list);
        Assert.assertEquals((long)1L, (long)((Integer)list.get(3)).intValue());
        boolean b = list.removeAll(Collections.singletonList(9));
        Assert.assertTrue((boolean)b);
        b = list.removeAll(Collections.singletonList(99));
        Assert.assertFalse((boolean)b);
        list.add((Object)12345);
        b = list.removeAll(Collections.singletonList(12345));
        Assert.assertTrue((boolean)b);
        list.add((Object)12345);
        list.add((Object)123);
        b = list.removeAll(Collections.singletonList(12345));
        Assert.assertTrue((boolean)b);
        Assert.assertThat((Object)new ChunkList(Collections.nCopies(1000, 77)).size(), (Matcher)CoreMatchers.is((Object)1000));
        ChunkList list2 = new ChunkList();
        list2.listIterator(0).add("x");
        Assert.assertEquals((Object)"[x]", (Object)list2.toString());
        list2.add(0, (Object)"y");
        Assert.assertEquals((Object)"[y, x]", (Object)list2.toString());
        list2.remove(0);
        Assert.assertEquals((Object)"[x]", (Object)list2.toString());
        list2.clear();
        list2.addAll((Collection)ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"d", (Object)"e"));
        Assert.assertThat((Object)list2.size(), (Matcher)CoreMatchers.is((Object)5));
        ListIterator listIterator = list2.listIterator(0);
        Assert.assertThat(listIterator.next(), (Matcher)CoreMatchers.is((Object)"a"));
        listIterator.remove();
        Assert.assertThat(listIterator.next(), (Matcher)CoreMatchers.is((Object)"b"));
        listIterator.remove();
        Assert.assertThat(listIterator.next(), (Matcher)CoreMatchers.is((Object)"c"));
        listIterator.remove();
        Assert.assertThat(listIterator.next(), (Matcher)CoreMatchers.is((Object)"d"));
        listIterator.remove();
        Assert.assertThat((Object)list2.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat(listIterator.next(), (Matcher)CoreMatchers.is((Object)"e"));
        listIterator.remove();
        Assert.assertThat((Object)list2.size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void testClear() {
        this.checkListClear(0);
        this.checkListClear(1);
        this.checkListClear(2);
        this.checkListClear(32);
        this.checkListClear(64);
        this.checkListClear(65);
        this.checkListClear(66);
        this.checkListClear(100);
        this.checkListClear(127);
        this.checkListClear(128);
        this.checkListClear(129);
    }

    private void checkListClear(int n) {
        for (int i = 0; i < 4; ++i) {
            ChunkList list = new ChunkList(Collections.nCopies(n, "z"));
            Assert.assertThat((Object)list.size(), (Matcher)CoreMatchers.is((Object)n));
            switch (i) {
                case 0: {
                    list.clear();
                    break;
                }
                case 1: {
                    for (int j = 0; j < n; ++j) {
                        list.remove(0);
                    }
                    break;
                }
                case 2: {
                    for (int j = 0; j < n; ++j) {
                        list.remove(list.size() - 1);
                    }
                    break;
                }
                case 3: {
                    Random random = new Random();
                    for (int j = 0; j < n; ++j) {
                        list.remove(random.nextInt(list.size()));
                    }
                    break;
                }
            }
            Assert.assertThat((Object)list.isEmpty(), (Matcher)CoreMatchers.is((Object)true));
        }
    }

    @Test
    public void testIterator() {
        ChunkList list = new ChunkList();
        list.add((Object)"a");
        list.add((Object)"b");
        ListIterator listIterator = list.listIterator(0);
        try {
            listIterator.remove();
            Assert.fail((String)"excepted exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        listIterator.next();
        listIterator.remove();
        Assert.assertThat((Object)list.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)listIterator.hasNext(), (Matcher)CoreMatchers.is((Object)true));
        listIterator.next();
        listIterator.remove();
        Assert.assertThat((Object)list.size(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)listIterator.hasNext(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testRandom() {
        int iterationCount = 10000;
        this.checkRandom(new Random(1L), (ChunkList<Integer>)new ChunkList(), new ArrayList<Integer>(), 10000);
        Random random = new Random(2L);
        for (int j = 0; j < 10; ++j) {
            this.checkRandom(random, (ChunkList<Integer>)new ChunkList(), new ArrayList<Integer>(), 10000);
        }
        ChunkList chunkList = new ChunkList(Collections.nCopies(1000, 5));
        ArrayList<Integer> referenceList = new ArrayList<Integer>((Collection<Integer>)chunkList);
        this.checkRandom(new Random(3L), (ChunkList<Integer>)chunkList, referenceList, 10000);
    }

    void checkRandom(Random random, ChunkList<Integer> list, List<Integer> list2, int iterationCount) {
        int removeCount = 0;
        int addCount = 0;
        int initialCount = list.size();
        for (int i = 0; i < iterationCount; ++i) {
            assert (list.isValid(true));
            switch (random.nextInt(10)) {
                case 0: {
                    if (list.isEmpty()) break;
                    Assert.assertThat((Object)list2.isEmpty(), (Matcher)CoreMatchers.is((Object)false));
                    list.remove(list.size() - 1);
                    list2.remove(list2.size() - 1);
                    ++removeCount;
                    break;
                }
                case 1: {
                    int e = random.nextInt(1000);
                    list.add((Object)e);
                    list2.add(e);
                    ++addCount;
                    break;
                }
                case 2: {
                    int n = 0;
                    int size = list.size();
                    Assert.assertThat((Object)list.size(), (Matcher)CoreMatchers.is((Object)list2.size()));
                    for (Integer integer : list) {
                        Util.discard((Object)integer);
                        Assert.assertTrue((n++ < size ? 1 : 0) != 0);
                    }
                    break;
                }
                case 3: {
                    int size = list.size();
                    List<Integer> zz = Collections.singletonList(random.nextInt(500));
                    boolean b = list.removeAll(zz);
                    boolean b2 = list2.removeAll(zz);
                    Assert.assertThat((Object)b, (Matcher)CoreMatchers.is((Object)b2));
                    if (b) {
                        Assert.assertTrue((list.size() < size ? 1 : 0) != 0);
                        Assert.assertTrue((list2.size() < size ? 1 : 0) != 0);
                    } else {
                        Assert.assertTrue((list.size() == size ? 1 : 0) != 0);
                        Assert.assertTrue((list2.size() == size ? 1 : 0) != 0);
                    }
                    removeCount += size - list.size();
                    break;
                }
                case 4: {
                    if (list.isEmpty()) break;
                    int e = random.nextInt(list.size());
                    list.remove(e);
                    list2.remove(e);
                    ++removeCount;
                    break;
                }
                case 5: {
                    int count = random.nextInt(list.size() + 1);
                    ListIterator it = list.listIterator();
                    ListIterator<Integer> it2 = list2.listIterator();
                    for (int j = 0; j < count; ++j) {
                        it.next();
                        it2.next();
                    }
                    int size = list.size();
                    it.add(size);
                    it2.add(size);
                    ++addCount;
                    break;
                }
                case 6: {
                    if (random.nextInt(200) != 0) break;
                    removeCount += list.size();
                    list.clear();
                    list2.clear();
                    break;
                }
                default: {
                    int pos = random.nextInt(list.size() + 1);
                    int e = list.size();
                    list.add(pos, (Object)e);
                    list2.add(pos, e);
                    ++addCount;
                }
            }
            Assert.assertEquals((long)list.size(), (long)(initialCount + addCount - removeCount));
            Assert.assertEquals(list, list2);
        }
    }

    @Test
    public void testPerformance() {
        if (!Benchmark.enabled()) {
            return;
        }
        List factories0 = Pair.zip(Arrays.asList(new Function0<List<Integer>>(){

            public List<Integer> apply() {
                return new ArrayList<Integer>();
            }
        }, new Function0<List<Integer>>(){

            public List<Integer> apply() {
                return new LinkedList<Integer>();
            }
        }, new Function0<List<Integer>>(){

            public List<Integer> apply() {
                return new ChunkList();
            }
        }), Arrays.asList("ArrayList", "LinkedList", "ChunkList-64"));
        ArrayList<Pair> factories1 = new ArrayList<Pair>();
        for (Pair pair : factories0) {
            factories1.add(pair);
        }
        List factories = factories1.subList(2, 3);
        List sizes = Pair.zip(Arrays.asList(100000, 1000000, 10000000), Arrays.asList("100k", "1m", "10m"));
        for (final Pair pair : factories) {
            new Benchmark("add 10m values, " + (String)pair.right, (Function1)new Function1<Benchmark.Statistician, Void>(){

                public Void apply(Benchmark.Statistician statistician) {
                    List list = (List)((Function0)pair.left).apply();
                    long start = System.currentTimeMillis();
                    for (int i = 0; i < 10000000; ++i) {
                        list.add(1);
                    }
                    statistician.record(start);
                    return null;
                }
            }, 10).run();
        }
        for (final Pair pair : factories) {
            new Benchmark("iterate over 10m values, " + (String)pair.right, (Function1)new Function1<Benchmark.Statistician, Void>(){

                public Void apply(Benchmark.Statistician statistician) {
                    List list = (List)((Function0)pair.left).apply();
                    list.addAll(Collections.nCopies(10000000, 1));
                    long start = System.currentTimeMillis();
                    int count = 0;
                    for (Integer integer : list) {
                        count += integer.intValue();
                    }
                    statistician.record(start);
                    assert (count == 10000000);
                    return null;
                }
            }, 10).run();
        }
        for (final Pair pair : factories) {
            for (final Pair size : sizes) {
                if ((Integer)size.left > 1000000) continue;
                new Benchmark("delete 10% of " + (String)size.right + " values, " + (String)pair.right, (Function1)new Function1<Benchmark.Statistician, Void>(){

                    public Void apply(Benchmark.Statistician statistician) {
                        List list = (List)((Function0)pair.left).apply();
                        list.addAll(Collections.nCopies((Integer)size.left, 1));
                        long start = System.currentTimeMillis();
                        int n = 0;
                        Iterator it = list.iterator();
                        while (it.hasNext()) {
                            Integer integer = (Integer)it.next();
                            Util.discard((Object)integer);
                            if (n++ % 10 != 0) continue;
                            it.remove();
                        }
                        statistician.record(start);
                        return null;
                    }
                }, 10).run();
            }
        }
        for (final Pair pair : factories) {
            for (final Pair size : sizes) {
                if ((Integer)size.left > 1000000) continue;
                new Benchmark("get from " + (String)size.right + " values, " + (Integer)size.left / 1000 + " times, " + (String)pair.right, (Function1)new Function1<Benchmark.Statistician, Void>(){

                    public Void apply(Benchmark.Statistician statistician) {
                        List list = (List)((Function0)pair.left).apply();
                        list.addAll(Collections.nCopies((Integer)size.left, 1));
                        int probeCount = (Integer)size.left / 1000;
                        Random random = new Random(1L);
                        long start = System.currentTimeMillis();
                        int n = 0;
                        for (int i = 0; i < probeCount; ++i) {
                            n += ((Integer)list.get(random.nextInt(list.size()))).intValue();
                        }
                        assert (n == probeCount);
                        statistician.record(start);
                        return null;
                    }
                }, 10).run();
            }
        }
        for (final Pair pair : factories) {
            for (final Pair size : sizes) {
                if ((Integer)size.left > 1000000) continue;
                new Benchmark("add " + (String)size.right + " values, delete 10%, insert 20%, get 1%, using " + (String)pair.right, (Function1)new Function1<Benchmark.Statistician, Void>(){

                    public Void apply(Benchmark.Statistician statistician) {
                        Integer integer;
                        List list = (List)((Function0)pair.left).apply();
                        int probeCount = (Integer)size.left / 100;
                        long start = System.currentTimeMillis();
                        list.addAll(Collections.nCopies((Integer)size.left, 1));
                        Random random = new Random(1L);
                        Iterator<Integer> it = list.iterator();
                        while (it.hasNext()) {
                            integer = (Integer)it.next();
                            Util.discard((Object)integer);
                            if (random.nextInt(10) != 0) continue;
                            it.remove();
                        }
                        it = list.listIterator();
                        while (it.hasNext()) {
                            integer = (Integer)it.next();
                            Util.discard((Object)integer);
                            if (random.nextInt(5) != 0) continue;
                            it.add(2);
                        }
                        int n = 0;
                        for (int i = 0; i < probeCount; ++i) {
                            n += ((Integer)list.get(random.nextInt(list.size()))).intValue();
                        }
                        assert (n > probeCount);
                        statistician.record(start);
                        return null;
                    }
                }, 10).run();
            }
        }
    }
}

