/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.management.MemoryType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import javax.annotation.Nullable;
import org.apache.calcite.avatica.AvaticaUtils;
import org.apache.calcite.avatica.util.Spaces;
import org.apache.calcite.examples.RelBuilderExample;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.Linq4j;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.linq4j.function.Function1;
import org.apache.calcite.linq4j.function.Parameter;
import org.apache.calcite.runtime.ConsList;
import org.apache.calcite.runtime.FlatLists;
import org.apache.calcite.runtime.Resources;
import org.apache.calcite.runtime.SqlFunctions;
import org.apache.calcite.runtime.Utilities;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.util.SqlBuilder;
import org.apache.calcite.sql.util.SqlString;
import org.apache.calcite.test.DiffTestCase;
import org.apache.calcite.util.Benchmark;
import org.apache.calcite.util.BitSets;
import org.apache.calcite.util.BitString;
import org.apache.calcite.util.Compatible;
import org.apache.calcite.util.CompositeList;
import org.apache.calcite.util.CompositeMap;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.calcite.util.IntegerIntervalSet;
import org.apache.calcite.util.JsonBuilder;
import org.apache.calcite.util.Litmus;
import org.apache.calcite.util.NameMap;
import org.apache.calcite.util.NameMultimap;
import org.apache.calcite.util.NameSet;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.ReflectUtil;
import org.apache.calcite.util.Static;
import org.apache.calcite.util.Template;
import org.apache.calcite.util.TestUtil;
import org.apache.calcite.util.TryThreadLocal;
import org.apache.calcite.util.UnmodifiableArrayList;
import org.apache.calcite.util.Util;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class UtilTest {
    @BeforeClass
    public static void setUSLocale() {
        Locale.setDefault(Locale.US);
    }

    @Test
    public void testPrintEquals() {
        this.assertPrintEquals("\"x\"", "x", true);
    }

    @Test
    public void testPrintEquals2() {
        this.assertPrintEquals("\"x\"", "x", false);
    }

    @Test
    public void testPrintEquals3() {
        this.assertPrintEquals("null", null, true);
    }

    @Test
    public void testPrintEquals4() {
        this.assertPrintEquals("", null, false);
    }

    @Test
    public void testPrintEquals5() {
        this.assertPrintEquals("\"\\\\\\\"\\r\\n\"", "\\\"\r\n", true);
    }

    @Test
    public void testScientificNotation() {
        BigDecimal bd = new BigDecimal("0.001234");
        TestUtil.assertEqualsVerbose("1.234E-3", Util.toScientificNotation((BigDecimal)bd));
        bd = new BigDecimal("0.001");
        TestUtil.assertEqualsVerbose("1E-3", Util.toScientificNotation((BigDecimal)bd));
        bd = new BigDecimal("-0.001");
        TestUtil.assertEqualsVerbose("-1E-3", Util.toScientificNotation((BigDecimal)bd));
        bd = new BigDecimal("1");
        TestUtil.assertEqualsVerbose("1E0", Util.toScientificNotation((BigDecimal)bd));
        bd = new BigDecimal("-1");
        TestUtil.assertEqualsVerbose("-1E0", Util.toScientificNotation((BigDecimal)bd));
        bd = new BigDecimal("1.0");
        TestUtil.assertEqualsVerbose("1.0E0", Util.toScientificNotation((BigDecimal)bd));
        bd = new BigDecimal("12345");
        TestUtil.assertEqualsVerbose("1.2345E4", Util.toScientificNotation((BigDecimal)bd));
        bd = new BigDecimal("12345.00");
        TestUtil.assertEqualsVerbose("1.234500E4", Util.toScientificNotation((BigDecimal)bd));
        bd = new BigDecimal("12345.001");
        TestUtil.assertEqualsVerbose("1.2345001E4", Util.toScientificNotation((BigDecimal)bd));
        bd = new BigDecimal("1.23456789012345678901");
        TestUtil.assertEqualsVerbose("1.2345678901234567890E0", Util.toScientificNotation((BigDecimal)bd));
        bd = new BigDecimal("-1.23456789012345678901");
        TestUtil.assertEqualsVerbose("-1.2345678901234567890E0", Util.toScientificNotation((BigDecimal)bd));
    }

    @Test
    public void testToJavaId() throws UnsupportedEncodingException {
        Assert.assertEquals((Object)"ID$0$foo", (Object)Util.toJavaId((String)"foo", (int)0));
        Assert.assertEquals((Object)"ID$0$foo_20_bar", (Object)Util.toJavaId((String)"foo bar", (int)0));
        Assert.assertEquals((Object)"ID$0$foo__bar", (Object)Util.toJavaId((String)"foo_bar", (int)0));
        Assert.assertEquals((Object)"ID$100$_30_bar", (Object)Util.toJavaId((String)"0bar", (int)100));
        Assert.assertEquals((Object)"ID$0$foo0bar", (Object)Util.toJavaId((String)"foo0bar", (int)0));
        Assert.assertEquals((Object)"ID$0$it_27_s_20_a_20_bird_2c__20_it_27_s_20_a_20_plane_21_", (Object)Util.toJavaId((String)"it's a bird, it's a plane!", (int)0));
        Assert.assertEquals((Object)"ID$0$_f6__cb__c4__ca__ae__c1__f9__cb_", (Object)Util.toJavaId((String)"\u00f6\u00cb\u00c4\u00ca\u00ae\u00c1\u00f9\u00cb", (int)0));
        Assert.assertEquals((Object)"ID$0$_f6cb__c4ca__aec1__f9cb_", (Object)Util.toJavaId((String)"\uf6cb\uc4ca\uaec1\uf9cb", (int)0));
        byte[] bytes1 = new byte[]{3, 12, 54, 23, 33, 23, 45, 21, 127, -34, -92, -113};
        Assert.assertEquals((Object)"ID$0$_3__c_6_17__21__17__2d__15__7f__6cd9__fffd_", (Object)Util.toJavaId((String)new String(bytes1, "EUC-JP"), (int)0));
        byte[] bytes2 = new byte[]{64, 32, 43, -45, -23, 0, 43, 54, 119, -32, -56, -34};
        Assert.assertEquals((Object)"ID$0$_30c__3617__2117__2d15__7fde__a48f_", (Object)Util.toJavaId((String)new String(bytes1, "UTF-16"), (int)0));
    }

    private void assertPrintEquals(String expect, String in, boolean nullMeansNull) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        Util.printJavaString((PrintWriter)pw, (String)in, (boolean)nullMeansNull);
        pw.flush();
        String out = sw.toString();
        Assert.assertEquals((Object)expect, (Object)out);
    }

    @Test
    public void testTokenize() {
        ArrayList<String> list = new ArrayList<String>();
        for (String s : Util.tokenize((String)"abc,de,f", (String)",")) {
            list.add(s);
        }
        Assert.assertThat((Object)list.size(), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat((Object)((Object)list).toString(), (Matcher)CoreMatchers.is((Object)"[abc, de, f]"));
    }

    @Test
    public void testBitString() {
        BitString b0 = new BitString("", 0);
        BitString b1 = new BitString("1", 1);
        BitString b2 = new BitString("10", 2);
        BitString b4 = new BitString("100", 3);
        BitString b8 = new BitString("1000", 4);
        BitString b16 = new BitString("10000", 5);
        BitString b32 = new BitString("100000", 6);
        BitString b64 = new BitString("1000000", 7);
        BitString b128 = new BitString("10000000", 8);
        BitString b256 = new BitString("100000000", 9);
        BitString b0x1 = new BitString("", 1);
        BitString b0x12 = new BitString("", 12);
        Assert.assertEquals((Object)"", (Object)b0.toHexString());
        Assert.assertEquals((Object)"1", (Object)b1.toHexString());
        Assert.assertEquals((Object)"2", (Object)b2.toHexString());
        Assert.assertEquals((Object)"4", (Object)b4.toHexString());
        Assert.assertEquals((Object)"8", (Object)b8.toHexString());
        Assert.assertEquals((Object)"10", (Object)b16.toHexString());
        Assert.assertEquals((Object)"20", (Object)b32.toHexString());
        Assert.assertEquals((Object)"40", (Object)b64.toHexString());
        Assert.assertEquals((Object)"80", (Object)b128.toHexString());
        Assert.assertEquals((Object)"100", (Object)b256.toHexString());
        Assert.assertEquals((Object)"0", (Object)b0x1.toHexString());
        Assert.assertEquals((Object)"000", (Object)b0x12.toHexString());
        this.assertByteArray("01", "1", 1);
        this.assertByteArray("01", "1", 5);
        this.assertByteArray("01", "1", 8);
        this.assertByteArray("00, 01", "1", 9);
        this.assertByteArray("", "", 0);
        this.assertByteArray("00", "0", 1);
        this.assertByteArray("00", "0000", 2);
        this.assertByteArray("00", "000", 5);
        this.assertByteArray("00", "0", 8);
        this.assertByteArray("00, 00", "00", 9);
        UtilTest.assertReversible("");
        UtilTest.assertReversible("1");
        UtilTest.assertReversible("10");
        UtilTest.assertReversible("100");
        UtilTest.assertReversible("1000");
        UtilTest.assertReversible("10000");
        UtilTest.assertReversible("100000");
        UtilTest.assertReversible("1000000");
        UtilTest.assertReversible("10000000");
        UtilTest.assertReversible("100000000");
        UtilTest.assertReversible("01");
        UtilTest.assertReversible("001010");
        UtilTest.assertReversible("000000000100");
    }

    private static void assertReversible(String s) {
        Assert.assertEquals((String)s, (Object)BitString.createFromBitString((String)s).toBitString(), (Object)s);
        Assert.assertEquals((Object)s, (Object)BitString.createFromHexString((String)s).toHexString());
    }

    private void assertByteArray(String expected, String bits, int bitCount) {
        byte[] bytes = BitString.toByteArrayFromBitString((String)bits, (int)bitCount);
        String s = this.toString(bytes);
        Assert.assertEquals((Object)expected, (Object)s);
    }

    private String toString(byte[] bytes) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            if (i > 0) {
                buf.append(", ");
            }
            String s = Integer.toString(b, 16);
            buf.append(b < 16 ? "0" + s : s);
        }
        return buf.toString();
    }

    @Test
    public void testCastingList() {
        ArrayList<Number> numberList = new ArrayList<Number>();
        numberList.add(1);
        numberList.add(null);
        numberList.add(2);
        List integerList = Util.cast(numberList, Integer.class);
        Assert.assertEquals((long)3L, (long)integerList.size());
        Assert.assertEquals((Object)2, integerList.get(2));
        Assert.assertNull(integerList.get(1));
        integerList.set(1, 345);
        Assert.assertEquals((Object)345, integerList.get(1));
        integerList.set(1, null);
        Assert.assertNull(integerList.get(1));
        numberList.add(3.1415);
        Assert.assertEquals((long)4L, (long)integerList.size());
        try {
            integerList.get(3);
            Assert.fail((String)"expected exception");
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    @Test
    public void testCons() {
        String z2;
        List<String> abc0 = Arrays.asList("a", "b", "c");
        List abc = ConsList.of((Object)"a", (List)ImmutableList.of((Object)"b", (Object)"c"));
        Assert.assertThat((Object)abc.size(), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat((Object)abc, (Matcher)CoreMatchers.is(abc0));
        ArrayList bc = Lists.newArrayList((Object[])new String[]{"b", "c"});
        List abc2 = ConsList.of((Object)"a", (List)bc);
        Assert.assertThat((Object)abc2.size(), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat((Object)abc2, (Matcher)CoreMatchers.is(abc0));
        bc.set(0, "z");
        Assert.assertThat((Object)abc2, (Matcher)CoreMatchers.is(abc0));
        List bc3 = ConsList.of((Object)"b", Collections.singletonList("c"));
        List abc3 = ConsList.of((Object)"a", (List)bc3);
        Assert.assertThat((Object)abc3.size(), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat((Object)abc3, (Matcher)CoreMatchers.is(abc0));
        Assert.assertThat((Object)abc3.indexOf("b"), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)abc3.indexOf("z"), (Matcher)CoreMatchers.is((Object)-1));
        Assert.assertThat((Object)abc3.lastIndexOf("b"), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)abc3.lastIndexOf("z"), (Matcher)CoreMatchers.is((Object)-1));
        Assert.assertThat((Object)abc3.hashCode(), (Matcher)CoreMatchers.is((Object)abc0.hashCode()));
        Assert.assertThat(abc3.get(0), (Matcher)CoreMatchers.is((Object)"a"));
        Assert.assertThat(abc3.get(1), (Matcher)CoreMatchers.is((Object)"b"));
        Assert.assertThat(abc3.get(2), (Matcher)CoreMatchers.is((Object)"c"));
        try {
            z2 = (String)abc3.get(3);
            Assert.fail((String)("expected error, got " + z2));
        }
        catch (IndexOutOfBoundsException z2) {
            // empty catch block
        }
        try {
            z2 = (String)abc3.get(-3);
            Assert.fail((String)("expected error, got " + z2));
        }
        catch (IndexOutOfBoundsException z3) {
            // empty catch block
        }
        try {
            z2 = (String)abc3.get(30);
            Assert.fail((String)("expected error, got " + z2));
        }
        catch (IndexOutOfBoundsException z4) {
            // empty catch block
        }
        List a = ConsList.of((Object)"a", (List)ImmutableList.of());
        Assert.assertThat((Object)a.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)a, (Matcher)CoreMatchers.is(Collections.singletonList("a")));
    }

    @Test
    public void testConsPerformance() {
        int n = 2000000;
        int start = 10;
        List<Integer> list = this.makeConsList(10, 2000010);
        Assert.assertThat((Object)list.size(), (Matcher)CoreMatchers.is((Object)2000000));
        Assert.assertThat((Object)list.toString(), (Matcher)CoreMatchers.startsWith((String)"[10, 11, 12, "));
        Assert.assertThat((Object)list.contains(1000010), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)list.contains(4000010), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)list.indexOf(1000010), (Matcher)CoreMatchers.is((Object)1000000));
        Assert.assertThat((Object)list.containsAll(Arrays.asList(1999999, 1999990, 1000000, 10)), (Matcher)CoreMatchers.is((Object)true));
        long total = 0L;
        for (Integer i : list) {
            total += (long)(i - 10);
        }
        Assert.assertThat((Object)total, (Matcher)CoreMatchers.is((Object)1999999000000L));
        Object[] objects = list.toArray();
        Assert.assertThat((Object)objects.length, (Matcher)CoreMatchers.is((Object)2000000));
        Integer[] integers = new Integer[1999999];
        Assert.assertThat((Object)integers.length, (Matcher)CoreMatchers.is((Object)1999999));
        Integer[] integers2 = list.toArray(integers);
        Assert.assertThat((Object)integers2.length, (Matcher)CoreMatchers.is((Object)2000000));
        Assert.assertThat((Object)integers2[0], (Matcher)CoreMatchers.is((Object)10));
        Assert.assertThat((Object)integers2[integers2.length - 1], (Matcher)CoreMatchers.is((Object)2000009));
        Object[] integers3 = list.toArray(integers2);
        Assert.assertThat((Object)integers2, (Matcher)CoreMatchers.sameInstance((Object)integers3));
        Integer[] integers4 = new Integer[2000001];
        Integer[] integers5 = list.toArray(integers4);
        Assert.assertThat((Object)integers5, (Matcher)CoreMatchers.sameInstance((Object)integers4));
        Assert.assertThat((Object)integers5.length, (Matcher)CoreMatchers.is((Object)2000001));
        Assert.assertThat((Object)integers5[0], (Matcher)CoreMatchers.is((Object)10));
        Assert.assertThat((Object)integers5[1999999], (Matcher)CoreMatchers.is((Object)2000009));
        Assert.assertThat((Object)integers5[2000000], (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((Object)list.hashCode(), (Matcher)CoreMatchers.is((Object)Arrays.hashCode(integers3)));
        Assert.assertThat(list, (Matcher)CoreMatchers.is(Arrays.asList(integers3)));
        Assert.assertThat(list, (Matcher)CoreMatchers.is(list));
        Assert.assertThat(Arrays.asList(integers3), (Matcher)CoreMatchers.is(list));
    }

    private List<Integer> makeConsList(int start, int end) {
        List list = null;
        for (int i = end - 1; i >= start; --i) {
            list = i == end - 1 ? Collections.singletonList(i) : ConsList.of((Object)i, list);
        }
        return list;
    }

    @Test
    public void testIterableProperties() {
        Properties properties = new Properties();
        properties.put("foo", "george");
        properties.put("bar", "ringo");
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : Util.toMap((Properties)properties).entrySet()) {
            sb.append((String)entry.getKey()).append("=").append((String)entry.getValue());
            sb.append(";");
        }
        Assert.assertEquals((Object)"bar=ringo;foo=george;", (Object)sb.toString());
        Assert.assertEquals((long)2L, (long)Util.toMap((Properties)properties).entrySet().size());
        properties.put("nonString", (Object)34);
        try {
            for (Map.Entry e : Util.toMap((Properties)properties).entrySet()) {
                String s = (String)e.getValue();
                Util.discard((Object)s);
            }
            Assert.fail((String)"expected exception");
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    @Test
    public void testDiffLines() {
        String[] before = new String[]{"Get a dose of her in jackboots and kilt", "She's killer-diller when she's dressed to the hilt", "She's the kind of a girl that makes The News of The World", "Yes you could say she was attractively built.", "Yeah yeah yeah."};
        String[] after = new String[]{"Get a dose of her in jackboots and kilt", "(they call her \"Polythene Pam\")", "She's killer-diller when she's dressed to the hilt", "She's the kind of a girl that makes The Sunday Times", "seem more interesting.", "Yes you could say she was attractively built."};
        String diff = DiffTestCase.diffLines(Arrays.asList(before), Arrays.asList(after));
        Assert.assertThat((Object)Util.toLinux((String)diff), (Matcher)CoreMatchers.equalTo((Object)"1a2\n> (they call her \"Polythene Pam\")\n3c4,5\n< She's the kind of a girl that makes The News of The World\n---\n> She's the kind of a girl that makes The Sunday Times\n> seem more interesting.\n5d6\n< Yeah yeah yeah.\n"));
    }

    @Test
    public void testPosixTimeZone() {
        Assert.assertEquals((Object)"JST9", (Object)Util.toPosix((TimeZone)TimeZone.getTimeZone("Asia/Tokyo"), (boolean)true));
        String posixTime = Util.toPosix((TimeZone)TimeZone.getTimeZone("Australia/Sydney"), (boolean)true);
        if (posixTime.equals("EST10EST1,M10.5.0/2,M3.5.0/3")) {
            Assert.assertEquals((Object)"EST10EST1,M10.5.0/2,M3.5.0/3", (Object)posixTime);
        } else if (posixTime.equals("EST10EST1,M10.1.0/2,M4.1.0/3")) {
            Assert.assertEquals((Object)"EST10EST1,M10.1.0/2,M4.1.0/3", (Object)posixTime);
        } else {
            Assert.assertEquals((Object)"AEST10AEDT1,M10.1.0/2,M4.1.0/3", (Object)posixTime);
        }
        Assert.assertEquals((Object)"CET1CEST1,M3.5.0/2,M10.5.0/3", (Object)Util.toPosix((TimeZone)TimeZone.getTimeZone("Europe/Paris"), (boolean)true));
        Assert.assertEquals((Object)"UTC0", (Object)Util.toPosix((TimeZone)TimeZone.getTimeZone("UTC"), (boolean)true));
    }

    @Test
    public void testEnumConstants() {
        Map memoryTypeMap = Util.enumConstants(MemoryType.class);
        Assert.assertEquals((long)2L, (long)memoryTypeMap.size());
        Assert.assertEquals((Object)((Object)MemoryType.HEAP), memoryTypeMap.get("HEAP"));
        Assert.assertEquals((Object)((Object)MemoryType.NON_HEAP), memoryTypeMap.get("NON_HEAP"));
        try {
            memoryTypeMap.put("FOO", null);
            Assert.fail((String)"expected exception");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        Assert.assertEquals((Object)"HEAP", (Object)((MemoryType)Util.enumVal(MemoryType.class, (String)"HEAP")).name());
        Assert.assertNull((Object)Util.enumVal(MemoryType.class, (String)"heap"));
        Assert.assertNull((Object)Util.enumVal(MemoryType.class, (String)"nonexistent"));
    }

    @Test
    public void testSqlBuilder() {
        SqlBuilder buf = new SqlBuilder(SqlDialect.CALCITE);
        Assert.assertEquals((long)0L, (long)buf.length());
        buf.append("select ");
        Assert.assertEquals((Object)"select ", (Object)buf.getSql());
        buf.identifier("x");
        Assert.assertEquals((Object)"select \"x\"", (Object)buf.getSql());
        buf.append(", ");
        buf.identifier(new String[]{"y", "a b"});
        Assert.assertEquals((Object)"select \"x\", \"y\".\"a b\"", (Object)buf.getSql());
        SqlString sqlString = buf.toSqlString();
        Assert.assertEquals((Object)SqlDialect.CALCITE, (Object)sqlString.getDialect());
        Assert.assertEquals((Object)buf.getSql(), (Object)sqlString.getSql());
        Assert.assertTrue((buf.getSql().length() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)buf.getSqlAndClear(), (Object)sqlString.getSql());
        Assert.assertEquals((long)0L, (long)buf.length());
        buf.clear();
        Assert.assertEquals((long)0L, (long)buf.length());
        buf.literal("can't get no satisfaction");
        Assert.assertEquals((Object)"'can''t get no satisfaction'", (Object)buf.getSqlAndClear());
        buf.literal(new Timestamp(0L));
        Assert.assertEquals((Object)"TIMESTAMP '1970-01-01 00:00:00'", (Object)buf.getSqlAndClear());
        buf.clear();
        Assert.assertEquals((long)0L, (long)buf.length());
        buf.append("hello world");
        Assert.assertEquals((long)2L, (long)buf.indexOf("l"));
        Assert.assertEquals((long)-1L, (long)buf.indexOf("z"));
        Assert.assertEquals((long)9L, (long)buf.indexOf("l", 5));
    }

    @Test
    public void testCompositeList() {
        String s3;
        CompositeList list = CompositeList.of((List[])new List[0]);
        Assert.assertEquals((long)0L, (long)list.size());
        Assert.assertTrue((boolean)list.isEmpty());
        try {
            String s2 = (String)list.get(0);
            Assert.fail((String)("expected error, got " + s2));
        }
        catch (IndexOutOfBoundsException s2) {
            // empty catch block
        }
        Assert.assertFalse((boolean)list.listIterator().hasNext());
        List listEmpty = Collections.emptyList();
        List<String> listAbc = Arrays.asList("a", "b", "c");
        ArrayList<String> listEmpty2 = new ArrayList<String>();
        list = CompositeList.of(listEmpty, listAbc, listEmpty2);
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertFalse((boolean)list.isEmpty());
        Assert.assertEquals((Object)"a", list.get(0));
        Assert.assertEquals((Object)"c", list.get(2));
        try {
            s3 = (String)list.get(3);
            Assert.fail((String)("expected error, got " + s3));
        }
        catch (IndexOutOfBoundsException s3) {
            // empty catch block
        }
        try {
            s3 = list.set(0, "z");
            Assert.fail((String)("expected error, got " + s3));
        }
        catch (UnsupportedOperationException s4) {
            // empty catch block
        }
        Iterator iterator = list.iterator();
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((Object)"a", iterator.next());
        Assert.assertEquals((Object)"b", iterator.next());
        Assert.assertTrue((boolean)iterator.hasNext());
        try {
            iterator.remove();
            Assert.fail((String)"expected error");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        Assert.assertEquals((Object)"c", iterator.next());
        Assert.assertFalse((boolean)iterator.hasNext());
        listEmpty2.add("zz");
        Assert.assertEquals((long)4L, (long)list.size());
        Assert.assertEquals((Object)"zz", list.get(3));
        String ss = "";
        for (String s5 : CompositeList.of((List)list, (List)list)) {
            ss = ss + s5;
        }
        Assert.assertEquals((Object)"abczzabczz", (Object)ss);
    }

    @Test
    public void testTemplate() {
        Assert.assertThat((Object)new MessageFormat("Hello, {0}, what a nice {1}.", Locale.ROOT).format(new Object[]{"world", "day"}), (Matcher)CoreMatchers.is((Object)"Hello, world, what a nice day."));
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        map.put("person", "world");
        map.put("time", "day");
        Assert.assertEquals((Object)"Hello, world, what a nice day.", (Object)Template.formatByName((String)"Hello, {person}, what a nice {time}.", map));
        Template template = Template.of((String)"Happy {age,number,#.00}th birthday, {person}!");
        map.clear();
        map.put("person", "Ringo");
        map.put("age", 64.5);
        Assert.assertEquals((Object)"Happy 64.50th birthday, Ringo!", (Object)template.format(map));
        map.remove("person");
        Assert.assertEquals((Object)"Happy 64.50th birthday, null!", (Object)template.format(map));
        map.clear();
        map.put(1, "Ringo");
        map.put("0", 64.5);
        Assert.assertEquals((Object)"Happy 64.50th birthday, Ringo!", (Object)template.format(map));
        map.put("lastName", "Starr");
        map.put("homeTown", "Liverpool");
        Assert.assertEquals((Object)"Happy 64.50th birthday, Ringo!", (Object)template.format(map));
        Assert.assertEquals(Arrays.asList("age", "person"), (Object)template.getParameterNames());
        Template template2 = Template.of((String)"Don''t expand 'this {brace}'.");
        Assert.assertEquals(Collections.emptyList(), (Object)template2.getParameterNames());
        Assert.assertEquals((Object)"Don't expand this {brace}.", (Object)template2.format(Collections.emptyMap()));
        Assert.assertEquals((Object)"", (Object)Template.formatByName((String)"", map));
    }

    @Test
    public void testParseLocale() {
        String[] localeNames;
        Locale[] locales;
        for (Locale locale : locales = new Locale[]{Locale.CANADA, Locale.CANADA_FRENCH, Locale.getDefault(), Locale.US, Locale.TRADITIONAL_CHINESE}) {
            Assert.assertEquals((Object)locale, (Object)Util.parseLocale((String)locale.toString()));
        }
        for (String localeName : localeNames = new String[]{"en", "de_DE", "_GB", "en_US_WIN", "de__POSIX", "fr__MAC"}) {
            Assert.assertEquals((Object)localeName, (Object)Util.parseLocale((String)localeName).toString());
        }
    }

    @Test
    public void testSpaces() {
        Assert.assertEquals((Object)"", (Object)Spaces.of((int)0));
        Assert.assertEquals((Object)" ", (Object)Spaces.of((int)1));
        Assert.assertEquals((Object)" ", (Object)Spaces.of((int)1));
        Assert.assertEquals((Object)"         ", (Object)Spaces.of((int)9));
        Assert.assertEquals((Object)"     ", (Object)Spaces.of((int)5));
        Assert.assertEquals((long)1000L, (long)Spaces.of((int)1000).length());
    }

    @Test
    public void testSpaceString() {
        Assert.assertThat((Object)Spaces.sequence((int)0).toString(), (Matcher)CoreMatchers.equalTo((Object)""));
        Assert.assertThat((Object)Spaces.sequence((int)1).toString(), (Matcher)CoreMatchers.equalTo((Object)" "));
        Assert.assertThat((Object)Spaces.sequence((int)9).toString(), (Matcher)CoreMatchers.equalTo((Object)"         "));
        Assert.assertThat((Object)Spaces.sequence((int)5).toString(), (Matcher)CoreMatchers.equalTo((Object)"     "));
        String s = new StringBuilder().append("xx").append(Spaces.MAX, 0, 100).toString();
        Assert.assertThat((Object)s.length(), (Matcher)CoreMatchers.equalTo((Object)102));
        Assert.assertThat((Object)Spaces.sequence((int)1000000000).length(), (Matcher)CoreMatchers.equalTo((Object)1000000000));
        StringWriter sw = new StringWriter();
        Spaces.append((StringWriter)sw, (int)4);
        Assert.assertThat((Object)sw.toString(), (Matcher)CoreMatchers.equalTo((Object)"    "));
        StringBuilder buf = new StringBuilder();
        Spaces.append((StringBuilder)buf, (int)4);
        Assert.assertThat((Object)buf.toString(), (Matcher)CoreMatchers.equalTo((Object)"    "));
        Assert.assertThat((Object)Spaces.padLeft((String)"xy", (int)5), (Matcher)CoreMatchers.equalTo((Object)"   xy"));
        Assert.assertThat((Object)Spaces.padLeft((String)"abcde", (int)5), (Matcher)CoreMatchers.equalTo((Object)"abcde"));
        Assert.assertThat((Object)Spaces.padLeft((String)"abcdef", (int)5), (Matcher)CoreMatchers.equalTo((Object)"abcdef"));
        Assert.assertThat((Object)Spaces.padRight((String)"xy", (int)5), (Matcher)CoreMatchers.equalTo((Object)"xy   "));
        Assert.assertThat((Object)Spaces.padRight((String)"abcde", (int)5), (Matcher)CoreMatchers.equalTo((Object)"abcde"));
        Assert.assertThat((Object)Spaces.padRight((String)"abcdef", (int)5), (Matcher)CoreMatchers.equalTo((Object)"abcdef"));
    }

    @Test
    public void testPairZip() {
        List<String> strings = Arrays.asList("paul", "george", "john", "ringo");
        List<Integer> integers = Arrays.asList(1942, 1943, 1940);
        List zip = Pair.zip(strings, integers);
        Assert.assertEquals((long)3L, (long)zip.size());
        Assert.assertEquals((Object)"paul:1942", (Object)((String)((Pair)zip.get((int)0)).left + ":" + ((Pair)zip.get((int)0)).right));
        Assert.assertEquals((Object)"john", (Object)((Pair)zip.get((int)2)).left);
        int x = 0;
        for (Pair pair : zip) {
            x += ((Integer)pair.right).intValue();
        }
        Assert.assertEquals((long)5825L, (long)x);
    }

    @Test
    public void testPairAdjacents() {
        List<String> strings = Arrays.asList("a", "b", "c");
        ArrayList<String> result = new ArrayList<String>();
        for (Pair pair : Pair.adjacents(strings)) {
            result.add(pair.toString());
        }
        Assert.assertThat((Object)((Object)result).toString(), (Matcher)CoreMatchers.equalTo((Object)"[<a, b>, <b, c>]"));
        Assert.assertThat((Object)Pair.adjacents((Iterable)ImmutableList.of()).iterator().hasNext(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)Pair.adjacents((Iterable)ImmutableList.of((Object)"a")).iterator().hasNext(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)Iterables.size((Iterable)Pair.adjacents(Collections.nCopies(100, null))), (Matcher)CoreMatchers.equalTo((Object)99));
    }

    @Test
    public void testPairFirstAnd() {
        List<String> strings = Arrays.asList("a", "b", "c");
        ArrayList<String> result = new ArrayList<String>();
        for (Pair pair : Pair.firstAnd(strings)) {
            result.add(pair.toString());
        }
        Assert.assertThat((Object)((Object)result).toString(), (Matcher)CoreMatchers.equalTo((Object)"[<a, b>, <a, c>]"));
        Assert.assertThat((Object)Pair.firstAnd((Iterable)ImmutableList.of()).iterator().hasNext(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)Pair.firstAnd((Iterable)ImmutableList.of((Object)"a")).iterator().hasNext(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)Iterables.size((Iterable)Pair.firstAnd(Collections.nCopies(100, null))), (Matcher)CoreMatchers.equalTo((Object)99));
    }

    @Test
    public void testQuotientList() {
        List listBad2;
        List<String> beatles = Arrays.asList("john", "paul", "george", "ringo");
        List list0 = Util.quotientList(beatles, (int)3, (int)0);
        Assert.assertEquals((long)2L, (long)list0.size());
        Assert.assertEquals((Object)"john", list0.get(0));
        Assert.assertEquals((Object)"ringo", list0.get(1));
        List list1 = Util.quotientList(beatles, (int)3, (int)1);
        Assert.assertEquals((long)1L, (long)list1.size());
        Assert.assertEquals((Object)"paul", list1.get(0));
        List list2 = Util.quotientList(beatles, (int)3, (int)2);
        Assert.assertEquals((long)1L, (long)list2.size());
        Assert.assertEquals((Object)"george", list2.get(0));
        try {
            listBad2 = Util.quotientList(beatles, (int)3, (int)4);
            Assert.fail((String)("Expected error, got " + listBad2));
        }
        catch (IllegalArgumentException listBad2) {
            // empty catch block
        }
        try {
            listBad2 = Util.quotientList(beatles, (int)3, (int)3);
            Assert.fail((String)("Expected error, got " + listBad2));
        }
        catch (IllegalArgumentException listBad3) {
            // empty catch block
        }
        try {
            listBad2 = Util.quotientList(beatles, (int)0, (int)0);
            Assert.fail((String)("Expected error, got " + listBad2));
        }
        catch (IllegalArgumentException listBad4) {
            // empty catch block
        }
        List empty = Collections.emptyList();
        List list3 = Util.quotientList(empty, (int)7, (int)2);
        Assert.assertEquals((long)0L, (long)list3.size());
        List list4 = Util.quotientList(beatles, (int)10, (int)0);
        Assert.assertEquals((long)1L, (long)list4.size());
        Assert.assertEquals((Object)"john", list4.get(0));
        List list5 = Util.quotientList(beatles, (int)10, (int)5);
        Assert.assertEquals((long)0L, (long)list5.size());
    }

    @Test
    public void testImmutableIntList() {
        ImmutableIntList list = ImmutableIntList.of();
        Assert.assertEquals((long)0L, (long)list.size());
        Assert.assertEquals((Object)list, Collections.emptyList());
        Assert.assertThat((Object)list.toString(), (Matcher)CoreMatchers.equalTo((Object)"[]"));
        Assert.assertThat((Object)BitSets.of((ImmutableIntList)list), (Matcher)CoreMatchers.equalTo((Object)new BitSet()));
        ImmutableIntList list2 = ImmutableIntList.of((int[])new int[]{1, 3, 5});
        Assert.assertEquals((long)3L, (long)list2.size());
        Assert.assertEquals((Object)"[1, 3, 5]", (Object)list2.toString());
        Assert.assertEquals((long)list2.hashCode(), (long)Arrays.asList(1, 3, 5).hashCode());
        Integer[] integers = (Integer[])list2.toArray((Object[])new Integer[3]);
        Assert.assertEquals((long)1L, (long)integers[0].intValue());
        Assert.assertEquals((long)3L, (long)integers[1].intValue());
        Assert.assertEquals((long)5L, (long)integers[2].intValue());
        Assert.assertThat((Object)list.equals((Object)list), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)list.equals((Object)list2), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)list2.equals((Object)list), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)list2.equals((Object)list2), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testIntegerIntervalSet() {
        this.checkIntegerIntervalSet("1,5", 1, 5);
        this.checkIntegerIntervalSet("", new int[0]);
        this.checkIntegerIntervalSet("2,4,-1-5", new int[0]);
        this.checkIntegerIntervalSet("1-6,-3-5,4,9", 1, 2, 4, 6, 9);
        this.checkIntegerIntervalSet("1,3,1,2-4,-2,-4", 1, 3);
    }

    private List<Integer> checkIntegerIntervalSet(String s, int ... ints) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        Set set = IntegerIntervalSet.of((String)s);
        Assert.assertEquals((long)set.size(), (long)ints.length);
        for (Integer integer : set) {
            list.add(integer);
        }
        Assert.assertEquals(new HashSet(Ints.asList((int[])ints)), (Object)set);
        return list;
    }

    @Test
    public void testFlatList() {
        FlatLists.ComparableList emp = FlatLists.of();
        List emp0 = Collections.emptyList();
        Assert.assertEquals((Object)emp, emp0);
        Assert.assertEquals((long)emp.hashCode(), (long)emp0.hashCode());
        List ab = FlatLists.of((Object)"A", (Object)"B");
        List<String> ab0 = Arrays.asList("A", "B");
        Assert.assertEquals((Object)ab, ab0);
        Assert.assertEquals((long)ab.hashCode(), (long)ab0.hashCode());
        List abc = FlatLists.of((Object)"A", (Object)"B", (Object)"C");
        List<String> abc0 = Arrays.asList("A", "B", "C");
        Assert.assertEquals((Object)abc, abc0);
        Assert.assertEquals((long)abc.hashCode(), (long)abc0.hashCode());
        List abc1 = FlatLists.of((Object)"A", (Object)"B", (Object)"C");
        Assert.assertEquals((Object)abc1, abc0);
        Assert.assertEquals((Object)abc, abc0);
        Assert.assertEquals((long)abc1.hashCode(), (long)abc0.hashCode());
        List an = FlatLists.of((Object)"A", null);
        List<String> an0 = Arrays.asList("A", null);
        Assert.assertEquals((Object)an, an0);
        Assert.assertEquals((long)an.hashCode(), (long)an0.hashCode());
        List anb = FlatLists.of((Object)"A", null, (Object)"B");
        List<String> anb0 = Arrays.asList("A", null, "B");
        Assert.assertEquals((Object)anb, anb0);
        Assert.assertEquals((long)anb.hashCode(), (long)anb0.hashCode());
        Assert.assertThat((Object)emp, (Matcher)CoreMatchers.instanceOf(Comparable.class));
        Assert.assertThat((Object)ab, (Matcher)CoreMatchers.instanceOf(Comparable.class));
        Comparable cemp = (Comparable)emp;
        Comparable cab = (Comparable)((Object)ab);
        Assert.assertThat((Object)cemp.compareTo(emp), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)(cemp.compareTo(ab) < 0 ? 1 : 0), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)cab.compareTo(ab), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)(cab.compareTo(emp) > 0 ? 1 : 0), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)(cab.compareTo(anb) > 0 ? 1 : 0), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testFlatList2() {
        this.checkFlatList(0);
        this.checkFlatList(1);
        this.checkFlatList(2);
        this.checkFlatList(3);
        this.checkFlatList(4);
        this.checkFlatList(5);
        this.checkFlatList(6);
        this.checkFlatList(7);
    }

    private void checkFlatList(int n) {
        List eNull;
        List emp1;
        Object emp;
        switch (n) {
            case 0: {
                emp = FlatLists.of();
                emp1 = FlatLists.copyOf((Object[])new Object[0]);
                eNull = null;
                break;
            }
            case 1: {
                emp = FlatLists.of((Object)"A");
                emp1 = FlatLists.copyOf((Object[])new Object[]{"A"});
                eNull = null;
                break;
            }
            case 2: {
                emp = FlatLists.of((Object)"A", (Object)"B");
                emp1 = FlatLists.of((Object)"A", (Object)"B");
                eNull = FlatLists.of((Object)"A", null);
                break;
            }
            case 3: {
                emp = FlatLists.of((Object)"A", (Object)"B", (Object)"C");
                emp1 = FlatLists.copyOf((Object[])new Object[]{"A", "B", "C"});
                eNull = FlatLists.of((Object)"A", null, (Object)"C");
                break;
            }
            case 4: {
                emp = FlatLists.of((Object)"A", (Object)"B", (Object)"C", (Object)"D");
                emp1 = FlatLists.copyOf((Object[])new Object[]{"A", "B", "C", "D"});
                eNull = FlatLists.of((Object)"A", null, (Object)"C", (Object)"D");
                break;
            }
            case 5: {
                emp = FlatLists.of((Object)"A", (Object)"B", (Object)"C", (Object)"D", (Object)"E");
                emp1 = FlatLists.copyOf((Object[])new Object[]{"A", "B", "C", "D", "E"});
                eNull = FlatLists.of((Object)"A", null, (Object)"C", (Object)"D", (Object)"E");
                break;
            }
            case 6: {
                emp = FlatLists.of((Object)"A", (Object)"B", (Object)"C", (Object)"D", (Object)"E", (Object)"F");
                emp1 = FlatLists.copyOf((Object[])new Object[]{"A", "B", "C", "D", "E", "F"});
                eNull = FlatLists.of((Object)"A", null, (Object)"C", (Object)"D", (Object)"E", (Object)"F");
                break;
            }
            case 7: {
                emp = FlatLists.of((Comparable[])new String[]{"A", "B", "C", "D", "E", "F", "G"});
                emp1 = FlatLists.copyOf((Object[])new Object[]{"A", "B", "C", "D", "E", "F", "G"});
                eNull = FlatLists.of((Comparable[])new String[]{"A", null, "C", "D", "E", "F", "G"});
                break;
            }
            default: {
                throw new AssertionError(n);
            }
        }
        List<String> emp0 = Arrays.asList("A", "B", "C", "D", "E", "F", "G").subList(0, n);
        List<String> eNull0 = Arrays.asList("A", null, "C", "D", "E", "F", "G").subList(0, n);
        Assert.assertEquals((Object)emp, emp0);
        Assert.assertEquals((Object)emp, (Object)emp1);
        Assert.assertEquals(emp0, (Object)emp1);
        Assert.assertEquals((Object)emp1, emp0);
        Assert.assertEquals((long)emp.hashCode(), (long)emp0.hashCode());
        Assert.assertEquals((long)emp.hashCode(), (long)emp1.hashCode());
        Assert.assertThat((Object)emp.size(), (Matcher)CoreMatchers.is((Object)n));
        if (eNull != null) {
            Assert.assertThat((Object)eNull.size(), (Matcher)CoreMatchers.is((Object)n));
        }
        List an = FlatLists.of((Object)"A", null);
        List<String> an0 = Arrays.asList("A", null);
        Assert.assertEquals((Object)an, an0);
        Assert.assertEquals((long)an.hashCode(), (long)an0.hashCode());
        if (eNull != null) {
            Assert.assertEquals((Object)eNull, eNull0);
            Assert.assertEquals((long)eNull.hashCode(), (long)eNull0.hashCode());
        }
        Assert.assertThat((Object)emp.toString(), (Matcher)CoreMatchers.is((Object)emp1.toString()));
        if (eNull != null) {
            Assert.assertThat((Object)eNull.toString().length(), (Matcher)CoreMatchers.is((Object)(emp1.toString().length() + 3)));
        }
        Assert.assertThat((Object)emp, (Matcher)CoreMatchers.instanceOf(Comparable.class));
        if (n < 7) {
            Assert.assertThat((Object)emp1, (Matcher)CoreMatchers.instanceOf(Comparable.class));
        }
        if (eNull != null) {
            Assert.assertThat((Object)eNull, (Matcher)CoreMatchers.instanceOf(Comparable.class));
        }
        Comparable cemp = (Comparable)emp;
        Assert.assertThat((Object)cemp.compareTo(emp), (Matcher)CoreMatchers.is((Object)0));
        if (eNull != null) {
            Assert.assertThat((Object)(cemp.compareTo(eNull) < 0 ? 1 : 0), (Matcher)CoreMatchers.is((Object)false));
        }
    }

    private <E> List<E> l1(E e) {
        return Collections.singletonList(e);
    }

    private <E> List<E> l2(E e0, E e1) {
        return Arrays.asList(e0, e1);
    }

    private <E> List<E> l3(E e0, E e1, E e2) {
        return Arrays.asList(e0, e1, e2);
    }

    @Test
    public void testFlatListProduct() {
        ArrayList<Enumerator> list = new ArrayList<Enumerator>();
        list.add(Linq4j.enumerator(this.l2(this.l1("a"), this.l1("b"))));
        list.add(Linq4j.enumerator(this.l3(this.l2("x", "p"), this.l2("y", "q"), this.l2("z", "r"))));
        Enumerable product = SqlFunctions.product(list, (int)3, (boolean)false);
        int n = 0;
        FlatLists.ComparableList previous = FlatLists.of();
        for (FlatLists.ComparableList strings : product) {
            if (n++ == 1) {
                Assert.assertThat((Object)strings.size(), (Matcher)CoreMatchers.is((Object)3));
                Assert.assertThat((Object)strings.get(0), (Matcher)CoreMatchers.is((Object)"a"));
                Assert.assertThat((Object)strings.get(1), (Matcher)CoreMatchers.is((Object)"y"));
                Assert.assertThat((Object)strings.get(2), (Matcher)CoreMatchers.is((Object)"q"));
            }
            if (previous != null) {
                Assert.assertTrue((previous.compareTo((Object)strings) < 0 ? 1 : 0) != 0);
            }
            previous = strings;
        }
        Assert.assertThat((Object)n, (Matcher)CoreMatchers.is((Object)6));
    }

    @Test
    public void testToCamelCase() {
        Assert.assertEquals((Object)"myJdbcDriver", (Object)AvaticaUtils.toCamelCase((String)"MY_JDBC_DRIVER"));
        Assert.assertEquals((Object)"myJdbcDriver", (Object)AvaticaUtils.toCamelCase((String)"MY_JDBC__DRIVER"));
        Assert.assertEquals((Object)"myJdbcDriver", (Object)AvaticaUtils.toCamelCase((String)"my_jdbc_driver"));
        Assert.assertEquals((Object)"abCdefGHij", (Object)AvaticaUtils.toCamelCase((String)"ab_cdEf_g_Hij"));
        Assert.assertEquals((Object)"JdbcDriver", (Object)AvaticaUtils.toCamelCase((String)"_JDBC_DRIVER"));
        Assert.assertEquals((Object)"", (Object)AvaticaUtils.toCamelCase((String)"_"));
        Assert.assertEquals((Object)"", (Object)AvaticaUtils.toCamelCase((String)""));
    }

    @Test
    public void testCamelToUpper() {
        Assert.assertEquals((Object)"MY_JDBC_DRIVER", (Object)AvaticaUtils.camelToUpper((String)"myJdbcDriver"));
        Assert.assertEquals((Object)"MY_J_D_B_C_DRIVER", (Object)AvaticaUtils.camelToUpper((String)"myJDBCDriver"));
        Assert.assertEquals((Object)"AB_CDEF_G_HIJ", (Object)AvaticaUtils.camelToUpper((String)"abCdefGHij"));
        Assert.assertEquals((Object)"_JDBC_DRIVER", (Object)AvaticaUtils.camelToUpper((String)"JdbcDriver"));
        Assert.assertEquals((Object)"", (Object)AvaticaUtils.camelToUpper((String)""));
    }

    @Test
    public void testDistinct() {
        Assert.assertTrue((boolean)Util.isDistinct(Collections.emptyList()));
        Assert.assertTrue((boolean)Util.isDistinct(Arrays.asList("a")));
        Assert.assertTrue((boolean)Util.isDistinct(Arrays.asList("a", "b", "c")));
        Assert.assertFalse((boolean)Util.isDistinct(Arrays.asList("a", "b", "a")));
        Assert.assertTrue((boolean)Util.isDistinct(Arrays.asList("a", "b", null)));
        Assert.assertFalse((boolean)Util.isDistinct(Arrays.asList("a", null, "b", null)));
    }

    @Test
    public void testIntersects() {
        List empty = Collections.emptyList();
        List<String> listA = Collections.singletonList("a");
        List<String> listC = Collections.singletonList("c");
        List<String> listD = Collections.singletonList("d");
        List<String> listAbc = Arrays.asList("a", "b", "c");
        Assert.assertThat((Object)Util.intersects(empty, listA), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)Util.intersects(empty, empty), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)Util.intersects(listA, listAbc), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)Util.intersects(listAbc, listAbc), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)Util.intersects(listAbc, listC), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)Util.intersects(listAbc, listD), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)Util.intersects(listC, listD), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testJsonBuilder() {
        JsonBuilder builder = new JsonBuilder();
        Map map = builder.map();
        map.put("foo", 1);
        map.put("baz", true);
        map.put("bar", "can't");
        List list = builder.list();
        map.put("list", list);
        list.add(2);
        list.add(3);
        list.add(builder.list());
        list.add(builder.map());
        list.add(null);
        map.put("nullValue", null);
        Assert.assertEquals((Object)"{\n  \"foo\": 1,\n  \"baz\": true,\n  \"bar\": \"can't\",\n  \"list\": [\n    2,\n    3,\n    [],\n    {},\n    null\n  ],\n  \"nullValue\": null\n}", (Object)builder.toJsonString((Object)map));
    }

    @Test
    public void testCompositeMap() {
        String[] beatles = new String[]{"john", "paul", "george", "ringo"};
        LinkedHashMap<String, Integer> beatleMap = new LinkedHashMap<String, Integer>();
        for (String beatle : beatles) {
            beatleMap.put(beatle, beatle.length());
        }
        CompositeMap map = CompositeMap.of(beatleMap, (Map[])new Map[0]);
        this.checkCompositeMap(beatles, (Map<String, Integer>)map);
        map = CompositeMap.of(beatleMap, (Map[])new Map[]{Collections.emptyMap()});
        this.checkCompositeMap(beatles, (Map<String, Integer>)map);
        map = CompositeMap.of(Collections.emptyMap(), (Map[])new Map[]{beatleMap});
        this.checkCompositeMap(beatles, (Map<String, Integer>)map);
        map = CompositeMap.of(beatleMap, (Map[])new Map[]{beatleMap});
        this.checkCompositeMap(beatles, (Map<String, Integer>)map);
        LinkedHashMap<String, Integer> founderMap = new LinkedHashMap<String, Integer>();
        founderMap.put("ben", 1706);
        founderMap.put("george", 1732);
        founderMap.put("thomas", 1743);
        map = CompositeMap.of(beatleMap, (Map[])new Map[]{founderMap});
        Assert.assertThat((Object)map.isEmpty(), (Matcher)CoreMatchers.equalTo((Object)false));
        Assert.assertThat((Object)map.size(), (Matcher)CoreMatchers.equalTo((Object)6));
        Assert.assertThat((Object)map.keySet().size(), (Matcher)CoreMatchers.equalTo((Object)6));
        Assert.assertThat((Object)map.entrySet().size(), (Matcher)CoreMatchers.equalTo((Object)6));
        Assert.assertThat((Object)map.values().size(), (Matcher)CoreMatchers.equalTo((Object)6));
        Assert.assertThat((Object)map.containsKey((Object)"john"), (Matcher)CoreMatchers.equalTo((Object)true));
        Assert.assertThat((Object)map.containsKey((Object)"george"), (Matcher)CoreMatchers.equalTo((Object)true));
        Assert.assertThat((Object)map.containsKey((Object)"ben"), (Matcher)CoreMatchers.equalTo((Object)true));
        Assert.assertThat((Object)map.containsKey((Object)"andrew"), (Matcher)CoreMatchers.equalTo((Object)false));
        Assert.assertThat((Object)map.get((Object)"ben"), (Matcher)CoreMatchers.equalTo((Object)1706));
        Assert.assertThat((Object)map.get((Object)"george"), (Matcher)CoreMatchers.equalTo((Object)6));
        Assert.assertThat((Object)map.values().contains(1743), (Matcher)CoreMatchers.equalTo((Object)true));
        Assert.assertThat((Object)map.values().contains(1732), (Matcher)CoreMatchers.equalTo((Object)false));
        Assert.assertThat((Object)map.values().contains(1999), (Matcher)CoreMatchers.equalTo((Object)false));
    }

    private void checkCompositeMap(String[] beatles, Map<String, Integer> map) {
        Assert.assertThat((Object)4, (Matcher)CoreMatchers.equalTo((Object)map.size()));
        Assert.assertThat((Object)false, (Matcher)CoreMatchers.equalTo((Object)map.isEmpty()));
        Assert.assertThat(map.keySet(), (Matcher)CoreMatchers.equalTo(new HashSet<String>(Arrays.asList(beatles))));
        Assert.assertThat((Object)ImmutableMultiset.copyOf(map.values()), (Matcher)CoreMatchers.equalTo((Object)ImmutableMultiset.copyOf(Arrays.asList(4, 4, 6, 5))));
    }

    @Test
    public void testCommaList() {
        try {
            String s = Util.commaList(null);
            Assert.fail((String)("expected NPE, got " + s));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        Assert.assertThat((Object)Util.commaList((List)ImmutableList.of()), (Matcher)CoreMatchers.equalTo((Object)""));
        Assert.assertThat((Object)Util.commaList((List)ImmutableList.of((Object)1)), (Matcher)CoreMatchers.equalTo((Object)"1"));
        Assert.assertThat((Object)Util.commaList((List)ImmutableList.of((Object)2, (Object)3)), (Matcher)CoreMatchers.equalTo((Object)"2, 3"));
        Assert.assertThat((Object)Util.commaList(Arrays.asList(2, null, 3)), (Matcher)CoreMatchers.equalTo((Object)"2, null, 3"));
    }

    @Test
    public void testFirstDuplicate() {
        Assert.assertThat((Object)Util.firstDuplicate((List)ImmutableList.of()), (Matcher)CoreMatchers.equalTo((Object)-1));
        Assert.assertThat((Object)Util.firstDuplicate((List)ImmutableList.of((Object)5)), (Matcher)CoreMatchers.equalTo((Object)-1));
        Assert.assertThat((Object)Util.firstDuplicate((List)ImmutableList.of((Object)5, (Object)6)), (Matcher)CoreMatchers.equalTo((Object)-1));
        Assert.assertThat((Object)Util.firstDuplicate((List)ImmutableList.of((Object)5, (Object)6, (Object)5)), (Matcher)CoreMatchers.equalTo((Object)2));
        Assert.assertThat((Object)Util.firstDuplicate((List)ImmutableList.of((Object)5, (Object)5, (Object)6)), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)Util.firstDuplicate((List)ImmutableList.of((Object)5, (Object)5, (Object)6, (Object)5)), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)Util.firstDuplicate((List)ImmutableList.of((Object)0, (Object)1, (Object)2, (Object)3, (Object)4, (Object)5, (Object)6, (Object)7, (Object)8, (Object)9, (Object)10, (Object)11, (Object[])new Integer[]{12, 13, 14, 15, 16, 17, 3, 19, 3, 21})), (Matcher)CoreMatchers.equalTo((Object)18));
    }

    @Test
    public void testIsDistinctBenchmark() {
        final int limit = Benchmark.enabled() ? 1000000 : 10;
        int zMax = 100;
        for (int i = 0; i < 30; ++i) {
            final int size = i;
            new Benchmark("isDistinct " + i + " (set)", (Function1)new Function1<Benchmark.Statistician, Void>(){

                public Void apply(Benchmark.Statistician statistician) {
                    Random random = new Random(0L);
                    ArrayList lists = new ArrayList();
                    for (int z = 0; z < 100; ++z) {
                        ArrayList<Integer> list = new ArrayList<Integer>();
                        for (int k = 0; k < size; ++k) {
                            list.add(random.nextInt(size * size));
                        }
                        lists.add(list);
                    }
                    long nanos = System.nanoTime();
                    int n = 0;
                    for (int j = 0; j < limit; ++j) {
                        n += Util.firstDuplicate((List)((List)lists.get(j % 100)));
                    }
                    statistician.record(nanos);
                    Util.discard((int)n);
                    return null;
                }
            }, 5).run();
        }
    }

    @Test
    public void testHash() {
        this.checkHash(0.0);
        this.checkHash(1.0);
        this.checkHash(-2.5);
        this.checkHash(3.3333333333333335);
        this.checkHash(Double.NEGATIVE_INFINITY);
        this.checkHash(Double.POSITIVE_INFINITY);
        this.checkHash(Double.MAX_VALUE);
        this.checkHash(Double.MIN_VALUE);
    }

    public void checkHash(double v) {
        Assert.assertThat((Object)Double.valueOf(v).hashCode(), (Matcher)CoreMatchers.is((Object)Utilities.hashCode((double)v)));
        long long_ = (long)v;
        Assert.assertThat((Object)Long.valueOf(long_).hashCode(), (Matcher)CoreMatchers.is((Object)Utilities.hashCode((long)long_)));
        float float_ = (float)v;
        Assert.assertThat((Object)Float.valueOf(float_).hashCode(), (Matcher)CoreMatchers.is((Object)Utilities.hashCode((float)float_)));
        boolean boolean_ = v != 0.0;
        Assert.assertThat((Object)Boolean.valueOf(boolean_).hashCode(), (Matcher)CoreMatchers.is((Object)Utilities.hashCode((boolean)boolean_)));
    }

    @Test
    public void testStartsWithList() {
        Assert.assertThat((Object)Util.startsWith(this.list("x"), this.list(new String[0])), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)Util.startsWith(this.list("x"), this.list("x")), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)Util.startsWith(this.list("x"), this.list("y")), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)Util.startsWith(this.list("x"), this.list("x", "y")), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)Util.startsWith(this.list("x", "y"), this.list("x")), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)Util.startsWith(this.list(new String[0]), this.list(new String[0])), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)Util.startsWith(this.list(new String[0]), this.list("x")), (Matcher)CoreMatchers.is((Object)false));
    }

    public List<String> list(String ... xs) {
        return Arrays.asList(xs);
    }

    @Test
    public void testResources() {
        Resources.validate((Object)Static.RESOURCE);
        this.checkResourceMethodNames(Static.RESOURCE);
    }

    private void checkResourceMethodNames(Object resource) {
        for (Method method : resource.getClass().getMethods()) {
            if (Modifier.isStatic(method.getModifiers()) || method.getName().matches("^[a-z][A-Za-z0-9_]*$")) continue;
            Assert.fail((String)("resource method name must be camel case: " + method.getName()));
        }
    }

    @Test
    public void testSortedSet() {
        TreeSet treeSet = new TreeSet();
        Collections.addAll(treeSet, "foo", "bar", "fOo", "FOO", "pug");
        Assert.assertThat((Object)treeSet.size(), (Matcher)CoreMatchers.equalTo((Object)5));
        TreeSet treeSet2 = new TreeSet(String.CASE_INSENSITIVE_ORDER);
        treeSet2.addAll(treeSet);
        Assert.assertThat((Object)treeSet2.size(), (Matcher)CoreMatchers.equalTo((Object)3));
        Comparator<String> comparator = new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                String u2;
                String u1 = o1.toUpperCase(Locale.ROOT);
                int c = u1.compareTo(u2 = o2.toUpperCase(Locale.ROOT));
                if (c == 0) {
                    c = o1.compareTo(o2);
                }
                return c;
            }
        };
        TreeSet<String> treeSet3 = new TreeSet<String>(comparator);
        treeSet3.addAll(treeSet);
        Assert.assertThat((Object)treeSet3.size(), (Matcher)CoreMatchers.equalTo((Object)5));
        Assert.assertThat((Object)this.checkNav(treeSet3, "foo").size(), (Matcher)CoreMatchers.equalTo((Object)3));
        Assert.assertThat((Object)this.checkNav(treeSet3, "FOO").size(), (Matcher)CoreMatchers.equalTo((Object)3));
        Assert.assertThat((Object)this.checkNav(treeSet3, "FoO").size(), (Matcher)CoreMatchers.equalTo((Object)3));
        Assert.assertThat((Object)this.checkNav(treeSet3, "BAR").size(), (Matcher)CoreMatchers.equalTo((Object)1));
        ImmutableSortedSet treeSet4 = ImmutableSortedSet.copyOf((Comparator)comparator, treeSet);
        NavigableSet navigableSet4 = Compatible.INSTANCE.navigableSet(treeSet4);
        Assert.assertThat((Object)treeSet4.size(), (Matcher)CoreMatchers.equalTo((Object)5));
        Assert.assertThat((Object)navigableSet4.size(), (Matcher)CoreMatchers.equalTo((Object)5));
        Assert.assertThat((Object)navigableSet4, (Matcher)CoreMatchers.equalTo((Object)treeSet4));
        Assert.assertThat((Object)this.checkNav(navigableSet4, "foo").size(), (Matcher)CoreMatchers.equalTo((Object)3));
        Assert.assertThat((Object)this.checkNav(navigableSet4, "FOO").size(), (Matcher)CoreMatchers.equalTo((Object)3));
        Assert.assertThat((Object)this.checkNav(navigableSet4, "FoO").size(), (Matcher)CoreMatchers.equalTo((Object)3));
        Assert.assertThat((Object)this.checkNav(navigableSet4, "BAR").size(), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    private NavigableSet<String> checkNav(NavigableSet<String> set, String s) {
        return set.subSet(s.toUpperCase(Locale.ROOT), true, s.toLowerCase(Locale.ROOT), true);
    }

    @Test
    public void testImmutableNullableList() {
        List<String> arrayList = Arrays.asList("a", null, "c");
        List list = ImmutableNullableList.copyOf(arrayList);
        Assert.assertThat((Object)list.size(), (Matcher)CoreMatchers.equalTo((Object)arrayList.size()));
        Assert.assertThat((Object)list, (Matcher)CoreMatchers.equalTo(arrayList));
        Assert.assertThat((Object)list.hashCode(), (Matcher)CoreMatchers.equalTo((Object)arrayList.hashCode()));
        Assert.assertThat((Object)list.toString(), (Matcher)CoreMatchers.equalTo((Object)arrayList.toString()));
        String z = "";
        for (String s : list) {
            z = z + s;
        }
        Assert.assertThat((Object)z, (Matcher)CoreMatchers.equalTo((Object)"anullc"));
        arrayList.set(0, "z");
        Assert.assertThat((Object)arrayList.get(0), (Matcher)CoreMatchers.equalTo((Object)"z"));
        Assert.assertThat(list.get(0), (Matcher)CoreMatchers.equalTo((Object)"a"));
        try {
            boolean b = list.add("z");
            Assert.fail((String)("expected error, got " + b));
        }
        catch (UnsupportedOperationException b) {
            // empty catch block
        }
        try {
            String b = list.set(1, "z");
            Assert.fail((String)("expected error, got " + b));
        }
        catch (UnsupportedOperationException b) {
            // empty catch block
        }
        Assert.assertThat((Object)ImmutableNullableList.copyOf(Collections.emptyList()), (Matcher)CoreMatchers.isA(ImmutableList.class));
        final List<String> abcList = Arrays.asList("a", "b", "c");
        Assert.assertThat((Object)ImmutableNullableList.copyOf(abcList), (Matcher)CoreMatchers.isA(ImmutableList.class));
        Iterable<String> abc = new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return abcList.iterator();
            }
        };
        Assert.assertThat((Object)ImmutableNullableList.copyOf((Iterable)abc), (Matcher)CoreMatchers.isA(ImmutableList.class));
        Assert.assertThat((Object)ImmutableNullableList.copyOf((Iterable)abc), (Matcher)CoreMatchers.equalTo(abcList));
        final List<String> ab0cList = Arrays.asList("a", "b", null, "c");
        Iterable<String> ab0c = new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return ab0cList.iterator();
            }
        };
        Assert.assertThat((Object)ImmutableNullableList.copyOf((Iterable)ab0c), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.isA(ImmutableList.class)));
        Assert.assertThat((Object)ImmutableNullableList.copyOf((Iterable)ab0c), (Matcher)CoreMatchers.equalTo(ab0cList));
    }

    @Test
    public void testUnmodifiableArrayList() {
        Object[] strings = new String[]{"a", null, "c"};
        List<String> arrayList = Arrays.asList(strings);
        UnmodifiableArrayList list = UnmodifiableArrayList.of((Object[])strings);
        Assert.assertThat((Object)list.size(), (Matcher)CoreMatchers.equalTo((Object)arrayList.size()));
        Assert.assertThat((Object)list, (Matcher)CoreMatchers.equalTo(arrayList));
        Assert.assertThat((Object)list.hashCode(), (Matcher)CoreMatchers.equalTo((Object)arrayList.hashCode()));
        Assert.assertThat((Object)list.toString(), (Matcher)CoreMatchers.equalTo((Object)arrayList.toString()));
        String z = "";
        for (String s : list) {
            z = z + s;
        }
        Assert.assertThat((Object)z, (Matcher)CoreMatchers.equalTo((Object)"anullc"));
        arrayList.set(0, "z");
        Assert.assertThat((Object)arrayList.get(0), (Matcher)CoreMatchers.equalTo((Object)"z"));
        Assert.assertThat(list.get(0), (Matcher)CoreMatchers.equalTo((Object)"z"));
        try {
            boolean b = list.add("z");
            Assert.fail((String)("expected error, got " + b));
        }
        catch (UnsupportedOperationException b) {
            // empty catch block
        }
        try {
            String b = list.set(1, "z");
            Assert.fail((String)("expected error, got " + b));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void testImmutableNullableListBuilder() {
        ImmutableNullableList.Builder builder = ImmutableNullableList.builder();
        builder.add((Object)"a").add((Object)null).add((Object)"c");
        List<String> arrayList = Arrays.asList("a", null, "c");
        List list = builder.build();
        Assert.assertThat((Object)arrayList.equals(list), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testHuman() {
        Assert.assertThat((Object)Util.human((double)0.0), (Matcher)CoreMatchers.equalTo((Object)"0"));
        Assert.assertThat((Object)Util.human((double)1.0), (Matcher)CoreMatchers.equalTo((Object)"1"));
        Assert.assertThat((Object)Util.human((double)19.0), (Matcher)CoreMatchers.equalTo((Object)"19"));
        Assert.assertThat((Object)Util.human((double)198.0), (Matcher)CoreMatchers.equalTo((Object)"198"));
        Assert.assertThat((Object)Util.human((double)1000.0), (Matcher)CoreMatchers.equalTo((Object)"1.00K"));
        Assert.assertThat((Object)Util.human((double)1002.0), (Matcher)CoreMatchers.equalTo((Object)"1.00K"));
        Assert.assertThat((Object)Util.human((double)1009.0), (Matcher)CoreMatchers.equalTo((Object)"1.01K"));
        Assert.assertThat((Object)Util.human((double)1234.0), (Matcher)CoreMatchers.equalTo((Object)"1.23K"));
        Assert.assertThat((Object)Util.human((double)1987.0), (Matcher)CoreMatchers.equalTo((Object)"1.99K"));
        Assert.assertThat((Object)Util.human((double)1999.0), (Matcher)CoreMatchers.equalTo((Object)"2.00K"));
        Assert.assertThat((Object)Util.human((double)86837.2), (Matcher)CoreMatchers.equalTo((Object)"86.8K"));
        Assert.assertThat((Object)Util.human((double)868372.8), (Matcher)CoreMatchers.equalTo((Object)"868K"));
        Assert.assertThat((Object)Util.human((double)1009000.0), (Matcher)CoreMatchers.equalTo((Object)"1.01M"));
        Assert.assertThat((Object)Util.human((double)1999999.0), (Matcher)CoreMatchers.equalTo((Object)"2.00M"));
        Assert.assertThat((Object)Util.human((double)1.009E9), (Matcher)CoreMatchers.equalTo((Object)"1.01G"));
        Assert.assertThat((Object)Util.human((double)1.999999E9), (Matcher)CoreMatchers.equalTo((Object)"2.00G"));
        Assert.assertThat((Object)Util.human((double)-1.0), (Matcher)CoreMatchers.equalTo((Object)"-1"));
        Assert.assertThat((Object)Util.human((double)-19.0), (Matcher)CoreMatchers.equalTo((Object)"-19"));
        Assert.assertThat((Object)Util.human((double)-198.0), (Matcher)CoreMatchers.equalTo((Object)"-198"));
        Assert.assertThat((Object)Util.human((double)-1.999999E9), (Matcher)CoreMatchers.equalTo((Object)"-2.00G"));
        Assert.assertThat((Object)Util.human((double)0.18), (Matcher)CoreMatchers.equalTo((Object)"0.18"));
        Assert.assertThat((Object)Util.human((double)0.018), (Matcher)CoreMatchers.equalTo((Object)"0.018"));
        Assert.assertThat((Object)Util.human((double)0.0018), (Matcher)CoreMatchers.equalTo((Object)"0.0018"));
        Assert.assertThat((Object)Util.human((double)1.8E-4), (Matcher)CoreMatchers.equalTo((Object)"1.8E-4"));
        Assert.assertThat((Object)Util.human((double)1.8E-5), (Matcher)CoreMatchers.equalTo((Object)"1.8E-5"));
        Assert.assertThat((Object)Util.human((double)1.8E-6), (Matcher)CoreMatchers.equalTo((Object)"1.8E-6"));
        Assert.assertThat((Object)Util.human((double)0.181111), (Matcher)CoreMatchers.equalTo((Object)"0.181111"));
        Assert.assertThat((Object)Util.human((double)0.0181111), (Matcher)CoreMatchers.equalTo((Object)"0.0181111"));
        Assert.assertThat((Object)Util.human((double)0.00181111), (Matcher)CoreMatchers.equalTo((Object)"0.00181111"));
        Assert.assertThat((Object)Util.human((double)1.81111E-4), (Matcher)CoreMatchers.equalTo((Object)"1.81111E-4"));
        Assert.assertThat((Object)Util.human((double)1.81111E-5), (Matcher)CoreMatchers.equalTo((Object)"1.81111E-5"));
        Assert.assertThat((Object)Util.human((double)1.81111E-6), (Matcher)CoreMatchers.equalTo((Object)"1.81111E-6"));
    }

    @Test
    public void testImmutableCopy() {
        List<Integer> list3 = Arrays.asList(1, 2, 3);
        ImmutableList immutableList3 = ImmutableList.copyOf(list3);
        List<Integer> list0 = Arrays.asList(new Integer[0]);
        ImmutableList immutableList0 = ImmutableList.copyOf(list0);
        List<Integer> list1 = Arrays.asList(1);
        ImmutableList immutableList1 = ImmutableList.copyOf(list1);
        List<List> list301 = Arrays.asList(list3, list0, list1);
        List immutableList301 = Util.immutableCopy(list301);
        Assert.assertThat((Object)immutableList301.size(), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat((Object)immutableList301, (Matcher)CoreMatchers.is(list301));
        Assert.assertThat((Object)immutableList301, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.sameInstance(list301)));
        for (List list : immutableList301) {
            Assert.assertThat((Object)list, (Matcher)CoreMatchers.isA(ImmutableList.class));
        }
        List immutableList301b = Util.immutableCopy((Iterable)immutableList301);
        Assert.assertThat((Object)immutableList301b, (Matcher)CoreMatchers.sameInstance((Object)immutableList301));
        Assert.assertThat((Object)immutableList301b, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.sameInstance(list301)));
        List<List> list301c = Arrays.asList(immutableList3, immutableList0, immutableList1);
        List list301d = Util.immutableCopy(list301c);
        Assert.assertThat((Object)list301d.size(), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat((Object)list301d, (Matcher)CoreMatchers.is(list301));
        Assert.assertThat((Object)list301d, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.sameInstance(list301)));
        Assert.assertThat(list301d.get(0), (Matcher)CoreMatchers.sameInstance((Object)immutableList3));
        Assert.assertThat(list301d.get(1), (Matcher)CoreMatchers.sameInstance((Object)immutableList0));
        Assert.assertThat(list301d.get(2), (Matcher)CoreMatchers.sameInstance((Object)immutableList1));
    }

    @Test
    public void testAsIndexView() {
        ArrayList values = Lists.newArrayList((Object[])new String[]{"abCde", "X", "y"});
        Map map = Util.asIndexMap((Collection)values, (Function)new Function<String, String>(){

            public String apply(@Nullable String input) {
                return input.toUpperCase(Locale.ROOT);
            }
        });
        Assert.assertThat((Object)map.size(), (Matcher)CoreMatchers.equalTo((Object)values.size()));
        Assert.assertThat(map.get("X"), (Matcher)CoreMatchers.equalTo((Object)"X"));
        Assert.assertThat(map.get("Y"), (Matcher)CoreMatchers.equalTo((Object)"y"));
        Assert.assertThat(map.get("y"), (Matcher)CoreMatchers.is((Object)null));
        Assert.assertThat(map.get("ABCDE"), (Matcher)CoreMatchers.equalTo((Object)"abCde"));
        values.remove(1);
        Assert.assertThat((Object)map.size(), (Matcher)CoreMatchers.equalTo((Object)values.size()));
        Assert.assertThat(map.get("X"), (Matcher)CoreMatchers.is((Object)null));
        Assert.assertThat(map.get("Y"), (Matcher)CoreMatchers.equalTo((Object)"y"));
    }

    @Test
    public void testRelBuilderExample() {
        new RelBuilderExample(false).runAllExamples();
    }

    @Test
    public void testOrdReverse() {
        this.checkOrdReverse(Ord.reverse(Arrays.asList("a", "b", "c")));
        this.checkOrdReverse(Ord.reverse((Object[])new String[]{"a", "b", "c"}));
        Assert.assertThat((Object)Ord.reverse((Iterable)ImmutableList.of()).iterator().hasNext(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)Ord.reverse((Object[])new Object[0]).iterator().hasNext(), (Matcher)CoreMatchers.is((Object)false));
    }

    private void checkOrdReverse(Iterable<Ord<String>> reverse1) {
        Iterator<Ord<String>> reverse = reverse1.iterator();
        Assert.assertThat((Object)reverse.hasNext(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)reverse.next().i, (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)reverse.hasNext(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)reverse.next().e, (Matcher)CoreMatchers.is((Object)"b"));
        Assert.assertThat((Object)reverse.hasNext(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)reverse.next().e, (Matcher)CoreMatchers.is((Object)"a"));
        Assert.assertThat((Object)reverse.hasNext(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testParameterName() throws NoSuchMethodException {
        Method method = UtilTest.class.getMethod("foo", Integer.TYPE, Integer.TYPE);
        Assert.assertThat((Object)ReflectUtil.getParameterName((Method)method, (int)0), (Matcher)CoreMatchers.is((Object)"arg0"));
        Assert.assertThat((Object)ReflectUtil.getParameterName((Method)method, (int)1), (Matcher)CoreMatchers.is((Object)"j"));
    }

    public static void foo(int i, @Parameter(name="j") int j) {
    }

    @Test
    public void testListToString() {
        this.checkListToString("x");
        this.checkListToString("");
        this.checkListToString(new String[0]);
        this.checkListToString("ab", "c", "");
        this.checkListToString("ab", "c", "", "de");
        this.checkListToString("ab", "c.");
        this.checkListToString("ab", "c.d");
        this.checkListToString("ab", ".d");
        this.checkListToString(".ab", "d");
        this.checkListToString(".a", "d");
        this.checkListToString("a.", "d");
    }

    private void checkListToString(String ... strings) {
        ImmutableList list = ImmutableList.copyOf((Object[])strings);
        String asString = Util.listToString((List)list);
        Assert.assertThat((Object)Util.stringToList((String)asString), (Matcher)CoreMatchers.is((Object)list));
    }

    @Test
    public void testTryThreadLocal() {
        TryThreadLocal local1 = TryThreadLocal.of((Object)"foo");
        Assert.assertThat((Object)local1.get(), (Matcher)CoreMatchers.is((Object)"foo"));
        TryThreadLocal.Memo memo1 = local1.push((Object)"bar");
        Assert.assertThat((Object)local1.get(), (Matcher)CoreMatchers.is((Object)"bar"));
        local1.set((Object)"baz");
        Assert.assertThat((Object)local1.get(), (Matcher)CoreMatchers.is((Object)"baz"));
        memo1.close();
        Assert.assertThat((Object)local1.get(), (Matcher)CoreMatchers.is((Object)"foo"));
        TryThreadLocal local2 = TryThreadLocal.of(null);
        Assert.assertThat((Object)local2.get(), (Matcher)CoreMatchers.nullValue());
        TryThreadLocal.Memo memo2 = local2.push((Object)"a");
        Assert.assertThat((Object)local2.get(), (Matcher)CoreMatchers.is((Object)"a"));
        local2.set((Object)"b");
        Assert.assertThat((Object)local2.get(), (Matcher)CoreMatchers.is((Object)"b"));
        TryThreadLocal.Memo memo2B = local2.push(null);
        Assert.assertThat((Object)local2.get(), (Matcher)CoreMatchers.nullValue());
        memo2B.close();
        Assert.assertThat((Object)local2.get(), (Matcher)CoreMatchers.is((Object)"b"));
        memo2.close();
        Assert.assertThat((Object)local2.get(), (Matcher)CoreMatchers.nullValue());
        local2.set((Object)"x");
        try (TryThreadLocal.Memo ignore = local2.push((Object)"y");){
            Assert.assertThat((Object)local2.get(), (Matcher)CoreMatchers.is((Object)"y"));
            local2.set((Object)"z");
        }
        Assert.assertThat((Object)local2.get(), (Matcher)CoreMatchers.is((Object)"x"));
    }

    @Test
    public void testLitmus() {
        boolean b = this.checkLitmus(2, Litmus.THROW);
        Assert.assertThat((Object)b, (Matcher)CoreMatchers.is((Object)true));
        b = this.checkLitmus(2, Litmus.IGNORE);
        Assert.assertThat((Object)b, (Matcher)CoreMatchers.is((Object)true));
        try {
            b = this.checkLitmus(-1, Litmus.THROW);
            Assert.fail((String)("expected fail, got " + b));
        }
        catch (AssertionError e) {
            Assert.assertThat((Object)((Throwable)((Object)e)).getMessage(), (Matcher)CoreMatchers.is((Object)"-1 is less than 0"));
        }
        b = this.checkLitmus(-1, Litmus.IGNORE);
        Assert.assertThat((Object)b, (Matcher)CoreMatchers.is((Object)false));
    }

    private boolean checkLitmus(int i, Litmus litmus) {
        if (i < 0) {
            return litmus.fail("{} is less than {}", new Object[]{i, 0});
        }
        return litmus.succeed();
    }

    @Test
    public void testNameSet() {
        NameSet names = new NameSet();
        Assert.assertThat((Object)names.contains("foo", true), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)names.contains("foo", false), (Matcher)CoreMatchers.is((Object)false));
        names.add("baz");
        Assert.assertThat((Object)names.contains("foo", true), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)names.contains("foo", false), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)names.contains("baz", true), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)names.contains("baz", false), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)names.contains("BAZ", true), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)names.contains("BAZ", false), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)names.contains("bAz", false), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)names.range("baz", true).size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)names.range("baz", false).size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)names.range("BAZ", true).size(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)names.range("BaZ", true).size(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)names.range("BaZ", false).size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)names.range("BAZ", false).size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)names.contains("bAzinga", false), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)names.range("bAzinga", true).size(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)names.range("bAzinga", false).size(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)names.contains("zoo", true), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)names.contains("zoo", false), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)names.range("zoo", true).size(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)Iterables.size((Iterable)names.iterable()), (Matcher)CoreMatchers.is((Object)1));
        names.add("Baz");
        names.add("Abcde");
        names.add("Zymurgy");
        Assert.assertThat((Object)Iterables.size((Iterable)names.iterable()), (Matcher)CoreMatchers.is((Object)4));
        Assert.assertThat((Object)names.range("baz", false).size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)names.range("baz", true).size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)names.range("BAZ", true).size(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)names.range("Baz", true).size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testNameMap() {
        NameMap map = new NameMap();
        Assert.assertThat((Object)map.containsKey("foo", true), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)map.containsKey("foo", false), (Matcher)CoreMatchers.is((Object)false));
        map.put("baz", (Object)0);
        Assert.assertThat((Object)map.containsKey("foo", true), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)map.containsKey("foo", false), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)map.containsKey("baz", true), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)map.containsKey("baz", false), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)map.containsKey("BAZ", true), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)map.containsKey("BAZ", false), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)map.containsKey("bAz", false), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)map.range("baz", true).size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)map.range("baz", false).size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)map.range("BAZ", true).size(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)map.range("BaZ", true).size(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)map.range("BaZ", false).size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)map.range("BAZ", false).size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)map.containsKey("bAzinga", false), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)map.range("bAzinga", true).size(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)map.range("bAzinga", false).size(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)map.containsKey("zoo", true), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)map.containsKey("zoo", false), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)map.range("zoo", true).size(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)map.map().size(), (Matcher)CoreMatchers.is((Object)1));
        map.put("Baz", (Object)1);
        map.put("Abcde", (Object)2);
        map.put("Zymurgy", (Object)3);
        Assert.assertThat((Object)map.map().size(), (Matcher)CoreMatchers.is((Object)4));
        Assert.assertThat((Object)map.map().entrySet().size(), (Matcher)CoreMatchers.is((Object)4));
        Assert.assertThat((Object)map.map().keySet().size(), (Matcher)CoreMatchers.is((Object)4));
        Assert.assertThat((Object)map.range("baz", false).size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)map.range("baz", true).size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)map.range("BAZ", true).size(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)map.range("Baz", true).size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testNameMultimap() {
        NameMultimap map = new NameMultimap();
        Assert.assertThat((Object)map.containsKey("foo", true), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)map.containsKey("foo", false), (Matcher)CoreMatchers.is((Object)false));
        map.put("baz", (Object)0);
        map.put("baz", (Object)0);
        map.put("BAz", (Object)0);
        Assert.assertThat((Object)map.containsKey("foo", true), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)map.containsKey("foo", false), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)map.containsKey("baz", true), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)map.containsKey("baz", false), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)map.containsKey("BAZ", true), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)map.containsKey("BAZ", false), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)map.containsKey("bAz", false), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)map.range("baz", true).size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)map.range("baz", false).size(), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat((Object)map.range("BAZ", true).size(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)map.range("BaZ", true).size(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)map.range("BaZ", false).size(), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat((Object)map.range("BAZ", false).size(), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat((Object)map.containsKey("bAzinga", false), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)map.range("bAzinga", true).size(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)map.range("bAzinga", false).size(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)map.containsKey("zoo", true), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)map.containsKey("zoo", false), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)map.range("zoo", true).size(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)map.map().size(), (Matcher)CoreMatchers.is((Object)2));
        map.put("Baz", (Object)1);
        map.put("Abcde", (Object)2);
        map.put("Zymurgy", (Object)3);
        Assert.assertThat((Object)map.map().size(), (Matcher)CoreMatchers.is((Object)5));
        Assert.assertThat((Object)map.map().entrySet().size(), (Matcher)CoreMatchers.is((Object)5));
        Assert.assertThat((Object)map.map().keySet().size(), (Matcher)CoreMatchers.is((Object)5));
        Assert.assertThat((Object)map.range("baz", false).size(), (Matcher)CoreMatchers.is((Object)4));
        Assert.assertThat((Object)map.range("baz", true).size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)map.range("BAZ", true).size(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)map.range("Baz", true).size(), (Matcher)CoreMatchers.is((Object)1));
    }
}

