/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.zookeeper.attribute_store;

import com.gigaspaces.attribute_store.AttributeStore;
import com.gigaspaces.grid.zookeeper.ZookeeperClusterConfig;
import com.gigaspaces.grid.zookeeper.ZookeeperConfig;
import com.gigaspaces.internal.utils.SharedInstance;
import com.j_spaces.core.admin.SpaceConfig;
import java.io.IOException;
import java.io.Serializable;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.curator.utils.ZKPaths;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooKeeper;
import org.openspaces.zookeeper.curator.CuratorClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperAttributeStore
implements AttributeStore,
Serializable {
    private static final Logger logger = LoggerFactory.getLogger((String)"com.gigaspaces.zookeeper");
    private String name;
    private SharedInstance<CuratorFramework> sharedClient;

    public ZooKeeperAttributeStore() {
    }

    public ZooKeeperAttributeStore(String name, SpaceConfig config) throws IOException {
        this(name, CuratorClient.getOrCreate(config));
    }

    public ZooKeeperAttributeStore(String name) throws IOException {
        this(name, ZooKeeperAttributeStore.getSharedCuratorClient());
    }

    private static SharedInstance<CuratorFramework> getSharedCuratorClient() throws IOException {
        SpaceConfig spaceConfig = new SpaceConfig();
        return new SharedInstance((Object)CuratorClient.create(spaceConfig.getZookeeperSessionTimeout(), spaceConfig.getZookeeperConnectionTimeout(), spaceConfig.getZookeeperRetryTimeout(), spaceConfig.getZookeeperRetryInterval()));
    }

    private ZooKeeperAttributeStore(String name, SharedInstance<CuratorFramework> sharedClient) throws IOException {
        this.sharedClient = sharedClient;
        if (name.length() == 0) {
            this.name = name;
            logger.info("Created ZooKeeperAttributeStore");
        } else {
            this.name = name.startsWith("/") ? name : "/" + name;
            try {
                ZKPaths.mkdirs((ZooKeeper)((CuratorFramework)sharedClient.value()).getZookeeperClient().getZooKeeper(), (String)this.name);
            }
            catch (KeeperException.NodeExistsException ignored) {
                logger.debug("Path [" + this.name + "] already exists - creation skipped");
            }
            catch (Exception e) {
                throw new IOException("Failed to create ZooKeeperAttributeStore for [" + this.name + "]", e);
            }
            logger.info("Created ZooKeeperAttributeStore for [" + this.name + "]");
        }
    }

    private String toPath(String key) {
        return this.name + (key.startsWith("/") ? key : "/" + key);
    }

    public String get(String key) throws IOException {
        String path = this.toPath(key);
        try {
            return new String((byte[])((CuratorFramework)this.sharedClient.value()).getData().forPath(path));
        }
        catch (KeeperException.NoNodeException e) {
            return null;
        }
        catch (Exception e) {
            logger.error("Couldn't get data from key: " + path);
            throw new IOException("Couldn't get data from key: " + path, e);
        }
    }

    public String set(String key, String value) throws IOException {
        String oldValue = this.get(key);
        String path = this.toPath(key);
        try {
            ((CuratorFramework)this.sharedClient.value()).setData().forPath(path, value.getBytes());
        }
        catch (KeeperException.NoNodeException e) {
            try {
                ((CuratorFramework)this.sharedClient.value()).create().forPath(path, value.getBytes());
            }
            catch (Exception e1) {
                logger.error("Couldn't set key: " + path + " with value: " + value);
                throw new IOException("Couldn't set key: " + path + " with value: " + value, e1);
            }
        }
        catch (Exception e) {
            logger.error("Couldn't set key: " + path + " with value: " + value);
            throw new IOException("Couldn't set key: " + path + " with value: " + value, e);
        }
        return oldValue;
    }

    public String remove(String key) throws IOException {
        String oldValue = this.get(key);
        String path = this.toPath(key);
        try {
            if (oldValue != null) {
                ((CuratorFramework)this.sharedClient.value()).delete().forPath(path);
            }
        }
        catch (Exception e) {
            logger.error("Couldn't delete node with key: " + path);
            throw new IOException("Couldn't delete node with key: " + path, e);
        }
        return oldValue;
    }

    public void close() throws IOException {
        CuratorClient.release(this.sharedClient);
    }

    public void clear() throws Exception {
        try {
            ((CuratorFramework)this.sharedClient.value()).delete().deletingChildrenIfNeeded().forPath(this.name);
        }
        catch (Exception e) {
            logger.error("Couldn't clear client ");
            throw e;
        }
    }

    void restartClientWithoutDeletingNodes() throws Exception {
        this.close();
        ZookeeperClusterConfig clusterConfig = ZookeeperClusterConfig.getInstance();
        if (clusterConfig.isEmpty()) {
            logger.error("Zookeeper server list is not defined in system property nor environment variable or empty.");
            System.exit(0);
        }
        ZookeeperConfig config = ZookeeperConfig.getDefaultConfig();
        String zkConnString = clusterConfig.getServers()[0].getHost() + ":" + config.getClientPort();
        this.sharedClient = new SharedInstance((Object)CuratorFrameworkFactory.newClient((String)zkConnString, (RetryPolicy)new ExponentialBackoffRetry(1000, 3)));
        ((CuratorFramework)this.sharedClient.value()).start();
    }
}

