/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.zookeeper.curator;

import com.gigaspaces.grid.zookeeper.ZookeeperClusterConfig;
import com.gigaspaces.grid.zookeeper.ZookeeperConfig;
import com.gigaspaces.internal.utils.SharedInstance;
import com.gigaspaces.internal.utils.Singletons;
import com.j_spaces.core.admin.SpaceConfig;
import java.io.Closeable;
import java.io.IOException;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.RetryUntilElapsed;
import org.apache.curator.utils.CloseableUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CuratorClient {
    private static final Logger logger = LoggerFactory.getLogger((String)"com.gigaspaces.zookeeper");
    private static final String CURATOR_LOG_ONLY_FIRST_CONNECTION_ISSUE = "curator-log-only-first-connection-issue-as-error-level";
    private static final String CURATOR_DONT_LOG_CONNECTION_ISSUE = "curator-dont-log-connection-problems";
    private static final String ZOOKEEPER_CLIENT_SINGLETON_KEY = "zookeeperClient";

    public static synchronized SharedInstance<CuratorFramework> getOrCreate(SpaceConfig config) throws IOException {
        CuratorFramework curatorFramework;
        SharedInstance newInstance;
        SharedInstance existingInstance = (SharedInstance)Singletons.get((String)ZOOKEEPER_CLIENT_SINGLETON_KEY);
        if (existingInstance == null && (existingInstance = (SharedInstance)Singletons.putIfAbsent((String)ZOOKEEPER_CLIENT_SINGLETON_KEY, (Object)(newInstance = new SharedInstance((Object)(curatorFramework = CuratorClient.create(config.getZookeeperSessionTimeout(), config.getZookeeperConnectionTimeout(), config.getZookeeperRetryTimeout(), config.getZookeeperRetryInterval())))))) != newInstance) {
            curatorFramework.close();
            logger.warn("Unexpected behavior - CuratorFramework instance [" + existingInstance.value() + "] is shared [" + existingInstance.count() + "] times, state=[" + ((CuratorFramework)existingInstance.value()).getState() + "]");
        }
        int count = existingInstance.increment();
        if (logger.isDebugEnabled()) {
            logger.debug("CuratorFramework instance [" + existingInstance.value() + "] is shared [" + count + "] times, state=[" + ((CuratorFramework)existingInstance.value()).getState() + "]");
        }
        return existingInstance;
    }

    public static synchronized void release(SharedInstance<CuratorFramework> sharedClient) {
        if (sharedClient.decrement() == 0) {
            Singletons.compareAndRemove((String)ZOOKEEPER_CLIENT_SINGLETON_KEY, sharedClient);
            CloseableUtils.closeQuietly((Closeable)((Closeable)sharedClient.value()));
            if (logger.isDebugEnabled()) {
                logger.debug("Closed CuratorFramework instance [" + sharedClient.value() + "] state=[" + ((CuratorFramework)sharedClient.value()).getState() + "]");
            }
        }
    }

    public static CuratorFramework create(int sessionTimeout, int connectionTimeout, int retryTimeout, int retryInterval) throws IOException {
        try {
            String dontLogConnectionIssue;
            ZookeeperClusterConfig clusterConfig = ZookeeperClusterConfig.getInstance();
            if (clusterConfig.isEmpty()) {
                logger.error("Zookeeper server list is not defined in system property nor environment variable or empty.");
                throw new IOException("Zookeeper server list is not defined in system property nor environment variable or empty.");
            }
            String curatorLogonlyFirstConnectionIssue = System.getProperty(CURATOR_LOG_ONLY_FIRST_CONNECTION_ISSUE);
            if (curatorLogonlyFirstConnectionIssue == null) {
                System.setProperty(CURATOR_LOG_ONLY_FIRST_CONNECTION_ISSUE, "true");
            }
            if ((dontLogConnectionIssue = System.getProperty(CURATOR_DONT_LOG_CONNECTION_ISSUE)) == null) {
                System.setProperty(CURATOR_DONT_LOG_CONNECTION_ISSUE, "true");
            }
            String zkConnString = clusterConfig.generateConnectionString(ZookeeperConfig.getDefaultConfig());
            CuratorFramework curatorFramework = CuratorFrameworkFactory.newClient((String)zkConnString, (int)sessionTimeout, (int)connectionTimeout, (RetryPolicy)new RetryUntilElapsed(retryTimeout, retryInterval));
            curatorFramework.start();
            return curatorFramework;
        }
        catch (Exception e) {
            throw new IOException("Failed to connect to ZooKeeper", e);
        }
    }
}

