/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.zookeeper.curator;

import java.io.Closeable;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.leader.LeaderSelector;
import org.apache.curator.framework.recipes.leader.LeaderSelectorListener;
import org.apache.curator.framework.recipes.leader.Participant;
import org.apache.curator.framework.state.ConnectionState;
import org.openspaces.zookeeper.curator.XapLeaderSelectorListener;

public class XapLeaderSelector
implements Closeable {
    private final Logger logger;
    private final LeaderSelector leaderSelector;
    private final InternalListener internalListener;
    private volatile Long leadershipSessionId;
    private final String path;
    private final ExecutorService singleExecutorService = Executors.newSingleThreadExecutor();
    private volatile boolean isClosed;

    public XapLeaderSelector(CuratorFramework client, String path, String id, XapLeaderSelectorListener listener) {
        String suffix = listener.getLoggerSuffix();
        this.logger = Logger.getLogger("com.gigaspaces.zookeeper.leader-selector" + (suffix != null ? "." + suffix : ""));
        this.internalListener = new InternalListener(this, listener, this.singleExecutorService);
        this.leaderSelector = new LeaderSelector(client, path, (LeaderSelectorListener)this.internalListener);
        this.leaderSelector.setId(id);
        this.path = path;
        this.leaderSelector.autoRequeue();
    }

    public boolean isLeadershipSemaphoreTaken() {
        return this.internalListener.leadershipSemaphore.hasQueuedThreads();
    }

    public void start() {
        this.leaderSelector.start();
    }

    @Override
    public void close() {
        this.isClosed = true;
        this.leaderSelector.close();
        this.singleExecutorService.shutdown();
    }

    public Long getSessionId(CuratorFramework client) {
        try {
            return client.getZookeeperClient().getZooKeeper().getSessionId();
        }
        catch (Exception e) {
            this.logger.warning("Failed to get zookeeper session id - " + e);
            return null;
        }
    }

    public LeaderSelector getLeaderSelector() {
        return this.leaderSelector;
    }

    public String getPath() {
        return this.path;
    }

    public String getId() {
        return this.leaderSelector.getId();
    }

    public String participantToString() {
        return " Participant{id='" + this.leaderSelector.getId() + "'}";
    }

    public String sessionToString() {
        return " Session{id='" + XapLeaderSelector.toHex(this.leadershipSessionId) + "'}";
    }

    public boolean hasLeadership() {
        return this.leaderSelector.hasLeadership();
    }

    public void interruptLeadership() {
        this.logger.info("Submit 'interruptLeadership' -" + this.participantToString() + this.sessionToString());
        this.singleExecutorService.submit(new Runnable(){

            @Override
            public void run() {
                XapLeaderSelector.this.logger.info("Invoke 'interruptLeadership' -" + XapLeaderSelector.this.participantToString() + XapLeaderSelector.this.sessionToString());
                XapLeaderSelector.this.leaderSelector.interruptLeadership();
            }
        });
    }

    public Participant getLeaderIfExists() throws Exception {
        for (Participant participant : this.leaderSelector.getParticipants()) {
            if (!participant.isLeader()) continue;
            return participant;
        }
        return null;
    }

    public Long getLeadershipSessionId() {
        return this.leadershipSessionId;
    }

    private static String toHex(Long sessionId) {
        return sessionId != null ? "0x" + Long.toHexString(sessionId) : "null";
    }

    private static class InternalListener
    implements LeaderSelectorListener {
        private final XapLeaderSelector container;
        private final Logger logger;
        private final XapLeaderSelectorListener listener;
        private final ExecutorService singleExecutorService;
        private final Semaphore leadershipSemaphore = new Semaphore(0);
        private final AtomicLong suspendSessionId = new AtomicLong();
        private final Object stateChangeLock = new Object();
        private volatile ConnectionState lastState;

        private InternalListener(XapLeaderSelector container, XapLeaderSelectorListener listener, ExecutorService singleExecutorService) {
            this.container = container;
            this.logger = container.logger;
            this.listener = listener;
            this.singleExecutorService = singleExecutorService;
        }

        public void takeLeadership(CuratorFramework client) throws Exception {
            this.container.leadershipSessionId = this.container.getSessionId(client);
            this.logger.log(Level.INFO, "Notified of leadership -" + this.container.participantToString() + this.container.sessionToString());
            try {
                Collection participants = this.container.getLeaderSelector().getParticipants();
                if (this.logger.isLoggable(Level.INFO)) {
                    this.logger.log(Level.INFO, "Participants: " + participants);
                }
            }
            catch (InterruptedException e) {
                this.logger.log(Level.WARNING, "Interrupted while getting participants: " + e.getMessage(), e);
                Thread.currentThread().interrupt();
                throw e;
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Failed to get participants: " + e.getMessage(), e);
            }
            this.logger.log(Level.INFO, "Submit 'onLeadershipOffered' -" + this.container.participantToString() + this.container.sessionToString());
            Future<?> future = this.singleExecutorService.submit(new Runnable(){

                @Override
                public void run() {
                    logger.log(Level.INFO, "Invoke 'onLeadershipOffered' -" + container.participantToString() + container.sessionToString() + " ...");
                    try {
                        listener.onLeadershipOffered(container);
                    }
                    catch (Exception e) {
                        logger.log(Level.WARNING, "Caught [" + e + "] while offering leadership " + container.sessionToString(), e);
                        leadershipSemaphore.release();
                    }
                }
            });
            try {
                this.logger.info("Acquire leadership semaphore -" + this.container.participantToString() + this.container.sessionToString());
                this.leadershipSemaphore.acquire();
                this.logger.info("Released leadership semaphore -" + this.container.participantToString() + this.container.sessionToString());
                future.cancel(true);
            }
            catch (Throwable throwable) {
                this.logger.info("Released leadership semaphore -" + this.container.participantToString() + this.container.sessionToString());
                future.cancel(true);
                if (!this.container.isClosed) {
                    this.logger.info("Submit 'onLeadershipLost' -" + this.container.participantToString() + this.container.sessionToString());
                    this.singleExecutorService.submit(new Runnable(this){
                        final /* synthetic */ InternalListener this$0;
                        {
                            this.this$0 = this$0;
                        }

                        @Override
                        public void run() {
                            this.this$0.logger.log(Level.INFO, "Invoke 'onLeadershipLost' -" + this.this$0.container.participantToString() + this.this$0.container.sessionToString() + " ...");
                            this.this$0.listener.onLeadershipLost(this.this$0.container);
                            this.this$0.container.leadershipSessionId = null;
                        }
                    });
                }
                throw throwable;
            }
            if (!this.container.isClosed) {
                this.logger.info("Submit 'onLeadershipLost' -" + this.container.participantToString() + this.container.sessionToString());
                this.singleExecutorService.submit(new /* invalid duplicate definition of identical inner class */);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stateChanged(CuratorFramework client, ConnectionState newState) {
            Object object = this.stateChangeLock;
            synchronized (object) {
                long startTime = System.currentTimeMillis();
                String stateChange = (this.lastState != null ? this.lastState : "EMPTY") + " => " + newState;
                this.lastState = newState;
                this.logger.info("Zookeeper connection state changed: " + stateChange);
                Long currSessionId = this.container.getSessionId(client);
                switch (newState) {
                    case CONNECTED: {
                        this.listener.onConnected(this.container, client);
                        break;
                    }
                    case SUSPENDED: {
                        long prevSessionId;
                        if (currSessionId == null) {
                            this.logger.warning("Failed to get sessionId on suspend");
                        } else {
                            prevSessionId = this.suspendSessionId.getAndSet(currSessionId);
                            if (prevSessionId != 0L) {
                                this.logger.warning("Illegal state - session [" + XapLeaderSelector.toHex(prevSessionId) + "] was suspended and not reconnected, followed by suspension of session [" + XapLeaderSelector.toHex(currSessionId) + "]");
                            }
                        }
                        this.listener.onConnectionSuspended(this.container, client);
                        break;
                    }
                    case LOST: {
                        this.listener.onConnectionLost(this.container, client);
                        break;
                    }
                    case RECONNECTED: {
                        long prevSessionId;
                        if (currSessionId == null) {
                            this.logger.warning("Failed to get sessionId on reconnect");
                            currSessionId = 0L;
                        }
                        if ((prevSessionId = this.suspendSessionId.getAndSet(0L)) == 0L) {
                            this.logger.warning("Illegal state - session [" + XapLeaderSelector.toHex(currSessionId) + "] was reconnected, but there was no suspend event for it.");
                        }
                        if (prevSessionId == currSessionId) {
                            this.listener.onConnectionResumed(this.container, client);
                            break;
                        }
                        this.listener.onReconnected(this.container, client);
                        break;
                    }
                    case READ_ONLY: {
                        this.listener.onReadOnly(this.container, client);
                    }
                }
                long duration = System.currentTimeMillis() - startTime;
                this.logger.info("Zookeeper connection state transition [" + stateChange + "] took " + duration + "ms");
            }
        }
    }
}

