/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.zookeeper.grid;

import com.gigaspaces.grid.zookeeper.ZookeeperClusterConfig;
import com.gigaspaces.grid.zookeeper.ZookeeperConfig;
import com.gigaspaces.grid.zookeeper.ZookeeperServerConfig;
import com.gigaspaces.internal.io.BootIOUtils;
import com.gigaspaces.start.SystemInfo;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.zookeeper.server.ZooKeeperServerMain;
import org.apache.zookeeper.server.quorum.QuorumPeerMain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XapZookeeperContainer
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger((String)"com.gigaspaces.zookeeper");
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private final ZookeeperWrapper zookeeperWrapper;

    public XapZookeeperContainer() {
        System.setProperty("zookeeper.jmx.log4j.disable", "true");
        final ZookeeperClusterConfig clusterConfig = ZookeeperClusterConfig.getInstance();
        if (clusterConfig.isEmpty()) {
            logger.error("Zookeeper server ensemble is not configured");
            System.exit(0);
        }
        if (clusterConfig.getCurrServer() == null) {
            logger.error("Current host [" + SystemInfo.singleton().network().getHost() + "] is not part of the configured zookeeper ensemble [" + clusterConfig.toString() + "]");
            System.exit(0);
        }
        this.zookeeperWrapper = clusterConfig.getServers().length == 1 ? new ZookeeperStandaloneWrapper() : new ZookeeperQuorumWrapper();
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    String configFile = XapZookeeperContainer.prepareZookeeperConfigFiles(clusterConfig);
                    logger.info("zookeeper instance using generated conf file " + configFile);
                    XapZookeeperContainer.this.zookeeperWrapper.start(configFile);
                }
                catch (Exception e) {
                    logger.error("Failed to run Zookeeper instance", (Throwable)e);
                    System.exit(0);
                }
            }
        });
    }

    @Override
    public void close() throws IOException {
        if (this.zookeeperWrapper != null) {
            this.zookeeperWrapper.close();
        }
        if (!this.executor.isTerminated()) {
            this.executor.shutdown();
        }
    }

    private static String prepareZookeeperConfigFiles(ZookeeperClusterConfig clusterConfig) throws IOException {
        ZookeeperConfig config = ZookeeperConfig.getDefaultConfig();
        String dataDirProp = config.getProperty("dataDir");
        if (dataDirProp == null) {
            throw new IOException("The 'dataDir' configuration is missing from the zoo.cfg file");
        }
        File dataDir = new File(dataDirProp);
        XapZookeeperContainer.autoCreateZkDirectory(dataDir);
        String dataLogDirProp = config.getProperty("dataLogDir");
        if (dataLogDirProp != null) {
            ZookeeperServerConfig[] dataLogDir = new File(dataLogDirProp);
            XapZookeeperContainer.autoCreateZkDirectory((File)dataLogDir);
        }
        if (clusterConfig.getServers().length > 1) {
            for (ZookeeperServerConfig server : clusterConfig.getServers()) {
                if (SystemInfo.singleton().network().isPublicHostConfigured()) {
                    if (server.equals(clusterConfig.getCurrServer())) {
                        String publicHostAddress = SystemInfo.singleton().network().getPublicHost().getHostAddress();
                        String privateHostId = SystemInfo.singleton().network().getHostId();
                        config.setProperty("server." + server.getId(), server.getDescription().replace(publicHostAddress, privateHostId));
                        continue;
                    }
                    config.setProperty("server." + server.getId(), server.getDescription());
                    continue;
                }
                config.setProperty("server." + server.getId(), server.getDescription());
            }
            XapZookeeperContainer.generateMyId(clusterConfig.getCurrServer().getId(), dataDir);
        }
        File zookeeperPath = XapZookeeperContainer.mkdir(new File(BootIOUtils.path((String)SystemInfo.singleton().locations().work(), (String[])new String[]{"manager", "zookeeper"})));
        File configFile = File.createTempFile("zookeeper-", ".cfg", zookeeperPath);
        configFile.deleteOnExit();
        config.saveToFile(configFile);
        return configFile.getAbsolutePath();
    }

    private static void autoCreateZkDirectory(File directory) throws IOException {
        File dir = XapZookeeperContainer.mkdir(directory);
        if (!dir.exists()) {
            throw new IOException("Unable to create directory: " + dir);
        }
        if (!dir.canWrite()) {
            throw new IOException("Cannot write to directory: " + dir);
        }
        File dir_v2 = new File(directory, "version-2");
        if (!dir_v2.exists() && !dir_v2.mkdirs()) {
            throw new IOException("Unable to create directory: " + dir_v2);
        }
        if (!dir_v2.canWrite()) {
            throw new IOException("Cannot write to directory: " + dir_v2);
        }
    }

    private static void generateMyId(int myId, File dataDir) throws IOException {
        File idFile = new File(dataDir, "myid");
        BufferedWriter bw = new BufferedWriter(new FileWriter(idFile));
        bw.write(String.valueOf(myId));
        bw.close();
    }

    private static File mkdir(File dir) throws IOException {
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException("Failed to create " + dir);
        }
        return dir;
    }

    private static class ZookeeperStandaloneWrapper
    extends ZooKeeperServerMain
    implements ZookeeperWrapper {
        private ZookeeperStandaloneWrapper() {
        }

        @Override
        public void start(String configFile) throws Exception {
            this.initializeAndRun(new String[]{configFile});
        }

        @Override
        public void close() throws IOException {
            this.shutdown();
        }
    }

    private static class ZookeeperQuorumWrapper
    extends QuorumPeerMain
    implements ZookeeperWrapper {
        private ZookeeperQuorumWrapper() {
        }

        @Override
        public void start(String configFile) throws Exception {
            logger.info("Start ZooKeeper Quorum Peer");
            this.initializeAndRun(new String[]{configFile});
        }

        @Override
        public void close() throws IOException {
            if (this.quorumPeer != null) {
                logger.info("Close ZooKeeper Quorum Peer");
                this.quorumPeer.shutdown();
            }
        }
    }

    private static interface ZookeeperWrapper
    extends Closeable {
        public void start(String var1) throws Exception;
    }
}

