/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.zookeeper.leader_selector;

import com.gigaspaces.cluster.activeelection.LeaderSelectorHandler;
import com.gigaspaces.cluster.activeelection.LeaderSelectorHandlerConfig;
import com.gigaspaces.cluster.activeelection.SpaceMode;
import com.gigaspaces.cluster.activeelection.core.ActiveElectionException;
import com.gigaspaces.cluster.activeelection.core.ActiveElectionState;
import com.gigaspaces.internal.remoting.routing.clustered.LookupType;
import com.gigaspaces.internal.remoting.routing.clustered.RemoteOperationsExecutorProxy;
import com.gigaspaces.internal.remoting.routing.clustered.RemoteSpaceProxyLocator;
import com.gigaspaces.internal.server.space.recovery.direct_persistency.DirectPersistencyRecoveryException;
import com.gigaspaces.internal.utils.ObjectUtils;
import com.gigaspaces.internal.utils.SharedInstance;
import com.gigaspaces.internal.utils.concurrent.GSThreadFactory;
import java.io.Closeable;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import net.jini.core.entry.Entry;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.leader.Participant;
import org.apache.curator.utils.CloseableUtils;
import org.openspaces.zookeeper.ZNodePathFactory;
import org.openspaces.zookeeper.curator.CuratorClient;
import org.openspaces.zookeeper.curator.XapLeaderSelector;
import org.openspaces.zookeeper.curator.XapLeaderSelectorListener;

public class ZooKeeperBasedLeaderSelectorHandler
extends LeaderSelectorHandler {
    private static final String SEPARATOR = "~";
    private final Semaphore _primaryHold = new Semaphore(0);
    private final ExecutorService executorService = Executors.newSingleThreadExecutor((ThreadFactory)new GSThreadFactory("GS-LeaderSelectorExecutor", true));
    private static final int EXTRA_BACKUP_RESOLUTION_RETRIES = Integer.getInteger("com.gs.cluster.extra_backup_space_resolution_retries", 15);
    private SharedInstance<CuratorFramework> _sharedClient;
    private XapLeaderSelector _leaderSelector;
    private RemoteSpaceProxyLocator _proxyLocator;
    private volatile boolean _isTerminated;
    private final AtomicReference<Future<?>> reconnectTask = new AtomicReference();

    public void initialize(LeaderSelectorHandlerConfig config) throws Exception {
        super.initialize(config);
        this._proxyLocator = this._space.getSpaceProxy().getDirectProxy().getProxyRouter().getProxyLocator();
        this._sharedClient = CuratorClient.getOrCreate(this._space.getConfig());
        String path = ZNodePathFactory.space(this._space.getName(), "leader-election", this._space.getPartitionIdOneBased(), "participants");
        String id = this._space.getInstanceId() + SEPARATOR + this._space.getSpaceUuid();
        this._leaderSelector = new XapLeaderSelector((CuratorFramework)this._sharedClient.value(), path, id, new Adapter());
        this._leaderSelector.start();
    }

    public void terminate() {
        if (this._isTerminated) {
            return;
        }
        this._isTerminated = true;
        if (this._space.getDirectPersistencyRecoveryHelper() == null && this._space.isPrimary() && this._space.getZookeeperLastPrimaryHandler().isLastPrimary()) {
            try {
                this._space.getZookeeperLastPrimaryHandler().removeLastPrimaryRecord();
            }
            catch (IOException e) {
                this._logger.log(Level.WARNING, "Failed to remove last primary record from ZooKeeper.", e);
            }
        }
        this.cancelReconnectTask();
        try {
            CloseableUtils.closeQuietly((Closeable)this._leaderSelector);
        }
        catch (IllegalStateException e) {
            this._logger.log(Level.WARNING, "Caught while closing leader selector", e);
        }
        CuratorClient.release(this._sharedClient);
        try {
            this.executorService.shutdownNow();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setAsPrimarySpace() throws IOException, InterruptedException {
        Entry[] attributes = new Entry[]{new ActiveElectionState(ActiveElectionState.State.ACTIVE)};
        this._space.addLookupAttributes(attributes, 10000L);
        try {
            this.moveToPrimary();
            this._space.getZookeeperLastPrimaryHandler().setMeAsLastPrimary();
        }
        catch (DirectPersistencyRecoveryException e) {
            this._logger.log(Level.WARNING, "Caught while moving to primary", e);
            this._space.modifyLookupAttributes(attributes, new Entry[]{new ActiveElectionState(ActiveElectionState.State.NONE)});
        }
    }

    private void submitPrimaryReconnectTask(final XapLeaderSelector container, final boolean monitorLastPrimary) {
        this.cancelReconnectTask();
        this._logger.info("Submit reconnect task for Space, monitorLastPrimary=" + monitorLastPrimary);
        this.reconnectTask.set(this.executorService.submit(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                boolean shouldInterruptLeadership = monitorLastPrimary;
                while (true) {
                    Participant leader;
                    if ((leader = ZooKeeperBasedLeaderSelectorHandler.this.getLeader()) != null) {
                        ZooKeeperBasedLeaderSelectorHandler.this._logger.info("waiting for leader after reconnect, leader is: " + leader);
                        if (leader.getId().equals(ZooKeeperBasedLeaderSelectorHandler.this._leaderSelector.getId())) {
                            if (ZooKeeperBasedLeaderSelectorHandler.this._leaderSelector.isLeadershipSemaphoreTaken()) {
                                ZooKeeperBasedLeaderSelectorHandler.this._logger.info("Has Leadership -" + ZooKeeperBasedLeaderSelectorHandler.this.spaceParticipantToString());
                                return null;
                            }
                            ZooKeeperBasedLeaderSelectorHandler.this._logger.info("yet to acquire leadership");
                        } else if (ZooKeeperBasedLeaderSelectorHandler.this.isPrimary(leader)) {
                            ZooKeeperBasedLeaderSelectorHandler.this._logger.info("Identified another participant as leader - " + leader + " with mode=PRIMARY");
                            ZooKeeperBasedLeaderSelectorHandler.this.markUnusable("stopping Space - another space has been elected as primary [" + ZooKeeperBasedLeaderSelectorHandler.this.getInstanceId(leader) + "]");
                            return null;
                        }
                    }
                    if (shouldInterruptLeadership && ZooKeeperBasedLeaderSelectorHandler.this._space.getZookeeperLastPrimaryHandler().isLastPrimary()) {
                        ZooKeeperBasedLeaderSelectorHandler.this._logger.info("Space is listed as last primary, start reconnecting to path [" + ZooKeeperBasedLeaderSelectorHandler.this._leaderSelector.getPath() + "]");
                        container.interruptLeadership();
                        shouldInterruptLeadership = false;
                    }
                    Thread.sleep(1000L);
                }
            }
        }));
    }

    private void cancelReconnectTask() {
        Future task = this.reconnectTask.getAndSet(null);
        if (task != null && !task.isCancelled()) {
            task.cancel(true);
        }
    }

    public String getPrimaryMemberName() {
        return this._space.getServiceName();
    }

    public void select() throws RemoteException {
        block5: {
            try {
                Participant sameNameParticipant = this.findSameNameParticipantWithRetries();
                if (sameNameParticipant == null) {
                    Participant leader = this.waitForLeader();
                    this._logger.info("Found leader - " + leader);
                    if (leader.getId().equals(this._leaderSelector.getId())) {
                        this._primaryHold.acquire();
                        this._logger.info("Space instance [" + this._space.getServiceName() + "] has been elected as Primary");
                    } else {
                        this.moveToBackup();
                        this._logger.info("Space instance [" + this._space.getServiceName() + "] has been elected as Backup");
                    }
                    break block5;
                }
                String message = "Identified another participant with the same name for Space: " + this._space.getServiceName() + ", Id: " + this._leaderSelector.getId();
                this._logger.severe(message);
                throw new IllegalStateException(message);
            }
            catch (Exception e) {
                throw new RemoteException(this._space.getServiceName() + " failed leader election process", e);
            }
        }
    }

    private Participant waitForLeader() throws InterruptedException {
        while (true) {
            Participant leader;
            if ((leader = this.getLeader()) != null && this.isPrimary(leader)) {
                if (leader.getId().equals(this._leaderSelector.getId()) && this.getSpaceMode() != SpaceMode.PRIMARY) continue;
                return leader;
            }
            Thread.sleep(1000L);
        }
    }

    private Participant getLeader() {
        try {
            return this._leaderSelector.getLeaderIfExists();
        }
        catch (Exception e) {
            this._logger.warning("Failed while getting participants from ZooKeeper server: " + e);
            return null;
        }
    }

    private boolean isPrimary(Participant participant) {
        String memberSpaceUuid;
        long start = System.currentTimeMillis();
        String memberName = this.getMemberName(participant);
        RemoteOperationsExecutorProxy remoteOperationsExecutorProxy = this._proxyLocator.locateMember(memberName, memberSpaceUuid = this.getMemberSpaceUuid(participant), LookupType.TimeBasedLastIteration);
        if (remoteOperationsExecutorProxy != null) {
            try {
                if (remoteOperationsExecutorProxy.isActive()) {
                    this._logger.info("isPrimary(" + memberName + ") returned true [duration= " + (System.currentTimeMillis() - start) + "ms]");
                    return true;
                }
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        this._logger.info("isPrimary(" + memberName + ") returned false [duration= " + (System.currentTimeMillis() - start) + "ms]");
        return false;
    }

    public boolean isConnected() {
        return ((CuratorFramework)this._sharedClient.value()).getZookeeperClient().isConnected();
    }

    private String getInstanceId(Participant participant) {
        return this.getToken(participant, 0);
    }

    private String getMemberName(Participant participant) {
        String instanceId = this.getInstanceId(participant);
        return this._space.getName() + "_container" + instanceId + ":" + this._space.getName();
    }

    private String getMemberSpaceUuid(Participant participant) {
        return this.getToken(participant, 1);
    }

    private String getToken(Participant participant, int i) {
        String id = participant.getId();
        String[] tokens = id.split(SEPARATOR);
        if (i < tokens.length) {
            return tokens[i];
        }
        this._logger.warning("Cannot get token #" + i + " from [" + id + "] using separator [" + SEPARATOR + "]");
        return null;
    }

    private boolean isSuspended() {
        return this._space.getQuiesceHandler().isSuspended();
    }

    private void suspend(String description) {
        if (!this.isSuspended()) {
            this._space.getQuiesceHandler().suspend(description);
        }
    }

    private void unSuspend(String description) {
        if (this.isSuspended()) {
            this._logger.info(description);
            this._space.getQuiesceHandler().unsuspend();
        }
    }

    private void submitBackupReconnectTask() {
        this.cancelReconnectTask();
        this._logger.info("Submit reconnect task for Backup Space");
        this.reconnectTask.set(this.executorService.submit(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                while (true) {
                    ZooKeeperBasedLeaderSelectorHandler.this._logger.info("waiting for leader to be found");
                    Participant leader = ZooKeeperBasedLeaderSelectorHandler.this.waitForLeader();
                    if (ZooKeeperBasedLeaderSelectorHandler.this._leaderSelector.hasLeadership()) {
                        ZooKeeperBasedLeaderSelectorHandler.this._logger.info("Has Leadership -" + ZooKeeperBasedLeaderSelectorHandler.this.spaceParticipantToString());
                        return null;
                    }
                    ZooKeeperBasedLeaderSelectorHandler.this._logger.info("checking for extra backup instance");
                    Participant sameNameParticipant = ZooKeeperBasedLeaderSelectorHandler.this.findSameNameParticipantWithRetries();
                    if (sameNameParticipant == null) {
                        ZooKeeperBasedLeaderSelectorHandler.this._logger.info("no extra backup instance was found");
                        return null;
                    }
                    if (ZooKeeperBasedLeaderSelectorHandler.this.pingParticipant(sameNameParticipant)) {
                        ZooKeeperBasedLeaderSelectorHandler.this._logger.info("extra backup instance was found and is reachable");
                        ZooKeeperBasedLeaderSelectorHandler.this.markUnusable("stopping Space - found extra backup [" + sameNameParticipant.getId() + "]");
                        return null;
                    }
                    ZooKeeperBasedLeaderSelectorHandler.this._logger.info("extra backup instance was found but is not reachable, waiting for consistent state");
                    Thread.sleep(1000L);
                }
            }
        }));
    }

    private Participant findSameNameParticipantWithRetries() throws InterruptedException {
        Participant match = null;
        long tickTime = 1000L;
        long maxSessionTimeout = this._space.getConfig().getZookeeperSessionTimeout();
        boolean verboseOutput = true;
        while (true) {
            Participant sameNameParticipant;
            if ((sameNameParticipant = this.findSameNameParticipant(verboseOutput)) == null) {
                if (match != null) {
                    this._logger.info("Identified session expiration of " + match + " - took: " + ((long)this._space.getConfig().getZookeeperSessionTimeout() - maxSessionTimeout) + " ms");
                }
                return null;
            }
            if (maxSessionTimeout <= 0L && sameNameParticipant.equals((Object)match)) {
                return match;
            }
            match = sameNameParticipant;
            if (verboseOutput) {
                this._logger.info("Waiting in intervals of 1000 ms for " + match + " session to expire in: " + maxSessionTimeout + " ms)");
            }
            Thread.sleep(1000L);
            maxSessionTimeout -= 1000L;
            verboseOutput = false;
        }
    }

    private Participant findSameNameParticipant(boolean verboseOutput) {
        try {
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.fine("Searching for a participant with the same name prefix as " + this._leaderSelector.getId());
            }
            Collection participants = this._leaderSelector.getLeaderSelector().getParticipants();
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.log(Level.FINE, "Participants: " + participants);
            }
            for (Participant p : participants) {
                if (!p.getId().startsWith(this._space.getInstanceId() + SEPARATOR) || p.getId().equals(this._leaderSelector.getId())) continue;
                if (verboseOutput || this._logger.isLoggable(Level.FINE)) {
                    this._logger.info("Found matching " + p + " with the same name prefix as " + this._leaderSelector.getId());
                }
                return p;
            }
        }
        catch (Exception e) {
            this._logger.warning("Failed while getting participants from ZooKeeper server: " + e);
        }
        return null;
    }

    private boolean pingParticipant(Participant participant) {
        String memberSpaceUuid;
        String memberName = this.getMemberName(participant);
        RemoteOperationsExecutorProxy remoteOperationsExecutorProxy = this._proxyLocator.locateMember(memberName, memberSpaceUuid = this.getMemberSpaceUuid(participant), LookupType.TimeBasedLastIteration);
        if (remoteOperationsExecutorProxy != null) {
            try {
                remoteOperationsExecutorProxy.isActive();
                return true;
            }
            catch (RemoteException e) {
                return false;
            }
        }
        return false;
    }

    private void markUnusable(String description) {
        this._logger.info(description);
        ActiveElectionException lastError = new ActiveElectionException(description);
        this.setLastError((Throwable)lastError);
        this.moveToUnusable();
    }

    private String spaceParticipantToString() {
        return this._leaderSelector.participantToString() + " Space{mode=" + this.getSpaceMode() + ", suspended=" + this.isSuspended() + "}";
    }

    private class Adapter
    extends XapLeaderSelectorListener {
        private Adapter() {
        }

        @Override
        public String getLoggerSuffix() {
            return "space." + ZooKeeperBasedLeaderSelectorHandler.this._space.getServiceName();
        }

        @Override
        public void onConnectionSuspended(XapLeaderSelector container, CuratorFramework client) {
            Long currentSessionId = container.getSessionId(client);
            ZooKeeperBasedLeaderSelectorHandler.this._logger.warning("Connection to ZooKeeper was suspended - Session{id='" + this.toHex(currentSessionId) + "'}");
            ZooKeeperBasedLeaderSelectorHandler.this.cancelReconnectTask();
            if (ZooKeeperBasedLeaderSelectorHandler.this.isPrimary()) {
                ZooKeeperBasedLeaderSelectorHandler.this.suspend("Loss of connection to ZooKeeper. Leader suspended until the connection is re-established");
            } else {
                container.interruptLeadership();
            }
        }

        @Override
        public void onConnectionLost(XapLeaderSelector container, CuratorFramework client) {
            Long currentSessionId = container.getSessionId(client);
            ZooKeeperBasedLeaderSelectorHandler.this._logger.severe("Lost connection to ZooKeeper - Session{id='" + this.toHex(currentSessionId) + "'}");
            if (!ZooKeeperBasedLeaderSelectorHandler.this.isSuspended()) {
                if (ZooKeeperBasedLeaderSelectorHandler.this._logger.isLoggable(Level.FINE)) {
                    ZooKeeperBasedLeaderSelectorHandler.this._logger.fine("Connection lost, interrupting leadership (suspended=false)");
                }
                container.interruptLeadership();
            }
        }

        @Override
        public void onConnectionResumed(XapLeaderSelector container, CuratorFramework client) {
            super.onConnectionResumed(container, client);
            Long currentSessionId = container.getSessionId(client);
            ZooKeeperBasedLeaderSelectorHandler.this._logger.info("Connection to ZooKeeper resumed - Session{id='" + this.toHex(currentSessionId) + "'}");
            if (ZooKeeperBasedLeaderSelectorHandler.this.isSuspended()) {
                Long leadershipSessionId = container.getLeadershipSessionId();
                if (ObjectUtils.equals((Object)currentSessionId, (Object)leadershipSessionId)) {
                    ZooKeeperBasedLeaderSelectorHandler.this.unSuspend("Connection to ZooKeeper was resumed within the same session - Session{id='" + this.toHex(currentSessionId) + "'}");
                } else {
                    ZooKeeperBasedLeaderSelectorHandler.this._logger.log(Level.WARNING, "Illegal state - connection to ZooKeeper resumed with Session{id='" + this.toHex(currentSessionId) + "'}, but leadership is held by Session{id='" + this.toHex(leadershipSessionId) + "'}");
                }
            }
        }

        @Override
        public void onReconnected(XapLeaderSelector container, CuratorFramework client) {
            super.onReconnected(container, client);
            Long currentSessionId = container.getSessionId(client);
            ZooKeeperBasedLeaderSelectorHandler.this._logger.info("Connection to ZooKeeper was reestablished - Session{id='" + this.toHex(currentSessionId) + "'}");
            ZooKeeperBasedLeaderSelectorHandler.this._logger.info("Reconnect -" + ZooKeeperBasedLeaderSelectorHandler.this.spaceParticipantToString());
            if (ZooKeeperBasedLeaderSelectorHandler.this.isSuspended()) {
                if (ZooKeeperBasedLeaderSelectorHandler.this._space.getZookeeperLastPrimaryHandler().isLastPrimary()) {
                    ZooKeeperBasedLeaderSelectorHandler.this._logger.info("Space is last primary, start reconnecting to path [" + ZooKeeperBasedLeaderSelectorHandler.this._leaderSelector.getPath() + "]");
                    container.interruptLeadership();
                    ZooKeeperBasedLeaderSelectorHandler.this.submitPrimaryReconnectTask(container, false);
                } else {
                    ZooKeeperBasedLeaderSelectorHandler.this._logger.info("Space is not last primary, staying in suspend state");
                    ZooKeeperBasedLeaderSelectorHandler.this.submitPrimaryReconnectTask(container, true);
                }
            } else {
                ZooKeeperBasedLeaderSelectorHandler.this.submitBackupReconnectTask();
            }
        }

        @Override
        public void onLeadershipOffered(XapLeaderSelector container) throws Exception {
            super.onLeadershipOffered(container);
            ZooKeeperBasedLeaderSelectorHandler.this._logger.info("Leadership is being offered -" + ZooKeeperBasedLeaderSelectorHandler.this.spaceParticipantToString());
            if (ZooKeeperBasedLeaderSelectorHandler.this.isPrimary()) {
                ZooKeeperBasedLeaderSelectorHandler.this.unSuspend("A suspended or lost connection to ZooKeeper has been re-established");
            } else {
                ZooKeeperBasedLeaderSelectorHandler.this.setAsPrimarySpace();
                ZooKeeperBasedLeaderSelectorHandler.this._primaryHold.release();
            }
            ZooKeeperBasedLeaderSelectorHandler.this._logger.info("Leadership taken -" + ZooKeeperBasedLeaderSelectorHandler.this.spaceParticipantToString());
        }

        @Override
        public void onLeadershipLost(XapLeaderSelector container) {
            super.onLeadershipLost(container);
            ZooKeeperBasedLeaderSelectorHandler.this.suspend("ZooKeeper session has expired, instance is no longer the Leader");
        }
    }
}

